/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Element;
import nu.xom.NamespaceException;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Verifier;

public class Attribute
extends Node {
    private String localName;
    private String prefix;
    private String URI;
    private String value = "";
    private Type type;

    public Attribute(String localName, String value) {
        this(localName, "", value, Type.UNDECLARED);
    }

    public Attribute(String localName, String value, Type type) {
        this(localName, "", value, type);
    }

    public Attribute(String name, String URI2, String value) {
        this(name, URI2, value, Type.UNDECLARED);
    }

    public Attribute(String name, String URI2, String value, Type type) {
        this.prefix = "";
        String localName = name;
        if (name.indexOf(58) >= 0) {
            this.prefix = name.substring(0, name.indexOf(58));
            localName = name.substring(name.indexOf(58) + 1);
        }
        this.setNamespace(this.prefix, URI2);
        this.setLocalName(localName);
        this.setValue(value);
        this.setType(type);
    }

    public Attribute(Attribute attribute) {
        this(attribute.getQualifiedName(), attribute.URI, attribute.value, attribute.type);
    }

    private Attribute() {
    }

    static Attribute build(String name, String URI2, String value, Type type) {
        Attribute result = new Attribute();
        String prefix = "";
        String localName = name;
        if (name.indexOf(58) >= 0) {
            prefix = name.substring(0, name.indexOf(58));
            localName = name.substring(name.indexOf(58) + 1);
        }
        result.localName = localName;
        result.prefix = prefix;
        result.type = type;
        result.URI = URI2;
        result.value = value;
        return result;
    }

    public final Type getType() {
        return this.type;
    }

    public final void setType(Type type) {
        this.checkType(type);
        this.type = type;
    }

    protected void checkType(Type type) {
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        if ("xml".equals(this.prefix) && "base".equals(this.localName)) {
            Verifier.checkIRI(value);
        } else {
            Verifier.checkCharacterData(value);
        }
        this.checkValue(value);
        this.value = value;
    }

    protected void checkValue(String value) {
    }

    public final String getLocalName() {
        return this.localName;
    }

    public final void setLocalName(String localName) {
        Verifier.checkAttributeLocalName(localName);
        this.checkLocalName(localName);
        this.localName = localName;
    }

    public final String getQualifiedName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public final String getNamespaceURI() {
        return this.URI;
    }

    public final String getNamespacePrefix() {
        return this.prefix;
    }

    protected void checkLocalName(String localName) {
    }

    public final void setNamespace(String prefix, String URI2) {
        Element element;
        String currentURI;
        if (URI2 == null) {
            URI2 = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equals("xmlns")) {
            throw new NamespaceException("Attribute objects are not used to represent  namespace declarations");
        }
        if (prefix.equals("xml") && !URI2.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new NamespaceException("Wrong namespace URI for xml prefix: " + URI2);
        }
        if (prefix.length() == 0) {
            if (URI2.length() == 0) {
                this.prefix = "";
                this.URI = "";
                return;
            }
            throw new NamespaceException("Attributes cannot be in a default namespace.");
        }
        if (URI2.length() == 0) {
            throw new NamespaceException("Attribute prefixes must be declared.");
        }
        ParentNode parent = this.getParent();
        if (parent != null && (currentURI = (element = (Element)parent).getLocalNamespaceURI(prefix)) != null && !currentURI.equals(URI2)) {
            throw new NamespaceException("New prefix " + prefix + "conflicts with existing namespace declaration");
        }
        Verifier.checkAbsoluteURIReference(URI2);
        Verifier.checkNCName(prefix);
        this.checkNamespace(prefix, URI2);
        this.URI = URI2;
        this.prefix = prefix;
    }

    protected void checkNamespace(String prefix, String URI2) {
    }

    public final boolean hasChildren() {
        return false;
    }

    public final Node getChild(int position) {
        throw new IndexOutOfBoundsException("Attributes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public Node copy() {
        return new Attribute(this);
    }

    public final String toXML() {
        return this.getQualifiedName() + "=\"" + Attribute.escapeText(this.value) + "\"";
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.getQualifiedName() + "=\"" + this.getValue() + "\"]";
    }

    private static String escapeText(String s) {
        StringBuffer result = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            result.append(Attribute.escapeChar(s.charAt(i)));
        }
        return result.toString();
    }

    private static String escapeChar(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '\n': {
                return "&#x0A;";
            }
            case '\r': {
                return "&#x0D;";
            }
            case '\t': {
                return "&#x09;";
            }
        }
        return String.valueOf(c);
    }

    boolean isAttribute() {
        return true;
    }

    public static final class Type {
        public static final Type CDATA = new Type(1);
        public static final Type ID = new Type(2);
        public static final Type IDREF = new Type(3);
        public static final Type IDREFS = new Type(4);
        public static final Type NMTOKEN = new Type(5);
        public static final Type NMTOKENS = new Type(6);
        public static final Type NOTATION = new Type(7);
        public static final Type ENTITY = new Type(8);
        public static final Type ENTITIES = new Type(9);
        public static final Type ENUMERATION = new Type(10);
        public static final Type UNDECLARED = new Type(0);
        private int type;

        public String toXML() {
            switch (this.type) {
                case 0: {
                    return "UNDECLARED";
                }
                case 1: {
                    return "CDATA";
                }
                case 2: {
                    return "ID";
                }
                case 3: {
                    return "IDREF";
                }
                case 4: {
                    return "IDREFS";
                }
                case 5: {
                    return "NMTOKEN";
                }
                case 6: {
                    return "NMTOKENS";
                }
                case 7: {
                    return "NOTATION";
                }
                case 8: {
                    return "ENTITY";
                }
                case 9: {
                    return "ENTITIES";
                }
                case 10: {
                    return "ENUMERATION";
                }
            }
            throw new RuntimeException("Bug in XOM: unexpected attribute type: " + this.type);
        }

        private Type(int type) {
            this.type = type;
        }

        public int hashCode() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.hashCode() != o.hashCode()) {
                return false;
            }
            if (!o.getClass().getName().equals("Attribute.Type")) {
                return false;
            }
            return o.getClass().getPackage().getName().equals("nu.xom");
        }

        public String toString() {
            StringBuffer result = new StringBuffer("[Attribute.Type: ");
            result.append(this.toXML());
            result.append("]");
            return result.toString();
        }
    }
}

