/*
 * Decompiled with CFR 0.152.
 */
package bsbMain.settings;

import bsbEdit.EditHandler;
import bsbException.External;
import bsbException.Panic;
import bsbMain.Globals;
import bsbMain.settings.AppSettings;
import bsbMain.settings.Layout;
import bsbMain.settings.Path;
import bsbMain.settings.PathHist;
import bsbMain.settings.Settings;
import bsbMain.settings.SettingsFactory;
import bsbUtil.BsbList;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.ListIterator;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Serializer;

public class SettingsExt
extends Settings {
    private Builder builder = null;
    private Document doc = null;
    private File curFile = null;
    private File docRoot = null;

    public SettingsExt() {
    }

    public SettingsExt(SettingsExt settingsExt) {
        this.builder = settingsExt.builder;
        this.doc = settingsExt.doc;
        this.curFile = settingsExt.curFile;
        this.docRoot = settingsExt.docRoot;
    }

    public static SettingsExt read(File file) {
        SettingsExt settingsExt = null;
        if (file == null) {
            throw new Panic("No .ini file given");
        }
        if (!file.exists()) {
            settingsExt = new SettingsExt();
            settingsExt.defaultSettings(file);
            SettingsFactory settingsFactory = new SettingsFactory();
            settingsFactory.register("settings", "bsbMain.settings.SettingsExt");
            settingsExt.builder = new Builder(Globals.validating, settingsFactory);
            settingsExt.doc = new Document(settingsExt);
            settingsExt.curFile = file;
            settingsExt.docRoot = file.getParentFile();
            settingsExt.write(file);
            try {
                file = file.getCanonicalFile();
            }
            catch (Exception exception) {
                new External(exception).handle();
                return null;
            }
            return settingsExt;
        }
        if (!file.isFile()) {
            throw new Panic("Invalid .ini file:\u00a7\u00a7<" + file.getAbsolutePath() + ">");
        }
        try {
            try {
                file = file.getCanonicalFile();
            }
            catch (Exception exception) {
                new External(exception).handle();
                return null;
            }
            SettingsFactory settingsFactory = new SettingsFactory();
            settingsFactory.register("settings", "bsbMain.settings.SettingsExt");
            Builder builder = new Builder(Globals.validating, settingsFactory);
            Document document = builder.build(file);
            settingsExt = (SettingsExt)document.getRootElement();
            settingsExt.builder = builder;
            settingsExt.doc = document;
            settingsExt.curFile = file;
            settingsExt.docRoot = file.getParentFile();
            return settingsExt;
        }
        catch (Exception exception) {
            throw new External("Can't read INI-file:\u00a7\u00a7" + file.getPath(), exception);
        }
    }

    public SettingsExt restore() {
        return SettingsExt.read(this.curFile);
    }

    public void write(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Serializer serializer = new Serializer(fileOutputStream);
            serializer.setIndent(2);
            serializer.setMaxLength(0);
            serializer.write(this.doc);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            new External(exception).handle();
        }
        this.curFile = file;
    }

    public void write() {
        this.write(this.curFile);
    }

    public File getCurFile() {
        return this.curFile;
    }

    public File getDocRoot() {
        return this.docRoot;
    }

    public File getDoc(String string) {
        File file = new File(Globals.normalize(string));
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.docRoot, file.getPath());
    }

    public boolean isValid(PathHist pathHist) {
        return this.getDoc(pathHist.getPath()).isFile();
    }

    public boolean isAbsolute(PathHist pathHist) {
        return new File(pathHist.getPath()).isAbsolute();
    }

    public List getAll(String string) {
        BsbList bsbList = this.getPath();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Path path = (Path)listIterator.next();
            if (!string.equals(path.getName())) continue;
            return path.getPathHist();
        }
        return null;
    }

    public File getCurrent(String string) {
        if (string == null) {
            return this.curFile;
        }
        BsbList bsbList = this.getPath();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Path path = (Path)listIterator.next();
            if (!string.equals(path.getName())) continue;
            BsbList bsbList2 = path.getPathHist();
            if (bsbList2.size() > 0) {
                return this.getDoc(((PathHist)bsbList2.get(0)).getPath());
            }
            return null;
        }
        return null;
    }

    public void changeCurrent(String string, String string2) {
        BsbList bsbList = this.getPath();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            PathHist pathHist;
            Path path = (Path)listIterator.next();
            if (!string.equals(path.getName())) continue;
            BsbList bsbList2 = path.getPathHist();
            ListIterator listIterator2 = bsbList2.listIterator();
            while (listIterator2.hasNext()) {
                pathHist = (PathHist)listIterator2.next();
                String string3 = pathHist.getPath();
                if (!string3.equals(string2)) continue;
                listIterator2.remove();
            }
            pathHist = new PathHist();
            pathHist.setPath(string2);
            bsbList2.add(0, pathHist);
            return;
        }
    }

    public void switchConfigDef(File file) {
        String string = file.getPath();
        if (!file.isAbsolute()) {
            Object object;
            File file2 = new File(".").getAbsoluteFile();
            file = new File(file2, string);
            if (!file.exists()) {
                object = this.docRoot;
                file = new File((File)object, string);
            }
            if (!file.exists()) {
                String string2;
                File file3;
                object = this.getAll("ConfigDef");
                ListIterator listIterator = object.listIterator();
                while (listIterator.hasNext() && !(file = new File(file3 = new File(this.docRoot, string2 = ((PathHist)listIterator.next()).getPath()).getParentFile(), string)).exists()) {
                }
            }
        }
        if (!file.exists()) {
            throw new Panic("-cfg <" + string + ">\u00a7\u00a7invalid ConfigDef");
        }
        string = EditHandler.relativePath(this.docRoot, file.getPath());
        this.changeCurrent("ConfigDef", string);
    }

    private void defaultSettings(File file) {
        this.setName(file.getName());
        this.setDescription("Busy Bee Default Settings");
        BsbList bsbList = this.getPath();
        Path path = new Path();
        bsbList.add(path);
        path.setName("ConfigSet");
        BsbList bsbList2 = path.getPathHist();
        PathHist pathHist = new PathHist();
        bsbList2.add(pathHist);
        File file2 = new File("Docs/ConfigSets/configSet.xml");
        pathHist.setPath(file2.getAbsolutePath());
        path = new Path();
        bsbList.add(path);
        path.setName("ConfigDef");
        bsbList2 = path.getPathHist();
        pathHist = new PathHist();
        bsbList2.add(pathHist);
        file2 = new File("Docs/ConfigDefs/configDef.xml");
        pathHist.setPath(file2.getAbsolutePath());
        path = new Path();
        bsbList.add(path);
        path.setName("PathSet");
        bsbList2 = path.getPathHist();
        pathHist = new PathHist();
        bsbList2.add(pathHist);
        file2 = new File("Docs/PathSets/pathSet.xml");
        pathHist.setPath(file2.getAbsolutePath());
        path = new Path();
        bsbList.add(path);
        path.setName("OptionSet");
        bsbList2 = path.getPathHist();
        pathHist = new PathHist();
        bsbList2.add(pathHist);
        file2 = new File("Docs/OptionSets/optionSet.xml");
        pathHist.setPath(file2.getAbsolutePath());
        path = new Path();
        bsbList.add(path);
        path.setName("ToolSet");
        bsbList2 = path.getPathHist();
        pathHist = new PathHist();
        bsbList2.add(pathHist);
        file2 = new File("Docs/ToolSets/toolSet.xml");
        pathHist.setPath(file2.getAbsolutePath());
        path = new Path();
        bsbList.add(path);
        path.setName("TargetSet");
        bsbList2 = path.getPathHist();
        pathHist = new PathHist();
        bsbList2.add(pathHist);
        file2 = new File("Docs/TargetSets/targetSet.xml");
        pathHist.setPath(file2.getAbsolutePath());
        path = new Path();
        bsbList.add(path);
        path.setName("SourceSet");
        bsbList2 = path.getPathHist();
        pathHist = new PathHist();
        bsbList2.add(pathHist);
        file2 = new File("Docs/SourceSets/sources_1.xml");
        pathHist.setPath(file2.getAbsolutePath());
        this.setAppSettings(new AppSettings());
        this.getAppSettings().setLayout(new Layout());
    }
}

