/*
 * Decompiled with CFR 0.152.
 */
package bsbMain;

import bsbDocCls.Sources;
import bsbDocExt.ConfigDefExt;
import bsbDocExt.ConfigSetExt;
import bsbDocExt.OptionSetExt;
import bsbDocExt.PathSetExt;
import bsbDocExt.SourceSetExt;
import bsbDocExt.TargetSetExt;
import bsbDocExt.ToolSetExt;
import bsbException.BsbException;
import bsbException.Problem;
import bsbMain.Globals;
import bsbMain.settings.SettingsExt;
import java.io.File;

public class ExecEnv {
    public SettingsExt settings = null;
    public ConfigSetExt configSet = null;
    public ConfigDefExt configDef = null;
    public OptionSetExt optionSet = null;
    public PathSetExt pathSet = null;
    public ToolSetExt toolSet = null;
    public SourceSetExt sourceSet = null;
    public TargetSetExt targetSet = null;
    public String makefileName = null;
    public File curSettings = null;
    public File makefileLoc = null;

    public ExecEnv(File file) {
        this(file, null);
    }

    public ExecEnv(File file, File file2) {
        if (file != null) {
            block8: {
                try {
                    this.settings = SettingsExt.read(file);
                }
                catch (BsbException bsbException) {
                    if (file2 != null) break block8;
                    throw bsbException;
                }
            }
            this.curSettings = file;
        }
        if (file2 != null) {
            this.configDef = this.loadConfigDef(file2);
            String string = this.configDef.getReference();
            if (string != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
                File file3 = new File(string);
                if (!file3.isAbsolute()) {
                    File file4 = file2.getParentFile();
                    file3 = new File(file4, string);
                }
                if (!file3.exists()) {
                    new Problem("invalid reference <" + string + ">\u00a7\u00a7in ConfigDef <" + file2 + ">").handle();
                } else {
                    this.settings = SettingsExt.read(file3);
                    this.curSettings = file3;
                }
            }
            this.settings.switchConfigDef(file2);
        }
        this.defineMakefile(file2);
    }

    public void defineMakefile(File file) {
        this.makefileLoc = new File(".");
        this.makefileName = file != null ? file.getName() : this.curSettings.getName();
        int n = this.makefileName.lastIndexOf(".");
        if (n > 0) {
            this.makefileName = this.makefileName.substring(0, n);
        }
        this.makefileName = this.makefileLoc.getAbsolutePath() + File.separator + this.makefileName + ".mak";
    }

    public void loadAll() {
        this.loadConfigSet();
        this.loadConfigDef();
        this.loadOptionSet();
        this.loadPathSet();
        this.loadTargetSet();
        this.loadToolSet();
    }

    public boolean loadConfigSet() {
        File file = this.settings.getCurrent("ConfigSet");
        if (file == null) {
            return false;
        }
        this.configSet = this.loadConfigSet(file);
        return this.configSet != null;
    }

    public boolean loadConfigDef() {
        File file = this.settings.getCurrent("ConfigDef");
        if (file == null) {
            return false;
        }
        this.configDef = this.loadConfigDef(file);
        return this.configDef != null;
    }

    public boolean loadOptionSet() {
        File file = this.settings.getCurrent("OptionSet");
        if (file == null) {
            return false;
        }
        this.optionSet = this.loadOptionSet(file);
        return this.optionSet != null;
    }

    public boolean loadPathSet() {
        File file = this.settings.getCurrent("PathSet");
        if (file == null) {
            return false;
        }
        this.pathSet = this.loadPathSet(file);
        return this.pathSet != null;
    }

    public boolean loadTargetSet() {
        File file = this.settings.getCurrent("TargetSet");
        if (file == null) {
            return false;
        }
        this.targetSet = this.loadTargetSet(file);
        return this.targetSet != null;
    }

    public boolean loadToolSet() {
        File file = this.settings.getCurrent("ToolSet");
        if (file == null) {
            return false;
        }
        this.toolSet = this.loadToolSet(file);
        return this.toolSet != null;
    }

    public ConfigSetExt loadConfigSet(File file) {
        return ConfigSetExt.read(this, file);
    }

    public ConfigDefExt loadConfigDef(File file) {
        return ConfigDefExt.read(this, file);
    }

    public OptionSetExt loadOptionSet(File file) {
        return OptionSetExt.read(this, file);
    }

    public PathSetExt loadPathSet(File file) {
        return PathSetExt.read(this, file);
    }

    public TargetSetExt loadTargetSet(File file) {
        return TargetSetExt.read(this, file);
    }

    public ToolSetExt loadToolSet(File file) {
        return ToolSetExt.read(this, file);
    }

    public SourceSetExt loadSourceSet(File file) {
        return SourceSetExt.read(this, file);
    }

    public boolean loadSourceSet(Sources sources) {
        String string = sources.getSourceSet();
        File file = new File(string);
        if (file.isAbsolute()) {
            this.sourceSet = SourceSetExt.read(this, file);
            return this.sourceSet != null;
        }
        String string2 = this.targetSet.getCurFile().getParent();
        String string3 = sources.getPathRef();
        if (!Globals.isEmpty(string3)) {
            string2 = this.pathSet.getCurFile().getParent() + File.separator + this.pathSet.getPath(string3);
        }
        file = new File(string2, string);
        if (new File(string2, string.replaceAll("\\[.*\\]", "")).exists()) {
            this.sourceSet = SourceSetExt.read(this, file);
            return this.sourceSet != null;
        }
        this.loadSourceSet(string);
        return this.sourceSet != null;
    }

    public boolean loadSourceSet(String string) {
        File file = this.settings.getCurrent("SourceSet");
        if (file == null) {
            return false;
        }
        if (file.isFile()) {
            file = file.getParentFile();
        }
        this.sourceSet = SourceSetExt.read(this, new File(file, string + ".xml"));
        return this.sourceSet != null;
    }

    public File getSourceSetDir() {
        File file = this.settings.getCurrent("SourceSet");
        if (file == null) {
            return null;
        }
        if (file.isFile()) {
            file = file.getParentFile();
        }
        return file;
    }
}

