/*
 * Decompiled with CFR 0.152.
 */
package bsbGenerator;

import bsbDocCls.Args;
import bsbDocCls.Command;
import bsbDocCls.Sources;
import bsbDocCls.Target;
import bsbDocCls.TargetDef;
import bsbDocCls.TargetPath;
import bsbDocExt.SourceSetExt;
import bsbException.External;
import bsbException.Panic;
import bsbException.Problem;
import bsbMain.ExecEnv;
import bsbMain.Globals;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TgtEvaluator {
    public static Vector realizedTargets;
    public static Vector realizedCleanRules;
    public static Vector targetFolders;
    public static Vector targetFiles;
    public static Vector sourceFiles;
    public static Hashtable targetTypesList;
    public static Hashtable targetNamesList;
    public String targetType;
    public String autoName = null;
    private Vector files = new Vector();
    private static final String NL;
    private Vector sourceList = new Vector(10, 10);
    private Vector destList = new Vector(10, 10);
    private Vector destInlines = new Vector(10, 10);
    private Vector destReferences = new Vector(10, 10);
    private String destFile;
    private ExecEnv execEnv;
    private PrintStream ps;
    private Target target;
    private TargetDef targetDef;
    private Hashtable sourceSets = new Hashtable();
    private SourceSetExt sourceSet;
    private List commands;
    private Command command;
    private Args args;
    private int toolMode;
    private int multiX = -1;
    private boolean intoCmdFile;
    private String sourceType;
    private String sourceLocalFlags = "";
    private String targetDir;
    private String executable;
    private String toolName;
    private String commandName;
    private String commandModifier;
    private String commandDesc;
    private String cmdFileGen = "";
    private String cmdFileTmp = "";
    private static Pattern patSrcSet;

    public TgtEvaluator(ExecEnv execEnv, Target target, PrintStream printStream) {
        Object object;
        ListIterator listIterator;
        Object object2;
        Object object3;
        String string = target.getName();
        String string2 = target.getAutoNamed();
        target.setAutoNamed(string);
        if (!Globals.isEmpty(string2)) {
            this.autoName = execEnv.optionSet.autoName(string, string2);
            target.setName(this.autoName);
        }
        String string3 = "";
        if (realizedTargets.contains(target)) {
            printStream = this.getNullPs();
        } else {
            realizedTargets.add(target);
            string3 = string3 + target.getName() + ":";
        }
        System.out.println("Target " + target.getName() + ".");
        Target target2 = execEnv.targetSet.selected(target);
        List list = execEnv.targetSet.validTargetRefs(target);
        ListIterator listIterator2 = list.listIterator();
        while (listIterator2.hasNext()) {
            object3 = (String)listIterator2.next();
            object2 = execEnv.targetSet.named((String)object3);
            if (realizedTargets.contains(object2)) continue;
            new TgtEvaluator(execEnv, (Target)object2, printStream);
        }
        object3 = execEnv.targetSet.validTargetDefs(target);
        object2 = object3.listIterator();
        while (object2.hasNext()) {
            listIterator = (TargetDef)object2.next();
            object = new TgtEvaluator(execEnv, target, (TargetDef)((Object)listIterator), printStream);
            this.files.addAll(((TgtEvaluator)object).files);
            this.destList.addAll(((TgtEvaluator)object).destList);
            this.destInlines.addAll(((TgtEvaluator)object).destInlines);
            this.destReferences.addAll(((TgtEvaluator)object).destReferences);
            this.targetType = ((TgtEvaluator)object).targetType;
        }
        execEnv.targetSet.selected(target2);
        if (string3.length() > 0 && this.destList.size() > 0) {
            printStream.print(string3);
            listIterator = this.destList.listIterator();
            while (listIterator.hasNext()) {
                printStream.print(" |" + NL + "        " + listIterator.next());
            }
            printStream.println(NL);
            object = "clean_" + string3;
            realizedCleanRules.add(((String)object).substring(0, ((String)object).length() - 1));
            printStream.print((String)object);
            if (Globals.rigidClean) {
                listIterator = this.destReferences.listIterator();
                while (listIterator.hasNext()) {
                    printStream.print(" |" + NL + "        " + "clean_" + listIterator.next());
                }
            }
            printStream.println();
            listIterator = this.destList.listIterator();
            while (listIterator.hasNext()) {
                printStream.println("\t$(BSB_REMOVE) " + listIterator.next());
            }
            listIterator = this.destInlines.listIterator();
            while (listIterator.hasNext()) {
                printStream.println("\t$(BSB_REMOVE) " + listIterator.next());
            }
            printStream.println(NL + NL);
        }
        target.setName(string);
        target.setAutoNamed(string2);
    }

    public TgtEvaluator(ExecEnv execEnv, Target target, TargetDef targetDef, PrintStream printStream) {
        TargetPath targetPath = execEnv.targetSet.validTargetPath(target, targetDef);
        this.execEnv = execEnv;
        this.ps = printStream;
        this.target = target;
        this.targetDef = targetDef;
        this.targetType = targetDef.getType();
        this.targetDir = this.execEnv.pathSet.fullPath(targetPath.getPathRef(), targetPath.getPath());
        if (!targetFolders.contains(this.targetDir)) {
            targetFolders.add(this.targetDir);
        }
        if (this.targetDir.length() > 0) {
            this.targetDir = this.targetDir + File.separator;
        }
        this.toolName = this.targetDef.getTool();
        if (!Globals.isEmpty(this.toolName)) {
            this.commands = this.execEnv.toolSet.validCommands(this.toolName);
            this.command = (Command)this.commands.get(0);
            this.commandName = this.command.getName();
            this.commandModifier = this.command.getModifier();
            if (this.commandModifier == null) {
                this.commandModifier = "n/a";
            }
            this.commandDesc = this.command.getDescription();
            this.executable = this.execEnv.toolSet.validExecutable(this.command);
            this.args = this.execEnv.toolSet.validArgs(this.command);
            this.toolMode = this.execEnv.toolSet.mode(this.toolName);
        } else {
            this.toolName = "None";
            this.commands = new Vector();
            this.command = null;
            this.commandName = "n/a";
            this.commandModifier = "n/a";
            this.commandDesc = "n/a";
            this.executable = "n/a";
            this.args = null;
            this.toolMode = 2;
        }
        this.evalSources(this.execEnv.targetSet.validSources(this.targetDef));
        if (this.sourceList.size() < 1 && this.targetDef.getSources().size() > 0) {
            this.ps.println("#");
            this.ps.println("# Target " + this.target.getAutoNamed());
            this.ps.println("#");
            this.ps.println("# empty (no valid sources)");
            this.ps.println("#" + NL + NL);
            this.files.clear();
            this.destList.clear();
            this.destInlines.clear();
            return;
        }
        this.collect(targetTypesList, this.targetType, this.destList);
        this.collect(targetNamesList, target.getAutoNamed(), this.destList);
        this.dumpDescription();
        this.dumpRules();
    }

    private void evalSources(List list) {
        Vector vector = new Vector();
        vector.addAll(this.files);
        this.files.clear();
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Sources sources = (Sources)listIterator.next();
                this.evalSource(sources);
                vector.addAll(this.files);
                this.files.clear();
            }
        }
        this.files.addAll(vector);
        if (this.toolMode == 2) {
            if (!Globals.isEmpty(this.targetType)) {
                this.destList.add(this.targetDir + this.target.getName() + "." + this.targetType);
            } else {
                this.destList.add(this.targetDir + this.target.getName() + ".");
            }
        } else {
            this.addDirType(this.targetType, this.targetDir, this.destList, this.files);
        }
        this.files = this.clean(this.destList);
    }

    private void evalSource(Sources sources) {
        Object object;
        String string;
        Object object2;
        this.getSource(sources);
        this.sourceType = sources.getType();
        TargetDef targetDef = sources.getTargetDef();
        if (targetDef != null) {
            object2 = new TgtEvaluator(this.execEnv, this.target, targetDef, this.ps);
            string = targetDef.getLocalFlags();
            if (!Globals.isEmpty(string)) {
                object = ((TgtEvaluator)object2).files.listIterator();
                while (object.hasNext()) {
                    object.set(string + "##" + object.next());
                }
            }
            this.files.addAll(((TgtEvaluator)object2).files);
            this.destInlines.addAll(((TgtEvaluator)object2).destList);
            if (Globals.isEmpty(this.sourceType)) {
                this.sourceType = ((TgtEvaluator)object2).targetType;
            }
        }
        object2 = sources.getSourceSet();
        string = sources.getTarget();
        if (Globals.isEmpty((String)object2) && !Globals.isEmpty(string)) {
            object = this.execEnv.targetSet.named(string);
            TgtEvaluator tgtEvaluator = new TgtEvaluator(this.execEnv, (Target)object, this.ps);
            String string2 = sources.getLocalFlags();
            if (!Globals.isEmpty(string2)) {
                ListIterator<String> listIterator = tgtEvaluator.files.listIterator();
                while (listIterator.hasNext()) {
                    listIterator.set(string2 + "##" + listIterator.next());
                }
            }
            this.files.addAll(tgtEvaluator.files);
            this.destReferences.add(tgtEvaluator.autoName == null ? ((Target)object).getName() : tgtEvaluator.autoName);
            if (Globals.isEmpty(this.sourceType)) {
                this.sourceType = tgtEvaluator.targetType;
            }
        }
        this.addType(this.sourceType, this.sourceList, this.files);
    }

    private void dumpDescription() {
        String string = this.toolMode == 2 ? "Single Run" : "One to One";
        this.ps.println("# TargetName=" + this.target.getAutoNamed());
        this.ps.println("#");
        this.ps.println("# TargetType=" + (this.targetType != null && this.targetType.length() > 0 ? this.targetType : "n/a"));
        this.ps.println("# TargetDir=" + this.targetDir);
        this.ps.println("#");
        this.ps.println("# Using Tool: " + this.toolName);
        this.ps.println("#       mode: " + string);
        this.ps.println("#    command: " + this.commandName);
        this.ps.println("#   modifier: " + this.commandModifier);
        this.ps.println("#     descr.: " + this.commandDesc);
        this.ps.println("#      exec.: " + this.executable);
        this.ps.println("#");
        this.ps.println("# SOURCES:");
        ListIterator listIterator = this.sourceList.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            String[] stringArray = this.splitSourceFlags(string2);
            if (!sourceFiles.contains(string2 = stringArray[0])) {
                sourceFiles.add(string2);
            }
            if (!Globals.isEmpty(stringArray[1])) {
                string2 = string2 + " (" + stringArray[1] + ")";
            }
            this.ps.println("# " + string2);
        }
        this.ps.println("#");
        this.ps.println("# RESULTS:");
        listIterator = this.destList.listIterator();
        while (listIterator.hasNext()) {
            this.ps.println("# " + listIterator.next());
        }
        this.ps.println("#");
    }

    private void dumpRules() {
        this.ps.println("# RULES:");
        this.ps.println();
        this.sourceLocalFlags = "";
        if (this.toolMode == 1) {
            for (int i = 0; i < this.sourceList.size(); ++i) {
                this.destFile = (String)this.destList.elementAt(i);
                if (!targetFiles.contains(this.destFile)) {
                    targetFiles.add(this.destFile);
                }
                this.ps.println(this.destFile + ": |");
                String[] stringArray = this.splitSourceFlags((String)this.sourceList.elementAt(i));
                this.ps.println("        " + stringArray[0]);
                this.sourceLocalFlags = stringArray[1];
                if (!Globals.isEmpty(stringArray[2])) {
                    this.sourceSet = (SourceSetExt)this.sourceSets.get(stringArray[2]);
                }
                this.dumpCommands();
            }
        } else {
            this.destFile = (String)this.destList.elementAt(0);
            if (!targetFiles.contains(this.destFile)) {
                targetFiles.add(this.destFile);
            }
            this.ps.print(this.destFile + ": ");
            for (int i = 0; i < this.sourceList.size(); ++i) {
                this.ps.println(" |");
                String[] stringArray = this.splitSourceFlags((String)this.sourceList.elementAt(i));
                this.ps.print("        " + stringArray[0]);
                if (stringArray[1].length() <= 0) continue;
                this.sourceLocalFlags = this.sourceLocalFlags + stringArray[1] + NL;
            }
            this.ps.println();
            this.dumpCommands();
        }
        this.ps.println();
    }

    private void dumpCommands() {
        ListIterator listIterator = this.commands.listIterator();
        while (listIterator.hasNext()) {
            Command command = (Command)listIterator.next();
            String string = command.getModifier();
            if (string == null) {
                string = "";
            }
            String string2 = this.execEnv.toolSet.validExecutable(command);
            Args args = this.execEnv.toolSet.validArgs(command);
            String string3 = args.getTemplate();
            String string4 = "        ";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            PrintStream printStream2 = this.ps;
            this.ps = printStream;
            this.cmdFileGen = "";
            this.ps.print("\t" + string + string2);
            this.evalArgsTemplate(string3, string4, command);
            this.ps = printStream2;
            this.ps.print(this.cmdFileGen);
            try {
                byteArrayOutputStream.writeTo(this.ps);
            }
            catch (Exception exception) {
                new External(exception).handle();
            }
        }
        this.ps.println();
    }

    private String[] splitSourceFlags(String string) {
        int n;
        String[] stringArray = new String[]{string, "", ""};
        Matcher matcher = patSrcSet.matcher(string);
        if (matcher.find()) {
            stringArray[0] = string = matcher.group(1) + matcher.group(3);
            stringArray[2] = matcher.group(2);
        }
        if ((n = string.indexOf("##")) > 0) {
            stringArray[0] = string.substring(n + 2);
            stringArray[1] = string.substring(0, n);
        }
        return stringArray;
    }

    private void evalArgsTemplate(String string, String string2, Command command) {
        String string3 = string;
        String string4 = "";
        while (string.length() > 0) {
            String string5 = "";
            int n = string.indexOf("[");
            if (n < 0) {
                this.ps.println(" |" + NL + string2 + string);
                break;
            }
            String string6 = string.substring(0, n);
            if (string6.length() > 0 && string6.trim().length() > 0) {
                string5 = string5 + string2 + string6;
            }
            if ((n = this.getClosingBracket(string = string.substring(n + 1))) < 0) {
                throw new Panic("Invalid argument template\u00a7\u00a7  <" + string3 + ">\u00a7\u00a7" + "for command <" + command.getName() + ">");
            }
            string4 = string.substring(0, n);
            string6 = this.evalOption(string4, string2, command);
            if (string5.length() > 0) {
                string6 = string6.trim();
            }
            string5 = string5 + string6;
            if ((n = (string = string.substring(n + 1)).indexOf(" ")) < 0) {
                n = string.length();
            }
            if (n > 0) {
                string5 = string5 + string.substring(0, n);
                string = string.substring(n);
            }
            if (string5.length() <= 0) continue;
            this.ps.print(" |" + NL + string5);
        }
        this.ps.println();
    }

    private String evalOption(String string, String string2, Command command) {
        if (string.startsWith("dest")) {
            return this.evalOptionDest(string, string2, command);
        }
        if (string.startsWith("source")) {
            return this.evalOptionSource(string, string2, command);
        }
        if (string.startsWith("localFlags")) {
            return this.evalOptionLocalFlags(string, string2, command);
        }
        if (string.startsWith("cmdFile")) {
            return this.evalOptionCmdFile(string, string2, command);
        }
        this.multiX = string.indexOf("*");
        if (this.multiX > 0) {
            string = string.substring(0, this.multiX);
        }
        String string3 = "";
        String string4 = this.execEnv.toolSet.supportedFlag(command, string);
        if (string4 == null) {
            throw new Problem("Option <" + string + "> not supported\u00a7\u00a7" + "for command <" + command.getName() + ">");
        }
        String string5 = null;
        if (this.sourceSet != null) {
            string5 = this.sourceSet.lookUp(string, false);
        }
        if (Globals.isEmpty(string5)) {
            string5 = this.execEnv.targetSet.lookUp(string, false);
        }
        if (Globals.isEmpty(string5)) {
            return string3;
        }
        string3 = this.multiX < 0 ? string3 + this.formatOptSingle(string2 + string4, string5) : string3 + this.formatOptMulti(string2 + string4, string5);
        return string3;
    }

    private String evalOptionDest(String string, String string2, Command command) {
        String string3 = this.destFile;
        if (string.indexOf("_dir") > 0) {
            if (Globals.isEmpty(this.targetDir)) {
                throw new Panic("No valid target path\u00a7\u00a7for target <" + this.target.getName() + ">");
            }
            string3 = this.targetDir.substring(0, this.targetDir.length() - 1);
        } else {
            string2 = "";
            int n = string.indexOf(".");
            if (n >= 0) {
                string3 = "$(subst ." + this.targetType + "," + string.substring(n) + ",$@)";
            }
        }
        return string2 + string3;
    }

    private String evalOptionSource(String string, String string2, Command command) {
        if (string.indexOf("_dir") > 0) {
            int n;
            String string3 = "";
            String string4 = (String)this.sourceList.get(0);
            Matcher matcher = patSrcSet.matcher(string4);
            if (matcher.find()) {
                string4 = matcher.group(1) + matcher.group(3);
            }
            if ((n = string4.lastIndexOf(File.separator)) >= 0) {
                string3 = string4.substring(0, n);
            }
            return string3;
        }
        String string5 = "$<";
        this.multiX = string.indexOf("*");
        if (this.multiX > 0) {
            string = string.substring(0, this.multiX);
            string5 = "$^";
        }
        int n = string.indexOf(".");
        if (this.intoCmdFile) {
            String string6 = "";
            ListIterator listIterator = this.sourceList.listIterator();
            while (listIterator.hasNext()) {
                String string7 = (String)listIterator.next();
                Matcher matcher = patSrcSet.matcher(string7);
                if (matcher.find()) {
                    string7 = matcher.group(1) + matcher.group(3);
                }
                if (n > 0) {
                    string7 = string7.substring(0, string7.lastIndexOf(".") - 1) + string.substring(n);
                }
                string6 = string6 + string2 + string7 + NL;
            }
            return string6;
        }
        return n < 0 ? string2 + string5 : string2 + "$(subst ." + this.sourceType + "," + string.substring(n) + "," + string5 + ")";
    }

    private String evalOptionLocalFlags(String string, String string2, Command command) {
        if (this.sourceLocalFlags.length() == 0) {
            return "";
        }
        if (this.toolMode == 1) {
            return string2 + this.sourceLocalFlags;
        }
        String[] stringArray = this.sourceLocalFlags.split(NL);
        String string3 = string2 + stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string3 = string3 + " |" + NL + string2 + stringArray[i];
        }
        return string3;
    }

    private String evalOptionCmdFile(String string, String string2, Command command) {
        String string3 = "";
        String string4 = this.execEnv.toolSet.supportedFlag(command, "cmdFile");
        if (string4 == null) {
            throw new Problem("Option <cmdFile> not supported\u00a7\u00a7for command <" + command.getName() + ">");
        }
        String string5 = this.execEnv.targetSet.lookUp("cmdFile");
        if (string5 == null) {
            string5 = this.targetDir;
        }
        string5 = string5 + command.getName() + "_" + this.target.getName() + ".cmd";
        string3 = string3 + string2 + string4 + string5;
        PrintStream printStream = this.ps;
        this.ps = this.getMakeCmdPs(string5);
        this.intoCmdFile = true;
        this.evalArgsTemplate(string.substring(7), "", command);
        this.intoCmdFile = false;
        this.ps = printStream;
        return string3;
    }

    private String formatOptSingle(String string, String string2) {
        String string3 = "";
        int n = string2.indexOf("\u00a7");
        while (n >= 0) {
            string3 = string3 + string + string2.substring(0, n) + " |" + NL;
            string2 = string2.substring(n + 1);
            n = string2.indexOf("\u00a7");
        }
        string3 = string3 + string + string2;
        return string3;
    }

    private String formatOptMulti(String string, String string2) {
        int n;
        String string3 = string;
        String string4 = "";
        for (n = 0; n < string.length(); ++n) {
            string4 = string4 + " ";
        }
        n = string2.indexOf("\u00a7");
        while (n >= 0) {
            string3 = string3 + string2.substring(0, n) + " |" + NL + string4;
            string2 = string2.substring(n + 1);
            n = string2.indexOf("\u00a7");
        }
        string3 = string3 + string2;
        return string3;
    }

    private void getSource(Sources sources) {
        this.files.addAll(this.execEnv.targetSet.validSourceFiles(sources));
        String string = sources.getSourceSet();
        if (!Globals.isEmpty(string)) {
            String string2 = sources.getPathRef();
            if (!Globals.isEmpty(string2)) {
                string = string2 + "->" + string;
            }
            if (!this.execEnv.loadSourceSet(sources)) {
                throw new Problem("SourceSet <" + string + "> not found");
            }
            this.sourceSet = this.execEnv.sourceSet;
            String string3 = string.replaceAll("\\[\\*\\]", "[" + this.sourceSet.getName() + "]");
            this.sourceSets.put(string3, this.sourceSet);
            ListIterator listIterator = this.sourceSet.validSourceFiles().listIterator();
            while (listIterator.hasNext()) {
                this.files.add(":SrcSet=" + string3 + ":" + listIterator.next());
            }
            while (this.sourceSet.hasNext()) {
                SourceSetExt sourceSetExt = this.sourceSet.next();
                string3 = string.replaceAll("\\[\\*\\]", "[" + sourceSetExt.getName() + "]");
                this.sourceSets.put(string3, this.sourceSet);
                listIterator = sourceSetExt.validSourceFiles().listIterator();
                while (listIterator.hasNext()) {
                    this.files.add(":SrcSet=" + string3 + ":" + listIterator.next());
                }
            }
        }
    }

    private void addType(String string, List list, List list2) {
        ListIterator listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (!Globals.isEmpty(string)) {
                string2 = string2 + "." + string;
            }
            list.add(string2);
        }
    }

    private void addDirType(String string, String string2, List list, List list2) {
        ListIterator listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            String string3 = (String)listIterator.next();
            String string4 = Globals.isEmpty(string) ? "" : "." + string;
            string3 = string3.substring(string3.lastIndexOf(File.separator) + 1);
            string3 = string3.lastIndexOf(".") > 0 ? string2 + string3.replaceFirst("\\..*$", string4) : string2 + string3 + string4;
            list.add(string3);
        }
    }

    private Vector clean(List list) {
        Vector<String> vector = new Vector<String>();
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            int n = string.lastIndexOf(".");
            if (n < 0) {
                n = string.length();
            }
            vector.add(string.substring(0, n));
            listIterator.set(string.replaceFirst("\\.$", ""));
        }
        return vector;
    }

    private int getClosingBracket(String string) {
        int n = string.length();
        int n2 = 1;
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '[': {
                    ++n2;
                    continue block4;
                }
                case ']': {
                    if (--n2 != 0) continue block4;
                    return i;
                }
            }
        }
        return -1;
    }

    private void collect(Hashtable hashtable, String string, Vector vector) {
        if (Globals.isEmpty(string)) {
            return;
        }
        if (!hashtable.containsKey(string)) {
            hashtable.put(string, new Vector());
        }
        Vector vector2 = (Vector)hashtable.get(string);
        vector2.addAll(vector);
    }

    private PrintStream getMakeCmdPs(String string) {
        final String string2 = string;
        return new PrintStream(new OutputStream(){

            public void write(int n) {
                if (n == 124) {
                    return;
                }
                if (n == 13) {
                    return;
                }
                if (n == 10) {
                    String string = TgtEvaluator.this.cmdFileTmp.trim();
                    TgtEvaluator.this.cmdFileTmp = "";
                    if (string.length() == 0) {
                        return;
                    }
                    if (TgtEvaluator.this.cmdFileGen.length() == 0) {
                        TgtEvaluator.this.cmdFileGen = TgtEvaluator.this.cmdFileGen + ("\t$(BSB_ECHO) " + string + " > " + string2 + NL);
                    } else {
                        TgtEvaluator.this.cmdFileGen = TgtEvaluator.this.cmdFileGen + ("\t$(BSB_ECHO) " + string + " >> " + string2 + NL);
                    }
                    return;
                }
                TgtEvaluator.this.cmdFileTmp = TgtEvaluator.this.cmdFileTmp + String.valueOf((char)n);
            }
        });
    }

    private PrintStream getCmdPs(String string) {
        File file = new File(string);
        try {
            final FileOutputStream fileOutputStream = new FileOutputStream(file);
            return new PrintStream(new OutputStream(){

                public void write(int n) {
                    if (n == 124) {
                        return;
                    }
                    try {
                        fileOutputStream.write(n);
                    }
                    catch (Exception exception) {
                        new External(exception).handle();
                    }
                }
            });
        }
        catch (Exception exception) {
            throw new Panic("Can't access command outputfile:\u00a7\u00a7" + string);
        }
    }

    private PrintStream getNullPs() {
        return new PrintStream(new OutputStream(){

            public void write(int n) {
            }
        });
    }

    static {
        NL = System.getProperty("line.separator");
        patSrcSet = Pattern.compile("([^:]*):SrcSet=(.*):(.*)");
    }
}

