/*
 * Decompiled with CFR 0.152.
 */
package bsbGenerator;

import bsbDocExt.OptionsExt;
import bsbException.External;
import bsbException.Problem;
import bsbGenerator.Requestor;
import bsbMain.Globals;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Requirement {
    private static Pattern patName = Pattern.compile("\\s*([_.\\[A-Za-z][_\\.\\]\\-A-Za-z0-9]*)");
    private static Pattern patNumH = Pattern.compile("\\s*(0[xX][0-9A-Fa-f]+)");
    private static Pattern patExpr = Pattern.compile("\\s*\\(([^()]*)\\)");
    private static Pattern patOpNeg = Pattern.compile("\\s*!\\s*([0-9]+)");
    private static Pattern patOpLt = Pattern.compile("\\s*([0-9]+)\\s*<\\s*([0-9]+)");
    private static Pattern patOpGt = Pattern.compile("\\s*([0-9]+)\\s*>\\s*([0-9]+)");
    private static Pattern patOpEq = Pattern.compile("\\s*([0-9]+)\\s*==\\s*([0-9]+)");
    private static Pattern patOpNeq = Pattern.compile("\\s*([0-9]+)\\s*!=\\s*([0-9]+)");
    private static Pattern patOpLe = Pattern.compile("\\s*([0-9]+)\\s*<=\\s*([0-9]+)");
    private static Pattern patOpGe = Pattern.compile("\\s*([0-9]+)\\s*>=\\s*([0-9]+)");
    private static Pattern patOpAnd = Pattern.compile("\\s*([0-9]+)\\s*&&\\s*([0-9]+)");
    private static Pattern patOpOr = Pattern.compile("\\s*([0-9]+)\\s*\\|\\|\\s*([0-9]+)");
    private Requestor requestor = null;

    public Requirement(Requestor requestor) {
        this.requestor = requestor;
    }

    public boolean evaluate(String string) {
        String string2 = string;
        if (this.requestor == null) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return true;
        }
        String string3 = OptionsExt.cvLit;
        OptionsExt.cvLit = "";
        Matcher matcher = patExpr.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceFirst(this.eval(matcher.group(1)));
            matcher = patExpr.matcher(string);
        }
        boolean bl = false;
        try {
            bl = Integer.parseInt(this.eval(string)) != 0;
        }
        catch (Exception exception) {
            External external = new External("Invalid expression in requirement:\u00a7\u00a7" + string2, exception);
            if (Globals.gui) {
                external.handle();
            }
            throw external;
        }
        OptionsExt.cvLit = string3;
        return bl;
    }

    public String eval(String string) {
        string = this.evalNumHs(string);
        string = this.evalNames(string);
        string = this.evalOpNeg(string);
        string = this.evalOpLt(string);
        string = this.evalOpGt(string);
        string = this.evalOpEq(string);
        string = this.evalOpNeq(string);
        string = this.evalOpLe(string);
        string = this.evalOpGe(string);
        string = this.evalOpAnd(string);
        string = this.evalOpOr(string);
        return string;
    }

    public String evalNumHs(String string) {
        Matcher matcher = patNumH.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceFirst("" + Integer.decode(matcher.group(1)));
            matcher = patNumH.matcher(string);
        }
        return string;
    }

    public String evalNames(String string) {
        Matcher matcher = patName.matcher(string);
        while (matcher.find()) {
            String string2;
            String string3 = string2 = matcher.group(1);
            if (Globals.isEmpty(string2 = string2.equalsIgnoreCase("false") ? "0" : (string2.equalsIgnoreCase("true") ? "1" : (string2.equalsIgnoreCase("and") ? "&&" : (string2.equalsIgnoreCase("or") ? "||" : this.requestor.lookUp(string2)))))) {
                new Problem("Undefined option <" + string3 + ">" + "\u00a7\u00a7from <" + this.requestor.toString() + ">").handle();
                string2 = "0";
            }
            string = matcher.replaceFirst(string2);
            matcher = patName.matcher(string);
        }
        return string;
    }

    public String evalOpNeg(String string) {
        Matcher matcher = patOpNeg.matcher(string);
        while (matcher.find()) {
            String string2 = Integer.parseInt(matcher.group(1)) != 0 ? "0" : "1";
            string = matcher.replaceFirst(string2);
            matcher = patOpNeg.matcher(string);
        }
        return string;
    }

    public String evalOpLt(String string) {
        Matcher matcher = patOpLt.matcher(string);
        while (matcher.find()) {
            String string2 = Integer.parseInt(matcher.group(1)) < Integer.parseInt(matcher.group(2)) ? "1" : "0";
            string = matcher.replaceFirst(string2);
            matcher = patOpLt.matcher(string);
        }
        return string;
    }

    public String evalOpGt(String string) {
        Matcher matcher = patOpGt.matcher(string);
        while (matcher.find()) {
            String string2 = Integer.parseInt(matcher.group(1)) > Integer.parseInt(matcher.group(2)) ? "1" : "0";
            string = matcher.replaceFirst(string2);
            matcher = patOpGt.matcher(string);
        }
        return string;
    }

    public String evalOpEq(String string) {
        Matcher matcher = patOpEq.matcher(string);
        while (matcher.find()) {
            String string2 = Integer.parseInt(matcher.group(1)) == Integer.parseInt(matcher.group(2)) ? "1" : "0";
            string = matcher.replaceFirst(string2);
            matcher = patOpEq.matcher(string);
        }
        return string;
    }

    public String evalOpNeq(String string) {
        Matcher matcher = patOpNeq.matcher(string);
        while (matcher.find()) {
            String string2 = Integer.parseInt(matcher.group(1)) != Integer.parseInt(matcher.group(2)) ? "1" : "0";
            string = matcher.replaceFirst(string2);
            matcher = patOpNeq.matcher(string);
        }
        return string;
    }

    public String evalOpLe(String string) {
        Matcher matcher = patOpLe.matcher(string);
        while (matcher.find()) {
            String string2 = Integer.parseInt(matcher.group(1)) <= Integer.parseInt(matcher.group(2)) ? "1" : "0";
            string = matcher.replaceFirst(string2);
            matcher = patOpLe.matcher(string);
        }
        return string;
    }

    public String evalOpGe(String string) {
        Matcher matcher = patOpGe.matcher(string);
        while (matcher.find()) {
            String string2 = Integer.parseInt(matcher.group(1)) >= Integer.parseInt(matcher.group(2)) ? "1" : "0";
            string = matcher.replaceFirst(string2);
            matcher = patOpGe.matcher(string);
        }
        return string;
    }

    public String evalOpAnd(String string) {
        Matcher matcher = patOpAnd.matcher(string);
        while (matcher.find()) {
            String string2 = Integer.parseInt(matcher.group(1)) != 0 && Integer.parseInt(matcher.group(2)) != 0 ? "1" : "0";
            string = matcher.replaceFirst(string2);
            matcher = patOpAnd.matcher(string);
        }
        return string;
    }

    public String evalOpOr(String string) {
        Matcher matcher = patOpOr.matcher(string);
        while (matcher.find()) {
            String string2 = Integer.parseInt(matcher.group(1)) != 0 || Integer.parseInt(matcher.group(2)) != 0 ? "1" : "0";
            string = matcher.replaceFirst(string2);
            matcher = patOpOr.matcher(string);
        }
        return string;
    }
}

