/*
 * Decompiled with CFR 0.152.
 */
package bsbGenerator;

import bsbDocCls.Preamble;
import bsbDocCls.Preambles;
import bsbDocCls.Target;
import bsbDocExt.ConfigDefExt;
import bsbDocExt.PathSetExt;
import bsbDocExt.TargetSetExt;
import bsbDocExt.ToolSetExt;
import bsbException.External;
import bsbException.Problem;
import bsbGenerator.TgtEvaluator;
import bsbMain.ExecEnv;
import bsbMain.Globals;
import bsbUtil.BsbList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MainMakefile {
    private static final String NL = System.getProperty("line.separator");
    private ExecEnv execEnv = null;
    private ConfigDefExt configDef = null;
    private TargetSetExt targetSet = null;
    private PathSetExt pathSet = null;
    private ToolSetExt toolSet = null;
    private Vector preambleVars = new Vector();
    private static Pattern pVRef = Pattern.compile("\\$\\((\\w+)");

    public MainMakefile(ExecEnv execEnv) {
        long l = System.currentTimeMillis();
        this.execEnv = execEnv;
        this.configDef = this.execEnv.configDef;
        if (this.configDef == null) {
            throw new Problem("No Config Def available");
        }
        this.targetSet = this.execEnv.targetSet;
        if (this.targetSet == null) {
            throw new Problem("No Target Set available");
        }
        this.pathSet = this.execEnv.pathSet;
        if (this.pathSet == null) {
            throw new Problem("No Path Set available");
        }
        this.toolSet = this.execEnv.toolSet;
        if (this.toolSet == null) {
            throw new Problem("No Tool Set available");
        }
        Target target = this.targetSet.selected();
        String string = this.execEnv.makefileName;
        File file = new File(string);
        if (file.getParentFile() != null) {
            this.execEnv.makefileLoc = file.getParentFile();
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            throw new External("Invalid path <" + file.getAbsolutePath() + ">", exception);
        }
        if (Globals.useDirectOut) {
            String string2 = "busyb_temp.tmp";
            File file2 = new File(this.execEnv.makefileLoc, string2);
            try {
                file2.getCanonicalPath();
            }
            catch (Exception exception) {
                throw new External("Invalid temp file <" + file2.getAbsolutePath() + ">", exception);
            }
            PrintStream printStream = new PrintStream(new MakeOs(file));
            PrintStream printStream2 = new PrintStream(new MakeOs(file2));
            System.out.println("Generating <" + string + "> ...");
            this.makefileHeader(target, printStream);
            this.makefileBody(target, printStream2);
            this.makefileVars(target, printStream);
            this.makefileFooter(printStream2);
            try {
                printStream.close();
                printStream2.close();
            }
            catch (Exception exception) {
                throw new External("Could not close Makefile <" + string + ">", exception);
            }
            System.out.println("cleaning...");
            this.concat(file, file2);
        } else {
            MakeOsB makeOsB = new MakeOsB(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(makeOsB);
            PrintStream printStream3 = new PrintStream(byteArrayOutputStream);
            System.out.println("Generating <" + string + "> ...");
            this.makefileHeader(target, printStream);
            this.makefileBody(target, printStream3);
            this.makefileVars(target, printStream);
            this.makefileFooter(printStream3);
            try {
                byteArrayOutputStream.writeTo(makeOsB);
                printStream.close();
            }
            catch (Exception exception) {
                throw new External("Could not close Makefile <" + string + ">", exception);
            }
        }
        System.out.println("Finished after " + (System.currentTimeMillis() - l) + " ms.");
    }

    private void makefileHeader(Target target, PrintStream printStream) {
        String string = DateFormat.getInstance().format(new Date());
        printStream.println("###############################################");
        printStream.println("##  MAKEFILE FOR           " + target.getName());
        printStream.println("##  DEFINED IN TARGETSET   " + this.targetSet.getName());
        printStream.println("##                         " + this.targetSet.getFilePath());
        printStream.println("##  BASED ON CONFIGURATION " + this.configDef.getName());
        if (target.getAutoNamed() != null && target.getAutoNamed().length() > 0) {
            printStream.println("##  AUTONAMED BY           " + target.getAutoNamed());
        }
        printStream.println("##  USING TOOLSET          " + this.toolSet.getName());
        printStream.println("##  generated              " + string);
        printStream.println("##  by                     BuSyB Version 1.2.0");
        printStream.println("##  for                    DTD Version   1.19");
        printStream.println("###############################################");
        printStream.println("");
        printStream.flush();
    }

    private void makefileBody(Target target, PrintStream printStream) {
        Object object;
        Object object2;
        String string = target.getName();
        String string2 = target.getAutoNamed();
        if (Globals.genOutDirs) {
            printStream.println("BuSyB-DefaultTarget: " + string + " OutDirsAll");
            printStream.println(NL + string + ": OutDirsAll");
        } else {
            printStream.println("BuSyB-DefaultTarget: " + string);
        }
        printStream.println("");
        printStream.println("");
        printStream.flush();
        List list = this.toolSet.validPreambles();
        if (!list.isEmpty()) {
            object2 = list.listIterator();
            while (object2.hasNext()) {
                object = (Preambles)object2.next();
                printStream.println("# PREAMBLE: " + ((Preambles)object).getDescription());
                BsbList bsbList = ((Preambles)object).getPreamble();
                ListIterator listIterator = bsbList.listIterator();
                while (listIterator.hasNext()) {
                    String string3 = ((Preamble)listIterator.next()).getValue();
                    printStream.println(string3);
                    this.collectVarRefs(this.preambleVars, string3);
                }
                printStream.println("");
            }
            printStream.println("");
        }
        printStream.println("");
        printStream.println("");
        printStream.flush();
        TgtEvaluator.realizedTargets = new Vector();
        TgtEvaluator.realizedCleanRules = new Vector();
        TgtEvaluator.targetFolders = new Vector();
        TgtEvaluator.targetFiles = new Vector();
        TgtEvaluator.sourceFiles = new Vector();
        TgtEvaluator.targetTypesList = new Hashtable();
        TgtEvaluator.targetNamesList = new Hashtable();
        object2 = new TgtEvaluator(this.execEnv, target, printStream);
        if (string2 != null && string2.length() > 0) {
            printStream.println(string + ": " + ((TgtEvaluator)object2).autoName + NL + NL);
        }
        printStream.print("clean: ");
        object = TgtEvaluator.realizedCleanRules.listIterator();
        while (object.hasNext()) {
            printStream.print(" |" + NL + "        " + object.next());
        }
        printStream.println(NL);
        if (Globals.genOutDirs) {
            printStream.print("OutDirsAll: $(BSB_OUT_DIRS_ALL)" + NL + "\t$(BSB_MKDIR) $(BSB_OUT_DIRS_ALL)");
            printStream.println(NL + NL);
        }
        printStream.flush();
    }

    private void makefileVars(Target target, PrintStream printStream) {
        this.makefileVars_OutDirsAll(target, printStream);
        this.makefileVars_TargetsAll(target, printStream);
        this.makefileVars_SourcesAll(target, printStream);
        this.makefileVars_ToolsAll(target, printStream);
        this.makefileVars_PathesAll(target, printStream);
        this.makefileVars_PropsAll(target, printStream);
        this.makefileVars_SourcesOnly(target, printStream);
        this.makefileVars_TargetsTyped(target, printStream);
        this.makefileVars_TargetsNamed(target, printStream);
        this.makefileVars_PathesNamed(target, printStream);
        this.makefileVars_PropsNamed(target, printStream);
        printStream.println(NL);
        printStream.flush();
    }

    private void makefileFooter(PrintStream printStream) {
        printStream.println("");
        printStream.println("## END OF GENERATED MAKEFILE");
        printStream.println("###############################################");
        printStream.flush();
    }

    private void makefileVars_OutDirsAll(Target target, PrintStream printStream) {
        if (Globals.genAllVars || this.preambleVars.contains("BSB_OUT_DIRS_ALL")) {
            printStream.print(NL + "BSB_OUT_DIRS_ALL = ");
            ListIterator listIterator = TgtEvaluator.targetFolders.listIterator();
            if (listIterator.hasNext()) {
                printStream.print(listIterator.next());
            }
            while (listIterator.hasNext()) {
                printStream.print(" |" + NL + "                   " + listIterator.next());
            }
            printStream.println();
        }
    }

    private void makefileVars_TargetsAll(Target target, PrintStream printStream) {
        if (Globals.genAllVars || this.preambleVars.contains("BSB_TARGETS_ALL")) {
            printStream.print(NL + "BSB_TARGETS_ALL  = ");
            ListIterator listIterator = TgtEvaluator.targetFiles.listIterator();
            if (listIterator.hasNext()) {
                printStream.print(listIterator.next());
            }
            while (listIterator.hasNext()) {
                printStream.print(" |" + NL + "                   " + listIterator.next());
            }
            printStream.println();
        }
    }

    private void makefileVars_TargetsTyped(Target target, PrintStream printStream) {
        String string = NL;
        Enumeration enumeration = TgtEvaluator.targetTypesList.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!Globals.genAllVars && !this.preambleVars.contains("BSB_TG_TYPE_" + string2)) continue;
            printStream.print(string);
            string = "";
            Vector vector = (Vector)TgtEvaluator.targetTypesList.get(string2);
            printStream.print("BSB_TG_TYPE_" + string2 + "  = ");
            ListIterator listIterator = vector.listIterator();
            if (listIterator.hasNext()) {
                printStream.print(listIterator.next());
            }
            while (listIterator.hasNext()) {
                printStream.print(" |" + NL + "                   " + listIterator.next());
            }
            printStream.println();
        }
    }

    private void makefileVars_TargetsNamed(Target target, PrintStream printStream) {
        String string = NL;
        Enumeration enumeration = TgtEvaluator.targetNamesList.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!Globals.genAllVars && !this.preambleVars.contains("BSB_TG_NAME_" + string2)) continue;
            printStream.print(string);
            string = "";
            Vector vector = (Vector)TgtEvaluator.targetNamesList.get(string2);
            printStream.print("BSB_TG_NAME_" + string2 + "  = ");
            ListIterator listIterator = vector.listIterator();
            if (listIterator.hasNext()) {
                printStream.print(listIterator.next());
            }
            while (listIterator.hasNext()) {
                printStream.print(" |" + NL + "                   " + listIterator.next());
            }
            printStream.println();
        }
    }

    private void makefileVars_SourcesAll(Target target, PrintStream printStream) {
        if (Globals.genAllVars || this.preambleVars.contains("BSB_SOURCES_ALL")) {
            printStream.print(NL + "BSB_SOURCES_ALL  = ");
            ListIterator listIterator = TgtEvaluator.sourceFiles.listIterator();
            if (listIterator.hasNext()) {
                printStream.print(listIterator.next());
            }
            while (listIterator.hasNext()) {
                printStream.print(" |" + NL + "                   " + listIterator.next());
            }
            printStream.println();
        }
    }

    private void makefileVars_SourcesOnly(Target target, PrintStream printStream) {
        if (Globals.genAllVars || this.preambleVars.contains("BSB_SOURCES_ONLY")) {
            Vector<String> vector = new Vector<String>();
            printStream.print(NL + "BSB_SOURCES_ONLY = ");
            ListIterator listIterator = TgtEvaluator.sourceFiles.listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                if (TgtEvaluator.targetFiles.contains(string)) continue;
                vector.add(string);
            }
            listIterator = vector.listIterator();
            if (listIterator.hasNext()) {
                printStream.print(listIterator.next());
            }
            while (listIterator.hasNext()) {
                printStream.print(" |" + NL + "                   " + listIterator.next());
            }
            printStream.println();
        }
    }

    private void makefileVars_ToolsAll(Target target, PrintStream printStream) {
        if (Globals.genAllVars || this.preambleVars.contains("BSB_TOOLS_ALL")) {
            printStream.print(NL + "BSB_TOOLS_ALL    = ");
            ListIterator listIterator = this.toolSet.getUsedExecs().listIterator();
            if (listIterator.hasNext()) {
                printStream.print(listIterator.next());
            }
            while (listIterator.hasNext()) {
                printStream.print(" |" + NL + "                   " + listIterator.next());
            }
            printStream.println();
        }
    }

    private void makefileVars_PropsAll(Target target, PrintStream printStream) {
        if (Globals.genAllVars || this.preambleVars.contains("BSB_PROPS_ALL")) {
            String string;
            int n;
            printStream.print(NL + "BSB_PROPS_ALL    = ");
            int n2 = 0;
            Vector vector = this.configDef.getPropertyList()[0];
            ListIterator listIterator = vector.listIterator();
            while (listIterator.hasNext()) {
                int n3 = ((String)listIterator.next()).length();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            listIterator = vector.listIterator();
            if (listIterator.hasNext()) {
                String string2 = (String)listIterator.next();
                n = n2 - string2.length();
                string = "";
                while (0 < n--) {
                    string = string + " ";
                }
                string2 = string2 + string + " " + this.configDef.valueOf(string2);
                printStream.print(string2);
            }
            while (listIterator.hasNext()) {
                String string3 = (String)listIterator.next();
                n = n2 - string3.length();
                string = "";
                while (0 < n--) {
                    string = string + " ";
                }
                string3 = string3 + string + " " + this.configDef.valueOf(string3);
                printStream.print(" |" + NL + "                   " + string3);
            }
            printStream.println();
        }
    }

    private void makefileVars_PathesAll(Target target, PrintStream printStream) {
        if (Globals.genAllVars || this.preambleVars.contains("BSB_PATHES_ALL")) {
            String string;
            int n;
            String string2;
            printStream.print(NL + "BSB_PATHES_ALL   = ");
            int n2 = 0;
            Vector vector = this.pathSet.getList()[0];
            ListIterator listIterator = vector.listIterator();
            while (listIterator.hasNext()) {
                int n3 = ((String)listIterator.next()).length();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            listIterator = vector.listIterator();
            if (listIterator.hasNext()) {
                String string3 = (String)listIterator.next();
                string2 = this.pathSet.fullPath(string3);
                if (string3.length() == 0) {
                    string3 = "unnamed_";
                }
                if (string2.length() == 0) {
                    string2 = ".";
                }
                n = n2 - string3.length();
                string = "";
                while (0 < n--) {
                    string = string + " ";
                }
                string3 = string3 + string + " " + string2;
                printStream.print(string3);
            }
            while (listIterator.hasNext()) {
                String string4 = (String)listIterator.next();
                string2 = this.pathSet.fullPath(string4);
                if (string4.length() == 0) {
                    string4 = "unnamed_";
                }
                if (string2.length() == 0) {
                    string2 = ".";
                }
                n = n2 - string4.length();
                string = "";
                while (0 < n--) {
                    string = string + " ";
                }
                string4 = string4 + string + " " + string2;
                printStream.print(" |" + NL + "                   " + string4);
            }
            printStream.println();
        }
    }

    private void makefileVars_PathesNamed(Target target, PrintStream printStream) {
        String string = NL;
        int n = 0;
        Vector vector = this.pathSet.getList()[0];
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            int n2 = ((String)listIterator.next()).length();
            if (n2 <= n) continue;
            n = n2;
        }
        listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (!Globals.genAllVars && !this.preambleVars.contains("BSB_PATH_" + string2)) continue;
            String string3 = this.pathSet.fullPath(string2);
            if (string2.length() == 0) {
                string2 = "unnamed_";
            }
            if (string3.length() == 0) {
                string3 = ".";
            }
            printStream.print(string);
            string = "";
            int n3 = n - string2.length();
            String string4 = "";
            while (0 < n3--) {
                string4 = string4 + " ";
            }
            printStream.println("BSB_PATH_" + string2 + string4 + " = " + string3);
        }
    }

    private void makefileVars_PropsNamed(Target target, PrintStream printStream) {
        String string = NL;
        int n = 0;
        Vector vector = this.configDef.getPropertyList()[0];
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            int n2 = ((String)listIterator.next()).length();
            if (n2 <= n) continue;
            n = n2;
        }
        listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (!Globals.genAllVars && !this.preambleVars.contains("BSB_PROP_" + string2)) continue;
            printStream.print(string);
            string = "";
            int n3 = n - string2.length();
            String string3 = "";
            while (0 < n3--) {
                string3 = string3 + " ";
            }
            printStream.println("BSB_PROP_" + string2 + string3 + " = " + this.configDef.valueOf(string2));
        }
    }

    private void collectVarRefs(Vector vector, String string) {
        Matcher matcher = pVRef.matcher(string);
        while (matcher.find()) {
            if (vector.contains(matcher.group(1))) continue;
            vector.add(matcher.group(1));
        }
    }

    private void concat(File file, File file2) {
        try {
            int n;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileInputStream fileInputStream = new FileInputStream(file2);
            byte[] byArray = new byte[4096];
            randomAccessFile.seek(randomAccessFile.length());
            while ((n = fileInputStream.read(byArray)) > 0) {
                randomAccessFile.write(byArray, 0, n);
            }
            randomAccessFile.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            throw new External("Concat error", exception);
        }
    }

    private class MakeOsB
    extends ByteArrayOutputStream {
        private File fout = null;
        private FileOutputStream fos = null;

        public MakeOsB(File file) {
            this.fout = file;
        }

        public void close() {
            try {
                this.fos = new FileOutputStream(this.fout);
                this.writeTo(this.fos);
                this.fos.close();
            }
            catch (Exception exception) {
                throw new External("Cannot create Makefile <" + this.fout + ">", exception);
            }
        }

        public void write(int n) {
            if (n == 92) {
                n = 47;
            } else if (n == 124) {
                n = 92;
            } else if (n == 126) {
                for (int i = 0; i < NL.length() - 1; ++i) {
                    super.write(NL.charAt(i));
                }
                n = NL.charAt(NL.length() - 1);
            }
            super.write(n);
        }

        public void write(byte[] byArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                this.write(byArray[n++]);
            }
        }
    }

    private class MakeOs
    extends OutputStream {
        private File fout = null;
        private FileOutputStream fos = null;

        public MakeOs(File file) {
            try {
                this.fos = new FileOutputStream(file);
            }
            catch (Exception exception) {
                throw new External("Cannot create Makefile <" + file + ">", exception);
            }
            this.fout = file;
        }

        public void write(int n) {
            if (n == 92) {
                n = 47;
            } else if (n == 124) {
                n = 92;
            } else if (n == 126) {
                for (int i = 0; i < NL.length() - 1; ++i) {
                    try {
                        this.fos.write(NL.charAt(i));
                        continue;
                    }
                    catch (Exception exception) {
                        throw new External("Cannot write <" + this.fout + ">", exception);
                    }
                }
                n = NL.charAt(NL.length() - 1);
            }
            try {
                this.fos.write(n);
            }
            catch (Exception exception) {
                throw new External("Cannot write <" + this.fout + ">", exception);
            }
        }
    }
}

