/*
 * Decompiled with CFR 0.152.
 */
package bsbException;

import bsbException.External;
import bsbMain.Globals;
import javax.swing.JOptionPane;

public class BsbException
extends RuntimeException {
    protected String header = "BuSyB ";
    protected String type = "unspecified exception";
    protected String source = null;
    protected String msg = null;

    public BsbException() {
        this("Unknown reason");
    }

    public BsbException(String string) {
        super(string);
    }

    public BsbException(Exception exception) {
        super(exception);
    }

    public BsbException(String string, Exception exception) {
        super(string, exception);
    }

    public void handle() {
        if (this.msg == null && this.getMessage() != null) {
            this.msg = "  " + this.getMessage();
        }
        if (this.msg == null) {
            this.msg = "  Unknown reason";
        }
        this.msg = this.msg.replaceAll("\u00a7\u00a7", Globals.NL + "  ");
        if (Globals.verboseExAll || Globals.verboseExExt && this instanceof External) {
            if (this.source == null) {
                this.source = "";
            }
            if (this.getClass().getName() != null) {
                this.source = this.source + this.getClass().getName();
            }
            if (this.getCause() != null) {
                this.source = this.source + " (from: " + this.getCause().getClass().getName() + ")";
            }
            StackTraceElement[] stackTraceElementArray = null;
            StackTraceElement[] stackTraceElementArray2 = this.getStackTrace();
            Throwable throwable = this.getCause();
            if (throwable != null) {
                stackTraceElementArray = throwable.getStackTrace();
            }
            if (Globals.stackTraceLong) {
                int n;
                this.msg = this.msg + Globals.NL + "Stack Trace:" + Globals.NL;
                for (n = 0; n < stackTraceElementArray2.length; ++n) {
                    this.msg = this.msg + stackTraceElementArray2[n].toString() + Globals.NL;
                }
                if (Globals.verboseExExt && stackTraceElementArray != null) {
                    this.msg = this.msg + "Stack Trace of External:" + Globals.NL;
                    for (n = 0; n < stackTraceElementArray.length; ++n) {
                        this.msg = this.msg + stackTraceElementArray[n].toString() + Globals.NL;
                    }
                }
            } else {
                this.msg = this.msg + Globals.NL + "  in: " + stackTraceElementArray2[0].toString();
            }
        }
        if (this.source == null) {
            this.source = "";
        }
        if (Globals.gui) {
            if (this.source.length() > 0) {
                this.source = this.source + Globals.NL;
            }
            JOptionPane.showMessageDialog(null, this.source + this.msg, this.header + this.type, 0);
        } else {
            System.out.println(this.header + this.type);
            if (this.source.length() > 0) {
                System.out.println(this.source);
            }
            System.out.println(this.msg);
        }
        if (Globals.earlyExit) {
            System.exit(-1);
        }
    }
}

