/*
 * Decompiled with CFR 0.152.
 */
package bsbEdit;

import bsbDocTree.ToolSetTree;
import bsbEdit.EditHandler;
import bsbGui.ToolSetPnl;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolSetEdit
extends ToolSetPnl
implements ChangeListener,
ActionListener,
ComponentListener {
    private JToolBar tb;
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private ToolSetTree tree;
    private boolean dirty = false;

    public ToolSetEdit() {
    }

    public ToolSetEdit(UserEnv userEnv) {
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.tree = new ToolSetTree(this.userEnv);
        this.tree.expandRow(0);
        this.tree.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.pnlTree.add(jScrollPane);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.addComponentListener(this);
        this.setComponents();
    }

    public boolean isDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        if (this.userEnv.tbpMain.getSelectedComponent() == this) {
            this.userEnv.actSave.setEnabled(bl);
        }
        this.userEnv.checkDirty();
        return bl2;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void saveCur() {
        File file = this.execEnv.toolSet.getCurFile().getAbsoluteFile();
        this.execEnv.toolSet.write(file);
        this.isDirty(false);
    }

    private void setComponents() {
        this.tb = new JToolBar("Tool Set Edit");
        this.tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.populate(this.tb);
        this.tb.setOrientation(1);
        this.add((Component)this.tb, "East");
    }

    private void populate(JToolBar jToolBar) {
        jToolBar.add(this.userEnv.actEdtText).setToolTipText("Edit Text");
        jToolBar.addSeparator();
        jToolBar.add(this.userEnv.actPreamblesNew).setToolTipText("New Preamble Set");
        jToolBar.add(this.userEnv.actPreambleNew).setToolTipText("New Preamble");
        jToolBar.add(this.userEnv.actToolNew).setToolTipText("New Tool");
        jToolBar.add(this.userEnv.actCommandNew).setToolTipText("New Command");
        jToolBar.add(this.userEnv.actSupportsNew).setToolTipText("New Support option");
        jToolBar.add(this.userEnv.actArgsNew).setToolTipText("New Command Arguments");
        jToolBar.add(this.userEnv.actCmdModNew).setToolTipText("Add Command Modifier");
        jToolBar.add(this.userEnv.actFlagNew).setToolTipText("New Exec Flags");
        jToolBar.addSeparator();
        jToolBar.add(this.userEnv.actDelete).setToolTipText("Delete Element");
    }

    private void setEditMenu(JMenu jMenu) {
        jMenu.removeAll();
        jMenu.add(new JMenuItem(this.userEnv.actEdtText));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actPreamblesNew));
        jMenu.add(new JMenuItem(this.userEnv.actPreambleNew));
        jMenu.add(new JMenuItem(this.userEnv.actToolNew));
        jMenu.add(new JMenuItem(this.userEnv.actCommandNew));
        jMenu.add(new JMenuItem(this.userEnv.actSupportsNew));
        jMenu.add(new JMenuItem(this.userEnv.actArgsNew));
        jMenu.add(new JMenuItem(this.userEnv.actCmdModNew));
        jMenu.add(new JMenuItem(this.userEnv.actFlagNew));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actDelete));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Container container = this.tb.getParent();
        Component component = this.userEnv.tbpMain.getSelectedComponent();
        if (component == this) {
            this.userEnv.disableTabActions();
            this.userEnv.actSave.setEnabled(this.dirty);
            this.userEnv.actSave.putValue("BSB_HANDLER", this);
            this.userEnv.actSaveAs.setEnabled(true);
            this.userEnv.actSaveAs.putValue("BSB_HANDLER", this);
            this.tree.setGlobalActions(this.userEnv);
            this.userEnv.disableNodeActions();
            this.setEditMenu(this.userEnv.mbMain.getMenu(1));
            this.tree.checkNodeSelection();
            if (container != this) {
                container.getParent().getParent().getParent().setVisible(true);
            }
        } else if (container != this) {
            container.getParent().getParent().getParent().setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.userEnv.actSaveAs)) {
            File file = this.execEnv.toolSet.getCurFile();
            File file2 = EditHandler.saveFile(file, "ToolSet");
            if (file2 == null) {
                return;
            }
            this.execEnv.toolSet.write(file2);
            if (file2.getAbsoluteFile().equals(file.getAbsoluteFile())) {
                this.isDirty(false);
            }
            return;
        }
        if (actionEvent.getSource().equals(this.userEnv.actSave)) {
            this.saveCur();
            return;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.tree.setViewWidth(component.getWidth());
    }
}

