/*
 * Decompiled with CFR 0.152.
 */
package bsbEdit;

import bsbDocTree.OptionDefTree;
import bsbDocTree.TargetSetTree;
import bsbEdit.EditHandler;
import bsbGui.TargetSetPnl;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TargetSetEdit
extends TargetSetPnl
implements ChangeListener,
ActionListener,
ComponentListener,
PropertyChangeListener {
    private JToolBar tb;
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private TargetSetTree tree;
    private boolean inOptions = false;
    private boolean dirty = false;

    public TargetSetEdit() {
    }

    public TargetSetEdit(UserEnv userEnv) {
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.tree = new TargetSetTree(this.userEnv);
        this.tree.expandRow(0);
        this.tree.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.pnlTree.add(jScrollPane);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.addComponentListener(this);
        this.setComponents();
    }

    public boolean isDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        if (this.userEnv.tbpMain.getSelectedComponent() == this) {
            this.userEnv.actSave.setEnabled(bl);
        }
        this.userEnv.checkDirty();
        return bl2;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void saveCur() {
        File file = this.execEnv.targetSet.getCurFile().getAbsoluteFile();
        this.execEnv.targetSet.write(file);
        this.isDirty(false);
    }

    private void setComponents() {
        this.tb = new JToolBar("Target Set Edit");
        this.tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.populate(this.tb);
        this.tb.setOrientation(1);
        this.add((Component)this.tb, "East");
    }

    private void populate(JToolBar jToolBar) {
        jToolBar.add(this.userEnv.actEdtText).setToolTipText("Edit Text");
        jToolBar.addSeparator();
        jToolBar.add(this.userEnv.actTargetIncNew).setToolTipText("New Target Include");
        jToolBar.add(this.userEnv.actTargetNew).setToolTipText("New Target");
        jToolBar.add(this.userEnv.actOptionDefNew).setToolTipText("New Option Group");
        jToolBar.add(this.userEnv.actTargetRefNew).setToolTipText("New Target Include");
        jToolBar.add(this.userEnv.actTargetDefNew).setToolTipText("New Target Definition");
        jToolBar.add(this.userEnv.actLocNew).setToolTipText("New Location Definition");
        jToolBar.add(this.userEnv.actTargetSourcesNew).setToolTipText("New Target Sources");
        jToolBar.add(this.userEnv.actSourceFilesNew).setToolTipText("New Sourcefile");
        jToolBar.addSeparator();
        jToolBar.add(this.userEnv.actDelete).setToolTipText("Delete Element");
        jToolBar.addSeparator();
        jToolBar.add(this.userEnv.actGenMake).setToolTipText("Generate Makefile");
    }

    private void setEditMenu(JMenu jMenu) {
        jMenu.removeAll();
        jMenu.add(new JMenuItem(this.userEnv.actEdtText));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actTargetIncNew));
        jMenu.add(new JMenuItem(this.userEnv.actTargetNew));
        jMenu.add(new JMenuItem(this.userEnv.actOptionDefNew));
        jMenu.add(new JMenuItem(this.userEnv.actTargetRefNew));
        jMenu.add(new JMenuItem(this.userEnv.actTargetDefNew));
        jMenu.add(new JMenuItem(this.userEnv.actLocNew));
        jMenu.add(new JMenuItem(this.userEnv.actTargetSourcesNew));
        jMenu.add(new JMenuItem(this.userEnv.actSourceFilesNew));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actDelete));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actGenMake));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Container container = this.tb.getParent();
        Component component = this.userEnv.tbpMain.getSelectedComponent();
        if (component == this) {
            this.userEnv.bsbNotification.addPropertyChangeListener(this);
            this.userEnv.disableTabActions();
            this.userEnv.actSave.setEnabled(this.dirty);
            this.userEnv.actSave.putValue("BSB_HANDLER", this);
            this.userEnv.actSaveAs.setEnabled(true);
            this.userEnv.actSaveAs.putValue("BSB_HANDLER", this);
            this.tree.setGlobalActions(this.userEnv);
            this.userEnv.disableNodeActions();
            if (!this.inOptions) {
                this.setEditMenu(this.userEnv.mbMain.getMenu(1));
            } else {
                OptionDefTree.setEditMenu(this.userEnv.mbMain.getMenu(1), this.userEnv);
            }
            this.tree.checkNodeSelection();
            if (container != this) {
                container.getParent().getParent().getParent().setVisible(true);
            }
        } else {
            this.userEnv.bsbNotification.removePropertyChangeListener(this);
            if (container != this) {
                container.getParent().getParent().getParent().setVisible(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.userEnv.actSaveAs)) {
            File file = this.execEnv.targetSet.getCurFile();
            File file2 = EditHandler.saveFile(file, "TargetSet");
            if (file2 == null) {
                return;
            }
            this.execEnv.targetSet.write(file2);
            if (file2.getAbsoluteFile().equals(file.getAbsoluteFile())) {
                this.isDirty(false);
            }
            return;
        }
        if (actionEvent.getSource().equals(this.userEnv.actSave)) {
            this.saveCur();
            return;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.tree.setViewWidth(component.getWidth());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("TargetSetToolBar")) {
            String string = (String)propertyChangeEvent.getNewValue();
            this.tb.removeAll();
            this.tb.validate();
            this.tb.repaint();
            if (string.equals("OPTION")) {
                this.inOptions = true;
                OptionDefTree.populate(this.tb, this.userEnv);
                OptionDefTree.setEditMenu(this.userEnv.mbMain.getMenu(1), this.userEnv);
            } else if (string.equals("TARGET")) {
                this.inOptions = false;
                this.populate(this.tb);
                this.setEditMenu(this.userEnv.mbMain.getMenu(1));
            }
        }
    }
}

