/*
 * Decompiled with CFR 0.152.
 */
package bsbEdit;

import bsbDocTree.SettingsTree;
import bsbEdit.EditHandler;
import bsbGui.SettingsPnl;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SettingsEdit
extends SettingsPnl
implements ChangeListener,
ActionListener {
    private JToolBar tb;
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private SettingsTree tree;
    private boolean dirty = false;

    public SettingsEdit() {
    }

    public SettingsEdit(UserEnv userEnv) {
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.tree = new SettingsTree(this.userEnv);
        this.tree.expandRow(0);
        this.tree.setEditable(false);
        this.pnlTree.add(new JScrollPane(this.tree));
        this.setComponents();
        this.stateChanged(null);
    }

    public boolean isDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        if (this.userEnv.tbpMain.getSelectedComponent() == this) {
            this.userEnv.actSave.setEnabled(bl);
        }
        this.userEnv.checkDirty();
        return bl2;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void saveCur() {
        File file = this.execEnv.settings.getCurFile().getAbsoluteFile();
        this.execEnv.settings.write(file);
        this.isDirty(false);
    }

    private void setComponents() {
        this.tb = new JToolBar("Settings Edit");
        this.tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.tb.add(this.userEnv.actEdtText).setToolTipText("Edit Text");
        this.tb.addSeparator();
        this.tb.add(this.userEnv.actEdtDir).setToolTipText("Change Directory");
        this.tb.add(this.userEnv.actSelDir).setToolTipText("Select From History");
        this.tb.addSeparator();
        this.tb.add(this.userEnv.actFlipAbsRel).setToolTipText("Absolute / Relative");
        this.tb.addSeparator();
        this.tb.add(this.userEnv.actDelete).setToolTipText("Delete History Entry");
        this.tb.setOrientation(1);
        this.add((Component)this.tb, "East");
    }

    private void setEditMenu(JMenu jMenu) {
        jMenu.removeAll();
        jMenu.add(new JMenuItem(this.userEnv.actEdtText));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actEdtDir));
        jMenu.add(new JMenuItem(this.userEnv.actSelDir));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actFlipAbsRel));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actDelete));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Container container = this.tb.getParent();
        Component component = this.userEnv.tbpMain.getSelectedComponent();
        if (changeEvent == null || component == this) {
            this.userEnv.disableTabActions();
            this.userEnv.actOpen.setEnabled(true);
            this.userEnv.actOpen.putValue("BSB_HANDLER", this);
            this.userEnv.actSave.setEnabled(this.dirty);
            this.userEnv.actSave.putValue("BSB_HANDLER", this);
            this.userEnv.actSaveAs.setEnabled(true);
            this.userEnv.actSaveAs.putValue("BSB_HANDLER", this);
            this.tree.setGlobalActions(this.userEnv);
            this.userEnv.disableNodeActions();
            this.setEditMenu(this.userEnv.mbMain.getMenu(1));
            this.tree.checkNodeSelection();
            if (container != this) {
                container.getParent().getParent().getParent().setVisible(true);
            }
        } else if (container != this) {
            container.getParent().getParent().getParent().setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.userEnv.actOpen)) {
            File file = EditHandler.selectFile(this.execEnv.settings.getCurFile(), "BuSyB Settings");
            if (file == null) {
                return;
            }
            this.userEnv.reload(this.userEnv.settingsEdit, file);
            return;
        }
        if (actionEvent.getSource().equals(this.userEnv.actSaveAs)) {
            File file = EditHandler.saveFile(this.execEnv.settings.getCurFile(), "BuSyB Settings");
            if (file == null) {
                return;
            }
            this.execEnv.settings.write(file);
            this.userEnv.reload(this, file);
            return;
        }
        if (actionEvent.getSource().equals(this.userEnv.actSave)) {
            this.saveCur();
            return;
        }
    }
}

