/*
 * Decompiled with CFR 0.152.
 */
package bsbEdit;

import bsbDocTree.PathSetTree;
import bsbEdit.EditHandler;
import bsbGui.PathSetPnl;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PathSetEdit
extends PathSetPnl
implements ChangeListener,
ActionListener,
ComponentListener {
    private JToolBar tb;
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private PathSetTree tree;
    private boolean dirty = false;

    public PathSetEdit() {
    }

    public PathSetEdit(UserEnv userEnv) {
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.tree = new PathSetTree(this.userEnv);
        this.tree.expandRow(0);
        this.tree.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.pnlTree.add(jScrollPane);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.addComponentListener(this);
        this.setComponents();
    }

    public boolean isDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        if (this.userEnv.tbpMain.getSelectedComponent() == this) {
            this.userEnv.actSave.setEnabled(bl);
        }
        this.userEnv.checkDirty();
        return bl2;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void saveCur() {
        File file = this.execEnv.pathSet.getCurFile().getAbsoluteFile();
        this.execEnv.pathSet.write(file);
        this.isDirty(false);
    }

    private void setComponents() {
        this.tb = new JToolBar("Path Set Edit");
        this.tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.tb.add(this.userEnv.actEdtText).setToolTipText("Edit Text");
        this.tb.addSeparator();
        this.tb.add(this.userEnv.actPathIncNew).setToolTipText("Include PathSet");
        this.tb.add(this.userEnv.actPathTreeNew).setToolTipText("Add Path Tree");
        this.tb.add(this.userEnv.actLocNew).setToolTipText("Add Location");
        this.tb.addSeparator();
        this.tb.add(this.userEnv.actFlipAbsRel).setToolTipText("Absolute / Relative");
        this.tb.addSeparator();
        this.tb.add(this.userEnv.actDelete).setToolTipText("Delete Path");
        this.tb.setOrientation(1);
        this.add((Component)this.tb, "East");
    }

    private void setEditMenu(JMenu jMenu) {
        jMenu.removeAll();
        jMenu.add(new JMenuItem(this.userEnv.actEdtText));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actPathIncNew));
        jMenu.add(new JMenuItem(this.userEnv.actPathTreeNew));
        jMenu.add(new JMenuItem(this.userEnv.actLocNew));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actFlipAbsRel));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actDelete));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Container container = this.tb.getParent();
        Component component = this.userEnv.tbpMain.getSelectedComponent();
        if (component == this) {
            this.userEnv.disableTabActions();
            this.userEnv.actSave.setEnabled(this.dirty);
            this.userEnv.actSave.putValue("BSB_HANDLER", this);
            this.userEnv.actSaveAs.setEnabled(true);
            this.userEnv.actSaveAs.putValue("BSB_HANDLER", this);
            this.tree.setGlobalActions(this.userEnv);
            this.userEnv.disableNodeActions();
            this.setEditMenu(this.userEnv.mbMain.getMenu(1));
            this.tree.checkNodeSelection();
            if (container != this) {
                container.getParent().getParent().getParent().setVisible(true);
            }
        } else if (container != this) {
            container.getParent().getParent().getParent().setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.userEnv.actSaveAs)) {
            File file = this.execEnv.pathSet.getCurFile();
            File file2 = EditHandler.saveFile(file, "PathSet");
            if (file2 == null) {
                return;
            }
            this.execEnv.pathSet.write(file2);
            if (file2.getAbsoluteFile().equals(file.getAbsoluteFile())) {
                this.isDirty(false);
            }
            return;
        }
        if (actionEvent.getSource().equals(this.userEnv.actSave)) {
            this.saveCur();
            return;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.tree.setViewWidth(component.getWidth());
    }
}

