/*
 * Decompiled with CFR 0.152.
 */
package bsbEdit;

import bsbDocTree.OptionDefTree;
import bsbDocTree.OptionSetTree;
import bsbEdit.EditHandler;
import bsbGui.OptionSetPnl;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OptionSetEdit
extends OptionSetPnl
implements ChangeListener,
ActionListener,
ComponentListener {
    private JToolBar tb;
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private OptionSetTree tree;
    private boolean dirty = false;

    public OptionSetEdit() {
    }

    public OptionSetEdit(UserEnv userEnv) {
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.tree = new OptionSetTree(this.userEnv);
        this.tree.expandRow(0);
        this.tree.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.pnlTree.add(jScrollPane);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.addComponentListener(this);
        this.setComponents();
    }

    public boolean isDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        if (this.userEnv.tbpMain.getSelectedComponent() == this) {
            this.userEnv.actSave.setEnabled(bl);
        }
        this.userEnv.checkDirty();
        return bl2;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void saveCur() {
        File file = this.execEnv.optionSet.getCurFile().getAbsoluteFile();
        this.execEnv.optionSet.write(file);
        this.isDirty(false);
    }

    private void setComponents() {
        this.tb = new JToolBar("Option Set Edit");
        this.tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        OptionDefTree.populate(this.tb, this.userEnv);
        this.tb.setOrientation(1);
        this.add((Component)this.tb, "East");
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Container container = this.tb.getParent();
        Component component = this.userEnv.tbpMain.getSelectedComponent();
        if (component == this) {
            this.userEnv.disableTabActions();
            this.userEnv.actSave.setEnabled(this.dirty);
            this.userEnv.actSave.putValue("BSB_HANDLER", this);
            this.userEnv.actSaveAs.setEnabled(true);
            this.userEnv.actSaveAs.putValue("BSB_HANDLER", this);
            this.tree.setGlobalActions(this.userEnv);
            this.userEnv.disableNodeActions();
            OptionDefTree.setEditMenu(this.userEnv.mbMain.getMenu(1), this.userEnv);
            this.tree.checkNodeSelection();
            if (container != this) {
                container.getParent().getParent().getParent().setVisible(true);
            }
        } else if (container != this) {
            container.getParent().getParent().getParent().setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.userEnv.actSaveAs)) {
            File file = this.execEnv.optionSet.getCurFile();
            File file2 = EditHandler.saveFile(file, "OptionSet");
            if (file2 == null) {
                return;
            }
            this.execEnv.optionSet.write(file2);
            if (file2.getAbsoluteFile().equals(file.getAbsoluteFile())) {
                this.isDirty(false);
            }
            return;
        }
        if (actionEvent.getSource().equals(this.userEnv.actSave)) {
            this.saveCur();
            return;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.tree.setViewWidth(component.getWidth());
    }
}

