/*
 * Decompiled with CFR 0.152.
 */
package bsbEdit;

import bsbDocTree.DocNode;
import bsbDocTree.DocTree;
import bsbException.External;
import bsbMain.Globals;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.JFileChooser;

public abstract class EditHandler
implements ActionListener {
    private DocNode myNode;

    public void node(DocNode docNode) {
        this.myNode = docNode;
    }

    public DocNode node() {
        return this.myNode;
    }

    public void editText(DocTree docTree) {
        docTree.setEditable(true);
        docTree.startEditingAtPath(docTree.getSelectionPath());
    }

    public static File selectDir(File file, String string) {
        String string2 = "Select" + (string != null && string.length() > 0 ? " " + string : "") + " Folder";
        return EditHandler.chooseFile(file, 1, string2);
    }

    public static File selectFile(File file, String string) {
        String string2 = "Select" + (string != null && string.length() > 0 ? " " + string : "") + " File";
        return EditHandler.chooseFile(file, 0, string2);
    }

    public static File selectPath(File file, String string) {
        String string2 = "Select" + (string != null && string.length() > 0 ? " " + string : "") + " File or Folder";
        return EditHandler.chooseFile(file, 2, string2);
    }

    public static File chooseFile(File file, int n, String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(n);
        if (!file.isDirectory()) {
            jFileChooser.setSelectedFile(file);
            file = file.getParentFile();
        }
        jFileChooser.setCurrentDirectory(file);
        int n2 = jFileChooser.showDialog(null, "OK");
        File file2 = jFileChooser.getSelectedFile();
        if (file2 == null || n2 != 0) {
            return null;
        }
        return file2;
    }

    public static File saveFile(File file, String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save " + string + " File");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(file);
        int n = jFileChooser.showSaveDialog(null);
        File file2 = jFileChooser.getSelectedFile();
        if (file2 == null || n != 0) {
            return null;
        }
        return file2;
    }

    public static String relativePath(File file, String string) {
        String string2;
        String string3;
        String string4 = "";
        if (file.isFile()) {
            file = file.getAbsoluteFile().getParentFile();
        }
        try {
            if (Globals.useCanonical) {
                string3 = file.getCanonicalPath();
                string2 = new File(string).getCanonicalPath();
            } else {
                string3 = Globals.compact(file.getAbsoluteFile());
                string2 = Globals.compact(new File(string).getAbsoluteFile());
            }
        }
        catch (Exception exception) {
            new External(exception).handle();
            return null;
        }
        while (string3.length() > 0 && !string2.startsWith(string3 + File.separator)) {
            string4 = string4 + ".." + File.separator;
            int n = string3.lastIndexOf(File.separator);
            if (n < 0) {
                return new File(string2).getPath();
            }
            string3 = string3.substring(0, n);
        }
        if (string2.length() > string3.length()) {
            string4 = string4 + string2.substring(string3.length() + 1);
        }
        return new File(string4).getPath();
    }

    public void enable(Action action, ActionListener actionListener) {
        action.setEnabled(true);
        action.putValue("BSB_HANDLER", actionListener);
    }

    public abstract void selected();

    public abstract void actionPerformed(ActionEvent var1);

    public void changed() {
    }
}

