/*
 * Decompiled with CFR 0.152.
 */
package bsbEdit;

import bsbDocTree.ConfigSetTree;
import bsbEdit.EditHandler;
import bsbGui.ConfigSetPnl;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConfigSetEdit
extends ConfigSetPnl
implements ChangeListener,
ActionListener,
ComponentListener {
    private JToolBar tb;
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private ConfigSetTree tree;
    private boolean dirty = false;

    public ConfigSetEdit() {
    }

    public ConfigSetEdit(UserEnv userEnv) {
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.tree = new ConfigSetTree(this.userEnv);
        this.tree.expandRow(0);
        this.tree.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.pnlTree.add(jScrollPane);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.addComponentListener(this);
        this.setComponents();
    }

    public boolean isDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        if (this.userEnv.tbpMain.getSelectedComponent() == this) {
            this.userEnv.actSave.setEnabled(bl);
        }
        this.userEnv.checkDirty();
        return bl2;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void saveCur() {
        File file = this.execEnv.configSet.getCurFile().getAbsoluteFile();
        this.execEnv.configSet.write(file);
        this.isDirty(false);
    }

    private void setComponents() {
        this.tb = new JToolBar("Config Set Edit");
        this.tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.tb.add(this.userEnv.actEdtText).setToolTipText("Edit Text");
        this.tb.addSeparator();
        this.tb.add(this.userEnv.actPropertyGroupNew).setToolTipText("New Property Group");
        this.tb.add(this.userEnv.actPropertySetNew).setToolTipText("New Property");
        this.tb.add(this.userEnv.actValueSetNew).setToolTipText("Add Property Value");
        this.tb.addSeparator();
        this.tb.add(this.userEnv.actDelete).setToolTipText("Delete Element");
        this.tb.setOrientation(1);
        this.add((Component)this.tb, "East");
    }

    private void setEditMenu(JMenu jMenu) {
        jMenu.removeAll();
        jMenu.add(new JMenuItem(this.userEnv.actEdtText));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actPropertyGroupNew));
        jMenu.add(new JMenuItem(this.userEnv.actPropertySetNew));
        jMenu.add(new JMenuItem(this.userEnv.actValueSetNew));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.userEnv.actDelete));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JTabbedPane) {
            Container container = this.tb.getParent();
            Component component = this.userEnv.tbpMain.getSelectedComponent();
            if (component == this) {
                this.userEnv.disableTabActions();
                this.userEnv.actSave.setEnabled(this.dirty);
                this.userEnv.actSave.putValue("BSB_HANDLER", this);
                this.userEnv.actSaveAs.setEnabled(true);
                this.userEnv.actSaveAs.putValue("BSB_HANDLER", this);
                this.tree.setGlobalActions(this.userEnv);
                this.userEnv.disableNodeActions();
                this.setEditMenu(this.userEnv.mbMain.getMenu(1));
                this.tree.checkNodeSelection();
                if (container != this) {
                    container.getParent().getParent().getParent().setVisible(true);
                }
            } else if (container != this) {
                container.getParent().getParent().getParent().setVisible(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.userEnv.actSaveAs)) {
            File file = this.execEnv.configSet.getCurFile();
            File file2 = EditHandler.saveFile(file, "ConfigSet");
            if (file2 == null) {
                return;
            }
            this.execEnv.configSet.write(file2);
            if (file2.getAbsoluteFile().equals(file.getAbsoluteFile())) {
                this.isDirty(false);
            }
            return;
        }
        if (actionEvent.getSource().equals(this.userEnv.actSave)) {
            this.saveCur();
            return;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.tree.setViewWidth(component.getWidth());
    }
}

