/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocCls.Args;
import bsbDocCls.Command;
import bsbDocCls.Executable;
import bsbDocCls.Flag;
import bsbDocCls.Preamble;
import bsbDocCls.Preambles;
import bsbDocCls.Supports;
import bsbDocCls.Tool;
import bsbDocCls.ToolSet;
import bsbDocExt.ToolSetExt;
import bsbDocTree.DocEditor;
import bsbDocTree.DocNode;
import bsbDocTree.DocRenderer;
import bsbDocTree.DocTree;
import bsbEdit.EditHandler;
import bsbIcons.IconServer;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import bsbUtil.BsbList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreePath;

public class ToolSetTree
extends DocTree
implements TreeModelListener,
TreeSelectionListener {
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private ToolSetExt dx;
    private IconServer is;
    private DocTree thisTree;
    private TreePath rp;
    private Renderer renderer;

    public ToolSetTree(UserEnv userEnv) {
        super(userEnv.execEnv.toolSet.getName(), userEnv.execEnv.toolSet);
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.dx = this.execEnv.toolSet;
        this.is = this.userEnv.is;
        this.thisTree = this;
        this.setupNodes();
        this.renderer = new Renderer();
        this.setCellRenderer(this.renderer);
        Editor editor = new Editor();
        this.setCellEditor(new DefaultTreeCellEditor(this, this.renderer, editor));
        this.getModel().addTreeModelListener(this);
        this.addTreeSelectionListener(this);
    }

    public String getName() {
        return this.dx.getName();
    }

    protected void setupNodes() {
        DocNode docNode = this.getRoot();
        docNode.icon(this.is.doc).style(1).handler(new ehToolSetName());
        DocNode docNode2 = this.add(null, this.dx.getDescription(), this.dx, false);
        docNode2.icon(this.is.descr).style(2).handler(new ehToolSetDescr());
        this.add(docNode2, this.dx.getCurFile().getAbsolutePath(), this.dx, false).icon(this.is.locAbs);
        BsbList bsbList = this.dx.getPreambles();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((Preambles)listIterator.next(), docNode, docNode.getChildCount(), true);
        }
        BsbList bsbList2 = this.dx.getTool();
        ListIterator listIterator2 = bsbList2.listIterator();
        while (listIterator2.hasNext()) {
            this.insertElement((Tool)listIterator2.next(), docNode, docNode.getChildCount(), true);
        }
    }

    private DocNode insertElement(Preambles preambles, DocNode docNode, int n, boolean bl) {
        String string = preambles.getDescription() + "::";
        String string2 = preambles.getRequire();
        string = string + (string2 == null ? "" : string2);
        DocNode docNode2 = new DocNode(string, preambles);
        docNode2.icon(this.is.preambles).handler(new ehPreambles()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        BsbList bsbList = preambles.getPreamble();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            DocNode docNode3 = new DocNode(((Preamble)listIterator.next()).getValue(), preambles);
            docNode3.icon(this.is.preamble).handler(new ehPreamble());
            this.insert(docNode2.getChildCount(), docNode2, docNode3, false);
        }
        return docNode2;
    }

    private DocNode insertElement(Tool tool, DocNode docNode, int n, boolean bl) {
        String string = tool.getName() + "::" + tool.getDescription() + "::";
        if (tool.getSingleRun() != null) {
            string = string + "true";
        }
        DocNode docNode2 = new DocNode(string, tool);
        docNode2.icon(this.is.tool).handler(new ehTool()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        BsbList bsbList = tool.getCommand();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((Command)listIterator.next(), docNode2, docNode2.getChildCount(), false);
        }
        return docNode2;
    }

    private DocNode insertElement(Command command, DocNode docNode, int n, boolean bl) {
        String string = command.getName() + "::" + command.getDescription() + "::";
        String string2 = command.getRequire();
        string = string + (string2 == null ? "" : string2);
        DocNode docNode2 = new DocNode(string, command);
        docNode2.icon(this.is.command).handler(new ehCommand()).isSpecialRender(true);
        docNode = this.insert(n, docNode, docNode2, bl);
        n = 0;
        this.insertElement(command.getExecutable(), docNode, n, false);
        BsbList bsbList = command.getSupports();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((Supports)listIterator.next(), docNode, docNode.getChildCount(), false);
        }
        bsbList = command.getArgs();
        listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((Args)listIterator.next(), docNode, docNode.getChildCount(), false);
        }
        String string3 = command.getModifier();
        if (string3 != null && string3.length() > 0) {
            this.add(docNode, string3, command, false).icon(this.is.cmdMod).handler(new ehCmdMod());
        }
        return docNode2;
    }

    private DocNode insertElement(Executable executable, DocNode docNode, int n, boolean bl) {
        String string;
        String string2;
        String string3 = executable.getPathRef();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = executable.getPath()) == null) {
            string2 = "";
        }
        if ((string = executable.getToolRef()) == null) {
            string = "";
        }
        String string4 = string3 + "::" + string2 + "::" + string;
        DocNode docNode2 = new DocNode(string4, executable);
        docNode2.icon(this.is.executable).handler(new ehExecutable()).isSpecialRender(true);
        docNode = this.insert(n, docNode, docNode2, bl);
        n = 0;
        BsbList bsbList = executable.getFlag();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((Flag)listIterator.next(), docNode, docNode.getChildCount(), false);
        }
        return docNode2;
    }

    private DocNode insertElement(Supports supports, DocNode docNode, int n, boolean bl) {
        String string = supports.getOption() + "::" + supports.getFlag() + "::";
        String string2 = supports.getRequire();
        string = string + (string2 == null ? "" : string2);
        DocNode docNode2 = new DocNode(string, supports);
        docNode2.icon(this.is.supports).handler(new ehSupports()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private DocNode insertElement(Args args, DocNode docNode, int n, boolean bl) {
        String string = args.getTemplate() + "::";
        String string2 = args.getRequire();
        string = string + (string2 == null ? "" : string2);
        DocNode docNode2 = new DocNode(string, args);
        docNode2.icon(this.is.args).handler(new ehArgs()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private DocNode insertElement(Flag flag, DocNode docNode, int n, boolean bl) {
        String string;
        String string2;
        String string3 = flag.getValueRef();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = flag.get_Value()) == null) {
            string2 = "";
        }
        if ((string = flag.getRequire()) == null) {
            string = "";
        }
        String string4 = string3 + "::" + string2 + "::" + string;
        DocNode docNode2 = new DocNode(string4, flag);
        docNode2.icon(this.is.flags).handler(new ehFlag()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private void newPreambles(DocNode docNode, DocNode docNode2) {
        this.newPreambles(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newPreambles(DocNode docNode, int n) {
        Preambles preambles = new Preambles();
        preambles.setDescription("Preamble Set Description");
        preambles.setRequire("");
        Preamble preamble = new Preamble();
        preamble.appendChild("Preamble");
        preambles.getPreamble().add(preamble);
        this.dx.getPreambles().add(n - 1, preambles);
        docNode = this.insertElement(preambles, docNode, n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newPreamble(DocNode docNode, DocNode docNode2) {
        this.newPreamble(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newPreamble(DocNode docNode, int n) {
        Preambles preambles = (Preambles)docNode.content();
        String string = "-Preamble-";
        Preamble preamble = new Preamble();
        preamble.appendChild(string);
        preambles.getPreamble().add(n, preamble);
        DocNode docNode2 = new DocNode(string, preambles);
        docNode2.icon(this.is.preamble).handler(new ehPreamble());
        this.insert(n, docNode, docNode2, true);
        TreePath treePath = new TreePath(docNode2.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newTool(DocNode docNode, DocNode docNode2) {
        this.newTool(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newTool(DocNode docNode, int n) {
        Executable executable = new Executable();
        executable.setPathRef("pathRef");
        executable.setPath("path");
        executable.setToolRef("");
        Command command = new Command();
        command.setName("command");
        command.setDescription("description");
        command.setRequire("");
        command.setExecutable(executable);
        Tool tool = new Tool();
        tool.setName("tool");
        tool.setDescription("Tool Description");
        tool.getCommand().add(command);
        this.dx.getTool().add(n - this.dx.getPreambles().size() - 1, tool);
        docNode = this.insertElement(tool, docNode, n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newCommand(DocNode docNode, DocNode docNode2) {
        this.newCommand(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newCommand(DocNode docNode, int n) {
        Executable executable = new Executable();
        executable.setPathRef("pathRef");
        executable.setPath("path");
        Command command = new Command();
        command.setName("command");
        command.setDescription("description");
        command.setRequire("");
        command.setExecutable(executable);
        ((Tool)docNode.content()).getCommand().add(n, command);
        docNode = this.insertElement(command, docNode, n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newSupports(DocNode docNode, DocNode docNode2) {
        int n = 0;
        if (docNode2 != null) {
            n = docNode.getIndex(docNode2);
        }
        int n2 = n + 1;
        this.newSupports(docNode, n, n2);
    }

    private void newSupports(DocNode docNode, int n, int n2) {
        Supports supports = new Supports();
        supports.setOption("Option");
        supports.setFlag("flag");
        supports.setRequire("require");
        ((Command)docNode.content()).getSupports().add(n, supports);
        docNode = this.insertElement(supports, docNode, n2, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newArgs(DocNode docNode, DocNode docNode2) {
        int n = 0;
        Command command = (Command)docNode.content();
        int n2 = command.getSupports().size();
        if (docNode2 != null) {
            n = docNode.getIndex(docNode2) - n2;
        }
        int n3 = n + 1 + n2;
        this.newArgs(docNode, n, n3);
    }

    private void newArgs(DocNode docNode, int n, int n2) {
        Args args = new Args();
        args.setTemplate("arguments");
        args.setRequire("require");
        ((Command)docNode.content()).getArgs().add(n, args);
        docNode = this.insertElement(args, docNode, n2, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newModifier(DocNode docNode, DocNode docNode2) {
        this.newModifier(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newModifier(DocNode docNode, int n) {
        Command command = (Command)docNode.content();
        command.setModifier("-modify-");
        DocNode docNode2 = new DocNode(command.getModifier(), command);
        docNode2.icon(this.is.cmdMod).handler(new ehCmdMod());
        docNode = this.insert(n, docNode, docNode2, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newFlag(DocNode docNode, DocNode docNode2) {
        this.newFlag(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newFlag(DocNode docNode, int n) {
        Flag flag = new Flag();
        flag.setValueRef("value reference");
        flag.set_Value("value");
        flag.setRequire("require");
        ((Executable)docNode.content()).getFlag().add(n, flag);
        docNode = this.insertElement(flag, docNode, n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private Object deleteElement(DocNode docNode) {
        Object object;
        Object object2 = docNode.content();
        if (object2 == (object = ((DocNode)docNode.getParent()).content())) {
            object2 = docNode.getUserObject();
        }
        this.dx.deleteElement(object, object2);
        this.deleteNode(docNode);
        return object;
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.userEnv.toolSetEdit.isDirty(true);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.userEnv.toolSetEdit.isDirty(true);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.userEnv.toolSetEdit.isDirty(true);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.setEditable(false);
        DocNode docNode = (DocNode)this.getLastSelectedPathComponent();
        if (docNode != null) {
            docNode.handler().changed();
        }
        this.treeUpdate(this.dx.getName());
        this.userEnv.toolSetEdit.isDirty(true);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.userEnv.disableNodeActions();
        this.checkNodeSelection();
        this.setEditable(false);
    }

    private class Editor
    extends DocEditor {
        private Component[] car;
        private JTextField tf1 = new JTextField();
        private JTextField tf2 = new JTextField();
        private JTextField tf3 = new JTextField();
        private JComboBox cb1;
        private JComboBox cb2;
        private JCheckBox ch1;

        public Editor() {
            this.tf1.addKeyListener(this);
            this.tf2.addKeyListener(this);
            this.tf3.addKeyListener(this);
        }

        protected Component nodeEditor(DocTree docTree, DocNode docNode, boolean bl, boolean bl2, boolean bl3, int n) {
            if (!docNode.isSpecialRender()) {
                return super.nodeEditor(docTree, docNode, bl, bl2, bl3, n);
            }
            this.car = ((JComponent)docTree.getCellRenderer().getTreeCellRendererComponent(docTree, docNode, bl, bl2, bl3, n, true)).getComponents();
            this.nodePanel.removeAll();
            String string = (String)docNode.getUserObject();
            int n2 = ((ToolSetTree)ToolSetTree.this).renderer.getPreferredSize().height;
            if (docNode.content() instanceof Preambles) {
                this.editPreambles(string);
            } else if (docNode.content() instanceof Tool) {
                this.editTool(string);
            } else if (docNode.content() instanceof Command) {
                this.editCommand(string);
            } else if (docNode.content() instanceof Executable) {
                this.editExecutable(string);
            } else if (docNode.content() instanceof Supports) {
                this.editSupports(string);
            } else if (docNode.content() instanceof Args) {
                this.editArgs(string);
            } else if (docNode.content() instanceof Flag) {
                this.editFlag(string);
            } else {
                return super.nodeEditor(docTree, docNode, bl, bl2, bl3, n);
            }
            return this.nodePanel;
        }

        protected Object nodeValue() {
            if (!this.curNode.isSpecialRender()) {
                return super.nodeValue();
            }
            if (this.curNode.content() instanceof Preambles) {
                return this.tf1.getText() + "::" + this.tf2.getText();
            }
            if (this.curNode.content() instanceof Tool) {
                return this.tf1.getText() + "::" + this.tf2.getText() + "::" + (this.ch1.isSelected() ? "true" : "");
            }
            if (this.curNode.content() instanceof Command) {
                return this.tf1.getText() + "::" + this.tf3.getText() + "::" + this.tf2.getText();
            }
            if (this.curNode.content() instanceof Executable) {
                return this.cb1.getSelectedItem() + "::" + this.tf1.getText() + "::" + this.cb2.getSelectedItem();
            }
            if (this.curNode.content() instanceof Supports) {
                return this.cb1.getSelectedItem() + "::" + this.tf1.getText() + "::" + this.tf2.getText();
            }
            if (this.curNode.content() instanceof Args) {
                return this.tf1.getText() + "::" + this.tf2.getText();
            }
            if (this.curNode.content() instanceof Flag) {
                return this.cb1.getSelectedItem() + "::" + this.tf1.getText() + "::" + this.tf2.getText();
            }
            return super.nodeValue();
        }

        private void editPreambles(String string) {
            JLabel jLabel = (JLabel)this.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            this.nodePanel.add(this.car[2]);
            jLabel = (JLabel)this.car[3];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
        }

        private void editTool(String string) {
            JLabel jLabel = (JLabel)this.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            jLabel = (JLabel)this.car[2];
            this.ch1 = new JCheckBox("SingleRun", jLabel.getText().length() > 0);
            this.ch1.setFont(jLabel.getFont());
            this.ch1.setOpaque(false);
            this.ch1.setHorizontalTextPosition(2);
            this.ch1.addKeyListener(this);
            this.ch1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.ch1);
            this.nodePanel.add(this.car[3]);
            jLabel = (JLabel)this.car[4];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
        }

        private void editCommand(String string) {
            JLabel jLabel = (JLabel)this.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            this.nodePanel.add(this.car[2]);
            jLabel = (JLabel)this.car[3];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
            this.nodePanel.add(this.car[4]);
            jLabel = (JLabel)this.car[5];
            this.tf3.setText(jLabel.getText());
            this.tf3.setFont(jLabel.getFont());
            this.tf3.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf3);
        }

        private void editExecutable(String string) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    File file2;
                    String string = (String)cb1.getSelectedItem();
                    if (string.length() > 0) {
                        string = ((ToolSetTree)((Editor)this).ToolSetTree.this).execEnv.pathSet.fullPath(string);
                    }
                    if ((file2 = EditHandler.selectFile(file = string != null && string.length() > 0 ? new File(string) : null, "executable")) != null) {
                        string = file2.getPath();
                        if (file != null) {
                            string = EditHandler.relativePath(file, string);
                        }
                        tf1.setText(string);
                        tf1.requestFocusInWindow();
                    }
                }
            };
            JLabel jLabel = (JLabel)this.car[2];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[3];
            Vector vector = ((ToolSetTree)ToolSetTree.this).execEnv.pathSet.getList()[0];
            vector.add("");
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.cb1.setPreferredSize(dimension);
            this.nodePanel.add(this.cb1);
            Icon icon = jLabel.getText().length() > 0 ? ((ToolSetTree)ToolSetTree.this).is.locRel : ((ToolSetTree)ToolSetTree.this).is.locAbs;
            JButton jButton = new JButton(icon);
            jButton.setPreferredSize(new Dimension(ToolSetTree.this.icnw, ToolSetTree.this.icnw));
            jButton.addActionListener(actionListener);
            this.nodePanel.add(jButton);
            jLabel = (JLabel)this.car[5];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            this.tf1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf1);
            jLabel = (JLabel)this.car[7];
            List list = ToolSetTree.this.dx.getToolNames();
            list.add("");
            this.cb2 = new JComboBox<Object>(list.toArray());
            this.cb2.setSelectedItem(jLabel.getText());
            this.cb2.addKeyListener(this);
            this.cb2.setFont(jLabel.getFont());
            dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.cb2.setPreferredSize(dimension);
            this.nodePanel.add(this.cb2);
        }

        private void editSupports(String string) {
            JLabel jLabel = (JLabel)this.car[1];
            Vector vector = ((ToolSetTree)ToolSetTree.this).execEnv.optionSet.getCondValueList()[0];
            if (!vector.contains(jLabel.getText())) {
                vector.add(0, jLabel.getText());
            }
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            this.cb1.setEditable(true);
            this.cb1.getEditor().getEditorComponent().addKeyListener(this);
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.cb1.setPreferredSize(dimension);
            this.nodePanel.add(this.cb1);
            this.nodePanel.add(this.car[2]);
            jLabel = (JLabel)this.car[3];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            this.tf1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf1);
            this.nodePanel.add(this.car[4]);
            jLabel = (JLabel)this.car[5];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
        }

        private void editArgs(String string) {
            JLabel jLabel = (JLabel)this.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            this.nodePanel.add(this.car[2]);
            jLabel = (JLabel)this.car[3];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
        }

        private void editFlag(String string) {
            JLabel jLabel = (JLabel)this.car[2];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[3];
            Vector vector = ((ToolSetTree)ToolSetTree.this).execEnv.optionSet.getCondValueList()[0];
            vector.add(0, "");
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.cb1.setPreferredSize(dimension);
            this.nodePanel.add(this.cb1);
            this.nodePanel.add(this.car[4]);
            jLabel = (JLabel)this.car[5];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            this.tf1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf1);
            this.nodePanel.add(this.car[6]);
            jLabel = (JLabel)this.car[7];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
        }
    }

    private class Renderer
    extends DocRenderer {
        int vw;
        int sx1;
        int sx2;
        int sx3;
        int sx4;

        public Renderer() {
            super(ToolSetTree.this.fontDefault);
        }

        protected Component nodeRenderer(DocNode docNode, boolean bl) {
            if (!docNode.isSpecialRender()) {
                return super.nodeRenderer(docNode, bl);
            }
            this.vw = ToolSetTree.this.viewWidth / 10;
            this.sx1 = this.vw * 3 - docNode.getLevel() * 20;
            this.sx2 = this.vw * 2;
            this.sx3 = this.vw * 2;
            this.sx4 = this.vw * 3 - 15;
            this.nodePanel.removeAll();
            String string = (String)docNode.getUserObject();
            if (docNode.content() instanceof Preambles) {
                this.renderPreambles(docNode, string);
            }
            if (docNode.content() instanceof Tool) {
                this.renderTool(docNode, string);
            } else if (docNode.content() instanceof Command) {
                this.renderCommand(docNode, string);
            } else if (docNode.content() instanceof Executable) {
                this.renderExecutable(docNode, string);
            } else if (docNode.content() instanceof Supports) {
                this.renderSupports(docNode, string);
            } else if (docNode.content() instanceof Args) {
                this.renderArgs(docNode, string);
            } else if (docNode.content() instanceof Flag) {
                this.renderFlag(docNode, string);
            }
            this.nodePanel.setOpaque(bl);
            this.setVisible(false);
            this.nodePanel.setVisible(true);
            return this.nodePanel;
        }

        private void renderPreambles(DocNode docNode, String string) {
            int n = string.indexOf("::");
            this.addLabel(docNode.icon(), string.substring(0, n), ToolSetTree.this.fontItalic, this.sx1 + this.sx2 + this.sx3, true);
            string = string.substring(n + 2);
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.require, string, ToolSetTree.this.fontDefault, this.sx4, false);
        }

        private void renderTool(DocNode docNode, String string) {
            int n = string.indexOf("::");
            this.addLabel(docNode.icon(), string.substring(0, n), ToolSetTree.this.fontBold, this.sx1 + this.sx2, true);
            String string2 = string.substring(n + 2);
            n = string2.indexOf("::");
            string = string2.substring(n + 2);
            this.addLabel(null, string.length() > 0 ? "SingleRun" : "", ToolSetTree.this.fontDefault, this.sx3, true);
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.descr, string2.substring(0, n), ToolSetTree.this.fontItalic, this.sx4, true);
        }

        private void renderCommand(DocNode docNode, String string) {
            int n = string.indexOf("::");
            this.addLabel(docNode.icon(), string.substring(0, n), ToolSetTree.this.fontBold, this.sx1 + this.sx2, true);
            String string2 = string.substring(n + 2);
            n = string2.indexOf("::");
            string = string2.substring(n + 2);
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.require, string, ToolSetTree.this.fontDefault, this.sx3, false);
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.descr, string2.substring(0, n), ToolSetTree.this.fontItalic, this.sx4, true);
        }

        private void renderExecutable(DocNode docNode, String string) {
            this.addLabel(docNode.icon(), "", ToolSetTree.this.fontDefault, this.icnw, true);
            int n = 0;
            int n2 = string.indexOf("::");
            String string2 = string.substring(n, n2);
            n = n2 + 2;
            n2 = string.indexOf("::", n);
            String string3 = string.substring(n, n2);
            n = n2 + 2;
            String string4 = string.substring(n);
            int n3 = this.sx1 + (string2.length() > 0 ? this.sx2 : 0);
            int n4 = this.sx3 + (string2.length() > 0 ? 0 : this.sx2);
            int n5 = this.sx4;
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.pathRef, string2, ToolSetTree.this.fontBold, n3 - this.icnw, false);
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.locRel, string3, ToolSetTree.this.fontDefault, n4, false);
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.tool, string4, ToolSetTree.this.fontBold, n5, false);
        }

        private void renderSupports(DocNode docNode, String string) {
            int n = string.indexOf("::");
            this.addLabel(docNode.icon(), string.substring(0, n), ToolSetTree.this.fontBold, this.sx1 + this.sx2, true);
            string = string.substring(n + 2);
            n = string.indexOf("::");
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.flags, string.substring(0, n), ToolSetTree.this.fontDefault, this.sx3, true);
            string = string.substring(n + 2);
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.require, string, ToolSetTree.this.fontDefault, this.sx4, false);
        }

        private void renderArgs(DocNode docNode, String string) {
            int n = string.indexOf("::");
            this.addLabel(docNode.icon(), string.substring(0, n), ToolSetTree.this.fontDefault, this.sx1 + this.sx2 + this.sx3, true);
            string = string.substring(n + 2);
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.require, string, ToolSetTree.this.fontDefault, this.sx4, false);
        }

        private void renderFlag(DocNode docNode, String string) {
            this.addLabel(docNode.icon(), "", ToolSetTree.this.fontDefault, this.icnw, true);
            int n = string.indexOf("::");
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.valueRef, string.substring(0, n), ToolSetTree.this.fontBold, this.sx1 + this.sx2 - this.icnw, false);
            string = string.substring(n + 2);
            n = string.indexOf("::");
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.valueDef, string.substring(0, n), ToolSetTree.this.fontDefault, this.sx3, false);
            string = string.substring(n + 2);
            this.addLabel(((ToolSetTree)ToolSetTree.this).is.require, string, ToolSetTree.this.fontDefault, this.sx4, false);
        }
    }

    private class ehFlag
    extends EditHandler {
        private ehFlag() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actFlagNew, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText)) {
                this.editText(ToolSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actFlagNew)) {
                ToolSetTree.this.newFlag((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actDelete)) {
                ToolSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Flag flag = (Flag)this.node().content();
            int n = 0;
            int n2 = string.indexOf("::");
            flag.setValueRef(string.substring(n, n2));
            n = n2 + 2;
            n2 = string.indexOf("::", n);
            flag.set_Value(string.substring(n, n2));
            n = n2 + 2;
            flag.setRequire(string.substring(n));
        }
    }

    private class ehCmdMod
    extends EditHandler {
        private ehCmdMod() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText)) {
                this.editText(ToolSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actDelete)) {
                ((Command)this.node().content()).setModifier(null);
                ToolSetTree.this.deleteNode(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Command command = (Command)this.node().content();
            command.setModifier(string.length() > 0 ? string : null);
        }
    }

    private class ehArgs
    extends EditHandler {
        private ehArgs() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actArgsNew, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText)) {
                this.editText(ToolSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actArgsNew)) {
                ToolSetTree.this.newArgs((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actDelete)) {
                ToolSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Args args = (Args)this.node().content();
            int n = string.indexOf("::");
            args.setTemplate(string.substring(0, n));
            args.setRequire(string.substring(n + 2));
        }
    }

    private class ehSupports
    extends EditHandler {
        private ehSupports() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actSupportsNew, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText)) {
                this.editText(ToolSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actSupportsNew)) {
                ToolSetTree.this.newSupports((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actDelete)) {
                ToolSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Supports supports = (Supports)this.node().content();
            int n = 0;
            int n2 = string.indexOf("::");
            supports.setOption(string.substring(n, n2));
            n = n2 + 2;
            n2 = string.indexOf("::", n);
            supports.setFlag(string.substring(n, n2));
            n = n2 + 2;
            supports.setRequire(string.substring(n));
        }
    }

    private class ehExecutable
    extends EditHandler {
        private ehExecutable() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actFlagNew, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText)) {
                this.editText(ToolSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actFlagNew)) {
                ToolSetTree.this.newFlag(this.node(), 0);
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Executable executable = (Executable)this.node().content();
            int n = 0;
            int n2 = string.indexOf("::");
            executable.setPathRef(string.substring(n, n2));
            n = n2 + 2;
            n2 = string.indexOf("::", n);
            executable.setPath(string.substring(n, n2));
            n = n2 + 2;
            executable.setToolRef(string.substring(n));
        }
    }

    private class ehCommand
    extends EditHandler {
        private ehCommand() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actCommandNew, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actSupportsNew, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actArgsNew, this);
            if (((Command)this.node().content()).getModifier() == null) {
                this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actCmdModNew, this);
            }
            if (this.node().getParent().getChildCount() > 1) {
                this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actDelete, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Command command = (Command)this.node().content();
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText)) {
                this.editText(ToolSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actCommandNew)) {
                ToolSetTree.this.newCommand((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actSupportsNew)) {
                ToolSetTree.this.newSupports(this.node(), null);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actArgsNew)) {
                ToolSetTree.this.newArgs(this.node(), null);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actCmdModNew)) {
                ToolSetTree.this.newModifier(this.node(), this.node().getChildCount());
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actDelete)) {
                ToolSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Command command = (Command)this.node().content();
            int n = 0;
            int n2 = string.indexOf("::");
            command.setName(string.substring(n, n2));
            n = n2 + 2;
            n2 = string.indexOf("::", n);
            command.setDescription(string.substring(n, n2));
            n = n2 + 2;
            command.setRequire(string.substring(n));
        }
    }

    private class ehTool
    extends EditHandler {
        private ehTool() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actToolNew, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actCommandNew, this);
            if (ToolSetTree.this.dx.getTool().size() > 1) {
                this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actDelete, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText)) {
                this.editText(ToolSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actToolNew)) {
                ToolSetTree.this.newTool((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actCommandNew)) {
                ToolSetTree.this.newCommand(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actDelete)) {
                ToolSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Tool tool = (Tool)this.node().content();
            int n = 0;
            int n2 = string.indexOf("::");
            tool.setName(string.substring(n, n2));
            n = n2 + 2;
            n2 = string.indexOf("::", n);
            tool.setDescription(string.substring(n, n2));
            n = n2 + 2;
            tool.setSingleRun(string.substring(n).length() > 0 ? "true" : null);
        }
    }

    private class ehPreamble
    extends EditHandler {
        private ehPreamble() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actPreambleNew, this);
            Preambles preambles = (Preambles)this.node().content();
            if (preambles.getPreamble().size() > 1) {
                this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actDelete, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText)) {
                this.editText(ToolSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actPreambleNew)) {
                ToolSetTree.this.newPreamble((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actDelete)) {
                ToolSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Preambles preambles = (Preambles)this.node().content();
            int n = this.node().getParent().getIndex(this.node());
            Preamble preamble = (Preamble)preambles.getPreamble().get(n);
            preamble.removeChildren();
            preamble.appendChild(string);
        }
    }

    private class ehPreambles
    extends EditHandler {
        private ehPreambles() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actPreamblesNew, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actPreambleNew, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText)) {
                this.editText(ToolSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actPreamblesNew)) {
                ToolSetTree.this.newPreambles((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actPreambleNew)) {
                ToolSetTree.this.newPreamble(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actDelete)) {
                ToolSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Preambles preambles = (Preambles)this.node().content();
            int n = string.indexOf("::");
            preambles.setDescription(string.substring(0, n));
            preambles.setRequire(string.substring(n + 2));
        }
    }

    private class ehToolSetDescr
    extends EditHandler {
        private ehToolSetDescr() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.editText(ToolSetTree.this.thisTree);
        }

        public void changed() {
            ToolSet toolSet = (ToolSet)this.node().content();
            toolSet.setDescription(this.node().getUserObject().toString());
        }
    }

    private class ehToolSetName
    extends EditHandler {
        private ehToolSetName() {
        }

        public void selected() {
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actPreamblesNew, this);
            this.enable(((ToolSetTree)ToolSetTree.this).userEnv.actToolNew, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actEdtText)) {
                this.editText(ToolSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actPreamblesNew)) {
                ToolSetTree.this.newPreambles(this.node(), 1);
            }
            if (actionEvent.getSource().equals(((ToolSetTree)ToolSetTree.this).userEnv.actToolNew)) {
                ToolSet toolSet = (ToolSet)this.node().content();
                ToolSetTree.this.newTool(this.node(), toolSet.getPreambles().size() + 1);
            }
        }

        public void changed() {
            ToolSet toolSet = (ToolSet)this.node().content();
            toolSet.setName(this.node().getUserObject().toString());
        }
    }
}

