/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocCls.OptionDef;
import bsbDocCls.Settings;
import bsbDocCls.SourceFile;
import bsbDocCls.Sources;
import bsbDocCls.Target;
import bsbDocCls.TargetDef;
import bsbDocCls.TargetInc;
import bsbDocCls.TargetPath;
import bsbDocCls.TargetRef;
import bsbDocCls.TargetSet;
import bsbDocExt.OptionsExt;
import bsbDocExt.SettingsExt;
import bsbDocExt.SourceSetExt;
import bsbDocExt.TargetSetExt;
import bsbDocTree.DocEditor;
import bsbDocTree.DocNode;
import bsbDocTree.DocRenderer;
import bsbDocTree.DocTree;
import bsbDocTree.OptionDefTree;
import bsbEdit.EditHandler;
import bsbException.BsbException;
import bsbGenerator.MainMakefile;
import bsbIcons.IconServer;
import bsbMain.ExecEnv;
import bsbMain.Globals;
import bsbMain.UserEnv;
import bsbUtil.BsbList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TargetSetTree
extends DocTree
implements TreeModelListener,
TreeSelectionListener {
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private TargetSetExt dx;
    private IconServer is;
    private DocTree thisTree;
    private TreePath rp;
    private Renderer renderer;
    private static Pattern patSources = Pattern.compile("(.*@)(.*)@(.*)(@.*@.*)");
    private static Pattern patSsMember = Pattern.compile("(.+)(\\[.*\\])(.*)");

    public TargetSetTree(UserEnv userEnv) {
        super(userEnv.execEnv.targetSet.getName(), userEnv.execEnv.targetSet);
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.dx = this.execEnv.targetSet;
        this.is = this.userEnv.is;
        this.thisTree = this;
        this.setupNodes();
        this.renderer = new Renderer();
        this.setCellRenderer(this.renderer);
        Editor editor = new Editor();
        this.setCellEditor(new DefaultTreeCellEditor(this, this.renderer, editor));
        this.getModel().addTreeModelListener(this);
        this.addTreeSelectionListener(this);
    }

    public String getName() {
        return this.dx.getName();
    }

    public void resync() {
        this.dx.rehash();
    }

    protected void setupNodes() {
        DocNode docNode = this.getRoot();
        docNode.icon(this.is.doc).style(1).handler(new ehTargetSetName());
        DocNode docNode2 = this.add(null, this.dx.getDescription(), this.dx, false);
        docNode2.icon(this.is.descr).style(2).handler(new ehTargetSetDescr());
        this.add(docNode2, this.dx.getCurFile().getAbsolutePath(), this.dx, false).icon(this.is.locAbs);
        BsbList bsbList = this.dx.getTargetInc();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((TargetInc)listIterator.next(), docNode, docNode.getChildCount(), true);
        }
        bsbList = this.dx.getTarget();
        listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((Target)listIterator.next(), docNode, docNode.getChildCount(), true);
        }
    }

    private DocNode insertElement(TargetInc targetInc, DocNode docNode, int n, boolean bl) {
        String string;
        String string2 = targetInc.getIncludePath();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = targetInc.getRequire()) == null) {
            string = "";
        }
        String string3 = targetInc.getIncludeFile() + "@" + string2 + "@" + string + "@" + targetInc.getDescription();
        DocNode docNode2 = new DocNode(string3, targetInc);
        docNode2.icon(this.is.targetInc).handler(new ehTargetInc()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private DocNode insertElement(Target target, DocNode docNode, int n, boolean bl) {
        ListIterator listIterator;
        BsbList bsbList;
        String string;
        String string2 = target.getAutoNamed();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = target.getRequire()) == null) {
            string = "";
        }
        String string3 = target.getName() + "@" + string2 + "@" + string + "@" + target.getDescription();
        DocNode docNode2 = new DocNode(string3, target);
        docNode2.icon(this.is.target).handler(new ehTarget()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        SettingsExt settingsExt = (SettingsExt)target.getSettings();
        OptionsExt optionsExt = (OptionsExt)settingsExt.getOptions();
        docNode2.addInfo1(optionsExt);
        if (optionsExt != null) {
            bsbList = optionsExt.getOptionDef();
            listIterator = bsbList.listIterator();
            while (listIterator.hasNext()) {
                OptionDef optionDef = (OptionDef)listIterator.next();
                OptionDefTree optionDefTree = new OptionDefTree(this.userEnv, optionDef, optionsExt);
                optionDefTree.addTo(this, docNode2);
            }
        }
        bsbList = target.getTargetRef();
        listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((TargetRef)listIterator.next(), docNode2, docNode2.getChildCount(), false);
        }
        bsbList = target.getTargetDef();
        listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((TargetDef)listIterator.next(), docNode2, docNode2.getChildCount(), false);
        }
        return docNode2;
    }

    private DocNode insertElement(TargetRef targetRef, DocNode docNode, int n, boolean bl) {
        String string = targetRef.getTarget() + "@";
        String string2 = targetRef.getRequire();
        if (string2 != null) {
            string = string + string2;
        }
        DocNode docNode2 = new DocNode(string, targetRef);
        docNode2.icon(this.is.targetRef).handler(new ehTargetRef()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private DocNode insertElement(TargetDef targetDef, DocNode docNode, int n, boolean bl) {
        String string;
        String string2;
        String string3;
        String string4 = targetDef.getType();
        if (string4 == null || string4.length() == 0) {
            string4 = "";
        }
        if ((string3 = targetDef.getTool()) == null || string3.length() == 0) {
            string3 = "";
        }
        if ((string2 = targetDef.getLocalFlags()) == null || string2.length() == 0) {
            string2 = "";
        }
        if ((string = targetDef.getRequire()) == null || string.length() == 0) {
            string = "";
        }
        DocNode docNode2 = new DocNode(string4 + "@" + string3 + "@" + string2 + "@" + string, targetDef);
        docNode2.icon(this.is.targetDef).handler(new ehTargetDef()).isSpecialRender(true);
        docNode = this.insert(n++, docNode, docNode2, bl);
        n = 0;
        BsbList bsbList = targetDef.getTargetPath();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((TargetPath)listIterator.next(), docNode, n++, false);
        }
        bsbList = targetDef.getSources();
        listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((Sources)listIterator.next(), docNode, n++, false);
        }
        return docNode;
    }

    private DocNode insertElement(TargetPath targetPath, DocNode docNode, int n, boolean bl) {
        String string;
        String string2;
        String string3 = targetPath.getPathRef();
        if (string3 == null || string3.length() == 0) {
            string3 = "";
        }
        if ((string2 = targetPath.getPath()) == null || string2.length() == 0) {
            string2 = "";
        }
        if ((string = targetPath.getRequire()) == null || string.length() == 0) {
            string = "";
        }
        DocNode docNode2 = new DocNode(string3 + "@" + string2 + "@" + string, targetPath);
        docNode2.icon(this.is.pathRef).handler(new ehTargetPath()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private DocNode insertElement(Sources sources, DocNode docNode, int n, boolean bl) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = sources.getType();
        if (Globals.isEmpty(string6)) {
            string6 = "";
        }
        if (Globals.isEmpty(string5 = sources.getPathRef())) {
            string5 = "";
        }
        if (Globals.isEmpty(string4 = sources.getSourceSet())) {
            string4 = "";
        }
        if (Globals.isEmpty(string3 = sources.getTarget())) {
            string3 = "";
        }
        if (Globals.isEmpty(string2 = sources.getLocalFlags())) {
            string2 = "";
        }
        if (Globals.isEmpty(string = sources.getRequire())) {
            string = "";
        }
        DocNode docNode2 = new DocNode(string6 + "@" + string5 + "@" + string4 + "@" + string3 + "@" + string2 + "@" + string, sources);
        docNode2.icon(this.is.targetSources).handler(new ehSources()).isSpecialRender(true);
        docNode = this.insert(n, docNode, docNode2, bl);
        n = 0;
        BsbList bsbList = sources.getSourceFile();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((SourceFile)listIterator.next(), docNode, n++, false);
        }
        TargetDef targetDef = sources.getTargetDef();
        if (targetDef != null && !targetDef.getTargetPath().isEmpty()) {
            this.insertElement(targetDef, docNode, n++, false);
        }
        return docNode;
    }

    private DocNode insertElement(SourceFile sourceFile, DocNode docNode, int n, boolean bl) {
        String string;
        String string2;
        String string3;
        String string4 = sourceFile.getPathRef();
        if (string4 == null || string4.length() == 0) {
            string4 = "";
        }
        if ((string3 = sourceFile.getPath()) == null || string3.length() == 0) {
            string3 = "";
        }
        if ((string2 = sourceFile.getLocalFlags()) == null || string2.length() == 0) {
            string2 = "";
        }
        if ((string = sourceFile.getRequire()) == null || string.length() == 0) {
            string = "";
        }
        DocNode docNode2 = new DocNode(string4 + "@" + string3 + "@" + string2 + "@" + string, sourceFile);
        docNode2.icon(this.is.sourceFiles).handler(new ehSourceFiles()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private void newTargetInc(DocNode docNode, DocNode docNode2) {
        this.newTargetInc(docNode, docNode.getIndex(docNode2));
    }

    private void newTargetInc(DocNode docNode, int n) {
        TargetInc targetInc = new TargetInc();
        targetInc.setIncludeFile("#inc-targets");
        targetInc.setIncludePath("");
        targetInc.setRequire("");
        targetInc.setDescription("Include Description");
        this.dx.getTargetInc().add(n, targetInc);
        this.dx.rehash();
        docNode = this.insertElement(targetInc, docNode, n + 1, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newTarget(DocNode docNode, DocNode docNode2) {
        this.newTarget(docNode, docNode.getIndex(docNode2) - this.dx.getTargetInc().size());
    }

    private void newTarget(DocNode docNode, int n) {
        SettingsExt settingsExt = new SettingsExt();
        Target target = new Target();
        target.setName("target");
        target.setAutoNamed("");
        target.setRequire("");
        target.setDescription("Target Description");
        target.setSettings(settingsExt);
        this.dx.getTarget().add(n, target);
        this.dx.rehash();
        docNode = this.insertElement(target, docNode, n + this.dx.getTargetInc().size() + 1, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newOptions(DocNode docNode) {
        Object object;
        Object object2;
        OptionsExt optionsExt = (OptionsExt)docNode.addInfo1();
        if (optionsExt == null) {
            object2 = (Target)docNode.content();
            object = (SettingsExt)((Target)object2).getSettings();
            optionsExt = new OptionsExt();
            optionsExt.setEnv(this.execEnv);
            ((Settings)object).setOptions(optionsExt);
            docNode.addInfo1(optionsExt);
        }
        object2 = new OptionDefTree(this.userEnv, null, optionsExt);
        object = ((OptionDefTree)object2).insertAt(this, docNode, 0);
        ((OptionDefTree)object2).insertAt(0);
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)object).getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newTargetRef(DocNode docNode, DocNode docNode2) {
        this.newTargetRef(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newTargetRef(DocNode docNode, int n) {
        Object object;
        int n2;
        for (n2 = 0; docNode.getChildCount() > n2 && (object = ((DocNode)docNode.getChildAt(n2)).content()) instanceof OptionDef; ++n2) {
        }
        object = this.dx.listAll();
        String string = (String)JOptionPane.showInputDialog(null, "Available Targets", "Select Target", 3, this.is.targetRef, object.toArray(), null);
        if (string == null) {
            return;
        }
        TargetRef targetRef = new TargetRef();
        targetRef.setTarget(string);
        targetRef.setRequire("");
        ((Target)docNode.content()).getTargetRef().add(n == 0 ? 0 : n - n2, targetRef);
        docNode = this.insertElement(targetRef, docNode, n == 0 ? n2 : n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newTargetDef(DocNode docNode, DocNode docNode2) {
        this.newTargetDef(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newTargetDef(DocNode docNode, int n) {
        Object object;
        int n2 = 0;
        while (docNode.getChildCount() > n2) {
            object = ((DocNode)docNode.getChildAt(n2)).content();
            if (object instanceof OptionDef) {
                ++n2;
                continue;
            }
            if (object instanceof TargetRef) {
                ++n2;
                continue;
            }
            if (!(object instanceof SourceFile)) break;
            ++n2;
        }
        object = new TargetPath();
        ((TargetPath)object).setPathRef("pathref");
        ((TargetPath)object).setPath("path");
        ((TargetPath)object).setRequire("require");
        TargetDef targetDef = new TargetDef();
        targetDef.setType("type");
        targetDef.setTool("tool");
        targetDef.setLocalFlags("");
        targetDef.setRequire("require");
        targetDef.getTargetPath().add(object);
        Object object2 = docNode.content();
        if (object2 instanceof Target) {
            ((Target)object2).getTargetDef().add(n == 0 ? 0 : n - n2, targetDef);
        } else if (object2 instanceof Sources) {
            ((Sources)object2).setTargetDef(targetDef);
        }
        docNode = this.insertElement(targetDef, docNode, n == 0 ? n2 : n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newTargetPath(DocNode docNode, DocNode docNode2) {
        this.newTargetPath(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newTargetPath(DocNode docNode, int n) {
        TargetPath targetPath = new TargetPath();
        targetPath.setPathRef("pathref");
        targetPath.setPath("path");
        targetPath.setRequire("require");
        ((TargetDef)docNode.content()).getTargetPath().add(n, targetPath);
        docNode = this.insertElement(targetPath, docNode, n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newSources(DocNode docNode, DocNode docNode2) {
        this.newSources(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newSources(DocNode docNode, int n) {
        Object object;
        int n2;
        for (n2 = 0; docNode.getChildCount() > n2 && (object = ((DocNode)docNode.getChildAt(n2)).content()) instanceof TargetPath; ++n2) {
        }
        object = new Sources();
        ((Sources)object).setType("type");
        ((Sources)object).setLocalFlags("");
        ((Sources)object).setRequire("require");
        ((TargetDef)docNode.content()).getSources().add(n == 0 ? 0 : n - n2, object);
        docNode = this.insertElement((Sources)object, docNode, n == 0 ? n2 : n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newSourceFile(DocNode docNode, DocNode docNode2) {
        this.newSourceFile(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newSourceFile(DocNode docNode, int n) {
        SourceFile sourceFile = new SourceFile();
        sourceFile.setPathRef("pathref");
        sourceFile.setPath("path");
        sourceFile.setLocalFlags("");
        sourceFile.setRequire("require");
        ((Sources)docNode.content()).getSourceFile().add(n, sourceFile);
        docNode = this.insertElement(sourceFile, docNode, n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private Object deleteElement(DocNode docNode) {
        Object object = docNode.content();
        Object object2 = ((DocNode)docNode.getParent()).content();
        this.dx.deleteElement(object2, object);
        this.deleteNode(docNode);
        return object2;
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.userEnv.targetSetEdit.isDirty(true);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.userEnv.targetSetEdit.isDirty(true);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.userEnv.targetSetEdit.isDirty(true);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.setEditable(false);
        DocNode docNode = (DocNode)this.getLastSelectedPathComponent();
        if (docNode != null) {
            docNode.handler().changed();
        }
        this.treeUpdate(this.dx.getName());
        this.userEnv.targetSetEdit.isDirty(true);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DocNode docNode = (DocNode)this.getLastSelectedPathComponent();
        if (docNode == null) {
            return;
        }
        TreeNode[] treeNodeArray = docNode.getPath();
        boolean bl = false;
        for (int i = 0; i < treeNodeArray.length; ++i) {
            if (!(((DocNode)treeNodeArray[i]).content() instanceof OptionDef)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.userEnv.bsbNotification.putValue("TargetSetToolBar", "OPTION");
        } else {
            this.userEnv.bsbNotification.putValue("TargetSetToolBar", "TARGET");
        }
        this.userEnv.disableNodeActions();
        this.checkNodeSelection();
        this.setEditable(false);
    }

    static /* synthetic */ Pattern access$3800() {
        return patSsMember;
    }

    private class Editor
    extends DocEditor {
        private Component[] car;
        private JTextField tf1 = new JTextField();
        private JTextField tf2 = new JTextField();
        private JTextField tf3 = new JTextField();
        private JTextField tf4 = new JTextField();
        private JTextField tf5 = new JTextField();
        private JComboBox cb1;
        private JComboBox cb2;
        private int cbLim = 0;

        public Editor() {
            this.tf1.addKeyListener(this);
            this.tf2.addKeyListener(this);
            this.tf3.addKeyListener(this);
            this.tf4.addKeyListener(this);
            this.tf5.addKeyListener(this);
        }

        protected Component nodeEditor(DocTree docTree, DocNode docNode, boolean bl, boolean bl2, boolean bl3, int n) {
            if (!docNode.isSpecialRender()) {
                return super.nodeEditor(docTree, docNode, bl, bl2, bl3, n);
            }
            this.car = ((JComponent)docTree.getCellRenderer().getTreeCellRendererComponent(docTree, docNode, bl, bl2, bl3, n, true)).getComponents();
            this.nodePanel.removeAll();
            String string = (String)docNode.getUserObject();
            int n2 = ((TargetSetTree)TargetSetTree.this).renderer.getPreferredSize().height;
            if (docNode.content() instanceof TargetInc) {
                this.editTargetInc(string);
            } else if (docNode.content() instanceof Target) {
                this.editTarget(string);
            } else if (docNode.content() instanceof TargetRef) {
                this.editTargetRef(string);
            } else if (docNode.content() instanceof TargetDef) {
                this.editTargetDef(string);
            } else if (docNode.content() instanceof TargetPath) {
                this.editTargetPath(string);
            } else if (docNode.content() instanceof Sources) {
                this.editSources(string);
            } else if (docNode.content() instanceof SourceFile) {
                this.editSourceFile(string);
            } else {
                return super.nodeEditor(docTree, docNode, bl, bl2, bl3, n);
            }
            return this.nodePanel;
        }

        protected Object nodeValue() {
            if (!this.curNode.isSpecialRender()) {
                return super.nodeValue();
            }
            if (this.curNode.content() instanceof TargetInc) {
                return this.tf1.getText() + "@" + this.cb1.getSelectedItem() + "@" + this.tf2.getText() + "@" + this.tf3.getText();
            }
            if (this.curNode.content() instanceof Target) {
                return this.tf1.getText() + "@" + this.cb1.getSelectedItem() + "@" + this.tf2.getText() + "@" + this.tf3.getText();
            }
            if (this.curNode.content() instanceof TargetRef) {
                return this.cb1.getSelectedItem() + "@" + this.tf2.getText();
            }
            if (this.curNode.content() instanceof TargetDef) {
                return this.tf1.getText() + "@" + this.cb1.getSelectedItem() + "@" + this.tf2.getText() + "@" + this.tf3.getText();
            }
            if (this.curNode.content() instanceof TargetPath) {
                return this.cb1.getSelectedItem() + "@" + this.tf1.getText() + "@" + this.tf2.getText();
            }
            if (this.curNode.content() instanceof Sources) {
                String string = "";
                String string2 = this.tf4.getText();
                String string3 = this.tf5.getText();
                try {
                    TargetSetTree.this.dx.named(string2);
                }
                catch (Exception exception) {
                    string = string2;
                    string2 = "";
                }
                return this.tf1.getText() + "@" + string3 + "@" + string + "@" + string2 + "@" + this.tf2.getText() + "@" + this.tf3.getText();
            }
            if (this.curNode.content() instanceof SourceFile) {
                return this.cb1.getSelectedItem() + "@" + this.tf1.getText() + "@" + this.tf2.getText() + "@" + this.tf3.getText();
            }
            return super.nodeValue();
        }

        private void editTargetInc(String string) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    File file2;
                    String string = (String)cb1.getSelectedItem();
                    if (string.length() > 0) {
                        string = ((TargetSetTree)((Editor)this).TargetSetTree.this).execEnv.pathSet.fullPath(string);
                    }
                    if ((file2 = EditHandler.selectFile(file = string.length() > 0 ? new File(string) : TargetSetTree.this.dx.getCurFile(), "TargetSet")) != null) {
                        string = file2.getPath();
                        if (file != null) {
                            string = EditHandler.relativePath(file, string);
                        }
                        tf1.setText(string);
                        tf1.requestFocusInWindow();
                    }
                }
            };
            JLabel jLabel = (JLabel)this.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg + TargetSetTree.this.icnw;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            Icon icon = jLabel.getText().length() > 0 ? ((TargetSetTree)TargetSetTree.this).is.locRel : ((TargetSetTree)TargetSetTree.this).is.locAbs;
            JButton jButton = new JButton(icon);
            jButton.setPreferredSize(new Dimension(TargetSetTree.this.icnw, TargetSetTree.this.icnw));
            jButton.addActionListener(actionListener);
            this.nodePanel.add(jButton);
            this.nodePanel.add(this.car[2]);
            ((JLabel)this.car[2]).setVisible(true);
            jLabel = (JLabel)this.car[3];
            Vector vector = ((TargetSetTree)TargetSetTree.this).execEnv.pathSet.getList()[0];
            vector.add("");
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            this.cb1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.cb1);
            this.nodePanel.add(this.car[4]);
            ((JLabel)this.car[4]).setVisible(true);
            jLabel = (JLabel)this.car[5];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
            this.nodePanel.add(this.car[6]);
            ((JLabel)this.car[6]).setVisible(true);
            jLabel = (JLabel)this.car[7];
            this.tf3.setText(jLabel.getText());
            this.tf3.setFont(jLabel.getFont());
            this.tf3.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf3);
        }

        private void editTarget(String string) {
            JLabel jLabel = (JLabel)this.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            Vector<String> vector = new Vector<String>();
            vector.add("");
            Vector[] vectorArray = ((TargetSetTree)TargetSetTree.this).execEnv.optionSet.getCondValueList();
            ListIterator listIterator = vectorArray[0].listIterator();
            ListIterator listIterator2 = vectorArray[1].listIterator();
            while (listIterator2.hasNext()) {
                String string2 = (String)listIterator.next();
                if (!listIterator2.next().equals("AutoNamed")) continue;
                vector.add(string2);
            }
            this.nodePanel.add(this.car[2]);
            ((JLabel)this.car[2]).setVisible(true);
            jLabel = (JLabel)this.car[3];
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            this.cb1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.cb1);
            this.nodePanel.add(this.car[4]);
            ((JLabel)this.car[4]).setVisible(true);
            jLabel = (JLabel)this.car[5];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
            this.nodePanel.add(this.car[6]);
            ((JLabel)this.car[6]).setVisible(true);
            jLabel = (JLabel)this.car[7];
            this.tf3.setText(jLabel.getText());
            this.tf3.setFont(jLabel.getFont());
            this.tf3.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf3);
        }

        private void editTargetRef(String string) {
            JLabel jLabel = (JLabel)this.car[1];
            this.cb1 = new JComboBox<Object>(TargetSetTree.this.dx.listAll().toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.cb1.setPreferredSize(dimension);
            this.nodePanel.add(this.cb1);
            jLabel = (JLabel)this.car[2];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[3];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
        }

        private void editTargetDef(String string) {
            JLabel jLabel = (JLabel)this.car[2];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[3];
            jLabel.setVisible(true);
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            jLabel = (JLabel)this.car[4];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[5];
            List list = ((TargetSetTree)TargetSetTree.this).execEnv.toolSet.getToolNames();
            list.add("");
            this.cb1 = new JComboBox<Object>(list.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            this.cb1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.cb1);
            jLabel = (JLabel)this.car[6];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[7];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
            jLabel = (JLabel)this.car[8];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[9];
            this.tf3.setText(jLabel.getText());
            this.tf3.setFont(jLabel.getFont());
            this.tf3.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf3);
        }

        private void editTargetPath(String string) {
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ Editor this$1;
                {
                    this.this$1 = editor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    File file2;
                    String string = (String)Editor.access$3000(this.this$1).getSelectedItem();
                    if (string.length() > 0) {
                        string = TargetSetTree.access$3200((TargetSetTree)Editor.access$3100((Editor)this.this$1)).pathSet.fullPath(string);
                    }
                    if ((file2 = EditHandler.selectDir(file = string.length() > 0 ? new File(string) : TargetSetTree.access$900((TargetSetTree)Editor.access$3100((Editor)this.this$1)).execEnv.makefileLoc, "target")) != null) {
                        string = file2.getPath();
                        if (file != null) {
                            string = EditHandler.relativePath(file, string);
                        }
                        Editor.access$3300(this.this$1).setText(string);
                        Editor.access$3300(this.this$1).requestFocusInWindow();
                    }
                }
            };
            JLabel jLabel = (JLabel)this.car[1];
            Vector vector = ((TargetSetTree)TargetSetTree.this).execEnv.pathSet.getList()[0];
            vector.add("");
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.cb1.setPreferredSize(dimension);
            this.nodePanel.add(this.cb1);
            Icon icon = jLabel.getText().length() > 0 ? ((TargetSetTree)TargetSetTree.this).is.locRel : ((TargetSetTree)TargetSetTree.this).is.locAbs;
            JButton jButton = new JButton(icon);
            jButton.setPreferredSize(new Dimension(TargetSetTree.this.icnw, TargetSetTree.this.icnw));
            jButton.addActionListener(actionListener);
            this.nodePanel.add(jButton);
            jLabel = (JLabel)this.car[3];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            this.tf1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf1);
            jLabel = (JLabel)this.car[4];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[5];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
        }

        private void editSources(String string) {
            JButton jButton = new JButton();
            ActionListener actionListener = new ActionListener(this, jButton, string){
                private final /* synthetic */ JButton val$b;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ Editor this$1;
                {
                    this.this$1 = editor;
                    this.val$b = jButton;
                    this.val$s = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.access$3600(this.this$1, this.val$b, this.val$s, Editor.access$3400(this.this$1), Editor.access$3500(this.this$1));
                }
            };
            JLabel jLabel = (JLabel)this.car[2];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[3];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            int n = 0;
            this.tf5.setText("");
            if (this.car.length > 10) {
                jLabel = (JLabel)this.car[4];
                jLabel.setVisible(true);
                this.nodePanel.add(jLabel);
                jLabel = (JLabel)this.car[5];
                this.tf5.setText(jLabel.getText());
                this.tf5.setFont(jLabel.getFont());
                this.tf5.setPreferredSize(jLabel.getPreferredSize());
                this.nodePanel.add(this.tf5);
                n = 2;
            }
            jLabel = (JLabel)this.car[n + 4];
            jButton.setIcon(jLabel.getIcon());
            jButton.setToolTipText("specify sources attributes");
            jButton.setPreferredSize(new Dimension(TargetSetTree.this.icnw, TargetSetTree.this.icnw));
            jButton.addActionListener(actionListener);
            this.nodePanel.add(jButton);
            jLabel = (JLabel)this.car[n + 5];
            this.tf4.setText(jLabel.getText());
            this.tf4.setFont(jLabel.getFont());
            this.tf4.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf4);
            jLabel = (JLabel)this.car[n + 6];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[n + 7];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
            jLabel = (JLabel)this.car[n + 8];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[n + 9];
            this.tf3.setText(jLabel.getText());
            this.tf3.setFont(jLabel.getFont());
            this.tf3.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf3);
        }

        private void editSourceFile(String string) {
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ Editor this$1;
                {
                    this.this$1 = editor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    File file2;
                    String string = (String)Editor.access$3000(this.this$1).getSelectedItem();
                    if (string.length() > 0) {
                        string = TargetSetTree.access$3200((TargetSetTree)Editor.access$3100((Editor)this.this$1)).pathSet.getPath(string);
                    }
                    if ((file2 = EditHandler.selectFile(file = string != null && string.length() > 0 ? new File(string) : null, "source")) != null) {
                        string = file2.getPath();
                        if (file != null) {
                            string = EditHandler.relativePath(file, string);
                        }
                        Editor.access$3300(this.this$1).setText(string);
                        Editor.access$3300(this.this$1).requestFocusInWindow();
                    }
                }
            };
            JLabel jLabel = (JLabel)this.car[2];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[3];
            Vector vector = ((TargetSetTree)TargetSetTree.this).execEnv.pathSet.getList()[0];
            vector.add("");
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.cb1.setPreferredSize(dimension);
            this.nodePanel.add(this.cb1);
            Icon icon = jLabel.getText().length() > 0 ? ((TargetSetTree)TargetSetTree.this).is.locRel : ((TargetSetTree)TargetSetTree.this).is.locAbs;
            JButton jButton = new JButton(icon);
            jButton.setPreferredSize(new Dimension(TargetSetTree.this.icnw, TargetSetTree.this.icnw));
            jButton.addActionListener(actionListener);
            this.nodePanel.add(jButton);
            jLabel = (JLabel)this.car[5];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            this.tf1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf1);
            jLabel = (JLabel)this.car[6];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[7];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
            jLabel = (JLabel)this.car[8];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[9];
            this.tf3.setText(jLabel.getText());
            this.tf3.setFont(jLabel.getFont());
            this.tf3.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf3);
        }

        private JDialog showSourcesDialog(JComponent jComponent, String string, JTextField jTextField, JTextField jTextField2) {
            String string2 = "";
            String string3 = "";
            Matcher matcher = patSources.matcher(string);
            if (matcher.find()) {
                string3 = matcher.group(2);
                string2 = matcher.group(3);
            }
            JDialog jDialog = new JDialog(TargetSetTree.this.userEnv, "Specify Source", true);
            Container container = jDialog.getContentPane();
            FilenameFilter filenameFilter = new FilenameFilter(this){
                private final /* synthetic */ Editor this$1;
                {
                    this.this$1 = editor;
                }

                public boolean accept(File file, String string) {
                    return string.endsWith(".xml");
                }
            };
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new TitledBorder("Sources type"));
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton("SourceSet");
            JRadioButton jRadioButton2 = new JRadioButton("Target");
            JRadioButton jRadioButton3 = new JRadioButton("None");
            jRadioButton.setActionCommand("SourceSet");
            jRadioButton2.setActionCommand("Target");
            jRadioButton3.setActionCommand("None");
            buttonGroup.add(jRadioButton3);
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton);
            jPanel.add(jRadioButton3);
            jPanel.add(jRadioButton2);
            jPanel.add(jRadioButton);
            container.add((Component)jPanel, "North");
            jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new TitledBorder("Sources attributes"));
            JPanel jPanel2 = new JPanel();
            JComboBox jComboBox = new JComboBox((Vector)TargetSetTree.this.dx.listAll());
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(new TitledBorder("Targets"));
            jPanel3.add(jComboBox);
            JComboBox jComboBox2 = new JComboBox(((TargetSetTree)TargetSetTree.this).execEnv.pathSet.getList()[0]);
            jComboBox2.setSelectedItem(jTextField.getText());
            jComboBox2.setActionCommand("pathRefSelected");
            JPanel jPanel4 = new JPanel();
            jPanel4.setBorder(new TitledBorder("PathRefs"));
            jPanel4.add(jComboBox2);
            String[] stringArray = TargetSetTree.this.execEnv.getSourceSetDir().list(filenameFilter);
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i].substring(0, stringArray[i].lastIndexOf(".xml")));
            }
            JComboBox<String> jComboBox3 = new JComboBox<String>(vector);
            jComboBox3.addItem("");
            jComboBox3.setActionCommand("simpleSelected");
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(new TitledBorder("simple SourceSets"));
            jPanel5.add(jComboBox3);
            jPanel2.add(jPanel3);
            jPanel2.add(jPanel4);
            jPanel2.add(jPanel5);
            JPanel jPanel6 = new JPanel();
            JTextField jTextField3 = new JTextField("", 20);
            jTextField3.setActionCommand("pathChanged");
            JPanel jPanel7 = new JPanel();
            jPanel7.setBorder(new TitledBorder("SourceSet Path"));
            jPanel7.add(jTextField3);
            JComboBox jComboBox4 = new JComboBox();
            Dimension dimension = jComboBox4.getPreferredSize();
            dimension.width = 100;
            jComboBox4.setPreferredSize(dimension);
            JPanel jPanel8 = new JPanel();
            jPanel8.setBorder(new TitledBorder("SourceSet Member"));
            jPanel8.add(jComboBox4);
            JButton jButton = new JButton("Select");
            jButton.setActionCommand("Select");
            jPanel6.add(jPanel7);
            jPanel6.add(jPanel8);
            jPanel6.add(jButton);
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jPanel6, "South");
            container.add((Component)jPanel, "Center");
            jPanel = new JPanel();
            JButton jButton2 = new JButton("Cancel");
            JButton jButton3 = new JButton("OK");
            jButton2.setActionCommand("cancel");
            jButton3.setActionCommand("ok");
            jPanel.add(jButton2);
            jPanel.add(jButton3);
            container.add((Component)jPanel, "South");
            ActionListener actionListener = new ActionListener(this, jTextField, jTextField2, jComboBox, jComboBox3, jComboBox2, jTextField3, jDialog, jRadioButton3, jRadioButton2, jRadioButton, jComboBox4, jButton3, jButton){
                private boolean inAction;
                private int members;
                private final /* synthetic */ JTextField val$tf5;
                private final /* synthetic */ JTextField val$tf4;
                private final /* synthetic */ JComboBox val$cbTargets;
                private final /* synthetic */ JComboBox val$cbSourceSets;
                private final /* synthetic */ JComboBox val$cbPathRefs;
                private final /* synthetic */ JTextField val$tfPath;
                private final /* synthetic */ JDialog val$dlg;
                private final /* synthetic */ JRadioButton val$rbNone;
                private final /* synthetic */ JRadioButton val$rbTarget;
                private final /* synthetic */ JRadioButton val$rbSourceSet;
                private final /* synthetic */ JComboBox val$cbMember;
                private final /* synthetic */ JButton val$btnOk;
                private final /* synthetic */ JButton val$btnSelect;
                private final /* synthetic */ Editor this$1;
                {
                    this.this$1 = editor;
                    this.val$tf5 = jTextField;
                    this.val$tf4 = jTextField2;
                    this.val$cbTargets = jComboBox;
                    this.val$cbSourceSets = jComboBox2;
                    this.val$cbPathRefs = jComboBox3;
                    this.val$tfPath = jTextField3;
                    this.val$dlg = jDialog;
                    this.val$rbNone = jRadioButton;
                    this.val$rbTarget = jRadioButton2;
                    this.val$rbSourceSet = jRadioButton3;
                    this.val$cbMember = jComboBox4;
                    this.val$btnOk = jButton;
                    this.val$btnSelect = jButton2;
                    this.inAction = false;
                    this.members = 0;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.inAction) {
                        return;
                    }
                    this.inAction = true;
                    if ("SourceSet".equals(actionEvent.getActionCommand())) {
                        this.enable(0, 1, 1, 1, 0, 1);
                        this.checkFile(this.val$tf5.getText(), this.val$tf4.getText());
                    } else if ("Target".equals(actionEvent.getActionCommand())) {
                        this.enable(1, 0, 0, 0, 0, 0);
                        this.val$cbTargets.setSelectedItem(this.val$tf4.getText());
                    } else if ("None".equals(actionEvent.getActionCommand())) {
                        this.enable(0, 0, 0, 0, 0, 0);
                    } else if ("simpleSelected".equals(actionEvent.getActionCommand())) {
                        if ("".equals(this.val$cbSourceSets.getSelectedItem())) {
                            this.checkFile((String)this.val$cbPathRefs.getSelectedItem(), this.val$tfPath.getText());
                            this.enable(0, 1, 1, 1, this.members, 1);
                        } else {
                            this.checkFile("", (String)this.val$cbSourceSets.getSelectedItem());
                            this.enable(0, 0, 1, 0, this.members, 0);
                        }
                    } else if ("pathRefSelected".equals(actionEvent.getActionCommand())) {
                        if ("".equals(this.val$cbPathRefs.getSelectedItem())) {
                            this.checkFile("", this.val$tfPath.getText());
                        } else {
                            this.checkFile((String)this.val$cbPathRefs.getSelectedItem(), this.val$tfPath.getText());
                        }
                    } else if ("pathChanged".equals(actionEvent.getActionCommand())) {
                        this.checkFile((String)this.val$cbPathRefs.getSelectedItem(), this.val$tfPath.getText());
                    } else if ("Select".equals(actionEvent.getActionCommand())) {
                        File file;
                        String string = (String)this.val$cbPathRefs.getSelectedItem();
                        File file2 = new File(this.val$tfPath.getText()).getParentFile();
                        if (file2 == null || !file2.isAbsolute()) {
                            file2 = TargetSetTree.access$1500(Editor.access$3100(this.this$1)).getCurFile().getParentFile();
                        }
                        if (!Globals.isEmpty(string)) {
                            file2 = new File(TargetSetTree.access$3200((TargetSetTree)Editor.access$3100((Editor)this.this$1)).pathSet.fullPath(string));
                        }
                        if ((file = EditHandler.selectFile(file2, "SourceSet")) != null) {
                            if (Globals.isEmpty(string)) {
                                this.val$tfPath.setText(file.getPath());
                            } else {
                                this.val$tfPath.setText(EditHandler.relativePath(file2, file.getPath()));
                            }
                        }
                    } else if ("cancel".equals(actionEvent.getActionCommand())) {
                        this.val$dlg.dispose();
                    } else if ("ok".equals(actionEvent.getActionCommand())) {
                        if (this.val$rbNone.isSelected()) {
                            this.val$tf4.setText("");
                            this.val$tf5.setText("");
                        } else if (this.val$rbTarget.isSelected()) {
                            this.val$tf4.setText((String)this.val$cbTargets.getSelectedItem());
                            this.val$tf5.setText("");
                        } else if (this.val$rbSourceSet.isSelected()) {
                            String string = (String)this.val$cbSourceSets.getSelectedItem();
                            if ("".equals(string)) {
                                string = this.val$tfPath.getText();
                            }
                            this.val$tf4.setText(string + this.val$cbMember.getSelectedItem());
                            this.val$tf5.setText((String)this.val$cbPathRefs.getSelectedItem());
                        }
                        this.val$dlg.dispose();
                    }
                    this.inAction = false;
                }

                public String checkFile(String string, String string2) {
                    String string3 = string2;
                    String string4 = "";
                    File file = null;
                    Matcher matcher = TargetSetTree.access$3800().matcher(string3);
                    this.val$cbMember.removeAllItems();
                    if (matcher.find()) {
                        string3 = matcher.group(1) + matcher.group(3);
                        string4 = matcher.group(2);
                    }
                    if (Globals.isEmpty(string)) {
                        this.enable(-1, -1, 1, -1, -1, -1);
                        this.val$cbPathRefs.setSelectedItem("");
                        file = new File(string3);
                        if (file.isAbsolute()) {
                            this.val$cbSourceSets.setSelectedItem("");
                            this.val$tfPath.setText(file.getPath());
                        } else {
                            file = new File(TargetSetTree.access$1500(Editor.access$3100(this.this$1)).getCurFile().getParent(), string3);
                            if (file.exists()) {
                                this.val$cbSourceSets.setSelectedItem("");
                                this.val$tfPath.setText(string3);
                                this.enable(0, 1, 1, 1, 0, 1);
                            } else {
                                file = new File(TargetSetTree.access$3200(Editor.access$3100(this.this$1)).getSourceSetDir(), string3 + ".xml");
                                if (file.exists()) {
                                    this.val$cbSourceSets.setSelectedItem(string3);
                                    this.val$tfPath.setText(string3);
                                    this.enable(0, 0, 1, 0, 0, 0);
                                }
                            }
                        }
                    } else {
                        this.val$cbPathRefs.setSelectedItem(string);
                        file = new File(TargetSetTree.access$3200((TargetSetTree)Editor.access$3100((Editor)this.this$1)).pathSet.fullPath(string, string3));
                        if (file.exists()) {
                            this.val$cbSourceSets.setSelectedItem("");
                            this.val$tfPath.setText(string3);
                            this.enable(0, 1, 0, 1, 0, 1);
                        }
                    }
                    if (file.exists() && file.isFile()) {
                        file = new File(file.getPath() + "[*]");
                        SourceSetExt sourceSetExt = null;
                        try {
                            sourceSetExt = SourceSetExt.read(TargetSetTree.access$3200(Editor.access$3100(this.this$1)), file);
                        }
                        catch (BsbException bsbException) {
                            bsbException.handle();
                            return string3;
                        }
                        Vector vector = sourceSetExt.members();
                        this.members = vector.size();
                        if (this.members > 0) {
                            this.val$cbMember.addItem("[*]");
                            ListIterator<E> listIterator = vector.listIterator();
                            while (listIterator.hasNext()) {
                                this.val$cbMember.addItem("[" + ((SourceSetExt)listIterator.next()).getName() + "]");
                            }
                            this.val$cbMember.setSelectedItem(string4);
                        } else {
                            this.val$cbMember.addItem("");
                        }
                        this.val$btnOk.setEnabled(true);
                    } else {
                        this.val$btnOk.setEnabled(false);
                    }
                    this.enable(-1, -1, -1, -1, this.members, -1);
                    return string3;
                }

                private void enable(int n, int n2, int n3, int n4, int n5, int n6) {
                    if (n >= 0) {
                        this.val$cbTargets.setEnabled(n > 0);
                    }
                    if (n2 >= 0) {
                        this.val$cbPathRefs.setEnabled(n2 > 0);
                    }
                    if (n3 >= 0) {
                        this.val$cbSourceSets.setEnabled(n3 > 0);
                    }
                    if (n4 >= 0) {
                        this.val$tfPath.setEnabled(n4 > 0);
                    }
                    if (n5 >= 0) {
                        this.val$cbMember.setEnabled(n5 > 0);
                    }
                    if (n6 >= 0) {
                        this.val$btnSelect.setEnabled(n6 > 0);
                    }
                }
            };
            if (!Globals.isEmpty(string2)) {
                jRadioButton2.setSelected(true);
                actionListener.actionPerformed(new ActionEvent(jRadioButton2, 0, "Target"));
            } else if (!Globals.isEmpty(string3)) {
                jRadioButton.setSelected(true);
                actionListener.actionPerformed(new ActionEvent(jRadioButton, 0, "SourceSet"));
            } else {
                jRadioButton3.setSelected(true);
                actionListener.actionPerformed(new ActionEvent(jRadioButton3, 0, "None"));
            }
            jRadioButton.addActionListener(actionListener);
            jRadioButton2.addActionListener(actionListener);
            jRadioButton3.addActionListener(actionListener);
            jComboBox2.addActionListener(actionListener);
            jComboBox3.addActionListener(actionListener);
            jTextField3.addActionListener(actionListener);
            jButton.addActionListener(actionListener);
            jButton2.addActionListener(actionListener);
            jButton3.addActionListener(actionListener);
            jDialog.pack();
            jDialog.setLocationRelativeTo(jComponent);
            jDialog.show();
            return jDialog;
        }

        static /* synthetic */ JTextField access$3400(Editor editor) {
            return editor.tf5;
        }

        static /* synthetic */ JTextField access$3500(Editor editor) {
            return editor.tf4;
        }

        static /* synthetic */ JDialog access$3600(Editor editor, JComponent jComponent, String string, JTextField jTextField, JTextField jTextField2) {
            return editor.showSourcesDialog(jComponent, string, jTextField, jTextField2);
        }
    }

    private class Renderer
    extends DocRenderer {
        int vw;
        int sx1;
        int sx2;
        int sx3;
        int sx4;

        public Renderer() {
            super(TargetSetTree.this.fontDefault);
        }

        protected Component nodeRenderer(DocNode docNode, boolean bl) {
            if (!docNode.isSpecialRender()) {
                return super.nodeRenderer(docNode, bl);
            }
            this.vw = TargetSetTree.this.viewWidth / 10;
            this.sx1 = this.vw * 3 - docNode.getLevel() * 20;
            this.sx2 = this.vw * 2;
            this.sx3 = this.vw * 2;
            this.sx4 = this.vw * 3 - 15;
            this.nodePanel.removeAll();
            String string = (String)docNode.getUserObject();
            if (docNode.content() instanceof TargetInc) {
                this.renderTargetInc(docNode, string);
            } else if (docNode.content() instanceof Target) {
                this.renderTarget(docNode, string);
            } else if (docNode.content() instanceof TargetRef) {
                this.renderTargetRef(docNode, string);
            } else if (docNode.content() instanceof TargetDef) {
                this.renderTargetDef(docNode, string);
            } else if (docNode.content() instanceof TargetPath) {
                this.renderTargetPath(docNode, string);
            } else if (docNode.content() instanceof Sources) {
                this.renderSources(docNode, string);
            } else if (docNode.content() instanceof SourceFile) {
                this.renderSourceFile(docNode, string);
            }
            this.nodePanel.setOpaque(bl);
            this.setVisible(false);
            this.nodePanel.setVisible(true);
            return this.nodePanel;
        }

        private void renderTargetInc(DocNode docNode, String string) {
            int n = 0;
            int n2 = string.indexOf("@");
            JLabel jLabel = this.addLabel(docNode.icon(), string.substring(n, n2), TargetSetTree.this.fontDefault, this.sx1, true);
            jLabel.setToolTipText("Include TargetSet");
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            jLabel = this.addLabel(((TargetSetTree)TargetSetTree.this).is.pathRef, string.substring(n, n2), TargetSetTree.this.fontDefault, this.sx2, false);
            jLabel.setToolTipText("PathSet reference");
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            jLabel = this.addLabel(((TargetSetTree)TargetSetTree.this).is.require, string.substring(n, n2), TargetSetTree.this.fontDefault, this.sx3, false);
            jLabel.setToolTipText("Include requirement");
            n = n2 + 1;
            jLabel = this.addLabel(((TargetSetTree)TargetSetTree.this).is.descr, string.substring(n), TargetSetTree.this.fontItalic, this.sx4, false);
            jLabel.setToolTipText("Include description");
        }

        private void renderTarget(DocNode docNode, String string) {
            int n = 0;
            int n2 = string.indexOf("@");
            JLabel jLabel = this.addLabel(docNode.icon(), string.substring(n, n2), TargetSetTree.this.fontBold, this.sx1, true);
            jLabel.setToolTipText("Target name");
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            jLabel = this.addLabel(((TargetSetTree)TargetSetTree.this).is.autoNamed, string.substring(n, n2), TargetSetTree.this.fontDefault, this.sx2, false);
            jLabel.setToolTipText("Target autoNamed");
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            jLabel = this.addLabel(((TargetSetTree)TargetSetTree.this).is.require, string.substring(n, n2), TargetSetTree.this.fontDefault, this.sx3, false);
            jLabel.setToolTipText("Target requirement");
            n = n2 + 1;
            jLabel = this.addLabel(((TargetSetTree)TargetSetTree.this).is.descr, string.substring(n), TargetSetTree.this.fontItalic, this.sx4, false);
            jLabel.setToolTipText("Target description");
        }

        private void renderTargetRef(DocNode docNode, String string) {
            int n = string.indexOf("@");
            this.addLabel(docNode.icon(), string.substring(0, n), TargetSetTree.this.fontBold, this.sx1 + this.sx2 + this.sx3, true);
            string = string.substring(n + 1);
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.require, string, TargetSetTree.this.fontDefault, this.sx4, false);
        }

        private void renderTargetDef(DocNode docNode, String string) {
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.targetDef, "", TargetSetTree.this.fontDefault, this.icnw, true);
            int n = string.indexOf("@");
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.targetTypes, string.substring(0, n), TargetSetTree.this.fontBold, this.sx1 - this.icnw, false);
            string = string.substring(n + 1);
            n = string.indexOf("@");
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.tool, string.substring(0, n), TargetSetTree.this.fontDefault, this.sx2, false);
            string = string.substring(n + 1);
            n = string.indexOf("@");
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.flags, string.substring(0, n), TargetSetTree.this.fontDefault, this.sx3, false);
            string = string.substring(n + 1);
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.require, string, TargetSetTree.this.fontDefault, this.sx4, false);
        }

        private void renderTargetPath(DocNode docNode, String string) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            int n = string.indexOf("@");
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
            n = string.indexOf("@");
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
            int n2 = this.sx1 + (string2.length() > 0 ? this.sx2 : 0);
            int n3 = this.sx3 + (string2.length() > 0 ? 0 : this.sx2);
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.pathRef, string2, TargetSetTree.this.fontBold, n2, true);
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.locRel, string3, TargetSetTree.this.fontDefault, n3, false);
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.require, string4, TargetSetTree.this.fontDefault, this.sx4, false);
        }

        private void renderSources(DocNode docNode, String string) {
            this.addLabel(docNode.icon(), "", TargetSetTree.this.fontDefault, this.icnw, true);
            int n = string.indexOf("@");
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            n = string.indexOf("@");
            String string3 = string.substring(0, n);
            string = string.substring(n + 1);
            n = string.indexOf("@");
            String string4 = string.substring(0, n);
            string = string.substring(n + 1);
            n = string.indexOf("@");
            String string5 = string.substring(0, n);
            if (string3.length() > 0) {
                this.sx1 /= 2;
            }
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.targetTypes, string2, TargetSetTree.this.fontBold, this.sx1 - this.icnw, false);
            if (string3.length() > 0) {
                this.addLabel(((TargetSetTree)TargetSetTree.this).is.pathRef, string3, TargetSetTree.this.fontDefault, this.sx1, false);
            }
            if (string4.length() > 0) {
                this.addLabel(((TargetSetTree)TargetSetTree.this).is.sourceSetRef, string4, TargetSetTree.this.fontDefault, this.sx2, false);
            } else {
                this.addLabel(((TargetSetTree)TargetSetTree.this).is.targetRef, string5, TargetSetTree.this.fontDefault, this.sx2, false);
            }
            string = string.substring(n + 1);
            n = string.indexOf("@");
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.flags, string.substring(0, n), TargetSetTree.this.fontDefault, this.sx3, false);
            string = string.substring(n + 1);
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.require, string, TargetSetTree.this.fontDefault, this.sx4, false);
        }

        private void renderSourceFile(DocNode docNode, String string) {
            this.addLabel(docNode.icon(), "", TargetSetTree.this.fontDefault, this.icnw, true);
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            int n = string.indexOf("@");
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
            n = string.indexOf("@");
            string3 = string.substring(0, n);
            string = string.substring(n + 1);
            n = string.indexOf("@");
            string4 = string.substring(0, n);
            string5 = string.substring(n + 1);
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.pathRef, string2, TargetSetTree.this.fontBold, this.sx1 - this.icnw, true);
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.locRel, string3, TargetSetTree.this.fontDefault, this.sx2, false);
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.flags, string4, TargetSetTree.this.fontDefault, this.sx3, false);
            this.addLabel(((TargetSetTree)TargetSetTree.this).is.require, string5, TargetSetTree.this.fontDefault, this.sx4, false);
        }
    }

    private class ehSourceFiles
    extends EditHandler {
        private ehSourceFiles() {
        }

        public void selected() {
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actSourceFilesNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText)) {
                this.editText(TargetSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actSourceFilesNew)) {
                TargetSetTree.this.newSourceFile((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actDelete)) {
                TargetSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            SourceFile sourceFile = (SourceFile)this.node().content();
            int n = 0;
            int n2 = string.indexOf("@");
            sourceFile.setPathRef(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            sourceFile.setPath(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            sourceFile.setLocalFlags(string.substring(n, n2));
            n = n2 + 1;
            sourceFile.setRequire(string.substring(n));
        }
    }

    private class ehSources
    extends EditHandler {
        private ehSources() {
        }

        public void selected() {
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetSourcesNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actSourceFilesNew, this);
            if (((Sources)this.node().content()).getTargetDef() == null) {
                this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetDefNew, this);
            }
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText)) {
                this.editText(TargetSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetSourcesNew)) {
                TargetSetTree.this.newSources((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actSourceFilesNew)) {
                TargetSetTree.this.newSourceFile(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetDefNew)) {
                TargetSetTree.this.newTargetDef(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actDelete)) {
                TargetSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Sources sources = (Sources)this.node().content();
            int n = 0;
            int n2 = string.indexOf("@");
            sources.setType(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            sources.setPathRef(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            sources.setSourceSet(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            sources.setTarget(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            sources.setLocalFlags(string.substring(n, n2));
            n = n2 + 1;
            sources.setRequire(string.substring(n));
        }
    }

    private class ehTargetPath
    extends EditHandler {
        private ehTargetPath() {
        }

        public void selected() {
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actLocNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText)) {
                this.editText(TargetSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actLocNew)) {
                TargetSetTree.this.newTargetPath((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actDelete)) {
                TargetSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            TargetPath targetPath = (TargetPath)this.node().content();
            int n = 0;
            int n2 = string.indexOf("@");
            targetPath.setPathRef(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            targetPath.setPath(string.substring(n, n2));
            n = n2 + 1;
            targetPath.setRequire(string.substring(n));
        }
    }

    private class ehTargetDef
    extends EditHandler {
        private ehTargetDef() {
        }

        public void selected() {
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText, this);
            if (!(((DocNode)this.node().getParent()).content() instanceof Sources)) {
                this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetDefNew, this);
            }
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actLocNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetSourcesNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText)) {
                this.editText(TargetSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetDefNew)) {
                TargetSetTree.this.newTargetDef((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actLocNew)) {
                TargetSetTree.this.newTargetPath(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetSourcesNew)) {
                TargetSetTree.this.newSources(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actDelete)) {
                TargetSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            TargetDef targetDef = (TargetDef)this.node().content();
            int n = 0;
            int n2 = string.indexOf("@");
            targetDef.setType(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            targetDef.setTool(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            targetDef.setLocalFlags(string.substring(n, n2));
            n = n2 + 1;
            targetDef.setRequire(string.substring(n));
        }
    }

    private class ehTargetRef
    extends EditHandler {
        private ehTargetRef() {
        }

        public void selected() {
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetRefNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText)) {
                this.editText(TargetSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetRefNew)) {
                TargetSetTree.this.newTargetRef((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actDelete)) {
                TargetSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            TargetRef targetRef = (TargetRef)this.node().content();
            int n = string.indexOf("@");
            targetRef.setTarget(string.substring(0, n));
            targetRef.setRequire(string.substring(n + 1));
        }
    }

    private class ehTarget
    extends EditHandler {
        private ehTarget() {
        }

        public void selected() {
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actOptionDefNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetRefNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetDefNew, this);
            if (this.node().getParent().getChildCount() > 2) {
                this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actDelete, this);
            }
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actGenMake, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText)) {
                this.editText(TargetSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetNew)) {
                TargetSetTree.this.newTarget((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actOptionDefNew)) {
                TargetSetTree.this.newOptions(this.node());
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetRefNew)) {
                TargetSetTree.this.newTargetRef(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetDefNew)) {
                TargetSetTree.this.newTargetDef(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actDelete)) {
                TargetSetTree.this.deleteElement(this.node());
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actGenMake)) {
                TargetSetTree.this.dx.selected(((Target)this.node().content()).getName());
                new MainMakefile(((TargetSetTree)TargetSetTree.this).userEnv.execEnv);
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Target target = (Target)this.node().content();
            int n = 0;
            int n2 = string.indexOf("@");
            target.setName(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            target.setAutoNamed(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            target.setRequire(string.substring(n, n2));
            n = n2 + 1;
            target.setDescription(string.substring(n));
            TargetSetTree.this.dx.rehash();
        }
    }

    private class ehTargetInc
    extends EditHandler {
        private ehTargetInc() {
        }

        public void selected() {
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetIncNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText)) {
                this.editText(TargetSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetIncNew)) {
                TargetSetTree.this.newTargetInc((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actDelete)) {
                TargetSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            TargetInc targetInc = (TargetInc)this.node().content();
            int n = 0;
            int n2 = string.indexOf("@");
            targetInc.setIncludeFile(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            targetInc.setIncludePath(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            targetInc.setRequire(string.substring(n, n2));
            n = n2 + 1;
            targetInc.setDescription(string.substring(n));
            TargetSetTree.this.dx.rehash();
        }
    }

    private class ehTargetSetDescr
    extends EditHandler {
        private ehTargetSetDescr() {
        }

        public void selected() {
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.editText(TargetSetTree.this.thisTree);
        }

        public void changed() {
            TargetSet targetSet = (TargetSet)this.node().content();
            targetSet.setDescription(this.node().getUserObject().toString());
        }
    }

    private class ehTargetSetName
    extends EditHandler {
        private ehTargetSetName() {
        }

        public void selected() {
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetIncNew, this);
            this.enable(((TargetSetTree)TargetSetTree.this).userEnv.actTargetNew, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actEdtText)) {
                this.editText(TargetSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetIncNew)) {
                TargetSetTree.this.newTargetInc(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((TargetSetTree)TargetSetTree.this).userEnv.actTargetNew)) {
                TargetSetTree.this.newTarget(this.node(), 0);
            }
        }

        public void changed() {
            TargetSet targetSet = (TargetSet)this.node().content();
            targetSet.setName(this.node().getUserObject().toString());
        }
    }
}

