/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocCls.ExpDir;
import bsbDocCls.OptionDef;
import bsbDocCls.Settings;
import bsbDocCls.Source;
import bsbDocCls.SourceFiles;
import bsbDocCls.SourceSet;
import bsbDocCls.SrcDir;
import bsbDocExt.OptionsExt;
import bsbDocExt.SettingsExt;
import bsbDocExt.SourceSetExt;
import bsbDocTree.DocEditor;
import bsbDocTree.DocNode;
import bsbDocTree.DocRenderer;
import bsbDocTree.DocTree;
import bsbDocTree.OptionDefTree;
import bsbEdit.EditHandler;
import bsbIcons.IconServer;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import bsbUtil.BsbList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SourceSetTree
extends DocTree
implements TreeModelListener,
TreeSelectionListener {
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private SourceSetExt dx;
    private IconServer is;
    private DocTree thisTree;
    private TreePath rp;
    private Renderer renderer;
    private File curSourcePath;

    public SourceSetTree(UserEnv userEnv, SourceSetExt sourceSetExt) {
        super(sourceSetExt.getName(), sourceSetExt);
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.dx = sourceSetExt;
        this.is = this.userEnv.is;
        this.thisTree = this;
        this.setupNodes();
        this.renderer = new Renderer();
        this.setCellRenderer(this.renderer);
        Editor editor = new Editor();
        this.setCellEditor(new DefaultTreeCellEditor(this, this.renderer, editor));
        this.getModel().addTreeModelListener(this);
        this.addTreeSelectionListener(this);
    }

    public String getName() {
        return this.dx.getName();
    }

    protected void setupNodes() {
        if (this.dx.hasGroup()) {
            SourceSetExt sourceSetExt = this.dx;
            DocNode docNode = this.getRoot().icon(this.is.doc).style(1);
            docNode.setUserObject(this.dx.getCurFile().getName());
            Vector vector = this.dx.members();
            ListIterator listIterator = vector.listIterator();
            while (listIterator.hasNext()) {
                this.dx = (SourceSetExt)listIterator.next();
                DocNode docNode2 = this.add(docNode, this.dx.getName(), this.dx, true);
                this.setupNodes(docNode2, this.is.sourceSet);
            }
            this.dx = sourceSetExt;
        } else {
            this.setupNodes(this.getRoot(), this.is.doc);
        }
    }

    protected void setupNodes(DocNode docNode, Icon icon) {
        docNode.icon(icon).style(1).handler(new ehSourceSetName());
        DocNode docNode2 = this.add(docNode, this.dx.getDescription(), this.dx, false);
        docNode2.icon(this.is.descr).style(2).handler(new ehSourceSetDescr());
        this.add(docNode2, this.dx.getCurFile().getAbsolutePath(), this.dx, false).icon(this.is.locAbs);
        SettingsExt settingsExt = (SettingsExt)this.dx.getSettings();
        OptionsExt optionsExt = (OptionsExt)settingsExt.getOptions();
        if (optionsExt == null) {
            optionsExt = new OptionsExt();
            settingsExt.setOptions(optionsExt);
        }
        docNode.addInfo1(optionsExt);
        if (optionsExt != null) {
            BsbList bsbList = optionsExt.getOptionDef();
            ListIterator listIterator = bsbList.listIterator();
            while (listIterator.hasNext()) {
                OptionDef optionDef = (OptionDef)listIterator.next();
                OptionDefTree optionDefTree = new OptionDefTree(this.userEnv, optionDef, optionsExt);
                optionDefTree.addTo(this, docNode);
            }
        }
        this.insertElement(this.dx.getSourceDirs().getSrcDir(), docNode, docNode.getChildCount(), true);
        this.insertElement(this.dx.getSourceDirs().getExpDir(), docNode, docNode.getChildCount(), true);
        this.insertElement(this.dx.getSourceFiles(), docNode, docNode.getChildCount(), true);
    }

    private DocNode insertElement(SrcDir srcDir, DocNode docNode, int n, boolean bl) {
        String string;
        String string2 = srcDir.getPathRef();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = srcDir.getPath()) == null) {
            string = "";
        }
        this.curSourcePath = new File(this.execEnv.pathSet.fullPath(string2, string));
        String string3 = string2 + "@" + string;
        DocNode docNode2 = new DocNode(string3, srcDir);
        docNode2.icon(this.is.sourceDir).handler(new ehSrcDir()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private DocNode insertElement(ExpDir expDir, DocNode docNode, int n, boolean bl) {
        String string;
        String string2;
        if (expDir == null) {
            expDir = new ExpDir();
            ((SourceSetExt)docNode.content()).getSourceDirs().setExpDir(expDir);
        }
        if ((string2 = expDir.getPathRef()) == null) {
            string2 = "";
        }
        if ((string = expDir.getPath()) == null) {
            string = "";
        }
        String string3 = string2 + "@" + string;
        DocNode docNode2 = new DocNode(string3, expDir);
        docNode2.icon(this.is.expDir).handler(new ehExpDir()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private DocNode insertElement(SourceFiles sourceFiles, DocNode docNode, int n, boolean bl) {
        DocNode docNode2 = null;
        BsbList bsbList = sourceFiles.getSource();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            docNode2 = this.insertElement((Source)listIterator.next(), docNode, n++, bl);
            docNode2.addInfo1(sourceFiles);
        }
        return docNode2;
    }

    private DocNode insertElement(Source source, DocNode docNode, int n, boolean bl) {
        String string;
        String string2;
        String string3 = source.getName();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = source.getRequire()) == null) {
            string2 = "";
        }
        if ((string = source.getLocalFlags()) == null) {
            string = "";
        }
        String string4 = string3 + "@" + string2 + "@" + string;
        DocNode docNode2 = new DocNode(string4, source);
        docNode2.icon(this.is.sourceFiles).handler(new ehSourceFiles()).isSpecialRender(true);
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private void newSourceFile(DocNode docNode, DocNode docNode2) {
        this.newSourceFile(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newSourceFile(DocNode docNode, int n) {
        Object object;
        int n2;
        for (n2 = 0; docNode.getChildCount() > n2 && !((object = ((DocNode)docNode.getChildAt(n2)).content()) instanceof Source); ++n2) {
        }
        object = new Source();
        ((Source)object).setName("name");
        ((Source)object).setRequire("require");
        ((Source)object).setLocalFlags("");
        SourceFiles sourceFiles = ((SourceSetExt)docNode.content()).getSourceFiles();
        sourceFiles.getSource().add(n == 0 ? 0 : n - n2, object);
        docNode = this.insertElement((Source)object, docNode, n == 0 ? n2 : n, true);
        docNode.addInfo1(sourceFiles);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newOptions(DocNode docNode) {
        Object object;
        Object object2;
        OptionsExt optionsExt = (OptionsExt)docNode.addInfo1();
        if (optionsExt == null) {
            object2 = (SourceSet)docNode.content();
            object = (SettingsExt)((SourceSet)object2).getSettings();
            optionsExt = new OptionsExt();
            optionsExt.setEnv(this.execEnv);
            ((Settings)object).setOptions(optionsExt);
            docNode.addInfo1(optionsExt);
        }
        object2 = new OptionDefTree(this.userEnv, null, optionsExt);
        object = ((OptionDefTree)object2).insertAt(this, docNode, 1);
        ((OptionDefTree)object2).insertAt(0);
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)object).getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private Object deleteElement(DocNode docNode) {
        DocNode docNode2;
        Object object = docNode.content();
        Object object2 = ((DocNode)docNode.getParent()).content();
        if (object instanceof Source) {
            object2 = docNode.addInfo1();
        }
        SourceSetExt sourceSetExt = this.dx;
        for (docNode2 = docNode; docNode2 != null && !(docNode2.content() instanceof SourceSetExt); docNode2 = (DocNode)docNode2.getParent()) {
        }
        if (docNode2 != null) {
            sourceSetExt = (SourceSetExt)docNode2.content();
        }
        sourceSetExt.deleteElement(object2, object);
        this.deleteNode(docNode);
        return object2;
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.userEnv.sourceSetEdit.isDirty(true);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.userEnv.sourceSetEdit.isDirty(true);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.userEnv.sourceSetEdit.isDirty(true);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.setEditable(false);
        DocNode docNode = (DocNode)this.getLastSelectedPathComponent();
        if (docNode != null) {
            docNode.handler().changed();
        }
        this.treeUpdate(this.dx.getName());
        this.userEnv.sourceSetEdit.isDirty(true);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DocNode docNode = (DocNode)this.getLastSelectedPathComponent();
        if (docNode == null) {
            return;
        }
        TreeNode[] treeNodeArray = docNode.getPath();
        boolean bl = false;
        for (int i = 0; i < treeNodeArray.length; ++i) {
            if (!(((DocNode)treeNodeArray[i]).content() instanceof OptionDef)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.userEnv.bsbNotification.putValue("SourceSetToolBar", "OPTION");
        } else {
            this.userEnv.bsbNotification.putValue("SourceSetToolBar", "SOURCE");
        }
        this.userEnv.disableNodeActions();
        this.checkNodeSelection();
        this.setEditable(false);
    }

    static /* synthetic */ File access$900(SourceSetTree sourceSetTree) {
        return sourceSetTree.curSourcePath;
    }

    private class Editor
    extends DocEditor {
        private Component[] car;
        private JTextField tf1 = new JTextField();
        private JTextField tf2 = new JTextField();
        private JTextField tf3 = new JTextField();
        private JComboBox cb1;
        private JComboBox cb2;

        public Editor() {
            this.tf1.addKeyListener(this);
            this.tf2.addKeyListener(this);
            this.tf3.addKeyListener(this);
        }

        protected Component nodeEditor(DocTree docTree, DocNode docNode, boolean bl, boolean bl2, boolean bl3, int n) {
            if (!docNode.isSpecialRender()) {
                return super.nodeEditor(docTree, docNode, bl, bl2, bl3, n);
            }
            this.car = ((JComponent)docTree.getCellRenderer().getTreeCellRendererComponent(docTree, docNode, bl, bl2, bl3, n, true)).getComponents();
            this.nodePanel.removeAll();
            String string = (String)docNode.getUserObject();
            int n2 = ((SourceSetTree)SourceSetTree.this).renderer.getPreferredSize().height;
            if (docNode.content() instanceof SrcDir) {
                this.editSrcDir(string);
            } else if (docNode.content() instanceof ExpDir) {
                this.editExpDir(string);
            } else if (docNode.content() instanceof Source) {
                this.editSource(string);
            } else {
                return super.nodeEditor(docTree, docNode, bl, bl2, bl3, n);
            }
            return this.nodePanel;
        }

        protected Object nodeValue() {
            if (!this.curNode.isSpecialRender()) {
                return super.nodeValue();
            }
            if (this.curNode.content() instanceof SrcDir) {
                return this.cb1.getSelectedItem() + "@" + this.tf1.getText();
            }
            if (this.curNode.content() instanceof ExpDir) {
                return this.cb1.getSelectedItem() + "@" + this.tf1.getText();
            }
            if (this.curNode.content() instanceof Source) {
                return this.tf1.getText() + "@" + this.tf3.getText() + "@" + this.tf2.getText();
            }
            return super.nodeValue();
        }

        private void editSrcDir(String string) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    File file2;
                    String string = (String)cb1.getSelectedItem();
                    if (string.length() > 0) {
                        string = ((SourceSetTree)((Editor)this).SourceSetTree.this).execEnv.pathSet.fullPath(string);
                    }
                    if ((file2 = EditHandler.selectDir(file = string.length() > 0 ? new File(string) : ((SourceSetTree)((Editor)this).SourceSetTree.this).userEnv.execEnv.makefileLoc, "source")) != null) {
                        string = file2.getPath();
                        if (file != null) {
                            string = EditHandler.relativePath(file, string);
                        }
                        tf1.setText(string);
                        tf1.requestFocusInWindow();
                    }
                }
            };
            JLabel jLabel = (JLabel)this.car[2];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[3];
            Vector vector = ((SourceSetTree)SourceSetTree.this).execEnv.pathSet.getList()[0];
            vector.add("");
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.cb1.setPreferredSize(dimension);
            this.nodePanel.add(this.cb1);
            Icon icon = jLabel.getText().length() > 0 ? ((SourceSetTree)SourceSetTree.this).is.locRel : ((SourceSetTree)SourceSetTree.this).is.locAbs;
            JButton jButton = new JButton(icon);
            jButton.setPreferredSize(new Dimension(SourceSetTree.this.icnw, SourceSetTree.this.icnw));
            jButton.addActionListener(actionListener);
            this.nodePanel.add(jButton);
            jLabel = (JLabel)this.car[5];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            this.tf1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf1);
        }

        private void editExpDir(String string) {
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ Editor this$1;
                {
                    this.this$1 = editor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    File file2;
                    String string = (String)Editor.access$1500(this.this$1).getSelectedItem();
                    if (string.length() > 0) {
                        string = SourceSetTree.access$1000((SourceSetTree)Editor.access$1600((Editor)this.this$1)).pathSet.fullPath(string);
                    }
                    if ((file2 = EditHandler.selectDir(file = string.length() > 0 ? new File(string) : SourceSetTree.access$500((SourceSetTree)Editor.access$1600((Editor)this.this$1)).execEnv.makefileLoc, "export")) != null) {
                        string = file2.getPath();
                        if (file != null) {
                            string = EditHandler.relativePath(file, string);
                        }
                        Editor.access$1700(this.this$1).setText(string);
                        Editor.access$1700(this.this$1).requestFocusInWindow();
                    }
                }
            };
            JLabel jLabel = (JLabel)this.car[2];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[3];
            Vector vector = ((SourceSetTree)SourceSetTree.this).execEnv.pathSet.getList()[0];
            vector.add("");
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(this);
            this.cb1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.cb1.setPreferredSize(dimension);
            this.nodePanel.add(this.cb1);
            Icon icon = jLabel.getText().length() > 0 ? ((SourceSetTree)SourceSetTree.this).is.locRel : ((SourceSetTree)SourceSetTree.this).is.locAbs;
            JButton jButton = new JButton(icon);
            jButton.setPreferredSize(new Dimension(SourceSetTree.this.icnw, SourceSetTree.this.icnw));
            jButton.addActionListener(actionListener);
            this.nodePanel.add(jButton);
            jLabel = (JLabel)this.car[5];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            this.tf1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf1);
        }

        private void editSource(String string) {
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ Editor this$1;
                {
                    this.this$1 = editor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    File file = EditHandler.selectFile(SourceSetTree.access$900(Editor.access$1600(this.this$1)), "source");
                    if (file != null) {
                        String string = file.getPath();
                        string = EditHandler.relativePath(SourceSetTree.access$900(Editor.access$1600(this.this$1)), string);
                        Editor.access$1700(this.this$1).setText(string);
                        Editor.access$1700(this.this$1).requestFocusInWindow();
                    }
                }
            };
            JLabel jLabel = (JLabel)this.car[2];
            JButton jButton = new JButton(jLabel.getIcon());
            jButton.setPreferredSize(new Dimension(SourceSetTree.this.icnw, SourceSetTree.this.icnw));
            jButton.addActionListener(actionListener);
            this.nodePanel.add(jButton);
            jLabel = (JLabel)this.car[3];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            jLabel = (JLabel)this.car[4];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[5];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
            jLabel = (JLabel)this.car[6];
            jLabel.setVisible(true);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[7];
            this.tf3.setText(jLabel.getText());
            this.tf3.setFont(jLabel.getFont());
            this.tf3.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf3);
        }
    }

    private class Renderer
    extends DocRenderer {
        int vw;
        int sx1;
        int sx2;
        int sx3;
        int sx4;

        public Renderer() {
            super(SourceSetTree.this.fontDefault);
        }

        protected Component nodeRenderer(DocNode docNode, boolean bl) {
            if (!docNode.isSpecialRender()) {
                return super.nodeRenderer(docNode, bl);
            }
            this.vw = SourceSetTree.this.viewWidth / 10;
            this.sx1 = this.vw * 3 - docNode.getLevel() * 20;
            this.sx2 = this.vw * 2;
            this.sx3 = this.vw * 2;
            this.sx4 = this.vw * 3 - 15;
            this.nodePanel.removeAll();
            String string = (String)docNode.getUserObject();
            if (docNode.content() instanceof SrcDir) {
                this.renderSrcDir(docNode, string);
            } else if (docNode.content() instanceof ExpDir) {
                this.renderExpDir(docNode, string);
            } else if (docNode.content() instanceof Source) {
                this.renderSource(docNode, string);
            }
            this.nodePanel.setOpaque(bl);
            this.setVisible(false);
            this.nodePanel.setVisible(true);
            return this.nodePanel;
        }

        private void renderSrcDir(DocNode docNode, String string) {
            this.addLabel(docNode.icon(), "", SourceSetTree.this.fontDefault, this.icnw, true);
            int n = string.indexOf("@");
            this.addLabel(((SourceSetTree)SourceSetTree.this).is.pathRef, string.substring(0, n), SourceSetTree.this.fontBold, this.sx1 + this.sx2 - this.icnw, true);
            string = string.substring(n + 1);
            this.addLabel(((SourceSetTree)SourceSetTree.this).is.locRel, string, SourceSetTree.this.fontDefault, this.sx3 + this.sx4, false);
        }

        private void renderExpDir(DocNode docNode, String string) {
            this.addLabel(docNode.icon(), "", SourceSetTree.this.fontDefault, this.icnw, true);
            int n = string.indexOf("@");
            this.addLabel(((SourceSetTree)SourceSetTree.this).is.pathRef, string.substring(0, n), SourceSetTree.this.fontBold, this.sx1 + this.sx2 - this.icnw, true);
            string = string.substring(n + 1);
            this.addLabel(((SourceSetTree)SourceSetTree.this).is.locRel, string, SourceSetTree.this.fontDefault, this.sx3 + this.sx4, false);
        }

        private void renderSource(DocNode docNode, String string) {
            this.addLabel(docNode.icon(), "", SourceSetTree.this.fontDefault, this.icnw, true);
            int n = string.indexOf("@");
            this.addLabel(((SourceSetTree)SourceSetTree.this).is.sourceFile, string.substring(0, n), SourceSetTree.this.fontBold, this.sx1 + this.sx2 - this.icnw, true);
            string = string.substring(n + 1);
            n = string.indexOf("@");
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            this.addLabel(((SourceSetTree)SourceSetTree.this).is.flags, string, SourceSetTree.this.fontDefault, this.sx3, false);
            this.addLabel(((SourceSetTree)SourceSetTree.this).is.require, string2, SourceSetTree.this.fontDefault, this.sx4, false);
        }
    }

    private class ehSourceFiles
    extends EditHandler {
        private ehSourceFiles() {
        }

        public void selected() {
            this.enable(((SourceSetTree)SourceSetTree.this).userEnv.actEdtText, this);
            this.enable(((SourceSetTree)SourceSetTree.this).userEnv.actSourceFilesNew, this);
            this.enable(((SourceSetTree)SourceSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((SourceSetTree)SourceSetTree.this).userEnv.actEdtText)) {
                this.editText(SourceSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((SourceSetTree)SourceSetTree.this).userEnv.actSourceFilesNew)) {
                SourceSetTree.this.newSourceFile((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((SourceSetTree)SourceSetTree.this).userEnv.actDelete)) {
                SourceSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            Source source = (Source)this.node().content();
            int n = 0;
            int n2 = string.indexOf("@");
            source.setName(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            source.setRequire(string.substring(n, n2));
            n = n2 + 1;
            source.setLocalFlags(string.substring(n));
        }
    }

    private class ehExpDir
    extends EditHandler {
        private ehExpDir() {
        }

        public void selected() {
            this.enable(((SourceSetTree)SourceSetTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((SourceSetTree)SourceSetTree.this).userEnv.actEdtText)) {
                this.editText(SourceSetTree.this.thisTree);
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            ExpDir expDir = (ExpDir)this.node().content();
            int n = string.indexOf("@");
            expDir.setPathRef(string.substring(0, n));
            expDir.setPath(string.substring(n + 1));
        }
    }

    private class ehSrcDir
    extends EditHandler {
        private ehSrcDir() {
        }

        public void selected() {
            this.enable(((SourceSetTree)SourceSetTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((SourceSetTree)SourceSetTree.this).userEnv.actEdtText)) {
                this.editText(SourceSetTree.this.thisTree);
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            SrcDir srcDir = (SrcDir)this.node().content();
            int n = string.indexOf("@");
            srcDir.setPathRef(string.substring(0, n));
            srcDir.setPath(string.substring(n + 1));
            SourceSetTree.this.curSourcePath = new File(((SourceSetTree)SourceSetTree.this).execEnv.pathSet.fullPath(srcDir.getPathRef(), srcDir.getPath()));
        }
    }

    private class ehSourceSetDescr
    extends EditHandler {
        private ehSourceSetDescr() {
        }

        public void selected() {
            this.enable(((SourceSetTree)SourceSetTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.editText(SourceSetTree.this.thisTree);
        }

        public void changed() {
            SourceSet sourceSet = (SourceSet)this.node().content();
            sourceSet.setDescription(this.node().getUserObject().toString());
        }
    }

    private class ehSourceSetName
    extends EditHandler {
        private ehSourceSetName() {
        }

        public void selected() {
            this.enable(((SourceSetTree)SourceSetTree.this).userEnv.actEdtText, this);
            this.enable(((SourceSetTree)SourceSetTree.this).userEnv.actOptionDefNew, this);
            this.enable(((SourceSetTree)SourceSetTree.this).userEnv.actSourceFilesNew, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((SourceSetTree)SourceSetTree.this).userEnv.actEdtText)) {
                this.editText(SourceSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((SourceSetTree)SourceSetTree.this).userEnv.actOptionDefNew)) {
                SourceSetTree.this.newOptions(this.node());
            }
            if (actionEvent.getSource().equals(((SourceSetTree)SourceSetTree.this).userEnv.actSourceFilesNew)) {
                SourceSetTree.this.newSourceFile(this.node(), 0);
            }
        }

        public void changed() {
            SourceSet sourceSet = (SourceSet)this.node().content();
            sourceSet.setName(this.node().getUserObject().toString());
        }
    }
}

