/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocTree.DocNode;
import bsbDocTree.DocRenderer;
import bsbDocTree.DocTree;
import bsbEdit.ConfigDefEdit;
import bsbEdit.ConfigSetEdit;
import bsbEdit.EditHandler;
import bsbEdit.OptionSetEdit;
import bsbEdit.PathSetEdit;
import bsbEdit.SourceSetEdit;
import bsbEdit.TargetSetEdit;
import bsbEdit.ToolSetEdit;
import bsbException.External;
import bsbException.Panic;
import bsbIcons.IconServer;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import bsbMain.settings.Path;
import bsbMain.settings.PathHist;
import bsbMain.settings.Settings;
import bsbMain.settings.SettingsExt;
import bsbUtil.BsbList;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class SettingsTree
extends DocTree
implements TreeModelListener,
TreeSelectionListener {
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private SettingsExt sx;
    private IconServer is;

    public SettingsTree(UserEnv userEnv) {
        super(userEnv.execEnv.settings.getName(), userEnv.execEnv.settings);
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.sx = this.execEnv.settings;
        this.is = this.userEnv.is;
        this.setupNodes();
        this.setCellRenderer(new DocRenderer(this.getFont()));
        this.getModel().addTreeModelListener(this);
        this.addTreeSelectionListener(this);
    }

    public String getName() {
        return this.sx.getName();
    }

    protected void setupNodes() {
        DocNode docNode = this.getRoot();
        docNode.icon(this.is.docSet).style(1).handler(new ehSettingsName());
        docNode = this.add(null, this.sx.getDescription(), this.sx, false);
        docNode.icon(this.is.descr).style(2).handler(new ehSettingsDescr());
        docNode = this.add(docNode, this.sx.getCurFile().getAbsolutePath(), this.sx, false);
        docNode.icon(this.is.locAbs).handler(new ehSettingsPath());
        BsbList bsbList = this.sx.getPath();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Path path = (Path)listIterator.next();
            docNode = this.add(null, path.getName(), path, true);
            docNode.icon(this.is.doc).style(1).handler(new ehPathName());
            BsbList bsbList2 = path.getPathHist();
            ListIterator listIterator2 = bsbList2.listIterator();
            if (!listIterator2.hasNext()) continue;
            PathHist pathHist = (PathHist)listIterator2.next();
            docNode = this.add(docNode, pathHist.getPath(), pathHist, true);
            docNode.icon(this.pathIcon(this.sx, pathHist)).handler(new ehPathDocPath());
            while (listIterator2.hasNext()) {
                pathHist = (PathHist)listIterator2.next();
                this.add(docNode, pathHist.getPath(), pathHist, false).icon(this.pathIcon(this.sx, pathHist)).handler(new ehPathHistPath());
            }
        }
    }

    private Icon pathIcon(SettingsExt settingsExt, PathHist pathHist) {
        return settingsExt.isValid(pathHist) ? (settingsExt.isAbsolute(pathHist) ? this.is.locAbs : this.is.locRel) : this.is.locErr;
    }

    private boolean loadDocument(String string) {
        if (string.equals("ConfigSet")) {
            return this.userEnv.reload(new ConfigSetEdit());
        }
        if (string.equals("ConfigDef")) {
            return this.userEnv.reload(new ConfigDefEdit());
        }
        if (string.equals("OptionSet")) {
            return this.userEnv.reload(new OptionSetEdit());
        }
        if (string.equals("PathSet")) {
            return this.userEnv.reload(new PathSetEdit());
        }
        if (string.equals("TargetSet")) {
            return this.userEnv.reload(new TargetSetEdit());
        }
        if (string.equals("ToolSet")) {
            return this.userEnv.reload(new ToolSetEdit());
        }
        if (string.equals("SourceSet")) {
            return this.userEnv.reload(new SourceSetEdit());
        }
        throw new Panic("Unknown document type: <" + string + ">");
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.userEnv.settingsEdit.isDirty(true);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.userEnv.settingsEdit.isDirty(true);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.userEnv.settingsEdit.isDirty(true);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.setEditable(false);
        Object[] objectArray = treeModelEvent.getPath();
        Object[] objectArray2 = treeModelEvent.getChildren();
        DocNode docNode = objectArray2 == null || objectArray2.length == 0 ? (DocNode)objectArray[objectArray.length - 1] : (DocNode)objectArray2[objectArray2.length - 1];
        docNode.handler().changed();
        this.userEnv.settingsEdit.isDirty(true);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.userEnv.disableNodeActions();
        this.checkNodeSelection();
        this.setEditable(false);
    }

    private class ehPathHistPath
    extends EditHandler {
        private ehPathHistPath() {
        }

        public void selected() {
            if (!this.node().icon().equals(((SettingsTree)SettingsTree.this).is.locErr)) {
                this.enable(((SettingsTree)SettingsTree.this).userEnv.actSelDir, this);
            }
            this.enable(((SettingsTree)SettingsTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((SettingsTree)SettingsTree.this).userEnv.actSelDir)) {
                DocNode docNode = (DocNode)this.node().getParent().getParent();
                String string = ((Path)docNode.content()).getName();
                File file = new File(this.node().getUserObject().toString());
                if (file == null) {
                    return;
                }
                File file2 = file;
                if (!file.isAbsolute()) {
                    file2 = new File(SettingsTree.this.sx.getDocRoot(), file.getPath());
                }
                try {
                    file2 = file2.getCanonicalFile();
                }
                catch (Exception exception) {
                    new External(exception).handle();
                    return;
                }
                SettingsTree.this.change((DocNode)this.node().getParent(), file.getPath());
                SettingsTree.this.loadDocument(string);
                return;
            }
            if (actionEvent.getSource().equals(((SettingsTree)SettingsTree.this).userEnv.actDelete)) {
                PathHist pathHist = (PathHist)this.node().content();
                Path path = (Path)((DocNode)this.node().getParent().getParent()).content();
                path.getPathHist().remove(pathHist);
                SettingsTree.this.remove(this.node());
                return;
            }
        }
    }

    private class ehPathDocPath
    extends EditHandler {
        private ehPathDocPath() {
        }

        public void selected() {
            this.enable(((SettingsTree)SettingsTree.this).userEnv.actEdtDir, this);
            if (!this.node().icon().equals(((SettingsTree)SettingsTree.this).is.locErr)) {
                this.enable(((SettingsTree)SettingsTree.this).userEnv.actFlipAbsRel, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((SettingsTree)SettingsTree.this).userEnv.actEdtDir)) {
                File file;
                DocNode docNode = (DocNode)this.node().getParent();
                String string = ((Path)docNode.content()).getName();
                File file2 = new File(((PathHist)this.node().content()).getPath());
                if (!file2.isAbsolute()) {
                    file2 = new File(SettingsTree.this.sx.getDocRoot(), file2.getPath());
                }
                if ((file = ehPathDocPath.selectFile(file2.getParentFile(), string)) == null) {
                    return;
                }
                try {
                    file2 = file2.getCanonicalFile();
                    file = file.getCanonicalFile();
                }
                catch (Exception exception) {
                    new External(exception).handle();
                    return;
                }
                if (!SettingsTree.this.loadDocument(string)) {
                    return;
                }
                if (!file2.equals(file)) {
                    String string2 = ehPathDocPath.relativePath(SettingsTree.this.sx.getDocRoot(), file.getPath());
                    SettingsTree.this.change(this.node(), string2);
                }
                SettingsTree.this.loadDocument(string);
                return;
            }
            if (actionEvent.getSource().equals(((SettingsTree)SettingsTree.this).userEnv.actFlipAbsRel)) {
                String string = this.node().getUserObject().toString();
                string = this.node().icon().equals(((SettingsTree)SettingsTree.this).is.locAbs) ? ehPathDocPath.relativePath(SettingsTree.this.sx.getDocRoot(), string) : SettingsTree.this.sx.getDoc(string).getAbsolutePath();
                SettingsTree.this.change(this.node(), string);
                return;
            }
        }

        public void changed() {
            PathHist pathHist = new PathHist();
            pathHist.setPath(this.node().getUserObject().toString());
            PathHist pathHist2 = (PathHist)this.node().content();
            SettingsTree.this.change(this.node(), pathHist);
            this.node().icon(SettingsTree.this.pathIcon(SettingsTree.this.sx, pathHist));
            DocNode docNode = SettingsTree.this.insert(0, this.node(), new DocNode(pathHist2.getPath(), pathHist2), false);
            docNode.icon(SettingsTree.this.pathIcon(SettingsTree.this.sx, pathHist2)).handler(new ehPathHistPath());
            Path path = (Path)((DocNode)this.node().getParent()).content();
            BsbList bsbList = path.getPathHist();
            bsbList.add(0, pathHist);
            File file = new File(pathHist.getPath());
            if (!file.isAbsolute()) {
                file = new File(SettingsTree.this.sx.getDocRoot(), pathHist.getPath());
            }
            try {
                file = file.getCanonicalFile();
            }
            catch (Exception exception) {
                new External(exception).handle();
                return;
            }
            for (int i = 1; i < bsbList.size(); ++i) {
                File file2 = new File(((PathHist)bsbList.get(i)).getPath());
                if (!file2.isAbsolute()) {
                    file2 = new File(SettingsTree.this.sx.getDocRoot(), file2.getPath());
                }
                try {
                    file2 = file2.getCanonicalFile();
                }
                catch (Exception exception) {
                    new External(exception).handle();
                    return;
                }
                if (!file.equals(file2)) continue;
                SettingsTree.this.remove((DocNode)this.node().getChildAt(i - 1));
                bsbList.remove(i);
                --i;
            }
        }
    }

    private class ehPathName
    extends EditHandler {
        private ehPathName() {
        }

        public void selected() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ehSettingsPath
    extends EditHandler {
        private ehSettingsPath() {
        }

        public void selected() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class ehSettingsDescr
    extends EditHandler {
        private ehSettingsDescr() {
        }

        public void selected() {
            this.enable(((SettingsTree)SettingsTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SettingsTree.this.setEditable(true);
            SettingsTree.this.startEditingAtPath(SettingsTree.this.getSelectionPath());
        }

        public void changed() {
            Settings settings = (Settings)this.node().content();
            settings.setDescription(this.node().getUserObject().toString());
        }
    }

    private class ehSettingsName
    extends EditHandler {
        private ehSettingsName() {
        }

        public void selected() {
            this.enable(((SettingsTree)SettingsTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SettingsTree.this.setEditable(true);
            SettingsTree.this.startEditingAtPath(SettingsTree.this.getSelectionPath());
        }

        public void changed() {
            Settings settings = (Settings)this.node().content();
            settings.setName(this.node().getUserObject().toString());
        }
    }
}

