/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocCls.Path;
import bsbDocCls.PathInc;
import bsbDocCls.PathSet;
import bsbDocCls.PathTree;
import bsbDocExt.PathSetExt;
import bsbDocExt.PathTreeExt;
import bsbDocTree.DocEditor;
import bsbDocTree.DocNode;
import bsbDocTree.DocRenderer;
import bsbDocTree.DocTree;
import bsbEdit.EditHandler;
import bsbException.External;
import bsbIcons.IconServer;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import bsbUtil.BsbList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreePath;

public class PathSetTree
extends DocTree
implements TreeModelListener,
TreeSelectionListener {
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private PathSetExt px;
    private IconServer is;
    private DocTree thisTree;
    private boolean noTreeUpdate = false;
    private Renderer renderer;

    public PathSetTree(UserEnv userEnv) {
        super(userEnv.execEnv.pathSet.getName(), userEnv.execEnv.pathSet);
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.px = this.execEnv.pathSet;
        this.is = this.userEnv.is;
        this.thisTree = this;
        this.setupNodes();
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.renderer = new Renderer();
        this.setCellRenderer(this.renderer);
        Editor editor = new Editor();
        this.setCellEditor(new DefaultTreeCellEditor(this, this.renderer, editor));
        this.getModel().addTreeModelListener(this);
        this.addTreeSelectionListener(this);
    }

    public String getName() {
        return this.px.getName();
    }

    protected void setupNodes() {
        DocNode docNode = this.getRoot();
        docNode.icon(this.is.doc).style(1).handler(new ehPathSetName());
        DocNode docNode2 = this.add(null, this.px.getDescription(), this.px, false);
        docNode2.icon(this.is.descr).style(2).handler(new ehPathSetDescr());
        this.add(docNode2, this.px.getCurFile().getAbsolutePath(), this.px, false).icon(this.is.locAbs);
        BsbList bsbList = this.px.getPathTree();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((PathTreeExt)listIterator.next(), docNode, docNode.getChildCount(), true);
        }
    }

    private DocNode insertElement(PathTreeExt pathTreeExt, DocNode docNode, int n, boolean bl) {
        PathTreeNode pathTreeNode = new PathTreeNode(pathTreeExt);
        pathTreeNode.handler(new ehPathTree());
        this.insert(n, docNode, pathTreeNode, bl);
        BsbList bsbList = pathTreeExt.getPath();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((Path)listIterator.next(), (DocNode)pathTreeNode, pathTreeNode.getChildCount(), false);
        }
        BsbList bsbList2 = pathTreeExt.getPathInc();
        ListIterator listIterator2 = bsbList2.listIterator();
        while (listIterator2.hasNext()) {
            this.insertElement((PathInc)listIterator2.next(), (DocNode)pathTreeNode, pathTreeNode.getChildCount(), false);
        }
        BsbList bsbList3 = pathTreeExt.getPathTree();
        ListIterator listIterator3 = bsbList3.listIterator();
        while (listIterator3.hasNext()) {
            this.insertElement((PathTreeExt)listIterator3.next(), (DocNode)pathTreeNode, pathTreeNode.getChildCount(), false);
        }
        return pathTreeNode;
    }

    private DocNode insertElement(Path path, DocNode docNode, int n, boolean bl) {
        PathNode pathNode = new PathNode(path);
        if (docNode.parent().content() instanceof PathSet) {
            pathNode.handler(new ehPathRootValue());
        } else {
            pathNode.handler(new ehPathValue());
        }
        this.insert(n, docNode, pathNode, bl);
        return pathNode;
    }

    private DocNode insertElement(PathInc pathInc, DocNode docNode, int n, boolean bl) {
        PathIncNode pathIncNode = new PathIncNode(pathInc);
        pathIncNode.handler(new ehPathInc());
        this.insert(n, docNode, pathIncNode, bl);
        return pathIncNode;
    }

    private Icon pathIcon(Path path) {
        String string = path.get_Value();
        if (string == null) {
            string = "";
        }
        if (string.matches(".+:.+") || string.matches("^[\\\\/]+.*")) {
            return this.is.locAbs;
        }
        return this.is.locRel;
    }

    private Path newPath() {
        Path path = new Path();
        path.set_Value("set location");
        return path;
    }

    private PathInc newPathInc() {
        PathInc pathInc = new PathInc();
        pathInc.setIncludeFile("#inc-pathset");
        pathInc.setIncludePath("");
        pathInc.setRequire("");
        pathInc.setDescription("add description");
        return pathInc;
    }

    private PathTreeExt newPathTree() {
        PathTreeExt pathTreeExt = new PathTreeExt();
        pathTreeExt.setName("new path tree");
        pathTreeExt.setDescription("add description");
        pathTreeExt.getPath().add(this.newPath());
        return pathTreeExt;
    }

    private void deleteElement(DocNode docNode) {
        int[] nArray = this.getSelectionRows();
        Object object = docNode.content();
        if (object instanceof PathTree) {
            this.px.delChild(((DocNode)docNode.getParent()).content(), (PathTreeExt)object);
        } else if (object instanceof PathInc) {
            this.px.delChild(((DocNode)docNode.getParent()).content(), (PathInc)object);
        } else if (object instanceof Path) {
            this.px.delChild(((DocNode)docNode.getParent()).content(), (Path)object);
        } else {
            throw new RuntimeException("invalid node");
        }
        this.remove(docNode);
        this.setSelectionRows(nArray);
    }

    private DocNode addChild(PathTreeExt pathTreeExt, DocNode docNode) {
        Object object;
        int n = 1;
        if (docNode.content() instanceof PathTree) {
            object = (PathTreeExt)docNode.content();
            n = ((PathTree)object).getPath().size();
            n += ((PathTree)object).getPathInc().size();
        }
        this.px.addChild(docNode.content(), pathTreeExt);
        object = this.insertElement(pathTreeExt, docNode, n, true);
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)object).getPath());
        this.setSelectionPath(treePath);
        this.expandPath(treePath);
        return object;
    }

    private DocNode addChild(PathInc pathInc, DocNode docNode) {
        int n = ((PathTreeExt)docNode.content()).getPath().size();
        this.px.addChild(docNode.content(), pathInc);
        DocNode docNode2 = this.insertElement(pathInc, docNode, n, true);
        this.setSelectionPath(new TreePath(docNode2.getPath()));
        return docNode2;
    }

    private DocNode addChild(Path path, DocNode docNode) {
        this.px.addChild(docNode.content(), path);
        DocNode docNode2 = this.insertElement(path, docNode, 0, true);
        this.setSelectionPath(new TreePath(docNode2.getPath()));
        return docNode2;
    }

    private DocNode addSibling(PathTreeExt pathTreeExt, DocNode docNode) {
        DocNode docNode2 = (DocNode)docNode.getParent();
        this.px.addSibling(docNode.content(), docNode2.content(), pathTreeExt);
        DocNode docNode3 = this.insertElement(pathTreeExt, docNode2, docNode2.getIndex(docNode) + 1, true);
        TreePath treePath = new TreePath(docNode3.getPath());
        this.setSelectionPath(treePath);
        this.expandPath(treePath);
        return docNode3;
    }

    private DocNode addSibling(PathInc pathInc, DocNode docNode) {
        DocNode docNode2 = (DocNode)docNode.getParent();
        this.px.addSibling(docNode.content(), docNode2.content(), pathInc);
        DocNode docNode3 = this.insertElement(pathInc, docNode2, docNode2.getIndex(docNode) + 1, true);
        this.setSelectionPath(new TreePath(docNode3.getPath()));
        return docNode3;
    }

    private DocNode addSibling(Path path, DocNode docNode) {
        DocNode docNode2 = (DocNode)docNode.getParent();
        this.px.addSibling(docNode.content(), docNode2.content(), path);
        DocNode docNode3 = this.insertElement(path, docNode2, docNode2.getIndex(docNode) + 1, true);
        this.setSelectionPath(new TreePath(docNode3.getPath()));
        return docNode3;
    }

    private void flipAbsRelRoot(DocNode docNode) {
        Icon icon = docNode.icon();
        Path path = (Path)docNode.content();
        String string = path.get_Value();
        if (icon == this.is.locAbs) {
            string = EditHandler.relativePath(this.px.getCurFile(), string);
        } else {
            try {
                string = new File(this.px.getOffset() + File.separator + string).getCanonicalPath();
            }
            catch (Exception exception) {
                new External(exception).handle();
            }
        }
        if (string != null && string.length() > 0) {
            String string2;
            path.set_Value(string);
            String string3 = path.getRequire();
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = path.getAutoNamed()) == null) {
                string2 = "";
            }
            this.change(docNode, string + "@" + string2 + "@" + string3);
        }
    }

    private void flipAbsRel(DocNode docNode) {
        String string;
        PathTree pathTree = (PathTree)((DocNode)docNode.getParent()).content();
        Path path = (Path)docNode.content();
        String string2 = (String)docNode.getUserObject();
        String string3 = path.get_Value();
        String string4 = path.getRequire();
        if (string4 == null) {
            string4 = "";
        }
        if ((string = path.getAutoNamed()) == null) {
            string = "";
        }
        String string5 = "not found";
        try {
            string5 = new File(this.px.fullPath(pathTree.getName())).getCanonicalPath();
        }
        catch (Exception exception) {
            new External(exception).handle();
        }
        if (string2.equals(string3 + "@" + string + "@" + string4)) {
            string3 = string5;
        }
        this.noTreeUpdate = true;
        this.change(docNode, string3 + "@" + string + "@" + string4);
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.userEnv.pathSetEdit.isDirty(true);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.userEnv.pathSetEdit.isDirty(true);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.userEnv.pathSetEdit.isDirty(true);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.setEditable(false);
        DocNode docNode = (DocNode)this.getLastSelectedPathComponent();
        if (this.noTreeUpdate) {
            this.noTreeUpdate = false;
            return;
        }
        if (docNode != null) {
            docNode.handler().changed();
        }
        this.treeUpdate(this.px.getName());
        this.userEnv.pathSetEdit.isDirty(true);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.userEnv.disableNodeActions();
        this.checkNodeSelection();
        this.setEditable(false);
    }

    private class Editor
    extends DocEditor {
        Component[] car;
        PathSetNode cpsn;

        private Editor() {
        }

        protected Component nodeEditor(DocTree docTree, DocNode docNode, boolean bl, boolean bl2, boolean bl3, int n) {
            if (!docNode.isSpecialRender()) {
                return super.nodeEditor(docTree, docNode, bl, bl2, bl3, n);
            }
            this.cpsn = (PathSetNode)this.curNode;
            PathSetNode pathSetNode = (PathSetNode)docNode;
            this.car = ((JComponent)docTree.getCellRenderer().getTreeCellRendererComponent(docTree, docNode, bl, bl2, bl3, n, true)).getComponents();
            this.nodePanel.removeAll();
            pathSetNode.edit(this);
            return this.nodePanel;
        }

        protected Object nodeValue() {
            if (!this.curNode.isSpecialRender()) {
                return super.nodeValue();
            }
            return ((PathSetNode)this.curNode).value();
        }
    }

    private class Renderer
    extends DocRenderer {
        int vw;
        int sx1;
        int sx2;
        int sx3;
        int sx4;

        public Renderer() {
            super(PathSetTree.this.fontDefault);
        }

        protected Component nodeRenderer(DocNode docNode, boolean bl) {
            if (!docNode.isSpecialRender()) {
                return super.nodeRenderer(docNode, bl);
            }
            PathSetNode pathSetNode = (PathSetNode)docNode;
            this.vw = PathSetTree.this.viewWidth / 10;
            this.sx1 = this.vw * 3 - docNode.getLevel() * 20;
            this.sx2 = this.vw * 2;
            this.sx3 = this.vw * 2;
            this.sx4 = this.vw * 3 - 15;
            this.nodePanel.removeAll();
            pathSetNode.render(this);
            this.nodePanel.setOpaque(bl);
            this.setVisible(false);
            this.nodePanel.setVisible(true);
            return this.nodePanel;
        }
    }

    private class ehPathValue
    extends EditHandler {
        private ehPathValue() {
        }

        public void selected() {
            PathTree pathTree = (PathTree)((DocNode)this.node().getParent()).content();
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actEdtText, this);
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actLocNew, this);
            if (pathTree.getPath().size() > 1) {
                this.enable(((PathSetTree)PathSetTree.this).userEnv.actDelete, this);
            }
            if (new File(PathSetTree.this.px.fullPath(pathTree.getName())).exists()) {
                this.enable(((PathSetTree)PathSetTree.this).userEnv.actFlipAbsRel, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actEdtText)) {
                this.editText(PathSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actFlipAbsRel)) {
                PathSetTree.this.flipAbsRel(this.node());
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actLocNew)) {
                PathSetTree.this.addSibling(PathSetTree.this.newPath(), this.node());
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actDelete)) {
                PathSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            ((PathNode)this.node()).changed();
        }
    }

    private class ehPathRootValue
    extends EditHandler {
        private ehPathRootValue() {
        }

        public void selected() {
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actEdtText, this);
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actLocNew, this);
            if (this.node().icon() != ((PathSetTree)PathSetTree.this).is.locErr) {
                this.enable(((PathSetTree)PathSetTree.this).userEnv.actFlipAbsRel, this);
            }
            if (this.node().getParent().getChildCount() > 1) {
                this.enable(((PathSetTree)PathSetTree.this).userEnv.actDelete, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actEdtText)) {
                this.editText(PathSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actLocNew)) {
                PathSetTree.this.addSibling(PathSetTree.this.newPath(), this.node());
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actFlipAbsRel)) {
                PathSetTree.this.flipAbsRelRoot(this.node());
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actDelete)) {
                PathSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            ((PathNode)this.node()).changed();
        }
    }

    private class ehPathInc
    extends EditHandler {
        private ehPathInc() {
        }

        public void selected() {
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actEdtText, this);
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actPathIncNew, this);
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actEdtText)) {
                this.editText(PathSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actPathIncNew)) {
                PathSetTree.this.addSibling(PathSetTree.this.newPathInc(), this.node());
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actDelete)) {
                PathSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            ((PathIncNode)this.node()).changed();
        }
    }

    private class ehPathTree
    extends EditHandler {
        private ehPathTree() {
        }

        public void selected() {
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actEdtText, this);
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actPathTreeNew, this);
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actPathIncNew, this);
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actLocNew, this);
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actEdtText)) {
                this.editText(PathSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actPathTreeNew)) {
                if (PathSetTree.this.isExpanded(PathSetTree.this.getSelectionPath())) {
                    PathSetTree.this.addChild(PathSetTree.this.newPathTree(), this.node());
                } else {
                    PathSetTree.this.addSibling(PathSetTree.this.newPathTree(), this.node());
                }
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actPathIncNew)) {
                PathSetTree.this.addChild(PathSetTree.this.newPathInc(), this.node());
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actLocNew)) {
                PathSetTree.this.addChild(PathSetTree.this.newPath(), this.node());
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actDelete)) {
                PathSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            ((PathTreeNode)this.node()).changed();
        }
    }

    private class ehPathSetDescr
    extends EditHandler {
        private ehPathSetDescr() {
        }

        public void selected() {
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.editText(PathSetTree.this.thisTree);
        }

        public void changed() {
            PathSet pathSet = (PathSet)this.node().content();
            pathSet.setDescription(this.node().getUserObject().toString());
        }
    }

    private class ehPathSetName
    extends EditHandler {
        private ehPathSetName() {
        }

        public void selected() {
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actEdtText, this);
            this.enable(((PathSetTree)PathSetTree.this).userEnv.actPathTreeNew, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actEdtText)) {
                this.editText(PathSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((PathSetTree)PathSetTree.this).userEnv.actPathTreeNew)) {
                PathSetTree.this.addChild(PathSetTree.this.newPathTree(), PathSetTree.this.getRoot());
            }
        }

        public void changed() {
            PathSet pathSet = (PathSet)this.node().content();
            pathSet.setName(this.node().getUserObject().toString());
        }
    }

    private class PathNode
    extends PathSetNode {
        public PathNode(Path path) {
            String string;
            String string2;
            String string3 = path.get_Value();
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = path.getAutoNamed()) == null) {
                string2 = "";
            }
            if ((string = path.getRequire()) == null) {
                string = "";
            }
            this.setUserObject(string3 + "@" + string2 + "@" + string);
            this.content(path);
            this.icon(PathSetTree.this.pathIcon(path));
            this.isSpecialRender(true);
        }

        public void render(Renderer renderer) {
            String string = (String)this.getUserObject();
            int n = 0;
            int n2 = string.indexOf("@");
            renderer.addLabel(this.icon(), string.substring(n, n2), PathSetTree.this.fontDefault, renderer.sx1 + renderer.sx2, true);
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            renderer.addLabel(((PathSetTree)PathSetTree.this).is.autoNamed, string.substring(n, n2), PathSetTree.this.fontDefault, renderer.sx3, false);
            n = n2 + 1;
            renderer.addLabel(((PathSetTree)PathSetTree.this).is.require, string.substring(n), PathSetTree.this.fontDefault, renderer.sx4, false);
        }

        public void edit(Editor editor) {
            this.curNode = editor.cpsn;
            this.tf1.addKeyListener(editor);
            this.tf2.addKeyListener(editor);
            JLabel jLabel = (JLabel)editor.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= PathSetTree.this.icnw + editor.tg;
            this.tf1.setPreferredSize(dimension);
            editor.nodePanel.add(this.tf1);
            Icon icon = ((PathSetTree)PathSetTree.this).is.locRel;
            JButton jButton = new JButton(icon);
            jButton.setPreferredSize(new Dimension(PathSetTree.this.icnw, PathSetTree.this.icnw));
            jButton.addActionListener(new Alc());
            editor.nodePanel.add(jButton);
            Vector<String> vector = new Vector<String>();
            vector.add("");
            Vector[] vectorArray = ((PathSetTree)PathSetTree.this).execEnv.optionSet.getCondValueList();
            ListIterator listIterator = vectorArray[0].listIterator();
            ListIterator listIterator2 = vectorArray[1].listIterator();
            while (listIterator2.hasNext()) {
                String string = (String)listIterator.next();
                if (!listIterator2.next().equals("AutoNamed")) continue;
                vector.add(string);
            }
            editor.nodePanel.add(editor.car[2]);
            ((JLabel)editor.car[2]).setVisible(true);
            jLabel = (JLabel)editor.car[3];
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(editor);
            this.cb1.setFont(jLabel.getFont());
            this.cb1.setPreferredSize(jLabel.getPreferredSize());
            editor.nodePanel.add(this.cb1);
            editor.nodePanel.add(editor.car[4]);
            ((JLabel)editor.car[4]).setVisible(true);
            jLabel = (JLabel)editor.car[5];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            editor.nodePanel.add(this.tf2);
        }

        public String value() {
            return this.tf1.getText() + "@" + this.cb1.getSelectedItem() + "@" + this.tf2.getText();
        }

        public void changed() {
            String string = (String)this.getUserObject();
            Path path = (Path)this.content();
            int n = 0;
            int n2 = string.indexOf("@");
            path.set_Value(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            path.setAutoNamed(string.substring(n, n2));
            n = n2 + 1;
            path.setRequire(string.substring(n));
            this.icon(PathSetTree.this.pathIcon(path));
        }

        private class Alc
        implements ActionListener {
            private Alc() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = string = PathNode.this.tf1.getText();
                DocNode docNode = PathNode.this.curNode.parent().parent();
                if (docNode.content() instanceof PathTree) {
                    string2 = PathSetTree.this.px.getPath(((PathTree)docNode.content()).getName());
                }
                String string3 = "";
                if (!string2.matches(".+:.+") && !string2.matches("^[\\\\/]+.*")) {
                    string3 = PathSetTree.this.px.getCurFile().getParent() + File.separator;
                }
                File file = new File(string3 + string2);
                try {
                    file = file.getCanonicalFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                File file2 = EditHandler.selectDir(file, "");
                if (file2 != null) {
                    string2 = file2.getPath();
                    string = docNode.content() instanceof PathTree ? EditHandler.relativePath(file, string2) : string2;
                    PathNode.this.tf1.setText(string);
                    PathNode.this.tf1.requestFocusInWindow();
                }
            }
        }
    }

    private class PathIncNode
    extends PathSetNode {
        public PathIncNode(PathInc pathInc) {
            String string;
            String string2;
            String string3;
            String string4 = pathInc.getIncludeFile();
            if (string4 == null) {
                string4 = "";
            }
            if ((string3 = pathInc.getIncludePath()) == null) {
                string3 = "";
            }
            if ((string2 = pathInc.getRequire()) == null) {
                string2 = "";
            }
            if ((string = pathInc.getDescription()) == null) {
                string = "";
            }
            this.setUserObject(string4 + "@" + string3 + "@" + string2 + "@" + string);
            this.content(pathInc);
            this.icon(((PathSetTree)PathSetTree.this).is.pathInc);
            this.isSpecialRender(true);
        }

        public void render(Renderer renderer) {
            String string = (String)this.getUserObject();
            int n = 0;
            int n2 = string.indexOf("@");
            renderer.addLabel(this.icon(), string.substring(n, n2), PathSetTree.this.fontDefault, renderer.sx1, true);
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            renderer.addLabel(((PathSetTree)PathSetTree.this).is.pathRef, string.substring(n, n2), PathSetTree.this.fontDefault, renderer.sx2, false);
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            renderer.addLabel(((PathSetTree)PathSetTree.this).is.require, string.substring(n, n2), PathSetTree.this.fontDefault, renderer.sx3, false);
            n = n2 + 1;
            renderer.addLabel(((PathSetTree)PathSetTree.this).is.descr, string.substring(n), PathSetTree.this.fontItalic, renderer.sx4, true);
        }

        public void edit(Editor editor) {
            this.curNode = editor.cpsn;
            this.tf1.addKeyListener(editor);
            this.tf2.addKeyListener(editor);
            this.tf3.addKeyListener(editor);
            JLabel jLabel = (JLabel)editor.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= PathSetTree.this.icnw + editor.tg;
            this.tf1.setPreferredSize(dimension);
            editor.nodePanel.add(this.tf1);
            Icon icon = ((PathSetTree)PathSetTree.this).is.locRel;
            JButton jButton = new JButton(icon);
            jButton.setPreferredSize(new Dimension(PathSetTree.this.icnw, PathSetTree.this.icnw));
            jButton.addActionListener(new Alc());
            editor.nodePanel.add(jButton);
            Vector vector = ((PathSetTree)PathSetTree.this).execEnv.pathSet.getList()[0];
            vector.add("");
            editor.nodePanel.add(editor.car[2]);
            ((JLabel)editor.car[2]).setVisible(true);
            jLabel = (JLabel)editor.car[3];
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedItem(jLabel.getText());
            this.cb1.addKeyListener(editor);
            this.cb1.setFont(jLabel.getFont());
            this.cb1.setPreferredSize(jLabel.getPreferredSize());
            editor.nodePanel.add(this.cb1);
            editor.nodePanel.add(editor.car[4]);
            ((JLabel)editor.car[4]).setVisible(true);
            jLabel = (JLabel)editor.car[5];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            editor.nodePanel.add(this.tf2);
            editor.nodePanel.add(editor.car[6]);
            ((JLabel)editor.car[6]).setVisible(true);
            jLabel = (JLabel)editor.car[7];
            this.tf3.setText(jLabel.getText());
            this.tf3.setFont(jLabel.getFont());
            this.tf3.setPreferredSize(jLabel.getPreferredSize());
            editor.nodePanel.add(this.tf3);
        }

        public String value() {
            return this.tf1.getText() + "@" + this.cb1.getSelectedItem() + "@" + this.tf2.getText() + "@" + this.tf3.getText();
        }

        public void changed() {
            String string = (String)this.getUserObject();
            PathInc pathInc = (PathInc)this.content();
            int n = 0;
            int n2 = string.indexOf("@");
            pathInc.setIncludeFile(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            pathInc.setIncludePath(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf("@", n);
            pathInc.setRequire(string.substring(n, n2));
            n = n2 + 1;
            pathInc.setDescription(string.substring(n));
        }

        private class Alc
        implements ActionListener {
            private Alc() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                File file2;
                String string = (String)PathIncNode.this.cb1.getSelectedItem();
                if (string.length() > 0) {
                    string = PathSetTree.this.px.fullPath(string);
                }
                if ((file2 = EditHandler.selectFile(file = string.length() > 0 ? new File(string) : PathSetTree.this.px.getCurFile(), "PathSet")) != null) {
                    string = file2.getPath();
                    if (file != null) {
                        string = EditHandler.relativePath(file, string);
                    }
                    PathIncNode.this.tf1.setText(string);
                    PathIncNode.this.tf1.requestFocusInWindow();
                }
            }
        }
    }

    private class PathTreeNode
    extends PathSetNode {
        public PathTreeNode(PathTreeExt pathTreeExt) {
            String string;
            String string2 = pathTreeExt.getName();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = pathTreeExt.getDescription()) == null) {
                string = "";
            }
            this.setUserObject(string2 + "@" + string);
            this.content(pathTreeExt);
            this.icon(((PathSetTree)PathSetTree.this).is.pathTree);
            this.isSpecialRender(true);
        }

        public void render(Renderer renderer) {
            String string = (String)this.getUserObject();
            int n = string.indexOf("@");
            renderer.addLabel(this.icon(), string.substring(0, n), PathSetTree.this.fontBold, renderer.sx1 + renderer.sx2 + renderer.sx3, true);
            string = string.substring(n + 1);
            renderer.addLabel(((PathSetTree)PathSetTree.this).is.descr, string, PathSetTree.this.fontItalic, renderer.sx4, true);
        }

        public void edit(Editor editor) {
            this.tf1.addKeyListener(editor);
            this.tf2.addKeyListener(editor);
            JLabel jLabel = (JLabel)editor.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= editor.tg;
            this.tf1.setPreferredSize(dimension);
            editor.nodePanel.add(this.tf1);
            editor.nodePanel.add(editor.car[2]);
            ((JLabel)editor.car[2]).setVisible(true);
            jLabel = (JLabel)editor.car[3];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            editor.nodePanel.add(this.tf2);
        }

        public String value() {
            return this.tf1.getText() + "@" + this.tf2.getText();
        }

        public void changed() {
            String string = (String)this.getUserObject();
            PathTree pathTree = (PathTree)this.content();
            int n = string.indexOf("@");
            pathTree.setName(string.substring(0, n));
            pathTree.setDescription(string.substring(n + 1));
        }
    }

    private abstract class PathSetNode
    extends DocNode {
        protected PathSetNode curNode;
        protected JTextField tf1 = new JTextField();
        protected JTextField tf2 = new JTextField();
        protected JTextField tf3 = new JTextField();
        protected JComboBox cb1;

        private PathSetNode() {
        }

        public abstract void render(Renderer var1);

        public abstract void edit(Editor var1);

        public abstract String value();

        public abstract void changed();
    }
}

