/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocCls.OptionDef;
import bsbDocCls.OptionSet;
import bsbDocExt.OptionSetExt;
import bsbDocExt.OptionsExt;
import bsbDocTree.DocEditor;
import bsbDocTree.DocNode;
import bsbDocTree.DocRenderer;
import bsbDocTree.DocTree;
import bsbDocTree.OptionDefTree;
import bsbEdit.EditHandler;
import bsbIcons.IconServer;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import bsbUtil.BsbList;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreePath;

public class OptionSetTree
extends DocTree
implements TreeModelListener,
TreeSelectionListener {
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private OptionSetExt dx;
    private IconServer is;
    private DocTree thisTree;

    public OptionSetTree(UserEnv userEnv) {
        super(userEnv.execEnv.optionSet.getName(), userEnv.execEnv.optionSet);
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.dx = this.execEnv.optionSet;
        this.is = this.userEnv.is;
        this.thisTree = this;
        this.setupNodes();
        DocRenderer docRenderer = new DocRenderer(this.fontDefault);
        this.setCellRenderer(docRenderer);
        DocEditor docEditor = new DocEditor();
        this.setCellEditor(new DefaultTreeCellEditor(this, docRenderer, docEditor));
        this.getModel().addTreeModelListener(this);
        this.addTreeSelectionListener(this);
    }

    public String getName() {
        return this.dx.getName();
    }

    protected void setupNodes() {
        DocNode docNode = this.getRoot();
        docNode.icon(this.is.doc).style(1).handler(new ehOptionSetName());
        DocNode docNode2 = this.add(null, this.dx.getDescription(), this.dx, false);
        docNode2.icon(this.is.descr).style(2).handler(new ehOptionSetDescr());
        this.add(docNode2, this.dx.getCurFile().getAbsolutePath(), this.dx, false).icon(this.is.locAbs);
        OptionsExt optionsExt = (OptionsExt)this.dx.getOptions();
        BsbList bsbList = optionsExt.getOptionDef();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            OptionDef optionDef = (OptionDef)listIterator.next();
            OptionDefTree optionDefTree = new OptionDefTree(this.userEnv, optionDef, optionsExt);
            optionDefTree.addTo(this, docNode);
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.userEnv.optionSetEdit.isDirty(true);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.userEnv.optionSetEdit.isDirty(true);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.userEnv.optionSetEdit.isDirty(true);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.setEditable(false);
        DocNode docNode = (DocNode)this.getLastSelectedPathComponent();
        if (docNode != null) {
            docNode.handler().changed();
        }
        this.treeUpdate(this.dx.getName());
        this.userEnv.optionSetEdit.isDirty(true);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.userEnv.disableNodeActions();
        this.checkNodeSelection();
        this.setEditable(false);
    }

    private void newOptionDef() {
        OptionsExt optionsExt = (OptionsExt)this.dx.getOptions();
        OptionDefTree optionDefTree = new OptionDefTree(this.userEnv, null, optionsExt);
        DocNode docNode = optionDefTree.insertAt(this, this.getRoot(), 1);
        optionDefTree.insertAt(0);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private class ehOptionSetDescr
    extends EditHandler {
        private ehOptionSetDescr() {
        }

        public void selected() {
            this.enable(((OptionSetTree)OptionSetTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.editText(OptionSetTree.this.thisTree);
        }

        public void changed() {
            OptionSet optionSet = (OptionSet)this.node().content();
            optionSet.setDescription(this.node().getUserObject().toString());
        }
    }

    private class ehOptionSetName
    extends EditHandler {
        private ehOptionSetName() {
        }

        public void selected() {
            this.enable(((OptionSetTree)OptionSetTree.this).userEnv.actEdtText, this);
            this.enable(((OptionSetTree)OptionSetTree.this).userEnv.actOptionDefNew, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((OptionSetTree)OptionSetTree.this).userEnv.actEdtText)) {
                this.editText(OptionSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((OptionSetTree)OptionSetTree.this).userEnv.actOptionDefNew)) {
                OptionSetTree.this.newOptionDef();
            }
        }

        public void changed() {
            OptionSet optionSet = (OptionSet)this.node().content();
            optionSet.setName(this.node().getUserObject().toString());
        }
    }
}

