/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocCls.CondOption;
import bsbDocCls.CondValue;
import bsbDocCls.OptionDef;
import bsbDocCls.OptionSet;
import bsbDocExt.OptionsExt;
import bsbDocTree.DocEditor;
import bsbDocTree.DocNode;
import bsbDocTree.DocRenderer;
import bsbDocTree.DocTree;
import bsbEdit.EditHandler;
import bsbException.External;
import bsbIcons.IconServer;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import bsbUtil.BsbList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreePath;

public class OptionDefTree
extends DocTree {
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private OptionsExt dx;
    private OptionDef od;
    private IconServer is;
    private DocTree tree;
    private Renderer renderer;
    private Editor editor;

    public static void populate(JToolBar jToolBar, UserEnv userEnv) {
        jToolBar.add(userEnv.actEdtText).setToolTipText("Edit Text");
        jToolBar.addSeparator();
        jToolBar.add(userEnv.actOptionDefNew).setToolTipText("New Option Group");
        jToolBar.add(userEnv.actCondOptionNew).setToolTipText("New Option");
        jToolBar.add(userEnv.actOptRefNew).setToolTipText("New Option Group Reference");
        jToolBar.addSeparator();
        jToolBar.add(userEnv.actPathTreeNew).setToolTipText("New Path (Reference)");
        jToolBar.add(userEnv.actValueRefNew).setToolTipText("New Value (Reference)");
        jToolBar.add(userEnv.actPropertyGroupRefNew).setToolTipText("New Property Group Reference");
        jToolBar.addSeparator();
        jToolBar.add(userEnv.actDelete).setToolTipText("Delete Element");
    }

    public static void setEditMenu(JMenu jMenu, UserEnv userEnv) {
        jMenu.removeAll();
        jMenu.add(new JMenuItem(userEnv.actEdtText));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(userEnv.actOptionDefNew));
        jMenu.add(new JMenuItem(userEnv.actCondOptionNew));
        jMenu.add(new JMenuItem(userEnv.actOptRefNew));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(userEnv.actPathTreeNew));
        jMenu.add(new JMenuItem(userEnv.actValueRefNew));
        jMenu.add(new JMenuItem(userEnv.actPropertyGroupRefNew));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(userEnv.actDelete));
    }

    public OptionDefTree(UserEnv userEnv, OptionDef optionDef, OptionsExt optionsExt) {
        if (optionDef == null) {
            optionDef = this.optionDefDefault();
        }
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.is = this.userEnv.is;
        this.dx = optionsExt;
        this.od = optionDef;
        this.tree = this;
        OptionDefNode optionDefNode = new OptionDefNode(optionDef);
        this.setRoot(optionDefNode);
        this.setupNodes();
        this.renderer = new Renderer();
        this.setCellRenderer(this.renderer);
        this.editor = new Editor();
        this.setCellEditor(new DefaultTreeCellEditor(this, this.renderer, this.editor));
        this.getModel().addTreeModelListener(this);
        this.addTreeSelectionListener(this);
    }

    public DocNode addTo(DocTree docTree, DocNode docNode) {
        return this.insertAt(docTree, docNode, docNode.getChildCount());
    }

    public DocNode insertAfter(DocTree docTree, DocNode docNode, DocNode docNode2) {
        return this.insertAt(docTree, docNode, docNode.getIndex(docNode2) + 1);
    }

    public DocNode insertAt(DocTree docTree, DocNode docNode, int n) {
        DocNode docNode2 = this.getRoot();
        this.tree = docTree;
        this.setCellRenderer(null);
        this.getModel().removeTreeModelListener(this);
        this.removeTreeSelectionListener(this);
        docTree.insert(n, docNode, docNode2, false);
        return docNode2;
    }

    public void insertAt(int n) {
        this.dx.getOptionDef().add(n, this.od);
    }

    protected void setupNodes() {
        OptionDefNode optionDefNode = (OptionDefNode)this.getRoot();
        optionDefNode.handler(new ehOptionDef());
        BsbList bsbList = this.od.getCondOption();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((CondOption)listIterator.next(), (DocNode)optionDefNode, optionDefNode.getChildCount(), false);
        }
    }

    private DocNode insertElement(CondOption condOption, DocNode docNode, int n, boolean bl) {
        String string = condOption.getOptRef();
        if (string != null && string.length() > 0) {
            OptRefNode optRefNode = new OptRefNode(condOption);
            optRefNode.handler(new ehOptRef());
            this.tree.insert(n, docNode, optRefNode, bl);
            return optRefNode;
        }
        String string2 = condOption.getName();
        if (string2 != null && string2.length() > 0) {
            CondOptionNode condOptionNode = new CondOptionNode(condOption);
            condOptionNode.handler(new ehCondOption());
            this.tree.insert(n, docNode, condOptionNode, bl);
            BsbList bsbList = condOption.getCondValue();
            ListIterator listIterator = bsbList.listIterator();
            while (listIterator.hasNext()) {
                this.insertElement((CondValue)listIterator.next(), (DocNode)condOptionNode, condOptionNode.getChildCount(), false);
            }
            return condOptionNode;
        }
        return null;
    }

    private DocNode insertElement(CondValue condValue, DocNode docNode, int n, boolean bl) {
        CondValueNode condValueNode = new CondValueNode(condValue);
        condValueNode.handler(new ehCondValue());
        this.tree.insert(n, docNode, condValueNode, bl);
        return condValueNode;
    }

    private OptionDef optionDefDefault() {
        CondValue condValue = new CondValue();
        condValue.set_Value("0");
        CondOption condOption = new CondOption();
        condOption.setName("New Option");
        condOption.getCondValue().add(condValue);
        OptionDef optionDef = new OptionDef();
        optionDef.setName("New Option Group");
        optionDef.setDescription("New Option Group Description");
        optionDef.getCondOption().add(condOption);
        return optionDef;
    }

    private Vector availableValueRefs() {
        Vector<String> vector = new Vector<String>();
        Vector[] vectorArray = this.dx.getCondValueList();
        Vector[] vectorArray2 = this.dx.getRefdCondValueList();
        Vector[] vectorArray3 = this.execEnv.configDef.getPropertyList();
        vector.add(0, "[no reference]");
        ListIterator listIterator = vectorArray[1].listIterator();
        ListIterator listIterator2 = vectorArray[0].listIterator();
        while (listIterator.hasNext()) {
            vector.add(listIterator.next() + "." + listIterator2.next());
        }
        listIterator = vectorArray2[1].listIterator();
        listIterator2 = vectorArray2[0].listIterator();
        while (listIterator.hasNext()) {
            vector.add("[" + listIterator.next() + ".]" + listIterator2.next());
        }
        listIterator = vectorArray3[0].listIterator();
        while (listIterator.hasNext()) {
            vector.add("[Config.]" + listIterator.next());
        }
        return vector;
    }

    private String selectNewValueRef() {
        Vector vector = this.availableValueRefs();
        String string = (String)JOptionPane.showInputDialog(null, "Select Value Reference", "Option Value Selection", 3, this.is.valueRef, vector.toArray(), null);
        if (string == null) {
            return null;
        }
        int n = (string = string.replaceAll("\\[.+\\]", "")).indexOf(" - ");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private String selectNewGrpRef() {
        Vector[] vectorArray = this.execEnv.configSet.getGroups();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < vectorArray[0].size(); ++i) {
            vector.add(vectorArray[0].elementAt(i) + " - " + vectorArray[1].elementAt(i));
        }
        String string = (String)JOptionPane.showInputDialog(null, "Select Group Reference", "Property Group Selection", 3, this.is.propertyGroupRef, vector.toArray(), null);
        if (string == null) {
            return null;
        }
        int n = string.indexOf(" - ");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private void newOptionDef(DocNode docNode, DocNode docNode2) {
        this.newOptionDef(docNode, docNode.getIndex(docNode2));
    }

    public void newOptionDef(DocNode docNode, int n) {
        OptionDefTree optionDefTree = new OptionDefTree(this.userEnv, null, this.dx);
        DocNode docNode2 = (DocNode)docNode.getChildAt(n);
        DocNode docNode3 = optionDefTree.insertAt(this.tree, docNode, n + 1);
        int n2 = this.dx.getOptionDef().indexOf(docNode2.content());
        optionDefTree.insertAt(n2 + 1);
        TreePath treePath = new TreePath(docNode3.getPath());
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
    }

    private void newCondOption(DocNode docNode, DocNode docNode2) {
        this.newCondOption(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newCondOption(DocNode docNode, int n) {
        CondValue condValue = new CondValue();
        condValue.set_Value("0");
        CondOption condOption = new CondOption();
        condOption.setName("New Option");
        condOption.getCondValue().add(condValue);
        OptionDef optionDef = (OptionDef)docNode.content();
        optionDef.getCondOption().add(n, condOption);
        docNode = this.insertElement(condOption, docNode, n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
    }

    private void newOptRef(DocNode docNode, DocNode docNode2) {
        this.newOptRef(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newOptRef(DocNode docNode, int n) {
        Vector<String> vector = new Vector<String>();
        Vector[] vectorArray = this.execEnv.optionSet.getOptionDefList();
        ListIterator listIterator = vectorArray[0].listIterator();
        ListIterator listIterator2 = vectorArray[1].listIterator();
        while (listIterator.hasNext()) {
            vector.add(listIterator.next() + " - " + listIterator2.next());
        }
        String string = (String)JOptionPane.showInputDialog(null, "Select Option Group", "Option Group Reference", 3, this.is.optRef, vector.toArray(), null);
        if (string == null) {
            return;
        }
        string = (String)vectorArray[0].elementAt(vector.indexOf(string));
        CondOption condOption = new CondOption();
        condOption.setOptRef(string);
        OptionDef optionDef = (OptionDef)docNode.content();
        optionDef.getCondOption().add(n, condOption);
        docNode = this.insertElement(condOption, docNode, n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
    }

    private void newPathRef(DocNode docNode, DocNode docNode2) {
        this.newPathRef(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newPathRef(DocNode docNode, int n) {
        Vector[] vectorArray = this.execEnv.pathSet.getList();
        String string = (String)JOptionPane.showInputDialog(null, "Select Path Reference", "Option Value Selection", 3, this.is.pathRef, vectorArray[0].toArray(), null);
        if (string == null) {
            return;
        }
        CondOption condOption = (CondOption)docNode.content();
        BsbList bsbList = condOption.getCondValue();
        CondValue condValue = new CondValue();
        condValue.setPathRef(string);
        bsbList.add(n, condValue);
        this.insertElement(condValue, docNode, n, true);
    }

    private void newPath(DocNode docNode, DocNode docNode2) {
        this.newPath(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newPath(DocNode docNode, int n) {
        File file = EditHandler.selectPath(this.execEnv.settings.getDocRoot(), "");
        if (file == null) {
            return;
        }
        String string = file.getPath();
        CondOption condOption = (CondOption)docNode.content();
        BsbList bsbList = condOption.getCondValue();
        CondValue condValue = new CondValue();
        condValue.setPath(string);
        bsbList.add(n, condValue);
        this.insertElement(condValue, docNode, n, true);
    }

    private void newValueRef(DocNode docNode, DocNode docNode2) {
        this.newValueRef(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newValueRef(DocNode docNode, int n) {
        String string = this.selectNewValueRef();
        if (string == null) {
            return;
        }
        CondOption condOption = (CondOption)docNode.content();
        BsbList bsbList = condOption.getCondValue();
        CondValue condValue = new CondValue();
        condValue.setValRef(string);
        bsbList.add(n, condValue);
        this.insertElement(condValue, docNode, n, true);
    }

    private void newValue(DocNode docNode, DocNode docNode2) {
        this.newValue(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newValue(DocNode docNode, int n) {
        String string = "0";
        CondOption condOption = (CondOption)docNode.content();
        BsbList bsbList = condOption.getCondValue();
        CondValue condValue = new CondValue();
        condValue.set_Value(string);
        bsbList.add(n, condValue);
        docNode = this.insertElement(condValue, docNode, n, true);
        this.tree.setSelectionPath(new TreePath(docNode.getPath()));
    }

    private void newGrpRef(DocNode docNode, DocNode docNode2) {
        this.newGrpRef(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newGrpRef(DocNode docNode, int n) {
        String string = this.selectNewGrpRef();
        if (string == null) {
            return;
        }
        CondOption condOption = (CondOption)docNode.content();
        BsbList bsbList = condOption.getCondValue();
        CondValue condValue = new CondValue();
        condValue.setGrpRef(string);
        condValue.set_Value("[name]=[value]");
        bsbList.add(n, condValue);
        docNode = this.insertElement(condValue, docNode, n, true);
        this.tree.setSelectionPath(new TreePath(docNode.getPath()));
    }

    private Object deleteElement(DocNode docNode) {
        Object object = docNode.content();
        Object object2 = ((DocNode)docNode.getParent()).content();
        this.dx.deleteElement(object2, object);
        this.tree.deleteNode(docNode);
        return object2;
    }

    private class Editor
    extends DocEditor {
        Component[] car;
        OptionDefsNode codn;

        private Editor() {
        }

        protected Component nodeEditor(DocTree docTree, DocNode docNode, boolean bl, boolean bl2, boolean bl3, int n) {
            this.curTree = docTree;
            if (!docNode.isSpecialRender()) {
                return super.nodeEditor(docTree, docNode, bl, bl2, bl3, n);
            }
            this.codn = (OptionDefsNode)docNode;
            OptionDefsNode optionDefsNode = (OptionDefsNode)docNode;
            this.car = ((JComponent)docTree.getCellRenderer().getTreeCellRendererComponent(docTree, docNode, bl, bl2, bl3, n, true)).getComponents();
            this.nodePanel.removeAll();
            optionDefsNode.edit(this);
            return this.nodePanel;
        }

        protected Object nodeValue() {
            if (!this.codn.isSpecialRender()) {
                return super.nodeValue();
            }
            return this.codn.value();
        }
    }

    private class Renderer
    extends DocRenderer {
        int vw;
        int sx1;
        int sx2;
        int sx3;
        int sx4;

        public Renderer() {
            super(OptionDefTree.this.fontDefault);
        }

        protected Component nodeRenderer(DocNode docNode, boolean bl) {
            if (!docNode.isSpecialRender()) {
                return super.nodeRenderer(docNode, bl);
            }
            OptionDefsNode optionDefsNode = (OptionDefsNode)docNode;
            this.vw = ((OptionDefTree)OptionDefTree.this).tree.viewWidth / 10;
            this.sx1 = this.vw * 3 - docNode.getLevel() * 20;
            this.sx2 = this.vw * 2;
            this.sx3 = this.vw * 2;
            this.sx4 = this.vw * 3 - 15;
            this.nodePanel.removeAll();
            optionDefsNode.render(this);
            this.nodePanel.setOpaque(bl);
            this.setVisible(false);
            this.nodePanel.setVisible(true);
            return this.nodePanel;
        }
    }

    private class ehCondValue
    extends EditHandler {
        private ehCondValue() {
        }

        public void selected() {
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actEdtText, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actPathTreeNew, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actValueRefNew, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actPropertyGroupRefNew, this);
            if (this.node().getParent().getChildCount() > 1) {
                this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actDelete, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actEdtText)) {
                this.editText(OptionDefTree.this.tree);
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actPathTreeNew)) {
                OptionDefTree.this.newPathRef((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actValueRefNew)) {
                OptionDefTree.this.newValueRef((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actPropertyGroupRefNew)) {
                OptionDefTree.this.newGrpRef((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actDelete)) {
                OptionDefTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            ((CondValueNode)this.node()).changed();
        }
    }

    private class ehCondOption
    extends EditHandler {
        private ehCondOption() {
        }

        public void selected() {
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actEdtText, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actCondOptionNew, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actOptRefNew, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actPathTreeNew, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actValueRefNew, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actPropertyGroupRefNew, this);
            if (this.node().getParent().getChildCount() > 1) {
                this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actDelete, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actEdtText)) {
                this.editText(OptionDefTree.this.tree);
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actCondOptionNew)) {
                OptionDefTree.this.newCondOption((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actOptRefNew)) {
                OptionDefTree.this.newOptRef((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actPathTreeNew)) {
                OptionDefTree.this.newPathRef(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actValueRefNew)) {
                OptionDefTree.this.newValueRef(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actPropertyGroupRefNew)) {
                OptionDefTree.this.newGrpRef(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actDelete)) {
                OptionDefTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            ((CondOptionNode)this.node()).changed();
        }
    }

    private class ehOptRef
    extends EditHandler {
        private ehOptRef() {
        }

        public void selected() {
            String string = ((CondOption)this.node().content()).getRequire();
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actEdtText, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actCondOptionNew, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actOptRefNew, this);
            if (this.node().getParent().getChildCount() > 1) {
                this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actDelete, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actEdtText)) {
                this.editText(OptionDefTree.this.tree);
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actCondOptionNew)) {
                OptionDefTree.this.newCondOption((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actOptRefNew)) {
                OptionDefTree.this.newOptRef((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actDelete)) {
                OptionDefTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            ((OptRefNode)this.node()).changed();
        }
    }

    private class ehOptionDef
    extends EditHandler {
        private ehOptionDef() {
        }

        public void selected() {
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actEdtText, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actCondOptionNew, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actOptRefNew, this);
            this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actOptionDefNew, this);
            Object object = ((DocNode)this.node().getParent()).content();
            if (!(object instanceof OptionSet) || this.node().getParent().getChildCount() > 2) {
                this.enable(((OptionDefTree)OptionDefTree.this).userEnv.actDelete, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actEdtText)) {
                this.editText(OptionDefTree.this.tree);
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actCondOptionNew)) {
                OptionDefTree.this.newCondOption(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actOptRefNew)) {
                OptionDefTree.this.newOptRef(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actOptionDefNew)) {
                OptionDefTree.this.newOptionDef((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((OptionDefTree)OptionDefTree.this).userEnv.actDelete)) {
                OptionDefTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            ((OptionDefNode)this.node()).changed();
        }
    }

    private class CondValueNode
    extends OptionDefsNode {
        public CondValueNode(CondValue condValue) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6 = condValue.getPathRef();
            if (string6 == null) {
                string6 = "";
            }
            if ((string5 = condValue.getPath()) == null) {
                string5 = "";
            }
            if ((string4 = condValue.getValRef()) == null) {
                string4 = "";
            }
            if ((string3 = condValue.getGrpRef()) == null) {
                string3 = "";
            }
            if ((string2 = condValue.get_Value()) == null) {
                string2 = "";
            }
            if ((string = condValue.getRequire()) == null) {
                string = "";
            }
            if ((string6 + string5).length() > 0) {
                this.setUserObject(string6 + "::" + string5 + "::" + string);
                this.content(condValue);
                this.icon(((OptionDefTree)OptionDefTree.this).is.pathRef);
                this.isSpecialRender(true);
            } else if (string4.length() > 0) {
                this.setUserObject(string4 + "::" + string2 + "::" + string);
                this.content(condValue);
                this.icon(((OptionDefTree)OptionDefTree.this).is.valueRef);
                this.isSpecialRender(true);
            } else if (string3.length() > 0) {
                this.setUserObject(string3 + "::" + string2 + "::" + string);
                this.content(condValue);
                this.icon(((OptionDefTree)OptionDefTree.this).is.propertyGroupRef);
                this.isSpecialRender(true);
            } else if (string2.length() > 0) {
                this.setUserObject(string4 + "::" + string2 + "::" + string);
                this.content(condValue);
                this.icon(((OptionDefTree)OptionDefTree.this).is.valueRef);
                this.isSpecialRender(true);
            } else {
                this.setUserObject(string4 + "::" + "???" + "::" + string);
                this.content(condValue);
                this.icon(((OptionDefTree)OptionDefTree.this).is.valueRef);
                this.isSpecialRender(true);
            }
        }

        public void render(Renderer renderer) {
            String string = (String)this.getUserObject();
            int n = string.indexOf("::");
            renderer.addLabel(this.icon(), string.substring(0, n), OptionDefTree.this.fontBold, renderer.sx1 + renderer.sx2, false);
            string = string.substring(n + 2);
            n = string.indexOf("::");
            Icon icon = this.icon() == ((OptionDefTree)OptionDefTree.this).is.pathRef ? (string.length() > 0 ? ((OptionDefTree)OptionDefTree.this).is.locRel : ((OptionDefTree)OptionDefTree.this).is.locAbs) : ((OptionDefTree)OptionDefTree.this).is.valueDef;
            renderer.addLabel(icon, string.substring(0, n), OptionDefTree.this.fontDefault, renderer.sx3, false);
            string = string.substring(n + 2);
            renderer.addLabel(((OptionDefTree)OptionDefTree.this).is.require, string, OptionDefTree.this.fontDefault, renderer.sx4, false);
        }

        public void edit(Editor editor) {
            Vector vector = new Vector();
            JLabel jLabel = (JLabel)editor.car[0];
            if (jLabel.getIcon() == ((OptionDefTree)OptionDefTree.this).is.pathRef) {
                jLabel = (JLabel)editor.car[1];
                Vector[] vectorArray = ((OptionDefTree)OptionDefTree.this).execEnv.pathSet.getList();
                ListIterator listIterator = vectorArray[0].listIterator();
                ListIterator listIterator2 = vectorArray[1].listIterator();
                vector.add(" - no path reference");
                while (listIterator.hasNext()) {
                    vector.add(listIterator.next() + " - " + listIterator2.next());
                }
                int n = vectorArray[0].indexOf(jLabel.getText()) + 1;
                this.cb1 = new JComboBox<Object>(vector.toArray());
                this.cb1.setSelectedIndex(n);
                this.cb1.addKeyListener(editor);
                this.cb1.setFont(jLabel.getFont());
                Dimension dimension = jLabel.getPreferredSize();
                dimension.width -= editor.tg;
                this.cb1.setPreferredSize(dimension);
                editor.nodePanel.add(this.cb1);
                Icon icon = ((String)this.cb1.getSelectedItem()).length() > 0 ? ((OptionDefTree)OptionDefTree.this).is.locRel : ((OptionDefTree)OptionDefTree.this).is.locAbs;
                JButton jButton = new JButton(icon);
                jButton.setPreferredSize(new Dimension(OptionDefTree.this.icnw, OptionDefTree.this.icnw));
                jButton.addActionListener(new Alc());
                editor.nodePanel.add(jButton);
                jLabel = (JLabel)editor.car[3];
                this.tf1.setText(jLabel.getText());
                this.tf1.setFont(jLabel.getFont());
                this.tf1.setPreferredSize(jLabel.getPreferredSize());
                editor.nodePanel.add(this.tf1);
                this.tf1.addKeyListener(editor);
            } else if (jLabel.getIcon() == ((OptionDefTree)OptionDefTree.this).is.propertyGroupRef) {
                jLabel = (JLabel)editor.car[1];
                Vector[] vectorArray = ((OptionDefTree)OptionDefTree.this).execEnv.configSet.getGroups();
                ListIterator listIterator = vectorArray[0].listIterator();
                ListIterator listIterator3 = vectorArray[1].listIterator();
                while (listIterator.hasNext()) {
                    vector.add(listIterator.next() + " - " + listIterator3.next());
                }
                int n = vectorArray[0].indexOf(jLabel.getText());
                this.cb1 = new JComboBox<Object>(vector.toArray());
                this.cb1.setSelectedIndex(n);
                this.cb1.addKeyListener(editor);
                this.cb1.setFont(jLabel.getFont());
                Dimension dimension = jLabel.getPreferredSize();
                dimension.width -= editor.tg;
                this.cb1.setPreferredSize(dimension);
                editor.nodePanel.add(this.cb1);
                jLabel = (JLabel)editor.car[3];
                this.tf1.setText(jLabel.getText());
                this.tf1.setFont(jLabel.getFont());
                this.tf1.setPreferredSize(jLabel.getPreferredSize());
                editor.nodePanel.add(this.tf1);
                this.tf1.addKeyListener(editor);
            } else {
                vector = OptionDefTree.this.availableValueRefs();
                jLabel = (JLabel)editor.car[1];
                Vector[] vectorArray = OptionDefTree.this.dx.getRefdCondValueList();
                String string = jLabel.getText();
                int n = vector.indexOf(string);
                if (n < 0 && (n = vectorArray[0].indexOf(string)) >= 0) {
                    n = vector.indexOf("[" + vectorArray[1].elementAt(n) + ".]" + string);
                }
                if (n < 0) {
                    n = vector.indexOf("[Config.]" + string);
                }
                if (n < 0) {
                    n = 0;
                }
                this.cb1 = new JComboBox<Object>(vector.toArray());
                this.cb1.setSelectedIndex(n);
                this.cb1.addKeyListener(editor);
                this.cb1.setFont(jLabel.getFont());
                Dimension dimension = jLabel.getPreferredSize();
                dimension.width -= editor.tg;
                this.cb1.setPreferredSize(dimension);
                editor.nodePanel.add(this.cb1);
                jLabel = (JLabel)editor.car[2];
                jLabel.setVisible(true);
                editor.nodePanel.add(jLabel);
                jLabel = (JLabel)editor.car[3];
                this.tf1.setText(jLabel.getText());
                this.tf1.setFont(jLabel.getFont());
                this.tf1.setPreferredSize(jLabel.getPreferredSize());
                editor.nodePanel.add(this.tf1);
                this.tf1.addKeyListener(editor);
            }
            jLabel = (JLabel)editor.car[4];
            jLabel.setVisible(true);
            editor.nodePanel.add(jLabel);
            jLabel = (JLabel)editor.car[5];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            editor.nodePanel.add(this.tf2);
            this.tf2.addKeyListener(editor);
        }

        public String value() {
            String string = (String)this.cb1.getSelectedItem();
            if ((string = string.replaceAll("\\[.+\\]", "")).indexOf(" - ") >= 0) {
                string = string.substring(0, string.indexOf(" - "));
            }
            return string + "::" + this.tf1.getText() + "::" + this.tf2.getText();
        }

        public void changed() {
            String string = (String)this.getUserObject();
            CondValue condValue = (CondValue)this.content();
            int n = string.indexOf("::");
            if (this.icon() == ((OptionDefTree)OptionDefTree.this).is.pathRef) {
                condValue.setPathRef(string.substring(0, n));
                string = string.substring(n + 2);
                n = string.indexOf("::");
                condValue.setPath(string.substring(0, n));
                string = string.substring(n + 2);
            } else if (this.icon() == ((OptionDefTree)OptionDefTree.this).is.propertyGroupRef) {
                condValue.setGrpRef(string.substring(0, n));
                string = string.substring(n + 2);
                n = string.indexOf("::");
                condValue.set_Value(string.substring(0, n));
                string = string.substring(n + 2);
            } else {
                condValue.setValRef(string.substring(0, n));
                string = string.substring(n + 2);
                n = string.indexOf("::");
                condValue.set_Value(string.substring(0, n));
                string = string.substring(n + 2);
            }
            condValue.setRequire(string);
        }

        private class Alc
        implements ActionListener {
            private Alc() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)CondValueNode.this.cb1.getSelectedItem();
                if ((string = string.replaceAll("\\[.+\\]", "")).indexOf(" - ") > 0) {
                    string = string.substring(0, string.indexOf(" - "));
                }
                String string2 = CondValueNode.this.tf1.getText();
                String string3 = ((OptionDefTree)((CondValueNode)CondValueNode.this).OptionDefTree.this).execEnv.pathSet.fullPath(string, string2);
                File file = new File(string3);
                try {
                    file = file.getCanonicalFile();
                }
                catch (Exception exception) {
                    new External(exception).handle();
                }
                File file2 = EditHandler.selectPath(file, "");
                if (file2 != null) {
                    string3 = file2.getPath();
                    string = EditHandler.relativePath(file, string3);
                    CondValueNode.this.tf1.setText(string);
                    CondValueNode.this.tf1.requestFocusInWindow();
                }
            }
        }
    }

    private class OptRefNode
    extends OptionDefsNode {
        public OptRefNode(CondOption condOption) {
            String string;
            String string2 = condOption.getOptRef();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = condOption.getRequire()) == null) {
                string = "";
            }
            this.setUserObject(string2 + "::" + string);
            this.content(condOption);
            this.icon(((OptionDefTree)OptionDefTree.this).is.optRef);
            this.isSpecialRender(true);
        }

        public void render(Renderer renderer) {
            String string = (String)this.getUserObject();
            int n = string.indexOf("::");
            renderer.addLabel(this.icon(), string.substring(0, n), OptionDefTree.this.fontBold, renderer.sx1 + renderer.sx2 + renderer.sx3, true);
            string = string.substring(n + 2);
            renderer.addLabel(((OptionDefTree)OptionDefTree.this).is.require, string, OptionDefTree.this.fontDefault, renderer.sx4, false);
        }

        public void edit(Editor editor) {
            Vector<String> vector = new Vector<String>();
            Vector[] vectorArray = ((OptionDefTree)OptionDefTree.this).execEnv.optionSet.getOptionDefList();
            ListIterator listIterator = vectorArray[0].listIterator();
            ListIterator listIterator2 = vectorArray[1].listIterator();
            while (listIterator.hasNext()) {
                vector.add(listIterator.next() + " - " + listIterator2.next());
            }
            JLabel jLabel = (JLabel)editor.car[1];
            int n = vectorArray[0].indexOf(jLabel.getText());
            if (n < 0) {
                n = 0;
            }
            this.cb1 = new JComboBox<Object>(vector.toArray());
            this.cb1.setSelectedIndex(n);
            this.cb1.addKeyListener(editor);
            this.cb1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= editor.tg;
            this.cb1.setPreferredSize(dimension);
            editor.nodePanel.add(this.cb1);
            jLabel = (JLabel)editor.car[2];
            jLabel.setVisible(true);
            editor.nodePanel.add(jLabel);
            jLabel = (JLabel)editor.car[3];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            this.tf1.setPreferredSize(jLabel.getPreferredSize());
            editor.nodePanel.add(this.tf1);
            this.tf1.addKeyListener(editor);
        }

        public String value() {
            String string = (String)this.cb1.getSelectedItem();
            string = string.substring(0, string.indexOf(" - "));
            return string + "::" + this.tf1.getText();
        }

        public void changed() {
            String string = (String)this.getUserObject();
            CondOption condOption = (CondOption)this.content();
            int n = string.indexOf("::");
            condOption.setOptRef(string.substring(0, n));
            condOption.setRequire(string.substring(n + 2));
        }
    }

    private class CondOptionNode
    extends OptionDefsNode {
        public CondOptionNode(CondOption condOption) {
            String string = condOption.getName();
            this.setUserObject(string);
            this.content(condOption);
            this.icon(((OptionDefTree)OptionDefTree.this).is.condOption);
            this.isSpecialRender(true);
        }

        public void render(Renderer renderer) {
            String string = (String)this.getUserObject();
            renderer.addLabel(this.icon(), string, OptionDefTree.this.fontBold, renderer.sx1 + renderer.sx2 + renderer.sx3 + renderer.sx4, true);
        }

        public void edit(Editor editor) {
            this.tf1.addKeyListener(editor);
            JLabel jLabel = (JLabel)editor.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= editor.tg;
            this.tf1.setPreferredSize(dimension);
            editor.nodePanel.add(this.tf1);
        }

        public String value() {
            return this.tf1.getText();
        }

        public void changed() {
            String string = (String)this.getUserObject();
            CondOption condOption = (CondOption)this.content();
            condOption.setName(string);
        }
    }

    private class OptionDefNode
    extends OptionDefsNode {
        public OptionDefNode(OptionDef optionDef) {
            String string;
            String string2 = optionDef.getName();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = optionDef.getDescription()) == null) {
                string = "";
            }
            this.setUserObject(string2 + "::" + string);
            this.content(optionDef);
            this.icon(((OptionDefTree)OptionDefTree.this).is.options);
            this.isSpecialRender(true);
        }

        public void render(Renderer renderer) {
            String string = (String)this.getUserObject();
            int n = string.indexOf("::");
            renderer.addLabel(this.icon(), string.substring(0, n), OptionDefTree.this.fontBold, renderer.sx1 + renderer.sx2 + renderer.sx3, true);
            string = string.substring(n + 2);
            renderer.addLabel(((OptionDefTree)OptionDefTree.this).is.descr, string, OptionDefTree.this.fontItalic, renderer.sx4, true);
        }

        public void edit(Editor editor) {
            this.tf1.addKeyListener(editor);
            this.tf2.addKeyListener(editor);
            JLabel jLabel = (JLabel)editor.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= editor.tg;
            this.tf1.setPreferredSize(dimension);
            editor.nodePanel.add(this.tf1);
            editor.nodePanel.add(editor.car[2]);
            ((JLabel)editor.car[2]).setVisible(true);
            jLabel = (JLabel)editor.car[3];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            editor.nodePanel.add(this.tf2);
        }

        public String value() {
            return this.tf1.getText() + "::" + this.tf2.getText();
        }

        public void changed() {
            String string = (String)this.getUserObject();
            OptionDef optionDef = (OptionDef)this.content();
            int n = string.indexOf("::");
            optionDef.setName(string.substring(0, n));
            optionDef.setDescription(string.substring(n + 2));
        }
    }

    public abstract class OptionDefsNode
    extends DocNode {
        protected OptionDefsNode curNode;
        protected JTextField tf1 = new JTextField();
        protected JTextField tf2 = new JTextField();
        protected JComboBox cb1;

        public DocRenderer getRenderer() {
            return OptionDefTree.this.renderer;
        }

        public DocEditor getEditor() {
            return OptionDefTree.this.editor;
        }

        public abstract void render(Renderer var1);

        public abstract void edit(Editor var1);

        public abstract String value();

        public abstract void changed();
    }
}

