/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocExt.BsbDocExt;
import bsbDocTree.DocNode;
import bsbException.Problem;
import bsbIcons.IconServer;
import bsbMain.UserEnv;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class DocTree
extends JTree
implements TreeModelListener,
TreeSelectionListener,
ActionListener,
MouseListener {
    protected int viewWidth = 500;
    protected int icnw;
    protected int icnt;
    protected Font fontDefault;
    protected Font fontBold;
    protected Font fontItalic;
    private DefaultTreeModel treeModel;
    private DocNode treeRoot;
    private UserEnv userEnv;

    public DocTree() {
        this("DocTree: unnamed", null);
    }

    public DocTree(String string, Object object) {
        this(new DocNode(string, object));
    }

    public DocTree(DocNode docNode) {
        this.treeRoot = docNode;
        this.treeModel = new DefaultTreeModel(this.treeRoot);
        this.setModel(this.treeModel);
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(false);
        this.setInvokesStopCellEditing(true);
        this.fontDefault = this.getFont();
        String string = this.fontDefault.getFontName();
        int n = this.fontDefault.getSize();
        this.fontBold = new Font(string, 1, n);
        this.fontItalic = new Font(string, 2, n);
        Icon icon = IconServer.load("/bsbIcons/Descr.gif");
        JLabel jLabel = new JLabel("TEXT", icon, 2);
        this.icnw = icon.getIconWidth();
        this.icnt = this.icnw + jLabel.getHorizontalTextPosition();
        this.addMouseListener(this);
        this.setToggleClickCount(0);
    }

    public void setGlobalActions(UserEnv userEnv) {
        this.userEnv = userEnv;
        this.userEnv.actRefreshTree.setEnabled(true);
        this.userEnv.actRefreshTree.putValue("BSB_HANDLER", this);
        this.userEnv.actExpand.setEnabled(true);
        this.userEnv.actExpand.putValue("BSB_HANDLER", this);
        this.userEnv.actExpandAll.setEnabled(true);
        this.userEnv.actExpandAll.putValue("BSB_HANDLER", this);
        this.userEnv.actCollapseAll.setEnabled(true);
        this.userEnv.actCollapseAll.putValue("BSB_HANDLER", this);
    }

    public DocNode getRoot() {
        return this.treeRoot;
    }

    public void setRoot(DocNode docNode) {
        this.treeRoot = docNode;
        this.treeModel = new DefaultTreeModel(this.treeRoot);
        this.setModel(this.treeModel);
    }

    public void setViewWidth(int n) {
        if (this.viewWidth != n) {
            this.viewWidth = n;
            this.treeUpdate(((BsbDocExt)this.treeRoot.content()).getName());
        }
    }

    public void treeUpdate() {
        this.treeUpdate((String)this.treeRoot.getUserObject());
    }

    public void treeUpdate(String string) {
        this.getModel().removeTreeModelListener(this);
        this.removeTreeSelectionListener(this);
        int[] nArray = this.getSelectionRows();
        JViewport jViewport = (JViewport)this.getParent();
        Point point = jViewport.getViewPosition();
        Vector<Integer> vector = new Vector<Integer>();
        Enumeration<TreePath> enumeration = this.getExpandedDescendants(new TreePath(this.treeRoot));
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            vector.add(new Integer(this.getRowForPath(enumeration.nextElement())));
        }
        Collections.sort(vector);
        this.removeChildren(this.treeRoot);
        this.treeRoot.setUserObject(string);
        this.setupNodes();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.expandPath(this.getPathForRow((Integer)((Object)enumeration.nextElement())));
        }
        jViewport.setViewPosition(point);
        this.getModel().addTreeModelListener(this);
        this.addTreeSelectionListener(this);
        this.setSelectionRows(nArray);
    }

    public void checkNodeSelection() {
        DocNode docNode = (DocNode)this.getLastSelectedPathComponent();
        if (docNode != null && docNode.handler() != null) {
            docNode.handler().selected();
        }
    }

    public DocNode add(DocNode docNode, String string, Object object, boolean bl) {
        return this.add(docNode, new DocNode(string, object), bl);
    }

    public DocNode add(DocNode docNode, DocNode docNode2, boolean bl) {
        if (docNode == null) {
            docNode = this.treeRoot;
        }
        return this.insert(docNode.getChildCount(), docNode, docNode2, bl);
    }

    public DocNode insert(int n, DocNode docNode, DocNode docNode2, boolean bl) {
        if (docNode == null) {
            docNode = this.treeRoot;
        }
        this.treeModel.insertNodeInto(docNode2, docNode, n);
        if (bl) {
            this.scrollPathToVisible(new TreePath(docNode2.getPath()));
        }
        return docNode2;
    }

    public void change(DocNode docNode, String string) {
        docNode.setUserObject(string);
        this.treeModel.nodeChanged(docNode);
    }

    public void change(DocNode docNode, Object object) {
        docNode.content(object);
    }

    public void change(DocNode docNode, String string, Object object) {
        docNode.setUserObject(string);
        docNode.content(object);
        this.treeModel.nodeChanged(docNode);
    }

    public void removeChildren(DocNode docNode) {
        while (this.treeModel.getChildCount(docNode) > 0) {
            this.treeModel.removeNodeFromParent((DocNode)this.treeModel.getChild(docNode, 0));
        }
    }

    public void remove(DocNode docNode) {
        this.treeModel.removeNodeFromParent(docNode);
    }

    public void remove() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            DocNode docNode = (DocNode)treePath.getLastPathComponent();
            DocNode docNode2 = (DocNode)docNode.getParent();
            if (docNode2 != null) {
                this.treeModel.removeNodeFromParent(docNode);
                return;
            }
            while (this.treeModel.getChildCount(docNode) > 0) {
                this.treeModel.removeNodeFromParent((DocNode)this.treeModel.getChild(docNode, 0));
            }
        }
    }

    public Object deleteNode(DocNode docNode) {
        Object object = docNode.content();
        int[] nArray = this.getSelectionRows();
        this.remove(docNode);
        this.setSelectionRows(nArray);
        return object;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        Action action = this.userEnv.actEdtText;
        if (mouseEvent.getButton() == 1 && (n == 6 || n == 2 && action.isEnabled())) {
            ActionListener actionListener = (ActionListener)action.getValue("BSB_HANDLER");
            if (actionListener == null) {
                return;
            }
            actionListener.actionPerformed(new ActionEvent(action, mouseEvent.getID(), "", mouseEvent.getModifiers()));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        throw new Problem("DocTree: unhandled treeStructureChanged");
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        throw new Problem("DocTree: unhandled treeNodesInserted");
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        throw new Problem("DocTree: unhandled treeNodesRemoved");
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        throw new Problem("DocTree: unhandled treeNodesChanged");
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        throw new Problem("DocTree: unhandled treeValueChanged");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.userEnv.actRefreshTree)) {
            this.resync();
            this.treeUpdate(this.getName());
            this.repaint();
            return;
        }
        if (actionEvent.getSource().equals(this.userEnv.actExpand)) {
            int n = this.getLeadSelectionRow();
            int n2 = this.getRowCount();
            for (int i = n + 1; n < i; ++n, i += this.getRowCount() - n2) {
                this.expandRow(n);
                n2 = this.getRowCount();
            }
            return;
        }
        if (actionEvent.getSource().equals(this.userEnv.actExpandAll)) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.expandRow(i);
            }
            return;
        }
        if (actionEvent.getSource().equals(this.userEnv.actCollapseAll)) {
            int n = this.getRowCount() - 1;
            while (n > 0) {
                this.collapseRow(n);
                if (--n < this.getRowCount()) continue;
                n = this.getRowCount() - 1;
            }
            return;
        }
    }

    public void resync() {
    }

    protected abstract void setupNodes();
}

