/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocTree.DocNode;
import bsbDocTree.OptionDefTree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DocRenderer
extends DefaultTreeCellRenderer {
    protected int icnw;
    protected int sy;
    protected Font fOrg;
    protected JPanel nodePanel = new JPanel();

    public DocRenderer(Font font) {
        this.fOrg = font;
        this.nodePanel.setLayout(new FlowLayout(0, 0, 0));
        this.nodePanel.setOpaque(false);
        this.nodePanel.setBackground(super.getBackgroundSelectionColor());
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DocNode docNode = (DocNode)object;
        Font font = this.fOrg;
        if (docNode.style() != -1) {
            font = new Font(this.fOrg.getFontName(), docNode.style(), this.fOrg.getSize());
        }
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.setIcon(docNode.icon() != null ? docNode.icon() : this.getIcon());
        this.setOpenIcon(docNode.icon() != null ? docNode.icon() : this.getIcon());
        this.setClosedIcon(docNode.icon() != null ? docNode.icon() : this.getIcon());
        this.setLeafIcon(docNode.icon() != null ? docNode.icon() : this.getIcon());
        this.setFont(font);
        this.icnw = this.getClosedIcon().getIconWidth();
        this.sy = this.getPreferredSize().height;
        if (docNode instanceof OptionDefTree.OptionDefsNode) {
            return ((OptionDefTree.OptionDefsNode)docNode).getRenderer().nodeRenderer(docNode, bl);
        }
        return this.nodeRenderer(docNode, bl);
    }

    protected Component nodeRenderer(DocNode docNode, boolean bl) {
        this.nodePanel.setVisible(false);
        this.setVisible(true);
        return this;
    }

    protected void clearLine() {
        this.nodePanel.removeAll();
    }

    protected JLabel addLabel(Icon icon, String string, Font font, int n, boolean bl) {
        JLabel jLabel;
        int n2 = 0;
        if (string == null) {
            string = "";
        }
        if (icon != null) {
            n2 = this.icnw;
            jLabel = new JLabel(icon);
            this.nodePanel.add(jLabel);
            if (string.length() == 0 && !bl) {
                jLabel.setEnabled(false);
            }
        }
        jLabel = new JLabel(string, 2);
        jLabel.setFont(font);
        jLabel.setPreferredSize(new Dimension(n - n2, this.sy));
        this.nodePanel.add(jLabel);
        return jLabel;
    }
}

