/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocCls.ConfigSet;
import bsbDocCls.PropertyGroup;
import bsbDocCls.PropertySet;
import bsbDocCls.ValueDef;
import bsbDocExt.ConfigSetExt;
import bsbDocTree.DocEditor;
import bsbDocTree.DocNode;
import bsbDocTree.DocRenderer;
import bsbDocTree.DocTree;
import bsbEdit.EditHandler;
import bsbIcons.IconServer;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import bsbUtil.BsbList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreePath;

public class ConfigSetTree
extends DocTree
implements TreeModelListener,
TreeSelectionListener {
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private ConfigSetExt dx;
    private IconServer is;
    private DocTree thisTree;
    private Renderer renderer;

    public ConfigSetTree(UserEnv userEnv) {
        super(userEnv.execEnv.configSet.getName(), userEnv.execEnv.configSet);
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.dx = this.execEnv.configSet;
        this.is = this.userEnv.is;
        this.thisTree = this;
        this.setupNodes();
        this.renderer = new Renderer();
        this.setCellRenderer(this.renderer);
        Editor editor = new Editor();
        this.setCellEditor(new DefaultTreeCellEditor(this, this.renderer, editor));
        this.getModel().addTreeModelListener(this);
        this.addTreeSelectionListener(this);
    }

    public String getName() {
        return this.dx.getName();
    }

    protected void setupNodes() {
        DocNode docNode = this.getRoot();
        docNode.icon(this.is.doc).style(1).handler(new ehConfigSetName());
        DocNode docNode2 = this.add(null, this.dx.getDescription(), this.dx, false);
        docNode2.icon(this.is.descr).style(2).handler(new ehConfigSetDescr());
        this.add(docNode2, this.dx.getCurFile().getAbsolutePath(), this.dx, false).icon(this.is.locAbs);
        BsbList bsbList = this.dx.getPropertyGroup();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((PropertyGroup)listIterator.next(), docNode, docNode.getChildCount(), true);
        }
        bsbList = this.dx.getPropertySet();
        listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((PropertySet)listIterator.next(), docNode, docNode.getChildCount(), true);
        }
    }

    private DocNode insertElement(PropertyGroup propertyGroup, DocNode docNode, int n, boolean bl) {
        String string = propertyGroup.getName() + ":" + propertyGroup.getDescription();
        DocNode docNode2 = new DocNode(string, propertyGroup);
        docNode2.icon(this.is.propertyGroup).isSpecialRender(true).handler(new ehPropertyGroup());
        this.insert(n, docNode, docNode2, bl);
        BsbList bsbList = propertyGroup.getPropertySet();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((PropertySet)listIterator.next(), docNode2, docNode2.getChildCount(), false);
        }
        return docNode2;
    }

    private DocNode insertElement(PropertySet propertySet, DocNode docNode, int n, boolean bl) {
        String string = propertySet.getName() + ":" + propertySet.getShortName() + ":" + propertySet.getDescription();
        DocNode docNode2 = new DocNode(string, propertySet);
        docNode2.icon(this.is.propertySet).isSpecialRender(true).handler(new ehPropertySet());
        this.insert(n, docNode, docNode2, bl);
        BsbList bsbList = propertySet.getValueDef();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((ValueDef)listIterator.next(), docNode2, docNode2.getChildCount(), false);
        }
        return docNode2;
    }

    private DocNode insertElement(ValueDef valueDef, DocNode docNode, int n, boolean bl) {
        String string = valueDef.getValname();
        if (string == null) {
            string = "";
        }
        String string2 = valueDef.get_Value() + ":" + string + ":" + valueDef.getDescription();
        DocNode docNode2 = new DocNode(string2, valueDef);
        docNode2.icon(this.is.valueSet).isSpecialRender(true).handler(new ehValueDef());
        this.insert(n, docNode, docNode2, bl);
        return docNode2;
    }

    private void newPropertyGroup(DocNode docNode, DocNode docNode2) {
        this.newPropertyGroup(docNode, docNode.getIndex(docNode2));
    }

    private void newPropertyGroup(DocNode docNode, int n) {
        PropertyGroup propertyGroup = new PropertyGroup();
        propertyGroup.setName("Property Group");
        propertyGroup.setDescription("Group description");
        ConfigSet configSet = (ConfigSet)docNode.content();
        configSet.getPropertyGroup().add(n, propertyGroup);
        docNode = this.insertElement(propertyGroup, docNode, n + 1, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newPropertySet(DocNode docNode, DocNode docNode2) {
        this.newPropertySet(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newPropertySet(DocNode docNode, int n) {
        ValueDef valueDef = new ValueDef();
        valueDef.set_Value("0");
        valueDef.setValname("");
        valueDef.setDescription("New property value");
        PropertySet propertySet = new PropertySet();
        propertySet.setName("Property");
        propertySet.setShortName("?");
        propertySet.setDescription("Property description");
        propertySet.getValueDef().add(valueDef);
        Object object = docNode.content();
        if (object instanceof PropertyGroup) {
            ((PropertyGroup)object).getPropertySet().add(n, propertySet);
        } else if (object instanceof ConfigSet) {
            int n2 = ((ConfigSet)object).getPropertyGroup().size() + 1;
            ((ConfigSet)object).getPropertySet().add(n - n2, propertySet);
        }
        docNode = this.insertElement(propertySet, docNode, n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newValueDef(DocNode docNode, DocNode docNode2) {
        this.newValueDef(docNode, docNode.getIndex(docNode2) + 1);
    }

    private void newValueDef(DocNode docNode, int n) {
        ValueDef valueDef = new ValueDef();
        valueDef.set_Value("0");
        valueDef.setValname("");
        valueDef.setDescription("New property value");
        PropertySet propertySet = (PropertySet)docNode.content();
        propertySet.getValueDef().add(n, valueDef);
        docNode = this.insertElement(valueDef, docNode, n, true);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private Object deleteElement(DocNode docNode) {
        Object object = docNode.content();
        Object object2 = ((DocNode)docNode.getParent()).content();
        this.dx.deleteElement(object2, object);
        this.deleteNode(docNode);
        return object2;
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.userEnv.configSetEdit.isDirty(true);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.userEnv.configSetEdit.isDirty(true);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.userEnv.configSetEdit.isDirty(true);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.setEditable(false);
        DocNode docNode = (DocNode)this.getLastSelectedPathComponent();
        if (docNode != null) {
            docNode.handler().changed();
        }
        this.treeUpdate(this.dx.getName());
        this.userEnv.configSetEdit.isDirty(true);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.userEnv.disableNodeActions();
        this.checkNodeSelection();
        this.setEditable(false);
    }

    private class Editor
    extends DocEditor {
        private Component[] car;
        private JTextField tf1 = new JTextField();
        private JTextField tf2 = new JTextField();
        private JTextField tf3 = new JTextField();

        public Editor() {
            this.tf1.addKeyListener(this);
            this.tf2.addKeyListener(this);
            this.tf3.addKeyListener(this);
        }

        protected Component nodeEditor(DocTree docTree, DocNode docNode, boolean bl, boolean bl2, boolean bl3, int n) {
            if (!docNode.isSpecialRender()) {
                return super.nodeEditor(docTree, docNode, bl, bl2, bl3, n);
            }
            this.car = ((JComponent)docTree.getCellRenderer().getTreeCellRendererComponent(docTree, docNode, bl, bl2, bl3, n, true)).getComponents();
            this.nodePanel.removeAll();
            String string = (String)docNode.getUserObject();
            int n2 = ((ConfigSetTree)ConfigSetTree.this).renderer.getPreferredSize().height;
            if (docNode.content() instanceof PropertyGroup) {
                this.editPropertyGroup(string, n2);
            } else if (docNode.content() instanceof PropertySet) {
                this.editPropertySet(string, n2);
            } else if (docNode.content() instanceof ValueDef) {
                this.editValueDef(string, n2);
            } else {
                return super.nodeEditor(docTree, docNode, bl, bl2, bl3, n);
            }
            return this.nodePanel;
        }

        protected Object nodeValue() {
            if (!this.curNode.isSpecialRender()) {
                return super.nodeValue();
            }
            if (this.curNode.content() instanceof PropertyGroup) {
                return this.tf1.getText() + ":" + this.tf2.getText();
            }
            if (this.curNode.content() instanceof PropertySet) {
                return this.tf1.getText() + ":" + this.tf2.getText() + ":" + this.tf3.getText();
            }
            if (this.curNode.content() instanceof ValueDef) {
                return this.tf1.getText() + ":" + this.tf2.getText() + ":" + this.tf3.getText();
            }
            return "undefined:node:error";
        }

        private void editPropertyGroup(String string, int n) {
            JLabel jLabel = (JLabel)this.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            this.nodePanel.add(this.car[2]);
            jLabel = (JLabel)this.car[3];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
        }

        private void editPropertySet(String string, int n) {
            JLabel jLabel = (JLabel)this.car[1];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            this.tf1.setPreferredSize(dimension);
            this.nodePanel.add(this.tf1);
            jLabel = (JLabel)this.car[2];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
            this.nodePanel.add(this.car[3]);
            jLabel = (JLabel)this.car[4];
            this.tf3.setText(jLabel.getText());
            this.tf3.setFont(jLabel.getFont());
            this.tf3.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf3);
        }

        private void editValueDef(String string, int n) {
            JLabel jLabel = (JLabel)this.car[1];
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width -= this.tg;
            jLabel.setPreferredSize(dimension);
            this.nodePanel.add(jLabel);
            jLabel = (JLabel)this.car[2];
            this.tf1.setText(jLabel.getText());
            this.tf1.setFont(jLabel.getFont());
            this.tf1.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf1);
            jLabel = (JLabel)this.car[3];
            this.tf2.setText(jLabel.getText());
            this.tf2.setFont(jLabel.getFont());
            this.tf2.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf2);
            this.nodePanel.add(this.car[4]);
            jLabel = (JLabel)this.car[5];
            this.tf3.setText(jLabel.getText());
            this.tf3.setFont(jLabel.getFont());
            this.tf3.setPreferredSize(jLabel.getPreferredSize());
            this.nodePanel.add(this.tf3);
        }
    }

    private class Renderer
    extends DocRenderer {
        int vw;
        int sx1;
        int sx2;
        int sx3;
        int sx4;

        public Renderer() {
            super(ConfigSetTree.this.fontDefault);
        }

        protected Component nodeRenderer(DocNode docNode, boolean bl) {
            if (!docNode.isSpecialRender()) {
                return super.nodeRenderer(docNode, bl);
            }
            this.vw = ConfigSetTree.this.viewWidth / 10;
            this.sx1 = this.vw * 3 - docNode.getLevel() * 20;
            this.sx2 = this.vw * 2;
            this.sx3 = this.vw * 2;
            this.sx4 = this.vw * 3 - 15;
            this.nodePanel.removeAll();
            String string = (String)docNode.getUserObject();
            if (docNode.content() instanceof PropertyGroup) {
                this.renderPropertyGroup(docNode, string);
            } else if (docNode.content() instanceof PropertySet) {
                this.renderPropertySet(docNode, string);
            } else if (docNode.content() instanceof ValueDef) {
                this.renderValueDef(docNode, string);
            }
            this.nodePanel.setOpaque(bl);
            this.setVisible(false);
            this.nodePanel.setVisible(true);
            return this.nodePanel;
        }

        private void renderPropertyGroup(DocNode docNode, String string) {
            int n = string.indexOf(":");
            this.addLabel(docNode.icon(), string.substring(0, n), ConfigSetTree.this.fontBold, this.sx1 + this.sx2 + this.sx3, true);
            this.addLabel(((ConfigSetTree)ConfigSetTree.this).is.descr, string.substring(n + 1), ConfigSetTree.this.fontItalic, this.sx4, true);
        }

        private void renderPropertySet(DocNode docNode, String string) {
            int n = string.indexOf(":");
            this.addLabel(docNode.icon(), string.substring(0, n), ConfigSetTree.this.fontBold, this.sx1 + this.sx2, true);
            string = string.substring(n + 1);
            n = string.indexOf(":");
            this.addLabel(null, string.substring(0, n), ConfigSetTree.this.fontBold, this.sx3, true);
            this.addLabel(((ConfigSetTree)ConfigSetTree.this).is.descr, string.substring(n + 1), ConfigSetTree.this.fontItalic, this.sx4, true);
        }

        private void renderValueDef(DocNode docNode, String string) {
            this.addLabel(docNode.icon(), "", ConfigSetTree.this.fontDefault, this.sx1, true);
            int n = string.indexOf(":");
            this.addLabel(null, string.substring(0, n), ConfigSetTree.this.fontDefault, this.sx2, true);
            string = string.substring(n + 1);
            n = string.indexOf(":");
            this.addLabel(null, string.substring(0, n), ConfigSetTree.this.fontDefault, this.sx3, true);
            this.addLabel(((ConfigSetTree)ConfigSetTree.this).is.descr, string.substring(n + 1), ConfigSetTree.this.fontItalic, this.sx4, true);
        }
    }

    private class ehValueDef
    extends EditHandler {
        private ehValueDef() {
        }

        public void selected() {
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actEdtText, this);
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actValueSetNew, this);
            if (this.node().getParent().getChildCount() > 1) {
                this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actDelete, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actEdtText)) {
                this.editText(ConfigSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actValueSetNew)) {
                ConfigSetTree.this.newValueDef((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actDelete)) {
                ConfigSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            ValueDef valueDef = (ValueDef)this.node().content();
            int n = 0;
            int n2 = string.indexOf(":");
            valueDef.set_Value(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(":", n);
            valueDef.setValname(string.substring(n, n2));
            n = n2 + 1;
            valueDef.setDescription(string.substring(n));
        }
    }

    private class ehPropertySet
    extends EditHandler {
        private ehPropertySet() {
        }

        public void selected() {
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actEdtText, this);
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actPropertySetNew, this);
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actValueSetNew, this);
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actEdtText)) {
                this.editText(ConfigSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actPropertySetNew)) {
                ConfigSetTree.this.newPropertySet((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actValueSetNew)) {
                ConfigSetTree.this.newValueDef(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actDelete)) {
                ConfigSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            PropertySet propertySet = (PropertySet)this.node().content();
            int n = 0;
            int n2 = string.indexOf(":");
            propertySet.setName(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(":", n);
            propertySet.setShortName(string.substring(n, n2));
            n = n2 + 1;
            propertySet.setDescription(string.substring(n));
        }
    }

    private class ehPropertyGroup
    extends EditHandler {
        private ehPropertyGroup() {
        }

        public void selected() {
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actEdtText, this);
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actPropertyGroupNew, this);
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actPropertySetNew, this);
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actEdtText)) {
                this.editText(ConfigSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actPropertyGroupNew)) {
                ConfigSetTree.this.newPropertyGroup((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actPropertySetNew)) {
                ConfigSetTree.this.newPropertySet(this.node(), 0);
            }
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actDelete)) {
                ConfigSetTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            String string = (String)this.node().getUserObject();
            PropertyGroup propertyGroup = (PropertyGroup)this.node().content();
            int n = string.indexOf(":");
            propertyGroup.setName(string.substring(0, n));
            propertyGroup.setDescription(string.substring(n + 1));
        }
    }

    private class ehConfigSetDescr
    extends EditHandler {
        private ehConfigSetDescr() {
        }

        public void selected() {
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.editText(ConfigSetTree.this.thisTree);
        }

        public void changed() {
            ConfigSet configSet = (ConfigSet)this.node().content();
            configSet.setDescription(this.node().getUserObject().toString());
        }
    }

    private class ehConfigSetName
    extends EditHandler {
        private ehConfigSetName() {
        }

        public void selected() {
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actEdtText, this);
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actPropertyGroupNew, this);
            this.enable(((ConfigSetTree)ConfigSetTree.this).userEnv.actPropertySetNew, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actEdtText)) {
                this.editText(ConfigSetTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actPropertyGroupNew)) {
                ConfigSetTree.this.newPropertyGroup(ConfigSetTree.this.getRoot(), 0);
            }
            if (actionEvent.getSource().equals(((ConfigSetTree)ConfigSetTree.this).userEnv.actPropertySetNew)) {
                ConfigSetTree.this.newPropertySet(ConfigSetTree.this.getRoot(), ConfigSetTree.this.dx.getPropertyGroup().size() + 1);
            }
        }

        public void changed() {
            ConfigSet configSet = (ConfigSet)this.node().content();
            configSet.setName(this.node().getUserObject().toString());
        }
    }
}

