/*
 * Decompiled with CFR 0.152.
 */
package bsbDocTree;

import bsbDocCls.ConfigDef;
import bsbDocCls.Property;
import bsbDocCls.ValueDef;
import bsbDocExt.ConfigDefExt;
import bsbDocExt.ConfigSetExt;
import bsbDocExt.PropertyExt;
import bsbDocTree.DocNode;
import bsbDocTree.DocRenderer;
import bsbDocTree.DocTree;
import bsbEdit.EditHandler;
import bsbGui.AddEditPanel;
import bsbIcons.IconServer;
import bsbMain.ExecEnv;
import bsbMain.UserEnv;
import bsbUtil.BsbList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ConfigDefTree
extends DocTree
implements TreeModelListener,
TreeSelectionListener {
    public AddEditPanel addEditPnl = new AddEditPanel();
    private UserEnv userEnv;
    private ExecEnv execEnv;
    private ConfigDefExt dx;
    private ConfigSetExt cx;
    private IconServer is;
    private DocTree thisTree;
    private Renderer renderer;

    public ConfigDefTree(UserEnv userEnv) {
        super(userEnv.execEnv.configDef.getName(), userEnv.execEnv.configDef);
        this.userEnv = userEnv;
        this.execEnv = this.userEnv.execEnv;
        this.dx = this.execEnv.configDef;
        this.is = this.userEnv.is;
        this.thisTree = this;
        this.setupNodes();
        this.renderer = new Renderer();
        this.setCellRenderer(this.renderer);
        this.getModel().addTreeModelListener(this);
        this.addTreeSelectionListener(this);
        this.setAddEdit(this.addEditPnl);
    }

    public void setAddEdit(final AddEditPanel addEditPanel) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == addEditPanel.btnOK) {
                    ConfigDefTree.this.dx.setName(((JTextField)addEditPanel.pnlPropValue.getComponent(0)).getText());
                    ConfigDefTree.this.dx.setDescription(((JTextField)addEditPanel.pnlPropValue.getComponent(1)).getText());
                    ConfigDefTree.this.thisTree.treeUpdate(ConfigDefTree.this.dx.getName());
                } else {
                    ((JTextField)addEditPanel.pnlPropValue.getComponent(0)).setText(ConfigDefTree.this.dx.getName());
                    ((JTextField)addEditPanel.pnlPropValue.getComponent(1)).setText(ConfigDefTree.this.dx.getDescription());
                }
            }
        };
        int n = 10;
        addEditPanel.btnOK.addActionListener(actionListener);
        addEditPanel.btnCancel.addActionListener(actionListener);
        addEditPanel.pnlDocPath.add(new JLabel(this.dx.getCurFile().getAbsolutePath(), this.is.locAbs, n));
        addEditPanel.pnlPropName.add(new JLabel("Name", this.is.doc, n));
        addEditPanel.pnlPropValue.add(new JTextField(this.dx.getName()));
        addEditPanel.pnlPropName.add(new JLabel("Description  ", this.is.descr, n));
        addEditPanel.pnlPropValue.add(new JTextField(this.dx.getDescription()));
    }

    public String getName() {
        return this.dx.getName();
    }

    public File getReference(ConfigDef configDef) {
        String string = configDef.getReference();
        File file = new File(string);
        if (!file.exists()) {
            return this.execEnv.curSettings;
        }
        return file;
    }

    protected void setupNodes() {
        DocNode docNode = this.getRoot();
        docNode.icon(this.is.doc).style(1).handler(new ehConfigDefName());
        DocNode docNode2 = this.add(null, this.dx.getDescription(), this.dx, false);
        docNode2.icon(this.is.descr).style(2).handler(new ehConfigDefDescr());
        this.add(docNode2, this.dx.getCurFile().getAbsolutePath(), this.dx, false).icon(this.is.locAbs);
        this.cx = this.execEnv.configSet;
        docNode2 = this.add(docNode2, this.dx.getReference(), this.dx, false);
        docNode2.icon(this.is.docSetRef).handler(new ehDocSetRef());
        BsbList bsbList = this.dx.getProperty();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((PropertyExt)listIterator.next(), docNode, docNode.getChildCount(), true);
        }
    }

    private DocNode insertElement(PropertyExt propertyExt, DocNode docNode, int n, boolean bl) {
        Object object;
        Object object2;
        String string = propertyExt.getInclude();
        if (string != null && string.length() > 0) {
            return this.insertElement(propertyExt.cdi, propertyExt, docNode, n, bl);
        }
        boolean bl2 = false;
        String string2 = propertyExt.getName();
        String string3 = propertyExt.get_Value();
        String string4 = string2 + "::" + string3 + "::";
        Icon icon = this.is.propertyDef;
        List list = this.cx.valueList(string2);
        if (list != null) {
            object2 = list.listIterator();
            while (object2.hasNext()) {
                object = (ValueDef)object2.next();
                if (!((ValueDef)object).get_Value().equals(string3)) continue;
                string4 = string4 + ((ValueDef)object).getDescription();
                bl2 = true;
                break;
            }
            if (!bl2) {
                string4 = string4 + "Undefined Value";
                icon = this.is.propertyErr;
            }
        } else {
            string4 = string4 + "Undefined Property";
            icon = this.is.propertyErr;
        }
        object2 = this.insert(n, docNode, new DocNode(string4, propertyExt), bl);
        ((DocNode)object2).icon(icon).isSpecialRender(true).handler(new ehProperty());
        if (list != null) {
            object = list.listIterator();
            while (object.hasNext()) {
                ValueDef valueDef = (ValueDef)object.next();
                if (valueDef.get_Value().equals(string3)) continue;
                string4 = "::" + valueDef.get_Value() + "::" + valueDef.getDescription();
                this.add((DocNode)object2, string4, valueDef, false).icon(this.is.valueDef).isSpecialRender(true).handler(new ehPropertyValue());
            }
        }
        return object2;
    }

    private DocNode insertElement(ConfigDefExt configDefExt, PropertyExt propertyExt, DocNode docNode, int n, boolean bl) {
        DocNode docNode2 = null;
        if (configDefExt == null) {
            docNode2 = new DocNode("unknown::" + propertyExt.getInclude() + "::invalid document", propertyExt);
            docNode2.icon(this.is.locErr).handler(new ehProperty()).isSpecialRender(true);
            return this.insert(n, docNode, docNode2, bl);
        }
        File file = configDefExt.getIncludeFile(propertyExt.getInclude());
        if (file == null) {
            docNode2 = new DocNode("unknown::" + propertyExt.getInclude() + "::not found", propertyExt);
            docNode2.icon(this.is.locErr).handler(new ehProperty()).isSpecialRender(true);
            return this.insert(n, docNode, docNode2, bl);
        }
        docNode2 = new DocNode(configDefExt.getName(), propertyExt);
        docNode2.icon(this.is.docConfigDefRef).style(1).handler(new ehConfigDefName());
        DocNode docNode3 = this.add(docNode2, configDefExt.getDescription(), configDefExt, false);
        docNode3.icon(this.is.descr).style(2).handler(new ehConfigDefDescr());
        this.add(docNode3, configDefExt.getCurFile().getAbsolutePath(), configDefExt, false).icon(this.is.locAbs);
        docNode3 = this.add(docNode3, configDefExt.getReference(), configDefExt, false);
        docNode3.icon(this.is.docSetRef).handler(new ehDocSetRef());
        docNode = this.insert(n, docNode, docNode2, bl);
        BsbList bsbList = configDefExt.getProperty();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            this.insertElement((PropertyExt)listIterator.next(), docNode, docNode.getChildCount(), false);
        }
        return docNode;
    }

    private void selectValue(DocNode docNode) {
        DocNode docNode2 = (DocNode)docNode.getParent();
        PropertyExt propertyExt = (PropertyExt)docNode2.content();
        ValueDef valueDef = (ValueDef)docNode.content();
        String string = propertyExt.get_Value();
        propertyExt.set_Value(valueDef.get_Value());
        this.dx.invalidate();
        this.treeUpdate(this.dx.getName());
        this.userEnv.configDefEdit.isDirty(true);
    }

    private void newPropertyDef(DocNode docNode, DocNode docNode2) {
        this.newPropertyDef(docNode, docNode.getIndex(docNode2));
    }

    private void newPropertyDef(DocNode docNode, int n) {
        Object object;
        String string;
        String string2;
        Vector<String> vector = new Vector<String>();
        Vector[] vectorArray = this.cx.getProperties();
        ListIterator listIterator = vectorArray[0].listIterator();
        ListIterator listIterator2 = vectorArray[1].listIterator();
        ListIterator listIterator3 = vectorArray[2].listIterator();
        while (listIterator.hasNext()) {
            string2 = (String)listIterator.next();
            string = (String)listIterator2.next();
            object = (String)listIterator3.next();
            vector.add(string2 + " (" + (String)object + ") - " + string);
        }
        string2 = (String)JOptionPane.showInputDialog(null, "Select ConfigSet property", "Available Properties", 3, this.is.propertySet, vector.toArray(), null);
        if (string2 == null) {
            return;
        }
        string2 = string2.substring(0, string2.indexOf(" ("));
        string = this.cx.firstValue(string2);
        object = new PropertyExt();
        ((Property)object).setName(string2);
        ((Property)object).set_Value(string);
        ConfigDefExt configDefExt = null;
        if (docNode.content() instanceof ConfigDefExt) {
            configDefExt = (ConfigDefExt)docNode.content();
        } else if (docNode.content() instanceof PropertyExt) {
            configDefExt = ((PropertyExt)docNode.content()).cdi;
        }
        if (configDefExt == null) {
            return;
        }
        configDefExt.getProperty().add(n, object);
        docNode = this.insertElement((PropertyExt)object, docNode, n + 1, false);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private void newCdInclude(DocNode docNode, DocNode docNode2) {
        this.newCdInclude(docNode, docNode.getIndex(docNode2));
    }

    private void newCdInclude(DocNode docNode, int n) {
        ConfigDefExt configDefExt = null;
        if (docNode.content() instanceof ConfigDefExt) {
            configDefExt = (ConfigDefExt)docNode.content();
        } else if (docNode.content() instanceof PropertyExt) {
            configDefExt = ((PropertyExt)docNode.content()).cdi;
        }
        if (configDefExt == null) {
            return;
        }
        File file = configDefExt.getCurFile();
        if (file == null) {
            return;
        }
        File file2 = EditHandler.selectFile(file.getParentFile(), "ConfigDef");
        if (file2 == null) {
            return;
        }
        PropertyExt propertyExt = new PropertyExt();
        propertyExt.setInclude(EditHandler.relativePath(file, file2.getAbsolutePath()));
        ConfigDefExt configDefExt2 = propertyExt.setup(configDefExt, this.execEnv);
        if (configDefExt2 == null) {
            return;
        }
        configDefExt.getProperty().add(n, propertyExt);
        docNode = this.insertElement(propertyExt, docNode, n + 1, false);
        TreePath treePath = new TreePath(docNode.getPath());
        this.expandPath(treePath);
        this.setSelectionPath(treePath);
    }

    private Object deleteElement(DocNode docNode) {
        Object object = docNode.content();
        Object object2 = ((DocNode)docNode.getParent()).content();
        if (object2 instanceof ConfigDefExt) {
            this.dx.deleteElement(object2, object);
        } else {
            ((PropertyExt)object2).cdi.deleteElement(object2, object);
        }
        this.deleteNode(docNode);
        return object2;
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.userEnv.configDefEdit.isDirty(true);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.userEnv.configDefEdit.isDirty(true);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.userEnv.configDefEdit.isDirty(true);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.setEditable(false);
        DocNode docNode = (DocNode)this.getLastSelectedPathComponent();
        if (docNode != null) {
            docNode.handler().changed();
        }
        this.treeUpdate(this.dx.getName());
        this.userEnv.configDefEdit.isDirty(true);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.userEnv.disableNodeActions();
        this.checkNodeSelection();
        this.setEditable(false);
    }

    private class Renderer
    extends DocRenderer {
        int vw;
        int sx1;
        int sx2;
        int sx3;
        int sx4;

        public Renderer() {
            super(ConfigDefTree.this.fontDefault);
        }

        protected Component nodeRenderer(DocNode docNode, boolean bl) {
            if (!docNode.isSpecialRender()) {
                return super.nodeRenderer(docNode, bl);
            }
            this.vw = ConfigDefTree.this.viewWidth / 10;
            this.sx1 = this.vw * 3 - docNode.getLevel() * 20;
            this.sx2 = this.vw * 2;
            this.sx3 = this.vw * 2;
            this.sx4 = this.vw * 3 - 15;
            this.nodePanel.removeAll();
            String string = (String)docNode.getUserObject();
            if (docNode.content() instanceof Property) {
                this.renderProperty(docNode, string);
            } else if (docNode.content() instanceof ValueDef) {
                this.renderValueDef(docNode, string);
            }
            this.nodePanel.setOpaque(bl);
            this.setVisible(false);
            this.nodePanel.setVisible(true);
            return this.nodePanel;
        }

        private void renderProperty(DocNode docNode, String string) {
            int n = string.indexOf("::");
            this.addLabel(docNode.icon(), string.substring(0, n), ConfigDefTree.this.fontBold, this.sx1 + this.sx2, true);
            string = string.substring(n + 2);
            n = string.indexOf("::");
            this.addLabel(null, string.substring(0, n), ConfigDefTree.this.fontBold, this.sx3, true);
            this.addLabel(((ConfigDefTree)ConfigDefTree.this).is.descr, string.substring(n + 2), ConfigDefTree.this.fontItalic, this.sx4, true);
        }

        private void renderValueDef(DocNode docNode, String string) {
            int n = string.indexOf("::");
            this.addLabel(docNode.icon(), string.substring(0, n), ConfigDefTree.this.fontBold, this.sx1 + this.sx2, true);
            string = string.substring(n + 2);
            n = string.indexOf("::");
            this.addLabel(null, string.substring(0, n), ConfigDefTree.this.fontDefault, this.sx3, true);
            this.addLabel(((ConfigDefTree)ConfigDefTree.this).is.descr, string.substring(n + 2), ConfigDefTree.this.fontItalic, this.sx4, true);
        }
    }

    private class ehPropertyValue
    extends EditHandler {
        private ehPropertyValue() {
        }

        public void selected() {
            this.enable(((ConfigDefTree)ConfigDefTree.this).userEnv.actValueSel, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ConfigDefTree)ConfigDefTree.this).userEnv.actValueSel)) {
                ConfigDefTree.this.selectValue(this.node());
            }
        }

        public void changed() {
        }
    }

    private class ehProperty
    extends EditHandler {
        private ehProperty() {
        }

        public void selected() {
            this.enable(((ConfigDefTree)ConfigDefTree.this).userEnv.actCdIncludeNew, this);
            this.enable(((ConfigDefTree)ConfigDefTree.this).userEnv.actPropertyDefNew, this);
            this.enable(((ConfigDefTree)ConfigDefTree.this).userEnv.actDelete, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ConfigDefTree)ConfigDefTree.this).userEnv.actCdIncludeNew)) {
                ConfigDefTree.this.newCdInclude((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ConfigDefTree)ConfigDefTree.this).userEnv.actPropertyDefNew)) {
                ConfigDefTree.this.newPropertyDef((DocNode)this.node().getParent(), this.node());
            }
            if (actionEvent.getSource().equals(((ConfigDefTree)ConfigDefTree.this).userEnv.actDelete)) {
                ConfigDefTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
        }
    }

    private class ehConfigDefDescr
    extends EditHandler {
        private ehConfigDefDescr() {
        }

        public void selected() {
            this.enable(((ConfigDefTree)ConfigDefTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.editText(ConfigDefTree.this.thisTree);
        }

        public void changed() {
            ConfigDefExt configDefExt = (ConfigDefExt)this.node().content();
            configDefExt.setDescription(this.node().getUserObject().toString());
        }
    }

    private class ehDocSetRef
    extends EditHandler {
        private ehDocSetRef() {
        }

        public void selected() {
            this.enable(((ConfigDefTree)ConfigDefTree.this).userEnv.actEdtText, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.editText(ConfigDefTree.this.thisTree);
        }

        public void changed() {
            ConfigDefExt configDefExt = (ConfigDefExt)this.node().content();
            configDefExt.setReference(this.node().getUserObject().toString());
        }
    }

    private class ehConfigDefName
    extends EditHandler {
        private ehConfigDefName() {
        }

        public void selected() {
            this.enable(((ConfigDefTree)ConfigDefTree.this).userEnv.actEdtText, this);
            this.enable(((ConfigDefTree)ConfigDefTree.this).userEnv.actCdIncludeNew, this);
            this.enable(((ConfigDefTree)ConfigDefTree.this).userEnv.actPropertyDefNew, this);
            if (this.node().content() instanceof PropertyExt) {
                this.enable(((ConfigDefTree)ConfigDefTree.this).userEnv.actDelete, this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(((ConfigDefTree)ConfigDefTree.this).userEnv.actEdtText)) {
                this.editText(ConfigDefTree.this.thisTree);
            }
            if (actionEvent.getSource().equals(((ConfigDefTree)ConfigDefTree.this).userEnv.actCdIncludeNew)) {
                if (ConfigDefTree.this.thisTree.isExpanded(ConfigDefTree.this.thisTree.getSelectionPath())) {
                    ConfigDefTree.this.newCdInclude(this.node(), 0);
                } else {
                    ConfigDefTree.this.newCdInclude((DocNode)this.node().getParent(), this.node());
                }
            }
            if (actionEvent.getSource().equals(((ConfigDefTree)ConfigDefTree.this).userEnv.actPropertyDefNew)) {
                if (ConfigDefTree.this.thisTree.isExpanded(ConfigDefTree.this.thisTree.getSelectionPath())) {
                    ConfigDefTree.this.newPropertyDef(this.node(), 0);
                } else {
                    ConfigDefTree.this.newPropertyDef((DocNode)this.node().getParent(), this.node());
                }
            }
            if (actionEvent.getSource().equals(((ConfigDefTree)ConfigDefTree.this).userEnv.actDelete)) {
                ConfigDefTree.this.deleteElement(this.node());
            }
        }

        public void changed() {
            ConfigDefExt configDefExt = (ConfigDefExt)this.node().content();
            configDefExt.setName(this.node().getUserObject().toString());
        }
    }
}

