/*
 * Decompiled with CFR 0.152.
 */
package bsbDocExt;

import bsbDocCls.Args;
import bsbDocCls.BsbDocClsFactory;
import bsbDocCls.Command;
import bsbDocCls.Executable;
import bsbDocCls.Flag;
import bsbDocCls.Preamble;
import bsbDocCls.Preambles;
import bsbDocCls.Supports;
import bsbDocCls.Tool;
import bsbDocCls.ToolSet;
import bsbDocExt.BsbDocExt;
import bsbException.External;
import bsbException.Problem;
import bsbGenerator.Requestor;
import bsbGenerator.Requirement;
import bsbMain.ExecEnv;
import bsbMain.Globals;
import bsbUtil.BsbList;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Serializer;

public class ToolSetExt
extends ToolSet
implements BsbDocExt,
Requestor {
    public static final int ONE_TO_ONE = 1;
    public static final int MANY_TO_ONE = 2;
    public static final String SOURCE = "[source";
    private Builder builder = null;
    private Document doc = null;
    private ExecEnv execEnv = null;
    private File curFile = null;
    private Vector usedExecs = new Vector();

    public ToolSetExt() {
    }

    public ToolSetExt(ToolSetExt toolSetExt) {
        this.builder = toolSetExt.builder;
        this.doc = toolSetExt.doc;
        this.execEnv = toolSetExt.execEnv;
        this.curFile = toolSetExt.curFile;
    }

    public static ToolSetExt read(ExecEnv execEnv, File file) {
        Globals.state.report("Reading ToolSet: " + file.getAbsolutePath());
        ToolSetExt toolSetExt = null;
        try {
            BsbDocClsFactory bsbDocClsFactory = new BsbDocClsFactory();
            bsbDocClsFactory.register("toolSet", "bsbDocExt.ToolSetExt");
            Builder builder = new Builder(Globals.validating, bsbDocClsFactory);
            Document document = builder.build(file);
            toolSetExt = (ToolSetExt)document.getRootElement();
            toolSetExt.builder = builder;
            toolSetExt.doc = document;
        }
        catch (Exception exception) {
            throw new External("Can't read ToolSet:\u00a7\u00a7" + file.getPath(), exception);
        }
        toolSetExt.execEnv = execEnv;
        toolSetExt.curFile = file;
        return toolSetExt;
    }

    public void write(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Serializer serializer = new Serializer(fileOutputStream);
            serializer.setIndent(2);
            serializer.setMaxLength(0);
            serializer.write(this.doc);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new External("Can't write ToolSet:\u00a7\u00a7" + file.getPath(), exception);
        }
    }

    public void write() {
        this.write(this.curFile);
    }

    public File getCurFile() {
        return this.curFile;
    }

    public Object deleteElement(Object object, Object object2) {
        if (object2 instanceof Preambles) {
            return this.deleteElement((Preambles)object2);
        }
        if (object instanceof Preambles) {
            return this.deleteElement((Preambles)object, object2);
        }
        if (object2 instanceof Tool) {
            return this.deleteElement((Tool)object2);
        }
        if (object2 instanceof Command) {
            return this.deleteElement((Tool)object, (Command)object2);
        }
        if (object2 instanceof Supports) {
            return this.deleteElement((Command)object, (Supports)object2);
        }
        if (object2 instanceof Args) {
            return this.deleteElement((Command)object, (Args)object2);
        }
        if (object2 instanceof Flag) {
            return this.deleteElement((Executable)object, (Flag)object2);
        }
        return null;
    }

    public Object deleteElement(Preambles preambles) {
        BsbList bsbList = this.getPreambles();
        bsbList.remove(preambles);
        return this;
    }

    public Object deleteElement(Preambles preambles, Object object) {
        BsbList bsbList = preambles.getPreamble();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Preamble preamble = (Preamble)listIterator.next();
            String string = preamble.getValue();
            if (!string.equals(object)) continue;
            bsbList.remove(preamble);
            break;
        }
        return preambles;
    }

    public Object deleteElement(Tool tool) {
        BsbList bsbList = this.getTool();
        bsbList.remove(tool);
        return this;
    }

    public Object deleteElement(Tool tool, Command command) {
        BsbList bsbList = tool.getCommand();
        bsbList.remove(command);
        return tool;
    }

    public Object deleteElement(Command command, Supports supports) {
        BsbList bsbList = command.getSupports();
        bsbList.remove(supports);
        return command;
    }

    public Object deleteElement(Command command, Args args) {
        BsbList bsbList = command.getArgs();
        bsbList.remove(args);
        return command;
    }

    public Object deleteElement(Executable executable, Flag flag) {
        BsbList bsbList = executable.getFlag();
        bsbList.remove(flag);
        return executable;
    }

    public List getToolNames() {
        Vector<String> vector = new Vector<String>();
        BsbList bsbList = this.getTool();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Tool tool = (Tool)listIterator.next();
            vector.add(tool.getName());
        }
        return vector;
    }

    public Tool getTool(String string) {
        BsbList bsbList = this.getTool();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Tool tool = (Tool)listIterator.next();
            if (!tool.getName().equals(string)) continue;
            return tool;
        }
        throw new Problem("Tool <" + string + "> not found");
    }

    public List validPreambles() {
        Vector<Preambles> vector = new Vector<Preambles>();
        Requirement requirement = new Requirement(this);
        BsbList bsbList = this.getPreambles();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Preambles preambles = (Preambles)listIterator.next();
            if (!requirement.evaluate(preambles.getRequire())) continue;
            vector.add(preambles);
        }
        return vector;
    }

    public List validCommands(String string) {
        Vector<Command> vector = new Vector<Command>();
        Tool tool = this.getTool(string);
        Requirement requirement = new Requirement(this);
        BsbList bsbList = tool.getCommand();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Command command = (Command)listIterator.next();
            if (!requirement.evaluate(command.getRequire())) continue;
            List list = this.merged(command);
            if (list != null) {
                vector.addAll(list);
                continue;
            }
            vector.add(command);
        }
        if (vector.size() == 0) {
            throw new Problem("No valid tool command for\u00a7\u00a7Tool <" + string + ">");
        }
        return vector;
    }

    public String validExecutable(Command command) {
        BsbList bsbList;
        Executable executable = command.getExecutable();
        Requirement requirement = new Requirement(this);
        String string = this.execEnv.pathSet.fullPath(executable.getPathRef(), executable.getPath());
        if (!(Globals.isEmpty(this.execEnv.pathSet.fullPath(executable.getPathRef())) && new File(executable.getPath()).getParent() == null || new File(string).getParent() != null)) {
            string = "." + File.separatorChar + string;
        }
        if ((bsbList = executable.getFlag()) == null) {
            return string;
        }
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Flag flag = (Flag)listIterator.next();
            if (!requirement.evaluate(flag.getRequire())) continue;
            String string2 = flag.getValueRef();
            if (string2 != null && string2.length() > 0 && (string2 = this.lookUp(string2)) != null && string2.length() > 0) {
                string = string + " " + string2;
            }
            if ((string2 = flag.get_Value()) == null || string2.length() <= 0) continue;
            string = string + " " + string2;
        }
        return string;
    }

    public Args validArgs(Command command) {
        BsbList bsbList = command.getArgs();
        if (bsbList == null) {
            throw new Problem("No arguments for\u00a7\u00a7Command <" + command.getName() + ">");
        }
        Requirement requirement = new Requirement(this);
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Args args = (Args)listIterator.next();
            if (!requirement.evaluate(args.getRequire())) continue;
            return args;
        }
        throw new Problem("No valid arguments for\u00a7\u00a7Command <" + command.getName() + ">");
    }

    public String supportedFlag(Command command, String string) {
        BsbList bsbList = command.getSupports();
        if (bsbList == null) {
            return null;
        }
        Requirement requirement = new Requirement(this);
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Supports supports = (Supports)listIterator.next();
            if (!supports.getOption().equals(string) || !requirement.evaluate(supports.getRequire())) continue;
            return supports.getFlag();
        }
        return null;
    }

    public int mode(String string) {
        Tool tool = this.getTool(string);
        if (tool.getSingleRun() != null) {
            return 2;
        }
        return 1;
    }

    public List getUsedExecs() {
        Vector vector = new Vector(this.usedExecs);
        this.usedExecs.clear();
        return vector;
    }

    private List merged(Command command) {
        Executable executable = command.getExecutable();
        String string = this.execEnv.pathSet.fullPath(executable.getPathRef(), executable.getPath());
        String string2 = executable.getToolRef();
        if (string.length() > 0 && !this.usedExecs.contains(string)) {
            this.usedExecs.add(string);
        }
        if (string.length() == 0) {
            return this.merge4Exes(command);
        }
        if (string2 != null && string2.length() > 0) {
            return this.merge4Scripts(command);
        }
        return null;
    }

    private List merge4Exes(Command command) {
        Vector<Command> vector = new Vector<Command>();
        Executable executable = command.getExecutable();
        BsbList bsbList = executable.getFlag();
        BsbList bsbList2 = command.getSupports();
        BsbList bsbList3 = command.getArgs();
        List list = this.validCommands(command.getName());
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Command command2 = (Command)listIterator.next();
            Command command3 = new Command();
            Executable executable2 = command2.getExecutable();
            Executable executable3 = new Executable();
            BsbList bsbList4 = executable2.getFlag();
            BsbList bsbList5 = executable3.getFlag();
            if (bsbList != null) {
                bsbList5.addAll(bsbList);
            }
            if (bsbList4 != null) {
                bsbList5.addAll(bsbList4);
            }
            executable3.setPathRef(executable2.getPathRef());
            executable3.setPath(executable2.getPath());
            executable3.setToolRef(executable2.getToolRef());
            command3.setExecutable(executable3);
            BsbList bsbList6 = command2.getSupports();
            BsbList bsbList7 = command3.getSupports();
            if (bsbList2 != null && !bsbList2.isEmpty()) {
                bsbList7.addAll(bsbList2);
            } else if (bsbList6 != null) {
                bsbList7.addAll(bsbList6);
            }
            BsbList bsbList8 = command2.getArgs();
            BsbList bsbList9 = command3.getArgs();
            if (bsbList3 != null && !bsbList3.isEmpty()) {
                bsbList9.addAll(bsbList3);
            } else if (bsbList8 != null) {
                bsbList9.addAll(bsbList8);
            }
            String string = command.getModifier();
            command3.setModifier(string != null && string.length() > 0 ? string : command2.getModifier());
            command3.setRequire(command.getRequire());
            command3.setName(command2.getName());
            command3.setDescription(command2.getDescription());
            vector.add(command3);
        }
        return vector;
    }

    private List merge4Scripts(Command command) {
        Vector<Command> vector = new Vector<Command>();
        Executable executable = command.getExecutable();
        String string = this.execEnv.pathSet.fullPath(executable.getPathRef(), executable.getPath());
        BsbList bsbList = executable.getFlag();
        BsbList bsbList2 = command.getSupports();
        BsbList bsbList3 = command.getArgs();
        List list = this.validCommands(executable.getToolRef());
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string2;
            Command command2 = (Command)listIterator.next();
            Command command3 = new Command();
            Executable executable2 = command2.getExecutable();
            Executable executable3 = new Executable();
            BsbList bsbList4 = executable2.getFlag();
            BsbList bsbList5 = executable3.getFlag();
            if (bsbList4 != null) {
                bsbList5.addAll(bsbList4);
            }
            Flag flag = new Flag();
            flag.set_Value(string);
            bsbList5.add(flag);
            if (bsbList != null) {
                bsbList5.addAll(bsbList);
            }
            executable3.setPathRef(executable2.getPathRef());
            executable3.setPath(executable2.getPath());
            executable3.setToolRef(executable2.getToolRef());
            command3.setExecutable(executable3);
            BsbList bsbList6 = command3.getSupports();
            if (bsbList2 != null) {
                bsbList6.addAll(bsbList2);
            }
            BsbList bsbList7 = command3.getArgs();
            if (bsbList3 != null) {
                bsbList7.addAll(bsbList3);
            }
            command3.setModifier((string2 = command.getModifier()) != null && string2.length() > 0 ? string2 : command2.getModifier());
            command3.setRequire(command.getRequire());
            command3.setName(command.getName());
            command3.setDescription(command.getDescription());
            vector.add(command3);
        }
        return vector;
    }

    public String lookUp(String string) {
        return this.execEnv.optionSet.lookUp(string);
    }
}

