/*
 * Decompiled with CFR 0.152.
 */
package bsbDocExt;

import bsbDocCls.BsbDocCls;
import bsbDocCls.BsbDocClsFactory;
import bsbDocCls.SourceFile;
import bsbDocCls.Sources;
import bsbDocCls.Target;
import bsbDocCls.TargetDef;
import bsbDocCls.TargetInc;
import bsbDocCls.TargetPath;
import bsbDocCls.TargetRef;
import bsbDocCls.TargetSet;
import bsbDocExt.BsbDocExt;
import bsbDocExt.SettingsExt;
import bsbException.External;
import bsbException.Problem;
import bsbGenerator.Requestor;
import bsbGenerator.Requirement;
import bsbMain.ExecEnv;
import bsbMain.Globals;
import bsbUtil.BsbFactory;
import bsbUtil.BsbList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nu.xom.ParentNode;
import nu.xom.Serializer;

public class TargetSetExt
extends TargetSet
implements BsbDocExt,
Requestor {
    private Hashtable targets = new Hashtable();
    private Builder builder = null;
    private Document doc = null;
    private ExecEnv execEnv = null;
    private File curFile = null;
    private Target selected = null;

    public TargetSetExt() {
    }

    public TargetSetExt(TargetSetExt targetSetExt) {
        this.builder = targetSetExt.builder;
        this.doc = targetSetExt.doc;
        this.execEnv = targetSetExt.execEnv;
        this.curFile = targetSetExt.curFile;
        this.selected = targetSetExt.selected;
    }

    public static TargetSetExt read(ExecEnv execEnv, File file) {
        ParentNode parentNode;
        Object object;
        Object object2;
        if (file == null) {
            return null;
        }
        TargetSetExt targetSetExt = null;
        Globals.state.report("Reading TargetSet: " + file.getAbsolutePath());
        try {
            object2 = new BsbDocClsFactory();
            ((BsbFactory)object2).register("targetSet", "bsbDocExt.TargetSetExt");
            ((BsbFactory)object2).register("settings", "bsbDocExt.SettingsExt");
            ((BsbFactory)object2).register("options", "bsbDocExt.OptionsExt");
            object = new Builder(Globals.validating, (NodeFactory)object2);
            parentNode = ((Builder)object).build(file);
            targetSetExt = (TargetSetExt)((Document)parentNode).getRootElement();
            targetSetExt.builder = object;
            targetSetExt.doc = parentNode;
        }
        catch (Exception exception) {
            throw new External("Can't read TargetSet:\u00a7\u00a7" + file.getPath(), exception);
        }
        targetSetExt.execEnv = execEnv;
        targetSetExt.curFile = file;
        targetSetExt.selected = (Target)targetSetExt.getTarget().get(0);
        object2 = targetSetExt.getTarget().listIterator();
        while (object2.hasNext()) {
            object = (Target)object2.next();
            parentNode = (SettingsExt)((Target)object).getSettings();
            ((SettingsExt)parentNode).setEnv(execEnv);
        }
        targetSetExt.rehash();
        return targetSetExt;
    }

    public void write(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Serializer serializer = new Serializer(fileOutputStream);
            serializer.setIndent(2);
            serializer.setMaxLength(0);
            serializer.write(this.doc);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new External("Can't write TargetSet:\u00a7\u00a7" + file.getPath(), exception);
        }
    }

    public void write() {
        this.write(this.curFile);
    }

    public void rehash() {
        BsbDocCls bsbDocCls;
        this.targets.clear();
        ListIterator listIterator = this.validTargetIncs().listIterator();
        while (listIterator.hasNext()) {
            bsbDocCls = (TargetInc)listIterator.next();
            File file = this.getIncluded(((TargetInc)bsbDocCls).getIncludePath(), ((TargetInc)bsbDocCls).getIncludeFile());
            if (file == null) continue;
            TargetSetExt targetSetExt = TargetSetExt.read(this.execEnv, file);
            this.targets.putAll(targetSetExt.targets);
        }
        listIterator = this.validTargets().listIterator();
        while (listIterator.hasNext()) {
            bsbDocCls = (Target)listIterator.next();
            this.targets.put(((Target)bsbDocCls).getName(), bsbDocCls);
        }
    }

    public File getCurFile() {
        return this.curFile;
    }

    public String getFilePath() {
        if (this.curFile != null) {
            return this.curFile.getPath();
        }
        throw new Problem("TargetSet: no target selected");
    }

    public File getIncluded(String string, String string2) {
        File file;
        if (string2.startsWith("#")) {
            return null;
        }
        File file2 = null;
        file2 = Globals.isEmpty(string) ? ((file = new File(string2)).isAbsolute() ? file : new File(this.curFile.getParent(), string2)) : new File(this.execEnv.pathSet.fullPath(string, string2));
        if (file2.canRead()) {
            return file2;
        }
        throw new Problem("TargetSet Inclusion: cannot find\u00a7\u00a7<" + string2 + ">" + "\u00a7\u00a7specified by path reference <" + string + ">" + "\u00a7\u00a7             and file path  <" + string2 + ">");
    }

    public Object deleteElement(Object object, Object object2) {
        if (object2 instanceof TargetInc) {
            return this.deleteElement((TargetInc)object2);
        }
        if (object2 instanceof Target) {
            return this.deleteElement((Target)object2);
        }
        if (object2 instanceof TargetRef) {
            return this.deleteElement((Target)object, (TargetRef)object2);
        }
        if (object instanceof Target && object2 instanceof TargetDef) {
            return this.deleteElement((Target)object, (TargetDef)object2);
        }
        if (object2 instanceof TargetPath) {
            return this.deleteElement((TargetDef)object, (TargetPath)object2);
        }
        if (object2 instanceof Sources) {
            return this.deleteElement((TargetDef)object, (Sources)object2);
        }
        if (object2 instanceof SourceFile) {
            return this.deleteElement((Sources)object, (SourceFile)object2);
        }
        if (object instanceof Sources && object2 instanceof TargetDef) {
            return this.deleteElement((Sources)object, (TargetDef)object2);
        }
        return null;
    }

    public Object deleteElement(TargetInc targetInc) {
        BsbList bsbList = this.getTargetInc();
        bsbList.remove(targetInc);
        this.rehash();
        return this;
    }

    public Object deleteElement(Target target) {
        BsbList bsbList = this.getTarget();
        bsbList.remove(target);
        this.rehash();
        return this;
    }

    public Object deleteElement(Target target, TargetRef targetRef) {
        BsbList bsbList = target.getTargetRef();
        bsbList.remove(targetRef);
        return target;
    }

    public Object deleteElement(Target target, TargetDef targetDef) {
        BsbList bsbList = target.getTargetDef();
        bsbList.remove(targetDef);
        return target;
    }

    public Object deleteElement(TargetDef targetDef, TargetPath targetPath) {
        BsbList bsbList = targetDef.getTargetPath();
        bsbList.remove(targetPath);
        return targetDef;
    }

    public Object deleteElement(TargetDef targetDef, Sources sources) {
        BsbList bsbList = targetDef.getSources();
        bsbList.remove(sources);
        return targetDef;
    }

    public Object deleteElement(Sources sources, SourceFile sourceFile) {
        BsbList bsbList = sources.getSourceFile();
        bsbList.remove(sourceFile);
        return sources;
    }

    public Object deleteElement(Sources sources, TargetDef targetDef) {
        sources.setTargetDef(null);
        return sources;
    }

    public Target named(String string) {
        if (this.targets.containsKey(string)) {
            return (Target)this.targets.get(string);
        }
        throw new Problem("TargetSet: cannot find named <" + string + ">");
    }

    public List listAll() {
        return new Vector(this.targets.keySet());
    }

    public void listAll(PrintStream printStream) {
        List list = this.listAll();
        printStream.println("TargetSet \"" + this.getName() + "\" (" + this.getDescription() + "):");
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            printStream.println((String)listIterator.next());
        }
    }

    public Target selected() {
        return this.selected;
    }

    public Target selected(Target target) {
        String string = target.getAutoNamed();
        if (Globals.isEmpty(string)) {
            return this.selected(target.getName());
        }
        return this.selected(string);
    }

    public Target selected(String string) {
        if (!this.targets.containsKey(string)) {
            throw new Problem("TargetSet: cannot find selected <" + string + ">");
        }
        Target target = this.selected;
        this.selected = (Target)this.targets.get(string);
        return target;
    }

    public List validTargetIncs() {
        Vector<TargetInc> vector = new Vector<TargetInc>();
        Requirement requirement = new Requirement(this);
        BsbList bsbList = this.getTargetInc();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            TargetInc targetInc = (TargetInc)listIterator.next();
            if (!requirement.evaluate(targetInc.getRequire())) continue;
            vector.add(targetInc);
        }
        return vector;
    }

    public List validTargets() {
        Vector<Target> vector = new Vector<Target>();
        Requirement requirement = new Requirement(this);
        BsbList bsbList = this.getTarget();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Target target = (Target)listIterator.next();
            if (!requirement.evaluate(target.getRequire())) continue;
            vector.add(target);
        }
        return vector;
    }

    public List validTargetRefs(Target target) {
        Vector<String> vector = new Vector<String>();
        Requirement requirement = new Requirement(this);
        BsbList bsbList = target.getTargetRef();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            TargetRef targetRef = (TargetRef)listIterator.next();
            if (!requirement.evaluate(targetRef.getRequire())) continue;
            vector.add(targetRef.getTarget());
        }
        return vector;
    }

    public TargetDef validTargetDef(Target target) {
        Requirement requirement = new Requirement(this);
        BsbList bsbList = target.getTargetDef();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            TargetDef targetDef = (TargetDef)listIterator.next();
            if (!requirement.evaluate(targetDef.getRequire())) continue;
            return targetDef;
        }
        throw new Problem("TargetSet: no definition matches requirements\u00a7\u00a7in Target <" + target.getName() + ">");
    }

    public List validTargetDefs(Target target) {
        Vector<TargetDef> vector = new Vector<TargetDef>();
        Requirement requirement = new Requirement(this);
        BsbList bsbList = target.getTargetDef();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            TargetDef targetDef = (TargetDef)listIterator.next();
            if (!requirement.evaluate(targetDef.getRequire())) continue;
            vector.add(targetDef);
        }
        return vector;
    }

    public TargetPath validTargetPath(Target target, TargetDef targetDef) {
        Requirement requirement = new Requirement(this);
        BsbList bsbList = targetDef.getTargetPath();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            TargetPath targetPath = (TargetPath)listIterator.next();
            if (!requirement.evaluate(targetPath.getRequire())) continue;
            return targetPath;
        }
        throw new Problem("No target path matches requirements\u00a7\u00a7in Target <" + target.getName() + ">\u00a7\u00a7" + "(Definition index " + target.getTargetDef().indexOf(targetDef) + ")");
    }

    public List validSources(TargetDef targetDef) {
        Requirement requirement = new Requirement(this);
        Vector<Sources> vector = new Vector<Sources>();
        BsbList bsbList = targetDef.getSources();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            Sources sources = (Sources)listIterator.next();
            if (!requirement.evaluate(sources.getRequire())) continue;
            vector.add(sources);
        }
        return vector.size() == 0 ? null : vector;
    }

    public List validSourceFiles(Sources sources) {
        Vector<String> vector = new Vector<String>(10, 10);
        Requirement requirement = new Requirement(this);
        BsbList bsbList = sources.getSourceFile();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            SourceFile sourceFile = (SourceFile)listIterator.next();
            if (!requirement.evaluate(sourceFile.getRequire())) continue;
            String string = this.execEnv.pathSet.fullPath(sourceFile.getPathRef(), sourceFile.getPath());
            String string2 = sourceFile.getLocalFlags();
            if (string2 != null && string2.length() > 0) {
                string = string2 + "##" + string;
            }
            vector.add(string);
        }
        return vector;
    }

    public String lookUp(String string) {
        return this.lookUp(string, true);
    }

    public String lookUp(String string, boolean bl) {
        Target target = this.selected();
        SettingsExt settingsExt = (SettingsExt)target.getSettings();
        settingsExt.setEnv(this.execEnv);
        return settingsExt.lookUp(string, bl);
    }
}

