/*
 * Decompiled with CFR 0.152.
 */
package bsbDocExt;

import bsbDocCls.BsbDocClsFactory;
import bsbDocCls.Source;
import bsbDocCls.SourceDirs;
import bsbDocCls.SourceFiles;
import bsbDocCls.SourceSet;
import bsbDocCls.SourceSets;
import bsbDocCls.SrcDir;
import bsbDocExt.BsbDocExt;
import bsbDocExt.SettingsExt;
import bsbEdit.EditHandler;
import bsbException.BsbException;
import bsbException.External;
import bsbException.Panic;
import bsbException.Problem;
import bsbGenerator.Requestor;
import bsbGenerator.Requirement;
import bsbMain.ExecEnv;
import bsbMain.Globals;
import bsbUtil.BsbList;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Serializer;

public class SourceSetExt
extends SourceSet
implements BsbDocExt,
Requestor {
    private static Vector members = new Vector();
    private Builder builder = null;
    private Document doc = null;
    private ExecEnv execEnv = null;
    private File curFile = null;
    private ListIterator ssli = null;
    private static Pattern patFile = Pattern.compile("(.+)\\[(.*)\\](.*)");

    public SourceSetExt() {
    }

    public SourceSetExt(SourceSetExt sourceSetExt) {
        this.builder = sourceSetExt.builder;
        this.doc = sourceSetExt.doc;
        this.execEnv = sourceSetExt.execEnv;
        this.curFile = sourceSetExt.curFile;
        this.ssli = sourceSetExt.ssli;
    }

    public static SourceSetExt read(ExecEnv execEnv, File file) {
        Object object;
        Object object2;
        String string;
        String string2 = "";
        if (!file.exists()) {
            string = file.getParent();
            object2 = file.getName();
            object = patFile.matcher((CharSequence)object2);
            if (((Matcher)object).find()) {
                object2 = ((Matcher)object).group(1) + ((Matcher)object).group(3);
                string2 = ((Matcher)object).group(2);
                file = new File(string, (String)object2);
            }
        }
        if (!file.exists()) {
            System.err.println("Error reading  SourceSet: " + file.getName());
            file = new File(file.getParent(), file.getName().toLowerCase());
            System.err.println("Trying to read SourceSet: " + file.getName());
        }
        if (!file.exists()) {
            throw new Panic("Can't locate SourceSet file:\u00a7\u00a7<" + file.getPath() + ">");
        }
        string = " SourceSet: " + file.getPath() + "[" + string2 + "]";
        Globals.state.report("Reading" + string);
        object2 = null;
        object = null;
        try {
            members = new Vector();
            BsbDocClsFactory bsbDocClsFactory = new BsbDocClsFactory();
            bsbDocClsFactory.register("sourceSet", "bsbDocExt.SourceSetExt");
            bsbDocClsFactory.register("settings", "bsbDocExt.SettingsExt");
            bsbDocClsFactory.register("options", "bsbDocExt.OptionsExt");
            Builder builder = new Builder(Globals.validating, bsbDocClsFactory);
            Document document = builder.build(file);
            object = document.getRootElement();
            if (object instanceof SourceSets) {
                BsbList bsbList = ((SourceSets)object).getSourceSet();
                if (bsbList.isEmpty()) {
                    throw new Panic("Empty multi SourceSet document:\u00a7\u00a7<" + file.getPath() + ">");
                }
                ListIterator listIterator = bsbList.listIterator();
                while (listIterator.hasNext()) {
                    object2 = (SourceSetExt)listIterator.next();
                    ((SourceSetExt)object2).builder = builder;
                    ((SourceSetExt)object2).doc = document;
                    ((SourceSetExt)object2).curFile = file;
                    ((SourceSetExt)object2).execEnv = execEnv;
                    ((SettingsExt)((SourceSet)object2).getSettings()).setEnv(execEnv);
                    members.add(object2);
                }
                object = members;
            } else {
                object2 = (SourceSetExt)object;
                ((SourceSetExt)object2).builder = builder;
                ((SourceSetExt)object2).doc = document;
                ((SourceSetExt)object2).curFile = file;
                ((SourceSetExt)object2).execEnv = execEnv;
                ((SettingsExt)((SourceSet)object2).getSettings()).setEnv(execEnv);
                object = object2;
            }
        }
        catch (BsbException bsbException) {
            throw bsbException;
        }
        catch (Exception exception) {
            throw new External("Can't read SourceSet:\u00a7\u00a7" + file.getPath(), exception);
        }
        return SourceSetExt.getSourceSet(execEnv, object, string2);
    }

    private static SourceSetExt getSourceSet(ExecEnv execEnv, Object object, String string) {
        SourceSetExt sourceSetExt = null;
        if (object instanceof Vector) {
            Object object2;
            List list = (List)object;
            if (list.isEmpty()) {
                throw new Panic("Empty multi SourceSet document:\u00a7\u00a7<" + ((SourceSetExt)list.get((int)0)).curFile.getPath() + ">");
            }
            if (string == "") {
                object2 = "Unqualified access to multiple SourceSet document:\u00a7\u00a7<" + ((SourceSetExt)list.get((int)0)).curFile.getPath() + ">\u00a7\u00a7" + "Assuming intended access to all elements!";
                new Problem((String)object2).handle();
                string = "*";
            }
            object2 = list.listIterator();
            if (string.equals("*")) {
                sourceSetExt = (SourceSetExt)object2.next();
                sourceSetExt.ssli = object2;
            } else {
                Object object3;
                while (object2.hasNext()) {
                    object3 = (SourceSetExt)object2.next();
                    if (!string.equals(((SourceSet)object3).getName())) continue;
                    sourceSetExt = object3;
                    break;
                }
                if (sourceSetExt == null) {
                    object3 = "Cannot find member [" + string + "]\u00a7\u00a7" + "in multiple SourceSet document:\u00a7\u00a7" + "<" + ((SourceSetExt)list.get((int)0)).curFile.getPath() + ">";
                    throw new Problem((String)object3);
                }
            }
        } else {
            sourceSetExt = (SourceSetExt)object;
            if (string != "") {
                String string2 = " qualified access [" + string + "]\u00a7\u00a7" + "to simple SourceSet document:\u00a7\u00a7" + "<" + sourceSetExt.curFile.getPath() + ">";
                if (!string.equals(sourceSetExt.getName()) && !string.equals("*")) {
                    throw new Problem("Invalid" + string2);
                }
            }
        }
        sourceSetExt.execEnv = execEnv;
        ((SettingsExt)sourceSetExt.getSettings()).setEnv(execEnv);
        return sourceSetExt;
    }

    public void write(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Serializer serializer = new Serializer(fileOutputStream);
            serializer.setIndent(2);
            serializer.setMaxLength(0);
            serializer.write(this.doc);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new External("Can't write SourceSet:\u00a7\u00a7" + file.getPath(), exception);
        }
    }

    public void write() {
        this.write(this.curFile);
    }

    public File getCurFile() {
        return this.curFile;
    }

    public boolean hasNext() {
        if (this.ssli == null) {
            return false;
        }
        return this.ssli.hasNext();
    }

    public SourceSetExt next() {
        if (this.ssli == null) {
            return null;
        }
        return (SourceSetExt)this.ssli.next();
    }

    public Vector members() {
        return new Vector(members);
    }

    public boolean hasGroup() {
        return this.doc.getRootElement() instanceof SourceSets;
    }

    public Object deleteElement(Object object, Object object2) {
        if (object2 instanceof Source) {
            return this.deleteElement((SourceFiles)object, (Source)object2);
        }
        return null;
    }

    public Object deleteElement(SourceFiles sourceFiles, Source source) {
        BsbList bsbList = sourceFiles.getSource();
        bsbList.remove(source);
        return sourceFiles;
    }

    public List validSourceFiles() {
        Vector<String> vector = new Vector<String>(10, 10);
        Requirement requirement = new Requirement(this);
        SourceDirs sourceDirs = this.getSourceDirs();
        SrcDir srcDir = sourceDirs.getSrcDir();
        String string = this.execEnv.pathSet.fullPath(srcDir.getPathRef(), srcDir.getPath());
        SourceFiles sourceFiles = this.getSourceFiles();
        BsbList bsbList = sourceFiles.getSource();
        if (bsbList == null) {
            return vector;
        }
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            String string2;
            Source source = (Source)listIterator.next();
            if (!requirement.evaluate(source.getRequire())) continue;
            File file = new File(this.execEnv.makefileLoc + File.separator + string);
            File file2 = new File(source.getName());
            if (!file2.isAbsolute()) {
                file2 = new File(file, source.getName());
                file2 = new File(EditHandler.relativePath(this.execEnv.makefileLoc, file2.getPath()));
            }
            string2 = (string2 = source.getLocalFlags()) != null && string2.length() > 0 ? string2 + "##" + file2.getPath() : file2.getPath();
            vector.add(string2);
        }
        return vector;
    }

    public String lookUp(String string) {
        return this.lookUp(string, true);
    }

    public String lookUp(String string, boolean bl) {
        SettingsExt settingsExt = (SettingsExt)this.getSettings();
        settingsExt.setEnv(this.execEnv);
        return settingsExt.lookUp(string, bl);
    }
}

