/*
 * Decompiled with CFR 0.152.
 */
package bsbDocExt;

import bsbDocCls.BsbDocClsFactory;
import bsbDocCls.Path;
import bsbDocCls.PathInc;
import bsbDocCls.PathSet;
import bsbDocCls.PathTree;
import bsbDocExt.BsbDocExt;
import bsbDocExt.PathTreeExt;
import bsbEdit.EditHandler;
import bsbException.External;
import bsbException.Problem;
import bsbGenerator.Requestor;
import bsbGenerator.Requirement;
import bsbMain.ExecEnv;
import bsbMain.Globals;
import bsbUtil.BsbList;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Serializer;

public class PathSetExt
extends PathSet
implements BsbDocExt,
Requestor {
    private Hashtable pathTrees = new Hashtable();
    private Builder builder = null;
    private Document doc = null;
    private ExecEnv execEnv = null;
    private File curFile = null;
    private String pathOffset = null;
    private PathTreeExt myIncluder = null;
    private Requirement req;

    public PathSetExt() {
    }

    public PathSetExt(PathSetExt pathSetExt) {
        this.builder = pathSetExt.builder;
        this.doc = pathSetExt.doc;
        this.execEnv = pathSetExt.execEnv;
        this.curFile = pathSetExt.curFile;
        this.pathOffset = pathSetExt.pathOffset;
        this.req = pathSetExt.req;
    }

    public static PathSetExt read(ExecEnv execEnv, File file) {
        return PathSetExt.read(execEnv, file, null);
    }

    public static PathSetExt read(ExecEnv execEnv, File file, PathTreeExt pathTreeExt) {
        Globals.state.report("Reading PathSet: " + file.getAbsolutePath());
        PathSetExt pathSetExt = null;
        try {
            BsbDocClsFactory bsbDocClsFactory = new BsbDocClsFactory();
            bsbDocClsFactory.register("pathSet", "bsbDocExt.PathSetExt");
            bsbDocClsFactory.register("pathTree", "bsbDocExt.PathTreeExt");
            Builder builder = new Builder(Globals.validating, bsbDocClsFactory);
            Document document = builder.build(file);
            pathSetExt = (PathSetExt)document.getRootElement();
            pathSetExt.builder = builder;
            pathSetExt.doc = document;
        }
        catch (Exception exception) {
            throw new External("Can't read PathSet:\u00a7\u00a7" + file.getPath(), exception);
        }
        pathSetExt.execEnv = execEnv;
        pathSetExt.curFile = file;
        pathSetExt.pathOffset = EditHandler.relativePath(execEnv.makefileLoc, file.getParent());
        pathSetExt.req = new Requirement(pathSetExt);
        pathSetExt.myIncluder = pathTreeExt;
        pathSetExt.rehash(pathTreeExt);
        return pathSetExt;
    }

    public void write(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Serializer serializer = new Serializer(fileOutputStream);
            serializer.setIndent(2);
            serializer.setMaxLength(0);
            serializer.write(this.doc);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new External("Can't write PathSet:\u00a7\u00a7" + file.getPath(), exception);
        }
    }

    public void write() {
        this.write(this.curFile);
    }

    public void rehash() {
        this.rehash(this.myIncluder);
    }

    public void rehash(PathTreeExt pathTreeExt) {
        this.pathTrees.clear();
        this.rehash_2(this.getPathTree(), pathTreeExt);
    }

    private void rehash_2(List list, PathTreeExt pathTreeExt) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            PathTreeExt pathTreeExt2 = (PathTreeExt)listIterator.next();
            pathTreeExt2.parent = pathTreeExt;
            ListIterator listIterator2 = pathTreeExt2.getPathInc().listIterator();
            while (listIterator2.hasNext()) {
                File file;
                PathInc pathInc = (PathInc)listIterator2.next();
                if (!this.req.evaluate(pathInc.getRequire()) || (file = this.getIncluded(pathInc.getIncludePath(), pathInc.getIncludeFile())) == null) continue;
                PathSetExt pathSetExt = PathSetExt.read(this.execEnv, file, pathTreeExt2);
                this.pathTrees.putAll(pathSetExt.pathTrees);
            }
            this.rehash_2(pathTreeExt2.getPathTree(), pathTreeExt2);
            this.pathTrees.put(pathTreeExt2.getName(), pathTreeExt2);
        }
    }

    public File getCurFile() {
        return this.curFile;
    }

    public String getOffset() {
        return this.pathOffset;
    }

    public File getIncluded(String string, String string2) {
        File file;
        if (string2.startsWith("#")) {
            return null;
        }
        File file2 = null;
        file2 = Globals.isEmpty(string) ? ((file = new File(string2)).isAbsolute() ? file : new File(this.curFile.getParent(), string2)) : new File(this.fullPath(string, string2));
        if (file2.canRead()) {
            return file2;
        }
        throw new Problem("PathSet Inclusion: cannot find\u00a7\u00a7<" + string2 + ">" + "\u00a7\u00a7specified by path reference <" + string + ">" + "\u00a7\u00a7             and file path  <" + string2 + ">");
    }

    public void delChild(Object object, PathTreeExt pathTreeExt) {
        BsbList bsbList = null;
        if (object == null) {
            bsbList = this.getPathTree();
        } else if (object instanceof PathSet) {
            bsbList = ((PathSet)object).getPathTree();
        } else if (object instanceof PathTree) {
            bsbList = ((PathTree)object).getPathTree();
        }
        bsbList.remove(pathTreeExt);
        this.rehash();
    }

    public void delChild(Object object, PathInc pathInc) {
        List list = null;
        if (object instanceof PathTree) {
            list = ((PathTree)object).getPathInc();
        }
        list.remove(pathInc);
        this.rehash();
    }

    public void delChild(Object object, Path path) {
        List list = null;
        if (object instanceof PathTree) {
            list = ((PathTree)object).getPath();
        }
        list.remove(path);
    }

    public void addChild(Object object, PathTreeExt pathTreeExt) {
        BsbList bsbList = null;
        if (object == null) {
            bsbList = this.getPathTree();
        } else if (object instanceof PathSet) {
            bsbList = ((PathSet)object).getPathTree();
        } else if (object instanceof PathTree) {
            bsbList = ((PathTree)object).getPathTree();
        }
        bsbList.add(0, pathTreeExt);
        this.rehash();
    }

    public void addChild(Object object, PathInc pathInc) {
        BsbList bsbList = null;
        if (object instanceof PathTree) {
            bsbList = ((PathTree)object).getPathInc();
        }
        bsbList.add(0, pathInc);
        this.rehash();
    }

    public void addChild(Object object, Path path) {
        BsbList bsbList = null;
        if (object instanceof PathTree) {
            bsbList = ((PathTree)object).getPath();
        }
        bsbList.add(0, path);
    }

    public void addSibling(Object object, Object object2, PathTreeExt pathTreeExt) {
        BsbList bsbList = null;
        if (object2 == null) {
            bsbList = this.getPathTree();
        } else if (object2 instanceof PathSet) {
            bsbList = ((PathSet)object2).getPathTree();
        } else if (object2 instanceof PathTree) {
            bsbList = ((PathTree)object2).getPathTree();
        }
        if (!(object instanceof PathTree)) {
            bsbList = null;
        }
        bsbList.add(bsbList.indexOf(object) + 1, pathTreeExt);
        this.rehash();
    }

    public void addSibling(Object object, Object object2, PathInc pathInc) {
        BsbList bsbList = null;
        if (object2 instanceof PathTree) {
            bsbList = ((PathTree)object2).getPathInc();
        }
        if (!(object instanceof PathInc)) {
            bsbList = null;
        }
        bsbList.add(bsbList.indexOf(object) + 1, pathInc);
        this.rehash();
    }

    public void addSibling(Object object, Object object2, Path path) {
        BsbList bsbList = null;
        if (object2 instanceof PathTree) {
            bsbList = ((PathTree)object2).getPath();
        }
        if (!(object instanceof Path)) {
            bsbList = null;
        }
        bsbList.add(bsbList.indexOf(object) + 1, path);
    }

    public String fullPath(String string) {
        return this.fullPath(string, null);
    }

    public String fullPath(String string, String string2) {
        String string3;
        String string4 = null;
        if (string != null && string.length() == 0) {
            new Problem("PathSet contains unnamed node for <" + this.getPath(string) + ">").handle();
        }
        if (string != null && string.length() > 0) {
            string4 = this.getPath(string);
        }
        if (string4 == null) {
            string4 = "";
        }
        if ((string3 = string2) == null) {
            string3 = "";
        }
        if (string4.length() > 0 || string3.matches(".*[:\\\\/]+.*")) {
            if (string4.length() > 0 && string3.length() > 0) {
                string4 = string4 + File.separator;
            }
            if ((string4 = string4 + string3).length() > 0 && this.pathOffset.length() > 0 && !Globals.isPathAbsolute(string4) && !string4.startsWith("$(")) {
                string4 = this.pathOffset + File.separator + string4;
            }
            if (string4.length() > 0 && !Globals.isPathAbsolute(string4) && !string4.startsWith("$(")) {
                String string5 = null;
                try {
                    string5 = Globals.useCanonical ? new File(string4).getCanonicalPath() : Globals.compact(new File(string4));
                }
                catch (Exception exception) {
                    return string4;
                }
                if (string5 == null) {
                    return string4;
                }
                string4 = EditHandler.relativePath(this.execEnv.makefileLoc, string5);
            }
            return string4;
        }
        return string3;
    }

    public String getPath(String string) {
        PathTreeExt pathTreeExt = (PathTreeExt)this.pathTrees.get(string);
        if (pathTreeExt == null) {
            return null;
        }
        PathTreeExt pathTreeExt2 = pathTreeExt.parent;
        String string2 = this.getActivePath(pathTreeExt.getPath());
        if (string2 == null) {
            string2 = "";
        }
        while (pathTreeExt2 != null) {
            String string3 = this.getActivePath(pathTreeExt2.getPath());
            if (string3 != null) {
                string2 = string3 + File.separator + string2;
            }
            pathTreeExt2 = pathTreeExt2.parent;
        }
        return string2.length() == 0 ? null : string2;
    }

    public Vector[] getList() {
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector(), new Vector()};
        Enumeration enumeration = this.pathTrees.elements();
        while (enumeration.hasMoreElements()) {
            PathTreeExt pathTreeExt = (PathTreeExt)enumeration.nextElement();
            String string = pathTreeExt.getName();
            String string2 = pathTreeExt.getDescription();
            String string3 = this.getPath(string);
            if (string3 == null) continue;
            vectorArray[0].add(string);
            vectorArray[1].add(string2);
            vectorArray[2].add(string3);
        }
        return vectorArray;
    }

    private String getActivePath(List list) {
        if (list == null) {
            return null;
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Path path = (Path)listIterator.next();
            if (!this.req.evaluate(path.getRequire())) continue;
            String string = path.getAutoNamed();
            if (string != null && string.length() > 0) {
                return this.execEnv.optionSet.autoName(path.get_Value(), string);
            }
            return path.get_Value();
        }
        return null;
    }

    public String lookUp(String string) {
        return this.execEnv.optionSet.lookUp(string);
    }
}

