/*
 * Decompiled with CFR 0.152.
 */
package bsbDocExt;

import bsbDocCls.BsbDocClsFactory;
import bsbDocCls.OptionSet;
import bsbDocExt.BsbDocExt;
import bsbDocExt.OptionsExt;
import bsbException.External;
import bsbGenerator.Requestor;
import bsbMain.ExecEnv;
import bsbMain.Globals;
import bsbUtil.BsbFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Vector;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nu.xom.Serializer;

public class OptionSetExt
extends OptionSet
implements BsbDocExt,
Requestor {
    private Builder builder = null;
    private Document doc = null;
    private ExecEnv execEnv = null;
    private File curFile = null;

    public OptionSetExt() {
    }

    public OptionSetExt(OptionSetExt optionSetExt) {
        this.builder = optionSetExt.builder;
        this.doc = optionSetExt.doc;
        this.execEnv = optionSetExt.execEnv;
        this.curFile = optionSetExt.curFile;
    }

    public static OptionSetExt read(ExecEnv execEnv, File file) {
        Object object;
        Globals.state.report("Reading OptionSet: " + file.getAbsolutePath());
        OptionSetExt optionSetExt = null;
        try {
            object = new BsbDocClsFactory();
            ((BsbFactory)object).register("optionSet", "bsbDocExt.OptionSetExt");
            ((BsbFactory)object).register("options", "bsbDocExt.OptionsExt");
            Builder builder = new Builder(Globals.validating, (NodeFactory)object);
            Document document = builder.build(file);
            optionSetExt = (OptionSetExt)document.getRootElement();
            optionSetExt.builder = builder;
            optionSetExt.doc = document;
        }
        catch (Exception exception) {
            throw new External("Can't read OptionSet:\u00a7\u00a7" + file.getPath(), exception);
        }
        optionSetExt.execEnv = execEnv;
        optionSetExt.curFile = file;
        object = (OptionsExt)optionSetExt.getOptions();
        if (object != null) {
            ((OptionsExt)object).setEnv(execEnv);
        }
        return optionSetExt;
    }

    public void write(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Serializer serializer = new Serializer(fileOutputStream);
            serializer.setIndent(2);
            serializer.setMaxLength(0);
            serializer.write(this.doc);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new External("Can't write OptionSet:\u00a7\u00a7" + file.getPath(), exception);
        }
    }

    public void write() {
        this.write(this.curFile);
    }

    public File getCurFile() {
        return this.curFile;
    }

    public Object deleteElement(Object object, Object object2) {
        return ((OptionsExt)this.getOptions()).deleteElement(object, object2);
    }

    public Vector[] getOptionDefList() {
        return ((OptionsExt)this.getOptions()).getOptionDefList();
    }

    public Vector[] getCondValueList() {
        return ((OptionsExt)this.getOptions()).getCondValueList();
    }

    public String autoName(String string, String string2) {
        String string3 = this.lookUp(string2);
        if (string3 != null && string3.length() > 0) {
            String[] stringArray = string3.split("\u00a7");
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i];
            }
        }
        return string;
    }

    public String lookUp(String string) {
        String string2;
        OptionsExt optionsExt = (OptionsExt)this.getOptions();
        if (optionsExt != null && (string2 = optionsExt.lookUp(string)) != null) {
            return string2;
        }
        return null;
    }
}

