/*
 * Decompiled with CFR 0.152.
 */
package bsbDocExt;

import bsbDocCls.BsbDocClsFactory;
import bsbDocCls.ConfigSet;
import bsbDocCls.PropertyGroup;
import bsbDocCls.PropertySet;
import bsbDocCls.ValueDef;
import bsbDocExt.BsbDocExt;
import bsbException.External;
import bsbException.Panic;
import bsbMain.ExecEnv;
import bsbMain.Globals;
import bsbUtil.BsbList;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Serializer;

public class ConfigSetExt
extends ConfigSet
implements BsbDocExt {
    private Builder builder = null;
    private Document doc = null;
    private ExecEnv execEnv = null;
    private File curFile = null;

    public ConfigSetExt() {
    }

    public ConfigSetExt(ConfigSetExt configSetExt) {
        this.builder = configSetExt.builder;
        this.doc = configSetExt.doc;
        this.execEnv = configSetExt.execEnv;
        this.curFile = configSetExt.curFile;
    }

    public static ConfigSetExt read(ExecEnv execEnv, File file) {
        Globals.state.report("Reading ConfigSet: " + file.getAbsolutePath());
        ConfigSetExt configSetExt = null;
        try {
            BsbDocClsFactory bsbDocClsFactory = new BsbDocClsFactory();
            bsbDocClsFactory.register("configSet", "bsbDocExt.ConfigSetExt");
            Builder builder = new Builder(Globals.validating, bsbDocClsFactory);
            Document document = builder.build(file);
            configSetExt = (ConfigSetExt)document.getRootElement();
            configSetExt.builder = builder;
            configSetExt.doc = document;
        }
        catch (Exception exception) {
            throw new External("Can't read ConfigSet:\u00a7\u00a7" + file.getPath(), exception);
        }
        configSetExt.execEnv = execEnv;
        configSetExt.curFile = file;
        return configSetExt;
    }

    public void write(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Serializer serializer = new Serializer(fileOutputStream);
            serializer.setIndent(2);
            serializer.setMaxLength(0);
            serializer.write(this.doc);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new External("Can't write ConfigSet:\u00a7\u00a7" + file.getPath(), exception);
        }
    }

    public void write() {
        this.write(this.curFile);
    }

    public File getCurFile() {
        return this.curFile;
    }

    public Object deleteElement(Object object, Object object2) {
        if (object2 instanceof PropertyGroup) {
            return this.deleteElement((PropertyGroup)object2);
        }
        if (object2 instanceof PropertySet) {
            return this.deleteElement(object, (PropertySet)object2);
        }
        if (object2 instanceof ValueDef) {
            return this.deleteElement((PropertySet)object, (ValueDef)object2);
        }
        return null;
    }

    public Object deleteElement(PropertyGroup propertyGroup) {
        BsbList bsbList = this.getPropertyGroup();
        bsbList.remove(propertyGroup);
        return this;
    }

    public Object deleteElement(Object object, PropertySet propertySet) {
        if (object instanceof PropertyGroup) {
            BsbList bsbList = ((PropertyGroup)object).getPropertySet();
            bsbList.remove(propertySet);
            return this;
        }
        BsbList bsbList = this.getPropertySet();
        bsbList.remove(propertySet);
        return this;
    }

    public Object deleteElement(PropertySet propertySet, ValueDef valueDef) {
        BsbList bsbList = propertySet.getValueDef();
        bsbList.remove(valueDef);
        return propertySet;
    }

    public Vector[] getGroups() {
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        BsbList bsbList = this.getPropertyGroup();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            PropertyGroup propertyGroup = (PropertyGroup)listIterator.next();
            vectorArray[0].add(propertyGroup.getName());
            vectorArray[1].add(propertyGroup.getDescription());
        }
        return vectorArray;
    }

    public Vector[] getProperties() {
        Vector[] vectorArray;
        Object object;
        Vector[] vectorArray2 = new Vector[]{new Vector(), new Vector(), new Vector()};
        BsbList bsbList = this.getPropertyGroup();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            object = (PropertyGroup)listIterator.next();
            vectorArray = this.getProperties((PropertyGroup)object);
            vectorArray2[0].addAll(vectorArray[0]);
            vectorArray2[1].addAll(vectorArray[1]);
            vectorArray2[2].addAll(vectorArray[2]);
        }
        object = this.getPropertySet();
        vectorArray = object.listIterator();
        while (vectorArray.hasNext()) {
            PropertySet propertySet = (PropertySet)vectorArray.next();
            vectorArray2[0].add(propertySet.getName());
            vectorArray2[1].add(propertySet.getDescription());
            vectorArray2[2].add(propertySet.getShortName());
        }
        return vectorArray2;
    }

    public Vector[] getProperties(String string) {
        BsbList bsbList = this.getPropertyGroup();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            PropertyGroup propertyGroup = (PropertyGroup)listIterator.next();
            if (!propertyGroup.getName().equals(string)) continue;
            return this.getProperties(propertyGroup);
        }
        return null;
    }

    public Vector[] getProperties(PropertyGroup propertyGroup) {
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector(), new Vector()};
        BsbList bsbList = propertyGroup.getPropertySet();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            PropertySet propertySet = (PropertySet)listIterator.next();
            vectorArray[0].add(propertySet.getName());
            vectorArray[1].add(propertySet.getDescription());
            vectorArray[2].add(propertySet.getShortName());
        }
        return vectorArray;
    }

    public List valueList(String string) {
        PropertySet propertySet = this.findPropertySet(string);
        if (propertySet != null) {
            return propertySet.getValueDef();
        }
        return null;
    }

    public String firstValue(String string) {
        List list = this.valueList(string);
        if (list.size() <= 0) {
            return "no defined values";
        }
        ValueDef valueDef = (ValueDef)list.get(0);
        return valueDef.get_Value();
    }

    public String valueName(String string, String string2) {
        PropertySet propertySet = this.findPropertySet(string);
        if (propertySet == null) {
            throw new Panic("Invalid PropertySet: " + string);
        }
        String string3 = null;
        ListIterator listIterator = propertySet.getValueDef().listIterator();
        while (listIterator.hasNext()) {
            ValueDef valueDef = (ValueDef)listIterator.next();
            if (!valueDef.get_Value().equals(string2)) continue;
            string3 = valueDef.getValname();
            if (string3 != null) break;
            string3 = "";
            break;
        }
        if (string3 == null) {
            throw new Panic("Undefined property value (" + string2 + ")\u00a7\u00a7" + "in PropertySet <" + string + ">");
        }
        return string3;
    }

    public String shortName(String string) {
        PropertySet propertySet = this.findPropertySet(string);
        if (propertySet != null) {
            return propertySet.getShortName();
        }
        return null;
    }

    public String description(String string) {
        PropertySet propertySet = this.findPropertySet(string);
        if (propertySet != null) {
            return propertySet.getDescription();
        }
        return null;
    }

    private PropertySet findPropertySet(String string) {
        BsbList bsbList = this.getPropertyGroup();
        ListIterator listIterator = bsbList.listIterator();
        while (listIterator.hasNext()) {
            PropertyGroup propertyGroup = (PropertyGroup)listIterator.next();
            PropertySet propertySet = this.findPropertySet(string, propertyGroup.getPropertySet());
            if (propertySet == null) continue;
            return propertySet;
        }
        return this.findPropertySet(string, this.getPropertySet());
    }

    private PropertySet findPropertySet(String string, List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            PropertySet propertySet = (PropertySet)listIterator.next();
            if (!propertySet.getName().equals(string)) continue;
            return propertySet;
        }
        return null;
    }
}

