/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.jdom;

import com.icl.saxon.jdom.DocumentWrapper;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.EmptyEnumeration;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.SingletonEnumeration;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NodeTest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.transform.TransformerException;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class NodeWrapper
implements NodeInfo {
    protected Object node;
    protected short nodeType;
    protected NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    public NodeWrapper(Object object, NodeWrapper nodeWrapper, int n) {
        this.node = object;
        this.parent = nodeWrapper;
        this.index = n;
    }

    public NodeWrapper makeWrapper(Object object, NodeWrapper nodeWrapper, int n) {
        NodeWrapper nodeWrapper2;
        if (object instanceof Document) {
            return this.docWrapper;
        }
        if (object instanceof Element) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = 1;
        } else if (object instanceof Attribute) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = (short)2;
        } else if (object instanceof String || object instanceof Text) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = (short)3;
        } else if (object instanceof CDATA) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = (short)3;
        } else if (object instanceof Comment) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = (short)8;
        } else if (object instanceof ProcessingInstruction) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeType = (short)7;
        } else {
            throw new IllegalArgumentException("Bad node type in JDOM!");
        }
        nodeWrapper2.docWrapper = nodeWrapper.docWrapper;
        return nodeWrapper2;
    }

    public Object getNode() {
        return this.node;
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper nodeWrapper = (NodeWrapper)nodeInfo;
        if (this.nodeType != nodeWrapper.getNodeType()) {
            return false;
        }
        if (this.index != nodeWrapper.index) {
            return false;
        }
        if (this.node instanceof String) {
            return this.parent.isSameNode(nodeWrapper.parent);
        }
        return this.node.equals(nodeWrapper.node);
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String string) {
        this.docWrapper.baseURI = string;
    }

    public String getBaseURI() {
        return this.docWrapper.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        NodeWrapper nodeWrapper = (NodeWrapper)nodeInfo;
        if (this.isSameNode(nodeInfo)) {
            return 0;
        }
        if (this.getParent().isSameNode(nodeInfo.getParent())) {
            return this.index - nodeWrapper.index;
        }
        int n = 0;
        int n2 = 0;
        NodeWrapper nodeWrapper2 = this;
        NodeInfo nodeInfo2 = nodeInfo;
        while (nodeWrapper2 != null) {
            ++n;
            nodeWrapper2 = nodeWrapper2.getParent();
        }
        while (nodeInfo2 != null) {
            ++n2;
            nodeInfo2 = nodeInfo2.getParent();
        }
        nodeWrapper2 = this;
        while (n > n2) {
            nodeWrapper2 = nodeWrapper2.getParent();
            --n;
        }
        nodeInfo2 = nodeWrapper;
        while (n2 > n) {
            nodeInfo2 = nodeInfo2.getParent();
            --n2;
        }
        while (true) {
            NodeInfo nodeInfo3 = nodeWrapper2.getParent();
            NodeInfo nodeInfo4 = nodeInfo2.getParent();
            if (nodeInfo3 == null || nodeInfo4 == null) {
                throw new NullPointerException("JDOM tree compare - internal error");
            }
            if (nodeInfo3.isSameNode(nodeInfo4)) {
                return nodeWrapper2.index - ((NodeWrapper)nodeInfo2).index;
            }
            nodeWrapper2 = nodeInfo3;
            nodeInfo2 = nodeInfo4;
        }
    }

    public String getStringValue() {
        switch (this.nodeType) {
            case 9: {
                List list = ((Document)this.node).getContent();
                StringBuffer stringBuffer = new StringBuffer();
                NodeWrapper.expandStringValue(list, stringBuffer);
                return stringBuffer.toString();
            }
            case 1: {
                List list = ((Element)this.node).getContent();
                StringBuffer stringBuffer = new StringBuffer();
                NodeWrapper.expandStringValue(list, stringBuffer);
                return stringBuffer.toString();
            }
            case 2: {
                return ((Attribute)this.node).getValue();
            }
            case 3: {
                if (this.node instanceof String) {
                    return (String)this.node;
                }
                if (this.node instanceof CDATA) {
                    return ((CDATA)this.node).getText();
                }
                return "";
            }
            case 8: {
                return ((Comment)this.node).getText();
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getData();
            }
            case 13: {
                return ((Namespace)this.node).getURI();
            }
        }
        return "";
    }

    private static void expandStringValue(List list, StringBuffer stringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Element) {
                NodeWrapper.expandStringValue(((Element)e).getContent(), stringBuffer);
                continue;
            }
            if (e instanceof String) {
                stringBuffer.append((String)e);
                continue;
            }
            if (e instanceof CDATA) {
                stringBuffer.append(((CDATA)e).getText());
                continue;
            }
            if (!(e instanceof EntityRef)) continue;
            throw new IllegalStateException("Unexpanded entity in JDOM tree");
        }
    }

    public int getNameCode() {
        switch (this.nodeType) {
            case 1: 
            case 2: 
            case 7: {
                return this.docWrapper.namePool.allocate(this.getPrefix(), this.getURI(), this.getLocalName());
            }
        }
        return -1;
    }

    public int getFingerprint() {
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalName() {
        switch (this.nodeType) {
            case 1: {
                return ((Element)this.node).getName();
            }
            case 2: {
                return ((Attribute)this.node).getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return "";
    }

    public String getPrefix() {
        switch (this.nodeType) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    public String getURI() {
        switch (this.nodeType) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    public String getDisplayName() {
        switch (this.nodeType) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: 
            case 13: {
                return this.getLocalName();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        return this.parent;
    }

    public AxisEnumeration getEnumeration(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                if (this.nodeType == 9) {
                    return EmptyEnumeration.getInstance();
                }
                return new FilterEnumeration(new AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                if (this.nodeType == 9) {
                    return EmptyEnumeration.getInstance();
                }
                return new FilterEnumeration(new AncestorEnumeration(this, true), nodeTest);
            }
            case 2: {
                if (this.nodeType != 1) {
                    return EmptyEnumeration.getInstance();
                }
                return new FilterEnumeration(new AttributeEnumeration(this), nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new FilterEnumeration(new ChildEnumeration(this, true, true), nodeTest);
                }
                return EmptyEnumeration.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new FilterEnumeration(new DescendantEnumeration(this, false, true), nodeTest);
                }
                return EmptyEnumeration.getInstance();
            }
            case 5: {
                return new FilterEnumeration(new DescendantEnumeration(this, true, true), nodeTest);
            }
            case 6: {
                return new FilterEnumeration(new FollowingEnumeration(this), nodeTest);
            }
            case 7: {
                switch (this.nodeType) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyEnumeration.getInstance();
                    }
                }
                return new FilterEnumeration(new ChildEnumeration(this, false, true), nodeTest);
            }
            case 8: {
                if (this.nodeType != 1) {
                    return EmptyEnumeration.getInstance();
                }
                return new FilterEnumeration(new NamespaceEnumeration(this), nodeTest);
            }
            case 9: {
                if (this.parent == null) {
                    return EmptyEnumeration.getInstance();
                }
                if (nodeTest.matches((NodeInfo)this.parent)) {
                    return new SingletonEnumeration((NodeInfo)this.parent);
                }
                return EmptyEnumeration.getInstance();
            }
            case 10: {
                return new FilterEnumeration(new PrecedingEnumeration(this, false), nodeTest);
            }
            case 11: {
                switch (this.nodeType) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyEnumeration.getInstance();
                    }
                }
                return new FilterEnumeration(new ChildEnumeration(this, false, false), nodeTest);
            }
            case 12: {
                if (nodeTest.matches((NodeInfo)this)) {
                    return new SingletonEnumeration((NodeInfo)this);
                }
                return EmptyEnumeration.getInstance();
            }
            case 13: {
                return new FilterEnumeration(new PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public String getAttributeValue(String string, String string2) {
        if (this.nodeType == 1) {
            Namespace namespace = Namespace.getNamespace((String)string);
            return ((Element)this.node).getAttributeValue(string2, namespace);
        }
        return "";
    }

    public String getAttributeValue(int n) {
        if (this.nodeType == 1) {
            Iterator iterator = ((Element)this.node).getAttributes().iterator();
            NamePool namePool = this.docWrapper.getNamePool();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                int n2 = namePool.allocate(attribute.getNamespacePrefix(), attribute.getNamespaceURI(), attribute.getName());
                if (n != (n2 & 0xFFFFF)) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        switch (this.nodeType) {
            case 9: {
                return true;
            }
            case 1: {
                return !((Element)this.node).getContent().isEmpty();
            }
        }
        return false;
    }

    public String generateId() {
        if (this.node instanceof String) {
            return this.parent.generateId() + "text" + this.index;
        }
        return "j" + this.node.hashCode();
    }

    public void copy(Outputter outputter) throws TransformerException {
        switch (this.nodeType) {
            case 9: {
                AxisEnumeration axisEnumeration = this.getEnumeration((byte)3, (NodeTest)new AnyNodeTest());
                while (axisEnumeration.hasMoreElements()) {
                    axisEnumeration.nextElement().copy(outputter);
                }
                return;
            }
            case 1: {
                int n = this.getNameCode();
                outputter.writeStartTag(n);
                this.outputNamespaceNodes(outputter, true);
                AxisEnumeration axisEnumeration = this.getEnumeration((byte)2, (NodeTest)new AnyNodeTest());
                while (axisEnumeration.hasMoreElements()) {
                    axisEnumeration.nextElement().copy(outputter);
                }
                AxisEnumeration axisEnumeration2 = this.getEnumeration((byte)3, (NodeTest)new AnyNodeTest());
                while (axisEnumeration2.hasMoreElements()) {
                    axisEnumeration2.nextElement().copy(outputter);
                }
                outputter.writeEndTag(n);
                return;
            }
            case 2: {
                outputter.writeAttribute(this.getNameCode(), this.getStringValue());
                return;
            }
            case 3: {
                outputter.writeContent(this.getStringValue());
                return;
            }
            case 8: {
                outputter.writeComment(this.getStringValue());
                return;
            }
            case 7: {
                outputter.writePI(this.getLocalName(), this.getStringValue());
                return;
            }
            case 13: {
                throw new IllegalArgumentException("Copying Namespace node!");
            }
        }
    }

    public void copyStringValue(Outputter outputter) throws TransformerException {
        outputter.writeContent(this.getStringValue());
    }

    public void outputNamespaceNodes(Outputter outputter, boolean bl) throws TransformerException {
        if (this.nodeType == 1) {
            NamePool namePool = this.docWrapper.getNamePool();
            AxisEnumeration axisEnumeration = this.getEnumeration((byte)8, (NodeTest)AnyNodeTest.getInstance());
            while (axisEnumeration.hasMoreElements()) {
                Namespace namespace = (Namespace)((NodeWrapper)axisEnumeration.nextElement()).node;
                int n = namePool.allocateNamespaceCode(namespace.getPrefix(), namespace.getURI());
                outputter.writeNamespaceDeclaration(n);
            }
        }
    }

    private class PrecedingEnumeration
    extends BaseEnumeration {
        private NodeWrapper start;
        private AxisEnumeration ancestorEnum = null;
        private AxisEnumeration siblingEnum = null;
        private AxisEnumeration descendEnum = null;
        private boolean includeAncestors;

        public PrecedingEnumeration(NodeWrapper nodeWrapper2, boolean bl) {
            this.start = nodeWrapper2;
            this.includeAncestors = bl;
            this.ancestorEnum = new AncestorEnumeration(nodeWrapper2, false);
            switch (nodeWrapper2.getNodeType()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = new ChildEnumeration(nodeWrapper2, false, false);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyEnumeration.getInstance();
                }
            }
            this.advance();
        }

        public void advance() {
            if (this.descendEnum != null) {
                if (this.descendEnum.hasMoreElements()) {
                    this.next = (NodeWrapper)this.descendEnum.nextElement();
                    return;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                if (this.siblingEnum.hasMoreElements()) {
                    NodeWrapper nodeWrapper = (NodeWrapper)this.siblingEnum.nextElement();
                    if (nodeWrapper.hasChildNodes()) {
                        this.descendEnum = new DescendantEnumeration(nodeWrapper, true, false);
                        this.advance();
                    } else {
                        this.descendEnum = null;
                        this.next = nodeWrapper;
                    }
                    return;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if (this.ancestorEnum.hasMoreElements()) {
                this.next = (NodeWrapper)this.ancestorEnum.nextElement();
                this.siblingEnum = this.next.getNodeType() == 9 ? EmptyEnumeration.getInstance() : new ChildEnumeration(this.next, false, false);
                if (!this.includeAncestors) {
                    this.advance();
                }
            } else {
                this.next = null;
            }
        }

        public boolean isSorted() {
            return false;
        }

        public boolean isPeer() {
            return false;
        }

        public BaseEnumeration copy() {
            return new PrecedingEnumeration(this.start, this.includeAncestors);
        }
    }

    private class FollowingEnumeration
    extends BaseEnumeration {
        private NodeWrapper start;
        private AxisEnumeration ancestorEnum = null;
        private AxisEnumeration siblingEnum = null;
        private AxisEnumeration descendEnum = null;

        public FollowingEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            this.ancestorEnum = new AncestorEnumeration(nodeWrapper2, false);
            switch (nodeWrapper2.getNodeType()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = new ChildEnumeration(nodeWrapper2, false, true);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyEnumeration.getInstance();
                }
            }
            this.advance();
        }

        public void advance() {
            if (this.descendEnum != null) {
                if (this.descendEnum.hasMoreElements()) {
                    this.next = (NodeWrapper)this.descendEnum.nextElement();
                    return;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                if (this.siblingEnum.hasMoreElements()) {
                    this.next = (NodeWrapper)this.siblingEnum.nextElement();
                    this.descendEnum = this.next.hasChildNodes() ? new DescendantEnumeration(this.next, false, true) : null;
                    return;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if (this.ancestorEnum.hasMoreElements()) {
                this.next = (NodeWrapper)this.ancestorEnum.nextElement();
                this.siblingEnum = this.next.getNodeType() == 9 ? EmptyEnumeration.getInstance() : new ChildEnumeration(this.next, false, true);
                this.advance();
            } else {
                this.next = null;
            }
        }

        public boolean isSorted() {
            return true;
        }

        public boolean isPeer() {
            return false;
        }

        public BaseEnumeration copy() {
            return new FollowingEnumeration(this.start);
        }
    }

    private final class DescendantEnumeration
    extends BaseEnumeration {
        private AxisEnumeration children = null;
        private AxisEnumeration descendants = null;
        private NodeWrapper start;
        private boolean includeSelf;
        private boolean forwards;
        private boolean atEnd = false;

        public DescendantEnumeration(NodeWrapper nodeWrapper2, boolean bl, boolean bl2) {
            this.start = nodeWrapper2;
            this.includeSelf = bl;
            this.forwards = bl2;
            this.advance();
        }

        public void advance() {
            if (this.descendants != null) {
                if (this.descendants.hasMoreElements()) {
                    this.next = (NodeWrapper)this.descendants.nextElement();
                    return;
                }
                this.descendants = null;
            }
            if (this.children != null) {
                if (this.children.hasMoreElements()) {
                    NodeWrapper nodeWrapper = (NodeWrapper)this.children.nextElement();
                    if (nodeWrapper.hasChildNodes()) {
                        if (this.forwards) {
                            this.descendants = new DescendantEnumeration(nodeWrapper, false, this.forwards);
                            this.next = nodeWrapper;
                        } else {
                            this.descendants = new DescendantEnumeration(nodeWrapper, true, this.forwards);
                            this.advance();
                        }
                    } else {
                        this.next = nodeWrapper;
                    }
                } else if (this.forwards || !this.includeSelf) {
                    this.next = null;
                } else {
                    this.atEnd = true;
                    this.children = null;
                    this.next = this.start;
                }
            } else if (this.atEnd) {
                this.next = null;
            } else {
                this.children = this.start.hasChildNodes() ? new ChildEnumeration(this.start, true, this.forwards) : EmptyEnumeration.getInstance();
                if (this.forwards && this.includeSelf) {
                    this.next = this.start;
                } else {
                    this.advance();
                }
            }
        }

        public boolean isSorted() {
            return this.forwards;
        }

        public boolean isPeer() {
            return false;
        }

        public BaseEnumeration copy() {
            return new DescendantEnumeration(this.start, this.includeSelf, this.forwards);
        }
    }

    private class ChildEnumeration
    extends BaseEnumeration {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private ListIterator children;
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(NodeWrapper nodeWrapper2, boolean bl, boolean bl2) {
            this.start = nodeWrapper2;
            this.downwards = bl;
            this.forwards = bl2;
            this.commonParent = bl ? nodeWrapper2 : (NodeWrapper)nodeWrapper2.getParent();
            this.children = this.commonParent.getNodeType() == 9 ? ((Document)this.commonParent.node).getContent().listIterator() : ((Element)this.commonParent.node).getContent().listIterator();
            if (bl) {
                if (!bl2) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = nodeWrapper2.index;
                if (bl2) {
                    int n = 0;
                    while (n <= this.ix) {
                        this.children.next();
                        ++n;
                    }
                    ++this.ix;
                } else {
                    int n = 0;
                    while (n < this.ix) {
                        this.children.next();
                        ++n;
                    }
                    --this.ix;
                }
            }
            this.advance();
        }

        public void advance() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Object e = this.children.next();
                    if (e instanceof EntityRef) {
                        throw new IllegalStateException("Unexpanded entity in JDOM tree");
                    }
                    this.next = NodeWrapper.this.makeWrapper(e, this.commonParent, this.ix++);
                } else {
                    this.next = null;
                }
            } else if (this.children.hasPrevious()) {
                Object e = this.children.previous();
                if (e instanceof EntityRef) {
                    throw new IllegalStateException("Unexpanded entity in JDOM tree");
                }
                this.next = NodeWrapper.this.makeWrapper(e, this.commonParent, this.ix--);
            } else {
                this.next = null;
            }
        }

        public boolean isSorted() {
            return this.forwards;
        }

        public boolean isPeer() {
            return true;
        }

        public BaseEnumeration copy() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards);
        }
    }

    private final class NamespaceEnumeration
    extends BaseEnumeration {
        private HashMap nslist = new HashMap();
        private Iterator prefixes;
        private int ix = 0;
        private NodeWrapper start;

        public NamespaceEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            NodeWrapper nodeWrapper3 = nodeWrapper2;
            do {
                List list;
                Element element;
                Namespace namespace;
                if (this.nslist.containsKey((namespace = (element = (Element)nodeWrapper3.node).getNamespace()).getPrefix())) {
                    this.nslist.put(namespace.getPrefix(), namespace);
                }
                if ((list = element.getAdditionalNamespaces()).size() <= 0) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    namespace = (Namespace)iterator.next();
                    if (!this.nslist.containsKey(namespace.getPrefix())) continue;
                    this.nslist.put(namespace.getPrefix(), namespace);
                }
            } while ((nodeWrapper3 = (NodeWrapper)nodeWrapper3.getParent()).getNodeType() == 1);
            this.nslist.put("xml", Namespace.XML_NAMESPACE);
            this.prefixes = this.nslist.keySet().iterator();
        }

        public void advance() {
            if (this.prefixes.hasNext()) {
                String string = (String)this.prefixes.next();
                Namespace namespace = (Namespace)this.nslist.get(string);
                this.next = NodeWrapper.this.makeWrapper(namespace, this.start, this.ix++);
            } else {
                this.next = null;
            }
        }

        public boolean isPeer() {
            return true;
        }

        public BaseEnumeration copy() {
            return new NamespaceEnumeration(this.start);
        }
    }

    private final class AttributeEnumeration
    extends BaseEnumeration {
        private Iterator atts;
        private int ix = 0;
        private NodeWrapper start;

        public AttributeEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            this.atts = ((Element)nodeWrapper2.node).getAttributes().iterator();
            this.advance();
        }

        public void advance() {
            this.next = this.atts.hasNext() ? NodeWrapper.this.makeWrapper(this.atts.next(), this.start, this.ix++) : null;
        }

        public boolean isPeer() {
            return true;
        }

        public BaseEnumeration copy() {
            return new AttributeEnumeration(this.start);
        }
    }

    final class AncestorEnumeration
    extends BaseEnumeration {
        private boolean includeSelf;
        private NodeWrapper start;

        public AncestorEnumeration(NodeWrapper nodeWrapper2, boolean bl) {
            this.start = nodeWrapper2;
            this.includeSelf = bl;
            this.next = nodeWrapper2;
            if (!bl) {
                this.advance();
            }
        }

        public void advance() {
            this.next = (NodeWrapper)this.next.getParent();
        }

        public boolean isSorted() {
            return false;
        }

        public boolean isPeer() {
            return false;
        }

        public BaseEnumeration copy() {
            return new AncestorEnumeration(this.start, this.includeSelf);
        }
    }

    private abstract class BaseEnumeration
    implements AxisEnumeration {
        protected NodeWrapper next;

        private BaseEnumeration() {
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }

        public final NodeInfo nextElement() {
            NodeWrapper nodeWrapper = this.next;
            this.advance();
            return nodeWrapper;
        }

        public abstract void advance();

        public abstract BaseEnumeration copy();

        public final int getLastPosition() {
            return 1;
        }

        public boolean isSorted() {
            return true;
        }

        public final boolean isReverseSorted() {
            return !this.isSorted();
        }

        public boolean isPeer() {
            return false;
        }
    }

    private class FilterEnumeration
    implements AxisEnumeration {
        private BaseEnumeration base;
        private NodeTest nodeTest;
        private NodeInfo next;
        private int last = -1;

        public FilterEnumeration(BaseEnumeration baseEnumeration, NodeTest nodeTest) {
            this.base = baseEnumeration;
            this.nodeTest = nodeTest;
            this.advance();
        }

        public void advance() {
            while (this.base.hasMoreElements()) {
                this.next = this.base.nextElement();
                if (!this.nodeTest.matches(this.next)) continue;
                return;
            }
            this.next = null;
        }

        public NodeInfo nextElement() {
            NodeInfo nodeInfo = this.next;
            this.advance();
            return nodeInfo;
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public int getLastPosition() {
            if (this.last >= 0) {
                return this.last;
            }
            this.last = 0;
            BaseEnumeration baseEnumeration = this.base.copy();
            while (baseEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = baseEnumeration.nextElement();
                if (!this.nodeTest.matches(nodeInfo)) continue;
                ++this.last;
            }
            return this.last;
        }

        public boolean isSorted() {
            return this.base.isSorted();
        }

        public boolean isReverseSorted() {
            return this.base.isReverseSorted();
        }

        public boolean isPeer() {
            return this.base.isPeer();
        }
    }
}

