/*
 * Decompiled with CFR 0.152.
 */
package com.ti.xslt.extension;

public class PrimIdentifier {
    public static String get32BitPrimId(String primNumStr, int dir, String sapIDStr) {
        return PrimIdentifier.get32BitPrimId(primNumStr, dir, sapIDStr, false);
    }

    public static String get32BitPrimId(String primNumStr, int dir, String sapIDStr, boolean memHandle) {
        return PrimIdentifier.get32BitPrimId(primNumStr, dir, sapIDStr, memHandle, false);
    }

    public static String get32BitPrimId(String primNumStr, int dir, String sapIDStr, boolean memHandle, boolean virtual) {
        int primNum = PrimIdentifier.str2int(primNumStr);
        int sapID = PrimIdentifier.str2int(sapIDStr);
        long id = 0x80000000L | (long)((primNum & 0x1FFF) << 16) | (long)((dir & 1) << 14) | (long)(sapID & 0x3FFF);
        if (memHandle) {
            id |= 0x20000000L;
        }
        if (virtual) {
            id |= 0x40000000L;
        }
        return "0x" + Long.toHexString(id).toUpperCase();
    }

    public static String get16BitPrimId(String primNumStr, int dir, String sapIDStr) {
        String s = new String(Long.toHexString(PrimIdentifier.str2int(primNumStr) + (dir << 14) + (PrimIdentifier.str2int(sapIDStr) << 8)).toUpperCase());
        while (s.length() < 4) {
            s = "0" + s;
        }
        return "0x" + s;
    }

    private static int str2int(String numberString) {
        if (numberString != null) {
            int basis = 10;
            if (numberString.startsWith("0x")) {
                numberString = numberString.replaceFirst("0x", "");
                basis = 16;
            } else if (numberString.startsWith("0X")) {
                numberString = numberString.replaceFirst("0X", "");
                basis = 16;
            } else if (numberString.startsWith("0b")) {
                numberString = numberString.replaceFirst("0b", "");
                basis = 2;
            } else if (numberString.startsWith("0B")) {
                numberString = numberString.replaceFirst("0B", "");
                basis = 2;
            } else if (numberString.startsWith("0") && numberString.trim().length() > 1) {
                numberString = numberString.replaceFirst("0", "");
                basis = 8;
            }
            try {
                return Integer.parseInt(numberString, basis);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

