/*
 * Decompiled with CFR 0.152.
 */
package com.ti.xslt.extension;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class PathResolution {
    public static String getCurrentPath() {
        return PathResolution.getAbsoluteURI(System.getProperty("user.dir"));
    }

    public static String getURL(String path) {
        return PathResolution.getURL(path, false);
    }

    public static String getURL(String path, boolean noInitialSlash) {
        return PathResolution.getURL(path, noInitialSlash, false);
    }

    public static String getURL(String path, boolean noInitialSlash, boolean forceDir) {
        File file;
        if (path != null && !path.trim().equals("") && (file = new File(path)) != null) {
            try {
                URL url = file.toURI().normalize().toURL();
                String extPath = url.toExternalForm();
                if (extPath != null) {
                    if (noInitialSlash) {
                        int protLen;
                        int slashIndex = extPath.indexOf("/");
                        String prot = url.getProtocol();
                        int n = protLen = prot != null ? prot.length() + 1 : 0;
                        if (slashIndex == protLen) {
                            extPath = String.valueOf(extPath.substring(0, slashIndex)) + extPath.substring(slashIndex + 1, extPath.length());
                        }
                    }
                    return forceDir ? PathResolution.addTrailingDirSeparator(extPath) : extPath;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return forceDir ? PathResolution.addTrailingDirSeparator(path) : path;
    }

    public static String getAbsoluteURI(String path) {
        File file;
        if (path != null && !path.trim().equals("") && (file = new File(path)) != null) {
            return file.toURI().normalize().getPath();
        }
        return path;
    }

    public static String getAbsoluteURI(String filePath, boolean noInitialSlash) {
        String uri = PathResolution.getAbsoluteURI(filePath);
        if (uri != null && uri.startsWith("/") && uri.charAt(2) == ':') {
            uri = uri.substring(1, uri.length());
        }
        return uri;
    }

    public static String addTrailingDirSeparator(String string) {
        if (string != null && !string.trim().endsWith(File.separator)) {
            string = String.valueOf(string.trim()) + File.separator;
        }
        return string;
    }
}

