/*
 * Decompiled with CFR 0.152.
 */
package com.ti.xslt.extension;

import com.ti.sapeditor.StdUtil;
import com.ti.sapeditor.editors.ExternalEditorManager;
import com.ti.sapeditor.files.FileIO;
import com.ti.xslt.extension.NameGenerator;
import com.ti.xslt.extension.PathResolution;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.w3c.dom.Node;

public class ImageConversion {
    public static String convertWithCommand(String fileName, String srcDir, String subName, String convertCmd, Object fileDependencies) {
        return ImageConversion.convertWithCommand(fileName, srcDir, null, subName, convertCmd, fileDependencies, false);
    }

    public static String convertWithCommand(String fileName, String srcDir, String dstDir, String subName, String convertCmd, Object fileDependencies) {
        return ImageConversion.convertWithCommand(fileName, srcDir, dstDir, subName, convertCmd, fileDependencies, false);
    }

    public static String convertWithCommand(String fileName, String srcDir, String dstDir, String subName, String convertCmd, Object fileDependencies, boolean createJpg) {
        boolean converted = false;
        PathWorker pathWorker = null;
        if (convertCmd != null && !convertCmd.trim().equals("")) {
            ArrayList<String> depFileNames = new ArrayList<String>();
            if (fileDependencies instanceof DTMNodeIterator) {
                Node depNode;
                while ((depNode = ((DTMNodeIterator)fileDependencies).nextNode()) != null) {
                    Node child;
                    Node nameNode = null;
                    Node archiveNode = null;
                    for (Node node = depNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                        String nodeName = node.getLocalName();
                        if (nodeName == null) {
                            nodeName = node.getNodeName();
                        }
                        if (nodeName == null) continue;
                        if (nodeName.equals("Name")) {
                            nameNode = node;
                            continue;
                        }
                        if (!nodeName.equals("ArchiveName")) continue;
                        archiveNode = node;
                    }
                    if (nameNode == null || (child = nameNode.getFirstChild()) == null) continue;
                    depFileNames.add(child.getNodeValue());
                }
            }
            String[] replacements = new String[2 + depFileNames.size()];
            replacements[0] = fileName;
            replacements[1] = subName;
            int i = 0;
            while (i < depFileNames.size()) {
                Object o = depFileNames.get(i);
                replacements[i + 2] = o != null ? (String)o : "";
                ++i;
            }
            String dirPath = FileIO.getOSPath((String)srcDir);
            String cmdLine = ExternalEditorManager.assembleCmdLine((String)convertCmd, (String[])replacements, (String)dirPath);
            if (cmdLine != null) {
                if (dirPath != null) {
                    pathWorker = new PathWorker(String.valueOf(dirPath) + File.separator + subName);
                }
                try {
                    StdUtil.executeExternal((String)cmdLine, (boolean)true);
                    converted = true;
                }
                catch (IOException archiveNode) {
                    // empty catch block
                }
            }
        }
        String filePath = null;
        if (converted && (filePath = ExternalEditorManager.findImageFilePath((String)srcDir, (String)subName)) == null) {
            converted = false;
        }
        if (!converted) {
            filePath = String.valueOf(srcDir) + fileName;
        }
        if (dstDir != null && converted && filePath != null) {
            File fromFile = new File(filePath);
            String suffix = fromFile.getName();
            if (suffix != null) {
                suffix = suffix.substring(suffix.lastIndexOf("."));
            }
            File toFile = new File(String.valueOf(FileIO.addTrailingDirSeparator((String)dstDir)) + NameGenerator.getName() + (suffix != null ? suffix : ""));
            if (fromFile != null && fromFile.isFile() && toFile != null && toFile.getParentFile().isDirectory()) {
                boolean renamed = fromFile.renameTo(toFile);
                boolean copied = false;
                if (!renamed && (copied = FileIO.copyFile((File)fromFile, (File)toFile, (boolean)true))) {
                    fromFile.delete();
                }
                if (renamed || copied) {
                    filePath = toFile.getAbsolutePath();
                    if (pathWorker != null) {
                        pathWorker.removeCreatedPath();
                    }
                }
            }
        }
        if (filePath != null) {
            if (createJpg) {
                filePath = ImageConversion.convert2jpg(filePath, String.valueOf(filePath.substring(0, filePath.length() - 3)) + "jpg");
            } else if (filePath.endsWith("svg")) {
                ImageConversion.svgScaleDownPdfA4(filePath);
            }
        }
        return PathResolution.getAbsoluteURI(filePath, true);
    }

    private static String convert2jpg(String srcFile, String dstFile) {
        if (srcFile != null) {
            if (dstFile == null) {
                dstFile = String.valueOf(srcFile) + ".jpg";
            }
            if (srcFile.endsWith(".eps")) {
                ImageConversion.magicConvert300(srcFile, dstFile);
            } else if (srcFile.endsWith(".svg")) {
                ImageConversion.visioConvert(srcFile, dstFile);
                if (!new File(dstFile).isFile()) {
                    ImageConversion.magicConvert300(srcFile, dstFile);
                }
            }
            if (!new File(dstFile).isFile()) {
                return srcFile;
            }
            return dstFile;
        }
        return null;
    }

    public static String convert(String filePath, String dstDir, boolean createJpg) {
        if (filePath != null) {
            String dstFilePath;
            if (filePath.endsWith(".wmf") || filePath.endsWith(".emf")) {
                dstFilePath = String.valueOf(FileIO.addTrailingDirSeparator((String)dstDir)) + NameGenerator.getName();
                ImageConversion.visioConvert(filePath, String.valueOf(dstFilePath) + ".eps");
                if (new File(String.valueOf(dstFilePath) + ".eps").isFile()) {
                    filePath = String.valueOf(dstFilePath) + ".eps";
                } else {
                    ImageConversion.visioPrintToFile(filePath, String.valueOf(dstFilePath) + ".ps");
                    ImageConversion.convertPsToEps(String.valueOf(dstFilePath) + ".ps", String.valueOf(dstFilePath) + ".eps");
                    if (new File(String.valueOf(dstFilePath) + ".eps").isFile()) {
                        filePath = String.valueOf(dstFilePath) + ".eps";
                    } else {
                        ImageConversion.visioConvertA4(filePath, String.valueOf(dstFilePath) + ".svg");
                        if (new File(String.valueOf(dstFilePath) + ".svg").isFile()) {
                            filePath = String.valueOf(dstFilePath) + ".svg";
                        } else {
                            ImageConversion.visioConvert(filePath, String.valueOf(dstFilePath) + ".svg");
                            if (new File(String.valueOf(dstFilePath) + ".svg").isFile()) {
                                filePath = String.valueOf(dstFilePath) + ".svg";
                            }
                        }
                    }
                }
            }
            if (createJpg && (filePath.endsWith(".eps") || filePath.endsWith(".svg"))) {
                dstFilePath = String.valueOf(FileIO.addTrailingDirSeparator((String)dstDir)) + NameGenerator.getName() + ".jpg";
                filePath = ImageConversion.convert2jpg(filePath, dstFilePath);
            } else if (filePath.endsWith("svg")) {
                ImageConversion.svgScaleDownPdfA4(filePath);
            }
        }
        return filePath;
    }

    public static void eps2jpg(String srcFile, String dstFile) {
        ImageConversion.magicConvert300(srcFile, dstFile);
    }

    private static void magicConvert300(String srcFile, String dstFile) {
        if (srcFile != null && dstFile != null) {
            try {
                String sCmd = "cmd /C %GPF%\\tools\\bin\\imagemagick\\convert.exe -density 300 " + srcFile + " " + dstFile;
                Process p = Runtime.getRuntime().exec(sCmd);
                try {
                    p.waitFor();
                }
                catch (InterruptedException e2) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void visioConvertA4(String srcFile, String dstFile) {
        ImageConversion.visioConvert(srcFile, dstFile, 142.4, 243.0);
    }

    private static void visioConvert(String srcFile, String dstFile) {
        ImageConversion.visioConvert(srcFile, dstFile, -1.0, -1.0);
    }

    private static void visioConvert(String srcFile, String dstFile, double maxXmm, double maxYmm) {
        if (srcFile != null && dstFile != null) {
            try {
                String sCmd = maxXmm > 0.0 || maxYmm > 0.0 ? "cmd /C %GPF%\\BIN\\execmd -v -n -f " + srcFile + " -d " + dstFile + " --maxXmm " + maxXmm + " --maxYmm " + maxYmm : "cmd /C %GPF%\\BIN\\execmd -v -n -f " + srcFile + " -d " + dstFile;
                Process p = Runtime.getRuntime().exec(sCmd);
                try {
                    p.waitFor();
                }
                catch (InterruptedException e2) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void visioPrintToFile(String srcFile, String dstFile) {
        if (srcFile != null && dstFile != null) {
            try {
                String sCmd = "cmd /C start /WAIT /MIN call %GPF%\\util\\sape\\bin\\exitingcall.bat %GPF%\\util\\sape\\bin\\visioPrintToFile.bat " + srcFile + " " + dstFile;
                Process p = Runtime.getRuntime().exec(sCmd);
                try {
                    p.waitFor();
                }
                catch (InterruptedException e2) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void convertPsToEps(String srcFile, String dstFile) {
        if (srcFile != null && dstFile != null) {
            try {
                String sCmd = "cmd /C start /WAIT /MIN call %GPF%\\util\\sape\\bin\\exitingcall.bat %GPF%\\util\\sape\\bin\\ps2eps.bat " + srcFile + " " + dstFile;
                Process p = Runtime.getRuntime().exec(sCmd);
                try {
                    p.waitFor();
                }
                catch (InterruptedException e2) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        ImageConversion.svgScaleDown("X:\\g23m\\condat\\com\\doc\\sapedoc\\pdf\\sap\\file1a\\images\\__sape10.svg", "C:\\tvo\\pict\\svgtest3_result.svg", 151, 260);
    }

    private static String svgCleanup(String svgContents) {
        boolean modified = false;
        if (svgContents != null) {
            Matcher clipMatcher;
            boolean hasclip;
            boolean hasGclip;
            Pattern gclipPattern = Pattern.compile("\\s*\\S+?\\s*=\\s*\"\\s*url\\s*\\(.+?\\)\"", 32);
            Matcher gclipMatcher = gclipPattern.matcher(svgContents);
            StringBuffer svgContentsNew = new StringBuffer();
            int lastMatchEnd = 0;
            while (hasGclip = gclipMatcher.find()) {
                modified = true;
                svgContentsNew.append(svgContents.substring(lastMatchEnd, gclipMatcher.start()));
                lastMatchEnd = gclipMatcher.end();
            }
            svgContentsNew.append(svgContents.substring(lastMatchEnd, svgContents.length()));
            svgContents = svgContentsNew.toString();
            Pattern clipPattern = Pattern.compile("\\s*clip\\s*=\\s*\".*?\"", 32);
            while (hasclip = (clipMatcher = clipPattern.matcher(svgContents)).find()) {
                modified = true;
                svgContents = String.valueOf(svgContents.substring(0, clipMatcher.start())) + svgContents.substring(clipMatcher.end(), svgContents.length());
            }
        }
        return modified ? svgContents : null;
    }

    private static void svgScaleDownPdfA4(String filePath) {
        ImageConversion.svgScaleDown(filePath, null, 151, 252);
    }

    private static void svgScaleDown(String svgSrcFile, String svgDstFile, int maxXmm, int maxYmm) {
        if (svgSrcFile != null) {
            String image;
            boolean fileWritten = false;
            boolean fileModified = false;
            if (svgDstFile == null) {
                svgDstFile = svgSrcFile;
                fileWritten = true;
            }
            if ((image = FileIO.byteToString((byte[])FileIO.readFileContents((File)new File(svgSrcFile)))) != null) {
                Pattern rootPattern;
                Matcher rootMatcher;
                boolean hasRoot;
                String cleanImage = ImageConversion.svgCleanup(image);
                if (cleanImage != null) {
                    image = cleanImage;
                    fileModified = true;
                }
                if (hasRoot = (rootMatcher = (rootPattern = Pattern.compile("<\\s*svg\\s.*?>", 32)).matcher(image)).find()) {
                    String prevRoot = image.substring(0, rootMatcher.start());
                    String postRoot = image.substring(rootMatcher.end(), image.length());
                    String root = image.substring(rootMatcher.start(), rootMatcher.end());
                    String modifiedRoot = ImageConversion.replaceSizeValueInTag(maxXmm, "width", root);
                    if (modifiedRoot != null) {
                        root = modifiedRoot;
                        fileModified = true;
                    }
                    if ((modifiedRoot = ImageConversion.replaceSizeValueInTag(maxYmm, "height", root)) != null) {
                        root = modifiedRoot;
                        fileModified = true;
                    }
                    if (fileModified) {
                        image = String.valueOf(prevRoot) + root + postRoot;
                    }
                }
            }
            if (fileModified) {
                try {
                    FileIO.writeNonProjectFileContents((String)svgDstFile, (byte[])FileIO.stringToByte((String)image), (boolean)true);
                    fileWritten = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!fileWritten) {
                FileIO.copyFile((File)new File(svgSrcFile), (File)new File(svgDstFile), (boolean)true);
            }
        }
    }

    private static String replaceSizeValueInTag(int maxXmm, String sizeName, String root) {
        Pattern sizeValuePattern = Pattern.compile(String.valueOf(sizeName) + "\\s*=\\s*\".*?\"", 32);
        Matcher sizeValueMatcher = sizeValuePattern.matcher(root);
        if (sizeValueMatcher.find()) {
            String prevSizeValue = root.substring(0, sizeValueMatcher.start());
            String postSizeValue = root.substring(sizeValueMatcher.end(), root.length());
            String sizeValue = root.substring(sizeValueMatcher.start(), sizeValueMatcher.end());
            String number = sizeValue.substring(sizeValue.indexOf("\"") + 1, sizeValue.lastIndexOf("\"")).trim();
            if ((number = ImageConversion.scaleDownNumber(number, maxXmm)) != null) {
                sizeValue = String.valueOf(sizeName) + "=\"" + number + "\"";
                root = String.valueOf(prevSizeValue) + sizeValue + postSizeValue;
                return root;
            }
        }
        return null;
    }

    private static String scaleDownNumber(String number, int maxMm) {
        if (number != null && maxMm >= 0) {
            try {
                if (number.endsWith("mm") && Double.parseDouble(number.substring(0, number.length() - 2)) > (double)maxMm) {
                    return String.valueOf(new Integer(maxMm).toString()) + "mm";
                }
                if (number.endsWith("cm") && Double.parseDouble(number.substring(0, number.length() - 2)) * 10.0 > (double)maxMm) {
                    return String.valueOf(new Integer(maxMm).toString()) + "mm";
                }
                if (number.endsWith("in") && Double.parseDouble(number.substring(0, number.length() - 2)) * 25.4 > (double)maxMm) {
                    return String.valueOf(new Integer(maxMm).toString()) + "mm";
                }
                if (number.endsWith("pt") && Double.parseDouble(number.substring(0, number.length() - 2)) * 25.4 / 72.0 > (double)maxMm) {
                    return String.valueOf(new Integer(maxMm).toString()) + "mm";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class PathWorker {
        private ArrayList createList = null;
        private File orgPath = null;

        public PathWorker(String filePathString) {
            this.createPath(filePathString);
        }

        private ArrayList createPath(String filePathString) {
            this.createList = new ArrayList();
            File path = new File(filePathString).getParentFile();
            while (!path.exists()) {
                this.createList.add(path.getName());
                path = path.getParentFile();
                if (path != null) continue;
                this.orgPath = null;
                this.createList = null;
                return null;
            }
            this.orgPath = path;
            ListIterator it = this.createList.listIterator(this.createList.size());
            while (it.hasPrevious()) {
                boolean isDir;
                String segment = (String)it.previous();
                if (segment == null || (isDir = (path = new File(String.valueOf(path.getPath()) + File.separator + segment)).mkdir())) continue;
                return this.createList;
            }
            return this.createList;
        }

        public void removeCreatedPath() {
            if (this.orgPath != null && this.createList != null) {
                File delPath = this.orgPath;
                ArrayList<File> delList = new ArrayList<File>();
                ListIterator it = this.createList.listIterator(this.createList.size());
                while (it.hasPrevious()) {
                    String segment = (String)it.previous();
                    if (segment == null) continue;
                    File[] delFiles = delPath.listFiles(new FileFilter(this, segment){
                        final /* synthetic */ PathWorker this$1;
                        private final /* synthetic */ String val$segment;
                        {
                            this.this$1 = pathWorker;
                            this.val$segment = string;
                        }

                        public boolean accept(File arg0) {
                            return this.val$segment.equals(arg0.getName());
                        }
                    });
                    if (delFiles == null || delFiles.length != 1 || !delFiles[0].isDirectory()) break;
                    delList.add(delFiles[0]);
                    delPath = delFiles[0];
                }
                it = delList.listIterator(delList.size());
                while (it.hasPrevious()) {
                    File delDir = (File)it.previous();
                    if (delDir == null) continue;
                    delDir.delete();
                }
            }
        }
    }
}

