/*****************************************************************************/
/* string.h   V1.22e                                                          */
/* Copyright (c) 1995-1997  Texas Instruments Incorporated                   */
/*****************************************************************************/

#ifndef _STRING
#define _STRING
 
#ifndef NULL
#define NULL 0
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

#ifdef _INLINE 
#define __INLINE static inline
#else
#define __INLINE
#endif

__INLINE size_t  strlen(const char *s);
__INLINE char   *strcpy(char *s1, const char *s2);
__INLINE char   *strncpy(char *s1, const char *s2, size_t n);
__INLINE char   *strcat(char *s1, const char *s2);
__INLINE char   *strncat(char *s1, const char *s2, size_t n);
__INLINE char   *strchr(const char *s, int c);
__INLINE char   *strrchr(const char *s, int c);
         int     strcmp(const char *s1, const char *s2);
         int     strncmp(const char *s1, const char *s2, size_t n);
        
         int     strcoll(const char *s1, const char *s2);
         size_t  strxfrm(char *s1, const char *s2, size_t n);
         char   *strpbrk(const char *s1, const char *s2);
         size_t  strspn(const char *s1, const char *s2);
         size_t  strcspn(const char *s1, const char *s2);
         char   *strstr(const char *s1, const char *s2);
         char   *strtok(char *s1, const char *s2);
         char   *strerror(int errno);
        
         void   *memmove(void *s1, const void *s2, size_t n);
         void   *memcpy(void *s1, const void *s2, size_t n);
         int     memcmp(const void *s1, const void *s2, size_t n);
__INLINE void   *memchr(const void *s, int c, size_t n);
__INLINE void   *memset(void *s, int c, size_t n);

#ifdef _INLINE

/****************************************************************************/
/*  strlen                                                                  */
/****************************************************************************/
static inline size_t strlen(const char *s)
{
   const char *r = s - 1;

   while (*++r);
   return r - s;
}

/****************************************************************************/
/*  strcpy                                                                  */
/****************************************************************************/
static inline char *strcpy(char *s1, const char *s2)
{
   char *result = s1;

   while (*s1++ = *s2++);
   return result;
}

/****************************************************************************/
/*  strncpy                                                                 */
/****************************************************************************/
static inline char *strncpy(char *s1, const char *s2, size_t n)
{
   char *result = s1;

   if (n == 0) return result; 
   while ((*s1++ = *s2++) && --n != 0);  /* COPY STRING         */
   if (n > 1)
   {
      --n;
      do *s1++ = 0; while (--n);         /* TERMINATION PADDING */
   }
   return result;
}

/****************************************************************************/
/*  strcat                                                                  */
/****************************************************************************/
static inline char *strcat(char *s1, const char *s2)
{
   char *result = s1;

   while (*s1++);			     /* FIND END OF STRING   */
   --s1;				     /* BACK UP OVER NULL    */
   while (*s1++ = *s2++);	             /* APPEND SECOND STRING */
   return result;
}

/****************************************************************************/
/*  strncat                                                                 */
/****************************************************************************/
static inline char *strncat(char *s1, const char *s2, size_t n)
{
   char *result = s1;

   while (*s1++);			   /* FIND END OF STRING   */
   --s1;  				   /* BACK UP OVER NULL    */
   while (n-- != 0) 
      if (!(*s1++ = *s2++)) return result; /* APPEND SECOND STRING */
   *s1 = 0;
   return result;
}

/****************************************************************************/
/*  strchr                                                                  */
/****************************************************************************/
static inline char *strchr(const char *s, int c)
{
   do
      if (*s == c) return (char *)s;
   while (*s++);
 
   return NULL;
}

/****************************************************************************/
/*  strrchr                                                                 */
/****************************************************************************/
static inline char *strrchr(const char *s, int c)
{
   char *result = NULL;
 
   do
      if (*s == c) result = (char *)s;
   while (*s++);
 
   return(result);
}

/****************************************************************************/
/*  memchr                                                                  */
/****************************************************************************/
static inline void *memchr(const void *s, int c, size_t n)
{
   const unsigned char *st = (unsigned char *)s;
   unsigned char        ch = c;

   while (n-- != 0) 
      if (*st++ == ch) { return (void *)--st; }
   return NULL;
}

/****************************************************************************/
/*  memset                                                                  */
/****************************************************************************/
static inline void *memset(void *s, int c, size_t n)
{
   unsigned char *st = (unsigned char *)s;
   unsigned char  ch = c;

   while (n-- > 0)  *st++ = ch;
   return s;
}

#endif

#undef __INLINE

#endif

