/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   : ccddata_tap_priv.c 
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  Ccddata abstraction for use in lib/dll. This function belongs
|             logically to tap_tdl.c, but is based on constants from mconst.cdg.
+----------------------------------------------------------------------------- 
*/ 

#define CCDDATA_TAP_PRIV_C

#include "typedefs.h"
#include "mconst.cdg"
#include "ccddata_tap_priv.h"

/*
+------------------------------------------------------------------------------
|  Function     :  ccddata_tap_get_pd
+------------------------------------------------------------------------------
|  Description  :  This function returns the protocol discriminator to a
|                  given entity number generated by ccdgen.
|
|  Parameters   :  comp - entity number.
|
|  Return       :  The protocol discriminator or the error condition
|                  TAP_PD_INVALID (= -1) if the entity is not known.
+------------------------------------------------------------------------------
*/
int ccddata_tap_get_pd (UCHAR comp)
{
  switch (comp)
  {
#ifdef CCDENT_XX_CSN1
    case CCDENT_XX_CSN1:
      return TAP_NOPD_MT;
#endif
#ifdef CCDENT_XX_TDC
    case CCDENT_XX_TDC:
      return TAP_NOPD_MT;
#endif
#ifdef CCDENT_RR_SHORT_PD
    case CCDENT_RR_SHORT_PD:
      return TAP_RR_SHORT;
#endif
#ifdef CCDENT_RR_SHORT
    case CCDENT_RR_SHORT:
      return TAP_RR_SHORT;
#endif
#ifdef CCDENT_UMTS_AS_ASN1_MSG
    case CCDENT_UMTS_AS_ASN1_MSG:
      return TAP_NOPD_NOMT;
#endif
#ifdef CCDENT_RRLP_ASN1_MSG
    case CCDENT_RRLP_ASN1_MSG:
      return TAP_NOPD_NOMT;
#endif
#ifdef CCDENT_ASN1_MSG
    case CCDENT_ASN1_MSG:
      return TAP_NOPD_MT;
#endif
#ifdef CCDENT_CLT
    case CCDENT_CLT:
      return TAP_NOPD_MT;
#endif
#ifdef CCDENT_CC
    case CCDENT_CC:
      return TAP_PD_CC;
#endif
#ifdef CCDENT_MM
    case CCDENT_MM:
      return TAP_PD_MM;
#endif
#ifdef CCDENT_GMM
    case CCDENT_GMM:
      return TAP_PD_GMM;
#endif
#ifdef CCDENT_SM
    case CCDENT_SM:
      return TAP_PD_SM;
#endif
#ifdef CCDENT_RR
    case CCDENT_RR:
      return TAP_PD_RR;
#endif
#ifdef CCDENT_SS
    case CCDENT_SS:
      return TAP_PD_SS;
#endif
#ifdef CCDENT_SMS
    case CCDENT_SMS:
      return TAP_PD_SMS;
#endif
#ifdef CCDENT_TST
    case CCDENT_TST:
      return TAP_PD_TST;
#endif
#ifdef CCDENT_XX
    case CCDENT_XX:
      return TAP_PD_XX;
#endif
#ifdef CCDENT_ABIS
    case CCDENT_ABIS:
      return TAP_PD_ABIS;
#endif
#ifdef CCDENT_GRR
    /* special treatment: no pd in GRR-messages */
    case CCDENT_GRR:
      return TAP_PD_OK;
#endif
    default:
      return TAP_PD_INVALID;
  }
}

/*
+------------------------------------------------------------------------------
|  Function     :  ccddata_tap_check_pd
+------------------------------------------------------------------------------
|  Description  :  This function checks if a protocol discriminator belongs to
|                  an entity number generated by ccdgen.
|
|  Parameters   :  comp - entity number.
|                  pd   - protocol discriminator.
|
|  Return       :  The protocol discriminator. The error condition
|                  TAP_PD_INVALID (= -1) is returned if the given comination
|                  does not match. It is not an error if the entity is not
|                  known.
+------------------------------------------------------------------------------
*/
int ccddata_tap_check_pd (UCHAR comp, UCHAR pd)
{
  switch (comp)
  {
#ifdef CCDENT_CC
    case CCDENT_CC:
      if (pd == TAP_PD_CC)
        return TAP_PD_CC;
      break;
#endif
#ifdef CCDENT_MM
    case CCDENT_MM:
      if (pd == TAP_PD_MM)
        return TAP_PD_MM;
      break;
#endif
#ifdef CCDENT_GMM
    case CCDENT_GMM:
      if (pd == TAP_PD_GMM)
        return TAP_PD_GMM;
      break;
#endif
#ifdef CCDENT_SM
    case CCDENT_SM:
      if (pd == TAP_PD_SM)
        return TAP_PD_SM;
      break;
#endif
#ifdef CCDENT_RR
    case CCDENT_RR:
      if (pd == TAP_PD_RR)
        return TAP_PD_RR;
      break;
#endif
#ifdef CCDENT_SS
    case CCDENT_SS:
      if (pd == TAP_PD_SS)
        return TAP_PD_SS;
      break;
#endif
#ifdef CCDENT_SMS
    case CCDENT_SMS:
      if (pd == TAP_PD_SMS)
        return TAP_PD_SMS;
      break;
#endif
#ifdef CCDENT_XX
    case CCDENT_XX:
      if (pd == TAP_PD_XX)
        return TAP_PD_XX;
      break;
#endif
    default:
      return pd;
  }
  return TAP_PD_INVALID;
}
