/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-F&D (8411)
|  Modul   :  CUS_ACI
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  Custom dependent definitions for AT Command Interpreter
|             Use this header for definitions to integrate the
|             ACI in your target system !
+----------------------------------------------------------------------------- 
*/ 

#ifndef CUS_ACI_H
#define CUS_ACI_H

/*==== CONSTANTS ==================================================*/
/*
 * TIMER_VALUES
 *
 * Description :  The constants define the timer values
 *                for the MMI timer TXXX depending on the various
 *                channel types and service access point identifiers.
 *                If your target system uses other units please
 *                change the values.
 */

/*
 * all values in milliseconds
 */
#define TICS_PER_DECIHOURS     (20*60*6*50)
#define TDTE_INACTIV_VALUE     500
#define TRING_VALUE            3000
//TISH, patch for OMAPS00129160
//start
//#define TMPTY_VALUE            10000        /* 10s (5 to 30 seconds) */
#define TMPTY_VALUE            30000        /* 30s (5 to 30 seconds) GSM 04.80*/
//end
#define TECT_VALUE             13500  /* 13,5s (5 to 15 seconds GSM 04.91 and 04.80) */
#define TDTMF_VALUE            3000         /*  3s wait time GSM 02.07 */

#ifdef VOCODER_FUNC_INTERFACE
#define VOCODER_VALUE          35
#endif

/* MAX_ACI_TIMER
 * Description :  The constant defines the number of
 *                timeouts which can be stored. */
#if defined FF_EOTD /*&& defined _SIMULATION_ */
#define MAX_ACI_TIMER 30
#else /*  no defined FF_EOTD */
#define MAX_ACI_TIMER 25
#endif
/*
 * VERSION
 *
 * Description :  The constants define the type and the value
 *                of a version identification. The version
 *                is part of the monitor struct.
 */

#ifndef SMI
#define T_VERSION   CHAR
#define VERSION_ACI  "ACI 1.0"
#endif

#ifdef SMI
#define T_VERSION   CHAR
#define VERSION_SMI  "SMI 1.0"
#endif

/*
 * VSI_CALLER
 *
 * Description :  For multithread applications the constant VSI_CALLER
 *                must be defined to identify the calling thread of the
 *                VSI-Interface. This must be done correponding to the
 *                type of T_VSI_CALLER in VSI.H. The comma symbol is
 *                neccessary because the vsi-functions are called
 *                like this vsi_xxx (VSI_CALLER par2, par3 ...)
 */

EXTERN T_HANDLE aci_handle;

#define VSI_CALLER aci_handle,
#define VSI_CALLER_SINGLE aci_handle

/*
 * It is a good idea to ensure that the following two definitions 
 * are not becoming longer than MAX_ALPHA_OPER_LEN.
 * Currently (21-May-2005) there is no long operator name known longer
 * than 25 characters and no short operator name known longer than 8
 * characters.
 * 27.007 limits the long operator names to 16 characters and 
 * the short operator names to 8 characters in the description
 * of the AT+COPS command, however there are a lot of operators
 * currently which exceed this limit for the long operator name.
 */
#define MAX_LONG_OPER_LEN     (25+1)  /* "Cable & Wireless Guernsey" + '\0' */
#define MAX_SHRT_OPER_LEN     (8+1)   /* short name + '\0' */ 

/*
 * Network operator list
 *
 * Description :  this is the list of all known network operators.
 *                There are five entries for each operator. A long
 *                name (max.24 chars), a short name (max.10 chars),
 *                the mobile country code, the mobile network code
 *                and a language reference. It is important to leave
 *                the EOL indicator at the end of the list to terminate
 *                the list.
 * Source :       The list depends on the GSM Association Infocentre - SE_13
 *                document
 * 
 */
typedef struct
{
    const char * longName;
    const char * shrtName;
    SHORT  mcc;
    SHORT  mnc;
} T_OPER_NTRY_FIXED;

/*
 * Beware, structure used from MFW directly by some "side access".
 */
typedef struct
{
    char longName[MAX_LONG_OPER_LEN];
    char shrtName[MAX_SHRT_OPER_LEN];
    SHORT  mcc;
    SHORT  mnc;
    UBYTE  pnn;          /* PLMN Network Name Source (for EONS) */
    UBYTE  long_len;     /* for EONS */
    UBYTE  long_ext_dcs;
    UBYTE  shrt_len;     /* for EONS */
    UBYTE  shrt_ext_dcs;
} T_OPER_ENTRY;

#ifdef TI_PS_OP_OPN_TAB_ROMBASED
    /* No definition for rom table is required as it is defined in xml file. */
#else 
#ifdef CMH_MMF_C

/*
 * Beware, data used from MFW directly by some "side access".
 */
const T_OPER_NTRY_FIXED operListFixed[] =
{
	{"GR COSMOTE","C-OTE", 0x202, 0x01f},
	{"vodafone GR","voda GR", 0x202, 0x05f},
	{"GR Q-TELECOM","Q-TELCOM", 0x202, 0x09f},
	{"Wind GR","Wind GR", 0x202, 0x10f},
	{"vodafone NL","voda NL", 0x204, 0x04f},
	{"NL KPN","NL KPN", 0x204, 0x08f},
	{"NL Telfort","NL Tlfrt", 0x204, 0x12f},
	{"T-Mobile NL","TMO NL", 0x204, 0x16f},
	{"Orange NL","Orange", 0x204, 0x20f},
	{"BEL PROXIMUS","PROXI", 0x206, 0x01f},
	{"B mobistar","mobi*", 0x206, 0x10f},
	{"BASE","BASE", 0x206, 0x20f},
	{"Orange F","Orange", 0x208, 0x01f},
	{"F - Contact","Contact", 0x208, 0x02f},
	{"F SFR","SFR", 0x208, 0x10f},
	{"F - Contact","Contact", 0x208, 0x13f},
	{"F - Contact","Contact", 0x208, 0x88f},		
	{"F-Bouygues Telecom","BYTEL", 0x208, 0x20f},
	{"Monaco","MONACO", 0x212, 0x10f},
	{"STA-MOBILAND","M-AND", 0x213, 0x03f},
	{"vodafone ES","voda ES", 0x214, 0x01f},
	{"Orange","Orange", 0x214, 0x03f},
	{"Yoigo","YOIGO", 0x214, 0x04f},
	{"movistar","movistar", 0x214, 0x07f},
	{"H pannon","pannon", 0x216, 0x01f},
	{"H pannon 3G","pannon3G", 0x216, 0x01f},
	{"T-Mobile H","TMO H", 0x216, 0x30f},
	{"vodafone HU","voda HU", 0x216, 0x70f},
	{"BA-ERONET","ERONET", 0x218, 0x03f},
	{"MOBI'S","MOBI'S", 0x218, 0x05f},
	{"BH GSMBIH","GSMBIH", 0x218, 0x90f},
	{"T-Mobile HR","T-Mobile", 0x219, 0x01f},
	{"HR TELE2, HR 21902","TELE2", 0x219, 0x02f},
	{"HR VIP","VIP", 0x219, 0x10f},
	{"Telenor","Telenor", 0x220, 0x01f},
	{"ProMonte","ProMonte", 0x220, 0x02f},
	{"YUG 03","SCGTS", 0x220, 0x03f},
	{"T-Mobile","TMO CG", 0x220, 0x04f},
	{"Novi Operater","Novi Operater", 0x220, 0x05f},
	{"I TIM","TIM", 0x222, 0x01f},
	{"vodafone IT","voda IT", 0x222, 0x10f},
	{"I WIND","I WIND", 0x222, 0x88f},
	{"3 ITA","3 ITA", 0x222, 0x99f},
	{"Vodafone RO","VF-RO", 0x226, 0x01f},
	{"RO COSMOTE","COSMOTE", 0x226, 0x03f},
	{"RO ORANGE","ORANGE", 0x226, 0x10f},
	{"Swisscom","SWISS", 0x228, 0x01f},
	{"sunrise","sunrise", 0x228, 0x02f},
	{"orange CH","ORANGE", 0x228, 0x03f},
	{"In&Phone","In&Phone", 0x228, 0x07f},
	{"CHE, Tele2 Switzerland","T2", 0x228, 0x08f},
	{"T-Mobile CZ","TMO CZ", 0x230, 0x01f},
	{"EUROTEL - CZ","ET - CZ", 0x230, 0x02f},
	{"Vodafone CZ","Vodafone", 0x230, 0x03f},
	{"Orange SK","Orange", 0x231, 0x01f},
	{"T-Mobile SK","TMO SK", 0x231, 0x02f},
	{"O2 - SK","O2 - SK", 0x231, 0x06f},
	{"A1","A1", 0x232, 0x01f},
	{"T-Mobile Austria","TMA", 0x232, 0x03f},
	{"one","one", 0x232, 0x05f},
	{"tele - ring","telering", 0x232, 0x07f},
	{"3 AT","3 AT", 0x232, 0x10f},
	{"one","one", 0x232, 0x12f},
	{"Manx Telecom Mobile","MANX", 0x232, 0x58f},
	{"PMN UK","PMN", 0x234, 0x01f},	
	{"Airtel-Vodafone","ATL-VOD", 0x234, 0x03f},
	{"PMN UK","PMN", 0x234, 0x09f},	
	{"O2 - UK","O2 -UK", 0x234, 0x10f},
	{"vodafone UK","voda UK", 0x234, 0x15f},
	{"Opal UK","Opal UK", 0x234, 0x16f},	
	{"T-Mobile UK","TMO UK", 0x234, 0x30f},
	{"T-Mobile UK","TMO UK", 0x234, 0x31f},
	{"T-Mobile UK","TMO UK", 0x234, 0x32f},
	{"Orange","Orange", 0x234, 0x33f},
	{"JT-Wave","JT-Wave", 0x234, 0x50f},
	{"C&W Isle of Man Ltd.	","C&W", 0x234, 0x55f},
	{"Manx Pronto","Pronto", 0x234, 0x58f},
	{"TDC MOBIL","DK TDC", 0x238, 0x01f},
	{"Sonofon","Sonofon", 0x238, 0x02f},
	{"3 DK","3 DK", 0x238, 0x06f},
	{"TELIA DK","TELIA", 0x238, 0x20f},
	{"Sonofon","Sonofon", 0x238, 0x77f},	
	{"TELIA S","TELIA", 0x240, 0x01f},
	{"3 SE","3 SE", 0x240, 0x02f},
	{"SWEDEN","SWE", 0x240, 0x04f},
	{"Sweden 3G","Sweden3G", 0x240, 0x05f},
	{"Telenor SE","TelenorS", 0x240, 0x08f},
	{"SpringMobil SE","Spring", 0x240, 0x10f},
	{"S COMVIQ","IQ", 0x240, 0x10f},
	{"N Telenor","TELENOR", 0x242, 0x01f},
	{"N NetCom","NetCom", 0x242, 0x02f},
	{"Teletopia 3","T3", 0x242, 0x03f},
	{"Network Norway N","NetworkN", 0x242, 0x05f},
	{"dna","dna", 0x244, 0x03f},
	{"FI elisa","elisa", 0x244, 0x05f},
	{"dna","dna", 0x244, 0x12f},
	{"FI AMT","FI AMT", 0x244, 0x14f},
	{"FI SONERA","SONERA", 0x244, 0x91f},
	{"OMNITEL LT","OMT", 0x246, 0x01f},
	{"LT BITE GSM","BITE", 0x246, 0x02f},
	{"TELE2","TELE2", 0x246, 0x03f},
	{"LV LMT","LMT", 0x247, 0x01f},
	{"LV LMT GSM, LV LMT","LMT GSM", 0x247, 0x01f},
	{"LV TELE2","TELE2", 0x247, 0x02f},
	{"BITE LV","BITE LV", 0x247, 0x05f},
	{"EE EMT","EMT", 0x248, 0x01f},
	{"EE elisa","elisa", 0x248, 0x02f},
	{"TELE2","TELE2", 0x248, 0x03f},
	{"MTS-RUS","MTS", 0x250, 0x01f},
	{"MegaFon RUS","MegaFon", 0x250, 0x02f},
	{"MegaFon","MegaFon", 0x250, 0x02f},
	{"SIBCHALLENGE RUS","RUS_SCN", 0x250, 0x04f},
	{"SCS, RUS 05, RUS SCS, RUS","STC", 0x250, 0x05f},
	{"SCS RUS","SCS", 0x250, 0x05f},
	{"ETK RUS","ETK", 0x250, 0x05f},
	{"RUS BMT","BMT", 0x250, 0x07f},
	{"RUS 07, RUS SMARTS","SMARTS", 0x250, 0x07f},
	{"RUS DTC","DTC", 0x250, 0x10f},
	{"RUS 12","AKOS GSM", 0x250, 0x12f},
	{"Far East, RUS 12, 250 12","BWC", 0x250, 0x12f},
	{"RUS - Sakhalin","SAKHALIN", 0x250, 0x12f},
	{"RF FAR EAST","RF FEast", 0x250, 0x12f},
	{"SIBI-RUS","SIBI", 0x250, 0x12f},
	{"RUS Kuban-GSM","KUGSM", 0x250, 0x13f},
	{"RUS15, RUS SMARTS","SMARTS", 0x250, 0x15f},
	{"RUS16,250 16","NTC", 0x250, 0x16f},
	{"Utel","Utel", 0x250, 0x17f},
	{"RUS: INDIGO","INDIGO", 0x250, 0x19f},
	{"RUS INDIGO","INDIGO", 0x250, 0x19f},
	{"TELE2","TELE2", 0x250, 0x20f},
	{"RUSSIA VOTEK MOBILE","VOTEK", 0x250, 0x20f},
	{"MOTIV","MOTIV", 0x250, 0x20f},
	{"RUS Beeline","Beeline", 0x250, 0x28f},
	{"MOTIV","MOTIV", 0x250, 0x35f},
	{"Utel","Utel", 0x250, 0x39f},
	{"Uraltel","Uraltel", 0x250, 0x39f},
	{"Primetelefone RUS","Primtel", 0x250, 0x92f},
	{"Beeline","Beeline", 0x250, 0x99f},
	{"UA UMC","UMC", 0x255, 0x01f},
	{"Beeline UA","Beeline", 0x255, 0x02f},
	{"UA-KYIVSTAR","UA-KS", 0x255, 0x03f},
	{"UA-GT","GT", 0x255, 0x05f},
	{"life:)","life:)", 0x255, 0x06f},
	{"BY VELCOM","VELCOM", 0x257, 0x01f},
	{"MTS BY","MTS", 0x257, 0x02f},
	{"BeST BY","BeST", 0x257, 0x04f},
	{"Orange MD","Orange", 0x259, 0x01f},
	{"MD MOLDCELL","MDCELL", 0x259, 0x02f},
	{"Eventis Mobile S.R.L.","EVENTIS", 0x259, 0x04f},
	{"Plus","PLUS", 0x260, 0x01f},
	{"Era","Era", 0x260, 0x02f},
	{"Orange PL","Orange", 0x260, 0x03f},
	{"POL","Play", 0x260, 0x06f},	
	{"T-Mobile D","TMO D", 0x262, 0x01f},
	{"Vodafone.de","Vodafone.de", 0x262, 0x02f},
	{"E-Plus","E-Plus", 0x262, 0x03f},
	{"o2 - de","o2 - de", 0x262, 0x07f},
	{"o2 - de","o2 - de", 0x262, 0x08f},
	{"GIBTEL GSM","GIBTEL", 0x266, 0x01f},
	{"vodafone P","voda P", 0x268, 0x01f},
	{"P OPTIMUS","OPTIM", 0x268, 0x03f},
	{"P TMN","TMN", 0x268, 0x06f},
	{"L LUXGSM","LUXGSM", 0x270, 0x01f},
	{"L TANGO","TANGO", 0x270, 0x77f},
	{"L VOX.LU","VOX.LU", 0x270, 0x99f},
	{"vodafone IE","voda IE", 0x272, 0x01f},
	{"O2 IRL","02 -IRL", 0x272, 0x02f},
	{"IRL - METEOR","METEOR", 0x272, 0x03f},
	{"3 IRL","3 IRL", 0x272, 0x05f},
	{"Sminn","Sminn", 0x274, 0x01f},
	{"Vodafone","Vodafone", 0x274, 0x02f},
	{"Og Vodafone","Vodafone", 0x274, 0x03f},
	{"Viking","Viking", 0x274, 0x04f},
	{"IS-IceCell","IceCell", 0x274, 0x07f},
	{"NOVA IS","NOVA", 0x274, 0x11f},
	{"AMC - AL","A M C", 0x276, 0x01f},
	{"vodafone AL","voda AL", 0x276, 0x02f},
	{"vodafone MT","voda MT", 0x278, 0x01f},
	{"go mobile","gomobile", 0x278, 0x21f},
	{"CYTAMOBILE-VODAFONE","CYTAVODA", 0x280, 0x01f},
	{"areeba","areeba", 0x280, 0x10f},
	{"GEO-GEOCELL","GCELL", 0x282, 0x01f},
	{"MAGTI-GSM-GEO","MAGTI", 0x282, 0x02f},
	{"BEELINE GE","BEELINE", 0x282, 0x04f},
	{"ARMGSM","Beeline", 0x283, 0x01f},
	{"RA 05","RA 05", 0x283, 0x05f},
	{"M-Tel BG","M-Tel", 0x284, 0x01f},
	{"vivatel","vivatel", 0x284, 0x03f},
	{"BG GLOBUL","GLOBUL", 0x284, 0x05f},
	{"TR TURKCELL","TCELL", 0x286, 0x01f},
	{"Vodafone Turkey","VF TR", 0x286, 0x02f},
	{"AVEA","AVEA", 0x286, 0x03f},
	{"Føroya Tele","FT-GSM", 0x288, 0x01f},//names? - corrected
	{"KALL","KALL", 0x288, 0x02f},
	{"TELE Greenland","TELE GRL", 0x290, 0x01f},
	{"SMT","SMT", 0x292, 0x66f},
	{"SI vodafone","SI voda", 0x293, 0x40f},
	{"MOBITEL","MOBITEL", 0x293, 0x41f},
	{"T-2","T-2", 0x293, 0x64f},	
	{"Tusmobil","TUS", 0x293, 0x70f},
	{"T-Mobile MK","TMO MK", 0x294, 0x01f},
	{"MKD COSMOFON","COSMOFON", 0x294, 0x2f},
	{"Vip MKD","Vip MKD", 0x294, 0x03f},
	{"Mobitel","Mobitel", 0x294, 0x31f},
	{"SwisscomFL","Swiss FL", 0x295, 0x01f},
	{"Orange FL","OFL", 0x295, 0x02f},
	{"FL1","FL1", 0x295, 0x05f},
	{"LI TANGO","TANGO", 0x295, 0x77f},
	{"Fido","Fido", 0x302, 0x370},
	{"CAN Rogers Wireless Inc.","ROGERS", 0x302, 0x720},
	{"SPM AMERIS","AMERIS", 0x308, 0x01f},
	{"SPM-PROSODIE","PROSOD", 0x308, 0x02f},
	{"US - Union Telephone","UnionTel", 0x310, 0x020},
	{"T-Mobile","TMO", 0x310, 0x26f},
	{"Centennial Communications","CENT USA", 0x310, 0x30},
	{"T-Mobile","TMO", 0x310, 0x031},
	{"IT&E","IT&E", 0x310, 0x032},
	{"USATX","CONCHO", 0x310, 0x040},
	{"USA SIMMETRY","SIMMETRY", 0x310, 0x46f},
	{"Corr","Corr", 0x310, 0x080},
	{"Edge Wireless","Edge", 0x310, 0x090},
	{"US PLATEAU","PLATEAU", 0x310, 0x100},
	{"AT&T","AT&T", 0x310, 0x150},
	{"T-Mobile","TMO", 0x310, 0x160},
	{"AT&T","AT&T", 0x310, 0x170},
	{"AT&T","AT&T", 0x310, 0x180},
	{"USA Dutch Harbor","D-HARBOR", 0x310, 0x190},
	{"T-Mobile","TMO", 0x310, 0x200},
	{"T-Mobile","TMO", 0x310, 0x210},
	{"T-Mobile","TMO", 0x310, 0x220},
	{"T-Mobile","TMO", 0x310, 0x230},
	{"T-Mobile","TMO", 0x310, 0x240},
	{"T-Mobile","TMO", 0x310, 0x250},
	{"T-Mobile","TMO", 0x310, 0x260},
	{"T-Mobile","TMO", 0x310, 0x270},
	{"USA - CellularOne","Cell", 0x310, 0x320},
	{"USA 340","WestLink", 0x310, 0x340},
	{"AT&T","AT&T", 0x310, 0x380},
	{"Cell1ET","CELL 1 ET", 0x310, 0x390},
	{"USA i CAN","iCAN_GSM", 0x310, 0x400},
	{"AT&T","AT&T", 0x310, 0x410},
	{"Cell One of NE Colorado","NECCI", 0x310, 0x450},
	{"USA-WVA WIRELESS","W V W", 0x310, 0x530},
	{"Cellular One DCS","Cell One", 0x310, 0x560},
	{"Chinook","Chinook", 0x310, 0x570},
	{"USA - Extended Area","ROAMING", 0x310, 0x590},
	{"USA AmeriLink","AMERLINK", 0x310, 0x630},
	{"USA AE Airadigm","ARDGMC", 0x310, 0x640},
	{"Jasper","Jasper", 0x310, 0x650},
	{"T-Mobile","TMO", 0x310, 0x660},
	{"USA - Immix Wireless","IMMIX", 0x310, 0x690},
	{"USABIGFOOT","BIGFOOT", 0x310, 0x700},
	{"USA ASTAC","ASTAC", 0x310, 0x710},
	{"TELEMETRIX","TLXT", 0x310, 0x740},
	{"Iowa Wireless USA","IWS", 0x310, 0x770},
	{"USA Pinpoint","Pinpoint", 0x310, 0x790},
	{"US","PACE", 0x310, 0x870},
	{"USAACSI","ACSIAC", 0x310, 0x880},
	{"USA Unicel","UNICEL", 0x310, 0x890},
	{"Texas Cellular","TXCELL", 0x310, 0x900},
	{"USAFC","FCSI", 0x310, 0x910},
	{"USA XIT Wireless","XIT", 0x310, 0x950},
	{"AT&T","AT&T", 0x310, 0x980},
	{"USA Mid-Tex Cellular, Ltd","Mid-Tex", 0x311, 0x00f},
	{"Wilkes USA","WILKES", 0x311, 0x00f},
	{"Wilkes USA","WILKES", 0x311, 0x01f},
	{"Wilkes USA","WILKES", 0x311, 0x05f},
	{"Indigo","Indigo", 0x311, 0x30f},
	{"USA - Commnet","Commnet", 0x311, 0x40f},
	{"USAEC","EASTER", 0x311, 0x70f},
	{"Pine Cellular","PINECell", 0x311, 0x80f},
	{"USASXLP","SXLP", 0x311, 0x90f},
	{"High Plains","HPW", 0x311, 0x110},
	{"Cell One Amarillo","C1AMARIL", 0x311, 0x130},
	{"PetroCom","PetroCom", 0x311, 0x170},
	{"AT&T","AT&T", 0x311, 0x180},	
	{"USAC1ECI","C1ECI", 0x311, 0x190},
	{"FARMERS","FARMERS", 0x311, 0x210},
	{"USACWCI","CWCI", 0x311, 0x240},
	{"USA i CAN","iCAN_GSM", 0x311, 0x250},
	{"Lamar Cellular","LamarCel", 0x311, 0x310},
	{"GCI","GCI", 0x310, 0x370},
	{"movistar","mstar", 0x334, 0x03f},
	{"TELCEL GSM","TELCL", 0x334, 0x020},
	{"DIGICEL","DIGICEL", 0x338, 0x5f},
	{"DIGICEL","DIGICEL", 0x338, 0x050},
	{"bmobile","bmobile", 0x338, 0x180},
	{"Orange C","Orange", 0x340, 0x01f},
	{"ONLY","ONLY", 0x340, 0x02f},
	{"AMIGO","AMIGO", 0x340, 0x08f},
	{"DIGICEL","DigicelF", 0x340, 0x20f},
	{"bmobile","bmobile", 0x342, 0x600},
	{"DIGICEL","DIGICEL", 0x342, 0x750},
	{"APUA PCS ANTIGUA","APUA-PCS", 0x344, 0x030},
	{"bmobile","bmobile", 0x344, 0x920},
	{"AT&T","AT&T", 0x344, 0x930},
	{"bmobile","bmobile", 0x346, 0x140},
	{"bmobile","bmobile", 0x348, 0x170},
	{"CCT Boatphone","CCTBVI", 0x348, 0x570},
	{"BTC MOBILITY LTD.","MOBILITY", 0x350, 0x02f},
	{"AT&T","AT&T", 0x350, 0x010},
	{"DIGICEL","DIGICEL", 0x352, 0x030},
	{"bmobile","bmobile", 0x352, 0x110},
	{"bmobile","bmobile", 0x354, 0x860},
	{"bmobile","bmobile", 0x356, 0x110},
	{"DIGICEL","DIGICEL", 0x358, 0x050},
	{"bmobile","bmobile", 0x358, 0x110},
	{"DIGICEL","DIGICEL", 0x360, 0x070},
	{"bmobile","bmobile", 0x360, 0x110},
	{"Telcell GSM","Telcell", 0x362, 0x51f},
	{"DIGICEL","DIGICEL", 0x362, 0x69f},
	{"ANT","CHIPPIE", 0x362, 0x951},
	{"SETAR GSM","SETARGSM", 0x363, 0x01f},
	{"SETAR GSM","SETARGSM", 0x363, 0x01f},
	{"DIGICEL","DIGICEL", 0x363, 0x020},
	{"BaTelCell","BaTelCel", 0x364, 0x39f},
	{"bmobile","bmobile", 0x365, 0x840},
	{"AT&T","AT&T", 0x366, 0x020},
	{"bmobile","bmobile", 0x366, 0x110},
	{"CUBACEL","CUBACEL", 0x368, 0x01f},
	{"Orange","Orange", 0x370, 0x01f},
	{"Claro DOM","ClaroDOM", 0x370, 0x02f},
	{"COMCEL","VOILA", 0x372, 0x01f},
	{"DIGICEL","DIGICEL", 0x372, 0x020},
	{"TSTT","TSTT", 0x374, 0x12f},
	{"DIGICEL","DIGICEL", 0x374, 0x130},
	{"bmobile","bmobile", 0x376, 0x350},
	{"AZE - AZERCELL GSM","ACELL", 0x400, 0x01f},
	{"BAKCELL GSM 2000","BKCELL", 0x400, 0x02f},
	{"AZ Nar","Nar", 0x400, 0x04f},
	{"Beeline KZ","Beeline", 0x401, 0x01f},
	{"KZ KCELL","KCELL", 0x401, 0x02f},
	{"NEO-KZ","NEO", 0x401, 0x77f},
	{"BT B-Mobile","B-Mobile", 0x402, 0x11f},
	{"TASHICELL","TASHICELL", 0x402, 0x77f},	
	{"Vodafone IN","Vodafone", 0x404, 0x01f},
	{"AirTel","AirTel", 0x404, 0x02f},
	{"AirTel","AirTel", 0x404, 0x03f},
	{"IDEA","IDEA", 0x404, 0x04f},
	{"Vodafone IN","Vodafone", 0x404, 0x05f},
	{"IDEA","IDEA", 0x404, 0x07f},
	{"AirTel","AirTel", 0x404, 0x10f},
	{"Vodafone IN","Vodafone", 0x404, 0x11f},
	{"IDEA","IDEA", 0x404, 0x12f},
	{"Vodafone IN","Vodafone", 0x404, 0x13f},
	{"INA SPICE","SPICE", 0x404, 0x14f},
	{"Vodafone IN","Vodafone", 0x404, 0x15f},
	{"AIRCEL","AIRCEL", 0x404, 0x17f},
	{"IDEA","IDEA", 0x404, 0x19f},
	{"Vodafone IN","Vodafone", 0x404, 0x20f},
	{"BPL MOBILE","BPL MOBILE", 0x404, 0x21f},
	{"IDEA","IDEA", 0x404, 0x22f},
	{"IDEA","IDEA", 0x404, 0x24f},
	{"AIRCEL","AIRCEL", 0x404, 0x25f},
	{"Vodafone IN","Vodafone", 0x404, 0x27f},
	{"AIRCEL","AIRCEL", 0x404, 0x28f},
	{"Vodafone IN","Vodafone", 0x404, 0x30f},	
	{"AIRCEL","AIRCEL", 0x404, 0x29f},
	{"Vodafone IN","Vodafone", 0x404, 0x30f},
	{"Vodafone IN","Vodafone", 0x404, 0x030},
	{"AirTel","AirTel", 0x404, 0x31f},
	{"AIRCEL","AIRCEL", 0x404, 0x33f},
	{"CellOne","CellOne", 0x404, 0x34f},
	{"AIRCEL","AIRCEL", 0x404, 0x35f},
	{"AIRCEL","AIRCEL", 0x404, 0x37f},
	{"CellOne","CellOne", 0x404, 0x38f},
	{"IND AIRTEL","AIRTEL", 0x404, 0x40f},
	{"AIRCEL","AIRCEL", 0x404, 0x41f},
	{"AIRCEL","AIRCEL", 0x404, 0x42f},
	{"Vodafone IN","Vodafone", 0x404, 0x43f},	
	{"INA SPICE","SPICE", 0x404, 0x44f},
	{"AirTel","AirTel", 0x404, 0x45f},
	{"Vodafone IN","Vodafone", 0x404, 0x46f},	
	{"AirTel","AirTel", 0x404, 0x49f},
	{"CellOne","CellOne", 0x404, 0x51f},
	{"CellOne","CellOne", 0x404, 0x53f},
	{"CellOne","CellOne", 0x404, 0x54f},
	{"CellOne","CellOne", 0x404, 0x55f},
	{"IDEA","IDEA", 0x404, 0x56f},
	{"CellOne","CellOne", 0x404, 0x57f},
	{"CellOne","CellOne", 0x404, 0x58f},
	{"CellOne","CellOne", 0x404, 0x59f},
	{"Vodafone IN","Vodafone", 0x404, 0x60f},
	{"CellOne","CellOne", 0x404, 0x62f},
	{"CellOne","CellOne", 0x404, 0x64f},
	{"CellOne","CellOne", 0x404, 0x66f},
	{"IN-DOLPHIN","DOLPHIN", 0x404, 0x68f},
	{"IN-DOLPHIN","DOLPHIN", 0x404, 0x69f},
	{"INDH1","Oasis", 0x404, 0x70f},
	{"CellOne","CellOne", 0x404, 0x71f},
	{"CellOne","CellOne", 0x404, 0x72f},
	{"CellOne","CellOne", 0x404, 0x73f},
	{"CellOne","CellOne", 0x404, 0x74f},
	{"CellOne","CellOne", 0x404, 0x75f},
	{"CellOne","CellOne", 0x404, 0x76f},
	{"CellOne","CellOne", 0x404, 0x77f},
	{"IDEA","IDEA", 0x404, 0x78f},
	{"CellOne","CellOne", 0x404, 0x79f},
	{"CellOne","CellOne", 0x404, 0x80f},
	{"CellOne","CellOne", 0x404, 0x81f},
	{"IDEA","IDEA", 0x404, 0x82f},
	{"Vodafone IN","Vodafone", 0x404, 0x84f},
	{"Vodafone IN","Vodafone", 0x404, 0x86f},
	{"IDEA","IDEA", 0x404, 0x87f},
	{"Vodafone IN","Vodafone", 0x404, 0x88f},
	{"IDEA","IDEA", 0x404, 0x89f},
	{"AirTel","AirTel", 0x404, 0x90f},
	{"IND, INA91","Aircel", 0x404, 0x91f},	
	{"AirTel","AirTel", 0x404, 0x92f},
	{"AirTel","AirTel", 0x404, 0x93f},
	{"AirTel","AirTel", 0x404, 0x94f},
	{"AirTel","AirTel", 0x404, 0x95f},
	{"AirTel","AirTel", 0x404, 0x96f},
	{"AirTel","AirTel", 0x404, 0x97f},
	{"AirTel","AirTel", 0x404, 0x98f},
	{"Reliance","RELIANCE", 0x405, 0x50f},
	{"IND AirTel","AIRTEL", 0x405, 0x51f},
	{"IND AirTel","AIRTEL", 0x405, 0x52f},
	{"IND AirTel","AIRTEL", 0x405, 0x53f},
	{"IND AirTel","AIRTEL", 0x405, 0x54f},
	{"IND AirTel","AIRTEL", 0x405, 0x55f},
	{"IND Airtel","Airtel", 0x405, 0x56f},
	{"Vodafone IN","Vodafone", 0x405, 0x66f},
	{"Vodafone IN","Vodafone", 0x405, 0x67f},
	{"Mobilink","Mobilink", 0x410, 0x1f},
	{"PK-UFONE","UFONE", 0x410, 0x03f},
	{"PAK - PL","PAKTEL", 0x410, 0x04f},
	{"Telenor PK","TELENOR", 0x410, 0x06f},
	{"WaridTel","WaridTel", 0x410, 0x07f},
	{"AF AWCC","AWCC", 0x412, 0x01f},
	{"ROSHAN","ROSHAN", 0x412, 0x20f},
	{"AREEBA","AREEBA", 0x412, 0x40f},
	{"Etisalat Af","Etisalat", 0x412, 0x50f},
	{"Mobitel","MOBITEL", 0x413, 0x01f},
	{"SRI DIALOG","DIALOG", 0x413, 0x02f},
	{"SRI - Tigo","Tigo", 0x413, 0x03f},
	{"Hutch","Hutch", 0x413, 0x08f},
	{"MM 900","MPTGSM", 0x414, 0x01f},
	{"alfa","alfa", 0x415, 0x01f},
	{"RL MTC Lebanon","MTC LIBAN", 0x415, 0x03f},
	{"zain JO","zain JO", 0x416, 0x01f},
	{"UMNIAH","UMNIAH", 0x416, 0x03f},
	{"Orange JO","Orange JO", 0x416, 0x77f},
	{"SYRIATEL","SYRIATEL", 0x417, 0x01f},
	{"MTN","MTN", 0x417, 0x02f},
	{"SYR MOBILE SYR","MOBILE", 0x417, 0x09f},
	{"ASIACELL","ASIACELL", 0x418, 0x0f},
	{"SanaTel","SanaTel", 0x418, 0x02f},
	{"ASIACELL","ASIACELL", 0x418, 0x05f},
	{"SanaTel","SanaTel", 0x418, 0x08f},
	{"zain IQ","zain IQ", 0x418, 0x20f},
	{"IRAQNA","IRAQNA", 0x418, 0x30f},
	{"Zain KW","zain KW", 0x419, 0x02f},
	{"KT WATANIYA","WATANIYA", 0x419, 0x03f},
	{"ALJAWAL","KSA", 0x420, 0x01f},
	{"mobily-KSA","mobily", 0x420, 0x003},
	{"SabaFon","SABAFON", 0x421, 0x01f},
	{"MTN","MTN", 0x421, 0x02f},
	{"OMAN MOBILE","OMAN", 0x422, 0x02f},
	{"nawras","nawras", 0x422, 0x03f},
	{"ETISALAT","ETISALAT", 0x424, 0x02f},
	{"du","du", 0x424, 0x03f},
	{"IL ORANGE","ORANGE", 0x425, 0x01f},
	{"IL Cellcom","Cellcom", 0x425, 0x02f},
	{"IL Pelephone","PCL", 0x425, 0x03f},
	{"JAWWAL-PALESTINE","JAWWAL", 0x425, 0x05f},
	{"BATELCO","BATELCO", 0x426, 0x01f},
	{"zain BH","zain BH", 0x426, 0x02f},
	{"MTC Vodafone BH","MTC-VFBH", 0x426, 0x02f},
	{"Qat - Qtel","Qtel", 0x427, 0x01f},
	{"MONGOLIA UNITEL LLC","UNTLMN", 0x428, 0x88f},
	{"MN MobiCom","MobiCom", 0x428, 0x99f},
	{"IR-TCI","432 11", 0x432, 0x11f},
	{"IR KISH","KIFZO", 0x432, 0x14f},
	{"IR MTCE","MTCE", 0x432, 0x19f},
	{"Iran Taliya","Taliya", 0x432, 0x32f},
	{"Beeline UZ","Beeline", 0x434, 0x4f},
	{"UZB CSOCOM GSM","COSCOM", 0x434, 0x05f},
	{"UZB MTS","UZB MTS", 0x434, 0x07f},
	{"Somoncom","Somoncom", 0x436, 0x01f},
	{"INDIGO-T","INDIGO-T", 0x436, 0x02f},
	{"TJK MLT","MLT", 0x436, 0x3f},
	{"Babilon-M","Babilon", 0x436, 0x04f},
	{"BEELINE TJ","BEELINE", 0x436, 0x05f},
	{"INDIGO-3G","INDIGO-T", 0x436, 0x12f},
	{"BITEL KGZ","BITEL", 0x437, 0x01f},
	{"MEGACOM","MEGACOM", 0x437, 0x05f},
	{"JPN EMOBILE","EMOBILE", 0x440, 0x00f},
	{"JP DoCoMo","DoCoMo", 0x440, 0x10f},
	{"SoftBank","SoftBank", 0x440, 0x20f},
	{"KR KTF","KTF", 0x450, 0x02f},
	{"KOR SK Telecom","SKT", 0x450, 0x05f},
	{"KR KTF","KTF", 0x450, 0x08f},
	{"VN MOBIFONE","VMS", 0x452, 0x01f},
	{"VN VINAPHONE","GPC", 0x452, 0x02f},
	{"VNM and VIETTEL","VIETTEL", 0x452, 0x04f},
	{"HK CSL","CSL", 0x454, 0x00f},
	{"HK CSL","CSL", 0x454, 0x02f},
	{"3 HK","3 HK", 0x454, 0x03f},
	{"3(2G)","3(2G)", 0x454, 0x04f},
	{"SmarToneVodafone","SMC-Voda", 0x454, 0x06f},
	{"HK NEW WORLD","NWPCS", 0x454, 0x10f},
	{"CMCC PEOPLES","PEOPLES", 0x454, 0x12f},
	{"454-15","454-15", 0x454, 0x15f},
	{"PCCW","PCCW", 0x454, 0x16f},
	{"HK CSL","CSL", 0x454, 0x18f},
	{"PCCW","PCCW", 0x454, 0x19f},
	{"SmarTone Macau","SmarTone", 0x455, 0x00f},
	{"CTM","CTM", 0x455, 0x01f},
	{"Hutchison MAC","HT Macau", 0x455, 0x03f},
	{"3 Macau","3 Macau", 0x455, 0x05f},
	{"MOBITEL - KHM","MT-KHM", 0x456, 0x01f},
	{"KHM-Hello GSM","KHM-SM", 0x456, 0x02f},
	{"CADCOMMS","CADCOMMS", 0x456, 0x04f},	
	{"STAR CELL","STARCELL", 0x456, 0x05f},
	{"CAMBODIA SHINAWATRA","CAMSHIN", 0x456, 0x18f},
	{"LAO GSM","LAO GSM", 0x457, 0x01f},
	{"ETL MOBILE NETWORK","ETLMNW", 0x457, 0x02f},
	{"45703","LATMOBIL", 0x457, 0x03f},
	{"TIGO LAO","TIGO", 0x457, 0x08f},
	{"CHINA  MOBILE","CMCC", 0x460, 0x00f},
	{"CHN-CUGSM","CU-GSM", 0x460, 0x01f},
	{"Far EasTone","FET", 0x466, 0x01f},
	{"ACeS","ACeS", 0x466, 0x68f},
	{"KGT-Online","KGT", 0x466, 0x88f},
	{"VIBO","VIBO", 0x466, 0x89f},
	{"Chunghwa Telecom","CHT", 0x466, 0x92f},
	{"TWN MOBITAI","TW MOB", 0x466, 0x93f},
	{"TW Mobile","TWM", 0x466, 0x97f},
	{"TWN TransAsia Telecom GSM","TA-GSM", 0x466, 0x99f},
	{"TransAsia","TransAsi", 0x466, 0x99f},
	{"KP SUN","SUNNET", 0x467, 0x03f},
	{"GrameenPhone","GRAMEEN", 0x470, 0x01f},
	{"BGD AKTEL","AKTEL", 0x470, 0x02f},
	{"Banglalink","Banglalink", 0x470, 0x03f},
	{"BGD bMobile","bMobile", 0x470, 0x04f},
	{"WARID BD","WARID BD", 0x470, 0x07f},	
	{"MV DHIMOBILE","D-MOBILE", 0x472, 0x01f},
	{"WATANIYA","WATANIYA", 0x472, 0x02f},
	{"TT dotCom Sdn Bhd 52371-A","TIME3G", 0x502, 0x01f},
	{"MY MAXIS","MY MAXIS", 0x502, 0x12f},
	{"MY CELCOM 3G","CELCOM", 0x502, 0x13f},
	{"DiGi","DiGi", 0x502, 0x16f},
	{"U Mobile","U Mobile", 0x502, 0x18f},
	{"MY CELCOM","CELCOM", 0x502, 0x19f},
	{"Telstra Mobile","Telstra", 0x505, 0x01f},
	{"YES OPTUS","Optus", 0x505, 0x02f},
	{"vodafone AU","voda AU", 0x505, 0x03f},
	{"3TELSTRA","3TELSTRA", 0x505, 0x06f},
	{"ACeS","ACeS", 0x510, 0x00f},
	{"IND INDOSATT","INDOSAT", 0x510, 0x01f},
	{"axis","axis", 0x510, 0x08f},
	{"IND TELKOMSEL","T-SEL", 0x510, 0x10f},
	{"IND XL","XL", 0x510, 0x11f},
	{"IND INDOSAT","INDOSAT", 0x510, 0x21f},
	{"3","3", 0x510, 0x89f},
	{"3","3", 0x510, 0x89f},
	{"TLS-TT","TT", 0x514, 0x02f},
	{"ISLACOM","ISLACOM", 0x515, 0x01f},
	{"Globe Telecom-PH","GLOBE", 0x515, 0x02f},
	{"SMART","SMART", 0x515, 0x03f},
	{"PH Sun Cellular","SUN", 0x515, 0x05f},
	{"ACeS","ACeS", 0x515, 0x11f},
	{"CURE","CURE", 0x515, 0x18f},
	{"TH GSM","TH GSM", 0x520, 0x01f},
	{"TH ACT 1900","ACT-1900", 0x520, 0x15f},
	{"CURE","CURE", 0x520, 0x18f},
	{"ACeS","ACeS", 0x520, 0x20f},
	{"TH GSM 1800","GSM 1800", 0x520, 0x23f},
	{"TRUE","TRUE", 0x520, 0x99f},
	{"SingTel","SingTel", 0x525, 0x01f},
	{"SingTel-G18","SingTel", 0x525, 0x02f},
	{"SGP-M1-3GSM","M1-3GSM", 0x525, 0x03f},
	{"STARHUB-SGP","STARHUB", 0x525, 0x05f},
	{"STARHUB","STARHUB", 0x525, 0x05f},
	{"BRU-bmobile","b-mobile", 0x528, 0x02f},
	{"BRU-DSTCom","DSTCom", 0x528, 0x11f},
	{"vodafone NZ","voda NZ", 0x530, 0x01f},
	{"Next G NZ","NextG NZ", 0x530, 0x04f},
	{"Telecom NZ","Telecom", 0x530, 0x05f},
	{"NZ Comms","NZ COMMS", 0x530, 0x24f},
	{"PNGBMobile","BMobile", 0x537, 0x01f},
	{"U-CALL","U-CALL", 0x539, 0x01f},
	{"Digicel Tonga","Digicel", 0x539, 0x88f},
	{"SI BREEZE","BREEZE", 0x540, 0x01f},
	{"VUT SMILE","SMILE", 0x541, 0x01f},
	{"FJ VODAFONE","VODAFONE", 0x542, 0x01f},
	{"KL-Frigate","KI-FRIG", 0x545, 0x09f},
	{"NCL MOBILIS","MOBNCL", 0x546, 0x01f},
	{"F-VINI","VINI", 0x547, 0x20f},
	{"CK KOKANET","KOKANET", 0x548, 0x01f},
	{"Samoatel GO","GO", 0x549, 0x27f},
	{"FSM Telecom","FSMTC", 0x550, 0x01f},
	{"PLWPMC","PLWPMC", 0x552, 0x80f},
	{"EGY MobiNiL","MobiNiL", 0x602, 0x01f},
	{"vodafone EG","voda EG", 0x602, 0x02f},
	{"etisalat","etisalat", 0x602, 0x03f},
	{"ALG Mobilis","Mobilis", 0x603, 0x01f},
	{"Djezzy","Djezzy", 0x603, 0x02f},
	{"DZA NEDJMA","NEDJMA", 0x603, 0x03f},
	{"MOR MEDITEL","MEDITEL", 0x604, 0x00f},
	{"MOR IAM","IAM", 0x604, 0x01f},
	{"TUNISIE TELECOM","TUNTEL", 0x605, 0x02f},
	{"TUNISIANA","TUNSIANA", 0x605, 0x03f},
	{"Libyana","L", 0x606, 0x00f},
	{"Libya Al Madar","606 01", 0x606, 0x01f},
	{"GAMCEL","GAMCEL", 0x607, 0x01f},
	{"AFRICELL","AFRICELL", 0x607, 0x02f},
	{"GM COMIUM","GMCOMIUM", 0x607, 0x03f},
	{"SN ALIZE","ALIZE", 0x608, 0x01f},
	{"SN-SENTEL SG","SENTEL", 0x608, 0x02f},
	{"MR MATTEL","MATTEL", 0x609, 0x01f},
	{"MALITEL ML","MALITEL", 0x610, 0x01f},
	{"ORANGE ML","OML", 0x610, 0x02f},
	{"GN LAGUI","LAGUI", 0x611, 0x02f},
	{"CKY-Areeba","Areeba", 0x611, 0x04f},
	{"GINCL","CellcomGN", 0x611, 0x05f},
	{"CIV02","ACELL-CI", 0x612, 0x02f},
	{"Orange CI","Orange", 0x612, 0x03f},
	{"KoZ","KoZ", 0x612, 0x04f},
	{"MTN","MTN CI", 0x612, 0x05f},
	{"BF Celtel","celtel", 0x613, 0x02f},
	{"SAHELCOM","SAHELCOM", 0x614, 0x01f},
	{"CELTEL","CELTEL", 0x614, 0x02f},
	{"NE TELECEL","TELECEL", 0x614, 0x03f},
	{"TG-TOGO CELL","TGCELL", 0x615, 0x01f},
	{"TELECEL-TOGO","TELECEL", 0x615, 0x03f},
	{"TELECEL BENIN","TLCL-BEN", 0x616, 0x02f},
	{"BJ BENINCELL","BENCELL", 0x616, 0x03f},
	{"BELL BENIN COMMUNICATION","BBCOM", 0x616, 0x004},
	{"GloBenin","GloBenin", 0x616, 0x05f},
	{"CELLPLUS-MRU","CELL +", 0x617, 0x01f},
	{"EMTEL-MRU","EMTEL", 0x617, 0x10f},
	{"LBR Lonestar Cell","LoneStar", 0x618, 0x01f},
	{"LIBERCELL","LIBERCEL", 0x618, 0x02f},
	{"Celcom GSM","Celcom", 0x618, 0x07f},
	{"CELTEL SL","CELTEL", 0x619, 0x01f},
	{"MILLICOM SL","MILLICOM", 0x619, 0x02f},
	{"GH MTN","MTN", 0x620, 0x01f},
	{"GH ONEtouch","ONEtouch", 0x620, 0x02f},
	{"tiGO","tiGO GHANA", 0x620, 0x03f},
	{"Celtel NIG","celtel", 0x621, 0x20f},
	{"MTN - NG","MTN-NG", 0x621, 0x30f},
	{"NG Mtel","Mtel", 0x621, 0x40f},
	{"Glo NG","glo", 0x621, 0x50f},
	{"CELTEL TCD","CELTEL", 0x622, 0x01f},
	{"Telecel","Telecel", 0x623, 0x02f},
	{"NationLink","NL-RCA", 0x623, 0x04f},
	{"MTN CAM","62401", 0x624, 0x01f},
	{"Orange CAM","Orange", 0x624, 0x02f},
	{"CPV MOVEL","CMOVEL", 0x625, 0x01f},
	{"CPV T+","T+", 0x625, 0x02f},
	{"STP CSTmovel","CSTmovel", 0x626, 0x01f},
	{"GNQ01","GETESA", 0x627, 0x01f},
	{"628 01/LIBERTIS","LIBERTIS", 0x628, 0x01f},
	{"GAB TELECEL","TELECEL", 0x628, 0x02f},
	{"CELTEL GA","CELTEL", 0x628, 0x03f},
	{"CELTEL","CELTEL RC", 0x629, 0x01f},
	{"WARID RC","WARIDRC", 0x629, 0x07f},
	{"COG MTN","MTN-CG", 0x629, 0x10f},
	{"VODACOM CD","VODACOM", 0x630, 0x01f},
	{"CELTEL DRC","CELTEL", 0x630, 0x02f},
	{"SCELL CD","SCELL", 0x630, 0x05f},
	{"DRC and CCT","CCT", 0x630, 0x86f},
	{"CD OASIS","OASIS", 0x630, 0x89f},
	{"UNITEL","UNITEL", 0x631, 0x02f},
	{"Orange BS","ORANGE BS", 0x632, 0x03f},
	{"GTM","GTM", 0x632, 0x07f},
	{"C&W SEY","C&W SEY", 0x633, 0x01f},
	{"SEZ AIRTEL","AIRTEL", 0x633, 0x10f},
	{"MobiTel SDN","MobiTel", 0x634, 0x01f},
	{"MTN","MTN", 0x634, 0x02f},
	{"R-CELL","RCELL", 0x635, 0x10f},
	{"ETH-MTN","ET-MTN", 0x636, 0x01f},
	{"SOMTELESOM","TELESOM", 0x637, 0x01f},
	{"SOMAFONE","SOMAFONE", 0x637, 0x04f},
	{"Som Golis","Golis", 0x637, 0x30f},
	{"Telsom","Telsom", 0x637, 0x82f},
	{"DJ EVATIS","EVATIS", 0x638, 0x01f},
	{"Safaricom","SAF-COM", 0x639, 0x02f},
	{"CELTEL","CELTEL", 0x639, 0x03f},
	{"MOBITEL - TZ","MOBITEL", 0x640, 0x02f},
	{"ZANTEL-TZ","ZANTEL", 0x640, 0x03f},
	{"VodaCom","VodaCom", 0x640, 0x04f},
	{"celtel","celtel", 0x640, 0x05f},
	{"UG CelTel","CELTEL", 0x641, 0x01f},
	{"MTN-UGANDA","MTN-UG", 0x641, 0x10f},
	{"Uganda Telecom","UTL", 0x641, 0x11f},
	{"WaridTel","WaridTel", 0x641, 0x22f},	
	{"Spacetel BI","SPACETEL", 0x642, 0x01f},
	{"BUSAFA","SAFARIS", 0x642, 0x02f},
	{"ONATEL BDI","ONATEL", 0x642, 0x03f},
	{"TELECEL-BDI","BDITL", 0x642, 0x82f},
	{"MOZ - mCel","mCel", 0x643, 0x01f},
	{"VodaCom-MZ","VodaCom", 0x643, 0x04f},
	{"ZM CELTEL","CELTEL", 0x645, 0x01f},
	{"TELECEL ZM","TELECEL", 0x645, 0x02f},
	{"MG CT","Celtel", 0x646, 0x01f},
	{"MG ANTARIS","ANTARIS", 0x646, 0x02f},
	{"TELMA","TELMA", 0x646, 0x04f},
	{"Orange re","Orange", 0x647, 0x00f},
	{"ONLY","OUTREMER", 0x647, 0x02f},
	{"SFR REUNION","SFR RU", 0x647, 0x10f},
	{"ZW NET*ONE","NETONE", 0x648, 0x01f},
	{"TELECEL ZW","TELECEL", 0x648, 0x03f},
	{"ZW ECONET","ECONET", 0x648, 0x04f},
	{"MTC NAMIBIA","MTCNAM", 0x649, 0x01f},
	{"NAM Cell One","Cell One", 0x649, 0x03f},
	{"MW CP 900","CP 900", 0x650, 0x01f},
	{"CELTEL MW","CELTEL", 0x650, 0x10f},
	{"Vodacom Lesotho","Vodacom-LS", 0x651, 0x01f},
	{"LS-ECONET-EZI-CEL","EZI-CEL", 0x651, 0x02f},
	{"BW MASCOM","MASCOM", 0x652, 0x01f},
	{"Orange","Orange", 0x652, 0x02f},
	{"Swazi-MTN","SwaziMTN", 0x653, 0x10f},
	{"HURI","HURI", 0x654, 0x01f},
	{"VodaCom-SA","VODA", 0x655, 0x01f},
	{"Cell C","Cell C", 0x655, 0x07f},
	{"MTN-SA","MTN", 0x655, 0x10f},
	{"BTL","BTL", 0x702, 0x67f},
	{"Claro GTM","ClaroGTM", 0x704, 0x01f},
	{"TIGO","TIGO", 0x704, 0x02f},
	{"movistar","mstar", 0x704, 0x03f},
	{"Claro SLV","ClaroSLV", 0x706, 0x01f},
	{"Digicel","Digic", 0x706, 0x02f},
	{"TIGO","TIGO", 0x706, 0x03f},
	{"movistar","mstar", 0x706, 0x04f},
	{"Claro HND","ClaroHND", 0x708, 0x001},
	{"CELTELHND","CELTEL", 0x708, 0x02f},
	{"HND","HT - 200", 0x708, 0x30},
	{"Claro NIC","ClaroNIC", 0x710, 0x21f},
	{"movistar","mstar", 0x710, 0x30f},
	{"Claro NIC","ClaroNIC", 0x710, 0x73f},
	{"MOVISTARNI","movistar", 0x710, 0x300},
	{"I.C.E.","I.C.E.", 0x712, 0x01f},
	{"I.C.E.","I.C.E.", 0x712, 0x02f},
	{"PANCW","PANCW", 0x714, 0x01f},
	{"movistar","mstar", 0x714, 0x02f},
	{"movistar","mstar", 0x716, 0x06f},
	{"Claro PER","ClaroPER", 0x716, 0x10f},
	{"MOVISTAR","MSTAR", 0x722, 0x07f},
	{"Personal","Perso", 0x722, 0x34f},
	{"PORTHABLE","PORTH", 0x722, 0x35f},
	{"Claro AR","Claro AR", 0x722, 0x310},
	{"TIM","TIM", 0x724, 0x02f},
	{"TIM","TIM", 0x724, 0x03f},
	{"TIM","TIM", 0x724, 0x04f},
	{"Claro","Claro", 0x724, 0x05f},
	{"VIVO","VIVO", 0x724, 0x06f},
	{"VIVO","VIVO", 0x724, 0x10f},
	{"VIVO","VIVO", 0x724, 0x11f},
	{"BRA SCTL","SCTL", 0x724, 0x15f},
	{"Brasil Telecom","BrT", 0x724, 0x16f},	
	{"TELEMIG CEL","TELEMIG", 0x724, 0x23f},
	{"AMAZÔIA","AMAZÔIA", 0x724, 0x24f},//names? - corrected
	{"Oi","Oi", 0x724, 0x31f},
	{"CTBC","CTBC", 0x724, 0x32f},
	{"CTBC","CTBC", 0x724, 0x33f},
	{"CTBC","CTBC", 0x724, 0x34f},
	{"Entel PCS","Entel", 0x730, 0x01f},
	{"movistar","mstar", 0x730, 0x02f},
	{"Claro CHL","ClaroCHL", 0x730, 0x03f},
	{"Entel PCS","Entel", 0x730, 0x10f},
	{"COMCEL 3GSM","COMCEL", 0x732, 0x101},
	{"Tigo","TIGO COL", 0x732, 0x103},
	{"Tigo","TIGO COL", 0x732, 0x111},
	{"movistar","mstar", 0x732, 0x123},
	{"DIGITEL","DIGIT", 0x734, 0x01f},
	{"DIGITEL","DIGIT", 0x734, 0x02f},
	{"DIGITEL","DIGIT", 0x734, 0x03f},
	{"movistar","mstar", 0x734, 0x04f},
	{"VE_MOVILNET","Movilnet", 0x734, 0x06f},	
	{"Nuevatel PCS De BoliviaSA","VIVA", 0x736, 0x01f},
	{"BOMOV","EMOVIL", 0x736, 0x02f},
	{"Telecel_Bolivia_GSM","Telecel", 0x736, 0x03f},
	{"DIGICEL","DIGICEL", 0x738, 0x01f},
	{"GUY CLNK PLS","CLNK PLS", 0x738, 0x002},
	{"movistar","mstar", 0x740, 0x00f},
	{"Porta GSM","PORTAGSM", 0x740, 0x01f},
	{"VOX","VOX", 0x744, 0x01f},
	{"Claro PY","Claro PY", 0x744, 0x02f},
	{"TIGO","TIGO", 0x744, 0x04f},
	{"Personal","Perso", 0x744, 0x05f},
	{"SR.TELESUR.GSM","TeleG", 0x746, 0x02f},
	{"DIGICEL","DIGICEL", 0x746, 0x03f},
	{"ANCEL","ANCEL", 0x748, 0x01f},
	{"MOVISTAR","MSTAR", 0x748, 0x07f},
	{"Claro UY","Claro UY", 0x748, 0x10f},
	{"C&W FLK","C&W FLK", 0x750, 0x01f},
	{"TM CELL","TM CELL", 0x795, 0x02f},
	{"Thuraya","Thuraya", 0x901, 0x05f},
	{"Thuraya","Thuraya", 0x901, 0x06f},
	{"MCP Maritime Com","MCP", 0x901, 0x12f},
	{"AeroMobile","AeroMob", 0x901, 0x14f},
	{"OnAir","OnAir", 0x901, 0x15f},
	{"Navitas","Navitas", 0x901, 0x17f},
	{"Seanet","Seanet", 0x901, 0x21f},
	{"INX Inmarsat","INMARSAT", 0x901 , 0x11f},
	{"AT&T","AT&T", 0x311, 0x180}, 	
	{"GCI","GCI", 0x311, 0x370},
	{"PR Claro","Claro", 0x330, 0x110},
/*--- EOL -------------------------------------------------------*/
    	{ NULL,	 NULL,  -1 ,-1   }
};
#else

EXTERN const T_OPER_NTRY_FIXED operListFixed[];

#endif      /* of #ifdef CMH_MMF_C */

#endif      /* TI_PS_OP_OPN_TAB_ROMBASED */

#endif
