/****************************************************************************/
/*  modf   v2.54                                                            */
/*  Copyright (c) 1995-2004 Texas Instruments Incorporated                  */
/****************************************************************************/
#include <math.h>
#include <values.h>

/****************************************************************************/
/*									    */
/*  MODF() - break into integer and fractional parts			    */
/*									    */
/****************************************************************************/
double modf(double value, double *iptr)
{
    unsigned long *dptr = (unsigned long *)&value;
    double input        = value;   

    /************************************************************************/
    /* Get double precision exponent, subtract bias                         */
    /************************************************************************/
    int exp = ((*dptr >> 20) & 0x7FF) - 1023;

    /************************************************************************/
    /* IF VALUE HAS NO WHOLE PART, EASY.                                    */
    /************************************************************************/
    if (exp < 0)   { *iptr = 0.0; return value; }

    /************************************************************************/
    /* IF VALUE HAS NO FRACTIONAL PART, ALSO EASY                           */
    /************************************************************************/
    if (exp >= 52) { *iptr = value; return 0.0; }

    /************************************************************************/
    /* OTHERWISE, NOT SO EASY.                                              */
    /* MASK OFF FRACTIONAL BITS TO GET INTEGRAL PORTION OF VALUE.           */
    /************************************************************************/
    if (exp < 20)
        { dptr[1] = 0; dptr[0] &= ~((1 << (20 - exp)) - 1); }
    else
	{ dptr[1] &= ~((1 << (52 - exp)) - 1); }
   
    /************************************************************************/
    /* SUBTRACT INTEGRAL PORTION FROM ORIGINAL VALUE TO GET FRACTIONAL PART.*/
    /************************************************************************/
    *iptr = value;
    return input - value;
}
