/*=============================================================================
 * Copyright 2003 Texas Instruments Incorporated. All Rights Reserved.
 */
#ifndef BSP_TWL3029_USBOTG_PX2_HEADER
#define BSP_TWL3029_USBOTG_PX2_HEADER
 

/*===========================================================================
 * Component Description:
 */
/*!  
 * @header bspTwl3029_UsbOtg_px2.h
 *   Public interface to the Twl3029 USB hardware subsystem.
 */
/*===========================================================================
 *  Defines and Macros
 */
 /*==========================================================================*/
 /*!
 * @constant
 *
 * @discussion 
 * <b> Description </b><br>
 */

/*===========================================================================*/
/*!
 * @typedef BspTwl3029_UsbOtgIntTriggerType
 *
 * @discussion
 * <b> Description </b><br>
 *    Defines the interrupt signal transition that will cause the
 *    interrupt to trigger.
 *
 * @constant BSP_TWL3029_USBOTG_INT_TRIGGER_ON_TRUE_FALSE_SIGNAL_TRANSITION
 *    Triggers interrupt when signal transitions from high to low.
 *
 * @constant BSP_TWL3029_USBOTG_INT_TRIGGER_ON_FALSE_TRUE_SIGNAL_TRANSITION
 *    Triggers interrupt when signal transitions from low to high.
 */
enum
{
    BSP_TWL3029_USBOTG_INT_TRIGGER_ON_TRUE_FALSE_SIGNAL_TRANSITION,
    BSP_TWL3029_USBOTG_INT_TRIGGER_ON_FALSE_TRUE_SIGNAL_TRANSITION
};
typedef Uint8 BspTwl3029_UsbOtgIntTriggerType;
 /*===========================================================================
 * Public Data
 */
 /*!
 * @constant
 *
 * @discussion 
 * <b> Description </b><br>
 *     These are default values for all regs for initialization. 
 */
 enum
{
   BSP_TWL3029_MAP_USB_CTRL_1_SET_DEFAULT         = 0, /* USB:   CTRL_1_SET */   
   BSP_TWL3029_MAP_USB_CTRL_1_CLR_DEFAULT         = 0, /* USB:   CTRL_1_CLR */   
   BSP_TWL3029_MAP_USB_CTRL_2_SET_DEFAULT         = 0, /* USB:   CTRL_2_SET */   
   BSP_TWL3029_MAP_USB_CTRL_2_CLR_DEFAULT         = 0,  /* USB:   CTRL_2_CLR */   
   BSP_TWL3029_MAP_USB_INT_SRC_DEFAULT            = 0, /* USB:   INT_SRC */   
   BSP_TWL3029_MAP_USB_INT_LATCH_SET_DEFAULT     = 0,/* USB:   INT_LATCH_SET */   
   BSP_TWL3029_MAP_USB_INT_LATCH_CLR_DEFAULT     = 0,  /* USB:   INT_LATCH_CLR */   
   BSP_TWL3029_MAP_USB_INT_EN_LO_SET_DEFAULT     = 0,  /* USB:   INT_EN_LO_SET */   
   BSP_TWL3029_MAP_USB_INT_EN_LO_CLR_DEFAULT     = 0, /* USB:   INT_EN_LO_CLR */   
   BSP_TWL3029_MAP_USB_INT_EN_HI_SET_DEFAULT     = 0, /* USB:   INT_EN_HI_SET */
   BSP_TWL3029_MAP_USB_INT_EN_HI_CLR_DEFAULT     = 0, /* USB:   INT_EN_HI_CLR */
   BSP_TWL3029_MAP_USB_CR_PSM_CTRL_DEFAULT       = 0, /* USB:   CR_PSM_CTRL */
   BSP_TWL3029_MAP_USB_CR_PSM_CMD_DEFAULT       =  0,  /* USB:   CR_PSM_CMD */
   BSP_TWL3029_MAP_USB_CR_PSM_CMD_STATUS_DEFAULT = 0, /* USB:   CR_PSM_CMD_STATUS */
   BSP_TWL3029_MAP_USB_CR_FSM_STATUS_DEFAULT     = 0, /* USB:   CR_FSM_STATUS */
   BSP_TWL3029_MAP_USB_CR_FSM_ERR_STATUS_DEFAULT = 0, /* USB:   CR_FSM_ERR_STATUS */
   BSP_TWL3029_MAP_USB_CR_TIM_POS_DEFAULT        = 0, /* USB:   CR_TIM_POS */
   BSP_TWL3029_MAP_USB_CR_TIM_PLS_DEFAULT        = 0, /* USB:   CR_TIM_PLS */
   BSP_TWL3029_MAP_USB_CR_DET_PLS_DEFAULT        = 0, /* USB:   CR_DET_PLS */
   BSP_TWL3029_MAP_USB_CR_INT_SRC_1_DEFAULT      = 0, /* USB:   CR_INT_SRC_1 */
   BSP_TWL3029_MAP_USB_CR_INT_SRC_2_DEFAULT      = 0, /* USB:   CR_INT_SRC_2 */
   BSP_TWL3029_MAP_USB_CR_INT_MSK_1_DEFAULT      = 0, /* USB:   CR_INT_MSK_1 */
   BSP_TWL3029_MAP_USB_CR_INT_MSK_2_DEFAULT      = 0, /* USB:   CR_INT_MSK_2 */
   BSP_TWL3029_MAP_USB_CR_INT_LATCH_1_DEFAULT    = 0, /* USB:   CR_INT_LATCH_1 */
   BSP_TWL3029_MAP_USB_CR_INT_LATCH_2_DEFAULT    = 0, /* USB:   CR_INT_LATCH_2 */
   BSP_TWL3029_MAP_USB_UART_AUDIO_CTRL_DEFAULT   = 0, /* USB:   UART_AUDIO_CTRL */
   BSP_TWL3029_MAP_USB_INT_SRC_2_DEFAULT         = 0, /* USB:   INT_SRC_2 */
   BSP_TWL3029_MAP_USB_INT_LATCH_2_DEFAULT       = 0, /* USB:   INT_LATCH_2 */
   BSP_TWL3029_MAP_USB_INT_EN_LO_2_DEFAULT       = 0, /* USB:   INT_EN_LO_2 */
   BSP_TWL3029_MAP_USB_INT_EN_HI_2_DEFAULT       = 0 /* USB:   INT_EN_HI_2 */
};
typedef Uint8 BspTwl3029_Usb_RegDefault;  




/*===========================================================================*/
/*!
 * @typedef BspTwl3029_UsbOtgInterruptId
 *
 * @discussion
 * <b> Description </b><br>
 *    Defines the various interrupts generated by the USB OTG block.
 *    Note: Car Kit not working in ver PG 1.0 or  1.1 of hardware
 *
 * @constant BSP_TWL3029_USBOTG_INT_VBUS_VLD
 *    Trigger if VBUS voltage is above Va_vbus_vld.
 *
 * @constant BSP_TWL3029_USBOTG_INT_SESSION_START
 *    Trigger on session transaction start.
 *
 * @constant BSP_TWL3029_USBOTG_INT_DP_PIN_HIGH
 *    Trigger if DP pin voltage is above Vih.
 *
 * @constant  BSP_TWL3029_USBOTG_INT_ID_PIN_GROUNDED
 *    Trigger if the ID pin is grounded.
 *
 * @constant BSP_TWL3029_USBOTG_INT_DM_PIN_HIGH
 *    Trigger if DM pin voltage is above Vih.
 *
 * @constant BSP_TWL3029_USBOTG_INT_ID_PIN_FLOAT
 *    Trigger on ID pin float.
 *
 * @constant BSP_TWL3029_USBOTG_INT_BDIS_ACON
 *    Trigger on B-device disconnect.
 */
enum
{
    BSP_TWL3029_USBOTG_INT_VBUS_VLD,
    BSP_TWL3029_USBOTG_INT_SESSION_START,
    BSP_TWL3029_USBOTG_INT_DP_PIN_HIGH,
    BSP_TWL3029_USBOTG_INT_ID_PIN_GROUNDED,
    BSP_TWL3029_USBOTG_INT_DM_PIN_HIGH,
    BSP_TWL3029_USBOTG_INT_ID_PIN_FLOAT,
    BSP_TWL3029_USBOTG_INT_BDIS_ACON,
    
    BSP_TWL3029_USBOTG_INT_CR_INT,
    
    BSP_TWL3029_USBOTG_INT2_VD_SESS_END,
    BSP_TWL3029_USBOTG_INT2_VD_SESS_VLD,
    BSP_TWL3029_USBOTG_INT2_STRESS,
    BSP_TWL3029_USBOTG_INT_ID_RES_100K,
    BSP_TWL3029_USBOTG_INT_ID_RES_200K,
    BSP_TWL3029_USBOTG_INT_ID_RES_440K          
    
};
typedef Uint8 BspTwl3029_UsbOtg_InterruptId;
#define BSP_TWL3029_USBOTG_INT_MAX 14
/*===========================================================================*/
/*!
 * @typedef BspTwl3029_UsbOtgCrInterruptId
 *
 * @discussion
 * <b> Description </b><br>
 *    Defines the various sources which can generate a  CR_INT interrupt.
 *
 * @constant 
 */
enum
{
    BSP_TWL3029_USBOTG_CR_INT_DISCONNECTED,
    BSP_TWL3029_USBOTG_CR_INT_CARKIT,
    BSP_TWL3029_USBOTG_CR_INT_USBOTG_B,
    BSP_TWL3029_USBOTG_CR_INT_HOST,
    BSP_TWL3029_USBOTG_CR_INT_CHARGER,
    BSP_TWL3029_USBOTG_CR_INT_PH_ACC,
    BSP_TWL3029_USBOTG_CR_INT_PSM_ERROR,
    BSP_TWL3029_USBOTG_CR_INT_RSVRD1,
    
    BSP_TWL3029_USBOTG_CR_INT_PH_NO_ACK,    
    BSP_TWL3029_USBOTG_CR_INT_PHONE_UART,
    BSP_TWL3029_USBOTG_CR_INT_CARKIT_UART,
    BSP_TWL3029_USBOTG_CR_INT_STEREO_TO_MONO,
    BSP_TWL3029_USBOTG_CR_INT_RSVRD2,
    BSP_TWL3029_USBOTG_CR_INT_RSVRD3,
    BSP_TWL3029_USBOTG_CR_INT_RSVRD4,
    BSP_TWL3029_USBOTG_CR_INT_STOP_PLS_MISS
    
};
typedef Uint8 BspTwl3029_UsbOtg_CrInterruptId;
#define BSP_TWL3029_USBOTG_CR_INT_MAX 16

/*===========================================================================*/
/*!
 * @typedef BspTwl3029_UsbOtg_SetClrReg
 *
 * @discussion
 * <b> Description </b><br>
 *    Used to access the address of one of the Usb SET registers from 
 *    an array containing the addresses
 *
 * @constant 
 *
 */
enum
{
    BSP_TWL3029_USBOTG_SETCLR_CTRL_1,
    BSP_TWL3029_USBOTG_SETCLR_CTRL_2,
    BSP_TWL3029_USBOTG_SETCLR_CTRL_3, 
    BSP_TWL3029_USBOTG_SETCLR_POWER,
    BSP_TWL3029_USBOTG_SETCLR_CR_PSM_CTRL,
    BSP_TWL3029_USBOTG_SETCLR_CR_PSM_CMD 

};

typedef Uint8 BspTwl3029_UsbOtg_SetClrReg;

#define BSPTWL3029_SETCLRREG_MAX 6

typedef BspTwl3029_I2C_RegData BspTwl3029_UsbOtg_SetClrVal; 
/*===========================================================================*/
/*!
 * @typedef BspTwl3029_UsbOtg_CrIntHandler
 *
 * @discussion
 * <b> Description </b><br>
 *     Interrupt handler for handling usb itg transceiver events.
 *
 * @param intId
 *    Identifies the interrupt source which triggered the interrupt.
 *
 * @return NOTHING.
 */
typedef void (*BspTwl3029_UsbOtg_CrIntHandler)( BspTwl3029_UsbOtg_CrInterruptId intId );

/*==============================================================================*/
/*!
 *   FUNCTIONS
 */

/*==============================================================================*/
/*!
 * @function bspTwl3029_UsbOtg_enableCrIntSource
 *
 * @discussion
 * <b> Description </b><br>
 *    Enables a carkit interrupt.
 *
 * @param intSrcId
 *    The interrupt to enable.
 *
 * @result
 *    returns BSP_TWL3029_RETURN_CODE_SUCCESS on success
 *            BSP_TWL3029_RETURN_CODE_FAILURE on failure.
 */
BspTwl3029_ReturnCode
bspTwl3029_UsbOtg_enableCrIntSource( BspTwl3029_I2C_CallbackPtr callbackInfoPtr,
                                   BspTwl3029_UsbOtg_InterruptId    intSrcId);

/*==============================================================================*/
/*!
 * @function bspTwl3029_UsbOtg_disableCrIntSource
 *
 * @discussion
 * <b> Description </b><br>
 *    Disables the interrupt for the usb carkit.
 *
 * @param intSrcId
 *    The interrupt to enable.
 *
 * @result
 *    returns BSP_TWL3029_RETURN_CODE_SUCCESS on success
 *            BSP_TWL3029_RETURN_CODE_FAILURE on failure.
 */
BspTwl3029_ReturnCode
bspTwl3029_UsbOtg_disableCrIntSource( BspTwl3029_I2C_CallbackPtr callbackInfoPtr,
                                    BspTwl3029_UsbOtg_InterruptId    intSrcId );



/*==============================================================================*/
/*!
 * @function bspTwl3029_UsbOtg_setCrHandler
 *
 * @discussion
 * <b> Description </b><br>
 *    Registers the client handler for an interrupt.
 *
 * @param intSrcId
 *    The interrupt for which the handler is to be registered.
 *
 * @param handler
 *    The handler to register.
 *
 * @result
 *    returns BSP_TWL3029_RETURN_CODE_SUCCESS on success
 *            BSP_TWL3029_RETURN_CODE_FAILURE on failure.
 */
BspTwl3029_ReturnCode
bspTwl3029_UsbOtg_setCrHandler( BspTwl3029_UsbOtg_InterruptId intSrcId,
                                BspTwl3029_UsbOtg_CrIntHandler  handler );



#endif
