/******************************************************************************
 *                   WIRELESS COMMUNICATION SYSTEM DEVELOPMENT
 *
 *             (C) 2005 Texas Instruments France. All rights reserved
 *
 *                          Author : Mary  TOOHER
 *
 *
 *  Important Note
 *  --------------
 *
 *  This S/W is a preliminary version. It contains information on a product 
 *  under development and is issued for evaluation purposes only. Features 
 *  characteristics, data and other information are subject to change.
 *
 *  The S/W is furnished under Non Disclosure Agreement and may be used or
 *  copied only in accordance with the terms of the agreement. It is an offence
 *  to copy the software in any way except as specifically set out in the 
 *  agreement. No part of this document may be reproduced or transmitted in any
 *  form or by any means, electronic or mechanical, including photocopying and
 *  recording, for any purpose without the express written permission of Texas
 *  Instruments Inc.
 *
 ******************************************************************************
 *
 *  FILE NAME: bspTwl3029_Aux.h
 *
 *
 *  PURPOSE:  Driver header for various Twl3029 ( Triton )analog  Transceiver and resourse
 *            These are:
 *             LEDA  - for use as LCD back light
 *             LEDB
 *             LEDC
 *             Vibrator
 *
 *             Note: USBotg transceiver and SIM have their own separate drivers
 *
 *  FILE REFERENCES:
 *
 *  Name                  IO      Description
 *  -------------         --      ---------------------------------------------
 *  
 *
 *
 *  EXTERNAL VARIABLES:
 *
 *  Source:
 *
 *  Name                  Type              IO   Description
 *  -------------         ---------------   --   ------------------------------
 *
 *  
 *
 *
 *  EXTERNAL REFERENCES:
 *
 *  Name                Description
 *  ------------------  -------------------------------------------------------
 *
 *
 *
 *  ABNORMAL TERMINATION CONDITIONS, ERROR AND WARNING MESSAGES:
 *  
 *
 *
 *  ASSUMPTION, CONSTRAINTS, RESTRICTIONS:
 *  
 *
 *
 *  NOTES:
 *  
 *
 *
 *  REQUIREMENTS/FUNCTIONAL SPECIFICATION REFERENCES:
 *
 *
 *
 *
 *  DEVELOPMENT HISTORY:
 *
 *  Date        Name(s)         Version  Description
 *  ----------  --------------  -------  --------------------------------------
 *  04/03/2004  Mary Tooher     V1.0.0   First implementation
 */
#ifndef BSP_TWL3029_AUX_PG2x_HEADER
#define BSP_TWL3029_AUX_PG2x_HEADER 
 /*******************************************************************************
 *   includes
 */
 
#include "types.h" 
//#include "main_system.h"
#include "bspTwl3029.h"
#include "bspTwl3029_I2c.h"

//#include "main_Platform.h"



/*=============================================================================
 *  Defines and Macros
 */
/*==========================================================================*/
/*==========================================================================*/
 /*!
 * @typedef  BspTwl3029_Aux_LedCtrlField
 *
 * @discussion 
 * <b> Description </b><br>
 *     enum used to select one or more of the 4 fields to update in 
 *     LED_CTRL register
 *
 * @constant  
 *      
 */
 enum
{
    BSP_TWL3029_LED_CTRL_LPM     = 1,
    BSP_TWL3029_LED_CTRL_TIMER   = 2,
    BSP_TWL3029_LED_CTRL_DACIREF = 4,
    BSP_TWL3029_LED_CTRL_SWFREQ  = 8,
    BSP_TWL3029_LED_CTRL_TRIM    = 16
};
typedef Uint8 BspTwl3029_Aux_LedCtrlField;			               				   


/*==========================================================================*/
 /*!
 * @typedef  BspTwl3029_Aux_LedCtrlLpm
 *
 * @discussion 
 * <b> Description </b><br>
 *     enum used for enable/disabling low power mode
 *
 * @constant  
 *      
 */
 enum
{
    BSP_TWL3029_LED_LPM_DISABLE  = 0,
    BSP_TWL3029_LED_LPM_ENABLE = 1
};
typedef Uint8 BspTwl3029_Aux_LedCtrlLpm;			               				   


/*==========================================================================*/
 /*!
 * @typedef  BspTwl3029_Aux_LedTimer
 *
 * @discussion 
 * <b> Description </b><br>
 *     defines timer step
 *     0 -   125 us ( mim)
 *     1 -   125 + 31 us  ( min +step)
 *       -
 *     4 -   250us ( hardware default) 
 *   0xf -   593us (max)
 * @constant  
 *      
 */

typedef Uint8 BspTwl3029_Aux_LedCtrlTimer;			               				   


/*==========================================================================*/
 /*!
 * @typedef  BspTwl3029_Aux_LedCtrlDacIref
 *
 * @discussion 
 * <b> Description </b><br>
 *     This sets the path of the reference current for the 8-bit DAC.
 *  @constant   BSP_TWL3029_LED_DAC_IREF_ONCHIP
 *               Reference current is generated by the on-chip current reference 
 *                generator (based on the external reference resistor at node IREF
 * 
 *  @constant  BSP_TWL3029_LED_DAC_IREF_V2I_CONVERTER 
 *           Reference current is generated by a dedicated V-to-I converter
 *           (reference input voltage is the on-chip bandgap reference) 
 *      
 */
 enum
{
    BSP_TWL3029_LED_DAC_IREF_ONCHIP  = 0,
    BSP_TWL3029_LED_DAC_IREF_V2I_CONVERTER = 1
};
typedef Uint8 BspTwl3029_Aux_LedCtrlDacIref;			               				   


/*==========================================================================*/
 /*!
 * @typedef  BspTwl3029_Aux_LedCtrlSwFreq
 *
 * @discussion 
 * <b> Description </b><br>
 *     This is used to set the switching frequency of the current flowing 
 *             through the WLEDs
 *  @constant   BSP_TWL3029_LED_SWFREQ_56HZ
 *               current switched any 6ms - 56-Hz
 *
 *  @constant   BSP_TWL3029_LED_SWFREQ_112HZ
 *               current switched any 3ms - 112-Hz
 *
 *  @constant   BSP_TWL3029_LED_SWFREQ_168HZ
 *               current switched any 2ms - 168-Hz
 *     
 */
 enum
{
    BSP_TWL3029_LED_SWFREQ_56HZ  = 0,
    BSP_TWL3029_LED_SWFREQ_112HZ = 1,
    BSP_TWL3029_LED_SWFREQ_168HZ = 3
};
typedef Uint8 BspTwl3029_Aux_LedCtrlSwFreq;	

/*==========================================================================*/
 /*!
 * @typedef  BspTwl3029_Aux_LedCtrlTrimCtrl
 *
 * @discussion 
 * <b> Description </b><br>
 *     trimming code for the output V to I converter. ( default 0x10) 
 *     
 */

#define     BSP_TWL3029_LED_TRIM_DEFAULT   (0x10)
 
typedef Uint8 BspTwl3029_Aux_LedCtrlTrimCtrl;	
/*==========================================================================*/
 /*!
 * @typedef  BspTwl3029_Aux_LedsCtrlData
 *
 * @discussion 
 * <b> Description </b><br>
 *      struct containing control fields used for programming WLED_CTRL register
 *      and also WLED_RES_TRIM register 
 *
 *      rsvd  - reserved 
 *
 *      timer - White-LEDs monitoring timer control bits: they control the status of 
 *             each WLEDs network. 
 *             In case the circuit has not properly started (after the programmed time), 
 *             this timer stops driving the network that does not works correctly 
 *
 *      dacIref - This sets the path of the reference current for the 8-bit DAC.
 *             0: Reference current is generated by the on-chip current reference 
 *                generator (based on the external reference resistor at node IREF
 *             1: Reference current is generated by a dedicated V-to-I converter
 *               (reference input voltage is the on-chip bandgap reference)
 *
 *     swFreq - These two bits set the switching frequency of the current flowing 
 *             through the WLEDs
 *
 *     trim   - trimming code for the output V to I converter. ( default 0x10)
 */
typedef struct
{
    BspTwl3029_I2C_RegData      reserved;   /* not used for version PG 2.0 */
    BspTwl3029_I2C_RegData      timer;
    BspTwl3029_I2C_RegData      dacIref;
    BspTwl3029_I2C_RegData      swFreq;
    BspTwl3029_I2C_RegData      trim;
} BspTwl3029_Aux_LedsCtrlData;




/*=============================================================================
 *   Public Functions
 *============================================================================*/



#endif















