/*=============================================================================
 *    Copyright 2005 Texas Instruments Inc. All rights reserved.
 */
#ifndef BSP_TWL3029_AUX_MAP_PG2X_HEADER
#define BSP_TWL3029_AUX_MAP_PG2X_HEADER

/*=============================================================================
 * Component Description:
 *    PG2.0 register map for Triton Analog Base Band processor - module baraux.
 *    - mapping for the following Triton  registers 
 *    - USB
 *    - MADC
 *    - VIB
 *    - AUX_REG
 *    - WLED
 *    - BCI
 *    - SIM
 */

/*=============================================================================
 * Constants
 */

/*=============================================================================
 */

/* USBOTG register on page 0 and 2  */
#define BSP_TWL3029_MAP_USB_USB_POWER_SET_OFFSET        16 /* USB:   USB_POWER_SET */
#define BSP_TWL3029_MAP_USB_USB_POWER_CLR_OFFSET        17 /* USB:   POWER_CLR */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_12H_OFFSET     18 /* USB:  RESERVED_USB_12H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_13H_OFFSET     19 /* USB:  RESERVED_USB_13H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_14H_OFFSET     20 /* USB:  RESERVED_USB_14H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_15H_OFFSET     21 /* USB:  RESERVED_USB_15H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_16H_OFFSET     22 /* USB:  RESERVED_USB_16H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_17H_OFFSET     23 /* USB:  RESERVED_USB_17H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_18H_OFFSET     24 /* USB:  RESERVED_USB_18H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_19H_OFFSET     25 /* USB:  RESERVED_USB_19H */
#define BSP_TWL3029_MAP_USB_CTRL_3_SET_OFFSET           26 /* USB:  CTRL_3_SET */
#define BSP_TWL3029_MAP_USB_CTRL_3_CLR_OFFSET           27 /* USB:  CTRL_3_CLR */
#define BSP_TWL3029_MAP_USB_TX_PLSWIDTH_POS_OFFSET      28 /* USB:  TX_PLSWIDTH_POS */
#define BSP_TWL3029_MAP_USB_TX_PLSWIDTH_NEG_OFFSET      29 /* USB:  TX_PLSWIDTH_NEG */
#define BSP_TWL3029_MAP_USB_RX_RECOVERY_OFFSET          30 /* USB:  RX_RECOVERY */
#define BSP_TWL3029_MAP_USB_CR_INT_DELAY_OFFSET         31 /* USB:  CR_INT_DELAY */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_20H_OFFSET     32 /* USB:  RESERVED_USB_20H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_21H_OFFSET     33 /* USB:  RESERVED_USB_21H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_22H_OFFSET	34 /* USB:  RESERVED_USB_22H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_23H_OFFSET	35 /* USB:   RESERVED_USB_23H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_24H_OFFSET     36 /* USB:  RESERVED_USB_24H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_25H_OFFSET     37 /* USB:  RESERVED_USB_25H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_26H_OFFSET     38 /* USB:  RESERVED_USB_26H */
#define BSP_TWL3029_MAP_USB_RESERVED_USB_27H_OFFSET     39 /* USB:  RESERVED_USB_27H */



/* USBOTG register on page 2 only */
#define BSP_TWL3029_MAP_USB_INT_SRC_2_OFFSET           160  /* USB: INT_SRC_2  */ 
#define BSP_TWL3029_MAP_USB_INT_LATCH_2_SET_OFFSET     161  /* USB: INT_LATCH_2_SET  */
#define BSP_TWL3029_MAP_USB_INT_LATCH_2_CLR_OFFSET     162  /* USB: INT_LATCH_2_CLR  */
#define BSP_TWL3029_MAP_USB_INT_EN_LO_2_SET_OFFSET     163  /* USB: INT_EN_LO_2_SET  */
#define BSP_TWL3029_MAP_USB_INT_EN_LO_2_CLR_OFFSET     164  /* USB: INT_EN_LO_2_CLR  */
#define BSP_TWL3029_MAP_USB_INT_EN_HI_2_SET_OFFSET     165  /* USB: INT_EN_HI_2_SET  */
#define BSP_TWL3029_MAP_USB_INT_EN_HI_2_CLR_OFFSET     166  /* USB: INT_EN_HI_2_CLR  */
#define BSP_TWL3029_MAP_USB_CR_INT_SRC_1_OFFSET        167  /* USB: CR_INT_SRC_1  */
#define BSP_TWL3029_MAP_USB_CR_INT_LATCH_1_SET_OFFSET  168  /* USB: CR_INT_LATCH_1_SET  */
#define BSP_TWL3029_MAP_USB_CR_INT_LATCH_1_CLR_OFFSET  169  /* USB: CR_INT_LATCH_1_CLR  */
#define BSP_TWL3029_MAP_USB_CR_INT_EN_1_SET_OFFSET     170  /* USB: CR_INT_EN_1_SET  */
#define BSP_TWL3029_MAP_USB_CR_INT_EN_1_CLR_OFFSET     171  /* USB: CR_INT_EN_1_CLR  */
#define BSP_TWL3029_MAP_USB_CR_INT_SRC_2_OFFSET        172  /* USB: CR_INT_SRC_2  */
#define BSP_TWL3029_MAP_USB_CR_INT_LATCH_2_SET_OFFSET  173  /* USB: CR_INT_LATCH_2_SET  */
#define BSP_TWL3029_MAP_USB_CR_INT_LATCH_2_CLR_OFFSET  174  /* USB: CR_INT_LATCH_2_CLR  */
#define BSP_TWL3029_MAP_USB_CR_INT_EN_2_SET_OFFSET     175  /* USB: CR_INT_EN_2_SET  */
#define BSP_TWL3029_MAP_USB_CR_INT_EN_2_CLR_OFFSET     176  /* USB: CR_INT_EN_2_CLR  */
#define BSP_TWL3029_MAP_USB_CR_PSM_CTRL_SET_OFFSET     177  /* USB: CR_PSM_CTRL_SET  */
#define BSP_TWL3029_MAP_USB_CR_PSM_CTRL_CLR_OFFSET     178  /* USB: CR_PSM_CTRL_CLR  */
#define BSP_TWL3029_MAP_USB_CR_PSM_CMD_SET_OFFSET      179  /* USB: CR_PSM_CMD_SET  */
#define BSP_TWL3029_MAP_USB_CR_PSM_CMD_CLR_OFFSET      180  /* USB: CR_PSM_CMD_CLR  */
#define BSP_TWL3029_MAP_USB_CR_PSM_CMD_STATUS_OFFSET   181  /* USB: CR_PSM_CMD_STATUS */
#define BSP_TWL3029_MAP_USB_CR_PSM_STATUS_OFFSET       182  /* USB: CR_PSM_STATUS  */
#define BSP_TWL3029_MAP_USB_CR_PSM_NEXT_STATUS_OFFSET  183  /* USB: CR_PSM_NEXT_STATUS  */
#define BSP_TWL3029_MAP_USB_CR_PSM_ERR_STATUS_OFFSET   184  /* USB: CR_PSM_ERR_STATUS  */
#define BSP_TWL3029_MAP_USB_CR_PSM_CTRL_STATE_OFFSET   185  /* USB: CR_PSM_CTRL_STATE  */
#define BSP_TWL3029_MAP_USB_CABLE_DEBOUNCE_OFFSET      186  /* USB: CABLE_DEBOUNCE  */
#define BSP_TWL3029_MAP_USB_TPH_DP_CON_MIN_OFFSET      187  /* USB: TPH_DP_CON_MIN  */
#define BSP_TWL3029_MAP_USB_TPH_DP_CON_MAX_OFFSET      188  /* USB: TPH_DP_CON_MAX  */
#define BSP_TWL3029_MAP_USB_TCR_DP_CON_MIN_OFFSET      189  /* USB: TCR_DP_CON_MIN  */
#define BSP_TWL3029_MAP_USB_TCR_DP_CON_MAX_OFFSET      190  /* USB: TCR_DP_CON_MAX  */
#define BSP_TWL3029_MAP_USB_TPH_DP_PD_SHORT_OFFSET     191  /* USB: TPH_DP_PD_SHORT  */
#define BSP_TWL3029_MAP_USB_TPH_AUD_BIAS_OFFSET        192  /* USB: TPH_AUD_BIAS  */
#define BSP_TWL3029_MAP_USB_TCR_INT_ACK_OFFSET         193  /* USB: TCR_INT_ACK  */
#define BSP_TWL3029_MAP_USB_TPH_MNLO_DET_OFFSET        194  /* USB: TPH_MNLO_DET  */
#define BSP_TWL3029_MAP_USB_TCR_UART_DET_MIN_OFFSET    195  /* USB: TCR_UART_DET_MIN  */
#define BSP_TWL3029_MAP_USB_TCR_UART_DET_MAX_OFFSET    196  /* USB: TCR_UART_DET_MAX  */
#define BSP_TWL3029_MAP_USB_TPH_STLO_DET_OFFSET        197  /* USB: TPH_STLO_DET  */
#define BSP_TWL3029_MAP_USB_TPH_ID_INT_PW_OFFSET       198  /* USB: TPH_ID_INT_PW  */
#define BSP_TWL3029_MAP_USB_TACC_ID_INT_WAIT_OFFSET    199  /* USB: TACC_ID_INT_WAIT  */
#define BSP_TWL3029_MAP_USB_TACC_ID_INT_PW_OFFSET      200  /* USB: TACC_ID_INT_PW  */
#define BSP_TWL3029_MAP_USB_TPH_CMD_WAIT_OFFSET        201  /* USB: TPH_CMD_WAIT  */
#define BSP_TWL3029_MAP_USB_TPH_ACK_WAIT_OFFSET        202  /* USB: TPH_ACK_WAIT  */
#define BSP_TWL3029_MAP_USB_TPH_DET_RST_OFFSET         203  /* USB: TPH_DET_RST  */
#define BSP_TWL3029_MAP_USB_TXVR_EN_TEST_SET_OFFSET    204  /* USB: TXVR_EN_TEST_SET  */
#define BSP_TWL3029_MAP_USB_TXVR_EN_TEST_CLR_OFFSET    205  /* USB: TXVR_EN_TEST_CLR  */
#define BSP_TWL3029_MAP_USB_VBUS_EN_TEST_OFFSET        206  /* USB: VBUS_EN_TEST  */
#define BSP_TWL3029_MAP_USB_ID_EN_TEST_OFFSET          207  /* USB: ID_EN_TEST  */
#define BSP_TWL3029_MAP_USB_PSM_EN_TEST_SET_OFFSET     208  /* USB: PSM_EN_TEST_SET  */
#define BSP_TWL3029_MAP_USB_PSM_EN_TEST_CLR_OFFSET     209  /* USB: PSM_EN_TEST_CLR  */


#define BSP_TWL3029_MAP_WLED_WLED_RES_TRIM_OFFSET    118  /* WLED: WLED_RES_TRIM */

#endif


