/*=============================================================================
 *    Copyright 2004 Texas Instruments Inc. All rights reserved.
 */
#ifndef BSP_TWL3029_PWR_LLIF_HEADER
#define BSP_TWL3029_PWR_LLIF_HEADER

#include "bspUtil_BitUtil.h"

#if (ANLG_PG == 1)
#include "pg1x/bspTwl3029_Pwr_Llif_pg1x.h"
#elif (ANLG_PG == 2)
#include "pg2x/bspTwl3029_Pwr_Llif_pg2x.h"
#endif

/*=============================================================================
 * Component Description:
 *    Provides accessor and manipulator macros for TWL3029 aka Triton
 *    register fields for BARPWR module. Fields offsets and widths are encoded in contants
 *    that are to be fed into simple macros. This common approach should
 *    help to prevent masking errors.
 *
 *    the BARINT registers consist of: 
 *     -  RTC registers
 *     -  power master registers registers
 *     -  power slave registers
 */


/*=================================================
 *     RTC registers
 */

/*=========BSP_TWL3029_LLIF_RTC_SECOND_REG=========
 */

#define BSP_TWL3029_LLIF_RTC_SECOND_REG_SEC0_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_SECOND_REG_SEC0_WIDTH       4

#define BSP_TWL3029_LLIF_RTC_SECOND_REG_SEC1_OFFSET      4       
#define BSP_TWL3029_LLIF_RTC_SECOND_REG_SEC1_WIDTH       3

/*=========BSP_TWL3029_LLIF_RTC_MINUTES_REG=========
 */

#define BSP_TWL3029_LLIF_RTC_MINUTES_REG_MIN0_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_MINUTES_REG_MIN0_WIDTH       4

#define BSP_TWL3029_LLIF_RTC_MINUTES_REG_MIN1_OFFSET      4       
#define BSP_TWL3029_LLIF_RTC_MINUTES_REG_MIN1_WIDTH       3
   


/*=========BSP_TWL3029_LLIF_RTC_HOURS_REG=========
 */
 
#define  BSP_TWL3029_LLIF_RTC_HOURS_REG_HOURS0_OFFSET     0
#define  BSP_TWL3029_LLIF_RTC_HOURS_REG_HOURS0_WIDTH      3

#define  BSP_TWL3029_LLIF_RTC_HOURS_REG_HOURS1_OFFSET     4
#define  BSP_TWL3029_LLIF_RTC_HOURS_REG_HOURS1_WIDTH      2

#define  BSP_TWL3029_LLIF_RTC_HOURS_REG_PM_nAM_OFFSET     7
#define  BSP_TWL3029_LLIF_RTC_HOURS_REG_PM_nAM_WIDTH      1



/*=========BSP_TWL3029_LLIF_RTC_DAYS_REG=========
 */

#define BSP_TWL3029_LLIF_RTC_DAYS_REG_DAY0_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_DAYS_REG_DAY0_WIDTH       4

#define BSP_TWL3029_LLIF_RTC_DAYS_REG_DAY1_OFFSET      4       
#define BSP_TWL3029_LLIF_RTC_DAYS_REG_DAY1_WIDTH       2
   



/*=========BSP_TWL3029_LLIF_RTC_MONTHS_REG=========
 */

#define BSP_TWL3029_LLIF_RTC_MONTHS_REG_MONTH0_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_MONTHS_REG_MONTH0_WIDTH       4

#define BSP_TWL3029_LLIF_RTC_MONTHS_REG_MONTH1_OFFSET      4       
#define BSP_TWL3029_LLIF_RTC_MONTHS_REG_MONTH1_WIDTH       1
   

/*=========BSP_TWL3029_LLIF_RTC_YEARS_REG=========
*/

#define BSP_TWL3029_LLIF_RTC_YEARS_REG_YEAR0_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_YEARS_REG_YEAR0_WIDTH       4

#define BSP_TWL3029_LLIF_RTC_YEARS_REG_YEAR1_OFFSET      4       
#define BSP_TWL3029_LLIF_RTC_YEARS_REG_YEAR1_WIDTH       4

/*=========BSP_TWL3029_LLIF_RTC_WEEK_REG=========
*/


#define BSP_TWL3029_LLIF_RTC_WEEK_REG_WEEK_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_WEEK_REG_WEEK_WIDTH       3


/*=========BSP_TWL3029_LLIF_RTC_RESERVED=========
*/
#define BSP_TWL3029_LLIF_RTC_RESERVED_1_OFFSET           0
#define BSP_TWL3029_LLIF_RTC_RESERVED_1_WIDTH            8 

/*=========BSP_TWL3029_LLIF_RTC_ALARM_SECONDS_REG=========
 */

#define BSP_TWL3029_LLIF_RTC_ALARM_SECONDS_REG_SEC0_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_ALARM_SECONDS_REG_SEC0_WIDTH       4

#define BSP_TWL3029_LLIF_RTC_ALARM_SECONDS_REG_SEC1_OFFSET      4       
#define BSP_TWL3029_LLIF_RTC_ALARM_SECONDS_REG_SEC1_WIDTH       3

/*=========BSP_TWL3029_LLIF_RTC_ALARM_MINUTES_REG=========
 */

#define BSP_TWL3029_LLIF_RTC_ALARM_MINUTES_REG_MIN0_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_ALARM_MINUTES_REG_MIN0_WIDTH       4

#define BSP_TWL3029_LLIF_RTC_ALARM_MINUTES_REG_MIN1_OFFSET      4       
#define BSP_TWL3029_LLIF_RTC_ALARM_MINUTES_REG_MIN1_WIDTH       3
   


/*=========BSP_TWL3029_LLIF_RTC_ALARM_HOURS_REG=========
 */
 
#define  BSP_TWL3029_LLIF_RTC_ALARM_HOURS_REG_HOURS0_OFFSET     0
#define  BSP_TWL3029_LLIF_RTC_ALARM_HOURS_REG_HOURS0_WIDTH      3

#define  BSP_TWL3029_LLIF_RTC_ALARM_HOURS_REG_HOURS1_OFFSET     4
#define  BSP_TWL3029_LLIF_RTC_ALARM_HOURS_REG_HOURS1_WIDTH      2

#define  BSP_TWL3029_LLIF_RTC_ALARM_HOURS_REG_PM_nAM_OFFSET     7
#define  BSP_TWL3029_LLIF_RTC_ALARM_HOURS_REG_PM_nAM_WIDTH      1



/*=========BSP_TWL3029_LLIF_RTC_ALARM_DAYS_REG=========
 */

#define BSP_TWL3029_LLIF_RTC_ALARM_DAYS_REG_DAY0_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_ALARM_DAYS_REG_DAY0_WIDTH       4

#define BSP_TWL3029_LLIF_RTC_ALARM_DAYS_REG_DAY1_OFFSET      4       
#define BSP_TWL3029_LLIF_RTC_ALARM_DAYS_REG_DAY1_WIDTH       2
   

/*=========BSP_TWL3029_LLIF_RTC_ALARM_MONTHS_REG=========
*/

#define BSP_TWL3029_LLIF_RTC_ALARM_MONTHS_REG_MONTH0_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_ALARM_MONTHS_REG_MONTH0_WIDTH       4

#define BSP_TWL3029_LLIF_RTC_ALARM_MONTHS_REG_MONTH1_OFFSET      4       
#define BSP_TWL3029_LLIF_RTC_ALARM_MONTHS_REG_MONTH1_WIDTH       1
   

/*=========BSP_TWL3029_LLIF_RTC_ALARM_YEARS_REG=========
*/

#define BSP_TWL3029_LLIF_RTC_ALARM_YEARS_REG_YEAR0_OFFSET      0    
#define BSP_TWL3029_LLIF_RTC_ALARM_YEARS_REG_YEAR0_WIDTH       4

#define BSP_TWL3029_LLIF_RTC_ALARM_YEARS_REG_YEAR1_OFFSET      4       
#define BSP_TWL3029_LLIF_RTC_ALARM_YEARS_REG_YEAR1_WIDTH       4


/*=========BSP_TWL3029_LLIF_RTC_RESERVED=========
*/
#define BSP_TWL3029_LLIF_RTC_RESERVED_2_OFFSET           0
#define BSP_TWL3029_LLIF_RTC_RESERVED_2_WIDTH            8 


#define BSP_TWL3029_LLIF_RTC_RESERVED_3_OFFSET           0
#define BSP_TWL3029_LLIF_RTC_RESERVED_3_WIDTH            8 

/*=========BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG=========
*/
#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_STOP_RTC_OFFSET            0
#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_STOP_RTC_WIDTH             1 

#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_ROUND_30S_OFFSET           1
#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_ROUND_30S_WIDTH            1 

#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_AUTO_COMP_OFFSET           2
#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_AUTO_COMP_WIDTH            1 

#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_MODE_12_24_OFFSET          3
#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_MODE_12_24_WIDTH           1 

#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_TEST_MODE_OFFSET           4
#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_TEST_MODE_WIDTH            1 

#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_SET_32_COUNTER_OFFSET      5
#define BSP_TWL3029_LLIF_RTC_RTC_CTRL_REG_SET_32_COUNTER_WIDTH       1 


/*=========BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG=========
*/

#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_RUN_OFFSET      1
#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_RUN_WIDTH       1 

#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_1S_EVENT_OFFSET      2
#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_1S_EVENT_WIDTH       1 

#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_1M_EVENT_OFFSET      3
#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_1M_EVENT_WIDTH       1 

#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_1H_EVENT_OFFSET      4
#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_1H_EVENT_WIDTH       1 

#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_1D_EVENT_OFFSET      5
#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_1D_EVENT_WIDTH       1 

#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_ALARM_OFFSET         6
#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_ALARM_WIDTH          1 

#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_POWER_UP_OFFSET      7
#define BSP_TWL3029_LLIF_RTC_RTC_STATUS_REG_POWER_UP_WIDTH       1 

 
/*=========BSP_TWL3029_LLIF_RTC_RTC_INTERRUPTS_REG=========*/

#define BSP_TWL3029_LLIF_RTC_RTC_INTERRUPTS_REG_EVERY_OFFSET         0
#define BSP_TWL3029_LLIF_RTC_RTC_INTERRUPTS_REG_EVERY_WIDTH          2 

#define BSP_TWL3029_LLIF_RTC_RTC_INTERRUPTS_REG_IT_TIMER_OFFSET      2
#define BSP_TWL3029_LLIF_RTC_RTC_INTERRUPTS_REG_IT_TIMER_WIDTH       1 

#define BSP_TWL3029_LLIF_RTC_RTC_INTERRUPTS_REG_IT_ALARM_OFFSET      3
#define BSP_TWL3029_LLIF_RTC_RTC_INTERRUPTS_REG_IT_ALARM_WIDTH       1 







/*=========BSP_TWL3029_LLIF_RTC_RTC_COMP_LSB_REG=========
*/

#define BSP_TWL3029_LLIF_RTC_RTC_COMP_LSB_REG_COMP_LSB_OFFSET      0
#define BSP_TWL3029_LLIF_RTC_RTC_COMP_LSB_REG_COMP_LSB_WIDTH       8 

/*=========BSP_TWL3029_LLIF_RTC_RTC_COMP_MSB_REG=========
*/

#define BSP_TWL3029_LLIF_RTC_RTC_COMP_MSB_REG_COMP_MSB_OFFSET      0
#define BSP_TWL3029_LLIF_RTC_RTC_COMP_MSB_REG_COMP_MSB_WIDTH       8 

/*=========BSP_TWL3029_LLIF_RTC_RTC_RES_PROG_REG=========
 */
 
#define  BSP_TWL3029_LLIF_RTC_RTC_RES_PROG_REG_SW_RES_PROG_OFFSET      0
#define  BSP_TWL3029_LLIF_RTC_RTC_RES_PROG_REG_SW_RES_PROG_WIDTH       5 


/*=========BSP_TWL3029_LLIF_RTC_RTC_RESET_STATUS_REG=========
 */
 
#define  BSP_TWL3029_LLIF_RTC_RTC_RESET_STATUS_REG_RESWON_STATUS_OFFSET      0
#define  BSP_TWL3029_LLIF_RTC_RTC_RESET_STATUS_REG_RESWON_STATUS_WIDTH       1 
 



/*=================================================
 *     POWER MASTER REGISTERS
 */

/*=========BSP_TWL3029_LLIF_PMC_MASTER_GP_CFG=========
 */
#define  BSP_TWL3029_LLIF_PMC_MASTER_GP_CFG_PAD_CONT_EN_OFFSET      0
#define  BSP_TWL3029_LLIF_PMC_MASTER_GP_CFG_PAD_CONT_EN_WIDTH       1 



/*=========BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB=========
*/

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CMCLK1PD_OFFSET      0
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CMCLK1PD_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CPCLKREQPD_OFFSET      2
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CPCLKREQPD_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CWAKEUP1PD_OFFSET      3
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CWAKEUP1PD_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CWAKEUP2PD_OFFSET      4
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CWAKEUP2PD_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CHSDETPU7VZ_OFFSET      5
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CHSDETPU7VZ_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CRPWONPU7VZ_OFFSET      6
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CRPWONPU7VZ_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CPWONPU7VZ_OFFSET      7
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_MSB_CPWONPU7VZ_WIDTH       1 



 
/*=========BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB=========
 */
 
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CPMPUZ_OFFSET      0
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CPMPUZ_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CVMODEPD_OFFSET      1
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CVMODEPD_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CSE0VMTXDPD_OFFSET      2
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CSE0VMTXDPD_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CDATVPRXDPD_OFFSET      3
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CDATVPRXDPD_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_COEINTNPD_OFFSET      4
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_COEINTNPD_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CTDIPUZ_OFFSET      5
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CTDIPUZ_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CTMSPUZ_OFFSET      6
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CTMSPUZ_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CTCKPD_OFFSET      7
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB_CTCKPD_WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB__OFFSET      0
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB__WIDTH       1 

#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB__OFFSET      0
#define  BSP_TWL3029_LLIF_PMC_MASTER_CFG_PU_PD_LSB__WIDTH       1 


/*=========BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_P1_MSK_PWON_OFFSET    0
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_P1_MSK_PWON_WIDTH     1

#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_P1_MSK_RPWON_OFFSET   1 
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_P1_MSK_RPWON_WIDTH    1 

#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_P1_MSK_CHG_OFFSET     2
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_P1_MSK_CHG_WIDTH      1

#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_P1_MSK_USB_OFFSET     3
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_P1_MSK_USB_WIDTH      1

#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_P1_MSK_RTC_OFFSET     4
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_P1_MSK_RTC_WIDTH      1

#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_WAKEUP_OFFSET         7
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_CFG_TRANSITION_WAKEUP_WIDTH          1
//start
/*=========BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_P2_MSK_PWON_OFFSET    0
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_P2_MSK_PWON_WIDTH     1

#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_P2_MSK_RPWON_OFFSET   1 
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_P2_MSK_RPWON_WIDTH    1 

#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_P2_MSK_CHG_OFFSET     2
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_P2_MSK_CHG_WIDTH      1

#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_P2_MSK_USB_OFFSET     3
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_P2_MSK_USB_WIDTH      1

#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_P2_MSK_RTC_OFFSET     4
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_P2_MSK_RTC_WIDTH      1

#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_WAKEUP_OFFSET         7
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_CFG_TRANSITION_WAKEUP_WIDTH          1



/*=========BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION=========
*/ 
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_MSK_PWON_OFFSET     0
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_MSK_PWON_WIDTH      1

#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_MSK_RPWON_OFFSET    1
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_MSK_RPWON_WIDTH     1

#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_MSK_CHG_OFFSET      2
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_MSK_CHG_WIDTH       1
  
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_MSK_USB_OFFSET      3
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_MSK_USB_WIDTH       1
    
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_MSK_RTC_OFFSET      4
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_MSK_RTC_WIDTH       1

#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_LVL_WAKEUP_OFFSET   7 
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_CFG_TRANSITION_P3_LVL_WAKEUP_WIDTH    1 


/*=========BSP_TWL3029_LLIF_PMC_MASTER_P123_CFG_TRANSITION=========
 */
 
#define BSP_TWL3029_LLIF_PMC_MASTER_P123_CFG_TRANSITION_P123_LVL_RPWON_OFFSET    0
#define BSP_TWL3029_LLIF_PMC_MASTER_P123_CFG_TRANSITION_P123_LVL_RPWON_WIDTH     1 

/*=========BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_PWON_OFFSET         0
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_PWON_WIDTH          1
 
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_RPWON_OFFSET        1
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_RPWON_WIDTH         1
 
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_CHG_OFFSET          2
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_CHG_WIDTH           1
 
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_USB_OFFSET          3
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_USB_WIDTH           1
 
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_WAKEUP1_OFFSET      4
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_WAKEUP1_WIDTH       1
 
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_WAKEUP2_OFFSET      5
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_WAKEUP2_WIDTH       1
 
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_WAKEUP3_OFFSET      6
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_WAKEUP3_WIDTH       1
 
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_VBATOK_OFFSET      7
#define BSP_TWL3029_LLIF_PMC_MASTER_STS_HW_CONDITIONS_STS_VBATOK_WIDTH       1
 
 
/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_P123_STATE=========
 */
 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_P123_STATE_SEQ_P1_STATE_OFFSET    0 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_P123_STATE_SEQ_P1_STATE_WIDTH     2
 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_P123_STATE_SEQ_P2_STATE_OFFSET    2
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_P123_STATE_SEQ_P2_STATE_WIDTH     2
 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_P123_STATE_SEQ_P3_STATE_OFFSET    4
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_P123_STATE_SEQ_P3_STATE_WIDTH     2
 

 
/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_SEQ_OFFSYNC_OFFSET            0
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_SEQ_OFFSYNC_WIDTH            1 

#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_SEQ_FREEZE_OFFSET            1
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_SEQ_FREEZE_WIDTH             1 
  
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_SEQ_MSK_VBAT_CMP_OFFSET      2
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_SEQ_MSK_VBAT_CMP_WIDTH       1 
 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_SEQ_MSK_VBAT_PRE_OFFSET      3
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_SEQ_MSK_VBAT_PRE_WIDTH       1 
  
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_STS_P3_STATE_STABLE_OFFSET   4
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_STS_P3_STATE_STABLE_WIDTH    1 
 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_STS_P2_STATE_STABLE_OFFSET   5
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_STS_P2_STATE_STABLE_WIDTH    1 
  
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_STS_P1_STATE_STABLE_OFFSET   6
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_STS_P1_STATE_STABLE_WIDTH    1 
 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_STS_P123_STATE_STABLE_OFFSET 7
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_MODE_STS_P123_STATE_STABLE_WIDTH  1 
  
 
 
/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_TRANSITION=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_TRANSITION_SEQ_MSK_BACKUP_OFFSET        0
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_TRANSITION_SEQ_MSK_BACKUP_WIDTH         1
 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_TRANSITION_SEQ_R_PWON_FASTDEB_OFFSET    1
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_TRANSITION_SEQ_R_PWON_FASTDEB_WIDTH     1

#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_TRANSITION_SEQ_STEP_DIV_OFFSET          2
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_TRANSITION_SEQ_STEP_DIV_WIDTH           2
 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_TRANSITION_STS_BACKUP_OFFSET            7
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_CFG_TRANSITION_STS_BACKUP_WIDTH             1



/*=========BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG=========
*/

#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_PB_P123_BW_OFFSET          0  
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_PB_P123_BW_WIDTH           2  

#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_PB_CLK_CFG_OFFSET          2  
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_PB_CLK_CFG_WIDTH           2

#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_PB_PMF_DLY_OFFSET          4  
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_PB_PMF_DLY_WIDTH           1  

/*=========BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_I2C=========
 */
 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_I2C_PB_I2C_BWEN_OFFSET         0  
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_I2C_PB_I2C_BWEN_WIDTH          1 
 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_I2C_PB_I2C_LGHT_OFFSET         1 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_I2C_PB_I2C_LGHT_WIDTH          2

#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_I2C_STS_PB_I2C_BUSY_OFFSET     7 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_I2C_STS_PB_I2C_BUSY_WIDTH      1 


/*=========BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST=========
 */
 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_PB_SHUTDOWN_REN_OFFSET     0  
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_PB_SHUTDOWN_REN_WIDTH      1
 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_PB_CLK_INV_OFFSET          1  
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_PB_CLK_INV_WIDTH           1

#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_PB_MSK_MASTER_AUTO_OFFSET  2  
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_PB_MSK_MASTER_AUTO_WIDTH   1 
 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_PB_MASTER_EXT_OFFSET       3 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_PB_MASTER_EXT_WIDTH        1

#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_RESET_GEN_TR_OFFSET        4  
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_RESET_GEN_TR_WIDTH         1 
 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_SETUP_DONE_OFFSET          5  
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_SETUP_DONE_WIDTH           1

#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_START_MODE_OFFSET          7  
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_CFG_TEST_START_MODE_WIDTH           1    
 

/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_O2C=========
*/ 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_O2C_SEQ_MEM_O2C_OFFSET         0
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_O2C_SEQ_MEM_O2C_WIDTH          6

/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_C2A=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_C2A_SEQ_MEM_C2A_OFFSET         0
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_C2A_SEQ_MEM_C2A_WIDTH          6


/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_A2O=========
 */
  
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_A2O_SEQ_MEM_A2O_OFFSET         0  
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_A2O_SEQ_MEM_A2O_WIDTH          6 

/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_A2S=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_A2S_SEQ_MEM_A2S_OFFSET         0  
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_A2S_SEQ_MEM_A2S_WIDTH          6 
 
/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_S2A=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_S2A_SEQ_MEM_S2A_OFFSET         0  
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_S2A_SEQ_MEM_S2A_WIDTH          6  

/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_C2O=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_C2O_SEQ_MEM_C2O_OFFSET         0  
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_C2O_SEQ_MEM_C2O_WIDTH          6  

/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_ADD=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_ADD_SEQ_MEM_ADD_OFFSET         0  
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_ADD_SEQ_MEM_ADD_WIDTH          8 

/*=========BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_DATA=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_DATA_SEQ_MEM_DATA_OFFSET       0 
#define BSP_TWL3029_LLIF_PMC_MASTER_SEQ_MEM_DATA_SEQ_MEM_DATA_WIDTH        8 

/*=========BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_PKEY=========
*/
#define BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_PKEY_PKEY_OFFSET               0  
#define BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_PKEY_PKEY_WIDTH                8  

/*=========BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_TKEY=========
*/
#define BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_TKEY_TKEY_OFFSET               0  
#define BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_TKEY_TKEY_WIDTH                8
  
/*=========BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_EN=========
*/
#define BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_EN_PWEN_OFFSET           0  
#define BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_EN_PWEN_WIDTH            1
 
#define BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_EN_TRWEN_OFFSET          4  
#define BSP_TWL3029_LLIF_PMC_MASTER_PROTECT_EN_TRWEN_WIDTH           1


/*=========BSP_TWL3029_LLIF_PMC_MASTER_P1_DEV=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_DEV_P1_DEVOFF_OFFSET          0 
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_DEV_P1_DEVOFF_WIDTH           1 

#define BSP_TWL3029_LLIF_PMC_MASTER_P1_DEV_P1_DEVSLP_OFFSET          1 
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_DEV_P1_DEVSLP_WIDTH           1

#define BSP_TWL3029_LLIF_PMC_MASTER_P1_DEV_P1_DEVACT_OFFSET          2 
#define BSP_TWL3029_LLIF_PMC_MASTER_P1_DEV_P1_DEVACT_WIDTH           1


/*=========BSP_TWL3029_LLIF_PMC_MASTER_P2_DEV=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_DEV_P2_DEVOFF_OFFSET          0 
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_DEV_P2_DEVOFF_WIDTH           1 

#define BSP_TWL3029_LLIF_PMC_MASTER_P2_DEV_P2_DEVSLP_OFFSET          1 
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_DEV_P2_DEVSLP_WIDTH           1

#define BSP_TWL3029_LLIF_PMC_MASTER_P2_DEV_P2_DEVACT_OFFSET          2 
#define BSP_TWL3029_LLIF_PMC_MASTER_P2_DEV_P2_DEVACT_WIDTH           1

/*=========BSP_TWL3029_LLIF_PMC_MASTER_P3_DEV=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_DEV_P3_DEVOFF_OFFSET          0 
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_DEV_P3_DEVOFF_WIDTH           1 

#define BSP_TWL3029_LLIF_PMC_MASTER_P3_DEV_P3_DEVSLP_OFFSET          1 
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_DEV_P3_DEVSLP_WIDTH           1

#define BSP_TWL3029_LLIF_PMC_MASTER_P3_DEV_P3_DEVACT_OFFSET          2 
#define BSP_TWL3029_LLIF_PMC_MASTER_P3_DEV_P3_DEVACT_WIDTH           1

 
 
 
/*=========BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_A=========
*/
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_A_PB_I2C_WORD_A_OFFSET   0 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_A_PB_I2C_WORD_A_WIDTH    8


/*=========BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_B=========
*/
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_B_PB_I2C_WORD_B_OFFSET   0 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_B_PB_I2C_WORD_B_WIDTH    8

/*=========BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_C=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_C_PB_I2C_WORD_C_OFFSET   0 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_C_PB_I2C_WORD_C_WIDTH    8

/*=========BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_D=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_D_PB_I2C_WORD_D_OFFSET   0 
#define BSP_TWL3029_LLIF_PMC_MASTER_PB_I2C_WORD_D_PB_I2C_WORD_D_WIDTH    8

/*=========BSP_TWL3029_LLIF_PMC_MASTER_RESERVED=========
 */
#define BSP_TWL3029_LLIF_PMC_MASTER_RESERVED_1_OFFSET  0
#define BSP_TWL3029_LLIF_PMC_MASTER_RESERVED_1_WIDTH   8

/*=================================================
 *     POWER SLAVE REGISTERS
 */
 
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_RECEIVER_CFG=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_RECEIVER_CFG_PB_SHUTDOWN_REN_OFFSET    0
#define BSP_TWL3029_LLIF_PMC_SLAVE_RECEIVER_CFG_PB_SHUTDOWN_REN_WIDTH     1
 
#define BSP_TWL3029_LLIF_PMC_SLAVE_RECEIVER_CFG_LDO_TEST_MODE_OFFSET      2
#define BSP_TWL3029_LLIF_PMC_SLAVE_RECEIVER_CFG_LDO_TEST_MODE_WIDTH       5


 
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_PROTECT_SKEY=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_PROTECT_SKEY_SKEY_OFFSET     0  
#define BSP_TWL3029_LLIF_PMC_SLAVE_PROTECT_SKEY_SKEY_WIDTH      8


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_MES_BB_OFFSET        0
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_MES_BB_WIDTH         1
 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_BBSEL_OFFSET         1  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_BBSEL_WIDTH          2

#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_BBCHGEN_OFFSET       3 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_BBCHGEN_WIDTH        1
 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_VRTCPWEN_OFFSET      4  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_VRTCPWEN_WIDTH       1

#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_TEN_VRRTC_OFFSET     5 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_TEN_VRRTC_WIDTH      1
 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_TEN_BBSUPR_OFFSET    6  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_TEN_BBSUPR_WIDTH     1

#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_TEN_BBSPOR_OFFSET    7  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BBSPOR_CFG_TEN_BBSPOR_WIDTH     1

 
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_STS_RES_STATE_OFFSET        0  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_STS_RES_STATE_WIDTH         4
 

#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_STS_DEV_GRP_OFFSET          5 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_STS_DEV_GRP_WIDTH           3


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_RES_ID=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_RES_ID_RES_ID_OFFSET            0  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_RES_ID_RES_ID_WIDTH             8
  

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_STATE_SLEEP_STATE_OFFSET    0  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_STATE_SLEEP_STATE_WIDTH     4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_STATE_OFF_STATE_OFFSET      4 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_STATE_OFF_STATE_WIDTH       4

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VMODE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VMODE_VMODE_STEP_0_OFFSET   0
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VMODE_VMODE_STEP_0_WIDTH    6
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VMODE_VMODE_EN_OFFSET       6 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VMODE_VMODE_EN_WIDTH        1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VMODE_VRDBB_TESTEN_OFFSET   7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VMODE_VRDBB_TESTEN_WIDTH    1
 
 
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VSEL=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VSEL_CLK_ACTIVE_MODE_OFFSET 5 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VSEL_CLK_ACTIVE_MODE_WIDTH  1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VSEL_CLK_SLP_MODE_OFFSET    6 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VSEL_CLK_SLP_MODE_WIDTH     1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VSEL_REG_NCTL_OFFSET        7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_VSEL_REG_NCTL_WIDTH         1

 
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_ROOF=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_ROOF_STS_BUSY_OFFSET        6
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_ROOF_STS_BUSY_WIDTH         1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_ROOF_STS_ROOF_OFFSET        7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_ROOF_STS_ROOF_WIDTH         1

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_FLOOR=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_FLOOR_VRDBB_SLP_OFFSET      5 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_FLOOR_VRDBB_SLP_WIDTH       1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_FLOOR_STS_BUSY_OFFSET       6 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_FLOOR_STS_BUSY_WIDTH        1 

#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_FLOOR_STS_FLOOR_OFFSET      7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_FLOOR_STS_FLOOR_WIDTH       1

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_0=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_0_VCORE_TRIM_OFFSET    0         /* TRIM LSBs ( bits 0 - 7) */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_0_VCORE_TRIM_WIDTH     8 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_0__OFFSET  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_0__WIDTH

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_1========= 
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_1_VCORE_TRIM_OFFSET    0        /* TRIM MSBs ( bits 8 - 15) */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_1_VCORE_TRIM_WIDTH     8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_2=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_2_VCORE_TRIM_16_OFFSET  0        /* TRIM MSB ( bit 16) */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_2_VCORE_TRIM_16_WIDTH   1
 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_2_VRDBB_TESTREG_OFFSET  1 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_2_VRDBB_TESTREG_WIDTH   6

#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_2_VRDBB_CKINEN_OFFSET   7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VCORE_CFG_TRIM_2_VRDBB_CKINEN_WIDTH    1

/*=========   PMC_SLAVE_VRSIM   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_DEDICATED=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_DEDICATED_VSEL_OFFSET           0        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_DEDICATED_VSEL_WIDTH            1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_DEDICATED_VRSIM_TESTEN_OFFSET   7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_DEDICATED_VRSIM_TESTEN_WIDTH    1


/*=========   PMC_SLAVE_VRMMC   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_DEDICATED=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_DEDICATED_VSEL_OFFSET           0        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_DEDICATED_VSEL_WIDTH            1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_DEDICATED_VRMMC_TESTEN_OFFSET   7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMMC_CFG_DEDICATED_VRMMC_TESTEN_WIDTH    1


/*=========   PMC_SLAVE_VREXTH   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_DEDICATED=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_DEDICATED_VSEL_OFFSET           0        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_DEDICATED_VSEL_WIDTH            1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_DEDICATED_VREXTH_TESTEN_OFFSET   7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTH_CFG_DEDICATED_VREXTH_TESTEN_WIDTH    1

/*=========   PMC_SLAVE_VRPLL   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_DEDICATED=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_DEDICATED_VSEL_OFFSET           0        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_DEDICATED_VSEL_WIDTH            2

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_DEDICATED_VRPLL_TESTEN_OFFSET   7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRPLL_CFG_DEDICATED_VRPLL_TESTEN_WIDTH    1


/*=========   PMC_SLAVE_VRIO   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_DEDICATED=========
 */

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_DEDICATED_VRIO_TESTEN_OFFSET    7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRIO_CFG_DEDICATED_VRIO_TESTEN_WIDTH     1



/*=========   PMC_SLAVE_VRMEM   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_DEDICATED=========
 */

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_DEDICATED_VRMEM_TESTEN_OFFSET   7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRMEM_CFG_DEDICATED_VRMEM_TESTEN_WIDTH    1


/*=========   PMC_SLAVE_VRUSB   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_DEDICATED=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_DEDICATED_LVS_USB2IO_AUTO_OFFSET  0        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_DEDICATED_LVS_USB2IO_AUTO_WIDTH   1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_DEDICATED_LVS_USB2IO_EN_OFFSET    1        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_DEDICATED_LVS_USB2IO_EN_WIDTH     1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_DEDICATED_VRUSB_TESTEN_OFFSET   7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRUSB_CFG_DEDICATED_VRUSB_TESTEN_WIDTH    1



/*=========   PMC_SLAVE_VRABB  ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED_BIASABB_AUTO_OFFSET     0        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED_BIASABB_AUTO_WIDTH      1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED_BIASABB_EN_OFFSET       1        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED_BIASABB_EN_WIDTH        1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED_LVS_ABB2IO_AUTO_OFFSET  2        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED_LVS_ABB2IO_AUTO_WIDTH   1

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED_LVS_ABB2IO_EN_OFFSET    3        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED_LVS_ABB2IO_EN_WIDTH     1


#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED_VRABB_TESTEN_OFFSET     7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRABB_CFG_DEDICATED_VRABB_TESTEN_WIDTH      1


/*=========   PMC_SLAVE_VRVBUS   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_DEDICATED=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_DEDICATED_VRVBUS_TRIM_RAMP_OFFSET  0        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_DEDICATED_VRVBUS_TRIM_RAMP_WIDTH   4                    

#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_DEDICATED_VRVBUS_CKINEN_OFFSET     4        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_DEDICATED_VRVBUS_CKINEN_WIDTH      1


#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_DEDICATED_VRVBUS_TESTEN_OFFSET   7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRVBUS_CFG_DEDICATED_VRVBUS_TESTEN_WIDTH    1



/*=========   PMC_SLAVE_VREXTL   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_DEDICATED=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_DEDICATED_ACTIVE_VSEL_OFFSET    0        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_DEDICATED_ACTIVE_VSEL_WIDTH     2

#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_DEDICATED_SLEEP_VSEL_OFFSET     2                        
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_DEDICATED_SLEEP_VSEL_WIDTH      2      

#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_DEDICATED_VREXTL_TESTEN_OFFSET  7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VREXTL_CFG_DEDICATED_VREXTL_TESTEN_WIDTH   1



/*=========   PMC_SLAVE_EXT_REGEN   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_EXT_REGEN_CFG_STATE_OFF_STATE_WIDTH           4


/*=========   PMC_SLAVE_CBAT32   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_CBAT32_CFG_STATE_OFF_STATE_WIDTH           4



/*=========   PMC_SLAVE_BGAP   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_DEDICATED=========
 */

#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_DEDICATED_BGTRIM_OFFSET         0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_DEDICATED_BGTRIM_WIDTH          5

#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_DEDICATED_BG85EN_OFFSET         5       
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_DEDICATED_BG85EN_WIDTH          1

#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_DEDICATED_BGAP_TESTEN_OFFSET    7  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGAP_CFG_DEDICATED_BGAP_TESTEN_WIDTH     1 


/*=========   PMC_SLAVE_BGSLP   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_CFG_STS_RES_STATE_WIDTH	     4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_BGSLP_CFG_STATE_OFF_STATE_WIDTH           4


/*=========   PMC_SLAVE_TSHUTDOWN   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_STATE_OFF_STATE_WIDTH           4


/*=========BSP_TWL3029_LLIF_PMC_SLAVE_VRSIM_CFG_DEDICATED=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_HDSEL_OFFSET    0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_HDSEL_WIDTH     2

#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_MASK_OFFSET     2  
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_MASK_WIDTH      1

#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_TS_OFFSET       3  
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_TS_WIDTH        1 

#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_HD_OFFSET       4
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_HD_WIDTH        1

#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_TEST_TS_OFFSET  6  
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_TEST_TS_WIDTH   1

#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_TEST_HD_OFFSET  7 
#define BSP_TWL3029_LLIF_PMC_SLAVE_TSHUTDOWN_CFG_DEDICATED_THERM_TEST_HD_WIDTH   1



/*=========   PMC_SLAVE_BIAS   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_BIAS_CFG_STATE_OFF_STATE_WIDTH           4



/*=========   PMC_SLAVE_CLKON   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_CLKON_CFG_STATE_OFF_STATE_WIDTH           4


/*=========   PMC_STATE_MNGT   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_STATE_MNGT_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_STATE_MNGT_CFG_STS_RES_STATE_OFFSET       0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_STATE_MNGT_CFG_STS_RES_STATE_WIDTH        4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_STATE_MNGT_CFG_STS_DEV_GRP_OFFSET         5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_STATE_MNGT_CFG_STS_DEV_GRP_WIDTH          3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_MNGT_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_STATE_MNGT_RES_ID_RES_ID_OFFSET           0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_STATE_MNGT_RES_ID_RES_ID_WIDTH            8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_MNGT_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_STATE_MNGT_CFG_STATE_SLEEP_STATE_OFFSET   0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_STATE_MNGT_CFG_STATE_SLEEP_STATE_WIDTH    4

#define BSP_TWL3029_LLIF_PMC_SLAVE_STATE_MNGT_CFG_STATE_OFF_STATE_OFFSET     4
#define BSP_TWL3029_LLIF_PMC_SLAVE_STATE_MNGT_CFG_STATE_OFF_STATE_WIDTH      4


/*=========   PMC_SLAVE_SLEEP_MNGT   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_MNGT_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_CFG_STS_RES_STATE_OFFSET            0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_CFG_STS_RES_STATE_WIDTH             4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_CFG_STS_MSK_EN_OFFSET               4 
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_CFG_STS_MSK_EN_WIDTH                1
 
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_CFG_STS_DEV_GRP_OFFSET              5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_CFG_STS_DEV_GRP_WIDTH               3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_MNGT_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_RES_ID_RES_ID_OFFSET                0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_RES_ID_RES_ID_WIDTH                 8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_MNGT_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_CFG_STATE_SLEEP_STATE_OFFSET        0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_CFG_STATE_SLEEP_STATE_WIDTH         4

#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_CFG_STATE_OFF_STATE_OFFSET          4
#define BSP_TWL3029_LLIF_PMC_SLAVE_SLEEP_MNGT_CFG_STATE_OFF_STATE_WIDTH           4



/*=========   PMC_SLAVE_BAT_PRES_CHECK   ============================
 */
/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_CFG_STS=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_CFG_STS_RES_STATE_OFFSET      0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_CFG_STS_RES_STATE_WIDTH       4
  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_CFG_STS_DEV_GRP_OFFSET        5  
#define BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_CFG_STS_DEV_GRP_WIDTH         3

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_RES_ID=========
*/
#define BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_RES_ID_RES_ID_OFFSET          0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_RES_ID_RES_ID_WIDTH           8 

/*=========BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_CFG_STATE=========
 */
#define BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_CFG_STATE_SLEEP_STATE_OFFSET  0 
#define BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_CFG_STATE_SLEEP_STATE_WIDTH   4

#define BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_CFG_STATE_OFF_STATE_OFFSET    4
#define BSP_TWL3029_LLIF_PMC_SLAVE_BAT_PRES_CHECK_CFG_STATE_OFF_STATE_WIDTH     4

#endif

