/**
 * @file	usb_env.h
 *
 * Declarations of the Riviera Generic Functions 
 *
 * @author	 ()
 * @version 0.1
 */

/*
 * History:
 *
 *	Date       	Author					Modification
 *	-------------------------------------------------------------------
 *	6/17/2003	 ()		Create.
 *
 * (C) Copyright 2003 by Texas Instruments Incorporated, All Rights Reserved
 */


#ifndef __USB_W2FC_DEF_H__
#define __USB_W2FC_DEF_H__


/* MACRO TO ACCESS REGISTERS AND MEMORY */
#define USB_REG(A)	(*(volatile UINT16*)(A))	/* Let op, als je een 16 bit addressering hebt.*/
#define USB_REG8(A)	(*(volatile UINT8*)(A))		/* Let op, als je een 8 bit addressering hebt.*/

/* DEBUG */
#define USB_REG16_ASSIGN(REG16, VAL16) \
do { (REG16) = (VAL16); } while(0)
// do { rvf_send_trace(#REG16, sizeof(#REG16)-1, (VAL16), RV_TRACE_LEVEL_WARNING, USB_USE_ID); REG16 = (VAL16); } while(0)


#define USB_W2FC_BASE_ADDR		0xFFFFB000

//**********************************************************************
// Register Offset
//**********************************************************************
#define W2FC_REV_OFFSET			0x00	// #define W2FC_REV_OFFSET			0x00
#define W2FC_EP_NUM_OFFSET		0x02	// #define W2FC_EP_NUM_OFFSET		0x04
#define W2FC_DATA_OFFSET		0x04	// #define W2FC_DATA_OFFSET		0x08
#define W2FC_CTRL_OFFSET		0x06	// #define W2FC_CTRL_OFFSET		0x0C
#define W2FC_STAT_FLG_OFFSET	0x08	// #define W2FC_STAT_FLG_OFFSET	0x10
#define W2FC_RXFSTAT_OFFSET		0x0A	// #define W2FC_RXFSTAT_OFFSET		0x14
#define W2FC_SYSCON1_OFFSET		0x0C	// #define W2FC_SYSCON1_OFFSET		0x18
#define W2FC_SYSCON2_OFFSET		0x0E	// #define W2FC_SYSCON2_OFFSET		0x1C
#define W2FC_DEVSTAT_OFFSET		0x10	// #define W2FC_DEVSTAT_OFFSET		0x20
#define W2FC_SOF_OFFSET			0x12	// #define W2FC_SOF_OFFSET			0x24
#define W2FC_IRQ_EN_OFFSET		0x14	// #define W2FC_IRQ_EN_OFFSET		0x28
#define W2FC_DMA_IRQ_EN_OFFSET	0x16	// #define W2FC_DMA_IRQ_EN_OFFSET	0x2C
#define W2FC_IRQ_SRC_OFFSET		0x18	// #define W2FC_IRQ_SRC_OFFSET		0x30
#define W2FC_EPN_STAT_OFFSET	0x1A	// #define W2FC_EPN_STAT_OFFSET	0x34
#define W2FC_DMAN_STAT_OFFSET	0x1C	// #define W2FC_DMAN_STAT_OFFSET	0x38
// #define W2FC_RESERVED0			0x1E	// //	#define W2FC_RESERVED0			0x3C
#define W2FC_RXDMA_CFG_OFFSET	0x20	// #define W2FC_RXDMA_CFG_OFFSET	0x40
#define W2FC_TXDMA_CFG_OFFSET	0x22	// #define W2FC_TXDMA_CFG_OFFSET	0x44
#define W2FC_DATA_DMA_OFFSET	0x24	// #define W2FC_DATA_DMA_OFFSET	0x48
// #define W2FC_RESERVED1			0x26	// //	#define W2FC_RESERVED1			0x4C
#define W2FC_TXDMA0_OFFSET		0x28	// #define W2FC_TXDMA0_OFFSET		0x50
#define W2FC_TXDMA1_OFFSET		0x2A	// #define W2FC_TXDMA1_OFFSET		0x54
#define W2FC_TXDMA2_OFFSET		0x2C	// #define W2FC_TXDMA2_OFFSET		0x58
// #define W2FC_RESERVED2			0x2E	// //	#define W2FC_RESERVED2			0x5C
#define W2FC_RXDMA0_OFFSET		0x30	// #define W2FC_RXDMA0_OFFSET		0x60
#define W2FC_RXDMA1_OFFSET		0x32	// #define W2FC_RXDMA1_OFFSET		0x64
#define W2FC_RXDMA2_OFFSET		0x34	// #define W2FC_RXDMA2_OFFSET		0x68
// #define W2FC_RESERVED3			0x36	// // #define W2FC_RESERVED3			0x6C
// #define W2FC_RESERVED4			0x38	// // #define W2FC_RESERVED4			0x70
// #define W2FC_RESERVED5			0x3A	// // #define W2FC_RESERVED5			0x74
#define W2FC_USB_TEST_1_OFFSET	0x3C	// #define W2FC_USB_TEST_1_OFFSET	0x78
#define W2FC_USB_TEST_2_OFFSET	0x3E	// #define W2FC_USB_TEST_2_OFFSET	0x7C
#define W2FC_EP0_OFFSET			0x40	// #define W2FC_EP0_OFFSET			0x80
#define W2FC_EP1_RX_OFFSET		0x42	// #define W2FC_EP1_RX_OFFSET		0x84
#define W2FC_EP2_RX_OFFSET		0x44	// #define W2FC_EP2_RX_OFFSET		0x88
#define W2FC_EP3_RX_OFFSET		0x46	// #define W2FC_EP3_RX_OFFSET		0x8C
#define W2FC_EP4_RX_OFFSET		0x48	// #define W2FC_EP4_RX_OFFSET		0x90
#define W2FC_EP5_RX_OFFSET		0x4A	// #define W2FC_EP5_RX_OFFSET		0x94
#define W2FC_EP6_RX_OFFSET		0x4C	// #define W2FC_EP6_RX_OFFSET		0x98
#define W2FC_EP7_RX_OFFSET		0x4E	// #define W2FC_EP7_RX_OFFSET		0x9C
#define W2FC_EP8_RX_OFFSET		0x50	// #define W2FC_EP8_RX_OFFSET		0xA0
#define W2FC_EP9_RX_OFFSET		0x52	// #define W2FC_EP9_RX_OFFSET		0xA4
#define W2FC_EP10_RX_OFFSET		0x54	// #define W2FC_EP10_RX_OFFSET		0xA8
#define W2FC_EP11_RX_OFFSET		0x56	// #define W2FC_EP11_RX_OFFSET		0xAC
#define W2FC_EP12_RX_OFFSET		0x58	// #define W2FC_EP12_RX_OFFSET		0xB0
#define W2FC_EP13_RX_OFFSET		0x5A	// #define W2FC_EP13_RX_OFFSET		0xB4
#define W2FC_EP14_RX_OFFSET		0x5C	// #define W2FC_EP14_RX_OFFSET		0xB8
#define W2FC_EP15_RX_OFFSET		0x5E	// #define W2FC_EP15_RX_OFFSET		0xBC
// #define W2FC_RESERVED6			0x60	// // #define W2FC_RESERVED6			0xC0
#define W2FC_EP1_TX_OFFSET		0x62	// #define W2FC_EP1_TX_OFFSET		0xC4
#define W2FC_EP2_TX_OFFSET		0x64	// #define W2FC_EP2_TX_OFFSET		0xC8
#define W2FC_EP3_TX_OFFSET		0x66	// #define W2FC_EP3_TX_OFFSET		0xCC
#define W2FC_EP4_TX_OFFSET		0x68	// #define W2FC_EP4_TX_OFFSET		0xD0
#define W2FC_EP5_TX_OFFSET		0x6A	// #define W2FC_EP5_TX_OFFSET		0xD4
#define W2FC_EP6_TX_OFFSET		0x6C	// #define W2FC_EP6_TX_OFFSET		0xD8
#define W2FC_EP7_TX_OFFSET		0x6E	// #define W2FC_EP7_TX_OFFSET		0xDC
#define W2FC_EP8_TX_OFFSET		0x70	// #define W2FC_EP8_TX_OFFSET		0xE0
#define W2FC_EP9_TX_OFFSET		0x72	// #define W2FC_EP9_TX_OFFSET		0xE4
#define W2FC_EP10_TX_OFFSET		0x74	// #define W2FC_EP10_TX_OFFSET		0xE8
#define W2FC_EP11_TX_OFFSET		0x76	// #define W2FC_EP11_TX_OFFSET		0xEC
#define W2FC_EP12_TX_OFFSET		0x78	// #define W2FC_EP12_TX_OFFSET		0xF0
#define W2FC_EP13_TX_OFFSET		0x7A	// #define W2FC_EP13_TX_OFFSET		0xF4
#define W2FC_EP14_TX_OFFSET		0x7C	// #define W2FC_EP14_TX_OFFSET		0xF8
#define W2FC_EP15_TX_OFFSET		0x7E	// #define W2FC_EP15_TX_OFFSET		0xFC

//**********************************************************************
// W2FC Register
//**********************************************************************
#define W2FC_REV			USB_REG( USB_W2FC_BASE_ADDR + W2FC_REV_OFFSET )
#define W2FC_EP_NUM			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP_NUM_OFFSET )
#define W2FC_DATA			USB_REG( USB_W2FC_BASE_ADDR + W2FC_DATA_OFFSET )	/*16 bits adressing of fifo*/
#define W2FC_DATA8			USB_REG8( USB_W2FC_BASE_ADDR + W2FC_DATA_OFFSET )	/*8 bits adressing of fifo*/
#define W2FC_CTRL			USB_REG( USB_W2FC_BASE_ADDR + W2FC_CTRL_OFFSET )
#define W2FC_STAT_FLG		USB_REG( USB_W2FC_BASE_ADDR + W2FC_STAT_FLG_OFFSET )
#define W2FC_RXFSTAT		USB_REG( USB_W2FC_BASE_ADDR + W2FC_RXFSTAT_OFFSET )
#define W2FC_SYSCON1		USB_REG( USB_W2FC_BASE_ADDR + W2FC_SYSCON1_OFFSET )
#define W2FC_SYSCON2		USB_REG( USB_W2FC_BASE_ADDR + W2FC_SYSCON2_OFFSET )
#define W2FC_DEVSTAT		USB_REG( USB_W2FC_BASE_ADDR + W2FC_DEVSTAT_OFFSET )
#define W2FC_SOF			USB_REG( USB_W2FC_BASE_ADDR + W2FC_SOF_OFFSET )
#define W2FC_IRQ_EN			USB_REG( USB_W2FC_BASE_ADDR + W2FC_IRQ_EN_OFFSET )
#define W2FC_DMA_IRQ_EN		USB_REG( USB_W2FC_BASE_ADDR + W2FC_DMA_IRQ_EN_OFFSET )
#define W2FC_IRQ_SRC		USB_REG( USB_W2FC_BASE_ADDR + W2FC_IRQ_SRC_OFFSET )
#define W2FC_EPN_STAT		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EPN_STAT_OFFSET )
#define W2FC_DMAN_STAT		USB_REG( USB_W2FC_BASE_ADDR + W2FC_DMAN_STAT_OFFSET )
// #define W2FC_RESERVED0		USB_REG( USB_W2FC_BASE_ADDR + W2FC_RESERVED0 )
#define W2FC_RXDMA_CFG		USB_REG( USB_W2FC_BASE_ADDR + W2FC_RXDMA_CFG_OFFSET )
#define W2FC_TXDMA_CFG		USB_REG( USB_W2FC_BASE_ADDR + W2FC_TXDMA_CFG_OFFSET )
#define W2FC_DATA_DMA		USB_REG( USB_W2FC_BASE_ADDR + W2FC_DATA_DMA_OFFSET )
// #define W2FC_RESERVED1		USB_REG( USB_W2FC_BASE_ADDR + W2FC_RESERVED1 )
#define W2FC_TXDMA0			USB_REG( USB_W2FC_BASE_ADDR + W2FC_TXDMA0_OFFSET )
#define W2FC_TXDMA1			USB_REG( USB_W2FC_BASE_ADDR + W2FC_TXDMA1_OFFSET )
#define W2FC_TXDMA2			USB_REG( USB_W2FC_BASE_ADDR + W2FC_TXDMA2_OFFSET )
// #define W2FC_RESERVED2		USB_REG( USB_W2FC_BASE_ADDR + W2FC_RESERVED2 )
#define W2FC_RXDMA0			USB_REG( USB_W2FC_BASE_ADDR + W2FC_RXDMA0_OFFSET )
#define W2FC_RXDMA1			USB_REG( USB_W2FC_BASE_ADDR + W2FC_RXDMA1_OFFSET )
#define W2FC_RXDMA2			USB_REG( USB_W2FC_BASE_ADDR + W2FC_RXDMA2_OFFSET )
// #define W2FC_RESERVED3		USB_REG( USB_W2FC_BASE_ADDR + W2FC_RESERVED3 )
// #define W2FC_RESERVED4		USB_REG( USB_W2FC_BASE_ADDR + W2FC_RESERVED4 )
// #define W2FC_RESERVED5		USB_REG( USB_W2FC_BASE_ADDR + W2FC_RESERVED5 )
#define W2FC_USB_TEST_1		USB_REG( USB_W2FC_BASE_ADDR + W2FC_USB_TEST_1_OFFSET )
#define W2FC_USB_TEST_2		USB_REG( USB_W2FC_BASE_ADDR + W2FC_USB_TEST_2_OFFSET )
#define W2FC_EP0			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP0_OFFSET )
#define W2FC_EP1_RX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP1_RX_OFFSET )
#define W2FC_EP2_RX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP2_RX_OFFSET )
#define W2FC_EP3_RX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP3_RX_OFFSET )
#define W2FC_EP4_RX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP4_RX_OFFSET )
#define W2FC_EP5_RX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP5_RX_OFFSET )
#define W2FC_EP6_RX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP6_RX_OFFSET )
#define W2FC_EP7_RX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP7_RX_OFFSET )
#define W2FC_EP8_RX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP8_RX_OFFSET )
#define W2FC_EP9_RX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP9_RX_OFFSET )
#define W2FC_EP10_RX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP10_RX_OFFSET )
#define W2FC_EP11_RX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP11_RX_OFFSET )
#define W2FC_EP12_RX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP12_RX_OFFSET )
#define W2FC_EP13_RX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP13_RX_OFFSET )
#define W2FC_EP14_RX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP14_RX_OFFSET )
#define W2FC_EP15_RX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP15_RX_OFFSET )
// #define W2FC_RESERVED6		USB_REG( USB_W2FC_BASE_ADDR + W2FC_RESERVED6 )
#define W2FC_EP1_TX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP1_TX_OFFSET )
#define W2FC_EP2_TX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP2_TX_OFFSET )
#define W2FC_EP3_TX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP3_TX_OFFSET )
#define W2FC_EP4_TX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP4_TX_OFFSET )
#define W2FC_EP5_TX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP5_TX_OFFSET )
#define W2FC_EP6_TX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP6_TX_OFFSET )
#define W2FC_EP7_TX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP7_TX_OFFSET )
#define W2FC_EP8_TX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP8_TX_OFFSET )
#define W2FC_EP9_TX			USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP9_TX_OFFSET )
#define W2FC_EP10_TX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP10_TX_OFFSET )
#define W2FC_EP11_TX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP11_TX_OFFSET )
#define W2FC_EP12_TX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP12_TX_OFFSET )
#define W2FC_EP13_TX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP13_TX_OFFSET )
#define W2FC_EP14_TX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP14_TX_OFFSET )
#define W2FC_EP15_TX		USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP15_TX_OFFSET )

//**********************************************************************
// Register Parameter
//**********************************************************************
//conf core
#define USB_VBUS_MODE			0x0000	//use VBUS Ctrl
#define USB_VBUS_CTRL_CON		0x0001
#define USB_VBUS_CTRL_DISCON	0xFFFE

#define USB_TRX_MODE                   (1<<7)/*Added during Locosto 4 Bin Bi-Dir*/

#define USB_CONF_CORE	USB_REG(0xFFFEF01C) 

//general
#define W2FC_16BIT_RESET					0x0000
#define W2FC_8BIT_RESET						0x00


// W2FC_EP_NUM //
#define W2FC_EP_NUM_SETUP_SEL				0x40
#define W2FC_EP_NUM_EP_SEL					0x20
#define W2FC_EP_NUM_EP_DIR					0x10
#define W2FC_EP_NUM_EP_NUM					0x0F

// W2FC_CTRL //
#define W2FC_CTRL_CLR_HALT					0x80
#define W2FC_CTRL_SET_HALT					0x40
#define W2FC_CTRL_SET_FIFO_EN				0x04
#define W2FC_CTRL_CLR_EP					0x02
#define W2FC_CTRL_RESET_EP					0x01

// W2FC_STAT_FLG //
#define W2FC_STAT_FLG_MISS_IN				0x4000
#define W2FC_STAT_FLG_DATA_FLUSH			0x2000
#define W2FC_STAT_FLG_ISO_ERR				0x1000
#define W2FC_STAT_FLG_ISO_FIFO_EMPTY		0x0200
#define W2FC_STAT_FLG_ISO_FIFO_FULL			0x0100
#define W2FC_STAT_FLG_EP_HALTED				0x0040
#define W2FC_STAT_FLG_STALL					0x0020
#define W2FC_STAT_FLG_NAK					0x0010
#define W2FC_STAT_FLG_ACK					0x0008
#define W2FC_STAT_FLG_FIFO_EN				0x0004
#define W2FC_STAT_FLG_NON_ISO_FIFO_EMPTY	0x0002
#define W2FC_STAT_FLG_NON_ISO_FIFO_FULL		0x0001

// W2FC_RXFSTAT //
#define W2FC_RXFSTAT_RXF_COUNT				0x03FF

// W2FC_SYSCON1 //
#define W2FC_SYSCON1_CFG_LOCK				0x0100
#define W2FC_SYSCON1_NAK_EN					0x0010
#define W2FC_SYSCON1_SELF_PWR				0x0004
#define W2FC_SYSCON1_SOFF_DIS				0x0002
#define W2FC_SYSCON1_PULLUP_EN				0x0001

// W2FC_SYSCON2 //
#define W2FC_SYSCON2_RMT_WKP				0x40
#define W2FC_SYSCON2_STALL_CMD				0x20
#define W2FC_SYSCON2_DEV_CFG				0x08
#define W2FC_SYSCON2_CLR_CFG				0x04

// W2FC_DEVSTAT //
#define W2FC_DEVSTAT_R_WK_OK				0x40
#define W2FC_DEVSTAT_USB_RESET				0x20
#define W2FC_DEVSTAT_SUS					0x10
#define W2FC_DEVSTAT_CFG					0x08
#define W2FC_DEVSTAT_ADD					0x04
#define W2FC_DEVSTAT_DEF					0x02
#define W2FC_DEVSTAT_ATT					0x01

// W2FC_SOF //
#define W2FC_SOF_FT_LOCK					0x1000
#define W2FC_SOF_TS_OK						0x0800
#define W2FC_SOF_TS							0x07FF

// W2FC_IRQ_EN //
#define W2FC_IRQ_EN_SOF_IE					0x80
#define W2FC_IRQ_EN_EPN_RX_IE				0x20
#define W2FC_IRQ_EN_EPN_TX_IE				0x10
#define W2FC_IRQ_EN_DS_CHG_IE				0x08
#define W2FC_IRQ_EN_EP0_IE					0x01

// W2FC_DMA_IRQ_EN //
#define W2FC_DMA_IRQ_EN_TX2_DONE_IE			0x0400
#define W2FC_DMA_IRQ_EN_RX2_CNT_IE			0x0200
#define W2FC_DMA_IRQ_EN_RX2_EOT_IE			0x0100
#define W2FC_DMA_IRQ_EN_TX1_DONE_IE			0x0040
#define W2FC_DMA_IRQ_EN_RX1_CNT_IE			0x0020
#define W2FC_DMA_IRQ_EN_RX1_EOT_IE			0x0010
#define W2FC_DMA_IRQ_EN_TX0_DONE_IE			0x0004
#define W2FC_DMA_IRQ_EN_RX0_CNT_IE			0x0002
#define W2FC_DMA_IRQ_EN_RX0_EOT_IE			0x0001

// W2FC_IRQ_SRC //
#define W2FC_IRQ_SRC_TXN_DONE				0x0400
#define W2FC_IRQ_SRC_RXN_CNT				0x0200
#define W2FC_IRQ_SRC_RXN_EOT				0x0100
#define W2FC_IRQ_SRC_SOF					0x0080
#define W2FC_IRQ_SRC_EPN_RX					0x0020
#define W2FC_IRQ_SRC_EPN_TX					0x0010
#define W2FC_IRQ_SRC_DS_CHG					0x0008
#define W2FC_IRQ_SRC_SETUP					0x0004
#define W2FC_IRQ_SRC_EP0_RX					0x0002
#define W2FC_IRQ_SRC_EP0_TX					0x0001

// W2FC_EPN_STAT //
#define W2FC_EPN_STAT_EPN_RX_IT_SRC			0x0F00
#define W2FC_EPN_STAT_EPN_TX_IT_SRC			0x000F

// W2FC_DMAN_STAT //
#define W2FC_DMAN_STAT_DMAN_RX_SB			0x1000
#define W2FC_DMAN_STAT_DMAN_RX_IT_SRC		0x0F00
#define W2FC_DMAN_STAT_DMAN_TX_IT_SRC		0x000F

// W2FC_RXDMA_CFG //
#define W2FC_RXDMA_CFG_RXDMA2_EP			0x0F00
#define W2FC_RXDMA_CFG_RXDMA1_EP			0x00F0
#define W2FC_RXDMA_CFG_RXDMA0_EP			0x000F

// W2FC_TXDMA_CFG //
#define W2FC_TXDMA_CFG_TXDMA2_EP			0x0F00
#define W2FC_TXDMA_CFG_TXDMA1_EP			0x00F0
#define W2FC_TXDMA_CFG_TXDMA0_EP			0x000F

// W2FC_TXDMAn //
#define W2FC_TXDMAn_TXn_EOT					0x8000
#define W2FC_TXDMAn_TXn_START				0x4000
#define W2FC_TXDMAn_TXn_TSC					0x03FF

// W2FC_RXDMAn //
#define W2FC_RXDMAn_RXn_STOP				0x8000
#define W2FC_RXDMAn_RXn_TC					0x00FF

// W2FC_USB_TEST_1 //
#define W2FC_USB_TEST_1_TEST_UNLOCK			0x8000
#define W2FC_USB_TEST_1_REM_WAKEUP_EN		0x4000
#define W2FC_USB_TEST_1_USB_RESET			0x1000
#define W2FC_USB_TEST_1_IRQ_ISO				0x0400
#define W2FC_USB_TEST_1_IRQ_NON_ISO			0x0200
#define W2FC_USB_TEST_1_IRQ_GENI			0x0100
#define W2FC_USB_TEST_1_DMA_TX_REQ_2		0x0040
#define W2FC_USB_TEST_1_DMA_TX_REQ_1		0x0020
#define W2FC_USB_TEST_1_DMA_TX_REQ_0		0x0010
#define W2FC_USB_TEST_1_DMA_RX_REQ_2		0x0004
#define W2FC_USB_TEST_1_DMA_RX_REQ_1		0x0002
#define W2FC_USB_TEST_1_DMA_RX_REQ_0		0x0001

// W2FC_USB_TEST_2 //
#define W2FC_USB_TEST_2_TEST2_WE			0x8000
#define W2FC_USB_TEST_2_RAM_LOOPBACK		0x0200
#define W2FC_USB_TEST_2_BYPASS_ENUM			0x0100
#define W2FC_USB_TEST_2_VBUS_STAT			0x0080
#define W2FC_USB_TEST_2_RXD_STAT			0x0040
#define W2FC_USB_TEST_2_RXDM_STAT			0x0020
#define W2FC_USB_TEST_2_RXDP_STAT			0x0010
#define W2FC_USB_TEST_2_XEVR_MODE			0x000C
#define W2FC_USB_TEST_2_DATA_XMIT			0x0003

// W2FC_EP0 //
#define W2FC_EP0_EP0_SIZE					0x3000
// #define W2FC_EP0_EP0_PTR					0x03FF
#define W2FC_EP0_EP0_PTR					0x00FF // Because max FIFO Size = 2048bytes


// W2FC_EPn //
#define W2FC_EPn_EPn_VALID					0x8000
#define W2FC_EPn_EPn_DB						0x4000
#define W2FC_EPn_EPn_SIZE					0x3000
#define W2FC_EPn_EPn_ISO					0x0800
// #define W2FC_EPn_EPn_PTR					0x03FF
#define W2FC_EPn_EPn_PTR					0x00FF // Because max FIFO Size = 2048bytes

//MACRO
#define W2FC_EPn_TX( v )	USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP1_TX_OFFSET+( 0x02*(v-1) ) )
#define W2FC_EPn_RX( v )	USB_REG( USB_W2FC_BASE_ADDR + W2FC_EP1_RX_OFFSET+( 0x02*(v-1) ) )


typedef enum{
	DMA_TXn_Done = 0x0400,	// DMA
	DMA_RXn_Done = 0x0200,	// DMA
	DMA_RXn_EOT  = 0x0100,	// DMA
	SOF          = 0x0080,	// ISO interrupt
	EPn_OUT      = 0x0020,	// Non-ISO interrupt
	EPn_IN       = 0x0010,	// Non-ISO interrupt
	DS_Chg       = 0x0008,	// General interrupt
	Setup        = 0x0004,	// General interrupt
	EP0_OUT      = 0x0002,	// General interrupt
	EP0_IN       = 0x0001	// General interrupt
} IRQ_SRC_REG_MAPPING;




#endif /* __W2FC_DEF_H__ */

