# ---environments module initialization---
# vim: ft=python
#
# This is a file from the TI build system.
#
###############################################################################
# __init__.py
#
# This file initalizes the toolset module.
# Its goal is to set intp the caller namespace:
#    The "Toolset" variable: string naming the current toolset
###############################################################################
import os

def load(toolset, globs):
   '''Loads the toolset in the SConstruct namespace

   toolset: The name of the toolset to use (Without file extension .py)
   globs:   Reference to the SConstruct namespace.
   returns the SCons Environment being generated by the toolset or None in
      case of failure.
   '''
   exitStatus = True
   quiet = globs['Quiet']
   if not quiet: print '-' * 75
   toolsetFile = (os.path.dirname(__file__) + "/" + \
                  toolset + ".py").replace('\\', '/')
   if os.access(toolsetFile, os.R_OK):
      try:    execfile(toolsetFile, globs)
      except SystemExit:
         print "Explicit exit from:", toolsetFile
         exitStatus = False
      except:
         import sys, traceback, pickle
         excType, excValue, tb = sys.exc_info()
            # Save the traceback and attach it to the exception object
         excLines = ''.join(traceback.format_exception(excType, excValue, tb))
         print >> sys.stderr, sys.exc_info()[:2]
         print >> sys.stderr, excLines

         print "Problem interpreting:", toolsetFile
         exitStatus = False
      else:
         if not quiet:
            print "Loaded toolset:\n", toolsetFile.replace('\\', '/'), "\nOK"
   else:
      print "Problem reading file: " + toolsetFile
      exitStatus = False

   if not quiet: print '-' * 75
   return exitStatus
