/*
+--------------------------------------------------------------------------+
| PROJECT : PROTOCOL STACK                                                 |
| FILE    : p_mphc.h                                                       |
| SOURCE  : "__out__\LNX_TI_cgt2_70\rel_n5_camera_micron\cdginc\condat\ms\doc\sap\mphc.pdf"                  |
| LastModified : "2003-04-03"                                              |
| IdAndVersion : "10.10.10.011"                                            |
| SrcFileTime  : "Thu Nov 29 09:49:44 2007"                                |
| Generated by CCDGEN_2.5.5A on Wed Mar 11 09:58:58 2009                   |
|           !!DO NOT MODIFY!!DO NOT MODIFY!!DO NOT MODIFY!!                |
+--------------------------------------------------------------------------+
*/

/* PRAGMAS
 * PREFIX                 : NONE
 * COMPATIBILITY_DEFINES  : NO (require PREFIX)
 * ALWAYS_ENUM_IN_VAL_FILE: NO
 * ENABLE_GROUP: NO
 * CAPITALIZE_TYPENAME: NO
 */


#ifndef P_MPHC_H
#define P_MPHC_H


#define CDG_ENTER__P_MPHC_H

#define CDG_ENTER__FILENAME _P_MPHC_H
#define CDG_ENTER__P_MPHC_H__FILE_TYPE CDGINC
#define CDG_ENTER__P_MPHC_H__LAST_MODIFIED _2003_04_03
#define CDG_ENTER__P_MPHC_H__ID_AND_VERSION _10_10_10_011

#define CDG_ENTER__P_MPHC_H__SRC_FILE_TIME _Thu_Nov_29_09_49_44_2007

#include "CDG_ENTER.h"

#undef CDG_ENTER__P_MPHC_H

#undef CDG_ENTER__FILENAME


#include "p_mphc.val"

#ifndef __T_schedule_array__
#define __T_schedule_array__
/*
 * positional info
 * CCDGEN:WriteStruct_Count==2096
 */
typedef struct
{
  U16                       modulus;                  /*<  0:  2> modulo part                                        */
  U16                       relative_position;        /*<  2:  2> relative part                                      */
} T_schedule_array;
#endif

#ifndef __T_l2_frame__
#define __T_l2_frame__
/*
 * layer 2 frame
 * CCDGEN:WriteStruct_Count==2097
 */
typedef struct
{
  U8                        content[MAX_L2_FRAME_SIZE]; /*<  0: 23> frame content                                      */
  U8                        _align0;                  /*< 23:  1> alignment                                          */
} T_l2_frame;
#endif

#ifndef __T_chan_list__
#define __T_chan_list__
/*
 * channel list
 * CCDGEN:WriteStruct_Count==2098
 */
typedef struct
{
  U16                       radio_freq[BA_LIST_SIZE]; /*<  0: 66> channel number                                     */
  U8                        _align0;                  /*< 66:  1> alignment                                          */
  U8                        _align1;                  /*< 67:  1> alignment                                          */
} T_chan_list;
#endif

#ifndef __T_result__
#define __T_result__
/*
 * measurement results
 * CCDGEN:WriteStruct_Count==2099
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        rxlev;                    /*<  2:  1> The accumulated result of a power measurements. The signal strength units used are based on those described in GSM 05.08 (ETS 300 911) section 8.1.4. The measurements continue above 63 and below 0 */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
} T_result;
#endif

#ifndef __T_rf_channel__
#define __T_rf_channel__
/*
 * channel choice
 * CCDGEN:WriteStruct_Count==2100
 */
typedef struct
{
  U8                        maio;                     /*<  0:  1> mobile allocation index offset                     */
  U8                        hsn;                      /*<  1:  1> hopping sequence number                            */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_rf_channel;
#endif

#ifndef __T_chan_sel__
#define __T_chan_sel__
/*
 * channel selector
 * CCDGEN:WriteStruct_Count==2101
 */
typedef struct
{
  U8                        h;                        /*<  0:  1> hopping                                            */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_rf_channel              rf_channel;               /*<  4:  4> channel choice                                     */
} T_chan_sel;
#endif

#ifndef __T_cbch_desc__
#define __T_cbch_desc__
/*
 * CBCH channel description
 * CCDGEN:WriteStruct_Count==2102
 */
typedef struct
{
  T_chan_sel                chan_sel;                 /*<  0:  8> channel selector                                   */
  U8                        channel_type;             /*<  8:  1> SDCCH channel type                                 */
  U8                        sub_channel;              /*<  9:  1> sub channel                                        */
  U8                        timeslot_no;              /*< 10:  1> timeslot number                                    */
  U8                        tsc;                      /*< 11:  1> training sequence code                             */
} T_cbch_desc;
#endif

/*
 * channel description
 * CCDGEN:WriteStruct_Count==2103
 */
#ifndef __T_channel_desc__
#define __T_channel_desc__
typedef T_cbch_desc T_channel_desc;
#endif
/*
 * channel description
 * CCDGEN:WriteStruct_Count==2104
 */
#ifndef __T_channel_desc_1__
#define __T_channel_desc_1__
typedef T_cbch_desc T_channel_desc_1;
#endif
/*
 * channel description
 * CCDGEN:WriteStruct_Count==2105
 */
#ifndef __T_channel_desc_2__
#define __T_channel_desc_2__
typedef T_cbch_desc T_channel_desc_2;
#endif
/*
 * channel description before starting time
 * CCDGEN:WriteStruct_Count==2106
 */
#ifndef __T_channel_desc_1_bef_sti__
#define __T_channel_desc_1_bef_sti__
typedef T_cbch_desc T_channel_desc_1_bef_sti;
#endif
/*
 * channel description before starting time
 * CCDGEN:WriteStruct_Count==2107
 */
#ifndef __T_channel_desc_2_bef_sti__
#define __T_channel_desc_2_bef_sti__
typedef T_cbch_desc T_channel_desc_2_bef_sti;
#endif
#ifndef __T_rf_chan_no__
#define __T_rf_chan_no__
/*
 * channel list
 * CCDGEN:WriteStruct_Count==2108
 */
typedef struct
{
  U16                       radio_freq[MAX_MA_CARRIER]; /*<  0:128> channel number                                     */
} T_rf_chan_no;
#endif

#ifndef __T_cbch_freq_list__
#define __T_cbch_freq_list__
/*
 * CBCH frequency list
 * CCDGEN:WriteStruct_Count==2109
 */
typedef struct
{
  U16                       rf_chan_cnt;              /*<  0:  2> number of channels in the mobile allocation list or  number of bcch in the list */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  T_rf_chan_no              rf_chan_no;               /*<  4:128> channel list                                       */
} T_cbch_freq_list;
#endif

/*
 * frequency list
 * CCDGEN:WriteStruct_Count==2110
 */
#ifndef __T_frequency_list__
#define __T_frequency_list__
typedef T_cbch_freq_list T_frequency_list;
#endif
/*
 * frequency list before starting time
 * CCDGEN:WriteStruct_Count==2111
 */
#ifndef __T_frequency_list_bef_sti__
#define __T_frequency_list_bef_sti__
typedef T_cbch_freq_list T_frequency_list_bef_sti;
#endif
#ifndef __T_start_time__
#define __T_start_time__
/*
 * starting time
 * CCDGEN:WriteStruct_Count==2112
 */
typedef struct
{
  U8                        t1;                       /*<  0:  1> N32; named n32 in S922.doc                         */
  U8                        t3;                       /*<  1:  1> N51; named n51 in S922.doc                         */
  U8                        t2;                       /*<  2:  1> N26; named n26 in S922.doc                         */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
} T_start_time;
#endif

#ifndef __T_starting_time__
#define __T_starting_time__
/*
 * starting time
 * CCDGEN:WriteStruct_Count==2113
 */
typedef struct
{
  U8                        start_time_present;       /*<  0:  1> start time present                                 */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_start_time              start_time;               /*<  4:  4> starting time                                      */
} T_starting_time;
#endif

#ifndef __T_new_ciph_param__
#define __T_new_ciph_param__
/*
 * Cipher Key Kc
 * CCDGEN:WriteStruct_Count==2114
 */
typedef struct
{
  U8                        A[MAX_KC_STRING_SIZE];    /*<  0: 16> Kc values                                          */
} T_new_ciph_param;
#endif

/*
 * encryption key
 * CCDGEN:WriteStruct_Count==2115
 */
#ifndef __T_cipher_key__
#define __T_cipher_key__
typedef T_new_ciph_param T_cipher_key;
#endif
#ifndef __T_cell_description__
#define __T_cell_description__
/*
 * cell description
 * CCDGEN:WriteStruct_Count==2116
 */
typedef struct
{
  U8                        ncc;                      /*<  0:  1> national colour code                               */
  U8                        bcc;                      /*<  1:  1> base station colour code                           */
  U16                       bcch_carrier;             /*<  2:  2> BCCH carrier                                       */
} T_cell_description;
#endif

#ifndef __T_handover_command__
#define __T_handover_command__
/*
 * Handover Command
 * CCDGEN:WriteStruct_Count==2117
 */
typedef struct
{
  T_cell_description        cell_description;         /*<  0:  4> cell description                                   */
  T_channel_desc_1          channel_desc_1;           /*<  4: 12> channel description                                */
  U8                        channel_mode_1;           /*< 16:  1> channel mode                                       */
  U8                        _align0;                  /*< 17:  1> alignment                                          */
  U8                        _align1;                  /*< 18:  1> alignment                                          */
  U8                        _align2;                  /*< 19:  1> alignment                                          */
  T_starting_time           starting_time;            /*< 20:  8> starting time                                      */
  U8                        ho_acc;                   /*< 28:  1> handover access                                    */
  U8                        txpwr;                    /*< 29:  1> Indicates the power level which the mobile should use for transmission . */
  U8                        report_time_diff;         /*< 30:  1> time difference                                    */
  U8                        _align3;                  /*< 31:  1> alignment                                          */
  T_frequency_list          frequency_list;           /*< 32:132> frequency list                                     */
  T_channel_desc_2          channel_desc_2;           /*<164: 12> channel description                                */
  U8                        channel_mode_2;           /*<176:  1> channel mode                                       */
  U8                        _align4;                  /*<177:  1> alignment                                          */
  U8                        _align5;                  /*<178:  1> alignment                                          */
  U8                        _align6;                  /*<179:  1> alignment                                          */
  T_frequency_list_bef_sti  frequency_list_bef_sti;   /*<180:132> frequency list before starting time                */
  T_channel_desc_1_bef_sti  channel_desc_1_bef_sti;   /*<312: 12> channel description before starting time           */
  T_channel_desc_2_bef_sti  channel_desc_2_bef_sti;   /*<324: 12> channel description before starting time           */
  U8                        cipher_mode;              /*<336:  1> cipher mode                                        */
  U8                        a5_algorithm;             /*<337:  1> A5 algorithm                                       */
  U8                        _align7;                  /*<338:  1> alignment                                          */
  U8                        _align8;                  /*<339:  1> alignment                                          */
} T_handover_command;
#endif

#ifndef __T_res_list__
#define __T_res_list__
/*
 * neighbour cell measurement results
 * CCDGEN:WriteStruct_Count==2118
 */
typedef struct
{
  U16                       bcch_freq;                /*<  0:  2> channel number                                     */
  U16                       rxlev_acc;                /*<  2:  2> accumulated rx level                               */
  U8                        rxlev_nbr_meas;           /*<  4:  1> nbr of rxlevel samples                             */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U8                        _align1;                  /*<  6:  1> alignment                                          */
  U8                        _align2;                  /*<  7:  1> alignment                                          */
} T_res_list;
#endif

#ifndef __T_ncell_meas__
#define __T_ncell_meas__
/*
 * neighbour cell measurement results
 * CCDGEN:WriteStruct_Count==2119
 */
typedef struct
{
  T_res_list                res_list[BA_LIST_SIZE];   /*<  0:264> neighbour cell measurement results                 */
} T_ncell_meas;
#endif

#ifndef __T_chan_number__
#define __T_chan_number__
/*
 * channel list
 * CCDGEN:WriteStruct_Count==2120
 */
typedef struct
{
  U16                       radio_freq[BCCH_LIST_SIZE]; /*<  0: 64> channel number                                     */
} T_chan_number;
#endif

#ifndef __T_bcch_allocation__
#define __T_bcch_allocation__
/*
 * BCCH allocation
 * CCDGEN:WriteStruct_Count==2121
 */
typedef struct
{
  U16                       rf_chan_cnt;              /*<  0:  2> number of channels in the mobile allocation list or  number of bcch in the list */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  T_chan_number             chan_number;              /*<  4: 64> channel list                                       */
} T_bcch_allocation;
#endif

#ifndef __T_amr_configuration__
#define __T_amr_configuration__
/*
 * Parameters for AMR
 * CCDGEN:WriteStruct_Count==2122
 */
typedef struct
{
  U8                        noise_suppression_control_bit; /*<  0:  1> noise suppression control bit                      */
  U8                        initial_codec_mode_indicator; /*<  1:  1> initial code mode indicator                        */
  U8                        initial_codec_mode;       /*<  2:  1> initial code mode                                  */
  U8                        active_codec_set;         /*<  3:  1> active codec set                                   */
  U8                        threshold[3];             /*<  4:  3> threshold                                          */
  U8                        hysteresis[3];            /*<  7:  3> hysteresis                                         */
  U8                        _align0;                  /*< 10:  1> alignment                                          */
  U8                        _align1;                  /*< 11:  1> alignment                                          */
} T_amr_configuration;
#endif

#ifndef __T_ncell_list__
#define __T_ncell_list__
/*
 * Parameters of a neighbour cell
 * CCDGEN:WriteStruct_Count==2123
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  U32                       fn_offset;                /*<  4:  4> frame offset                                       */
  U32                       time_alignment;           /*<  8:  4> Difference in quarter bits between the first bit in a frame of the serving cell and the first bit in the next frame of the non-serving cell. Validity of time_alignment dependent upon timing_validity indication. (0 - 4999) */
  U8                        timing_validity;          /*< 12:  1> timing validity                                    */
  U8                        _align2;                  /*< 13:  1> alignment                                          */
  U8                        _align3;                  /*< 14:  1> alignment                                          */
  U8                        _align4;                  /*< 15:  1> alignment                                          */
} T_ncell_list;
#endif


// STRUCT-FF: !TI_DUAL_MODE 
#ifndef __T_RADIO_FRAME__
#define __T_RADIO_FRAME__
/*
 * Layer 2 frame
 * CCDGEN:WriteStruct_Count==2124
 */
typedef struct
{
  U8                        A[MAX_L2_FRAME_SIZE];     /*<  0: 23> frame content                                      */
  U8                        _align0;                  /*< 23:  1> alignment                                          */
} T_RADIO_FRAME;
#endif


// STRUCT-FF: TI_PS_FF_QUAD_BAND_SUPPORT 
#ifndef __T_multiband_power_class__
#define __T_multiband_power_class__
/*
 * Power Class information for multiple bands
 * CCDGEN:WriteStruct_Count==2125
 */
typedef struct
{
  U8                        radio_band;               /*<  0:  1> Radio Bands Supported                              */
  U8                        power_class;              /*<  1:  1> Power Class associated with each radio band        */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_multiband_power_class;
#endif


/*
 * End of substructure section, begin of primitive definition section
 */

#ifndef __T_MPHC_NETWORK_SYNC_REQ__
#define __T_MPHC_NETWORK_SYNC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2126
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  U32                       fn_offset;                /*<  4:  4> frame offset                                       */
  U32                       time_alignment;           /*<  8:  4> Difference in quarter bits between the first bit in a frame of the serving cell and the first bit in the next frame of the non-serving cell. Validity of time_alignment dependent upon timing_validity indication. (0 - 4999) */
  U8                        timing_validity;          /*< 12:  1> timing validity                                    */
  U8                        search_mode;              /*< 13:  1> search mode                                        */
  U8                        _align2;                  /*< 14:  1> alignment                                          */
  U8                        _align3;                  /*< 15:  1> alignment                                          */
} T_MPHC_NETWORK_SYNC_REQ;
#endif

#ifndef __T_MPHC_NETWORK_SYNC_IND__
#define __T_MPHC_NETWORK_SYNC_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2127
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        sb_flag;                  /*<  2:  1> Flag indicating whether synchronisation channel was read correctly or not */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
  U32                       fn_offset;                /*<  4:  4> frame offset                                       */
  U32                       time_alignment;           /*<  8:  4> Difference in quarter bits between the first bit in a frame of the serving cell and the first bit in the next frame of the non-serving cell. Validity of time_alignment dependent upon timing_validity indication. (0 - 4999) */
  U8                        bsic;                     /*< 12:  1> base station identification code                   */
  U8                        _align1;                  /*< 13:  1> alignment                                          */
  U8                        _align2;                  /*< 14:  1> alignment                                          */
  U8                        _align3;                  /*< 15:  1> alignment                                          */
} T_MPHC_NETWORK_SYNC_IND;
#endif

#ifndef __T_MPHC_STOP_NETWORK_SYNC_REQ__
#define __T_MPHC_STOP_NETWORK_SYNC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2128
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_NETWORK_SYNC_REQ;
#endif

#ifndef __T_MPHC_STOP_NETWORK_SYNC_CON__
#define __T_MPHC_STOP_NETWORK_SYNC_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2129
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_NETWORK_SYNC_CON;
#endif

#ifndef __T_MPHC_START_CCCH_REQ__
#define __T_MPHC_START_CCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2130
 */
typedef struct
{
  U8                        bs_pa_mfrms;              /*<  0:  1> Multiframe Period                                  */
  U8                        bs_ag_blks_res;           /*<  1:  1> Blocks reserved for AGCH                           */
  U8                        bcch_combined;            /*<  2:  1> combined BCCH flag                                 */
  U8                        ccch_group;               /*<  3:  1> CCCH group                                         */
  U8                        page_group;               /*<  4:  1> paging group                                       */
  U8                        page_block_index;         /*<  5:  1> page block index                                   */
  U8                        page_mode;                /*<  6:  1> paging mode                                        */
  U8                        _align0;                  /*<  7:  1> alignment                                          */
} T_MPHC_START_CCCH_REQ;
#endif

#ifndef __T_MPHC_STOP_CCCH_REQ__
#define __T_MPHC_STOP_CCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2131
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_CCCH_REQ;
#endif

#ifndef __T_MPHC_STOP_CCCH_CON__
#define __T_MPHC_STOP_CCCH_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2132
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_CCCH_CON;
#endif

#ifndef __T_MPHC_SCELL_NBCCH_REQ__
#define __T_MPHC_SCELL_NBCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2133
 */
typedef struct
{
  U8                        schedule_array_size;      /*<  0:  1> number of channel numbers                          */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_schedule_array          schedule_array[MAX_SCHED_SIZE]; /*<  4: 40> positional info                                    */
} T_MPHC_SCELL_NBCCH_REQ;
#endif

#ifndef __T_MPHC_SCELL_EBCCH_REQ__
#define __T_MPHC_SCELL_EBCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2134
 */
typedef struct
{
  U8                        schedule_array_size;      /*<  0:  1> number of channel numbers                          */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_schedule_array          schedule_array[MAX_SCHED_SIZE]; /*<  4: 40> positional info                                    */
} T_MPHC_SCELL_EBCCH_REQ;
#endif

#ifndef __T_MPHC_STOP_SCELL_BCCH_REQ__
#define __T_MPHC_STOP_SCELL_BCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2135
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_SCELL_BCCH_REQ;
#endif

#ifndef __T_MPHC_STOP_SCELL_BCCH_CON__
#define __T_MPHC_STOP_SCELL_BCCH_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2136
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_SCELL_BCCH_CON;
#endif

#ifndef __T_MPHC_DATA_IND__
#define __T_MPHC_DATA_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2137
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        l2_channel;               /*<  2:  1> layer 2 channel type                               */
  U8                        error_flag;               /*<  3:  1> error cause                                        */
  T_l2_frame                l2_frame;                 /*<  4: 24> layer 2 frame                                      */
  U8                        tc;                       /*< 28:  1> multiframe number modulo 8                         */
  U8                        ccch_lev;                 /*< 29:  1> Power strength level                               */
  U8                        _align0;                  /*< 30:  1> alignment                                          */
  U8                        _align1;                  /*< 31:  1> alignment                                          */
  U32                       fn;                       /*< 32:  4> frame number                                       */
} T_MPHC_DATA_IND;
#endif

#ifndef __T_MPHC_NCELL_SYNC_REQ__
#define __T_MPHC_NCELL_SYNC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2138
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  U32                       fn_offset;                /*<  4:  4> frame offset                                       */
  U32                       time_alignment;           /*<  8:  4> Difference in quarter bits between the first bit in a frame of the serving cell and the first bit in the next frame of the non-serving cell. Validity of time_alignment dependent upon timing_validity indication. (0 - 4999) */
  U8                        timing_validity;          /*< 12:  1> timing validity                                    */
  U8                        _align2;                  /*< 13:  1> alignment                                          */
  U8                        _align3;                  /*< 14:  1> alignment                                          */
  U8                        _align4;                  /*< 15:  1> alignment                                          */
} T_MPHC_NCELL_SYNC_REQ;
#endif

#ifndef __T_MPHC_NCELL_LIST_SYNC_REQ__
#define __T_MPHC_NCELL_LIST_SYNC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2139
 */
typedef struct
{
  U8                        eotd;                     /*<  0:  1> EOTD or neighbour cell monitoring                  */
  U8                        list_size;                /*<  1:  1> 1 up to 12 neighbour cells                         */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  T_ncell_list              ncell_list[MAX_NCELL_EOTD_L1]; /*<  4:192> Parameters of a neighbour cell                     */
} T_MPHC_NCELL_LIST_SYNC_REQ;
#endif

#ifndef __T_MPHC_NCELL_SYNC_IND__
#define __T_MPHC_NCELL_SYNC_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2140
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        sb_flag;                  /*<  2:  1> Flag indicating whether synchronisation channel was read correctly or not */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
  U32                       fn_offset;                /*<  4:  4> frame offset                                       */
  U32                       time_alignment;           /*<  8:  4> Difference in quarter bits between the first bit in a frame of the serving cell and the first bit in the next frame of the non-serving cell. Validity of time_alignment dependent upon timing_validity indication. (0 - 4999) */
  U8                        bsic;                     /*< 12:  1> base station identification code                   */
  U8                        neigh_id;                 /*< 13:  1> reserved                                           */
  U8                        attempt;                  /*< 14:  1> reserved                                           */
  U8                        _align1;                  /*< 15:  1> alignment                                          */
  U32                       pm;                       /*< 16:  4> reserved                                           */
  U32                       toa;                      /*< 20:  4> reserved                                           */
  U32                       angle;                    /*< 24:  4> reserved                                           */
  U32                       snr;                      /*< 28:  4> reserved                                           */
  U8                        eodt_data_valid;          /*< 32:  1> EOTD data present                                  */
  U8                        mode;                     /*< 33:  1> idle or dedicated mode                             */
  S16                       d_eotd_first;             /*< 34:  2> Delay to first correlation                         */
  S16                       d_eotd_max;               /*< 36:  2> Delay to maximum correlation                       */
  U8                        _align2;                  /*< 38:  1> alignment                                          */
  U8                        _align3;                  /*< 39:  1> alignment                                          */
  U32                       d_eotd_nrj;               /*< 40:  4> sum of amplitudes                                  */
  S16                       a_eotd_crosscor[18];      /*< 44: 36> Cross correlation                                  */
  U32                       time_tag;                 /*< 80:  4> Time tag                                           */
  U32                       fn_sb_neigh;              /*< 84:  4> reserved                                           */
  U32                       fn_in_sb;                 /*< 88:  4> reserved                                           */
  U32                       toa_correction;           /*< 92:  4> reserved                                           */
  U32                       delta_fn;                 /*< 96:  4> reserved                                           */
  U32                       delta_qbit;               /*<100:  4> reserved                                           */
} T_MPHC_NCELL_SYNC_IND;
#endif

#ifndef __T_MPHC_STOP_NCELL_SYNC_REQ__
#define __T_MPHC_STOP_NCELL_SYNC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2141
 */
typedef struct
{
  U8                        radio_freq_array_size;    /*<  0:  1> Number of entries in the radio_freq_array within a stop request. When 6 (maximum number of requests to be served in parallel) are provided the message is interpreted as a complete process stop request. */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       radio_freq_array[MAX_NCELL_EOTD_L1]; /*<  2: 24> channel list                                       */
  U8                        _align1;                  /*< 26:  1> alignment                                          */
  U8                        _align2;                  /*< 27:  1> alignment                                          */
} T_MPHC_STOP_NCELL_SYNC_REQ;
#endif

#ifndef __T_MPHC_STOP_NCELL_SYNC_CON__
#define __T_MPHC_STOP_NCELL_SYNC_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2142
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_NCELL_SYNC_CON;
#endif

#ifndef __T_MPHC_NCELL_BCCH_REQ__
#define __T_MPHC_NCELL_BCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2143
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  U32                       fn_offset;                /*<  4:  4> frame offset                                       */
  U32                       time_alignment;           /*<  8:  4> Difference in quarter bits between the first bit in a frame of the serving cell and the first bit in the next frame of the non-serving cell. Validity of time_alignment dependent upon timing_validity indication. (0 - 4999) */
  U8                        tsc;                      /*< 12:  1> training sequence code                             */
  U8                        _align2;                  /*< 13:  1> alignment                                          */
  U16                       bcch_blocks_required;     /*< 14:  2> sys info bitmap                                    */
  U8                        gprs_prio;                /*< 16:  1> Gprs priority                                      */
  U8                        _align3;                  /*< 17:  1> alignment                                          */
  U8                        _align4;                  /*< 18:  1> alignment                                          */
  U8                        _align5;                  /*< 19:  1> alignment                                          */
} T_MPHC_NCELL_BCCH_REQ;
#endif

#ifndef __T_MPHC_NCELL_BCCH_IND__
#define __T_MPHC_NCELL_BCCH_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2144
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        l2_channel;               /*<  2:  1> layer 2 channel type                               */
  U8                        error_flag;               /*<  3:  1> error cause                                        */
  T_l2_frame                l2_frame;                 /*<  4: 24> layer 2 frame                                      */
  U8                        tc;                       /*< 28:  1> multiframe number modulo 8                         */
  U8                        _align0;                  /*< 29:  1> alignment                                          */
  U8                        _align1;                  /*< 30:  1> alignment                                          */
  U8                        _align2;                  /*< 31:  1> alignment                                          */
  U32                       fn;                       /*< 32:  4> frame number                                       */
} T_MPHC_NCELL_BCCH_IND;
#endif

#ifndef __T_MPHC_STOP_NCELL_BCCH_REQ__
#define __T_MPHC_STOP_NCELL_BCCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2145
 */
typedef struct
{
  U8                        radio_freq_array_size;    /*<  0:  1> Number of entries in the radio_freq_array within a stop request. When 6 (maximum number of requests to be served in parallel) are provided the message is interpreted as a complete process stop request. */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       radio_freq_array[6];      /*<  2: 12> channel list                                       */
  U8                        _align1;                  /*< 14:  1> alignment                                          */
  U8                        _align2;                  /*< 15:  1> alignment                                          */
} T_MPHC_STOP_NCELL_BCCH_REQ;
#endif

#ifndef __T_MPHC_STOP_NCELL_BCCH_CON__
#define __T_MPHC_STOP_NCELL_BCCH_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2146
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_NCELL_BCCH_CON;
#endif

#ifndef __T_MPHC_RXLEV_PERIODIC_REQ__
#define __T_MPHC_RXLEV_PERIODIC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2147
 */
typedef struct
{
  T_chan_list               chan_list;                /*<  0: 68> channel list                                       */
  U8                        num_of_chans;             /*< 68:  1> Number of valid carrier numbers contained in the BA list (chan_number) array (1 to 33) */
  U8                        ba_id;                    /*< 69:  1> band allocation identification                     */
  U8                        next_radio_freq_measured; /*< 70:  1> channel index                                      */
  U8                        _align0;                  /*< 71:  1> alignment                                          */
} T_MPHC_RXLEV_PERIODIC_REQ;
#endif

#ifndef __T_MPHC_RXLEV_PERIODIC_IND__
#define __T_MPHC_RXLEV_PERIODIC_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2148
 */
typedef struct
{
  T_result                  result[MAX_MEAS_VALUES];  /*<  0: 32> measurement results                                */
  U8                        nbr_of_carriers;          /*< 32:  1> The number of cell carriers measured during the PCH block */
  U8                        s_rxlev;                  /*< 33:  1> The serving cell received power level (average of the 4 PCH bursts read during the particular PCH block). */
  U8                        ba_id;                    /*< 34:  1> band allocation identification                     */
  U8                        _align0;                  /*< 35:  1> alignment                                          */
  U32                       qual_acc_idle;            /*< 36:  4> accumulated rxqual meas. on different channels in Idle mode - error bits */
  U32                       qual_nbr_meas_idle;       /*< 40:  4> accumulated rxqual meas. on different channels in Idle mode - total number of bits decoded */
} T_MPHC_RXLEV_PERIODIC_IND;
#endif

#ifndef __T_MPHC_STOP_RXLEV_PERIODIC_REQ__
#define __T_MPHC_STOP_RXLEV_PERIODIC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2149
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_RXLEV_PERIODIC_REQ;
#endif

#ifndef __T_MPHC_STOP_RXLEV_PERIODIC_CON__
#define __T_MPHC_STOP_RXLEV_PERIODIC_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2150
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_RXLEV_PERIODIC_CON;
#endif

#ifndef __T_MPHC_RXLEV_REQ__
#define __T_MPHC_RXLEV_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2151
 */
typedef struct
{
  U32                       shared_ptr;               /*<  0:  4> Pointer                                            */
} T_MPHC_RXLEV_REQ;
#endif

#ifndef __T_MPHC_RXLEV_IND__
#define __T_MPHC_RXLEV_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2152
 */
typedef struct
{
  U32                       shared_ptr;               /*<  0:  4> Pointer                                            */
} T_MPHC_RXLEV_IND;
#endif

#ifndef __T_MPHC_STOP_RXLEV_REQ__
#define __T_MPHC_STOP_RXLEV_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2153
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_RXLEV_REQ;
#endif

#ifndef __T_MPHC_STOP_RXLEV_CON__
#define __T_MPHC_STOP_RXLEV_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2154
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_RXLEV_CON;
#endif

#ifndef __T_MPHC_CONFIG_CBCH_REQ__
#define __T_MPHC_CONFIG_CBCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2155
 */
typedef struct
{
  T_cbch_desc               cbch_desc;                /*<  0: 12> CBCH channel description                           */
  T_cbch_freq_list          cbch_freq_list;           /*< 12:132> CBCH frequency list                                */
} T_MPHC_CONFIG_CBCH_REQ;
#endif

#ifndef __T_MPHC_CBCH_SCHEDULE_REQ__
#define __T_MPHC_CBCH_SCHEDULE_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2156
 */
typedef struct
{
  U8                        cbch_select;              /*<  0:  1> which cbch channel to read                         */
  U8                        schedule_length;          /*<  1:  1> length of schedule period                          */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  U32                       first_blocks_0;           /*<  4:  4> Bitmap defining a set of blocks to be read during the schedule period. The bits represent the blocks as follows: bit MSB=31 -> block=32; bit LSB=0 -> block=1. */
  U16                       first_blocks_1;           /*<  8:  2> Bitmap defining a set of blocks to be read during the schedule period. The bits represent the blocks as follows: bit MSB=15 -> block=48; bit LSB=0 -> block=33. */
  U8                        _align2;                  /*< 10:  1> alignment                                          */
  U8                        _align3;                  /*< 11:  1> alignment                                          */
} T_MPHC_CBCH_SCHEDULE_REQ;
#endif

#ifndef __T_MPHC_CBCH_INFO_REQ__
#define __T_MPHC_CBCH_INFO_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2157
 */
typedef struct
{
  U8                        tb_bitmap;                /*<  0:  1> blocks to read                                     */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_CBCH_INFO_REQ;
#endif

#ifndef __T_MPHC_CBCH_UPDATE_REQ__
#define __T_MPHC_CBCH_UPDATE_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2158
 */
typedef struct
{
  U8                        cbch_select;              /*<  0:  1> which cbch channel to read                         */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  U32                       first_blocks_0;           /*<  4:  4> Bitmap defining a set of blocks to be read during the schedule period. The bits represent the blocks as follows: bit MSB=31 -> block=32; bit LSB=0 -> block=1. */
  U16                       first_blocks_1;           /*<  8:  2> Bitmap defining a set of blocks to be read during the schedule period. The bits represent the blocks as follows: bit MSB=15 -> block=48; bit LSB=0 -> block=33. */
  U8                        _align3;                  /*< 10:  1> alignment                                          */
  U8                        _align4;                  /*< 11:  1> alignment                                          */
} T_MPHC_CBCH_UPDATE_REQ;
#endif

#ifndef __T_MPHC_STOP_CBCH_REQ__
#define __T_MPHC_STOP_CBCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2159
 */
typedef struct
{
  U8                        normal_cbch;              /*<  0:  1> normal cbch                                        */
  U8                        extended_cbch;            /*<  1:  1> extended cbch                                      */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_CBCH_REQ;
#endif

#ifndef __T_MPHC_STOP_CBCH_CON__
#define __T_MPHC_STOP_CBCH_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2160
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_CBCH_CON;
#endif

#ifndef __T_MPHC_NEW_SCELL_REQ__
#define __T_MPHC_NEW_SCELL_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2161
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  U32                       fn_offset;                /*<  4:  4> frame offset                                       */
  U32                       time_alignment;           /*<  8:  4> Difference in quarter bits between the first bit in a frame of the serving cell and the first bit in the next frame of the non-serving cell. Validity of time_alignment dependent upon timing_validity indication. (0 - 4999) */
  U8                        tsc;                      /*< 12:  1> training sequence code                             */
  U8                        _align2;                  /*< 13:  1> alignment                                          */
  U8                        _align3;                  /*< 14:  1> alignment                                          */
  U8                        _align4;                  /*< 15:  1> alignment                                          */
} T_MPHC_NEW_SCELL_REQ;
#endif

#ifndef __T_MPHC_NEW_SCELL_CON__
#define __T_MPHC_NEW_SCELL_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2162
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_NEW_SCELL_CON;
#endif

#ifndef __T_MPHC_RA_REQ__
#define __T_MPHC_RA_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2163
 */
typedef struct
{
  U8                        txpwr;                    /*<  0:  1> Indicates the power level which the mobile should use for transmission . */
  U8                        rand;                     /*<  1:  1> TDMA frames before sending RACH burst              */
  U8                        channel_request;          /*<  2:  1> content of channel request message                 */
// ELEM-FF: !TI_PS_FF_QUAD_BAND_SUPPORT 
//   U8                        powerclass_gsm;           /*<  0:  0> GSM power class of the MS.                         */
// ELEM-FF: !TI_PS_FF_QUAD_BAND_SUPPORT 
//   U8                        powerclass_dcs;           /*<  0:  0> DCS power class of the MS.                         */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
} T_MPHC_RA_REQ;
#endif

#ifndef __T_MPHC_RA_CON__
#define __T_MPHC_RA_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2164
 */
typedef struct
{
  U32                       fn;                       /*<  0:  4> frame number                                       */
  U8                        channel_request;          /*<  4:  1> content of channel request message                 */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U8                        _align1;                  /*<  6:  1> alignment                                          */
  U8                        _align2;                  /*<  7:  1> alignment                                          */
} T_MPHC_RA_CON;
#endif

#ifndef __T_MPHC_STOP_RA_REQ__
#define __T_MPHC_STOP_RA_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2165
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_RA_REQ;
#endif

#ifndef __T_MPHC_STOP_RA_CON__
#define __T_MPHC_STOP_RA_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2166
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_RA_CON;
#endif

#ifndef __T_MPHC_IMMED_ASSIGN_REQ__
#define __T_MPHC_IMMED_ASSIGN_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2167
 */
typedef struct
{
  T_channel_desc            channel_desc;             /*<  0: 12> channel description                                */
  U8                        timing_advance;           /*< 12:  1> timing advance                                     */
  U8                        _align0;                  /*< 13:  1> alignment                                          */
  U8                        _align1;                  /*< 14:  1> alignment                                          */
  U8                        _align2;                  /*< 15:  1> alignment                                          */
  T_frequency_list          frequency_list;           /*< 16:132> frequency list                                     */
  T_starting_time           starting_time;            /*<148:  8> starting time                                      */
  T_frequency_list_bef_sti  frequency_list_bef_sti;   /*<156:132> frequency list before starting time                */
  U8                        maio_bef_sti;             /*<288:  1> MAIO used before starting time                     */
  U8                        dtx_allowed;              /*<289:  1> DTX allowed                                        */
  U8                        _align3;                  /*<290:  1> alignment                                          */
  U8                        _align4;                  /*<291:  1> alignment                                          */
  T_bcch_allocation         bcch_allocation;          /*<292: 68> BCCH allocation                                    */
  U8                        ba_id;                    /*<360:  1> band allocation identification                     */
  U8                        pwrc;                     /*<361:  1> power control indicator                            */
  U8                        _align5;                  /*<362:  1> alignment                                          */
  U8                        _align6;                  /*<363:  1> alignment                                          */
} T_MPHC_IMMED_ASSIGN_REQ;
#endif

#ifndef __T_MPHC_IMMED_ASSIGN_CON__
#define __T_MPHC_IMMED_ASSIGN_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2168
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_IMMED_ASSIGN_CON;
#endif

#ifndef __T_MPHC_CHANNEL_ASSIGN_REQ__
#define __T_MPHC_CHANNEL_ASSIGN_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2169
 */
typedef struct
{
  T_channel_desc_1          channel_desc_1;           /*<  0: 12> channel description                                */
  U8                        channel_mode_1;           /*< 12:  1> channel mode                                       */
  U8                        txpwr;                    /*< 13:  1> Indicates the power level which the mobile should use for transmission . */
  U8                        _align0;                  /*< 14:  1> alignment                                          */
  U8                        _align1;                  /*< 15:  1> alignment                                          */
  T_frequency_list          frequency_list;           /*< 16:132> frequency list                                     */
  T_starting_time           starting_time;            /*<148:  8> starting time                                      */
  T_channel_desc_2          channel_desc_2;           /*<156: 12> channel description                                */
  U8                        channel_mode_2;           /*<168:  1> channel mode                                       */
  U8                        _align2;                  /*<169:  1> alignment                                          */
  U8                        _align3;                  /*<170:  1> alignment                                          */
  U8                        _align4;                  /*<171:  1> alignment                                          */
  T_frequency_list_bef_sti  frequency_list_bef_sti;   /*<172:132> frequency list before starting time                */
  T_channel_desc_1_bef_sti  channel_desc_1_bef_sti;   /*<304: 12> channel description before starting time           */
  T_channel_desc_2_bef_sti  channel_desc_2_bef_sti;   /*<316: 12> channel description before starting time           */
  U8                        cipher_mode;              /*<328:  1> cipher mode                                        */
  U8                        a5_algorithm;             /*<329:  1> A5 algorithm                                       */
  U8                        _align5;                  /*<330:  1> alignment                                          */
  U8                        _align6;                  /*<331:  1> alignment                                          */
  T_cipher_key              cipher_key;               /*<332: 16> encryption key                                     */
  U8                        dtx_allowed;              /*<348:  1> DTX allowed                                        */
  U8                        _align7;                  /*<349:  1> alignment                                          */
  U8                        _align8;                  /*<350:  1> alignment                                          */
  U8                        _align9;                  /*<351:  1> alignment                                          */
  T_amr_configuration       amr_configuration;        /*<352: 12> Parameters for AMR                                 */
} T_MPHC_CHANNEL_ASSIGN_REQ;
#endif

#ifndef __T_MPHC_CHANNEL_ASSIGN_CON__
#define __T_MPHC_CHANNEL_ASSIGN_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2170
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_CHANNEL_ASSIGN_CON;
#endif

#ifndef __T_MPHC_ASYNC_HO_REQ__
#define __T_MPHC_ASYNC_HO_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2171
 */
typedef struct
{
  T_handover_command        handover_command;         /*<  0:340> Handover Command                                   */
  U32                       fn_offset;                /*<340:  4> frame offset                                       */
  U32                       time_alignmnt;            /*<344:  4> Difference in quarter bits between serving and handover destination cell (0 to 5000) */
  T_cipher_key              cipher_key;               /*<348: 16> encryption key                                     */
  T_amr_configuration       amr_configuration;        /*<364: 12> Parameters for AMR                                 */
// ELEM-FF: REL99 AND FF_BHO 
  U8                        handover_type;            /*<376:  1> handover type                                      */
  U8                        _align0;                  /*<377:  1> alignment                                          */
  U8                        _align1;                  /*<378:  1> alignment                                          */
  U8                        _align2;                  /*<379:  1> alignment                                          */
} T_MPHC_ASYNC_HO_REQ;
#endif

#ifndef __T_MPHC_ASYNC_HO_CON__
#define __T_MPHC_ASYNC_HO_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2172
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_ASYNC_HO_CON;
#endif

#ifndef __T_MPHC_HANDOVER_FINISHED__
#define __T_MPHC_HANDOVER_FINISHED__
/*
 * 
 * CCDGEN:WriteStruct_Count==2173
 */
typedef struct
{
  U8                        cause;                    /*<  0:  1> handover success                                   */
// ELEM-FF: REL99 AND FF_BHO 
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  U32                       fn_offset;                /*<  4:  4> frame offset                                       */
// ELEM-FF: REL99 AND FF_BHO 
  U32                       time_alignment;           /*<  8:  4> Difference in quarter bits between the first bit in a frame of the serving cell and the first bit in the next frame of the non-serving cell. Validity of time_alignment dependent upon timing_validity indication. (0 - 4999) */
} T_MPHC_HANDOVER_FINISHED;
#endif

#ifndef __T_MPHC_SYNC_HO_REQ__
#define __T_MPHC_SYNC_HO_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2174
 */
typedef struct
{
  T_handover_command        handover_command;         /*<  0:340> Handover Command                                   */
  U32                       fn_offset;                /*<340:  4> frame offset                                       */
  U32                       time_alignmnt;            /*<344:  4> Difference in quarter bits between serving and handover destination cell (0 to 5000) */
  T_cipher_key              cipher_key;               /*<348: 16> encryption key                                     */
  U8                        nci;                      /*<364:  1> normal cell indication                             */
  U8                        _align0;                  /*<365:  1> alignment                                          */
  U8                        _align1;                  /*<366:  1> alignment                                          */
  U8                        _align2;                  /*<367:  1> alignment                                          */
  T_amr_configuration       amr_configuration;        /*<368: 12> Parameters for AMR                                 */
// ELEM-FF: REL99 AND FF_BHO 
  U8                        handover_type;            /*<380:  1> handover type                                      */
  U8                        _align3;                  /*<381:  1> alignment                                          */
  U8                        _align4;                  /*<382:  1> alignment                                          */
  U8                        _align5;                  /*<383:  1> alignment                                          */
} T_MPHC_SYNC_HO_REQ;
#endif

#ifndef __T_MPHC_SYNC_HO_CON__
#define __T_MPHC_SYNC_HO_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2175
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_SYNC_HO_CON;
#endif

#ifndef __T_MPHC_TA_FAIL_IND__
#define __T_MPHC_TA_FAIL_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2176
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_TA_FAIL_IND;
#endif

#ifndef __T_MPHC_PRE_SYNC_HO_REQ__
#define __T_MPHC_PRE_SYNC_HO_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2177
 */
typedef struct
{
  T_handover_command        handover_command;         /*<  0:340> Handover Command                                   */
  U32                       fn_offset;                /*<340:  4> frame offset                                       */
  U32                       time_alignmnt;            /*<344:  4> Difference in quarter bits between serving and handover destination cell (0 to 5000) */
  T_cipher_key              cipher_key;               /*<348: 16> encryption key                                     */
  U8                        nci;                      /*<364:  1> normal cell indication                             */
  U8                        timing_advance_valid;     /*<365:  1> timing advance information valid flag              */
  U8                        timing_advance;           /*<366:  1> timing advance                                     */
  U8                        _align0;                  /*<367:  1> alignment                                          */
  T_amr_configuration       amr_configuration;        /*<368: 12> Parameters for AMR                                 */
// ELEM-FF: REL99 AND FF_BHO 
  U8                        handover_type;            /*<380:  1> handover type                                      */
  U8                        _align1;                  /*<381:  1> alignment                                          */
  U8                        _align2;                  /*<382:  1> alignment                                          */
  U8                        _align3;                  /*<383:  1> alignment                                          */
} T_MPHC_PRE_SYNC_HO_REQ;
#endif

#ifndef __T_MPHC_PRE_SYNC_HO_CON__
#define __T_MPHC_PRE_SYNC_HO_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2178
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_PRE_SYNC_HO_CON;
#endif

#ifndef __T_MPHC_HANDOVER_FAIL_REQ__
#define __T_MPHC_HANDOVER_FAIL_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2179
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_HANDOVER_FAIL_REQ;
#endif

#ifndef __T_MPHC_HANDOVER_FAIL_CON__
#define __T_MPHC_HANDOVER_FAIL_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2180
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_HANDOVER_FAIL_CON;
#endif

#ifndef __T_MPHC_CHANGE_FREQUENCY__
#define __T_MPHC_CHANGE_FREQUENCY__
/*
 * 
 * CCDGEN:WriteStruct_Count==2181
 */
typedef struct
{
  T_channel_desc            channel_desc;             /*<  0: 12> channel description                                */
  T_frequency_list          frequency_list;           /*< 12:132> frequency list                                     */
  T_starting_time           starting_time;            /*<144:  8> starting time                                      */
} T_MPHC_CHANGE_FREQUENCY;
#endif

#ifndef __T_MPHC_CHANGE_FREQUENCY_CON__
#define __T_MPHC_CHANGE_FREQUENCY_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2182
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_CHANGE_FREQUENCY_CON;
#endif

#ifndef __T_MPHC_CHANNEL_MODE_MODIFY_REQ__
#define __T_MPHC_CHANNEL_MODE_MODIFY_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2183
 */
typedef struct
{
  U8                        sub_channel;              /*<  0:  1> sub channel                                        */
  U8                        channel_mode;             /*<  1:  1> channel mode                                       */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  T_amr_configuration       amr_configuration;        /*<  4: 12> Parameters for AMR                                 */
} T_MPHC_CHANNEL_MODE_MODIFY_REQ;
#endif

#ifndef __T_MPHC_CHANNEL_MODE_MODIFY_CON__
#define __T_MPHC_CHANNEL_MODE_MODIFY_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2184
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_CHANNEL_MODE_MODIFY_CON;
#endif

#ifndef __T_MPHC_SET_CIPHERING_REQ__
#define __T_MPHC_SET_CIPHERING_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2185
 */
typedef struct
{
  U8                        cipher_mode;              /*<  0:  1> cipher mode                                        */
  U8                        a5_algorithm;             /*<  1:  1> A5 algorithm                                       */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  T_new_ciph_param          new_ciph_param;           /*<  4: 16> Cipher Key Kc                                      */
} T_MPHC_SET_CIPHERING_REQ;
#endif

#ifndef __T_MPHC_SET_CIPHERING_CON__
#define __T_MPHC_SET_CIPHERING_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2186
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_SET_CIPHERING_CON;
#endif

#ifndef __T_MPHC_MEAS_REPORT__
#define __T_MPHC_MEAS_REPORT__
/*
 * 
 * CCDGEN:WriteStruct_Count==2187
 */
typedef struct
{
  U8                        dtx_used;                 /*<  0:  1> DTX used flag                                      */
  U8                        meas_valid;               /*<  1:  1> measurement valid flag                             */
  U16                       rxlev_full_acc;           /*<  2:  2> rxlevel full serving cell accumulated              */
  U8                        rxlev_full_nbr_meas;      /*<  4:  1> number of rxlevel full serving cell samples        */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U16                       rxlev_sub_acc;            /*<  6:  2> rxlevel sub serving cell accumulated               */
  U8                        rxlev_sub_nbr_meas;       /*<  8:  1> number of rxlevel sub serving cell samples         */
  U8                        _align1;                  /*<  9:  1> alignment                                          */
  U16                       rxqual_full_acc_errors;   /*< 10:  2> rxqual full serving cell bit errors                */
  U16                       rxqual_full_nbr_bits;     /*< 12:  2> number of examined bits for rxqual full serving cell */
  U16                       rxqual_sub_acc_errors;    /*< 14:  2> rxlevel sub serving cell bit errors                */
  U16                       rxqual_sub_nbr_bits;      /*< 16:  2> number of examined bits for rxqual sub serving cell */
  U8                        no_of_ncells_meas;        /*< 18:  1> number of neighbour cell results                   */
  U8                        _align2;                  /*< 19:  1> alignment                                          */
  T_ncell_meas              ncell_meas;               /*< 20:264> neighbour cell measurement results                 */
  U8                        ba_id;                    /*<284:  1> band allocation identification                     */
  U8                        timing_advance;           /*<285:  1> timing advance                                     */
  U8                        txpwr_used;               /*<286:  1> TX power level currently used by L1 (For TEST MOBILE only). */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        _align3;                  /*<287:  1> alignment                                          */
  S16                       rxlev_val_acc;            /*<288:  2> RXLEV accumuated on SACCH for EMR                  */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        rxlev_val_nbr_meas;       /*<290:  1> Number of rxlev_val measurements taken on serving cell */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        _align4;                  /*<291:  1> alignment                                          */
  U32                       mean_bep_block_acc;       /*<292:  4> Accumulated value of Mean Bit Error Probability of a block taken over a reporting period. */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U16                       cv_bep_block_acc;         /*<296:  2> Accumulated value of coefficient of variation of BEP of a block taken over a reporting period. */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U16                       mean_bep_block_num;       /*<298:  2> Number of block used to accumulate the MEAN_BEPblock */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U16                       cv_bep_block_num;         /*<300:  2> Number of block used to accumulate the CV_BEPblock */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        nbr_rcvd_blocks;          /*<302:  1> Number of correctly decoded block during a reporting period. */
  U8                        facch_dl_count;           /*<303:  1> reserved                                           */
  U8                        facch_ul_count;           /*<304:  1> reserved                                           */
  U8                        _align5;                  /*<305:  1> alignment                                          */
  U8                        _align6;                  /*<306:  1> alignment                                          */
  U8                        _align7;                  /*<307:  1> alignment                                          */
} T_MPHC_MEAS_REPORT;
#endif

#ifndef __T_MPHC_UPDATE_BA_LIST__
#define __T_MPHC_UPDATE_BA_LIST__
/*
 * 
 * CCDGEN:WriteStruct_Count==2188
 */
typedef struct
{
  U8                        num_of_chans;             /*<  0:  1> Number of valid carrier numbers contained in the BA list (chan_number) array (1 to 33) */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_chan_list               chan_list;                /*<  4: 68> channel list                                       */
  U8                        pwrc;                     /*< 72:  1> power control indicator                            */
  U8                        dtx_allowed;              /*< 73:  1> DTX allowed                                        */
  U8                        ba_id;                    /*< 74:  1> band allocation identification                     */
  U8                        _align3;                  /*< 75:  1> alignment                                          */
} T_MPHC_UPDATE_BA_LIST;
#endif

#ifndef __T_MPHC_STOP_DEDICATED_REQ__
#define __T_MPHC_STOP_DEDICATED_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2189
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_DEDICATED_REQ;
#endif

#ifndef __T_MPHC_NCELL_FB_SB_READ__
#define __T_MPHC_NCELL_FB_SB_READ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2190
 */
typedef struct
{
  U16                       radio_freq;               /*<  0:  2> channel number                                     */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_MPHC_NCELL_FB_SB_READ;
#endif

#ifndef __T_MPHC_NCELL_SB_READ__
#define __T_MPHC_NCELL_SB_READ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2191
 */
typedef struct
{
  U8                        sb_flag;                  /*<  0:  1> Flag indicating whether synchronisation channel was read correctly or not */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       radio_freq;               /*<  2:  2> channel number                                     */
  U8                        bsic;                     /*<  4:  1> base station identification code                   */
  U8                        _align1;                  /*<  5:  1> alignment                                          */
  U8                        _align2;                  /*<  6:  1> alignment                                          */
  U8                        _align3;                  /*<  7:  1> alignment                                          */
  U32                       fn_offset;                /*<  8:  4> frame offset                                       */
  U32                       time_alignmnt;            /*< 12:  4> Difference in quarter bits between serving and handover destination cell (0 to 5000) */
} T_MPHC_NCELL_SB_READ;
#endif

#ifndef __T_OML1_CLOSE_TCH_LOOP_REQ__
#define __T_OML1_CLOSE_TCH_LOOP_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2192
 */
typedef struct
{
  U8                        sub_channel;              /*<  0:  1> sub channel                                        */
  U8                        frame_erasure;            /*<  1:  1> TCH loop type                                      */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_OML1_CLOSE_TCH_LOOP_REQ;
#endif

#ifndef __T_OML1_CLOSE_TCH_LOOP_CON__
#define __T_OML1_CLOSE_TCH_LOOP_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2193
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_OML1_CLOSE_TCH_LOOP_CON;
#endif

#ifndef __T_OML1_OPEN_TCH_LOOP_REQ__
#define __T_OML1_OPEN_TCH_LOOP_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2194
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_OML1_OPEN_TCH_LOOP_REQ;
#endif

#ifndef __T_OML1_OPEN_TCH_LOOP_CON__
#define __T_OML1_OPEN_TCH_LOOP_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2195
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_OML1_OPEN_TCH_LOOP_CON;
#endif

#ifndef __T_OML1_START_DAI_TEST_REQ__
#define __T_OML1_START_DAI_TEST_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2196
 */
typedef struct
{
  U8                        tested_device;            /*<  0:  1> DAI test device                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_OML1_START_DAI_TEST_REQ;
#endif

#ifndef __T_OML1_START_DAI_TEST_CON__
#define __T_OML1_START_DAI_TEST_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2197
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_OML1_START_DAI_TEST_CON;
#endif

#ifndef __T_OML1_STOP_DAI_TEST_REQ__
#define __T_OML1_STOP_DAI_TEST_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2198
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_OML1_STOP_DAI_TEST_REQ;
#endif

#ifndef __T_OML1_STOP_DAI_TEST_CON__
#define __T_OML1_STOP_DAI_TEST_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2199
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_OML1_STOP_DAI_TEST_CON;
#endif

#ifndef __T_TST_SLEEP_REQ__
#define __T_TST_SLEEP_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2200
 */
typedef struct
{
  U8                        sleep_mode;               /*<  0:  1> sleep mode                                         */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       Clocks;                   /*<  2:  2> clock modules                                      */
} T_TST_SLEEP_REQ;
#endif

#ifndef __T_MPHC_ADC_IND__
#define __T_MPHC_ADC_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2201
 */
typedef struct
{
  U16                       adc_results[9];           /*<  0: 18> result                                             */
  U8                        _align0;                  /*< 18:  1> alignment                                          */
  U8                        _align1;                  /*< 19:  1> alignment                                          */
} T_MPHC_ADC_IND;
#endif

#ifndef __T_MPHC_INIT_L1_REQ__
#define __T_MPHC_INIT_L1_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2202
 */
typedef struct
{
// ELEM-FF: !TI_PS_FF_QUAD_BAND_SUPPORT 
//   U8                        radio_band_config;        /*<  0:  0> Bitmap of frequency bands                          */
// ELEM-FF: TI_PS_FF_QUAD_BAND_SUPPORT 
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_INIT_L1_REQ;
#endif

#ifndef __T_MPHC_INIT_L1_CON__
#define __T_MPHC_INIT_L1_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2203
 */
typedef struct
{
// ELEM-FF: !TI_PS_FF_QUAD_BAND_SUPPORT 
//   U8                        param;                    /*<  0:  0> dummy parameter                                    */
// ELEM-FF: TI_PS_FF_QUAD_BAND_SUPPORT 
  T_multiband_power_class   multiband_power_class[NB_MAX_GSM_BANDS]; /*<  0: 48> Power Class information for multiple bands         */
} T_MPHC_INIT_L1_CON;
#endif

#ifndef __T_MPHC_DEACTIVATE_REQ__
#define __T_MPHC_DEACTIVATE_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2204
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_DEACTIVATE_REQ;
#endif

#ifndef __T_TST_TEST_HW_REQ__
#define __T_TST_TEST_HW_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2205
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_TST_TEST_HW_REQ;
#endif

#ifndef __T_TST_TEST_HW_CON__
#define __T_TST_TEST_HW_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2206
 */
typedef struct
{
  U16                       dsp_code_version;         /*<  0:  2> Version number of the DSP code                     */
  U16                       dsp_checksum;             /*<  2:  2> Checksum of DSP code                               */
  U16                       dsp_patch_version;        /*<  4:  2> Version number of the DSP patch code               */
  U16                       mcu_alr_version;          /*<  6:  2> Version  number of the MCU ALR code                */
  U16                       mcu_gprs_version;         /*<  8:  2> Version  number of the MCU GPRS code               */
  U16                       mcu_tm_version;           /*< 10:  2> Version  number of the Testmode                    */
} T_TST_TEST_HW_CON;
#endif

#ifndef __T_PH_DATA_IND__
#define __T_PH_DATA_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2207
 */
typedef struct
{
  U16                       rf_chan_num;              /*<  0:  2> channel number                                     */
  U8                        l2_channel_type;          /*<  2:  1> layer 2 channel type                               */
  U8                        error_cause;              /*<  3:  1> error cause                                        */
  T_RADIO_FRAME             l2_frame;                 /*<  4: 24> Layer 2 frame                                      */
  U8                        bsic;                     /*< 28:  1> base station identification code                   */
  U8                        tc;                       /*< 29:  1> multiframe number modulo 8                         */
  U8                        _align0;                  /*< 30:  1> alignment                                          */
  U8                        _align1;                  /*< 31:  1> alignment                                          */
} T_PH_DATA_IND;
#endif

#ifndef __T_MPHC_STOP_DEDICATED_CON__
#define __T_MPHC_STOP_DEDICATED_CON__
/*
 * 
 * CCDGEN:WriteStruct_Count==2208
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPHC_STOP_DEDICATED_CON;
#endif


#include "CDG_LEAVE.h"


#endif
