/*
+--------------------------------------------------------------------------+
| PROJECT : PROTOCOL STACK                                                 |
| FILE    : p_mph.h                                                        |
| SOURCE  : "__out__\LNX_TI_cgt2_70\rel_n5_camera_micron\cdginc\condat\ms\doc\sap\mph.pdf"                 |
| LastModified : "2003-02-04"                                              |
| IdAndVersion : "6148.109.01.207"                                         |
| SrcFileTime  : "Mon Aug 11 13:32:48 2008"                                |
| Generated by CCDGEN_2.5.5A on Wed Mar 11 09:58:58 2009                   |
|           !!DO NOT MODIFY!!DO NOT MODIFY!!DO NOT MODIFY!!                |
+--------------------------------------------------------------------------+
*/

/* PRAGMAS
 * PREFIX                 : NONE
 * COMPATIBILITY_DEFINES  : NO (require PREFIX)
 * ALWAYS_ENUM_IN_VAL_FILE: NO
 * ENABLE_GROUP: NO
 * CAPITALIZE_TYPENAME: NO
 */


#ifndef P_MPH_H
#define P_MPH_H


#define CDG_ENTER__P_MPH_H

#define CDG_ENTER__FILENAME _P_MPH_H
#define CDG_ENTER__P_MPH_H__FILE_TYPE CDGINC
#define CDG_ENTER__P_MPH_H__LAST_MODIFIED _2003_02_04
#define CDG_ENTER__P_MPH_H__ID_AND_VERSION _6148_109_01_207

#define CDG_ENTER__P_MPH_H__SRC_FILE_TIME _Mon_Aug_11_13_32_48_2008

#include "CDG_ENTER.h"

#undef CDG_ENTER__P_MPH_H

#undef CDG_ENTER__FILENAME


#include "p_mph.val"

#ifndef __T_cbch__
#define __T_cbch__
/*
 * cell broadcast channel
 * CCDGEN:WriteStruct_Count==2025
 */
typedef struct
{
  U8                        stat;                     /*<  0:  1> status                                             */
  U8                        ch;                       /*<  1:  1> channel type                                       */
  U8                        tn;                       /*<  2:  1> timeslot number                                    */
  U8                        tsc;                      /*<  3:  1> trainings sequence code                            */
  U8                        h;                        /*<  4:  1> hopping                                            */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U16                       arfcn;                    /*<  6:  2> channel number                                     */
  U8                        maio;                     /*<  8:  1> mobile allocation index offset                     */
  U8                        hsn;                      /*<  9:  1> hopping sequence number                            */
  U16                       ma[MAX_MA_CHANNELS];      /*< 10:128> channel number in the mobile allocation list (used with frequency hopping) */
  U8                        _align1;                  /*<138:  1> alignment                                          */
  U8                        _align2;                  /*<139:  1> alignment                                          */
} T_cbch;
#endif

#ifndef __T_ncells__
#define __T_ncells__
/*
 * neighbour cell measurement results
 * CCDGEN:WriteStruct_Count==2026
 */
typedef struct
{
  U8                        no_of_ncells;             /*<  0:  1> Number of ncells                                   */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       arfcn[MAX_NUM_CELLS_IN_REPORT]; /*<  2: 64> channel number                                     */
  U8                        rx_lev[MAX_NUM_CELLS_IN_REPORT]; /*< 66: 32> received field strength                            */
  U8                        bsic[MAX_NUM_CELLS_IN_REPORT]; /*< 98: 32> base station identification code                   */
  U8                        _align1;                  /*<130:  1> alignment                                          */
  U8                        _align2;                  /*<131:  1> alignment                                          */
  U32                       time_alignmt[MAX_NUM_CELLS_IN_REPORT]; /*<132:128> timing alignment; refers to difference in time between serving and neighbour cell */
  U32                       frame_offset[MAX_NUM_CELLS_IN_REPORT]; /*<260:128> frame offset; refers to difference in time between serving and neighbour cell */
} T_ncells;
#endif

#ifndef __T_start__
#define __T_start__
/*
 * starting time
 * CCDGEN:WriteStruct_Count==2027
 */
typedef struct
{
  U8                        v_start;                  /*<  0:  1> starting time valid                                */
  U8                        t1;                       /*<  1:  1> reduced frame number modula 32                     */
  U8                        t2;                       /*<  2:  1> reduced frame number modula 26                     */
  U8                        t3;                       /*<  3:  1> reduced frame number modula 51                     */
} T_start;
#endif

#ifndef __T_ch_type__
#define __T_ch_type__
/*
 * channel type configuration
 * CCDGEN:WriteStruct_Count==2028
 */
typedef struct
{
  U8                        ch;                       /*<  0:  1> channel type                                       */
  U8                        tn;                       /*<  1:  1> timeslot number                                    */
  U8                        tsc;                      /*<  2:  1> trainings sequence code                            */
  U8                        h;                        /*<  3:  1> hopping                                            */
  U16                       arfcn;                    /*<  4:  2> channel number                                     */
  U8                        maio;                     /*<  6:  1> mobile allocation index offset                     */
  U8                        hsn;                      /*<  7:  1> hopping sequence number                            */
  U16                       ma[MAX_MA_CHANNELS];      /*<  8:128> channel number in the mobile allocation list (used with frequency hopping) */
} T_ch_type;
#endif

/*
 * channel type
 * CCDGEN:WriteStruct_Count==2029
 */
#ifndef __T_ch_type2__
#define __T_ch_type2__
typedef T_ch_type T_ch_type2;
#endif
#ifndef __T_tr_para__
#define __T_tr_para__
/*
 * transmission parameter
 * CCDGEN:WriteStruct_Count==2030
 */
typedef struct
{
  U8                        power;                    /*<  0:  1> transmission power level                           */
  U8                        dtx;                      /*<  1:  1> discontinuous transmission                         */
  U8                        rlt;                      /*<  2:  1> radio link timeout                                 */
  U8                        tav;                      /*<  3:  1> timing advance                                     */
  U8                        pwrc;                     /*<  4:  1> power control indicator                            */
  U8                        mode;                     /*<  5:  1> channel mode                                       */
  U8                        _align0;                  /*<  6:  1> alignment                                          */
  U8                        _align1;                  /*<  7:  1> alignment                                          */
} T_tr_para;
#endif

#ifndef __T_ciph__
#define __T_ciph__
/*
 * ciphering parameters
 * CCDGEN:WriteStruct_Count==2031
 */
typedef struct
{
  U8                        stat;                     /*<  0:  1> status                                             */
  U8                        algo;                     /*<  1:  1> Algorithm                                          */
  U8                        kc[KC_STRING_SIZE];       /*<  2: 16> Kc value; the format in the GTI case is as on the SIM; the least significant bit of kc is the least significant bit of the eighth byte; the most significant bit of kc is the most significant bit of the first byte. */
  U8                        _align0;                  /*< 18:  1> alignment                                          */
  U8                        _align1;                  /*< 19:  1> alignment                                          */
} T_ciph;
#endif

#ifndef __T_cod_prop__
#define __T_cod_prop__
/*
 * codec properties
 * CCDGEN:WriteStruct_Count==2032
 */
typedef struct
{
  U8                        codec_thr;                /*<  0:  1> Codec threshold                                    */
  U8                        codec_hyst;               /*<  1:  1> Codec hysteresis                                   */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_cod_prop;
#endif

#ifndef __T_amr_conf__
#define __T_amr_conf__
/*
 * Parameters for AMR
 * CCDGEN:WriteStruct_Count==2033
 */
typedef struct
{
  U8                        nscb;                     /*<  0:  1> noise suppression control bit                      */
  U8                        icmi;                     /*<  1:  1> initial code mode indicator                        */
  U8                        st_mode;                  /*<  2:  1> initial code mode                                  */
  U8                        acs;                      /*<  3:  1> active codec set                                   */
  U8                        v_cod_prop;               /*<  4:  1> valid flag codec properties                        */
  U8                        c_cod_prop;               /*<  5:  1> counter                                            */
  U8                        _align0;                  /*<  6:  1> alignment                                          */
  U8                        _align1;                  /*<  7:  1> alignment                                          */
  T_cod_prop                cod_prop[3];              /*<  8: 12> codec properties                                   */
} T_amr_conf;
#endif

#ifndef __T_classmark__
#define __T_classmark__
/*
 * classmark
 * CCDGEN:WriteStruct_Count==2034
 */
typedef struct
{
  U8                        pclass;                   /*<  0:  1> power class                                        */
  U8                        pclass2;                  /*<  1:  1> power class 2                                      */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_classmark;
#endif

#ifndef __T_ho_param__
#define __T_ho_param__
/*
 * handover parameter
 * CCDGEN:WriteStruct_Count==2035
 */
typedef struct
{
  U8                        ho_ref;                   /*<  0:  1> reference                                          */
  U8                        ho_pow;                   /*<  1:  1> transmission power level                           */
  U8                        ho_acc_type;              /*<  2:  1> access type                                        */
  U8                        ho_nci;                   /*<  3:  1> normal cell indication                             */
} T_ho_param;
#endif

#ifndef __T_mid__
#define __T_mid__
/*
 * Mobile identities
 * CCDGEN:WriteStruct_Count==2036
 */
typedef struct
{
  U8                        len_imsi;                 /*<  0:  1> Length of IMSI                                     */
  U8                        imsi[15];                 /*<  1: 15> IMSI digits                                        */
  U8                        v_tmsi;                   /*< 16:  1> Valid TMSI flag                                    */
  U8                        _align0;                  /*< 17:  1> alignment                                          */
  U8                        _align1;                  /*< 18:  1> alignment                                          */
  U8                        _align2;                  /*< 19:  1> alignment                                          */
  U32                       tmsi;                     /*< 20:  4> Binary TMSI representatino                         */
  U8                        v_ptmsi;                  /*< 24:  1> Valid PTMSI flag; can indicate'valid'only for the GPRS supporting terminal */
  U8                        _align3;                  /*< 25:  1> alignment                                          */
  U8                        _align4;                  /*< 26:  1> alignment                                          */
  U8                        _align5;                  /*< 27:  1> alignment                                          */
  U32                       ptmsi;                    /*< 28:  4> Binary PTMSI representatino                        */
  U8                        v_ptmsi2;                 /*< 32:  1> Valid PTMSI flag; can indicate'valid'only for the GPRS supporting terminal */
  U8                        _align6;                  /*< 33:  1> alignment                                          */
  U8                        _align7;                  /*< 34:  1> alignment                                          */
  U8                        _align8;                  /*< 35:  1> alignment                                          */
  U32                       ptmsi2;                   /*< 36:  4> Binary PTMSI representatino                        */
} T_mid;
#endif

#ifndef __T_send_mode__
#define __T_send_mode__
/*
 * RACH sending mode
 * CCDGEN:WriteStruct_Count==2037
 */
typedef struct
{
  U8                        c;                        /*<  0:  1> dummy; unused, reserved                            */
  U8                        no;                       /*<  1:  1> number of RACH messages; this number includes re-transmissions and the first, initial RACH burst, i.e. no = M +1, where M is as defined in GSM 04.08's specification of the initiation of the immediate assignment procedure */
  U8                        delta[MAX_RACH_REQ];      /*<  2:  8> time in TDMA frames between bursts; delta[0]corresponds to the time between MPH_RANDOM_ACCESS_REQ and the first RACH burst, delta[1]to the time between the first and the 2nd RACH burst and so on */
  U8                        rach[MAX_RACH_REQ];       /*< 10:  8> channel request content burst n; rach[0]corresponds to the contents of the first RACH burst, rach[1]to the 2nd and so on */
  U8                        _align0;                  /*< 18:  1> alignment                                          */
  U8                        _align1;                  /*< 19:  1> alignment                                          */
} T_send_mode;
#endif

#ifndef __T_frame_no__
#define __T_frame_no__
/*
 * reduced frame number
 * CCDGEN:WriteStruct_Count==2038
 */
typedef struct
{
  U8                        t1;                       /*<  0:  1> reduced frame number modula 32                     */
  U8                        t2;                       /*<  1:  1> reduced frame number modula 26                     */
  U8                        t3;                       /*<  2:  1> reduced frame number modula 51                     */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
} T_frame_no;
#endif

#ifndef __T_meas_results__
#define __T_meas_results__
/*
 * neighbourcell measurement results
 * CCDGEN:WriteStruct_Count==2040
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        rx_lev;                   /*<  2:  1> received field strength                            */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
} T_meas_results;
#endif

#ifndef __T_eotd_sc_res__
#define __T_eotd_sc_res__
/*
 * EOTD SC Results at start of measurement
 * CCDGEN:WriteStruct_Count==2041
 */
typedef struct
{
  U8                        sb_flag;                  /*<  0:  1> Valid flag                                         */
  U8                        bsic;                     /*<  1:  1> base station identification code                   */
  U16                       arfcn;                    /*<  2:  2> channel number                                     */
  S16                       eotd_crosscor[XCOR_NO];   /*<  4: 36> Cross correlation                                  */
  U32                       d_eotd_nrj;               /*< 40:  4> Sum of Amplitudes                                  */
  U32                       time_tag;                 /*< 44:  4> Time tag                                           */
} T_eotd_sc_res;
#endif

/*
 * EOTD SC Results at stop of measurement
 * CCDGEN:WriteStruct_Count==2042
 */
#ifndef __T_eotd_sc_res1__
#define __T_eotd_sc_res1__
typedef T_eotd_sc_res T_eotd_sc_res1;
#endif
/*
 * EOTD NC Results
 * CCDGEN:WriteStruct_Count==2043
 */
#ifndef __T_eotd_nc_res__
#define __T_eotd_nc_res__
typedef T_eotd_sc_res T_eotd_nc_res;
#endif
#ifndef __T_ncell_eotd__
#define __T_ncell_eotd__
/*
 * Parameters of a neighbour cell
 * CCDGEN:WriteStruct_Count==2044
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        bsic;                     /*<  2:  1> base station identification code                   */
  U8                        mfrm_offset;              /*<  3:  1> multiframe offset                                  */
  U8                        otd_type;                 /*<  4:  1> OTD type                                           */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U16                       exp_otd;                  /*<  6:  2> expectedOTD                                        */
  U8                        uncertainty;              /*<  8:  1> Uncertainty of expected OTD                        */
  U8                        _align1;                  /*<  9:  1> alignment                                          */
  U16                       rough_rtd;                /*< 10:  2> rough RTD                                          */
} T_ncell_eotd;
#endif

#ifndef __T_meas_rep__
#define __T_meas_rep__
/*
 * meas report to RR
 * CCDGEN:WriteStruct_Count==2045
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        bsic;                     /*<  2:  1> base station identification code                   */
  U8                        rx_lev;                   /*<  3:  1> received field strength                            */
} T_meas_rep;
#endif

#ifndef __T_list__
#define __T_list__
/*
 * stores a list of frequencies
 * CCDGEN:WriteStruct_Count==2046
 */
typedef struct
{
  U8                        channels[LIST_MAX_SIZE];  /*<  0:128> Stores list of ARFCNS                              */
} T_list;
#endif

#ifndef __T_black_list__
#define __T_black_list__
/*
 * Contains a separate  bit map of  Black Listed carries for Euro / American regions
 * CCDGEN:WriteStruct_Count==2047
 */
typedef struct
{
  T_list                    list[MAX_REGIONS];        /*<  0:256> stores a list of frequencies                       */
} T_black_list;
#endif

#ifndef __T_white_list__
#define __T_white_list__
/*
 * contains the bitmap of carriers present in the 'White List'
 * CCDGEN:WriteStruct_Count==2048
 */
typedef struct
{
  U8                        white_list_valid;         /*<  0:  1> Indicates whether 'White List' is valid or not     */
  U8                        region;                   /*<  1:  1> Indicates whether 'White List'belongs to European or American region */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  T_list                    list;                     /*<  4:128> stores a list of frequencies                       */
} T_white_list;
#endif

#ifndef __T_inactive_carrier_list__
#define __T_inactive_carrier_list__
/*
 * Contains the bitmap of inactive carriers in the current location
 * CCDGEN:WriteStruct_Count==2049
 */
typedef struct
{
  T_list                    list[MAX_REGIONS];        /*<  0:256> stores a list of frequencies                       */
} T_inactive_carrier_list;
#endif


// STRUCT-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
#ifndef __T_enh_cell_list__
#define __T_enh_cell_list__
/*
 * Enhanced cell list
 * CCDGEN:WriteStruct_Count==2050
 */
typedef struct
{
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        bsic;                     /*<  2:  1> base station identification code                   */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        rep_priority;             /*<  3:  1> Reporting priority of a cell                       */
// ELEM-FF: REL99 AND TI_PS_FF_RTD 
  U8                        v_rtd;                    /*<  4:  1> valid-flag                                         */
  U8                        c_rtd;                    /*<  5:  1> counter                                            */
  U16                       rtd[MAX_NUM_OF_RTD_VALUES]; /*<  6:  6> Real Time Difference value for all the neighbour cells  */
} T_enh_cell_list;
#endif


// STRUCT-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
#ifndef __T_enh_rep_data__
#define __T_enh_rep_data__
/*
 * Enhanced data for reporting
 * CCDGEN:WriteStruct_Count==2051
 */
typedef struct
{
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        rep_threshold;            /*<  0:  1> Reporting threshold                                */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        rep_offset;               /*<  1:  1> Reporting offset                                   */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_enh_rep_data;
#endif


// STRUCT-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
#ifndef __T_enh_para_struct__
#define __T_enh_para_struct__
/*
 * Enhanced measurement parameters
 * CCDGEN:WriteStruct_Count==2052
 */
typedef struct
{
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        num_valid_cells;          /*<  0:  1> Indicates number of cells valid in cell list in enh para */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_enh_cell_list           enh_cell_list[MAX_NEIGHBOURCELLS]; /*<  4:396> Enhanced cell list                                 */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        rep_rate;                 /*<400:  1> Reporting rate                                     */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        inv_bsic_enabled;         /*<401:  1> Is Invalid BSIC reporting enabled?                 */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        ncc_permitted;            /*<402:  1> NCC permitted bitmap                               */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        multiband_rep;            /*<403:  1> Number of cells, in each non-serving cell band, to be reported  */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        servingband_rep;          /*<404:  1> Number of cells, in serving cell band, to be reported */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        scale_order;              /*<405:  1> Basic Element                                      */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        _align3;                  /*<406:  1> alignment                                          */
  U8                        _align4;                  /*<407:  1> alignment                                          */
  T_enh_rep_data            enh_rep_data[MAX_NUM_BANDS]; /*<408: 20> Enhanced data for reporting                        */
} T_enh_para_struct;
#endif


/*
 * End of substructure section, begin of primitive definition section
 */

#ifndef __T_MPH_POWER_REQ__
#define __T_MPH_POWER_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2054
 */
typedef struct
{
  U8                        pch_interrupt;            /*<  0:  1> PCH Interrupt                                      */
  U8                        freq_bands;               /*<  1:  1> Bitmap of frequency bands                          */
  U8                        search_mode;              /*<  2:  1> Basic Element                                      */
  U8                        lower_rxlevel_threshold[MAX_NUM_BANDS]; /*<  3:  5> lower rxlevel thershold for GSM channels           */
  T_black_list              black_list;               /*<  8:256> Contains a separate  bit map of  Black Listed carries for Euro / American regions */
  T_white_list              white_list;               /*<264:132> contains the bitmap of carriers present in the 'White List' */
} T_MPH_POWER_REQ;
#endif

#ifndef __T_MPH_POWER_CNF__
#define __T_MPH_POWER_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2055
 */
typedef struct
{
  U8                        num_of_chan;              /*<  0:  1> Number of detected channels                        */
  U8                        num_of_white_list_chan;   /*<  1:  1> The number of 'White List'carriers included in the list */
  U16                       arfcn[MAX_CHANNELS];      /*<  2:200> channel number                                     */
  U8                        rx_lev[MAX_CHANNELS];     /*<202:100> received field strength                            */
  U8                        _align0;                  /*<302:  1> alignment                                          */
  U8                        _align1;                  /*<303:  1> alignment                                          */
  T_inactive_carrier_list   inactive_carrier_list;    /*<304:256> Contains the bitmap of inactive carriers in the current location */
} T_MPH_POWER_CNF;
#endif

#ifndef __T_MPH_BSIC_REQ__
#define __T_MPH_BSIC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2056
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_MPH_BSIC_REQ;
#endif

#ifndef __T_MPH_BSIC_CNF__
#define __T_MPH_BSIC_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2057
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        bsic;                     /*<  2:  1> base station identification code                   */
  U8                        cs;                       /*<  3:  1> cause                                              */
} T_MPH_BSIC_CNF;
#endif

#ifndef __T_MPH_UNITDATA_IND__
#define __T_MPH_UNITDATA_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2058
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  U32                       fn;                       /*<  4:  4> full frame number; format: absolute frame number   */
  T_sdu                     sdu;                      /*<  8: ? > Service Data Unit                                  */
} T_MPH_UNITDATA_IND;
#endif

#ifndef __T_MPH_RANDOM_ACCESS_REQ__
#define __T_MPH_RANDOM_ACCESS_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2059
 */
typedef struct
{
  T_send_mode               send_mode;                /*<  0: 20> RACH sending mode                                  */
} T_MPH_RANDOM_ACCESS_REQ;
#endif

#ifndef __T_MPH_RANDOM_ACCESS_CNF__
#define __T_MPH_RANDOM_ACCESS_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2060
 */
typedef struct
{
  T_frame_no                frame_no;                 /*<  0:  4> reduced frame number                               */
} T_MPH_RANDOM_ACCESS_CNF;
#endif

#ifndef __T_MPH_IDLE_REQ__
#define __T_MPH_IDLE_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2061
 */
typedef struct
{
  U8                        mod;                      /*<  0:  1> idle / dedicated mode scenario                     */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       arfcn;                    /*<  2:  2> channel number                                     */
  U8                        ext_bcch;                 /*<  4:  1> unused, reserved                                   */
  U8                        comb_ccch;                /*<  5:  1> extended BCCH listening                            */
  U8                        tn;                       /*<  6:  1> timeslot number                                    */
  U8                        dlt;                      /*<  7:  1> downlink initial value                             */
  U8                        pg;                       /*<  8:  1> paging group                                       */
  U8                        bs_ag_blocks_res;         /*<  9:  1> blocks reserved for AGCH                           */
  U8                        bs_pa_mfrms;              /*< 10:  1> Multiframe Period                                  */
  U8                        power;                    /*< 11:  1> transmission power level                           */
  U8                        ncc_permitted;            /*< 12:  1> NCC permitted bitmap                               */
  U8                        reorg_only;               /*< 13:  1> specifies if reorg should be used                  */
  U8                        eotd_avail;               /*< 14:  1> eotd avail                                         */
  U8                        gprs_support;             /*< 15:  1> GPRS                                               */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        si2quater_status;         /*< 16:  1> SI-2quater configuration status                    */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        si2quater_pos;            /*< 17:  1> on N-BCCH or E-BCCH                                */
  U8                        _align1;                  /*< 18:  1> alignment                                          */
  U8                        _align2;                  /*< 19:  1> alignment                                          */
} T_MPH_IDLE_REQ;
#endif

#ifndef __T_MPH_MEASUREMENT_IND__
#define __T_MPH_MEASUREMENT_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2062
 */
typedef struct
{
  U16                       arfcn;                    /*<  0:  2> channel number                                     */
  U8                        rx_lev_full;              /*<  2:  1> received field strength                            */
  U8                        rx_lev_sub;               /*<  3:  1> received field strength                            */
  U8                        rx_qual_full;             /*<  4:  1> received quality                                   */
  U8                        rx_qual_sub;              /*<  5:  1> received quality                                   */
  U8                        dtx;                      /*<  6:  1> discontinuous transmission                         */
  U8                        _align0;                  /*<  7:  1> alignment                                          */
  U16                       otd;                      /*<  8:  2> timing advance                                     */
  U8                        valid;                    /*< 10:  1> valid flag                                         */
  U8                        _align1;                  /*< 11:  1> alignment                                          */
  U16                       fn_offset;                /*< 12:  2> TDMA Frame Offset                                  */
  U8                        _align2;                  /*< 14:  1> alignment                                          */
  U8                        _align3;                  /*< 15:  1> alignment                                          */
  T_ncells                  ncells;                   /*< 16:388> neighbour cell measurement results                 */
  U8                        gprs_sync;                /*<404:  1> specifies sync results                             */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        rxlev_val;                /*<405:  1> received field strength                            */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        nbr_rcvd_blks;            /*<406:  1> Number of received blocks                          */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        mean_bep;                 /*<407:  1> mapped value of mean BEP                           */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        cv_bep;                   /*<408:  1> CV BEP                                             */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        scale_used;               /*<409:  1> Basic Element                                      */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        nc_index[MAX_NUM_CELLS_IN_REPORT]; /*<410: 32> GSM Neighbour cell index /index to enhanced cell list */
// ELEM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
  U8                        bsic_seen;                /*<442:  1> Indicates if a GSM cell with invalid BSIC and allowed NCC part of the BSIC is one of the six strongest cells.  */
  U8                        bcch_rxlev_of_sc;         /*<443:  1> This is the rxlev of BCCH channel. Used only in dedicated mode */
} T_MPH_MEASUREMENT_IND;
#endif

#ifndef __T_MPH_NEIGHBOURCELL_REQ__
#define __T_MPH_NEIGHBOURCELL_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2063
 */
typedef struct
{
  U8                        multi_band;               /*<  0:  1> multiband report parameter                         */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       arfcn[MAX_NEIGHBOURCELLS]; /*<  2: 66> channel number                                     */
  U8                        sync_only;                /*< 68:  1> specifies if only sync is used                     */
  U8                        _align1;                  /*< 69:  1> alignment                                          */
  U8                        _align2;                  /*< 70:  1> alignment                                          */
  U8                        _align3;                  /*< 71:  1> alignment                                          */
} T_MPH_NEIGHBOURCELL_REQ;
#endif

#ifndef __T_MPH_DEDICATED_REQ__
#define __T_MPH_DEDICATED_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2064
 */
typedef struct
{
  U8                        mod;                      /*<  0:  1> idle / dedicated mode scenario                     */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_start                   start;                    /*<  4:  4> starting time                                      */
  T_ch_type                 ch_type;                  /*<  8:136> channel type configuration                         */
  T_ch_type2                ch_type2;                 /*<144:136> channel type                                       */
  U16                       arfcn;                    /*<280:  2> channel number                                     */
  U8                        bsic;                     /*<282:  1> base station identification code                   */
  U8                        _align3;                  /*<283:  1> alignment                                          */
  T_ho_param                ho_param;                 /*<284:  4> handover parameter                                 */
  T_tr_para                 tr_para;                  /*<288:  8> transmission parameter                             */
  T_ciph                    ciph;                     /*<296: 20> ciphering parameters                               */
  T_amr_conf                amr_conf;                 /*<316: 20> Parameters for AMR                                 */
} T_MPH_DEDICATED_REQ;
#endif

#ifndef __T_MPH_DEDICATED_CNF__
#define __T_MPH_DEDICATED_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2065
 */
typedef struct
{
  U8                        dedi_res;                 /*<  0:  1> dedicated configuration result                     */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPH_DEDICATED_CNF;
#endif

#ifndef __T_MPH_DEDICATED_FAIL_REQ__
#define __T_MPH_DEDICATED_FAIL_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2066
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPH_DEDICATED_FAIL_REQ;
#endif

#ifndef __T_MPH_DEDICATED_FAIL_CNF__
#define __T_MPH_DEDICATED_FAIL_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2067
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPH_DEDICATED_FAIL_CNF;
#endif

#ifndef __T_MPH_CIPHERING_REQ__
#define __T_MPH_CIPHERING_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2068
 */
typedef struct
{
  T_ciph                    ciph;                     /*<  0: 20> ciphering parameters                               */
} T_MPH_CIPHERING_REQ;
#endif

#ifndef __T_MPH_FREQ_REDEF_REQ__
#define __T_MPH_FREQ_REDEF_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2069
 */
typedef struct
{
  T_start                   start;                    /*<  0:  4> starting time                                      */
  T_ch_type                 ch_type;                  /*<  4:136> channel type configuration                         */
} T_MPH_FREQ_REDEF_REQ;
#endif

#ifndef __T_MPH_CHANNEL_MODE_REQ__
#define __T_MPH_CHANNEL_MODE_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2070
 */
typedef struct
{
  U8                        mode;                     /*<  0:  1> channel mode                                       */
  U8                        ch;                       /*<  1:  1> channel type                                       */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
  T_amr_conf                amr_conf;                 /*<  4: 20> Parameters for AMR                                 */
} T_MPH_CHANNEL_MODE_REQ;
#endif

#ifndef __T_MPH_ERROR_IND__
#define __T_MPH_ERROR_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2071
 */
typedef struct
{
  U8                        cs;                       /*<  0:  1> cause                                              */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       arfcn;                    /*<  2:  2> channel number                                     */
} T_MPH_ERROR_IND;
#endif

#ifndef __T_MPH_DEACTIVATE_REQ__
#define __T_MPH_DEACTIVATE_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2072
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPH_DEACTIVATE_REQ;
#endif

#ifndef __T_MPH_CLASSMARK_REQ__
#define __T_MPH_CLASSMARK_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2073
 */
typedef struct
{
  T_classmark               classmark;                /*<  0:  4> classmark                                          */
} T_MPH_CLASSMARK_REQ;
#endif

#ifndef __T_MPH_TCH_LOOP_REQ__
#define __T_MPH_TCH_LOOP_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2074
 */
typedef struct
{
  U8                        tch_loop;                 /*<  0:  1> TCH loop command                                   */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPH_TCH_LOOP_REQ;
#endif

#ifndef __T_MPH_DAI_REQ__
#define __T_MPH_DAI_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2075
 */
typedef struct
{
  U8                        device;                   /*<  0:  1> DAI testing device                                 */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPH_DAI_REQ;
#endif

#ifndef __T_MPH_CBCH_REQ__
#define __T_MPH_CBCH_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2076
 */
typedef struct
{
  T_cbch                    cbch;                     /*<  0:140> cell broadcast channel                             */
} T_MPH_CBCH_REQ;
#endif

#ifndef __T_MPH_IDENTITY_REQ__
#define __T_MPH_IDENTITY_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2077
 */
typedef struct
{
  T_mid                     mid;                      /*<  0: 40> Mobile identities                                  */
} T_MPH_IDENTITY_REQ;
#endif

#ifndef __T_MPH_PAGING_IND__
#define __T_MPH_PAGING_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2078
 */
typedef struct
{
  U8                        identity_type;            /*<  0:  1> Identity type                                      */
  U8                        channel_needed;           /*<  1:  1> Channel needed                                     */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_MPH_PAGING_IND;
#endif

#ifndef __T_MPH_MON_CTRL_REQ__
#define __T_MPH_MON_CTRL_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2079
 */
typedef struct
{
  U8                        action;                   /*<  0:  1> start or stop reading of BCCH resp. CCCH           */
  U8                        si_to_read;               /*<  1:  1> SI to read                                         */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_MPH_MON_CTRL_REQ;
#endif

#ifndef __T_MPH_SYNC_REQ__
#define __T_MPH_SYNC_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2080
 */
typedef struct
{
  U8                        cs;                       /*<  0:  1> cause                                              */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPH_SYNC_REQ;
#endif

#ifndef __T_MPH_SYNC_IND__
#define __T_MPH_SYNC_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2081
 */
typedef struct
{
  U8                        cs;                       /*<  0:  1> cause                                              */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U16                       arfcn;                    /*<  2:  2> channel number                                     */
} T_MPH_SYNC_IND;
#endif

#ifndef __T_MPH_MEAS_ORDER_CNF__
#define __T_MPH_MEAS_ORDER_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2082
 */
typedef struct
{
  U8                        no_of_ncells;             /*<  0:  1> Number of ncells                                   */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_meas_results            meas_results[MAX_NEIGHBOURCELLS]; /*<  4:132> neighbourcell measurement results                  */
} T_MPH_MEAS_ORDER_CNF;
#endif

#ifndef __T_MPH_EMO_REQ__
#define __T_MPH_EMO_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2083
 */
typedef struct
{
  U8                        ba_id;                    /*<  0:  1> link frequency list and measurement report         */
  U8                        c_arfcn;                  /*<  1:  1> counter                                            */
  U16                       arfcn[MAX_EMO_CHANNELS];  /*<  2: 42> channel number                                     */
} T_MPH_EMO_REQ;
#endif

#ifndef __T_MPH_EMO_MEAS_IND__
#define __T_MPH_EMO_MEAS_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2084
 */
typedef struct
{
  U8                        ba_id;                    /*<  0:  1> link frequency list and measurement report         */
  U8                        dtx;                      /*<  1:  1> discontinuous transmission                         */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        c_meas_results;           /*<  3:  1> counter                                            */
  T_meas_results            meas_results[MAX_EMO_CHANNELS + 1]; /*<  4: 88> neighbourcell measurement results                  */
} T_MPH_EMO_MEAS_IND;
#endif

#ifndef __T_MPH_EXT_MEAS_REQ__
#define __T_MPH_EXT_MEAS_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2085
 */
typedef struct
{
  U8                        pch_interrupt;            /*<  0:  1> PCH Interrupt                                      */
  U8                        freq_bands;               /*<  1:  1> Bitmap of frequency bands                          */
  U8                        num_of_chan;              /*<  2:  1> Number of detected channels                        */
  U8                        _align0;                  /*<  3:  1> alignment                                          */
  U16                       arfcn[MAX_CHANNELS];      /*<  4:200> channel number                                     */
} T_MPH_EXT_MEAS_REQ;
#endif

#ifndef __T_MPH_EXT_MEAS_CNF__
#define __T_MPH_EXT_MEAS_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2086
 */
typedef struct
{
  U8                        num_of_chan;              /*<  0:  1> Number of detected channels                        */
  U8                        num_of_white_list_chan;   /*<  1:  1> The number of 'White List'carriers included in the list */
  U16                       arfcn[MAX_CHANNELS];      /*<  2:200> channel number                                     */
  U8                        rx_lev[MAX_CHANNELS];     /*<202:100> received field strength                            */
  U8                        _align0;                  /*<302:  1> alignment                                          */
  U8                        _align1;                  /*<303:  1> alignment                                          */
  T_inactive_carrier_list   inactive_carrier_list;    /*<304:256> Contains the bitmap of inactive carriers in the current location */
} T_MPH_EXT_MEAS_CNF;
#endif

#ifndef __T_MPH_NCELL_POS_REQ__
#define __T_MPH_NCELL_POS_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2087
 */
typedef struct
{
  U16                       req_id;                   /*<  0:  2> Request Identifier                                 */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        c_ncell_eotd;             /*<  3:  1> counter                                            */
  T_ncell_eotd              ncell_eotd[MAX_NCELL_EOTD_ALR]; /*<  4:180> Parameters of a neighbour cell                     */
} T_MPH_NCELL_POS_REQ;
#endif

#ifndef __T_MPH_NCELL_POS_IND__
#define __T_MPH_NCELL_POS_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2088
 */
typedef struct
{
  U16                       req_id;                   /*<  0:  2> Request Identifier                                 */
  U8                        eotd_res;                 /*<  2:  1> EOTD Result                                        */
  U8                        ta;                       /*<  3:  1> timing advance                                     */
  U32                       fn;                       /*<  4:  4> full frame number; format: absolute frame number   */
  T_eotd_sc_res             eotd_sc_res;              /*<  8: 48> EOTD SC Results at start of measurement            */
  T_eotd_sc_res1            eotd_sc_res1;             /*< 56: 48> EOTD SC Results at stop of measurement             */
  U8                        _align0;                  /*<104:  1> alignment                                          */
  U8                        _align1;                  /*<105:  1> alignment                                          */
  U8                        _align2;                  /*<106:  1> alignment                                          */
  U8                        c_eotd_nc_res;            /*<107:  1> counter                                            */
  T_eotd_nc_res             eotd_nc_res[MAX_NCELL_EOTD_RES]; /*<108:576> EOTD NC Results                                    */
} T_MPH_NCELL_POS_IND;
#endif

#ifndef __T_MPH_CLEAN_BUF_REQ__
#define __T_MPH_CLEAN_BUF_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2089
 */
typedef struct
{
  U16                       si_to_clean;              /*<  0:  2> SI to clean                                        */
  U8                        _align0;                  /*<  2:  1> alignment                                          */
  U8                        _align1;                  /*<  3:  1> alignment                                          */
} T_MPH_CLEAN_BUF_REQ;
#endif

#ifndef __T_MPH_STOP_DEDICATED_REQ__
#define __T_MPH_STOP_DEDICATED_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2090
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPH_STOP_DEDICATED_REQ;
#endif

#ifndef __T_MPH_STOP_DEDICATED_CNF__
#define __T_MPH_STOP_DEDICATED_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2091
 */
typedef struct
{
  U8                        param;                    /*<  0:  1> dummy parameter                                    */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPH_STOP_DEDICATED_CNF;
#endif

#ifndef __T_MPH_MEAS_REP_REQ__
#define __T_MPH_MEAS_REP_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2092
 */
typedef struct
{
  U8                        cause;                    /*<  0:  1> Meas report                                        */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
} T_MPH_MEAS_REP_REQ;
#endif

#ifndef __T_MPH_MEAS_REP_CNF__
#define __T_MPH_MEAS_REP_CNF__
/*
 * 
 * CCDGEN:WriteStruct_Count==2093
 */
typedef struct
{
  T_meas_rep                meas_rep[RR_ALR_MEAS_REPORT_SIZE]; /*<  0: 28> meas report to RR                                  */
} T_MPH_MEAS_REP_CNF;
#endif


// PRIM-FF: REL99 AND ( TI_PS_FF_EMR OR TI_PS_FF_RTD ) 
#ifndef __T_MPH_ENHPARA_UPDATE_REQ__
#define __T_MPH_ENHPARA_UPDATE_REQ__
/*
 * 
 * CCDGEN:WriteStruct_Count==2094
 */
typedef struct
{
  U8                        rep_type;                 /*<  0:  1> Report type                                        */
  U8                        _align0;                  /*<  1:  1> alignment                                          */
  U8                        _align1;                  /*<  2:  1> alignment                                          */
  U8                        _align2;                  /*<  3:  1> alignment                                          */
  T_enh_para_struct         enh_para;                 /*<  4:428> Enhanced measurement parameters                    */
} T_MPH_ENHPARA_UPDATE_REQ;
#endif


// PRIM-FF: TI_PS_FF_QUAD_BAND_SUPPORT 
#ifndef __T_MPH_INIT_RR_IND__
#define __T_MPH_INIT_RR_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==2095
 */
typedef struct
{
  U8                        pclass_900;               /*<  0:  1> Power Class GSM 900                                */
  U8                        pclass_850;               /*<  1:  1> Power Class 850                                    */
  U8                        pclass_1800;              /*<  2:  1> Power Class 1800                                   */
  U8                        pclass_1900;              /*<  3:  1> Power Class 1900                                   */
  U8                        freq_bands;               /*<  4:  1> Bitmap of frequency bands                          */
  U8                        _align0;                  /*<  5:  1> alignment                                          */
  U8                        _align1;                  /*<  6:  1> alignment                                          */
  U8                        _align2;                  /*<  7:  1> alignment                                          */
} T_MPH_INIT_RR_IND;
#endif


#include "CDG_LEAVE.h"


#endif
