/************* Revision Controle System Header *************
 *                  GSM Layer 1 software
 * L1_DYN_DWL_INIT.C
 *
 *        Filename l1_dyn_dwl_init.c
 *  Copyright 2004 (C) Texas Instruments
 *
 ************* Revision Controle System Header *************/
#include "nucleus.h"
#include "l1_confg.h"
#include "sys_types.h"
#include "l1_types.h"
#include "l1audio_defty.h"
#include "l1audio_cust.h"
#include "l1audio_const.h"
#include "l1_const.h"
#include "l1tm_defty.h"

#if (L1_GTT == 1)
  #include "l1gtt_const.h"
  #include "l1gtt_defty.h"
#endif
#if (L1_DYN_DSP_DWNLD == 1)
 #include "l1_dyn_dwl_const.h"
 #include "l1_dyn_dwl_defty.h"
 #include "l1_dyn_dwl_proto.h"
#endif

#if (L1_MP3 == 1)
  #include "l1mp3_defty.h"
#endif //L1_MP3
#if (L1_MIDI == 1)
  #include "l1midi_defty.h"
#endif
#if (L1_AAC == 1)
  #include "l1aac_defty.h"
#endif //L1_AAC

#include "l1_defty.h"
#include "cust_os.h"
#include "nu_main.h"
#include "l1audio_signa.h"
#include "l1_varex.h"
#include "l1_macro.h"
#include "l1_trace.h"

#if (L1_DYN_DSP_DWNLD == 1)
extern T_DYN_DWNLD_MCU_DSP *dyn_dwl_ndb;
#if ((CODE_VERSION == SIMULATION) || (((CHIPSET == 12) || (CHIPSET == 15))))
const BOOL  primitives_to_patch_matrix[NUM_OF_DYN_DWNLD_PRIMITIVES][MAX_NUM_OF_PATCH_IDS] = {

//                                              MP3     MMS    Melo E2  TTY  Speech Acoustic AAC   PCM
// MMI_GTT_START_REQ
												{0,      0,      0,      1,      0,           0,     0},
// MMI_TCH_VOCODER_CFG_REQ
												{0,      0,      0,      0,      1,           0,     0},
// MMI_MELODY0_E2_START_REQ
												{0,      0,      1,      0,      0,           0,     0},
// MMI_MELODY1_E2_START_REQ
												{0,      0,      1,      0,      0,           0,     0},
// MMI_MP3_START_REQ
												{1,      0,      0,      0,      0,           0,     0},
// MMI_VM_AMR_PLAY_START_REQ
												{0,      1,      0,      0,      0,           0,     0},
// MMI_VM_AMR_RECORD_START_REQ
												{0,      1,      0,      0,      0,           0,     0},
// MMI_AAC_START_REQ
												{0,      0,      0,      0,      0,           1,     0},
// MMI_PCM_DOWNLOAD_START_REQ
												{0,      0,      0,      0,      0,           0,     1},
// MMI_PCM_UPLOAD_START_REQ
												{0,      0,      0,      0,      0,           0,     1}
  };

const BOOL incompatibility_matrix[MAX_NUM_OF_PATCH_IDS][MAX_NUM_OF_PATCH_IDS] ={

//                                               MP3    MMS   Melo E2   TTY  Speech Acoustic AAC   PCM
// MP3
												{0,     1,      1,      1,      1,           1,     1},
// MMS
												{1,     0,      1,      1,      1,           1,     1},
// Melo E2
												{1,     1,      0,      1,      1,           1,     1},
// TTY
												{1,     1,      1,      0,      1,           1,     1},
// Speech Acoustic
												{1,     1,      1,      1,      0,           1,     0},
// AAC
												{1,     1,      1,      1,      1,           0,     1},
// PCM
												{1,     1,      1,      1,      0,           1,     0}
  };


const BOOL semaphore_matrix[MAX_NUM_OF_PATCH_IDS][MAX_NUM_OF_SEMAPHORES] = {

//                          MP3 SM    VM AMR SM   E2 SM    ANR SM      Speech Reco SM  TTY SM    WCM SM  AAC SM   PCM SM
// MP3
							{1,          0,        0,        0,            1,           0,         1,       1,       0},
// MMS
							{1,          1,        0,        0,            1,           0,         0,       1,       0},
// Melo E2
							{1,          0,        1,        0,            1,           0,         0,       1,       0},
// TTY
							{1,          0,        0,        0,            1,           1,         0,       1,       0},
// Speech Acoustic
							{1,          0,        0,        1,            1,           0,         0,       1,       0},
// AAC
							{1,          0,        0,        0,            1,           0,         1,       1,       0},
// PCM
							{1,          0,        0,        0,            1,           0,         0,       1,       1}
  };
#elif (CHIPSET == 10 && BOARD == 35)
const BOOL  primitives_to_patch_matrix[NUM_OF_DYN_DWNLD_PRIMITIVES][MAX_NUM_OF_PATCH_IDS] = {

/*                                              MMS  TTY Speech Acoustic */
/* MMI_GTT_START_REQ                      */   { 0,   1,    0},    
/* MMI_TCH_VOCODER_CFG_REQ                */   { 0,   0,    1},
/* MMI_VM_AMR_PLAY_START_REQ              */   { 1,   0,    0},
/* MMI_VM_AMR_RECORD_START_REQ            */   { 1,   0,    0}
  };
  
const BOOL incompatibility_matrix[MAX_NUM_OF_PATCH_IDS][MAX_NUM_OF_PATCH_IDS] ={

/*                                                   MMS  TTY Speech Acoustic */
/* MMS                   */                      {    0,   1,   1},
/* TTY                   */                      {    1,   0,   0}, 
/* Speech Acoustic       */                      {    1,   0,   0}
  };

  
const BOOL semaphore_matrix[MAX_NUM_OF_PATCH_IDS][MAX_NUM_OF_SEMAPHORES] = {

//                             VM AMR SM    ANR SM      Speech Reco SM   TTY SM
// MMS
						{      1,          0,            1,            0      },
// TTY
						{      0,          0,            1,            1,     },
// Speech Acoustic
						{      0,          1,            1,            0      }
  };
#endif // CODE_VERSION == SIMULATION || ((CHIPSET == 12) || (CHIPSET == 15))

UWORD32 dyn_dwnld_address_vect[MAX_NUM_OF_PATCH_IDS];
UWORD16 dyn_dwnld_crc_vect[MAX_NUM_OF_PATCH_IDS];
UWORD16 size_vect[MAX_NUM_OF_PATCH_IDS];

UWORD8 const *dyn_dwnld_copy_MCU_vect[MAX_NUM_OF_PATCH_IDS];

#if (CODE_VERSION != SIMULATION && ((CHIPSET == 12) || (CHIPSET == 15)))
  #if (L1_MP3 == 1)
  extern const UWORD8 mp3_patch_array[];
  #endif
  extern const UWORD8 amr_mms_patch_array[];
  #if (CHIPSET == 15)
    // TODO: Just to avoid Compilation errors.
    // Ideally E2 should be completely removed for Locosto
    const UWORD8 e2_patch_array[] = {
   /* Tag  */ 0x00, 0x00, 0x00, 0x00,
   /* Vers */ 0x03, 0x00, 0x00, 0x00,
   
   /* size */ 0x0f, 0x00, 0x00, 0x00,
   /* addr */ 0x05, 0x16, 0x00, 0x00,
   0xF8,0x10,0xF6,0x17,0x10,0xF0,0x03,0x00,0x45,0xF8,0x0F,0x16,0x74,0xF0,0x12,0x16,
   0x73,0xF0,0x11,0x16,0x74,0xF0,0x13,0x16,0x00,0xFC,0x00,0xFC,0x00,0xFC,0xAD,0xDE,
   
   /* Final record */
   /* size */ 0x00, 0x00, 0x00, 0x00,
   /* Installation addr */ 0x05, 0x16, 0x00, 0x00,
   /* Checksum */ 0x34, 0x03,
  };      
  #else 
    extern const UWORD8 e2_patch_array[];
  #endif  
  //extern const UWORD8 tty_patch_array[];
  extern const UWORD8 speech_acoustic_patch_array[];
#if (L1_AAC == 1)
  extern const UWORD8 aac_patch_array[];
#endif
#if (L1_PCM_EXTRACTION == 1)
  extern const UWORD8 pcm_patch_array[];
#endif
#elif (CODE_VERSION != SIMULATION && CHIPSET == 10 && BOARD == 35)
  extern const UWORD8 amr_mms_patch_array[];
//  extern const UWORD8 tty_patch_array[];
  extern const UWORD8 speech_acoustic_patch_array[];
#elif (CODE_VERSION == SIMULATION)
  const UWORD8 mp3_patch_array[] = {
    /* Tag  */ 0x00, 0x00, 0x00, 0x00,
    /* Vers */ 0x03, 0x00, 0x00, 0x00,
    /* size */ 0x01, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x0E,0x60,
    /* Final record */ 0xAD, 0xDE,
    /* size */ 0x00, 0x00, 0x00, 0x00,
    /* addr */ 0xAA, 0xAA, 0x00, 0x00,
    /* CRC */ 0xAA, 0xAA, 0x00, 0x00,
  };
  const UWORD8 amr_mms_patch_array[] = {  
    /* Tag  */ 0x00, 0x00, 0x00, 0x00,
    /* Vers */ 0x03, 0x00, 0x00, 0x00,
    /* size */ 0x01, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x0E,0x60,
    /* Final record */ 0xAD, 0xDE,
    /* size */ 0x00, 0x00, 0x00, 0x00,
    /* addr */ 0xBB, 0xBB, 0x00, 0x00,
    /* CRC */ 0xBB, 0xBB, 0x00, 0x00,
  };
  const UWORD8 pcm_patch_array[] = {
    /* Tag  */ 0x00, 0x00, 0x00, 0x00,
    /* Vers */ 0x03, 0x00, 0x00, 0x00,
    /* size */ 0x01, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x0E,0x60,
    /* Final record */ 0xAD, 0xDE,
    /* size */ 0x00, 0x00, 0x00, 0x00,
    /* addr */ 0xBB, 0xBB, 0x00, 0x00,
    /* CRC */ 0xBB, 0xBB, 0x00, 0x00,
  };
  const UWORD8 aac_patch_array[] = {
    /* Tag  */ 0x00, 0x00, 0x00, 0x00,
    /* Vers */ 0x03, 0x00, 0x00, 0x00,
    /* size */ 0x01, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x0E,0x60,
    /* Final record */ 0xAD, 0xDE,
    /* size */ 0x00, 0x00, 0x00, 0x00,
    /* addr */ 0xCC, 0xCC, 0x00, 0x00,
    /* CRC */ 0xCC, 0xCC, 0x00, 0x00,
  };
 const UWORD8 tty_patch_array[] = {
    /* Tag  */ 0x00, 0x00, 0x00, 0x00,
    /* Vers */ 0x03, 0x00, 0x00, 0x00,
    /* size */ 0x01, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x0E,0x60,
    /* Final record */ 0xAD, 0xDE,
    /* size */ 0x00, 0x00, 0x00, 0x00,
    /* addr */ 0xDD, 0xDD, 0x00, 0x00,
    /* CRC */ 0xDD, 0xDD, 0x00, 0x00,
  };
  const UWORD8 e2_patch_array[] = {
/* Tag  */ 0x00, 0x00, 0x00, 0x00,
/* Vers */ 0x03, 0x00, 0x00, 0x00,

/* size */ 0xab, 0x03, 0x00, 0x00,
/* addr */ 0x10, 0x64, 0x00, 0x00,

0xF8,0x76,0x66,0x58,0x00,0x00,0x00,0xFC,0xF8,0x60,0x66,0x58,0x00,0x00,0x20,0xF8,
0x23,0x64,0xF8,0x10,0x67,0x58,0xE3,0xF4,0xF8,0x76,0x66,0x58,0x01,0x00,0xF8,0x10,
0x6A,0x58,0xE3,0xF4,0x00,0xFC,0xF8,0x60,0x66,0x58,0x01,0x00,0x20,0xF8,0x37,0x64,
0xF8,0x10,0x69,0x58,0xE3,0xF4,0xF8,0x76,0x66,0x58,0x02,0x00,0x45,0xF8,0x37,0x64,
0xF8,0x76,0x66,0x58,0x01,0x00,0xF8,0x10,0x6A,0x58,0xE3,0xF4,0x00,0xFC,0xF8,0x60,
0x66,0x58,0x02,0x00,0x20,0xF8,0x48,0x64,0xF8,0x76,0x66,0x58,0x03,0x00,0xF8,0x10,
0x68,0x58,0xE3,0xF4,0xF8,0x60,0x66,0x58,0x01,0x00,0x30,0xF8,0x28,0x64,0x00,0xFC,
0xF8,0x60,0x66,0x58,0x05,0x00,0x30,0xF8,0x1C,0x64,0xF8,0x60,0x66,0x58,0x04,0x00,
0x30,0xF8,0x1C,0x64,0x00,0xFC,0xF8,0x76,0x66,0x58,0x01,0x00,0x00,0xFC,0xF8,0x76,
0x66,0x58,0x05,0x00,0x00,0xFC,0xF8,0x76,0x66,0x58,0x04,0x00,0x00,0xFC,0xBB,0xF7,
0xF8,0x10,0x4E,0x43,0xF8,0x08,0x4F,0x43,0xBB,0xF6,0x00,0xFC,0xBB,0xF7,0x20,0xF0,
0x14,0x64,0x74,0xF0,0xC3,0xAA,0xBB,0xF6,0x00,0xFC,0xF8,0x61,0x09,0x09,0x00,0x20,
0x20,0xF8,0x79,0x64,0x74,0xF0,0xF7,0xC4,0xF8,0x76,0x66,0x58,0x01,0x00,0x73,0xF0,
0x97,0x65,0xF8,0x60,0x66,0x58,0x05,0x00,0x20,0xF8,0xF7,0xC4,0xF8,0x76,0x66,0x58,
0x01,0x00,0xF8,0x10,0x6A,0x58,0xE2,0xF4,0x20,0xF0,0xEA,0x64,0x74,0xF0,0x8E,0x64,
0x00,0xFC,0x20,0xF0,0xCB,0x64,0x74,0xF0,0x8E,0x64,0x00,0xFC,0x06,0x4A,0x17,0x4A,
0x16,0x4A,0x11,0x4A,0x07,0x4A,0x1D,0x4A,0x06,0x77,0x00,0x00,0x07,0x77,0x00,0x69,
0xF8,0x68,0x1D,0x00,0xFC,0xFF,0xE3,0xF4,0x1D,0x8A,0x07,0x8A,0x11,0x8A,0x16,0x8A,
0x17,0x8A,0x06,0x8A,0x00,0xFC,0xF8,0x76,0x69,0x58,0x5F,0x64,0xF8,0x76,0x6A,0x58,
0x66,0x64,0xF8,0x76,0xCB,0x43,0x6D,0x64,0xE4,0xF4,0x10,0x77,0xA0,0x28,0x11,0x77,
0x00,0x28,0x12,0x72,0xBE,0x3F,0x00,0xE8,0x1A,0x77,0x9F,0x00,0x72,0xF2,0xBC,0x64,
0x19,0x77,0x5E,0x01,0x90,0x80,0x91,0x80,0xD2,0x80,0xE4,0xF4,0xF8,0x76,0x69,0x58,
0x84,0x64,0xF8,0x76,0x6A,0x58,0x89,0x64,0xF8,0x76,0x33,0x4C,0xFA,0x64,0xF8,0x76,
0x32,0x4C,0x6B,0x65,0x00,0xFC,0x11,0x4A,0xFC,0xEE,0x95,0xF4,0xBB,0xF7,0x03,0x76,
0x16,0x00,0x02,0x76,0x00,0x00,0x18,0x48,0x00,0xF0,0x02,0x00,0xF8,0x11,0x43,0x4C,
0x00,0x80,0x20,0xF0,0xD1,0x4B,0xE3,0xF5,0x11,0x88,0x95,0xF4,0x95,0xF4,0xE1,0x6C,
0xFF,0xFF,0xE5,0x64,0xF8,0x69,0xD5,0x08,0x00,0x04,0xBB,0xF6,0x95,0xF4,0x04,0xEE,
0x11,0x8A,0x00,0xFC,0xBB,0xF7,0xF8,0x10,0xD2,0x4B,0xF8,0x08,0xD1,0x4B,0x44,0xF8,
0xF6,0x64,0xBB,0xF6,0x95,0xF4,0x00,0xE8,0x73,0xF0,0xF9,0x64,0xBB,0xF6,0x95,0xF4,
0x01,0xE8,0x00,0xFC,0xFF,0xEE,0xF8,0x11,0x5E,0x3F,0x20,0xF0,0x14,0x64,0xE3,0xF5,
0x01,0xEE,0x00,0xFC,0x11,0x4A,0xFE,0xEE,0xF8,0x61,0x09,0x09,0x01,0x00,0x20,0xF8,
0x48,0x65,0xF8,0x61,0x08,0x09,0x00,0x20,0x20,0xF8,0x41,0x65,0xF8,0x60,0x41,0x09,
0x03,0x00,0x20,0xF8,0x35,0x65,0xF8,0x61,0x09,0x09,0x00,0x20,0x30,0xF8,0x2D,0x65,
0xF8,0x69,0x09,0x09,0x00,0x20,0xF8,0x76,0x6B,0x58,0x00,0x00,0xF8,0x76,0x00,0x4C,
0x28,0x67,0xF8,0x76,0x6C,0x58,0x0D,0x66,0xF8,0x11,0x5E,0x3F,0x20,0xF0,0x9F,0x65,
0xE3,0xF5,0x74,0xF0,0x10,0x64,0x73,0xF0,0x3E,0x65,0xF8,0x68,0x09,0x09,0xFE,0xDF,
0xF8,0x76,0x6B,0x58,0x01,0x00,0x73,0xF0,0x3E,0x65,0xF8,0x76,0xC3,0x3F,0x00,0x28,
0xF8,0x76,0xC4,0x3F,0xA0,0x28,0xF8,0x76,0x6C,0x58,0xC8,0x5D,0xF8,0x68,0x08,0x09,
0xFF,0xDF,0xF8,0x10,0x41,0x09,0x44,0xF8,0x48,0x65,0xF8,0x76,0x6C,0x58,0x98,0x71,
0x11,0x72,0xB9,0x4B,0x95,0xF4,0x81,0x10,0xF8,0x61,0x08,0x00,0x00,0x40,0x30,0xF8,
0x63,0x65,0xF8,0x61,0x08,0x00,0xFF,0x00,0x20,0xF8,0x63,0x65,0x11,0x72,0xB9,0x4B,
0x95,0xF4,0xE1,0x60,0x03,0x00,0x03,0x00,0x20,0xF8,0x63,0x65,0xF8,0x61,0xB0,0x3F,
0x02,0x00,0x30,0xF8,0x68,0x65,0x00,0x70,0xE5,0x4B,0x15,0xE8,0x74,0xF0,0x23,0xDC,
0x02,0xEE,0x11,0x8A,0x00,0xFC,0xFF,0xEE,0xF8,0x11,0x63,0x3F,0x15,0xE8,0xE3,0xF5,
0xF8,0x61,0x09,0x09,0x00,0x20,0x30,0xF8,0x88,0x65,0xF8,0x60,0x66,0x58,0x05,0x00,
0x30,0xF8,0x81,0x65,0xF8,0x11,0x5E,0x3F,0x20,0xF0,0x35,0xE1,0xE3,0xF5,0x73,0xF0,
0x95,0x65,0xF8,0x76,0x66,0x58,0x01,0x00,0x74,0xF0,0xCB,0x64,0x73,0xF0,0x95,0x65,
0xF8,0x11,0x5E,0x3F,0x20,0xF0,0x35,0xE1,0xE3,0xF5,0xF8,0x76,0x66,0x58,0x01,0x00,
0xF8,0x11,0x5E,0x3F,0x20,0xF0,0x97,0x65,0xE3,0xF5,0x01,0xEE,0x00,0xFC,0xF8,0x76,
0x67,0x58,0x9F,0x65,0xF8,0x76,0x68,0x58,0xB8,0x65,0x73,0xF0,0x14,0x64,0xF8,0x68,
0xBF,0x3F,0xFF,0xF7,0xF8,0x69,0xBF,0x3F,0x00,0x10,0xF8,0x76,0xD2,0x56,0x01,0x00,
0xF8,0x76,0xCD,0x4F,0x01,0x00,0xF8,0x76,0x05,0x09,0x01,0x04,0xF8,0x76,0xD5,0x56,
0xFE,0xFF,0x81,0xF9,0x16,0xA3,0x80,0xF9,0x15,0x66,0x80,0xF9,0xAD,0x64,0x00,0xFC,
0xF8,0x60,0xD1,0x56,0x02,0x00,0x30,0xF8,0xFE,0x65,0xF8,0x60,0x00,0x15,0x00,0x00,
0x30,0xF8,0xDB,0x65,0xF8,0x10,0x00,0x15,0x93,0xF4,0xF8,0x18,0x01,0x15,0xF8,0x80,
0x01,0x15,0x01,0xE8,0x12,0x77,0xE5,0x55,0x10,0x77,0x0E,0x00,0x1A,0x77,0x0F,0x00,
0x72,0xF0,0xDA,0x65,0x40,0xF5,0xF8,0x19,0x00,0x15,0x4D,0xF8,0xD9,0x65,0x82,0x76,
0x00,0x00,0x61,0xF4,0xB2,0x6D,0xF8,0x76,0x00,0x15,0x00,0x00,0xF8,0x10,0x3C,0x15,
0x45,0xF8,0xFE,0x65,0xF8,0x6B,0xD5,0x56,0x01,0x00,0x81,0xF9,0x19,0xA3,0x74,0xF0,
0x53,0x64,0xF8,0x60,0xD5,0x56,0x0A,0x00,0x30,0xF8,0xFE,0x65,0xF8,0x60,0xD5,0x56,
0x16,0x00,0x30,0xF8,0xFE,0x65,0xF8,0x60,0xD5,0x56,0x20,0x00,0x20,0xF8,0x00,0x66,
0xF8,0x6B,0x3C,0x15,0xFF,0xFF,0xF8,0x76,0xD5,0x56,0xFE,0xFF,0x74,0xF0,0x57,0x64,
0xF8,0x10,0x6B,0x58,0x44,0xF9,0x05,0x66,0x00,0xFC,0xF8,0x68,0xBF,0x3F,0xFF,0xEF,
0x81,0xF9,0x1C,0xA3,0x74,0xF0,0x5B,0x64,0x00,0xFC,0xF8,0x60,0xD1,0x56,0x00,0x00,
0x30,0xF8,0x14,0x66,0x81,0xF9,0x1F,0xA3,0x00,0xFC,0x06,0x4A,0x07,0x4A,0x07,0x77,
0x00,0x23,0xAD,0xEA,0x95,0xF4,0x95,0xF4,0x7A,0x76,0x46,0x66,0x7B,0x76,0xC3,0x66,
0x7C,0x76,0xD8,0x66,0x79,0x76,0x3C,0x66,0xF8,0x76,0x00,0x15,0x00,0x00,0x13,0x77,
0xD8,0x55,0x93,0x76,0x14,0x00,0x93,0x76,0x11,0x00,0x93,0x76,0x0F,0x00,0x93,0x76,
0x0C,0x00,0x93,0x76,0x0A,0x00,0x93,0x76,0x07,0x00,0x93,0x76,0x05,0x00,0x83,0x76,
0x02,0x00,0x07,0x8A,0x06,0x8A,0xE4,0xF4,0xF8,0x4B,0xBE,0x3F,0xF8,0x76,0xBE,0x3F,
0x00,0x50,0x74,0xF0,0x94,0x67,0xF8,0x8B,0xBE,0x3F,0x00,0xFC,0x00,0xE8,0x08,0x8A,
0x10,0xF0,0x0D,0x00,0x44,0xF8,0x4E,0x66,0x56,0x44,0x40,0x4E,0x57,0x30,0x40,0x20,
0x76,0xF4,0x0E,0x88,0x59,0x20,0x00,0xF0,0x00,0x20,0x47,0x6F,0x62,0x0C,0x40,0x30,
0x5B,0x20,0x68,0x6F,0x6A,0x0C,0x5A,0x30,0x58,0x20,0x61,0xF4,0x0E,0x88,0x56,0x20,
0x79,0xF4,0x5F,0x80,0x45,0x62,0xA0,0x00,0x5F,0x08,0x42,0xF8,0x6B,0x66,0x47,0x10,
0x48,0x80,0x73,0xF0,0xA9,0x66,0x20,0xF1,0x00,0x04,0x86,0xF4,0x40,0x11,0x69,0xF7,
0x87,0xF4,0x09,0xF0,0x01,0x00,0x76,0xF5,0x68,0x6F,0x41,0x0C,0x87,0xF5,0x69,0x81,
0x1F,0xF6,0x0F,0xEC,0x69,0x1E,0x30,0xF0,0xFF,0xFF,0x95,0xF4,0x95,0xF4,0x45,0xFF,
0x00,0xF0,0x01,0x00,0x48,0x80,0x48,0x6F,0x5C,0x0D,0x47,0x09,0x4F,0xF8,0x8A,0x66,
0x47,0x10,0x48,0x80,0x5A,0x10,0x00,0xF0,0x01,0x00,0x60,0x80,0x60,0x30,0x40,0x20,
0x60,0x6F,0x9E,0x0C,0x60,0x30,0x66,0xF0,0x9A,0x01,0x77,0xF4,0x0F,0xEC,0x47,0x1E,
0x40,0xF5,0x5B,0x30,0x40,0x20,0x60,0x6F,0x9E,0x0C,0x60,0x30,0x66,0xF0,0x9A,0x01,
0x77,0xF4,0x0F,0xEC,0x48,0x1E,0x00,0xF5,0x30,0xF3,0xFF,0xFF,0x45,0x10,0x87,0xF5,
0x45,0x81,0x00,0xE8,0x4A,0x80,0x4B,0x80,0x49,0x80,0x42,0x4E,0x6E,0x76,0x01,0x00,
0x45,0x10,0x47,0xF8,0xC1,0x66,0x6E,0x76,0x00,0x00,0x5E,0x10,0xF8,0x1A,0x01,0x15,
0xF8,0x80,0x01,0x15,0x6D,0x71,0x16,0x00,0x62,0xE7,0x13,0x77,0xC0,0x56,0x0D,0xEC,
0x98,0xE5,0x17,0x8A,0x00,0xFC,0x56,0x6F,0x4A,0x0C,0x6C,0x6F,0x29,0x0C,0x61,0xF0,
0x01,0x00,0x46,0xF8,0xD2,0x66,0x68,0x76,0x00,0x00,0x56,0x6F,0x4A,0x0C,0x69,0x82,
0x73,0xF0,0x0E,0xA5,0x68,0x82,0x56,0x6F,0x0A,0x0C,0x69,0x82,0x73,0xF0,0x0E,0xA5,
0x42,0x56,0x67,0x45,0x80,0xF2,0x6C,0x6F,0x2F,0x0C,0x7A,0xF4,0x60,0xF0,0x01,0x00,
0xF8,0x82,0x10,0x00,0x95,0xF4,0x73,0xF0,0x6E,0xA5,0xF8,0x61,0x09,0x09,0x01,0x00,
0x20,0xF8,0x27,0x67,0xF8,0x61,0x08,0x09,0x00,0x20,0x20,0xF8,0x1F,0x67,0xF8,0x60,
0x41,0x09,0x03,0x00,0x20,0xF8,0x13,0x67,0xF8,0x61,0x09,0x09,0x00,0x20,0x20,0xF8,
0x04,0x67,0xF8,0x68,0x09,0x09,0xFF,0xDF,0xF8,0x68,0x09,0x09,0xFE,0xFF,0xF8,0x76,
0x6B,0x58,0x01,0x00,0x73,0xF0,0x1C,0x67,0xF8,0x69,0x09,0x09,0x00,0x20,0xF8,0x76,
0x6B,0x58,0x00,0x00,0xF8,0x76,0x6C,0x58,0x0D,0x66,0x74,0xF0,0x9F,0x65,0x74,0xF0,
0x10,0x64,0x73,0xF0,0x1C,0x67,0xF8,0x76,0xC4,0x3F,0xA0,0x28,0xF8,0x76,0xC3,0x3F,
0x00,0x28,0xF8,0x76,0x6C,0x58,0xC8,0x5D,0xF8,0x68,0x08,0x09,0xFF,0xDF,0xF8,0x60,
0x41,0x09,0x00,0x00,0x20,0xF8,0x27,0x67,0xF8,0x76,0x6C,0x58,0x98,0x71,0x00,0xFC,
0xF8,0x10,0x6C,0x58,0xE2,0xF4,0xF8,0x61,0x08,0x09,0x14,0x00,0x20,0xF8,0x32,0x67,
0x74,0xF0,0x10,0x64,0x00,0xFC,0xF8,0x76,0x6C,0x58,0x4F,0x67,0xF8,0x76,0x6D,0x58,
0x2B,0x67,0xF8,0x76,0x56,0x4C,0x02,0x65,0xF8,0x11,0x6B,0x58,0x10,0xF3,0x01,0x00,
0x4D,0xF8,0x46,0x67,0x74,0xF0,0x4F,0x67,0x73,0xF0,0x48,0x67,0x74,0xF0,0x49,0x67,
0x00,0xFC,0x74,0xF0,0x10,0x64,0xF8,0x76,0x00,0x4C,0x28,0x67,0x00,0xFC,0xF8,0x76,
0x6A,0x58,0xE5,0x66,0xF8,0x76,0xB3,0x43,0x28,0x67,0x80,0xF9,0xA3,0x64,0x20,0xF0,
0xBE,0x64,0x74,0xF0,0xBC,0x71,0x00,0xFC,0xF8,0x76,0x56,0x4C,0x8E,0x61,0xF8,0x11,
0x6B,0x58,0x10,0xF3,0x01,0x00,0x4D,0xF8,0x69,0x67,0x74,0xF0,0x6C,0x67,0x73,0xF0,
0x6B,0x67,0x74,0xF0,0x75,0x67,0x00,0xFC,0xF8,0x76,0x6A,0x58,0xEB,0x5A,0xF8,0x76,
0x6D,0x58,0xEB,0x5A,0xF8,0x76,0xB3,0x43,0xF7,0x5A,0xF8,0x76,0x6A,0x58,0xEB,0x5A,
0xF8,0x76,0x6D,0x58,0xEB,0x5A,0xF8,0x76,0x00,0x4C,0x98,0x71,0x00,0xFC,0x11,0x4A,
0x11,0x88,0x95,0xF4,0x95,0xF4,0x81,0x6C,0x8C,0x67,0xF8,0x11,0x5E,0x3F,0x20,0xF0,
0x33,0x67,0xE3,0xF5,0x73,0xF0,0x91,0x67,0xF8,0x11,0x5E,0x3F,0x20,0xF0,0x5C,0x67,
0xE3,0xF5,0x01,0xE8,0x11,0x8A,0x00,0xFC,0x06,0x4A,0x07,0x4A,0x9F,0xEA,0x07,0x77,
0x00,0x23,0xF8,0x10,0xCD,0x4F,0x45,0xF8,0xA2,0xFD,0x13,0x77,0xD8,0x4F,0x71,0xF0,
0x20,0x00,0x93,0x80,0x4D,0x80,0x20,0xF0,0x00,0x40,0x4E,0x80,0x4F,0x80,0xF8,0x10,
0x05,0x09,0x50,0x6F,0x68,0x0C,0x51,0x76,0x8F,0x02,0x52,0x76,0x66,0x66,0x55,0x76,
0x00,0x04,0x56,0x76,0x00,0x08,0x50,0x62,0x01,0x00,0x53,0x80,0x50,0x62,0x02,0x00,
0x54,0x80,0x73,0xF0,0xA2,0xFD,

/* Final record */ 0xAD, 0xDE,
/* size */ 0x00, 0x00, 0x00, 0x00,
/* Installation addr */ 0x83, 0x5a, 0x00, 0x00,
/* Checksum */ 0x83, 0x5a,
  };
  const UWORD8 speech_acoustic_patch_array[] = {
    /* Tag  */ 0x00, 0x00, 0x00, 0x00,
    /* Vers */ 0x03, 0x00, 0x00, 0x00,
    /* size */ 0x0A, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    /* CNTRL WORD*/ 0xAD, 0xDE,
    /* size */ 0x0B, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,   
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,    
    /* CNTRL WORD*/ 0xAD, 0xDE,
    /* size */ 0x28, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    /* CNTRL WORD*/ 0xAD, 0xDE,
    /* size */ 0x28, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    /* CNTRL WORD*/ 0xAD, 0xDE,
    /* size */ 0x01, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x55, 0x55,
    /* CNTRL WORD*/ 0xAD, 0xDE,
    /* Final record */
    /* size */ 0x00, 0x00, 0x00, 0x00,
    /* addr */ 0xEE, 0xEE, 0x00, 0x00,
    /* CRC */ 0xEE, 0xEE, 0x00, 0x00,   
 };
#endif // CODE_VERSION == SIMULATION
 const UWORD8 tty_patch_array[] = {
    /* Tag  */ 0x00, 0x00, 0x00, 0x00,
    /* Vers */ 0x03, 0x00, 0x00, 0x00,
    /* size */ 0x01, 0x00, 0x00, 0x00,
    /* addr */ 0xde, 0x07, 0x03, 0x00,
    0x0E,0x60,
    /* Final record */ 0xAD, 0xDE,
    /* size */ 0x00, 0x00, 0x00, 0x00,
    /* addr */ 0xDD, 0xDD, 0x00, 0x00,
    /* CRC */ 0xDD, 0xDD, 0x00, 0x00,
  };
/*-------------------------------------------------------*/
/* l1_dyn_dwnld_initialize_var()                         */
/*-------------------------------------------------------*/
/* Parameters : none                                     */
/* Return     : nothing                                  */
/* Functionality : Initialize Dynamic Download variables */
/*                                                       */
/*-------------------------------------------------------*/

void l1_dyn_dwnld_initialize_var()
{
  UWORD16 i;
  

  /* Init Dynamic Download NDB */
  dyn_dwl_ndb=(T_DYN_DWNLD_MCU_DSP *)API_address_dsp2mcu(C_DYN_DWNLD_API_BASE_ADDRESS);
#if (CODE_VERSION == SIMULATION)
  {
    extern T_DYN_DWNLD_MCU_DSP dyn_dwl_ndb_sim;
    dyn_dwl_ndb=&dyn_dwl_ndb_sim;
  }
#endif // CODE_VERSION == SIMULATION

  /* Init Dynamic Download DSP background */
  l1s_dsp_com.dsp_ndb_ptr->a_background_tasks[C_BGD_DSP_DYN_DWNLD] = (API)((C_BGD_DSP_DYN_DWNLD<<11) | 0);
  l1s_dsp_com.dsp_ndb_ptr->d_background_enable&=(API)(~(1<<C_BGD_DSP_DYN_DWNLD));

  if(l1s_dsp_com.dsp_ndb_ptr->d_max_background<(C_BGD_DSP_DYN_DWNLD+1))
    l1s_dsp_com.dsp_ndb_ptr->d_max_background=(API)(C_BGD_DSP_DYN_DWNLD+1);
#if (CODE_VERSION == SIMULATION || ((CHIPSET == 12) || (CHIPSET == 15)))
  #if (L1_MP3 == 1)
   dyn_dwnld_copy_MCU_vect[0] = mp3_patch_array;
  #endif
   dyn_dwnld_copy_MCU_vect[1] = amr_mms_patch_array;
   dyn_dwnld_copy_MCU_vect[2] = e2_patch_array;
   dyn_dwnld_copy_MCU_vect[3] = tty_patch_array;
   dyn_dwnld_copy_MCU_vect[4] = speech_acoustic_patch_array;
#if (L1_AAC == 1)
   dyn_dwnld_copy_MCU_vect[5] = aac_patch_array;
#endif
#if (L1_PCM_EXTRACTION == 1)
   dyn_dwnld_copy_MCU_vect[6] = pcm_patch_array;
#endif
#elif (CHIPSET == 10 && BOARD == 35)
   dyn_dwnld_copy_MCU_vect[0] = amr_mms_patch_array;
   dyn_dwnld_copy_MCU_vect[1] = tty_patch_array;
   dyn_dwnld_copy_MCU_vect[2] = speech_acoustic_patch_array;
#endif

  for(i=0;i<MAX_NUM_OF_PATCH_IDS;i++)
  {
	  if (dyn_dwnld_copy_MCU_vect[i] != 0)
	  {
      l1_set_dyn_dwnld_install_vect(size_vect,dyn_dwnld_address_vect,dyn_dwnld_crc_vect,dyn_dwnld_copy_MCU_vect[i],i);
  }
  }

  /*---------- Set L1A globals at phone init ----------------------------*/
  l1a.dyn_dwnld.melody0_E2_flag_activated = FALSE;
  l1a.dyn_dwnld.melody1_E2_flag_activated = FALSE;
  l1a.dyn_dwnld.state                     = 0;
  

  l1a.dyn_dwnld.num_patches_installed     = 0;  

  l1a.dyn_dwnld.patch_id[0] = 0xFFFF; //omaps00090550

  /**************************************************/

  // Compute number of current primitives defined via compilation switch
  l1a.dyn_dwnld.num_of_primitives=0;
#if (CODE_VERSION == SIMULATION || ((CHIPSET == 12) || (CHIPSET == 15)))
#if (L1_GTT == 1)
  l1a.dyn_dwnld.num_of_primitives++;
#endif // L1_GTT
#if (L1_VOCODER_IF_CHANGE == 1)
    l1a.dyn_dwnld.num_of_primitives++;
#endif // L1_VOCODER_IF_CHANGE
#if (AUDIO_TASK == 1)
#if (MELODY_E2 == 1)
    // Two primitves for MELODY E2
    l1a.dyn_dwnld.num_of_primitives+=2;
#endif // AUDIO_TASK
#endif // MELODY_E2
#if (L1_MP3 == 1)
    l1a.dyn_dwnld.num_of_primitives++;
#endif // L1_MP3
#if (AUDIO_TASK == 1)
#if (L1_VOICE_MEMO_AMR == 1)
    // Two primitves for L1_VOICE_MEMO_AMR
    l1a.dyn_dwnld.num_of_primitives+=2;
#endif // AUDIO_TASK
#endif // L1_VOICE_MEMO_AMR 
#if (L1_AAC == 1)
    l1a.dyn_dwnld.num_of_primitives++;
#endif // L1_AAC
#if (L1_PCM_EXTRACTION == 1)
    l1a.dyn_dwnld.num_of_primitives+=2;
#endif


#elif (CHIPSET == 10 && BOARD == 35)

#if (L1_GTT == 1)
  l1a.dyn_dwnld.num_of_primitives++;
#endif // L1_GTT
#if (L1_VOCODER_IF_CHANGE == 1)
    l1a.dyn_dwnld.num_of_primitives++;
#endif // L1_VOCODER_IF_CHANGE
#if (AUDIO_TASK == 1)
#if (L1_VOICE_MEMO_AMR == 1)
    // Two primitves for L1_VOICE_MEMO_AMR
    l1a.dyn_dwnld.num_of_primitives+=2;
#endif // AUDIO_TASK
#endif // L1_VOICE_MEMO_AMR 
#endif // CHIPSET
  

  for (i=l1a.dyn_dwnld.num_patches_installed;i<MAX_NUM_OF_PATCH_IDS;i++)
  {  
    l1a.dyn_dwnld.patch_id[i]      = 0xFFFF; //omaps00090550 ;
    l1a.dyn_dwnld.next_patch_id[i] = 0xFFFF; //omaps00090550 ;
  }
  for (i=0;i<MAX_NUM_OF_SEMAPHORES;i++)
     l1a.dyn_dwnld.semaphore_vect[i] = GREEN;

   
    l1a.dyn_dwnld.waiting_patch_fifo.num_of_elem = 0;
    for (i=0;i<MAX_NUM_OF_PATCH_IDS;i++)
      l1a.dyn_dwnld.waiting_patch_fifo.signal_code_vect[i] = 0;
  
  /*---------------------------------------------------------------------*/

  /*---------- Set L1S globals at phone init ----------------------------*/
  
  l1s.dyn_dwnld_state=0;
  
  /*---------------------------------------------------------------------*/


  /* Set API ACCESS bit to 16 bits mode */
  /* Bit 5: 0 -> 32 bits mode           */
  /*        1 -> 16 bits mode           */

#if (CODE_VERSION != SIMULATION)
  (*(volatile UWORD16 *) 0xFFFFFB0E) |= 0x0020;
#endif // CODE_VERSION != SIMULATION
}

/*-------------------------------------------------------*/
/* l1_dyn_dwl_reset()                                    */
/*                                                       */
/*-------------------------------------------------------*/
/* Parameters : none                                     */
/* Return     : nothing                                  */
/* Functionality : Reset Dynamic Download variables      */
/*                                                       */
/*-------------------------------------------------------*/

void l1_dyn_dwnld_reset()
{
  UWORD8 indx_loop;

  /* Reset L1A-L1S commands */
  l1a_l1s_com.dyn_dwnld_task.start = FALSE;
  l1a_l1s_com.dyn_dwnld_task.stop  = FALSE;
 
  /* Reset L1A-API HISR commands */

  l1a_apihisr_com.dyn_dwnld.command.restart = FALSE;
  l1a_apihisr_com.dyn_dwnld.uninstall_parameters.num_of_elem = 0;

  for (indx_loop = 0 ; indx_loop < MAX_NUM_OF_PATCH_IDS ; indx_loop++  )
  {
    l1a_apihisr_com.dyn_dwnld.uninstall_parameters.address[indx_loop]           = 0;
    l1a_apihisr_com.dyn_dwnld.copy_parameters.patch_data[indx_loop].start_MCU_copy_address = 0;
    l1a_apihisr_com.dyn_dwnld.copy_parameters.patch_data[indx_loop].address_to_install     = 0; 
    l1a_apihisr_com.dyn_dwnld.copy_parameters.patch_data[indx_loop].size_array             = 0;
  }

  l1a_apihisr_com.dyn_dwnld.copy_parameters.size_of_dwnld_area  = 0;
  l1a_apihisr_com.dyn_dwnld.copy_parameters.start_of_dwnld_area = 0;
  l1a_apihisr_com.dyn_dwnld.copy_parameters.num_of_elem         = 0;

  /* Reset global API HISR variable */
  l1_apihisr.dyn_dwnld.state                  = 0;
  l1_apihisr.dyn_dwnld.running                = FALSE;
  l1_apihisr.dyn_dwnld.uninstall_counter      = 0;
  l1_apihisr.dyn_dwnld.patch_ids_counter      = 0;
  l1_apihisr.dyn_dwnld.running_source_pointer = 0;
  l1_apihisr.dyn_dwnld.tmp_patch_size = 0;
  
  /* Reset L1A global FIFO for handling the DELAY (when two or more primitives fall within a dynamic download time frame)*/
  l1a.dyn_dwnld.waiting_patch_fifo.num_of_elem = 0;
  for (indx_loop=0;indx_loop<MAX_NUM_OF_PATCH_IDS;indx_loop++)
  {  
    l1a.dyn_dwnld.waiting_patch_fifo.signal_code_vect[indx_loop] = 0;
    l1a.dyn_dwnld.next_patch_id[indx_loop] = 0xFFFF; //omaps00090550 ;
  }
}

/*---------------------------------------------------------------------*/
/* l1_dyn_dwnld_reset_api()                                            */
/*---------------------------------------------------------------------*/
/* Parameters  : none                                                  */
/* Return         : nothing                                            */
/* Functionality : Reset Dynamic Download API variables                */
/*                                                                     */
/*---------------------------------------------------------------------*/
void l1_dyn_dwnld_reset_api()
{
  dyn_dwl_ndb->d_api_dwl_download_ctrl       = (API) 0;
  dyn_dwl_ndb->d_api_dwl_error_code          = (API) 0;
  dyn_dwl_ndb->d_api_dwl_function_address[0] = (API) 0;
  dyn_dwl_ndb->d_api_dwl_function_address[1] = (API) 0;
  dyn_dwl_ndb->d_api_dwl_crc                 = (API) 0;
  dyn_dwl_ndb->d_api_dwl_size                = (API) 0;
  dyn_dwl_ndb->d_api_dwl_write_pointer       = (API) 0;
}

#endif  // L1_DYN_DSP_DWNLD
