/**********************************************************************************
drp_api.h
-- Copyright (c) 2005, Texas Instruments, Inc.
-- Author: Shrinivas Gadkari

All drp related structures are defined here.
***********************************************************************************
                               Change History
************************************************************************************

Version     Date           Author(s)        Comments
-------------------------------------------------------------------------------------
Ver 0.0     12 May 2004    SG               Initial creation

************************************************************************************/

#ifndef  __DRP_API__

#define   __DRP_API__

/*
#include "sys_types.h"
*/
#if (DRP_FW_BUILD == 1)
#include "l1_types.h"
#endif
#include "general.h"


#include "drp_defines.h" //Added by Danny
#include "drp_extern_dependencies.h"

//#if (DRP_FILES_GENERATION_BUILD || DRP_STANDALONE_BUILD)

#if DRP_FILES_GENERATION_BUILD
  typedef long WORD32;
  typedef unsigned long uint32;
  #if (DRP_FW_BUILD==0)
    typedef unsigned long UINT32;
  #endif
  typedef unsigned long UWORD32;
  typedef unsigned long SYS_UWORD32;
  typedef short WORD16;

  #if defined NUCLEUS || defined __TYPEDEFS_H__
    typedef unsigned short UINT16;
  #endif

  typedef unsigned short UWORD16;
  typedef unsigned char  UINT8;
  typedef unsigned char  UWORD8;
#else
  //
#endif

typedef long        SINT32;
typedef short       SINT16;
typedef signed char SINT8;

#ifndef BASIC_TYPES
#define BASIC_TYPES
  typedef unsigned long uint32;
  typedef unsigned char uint8;
  typedef short int16;
  typedef unsigned short uint16;
  #if (DRP_FW_BUILD==1)
    #if defined NUCLEUS && defined PLUS_VERSION_COMP
      typedef unsigned long UINT32;
    #endif
  #endif
#endif

#ifdef __DRP_FILE__
  #if defined NUCLEUS || defined __TYPEDEFS_H__ || (DRP_FW_BUILD == 0)
    typedef unsigned short UINT16;
  #endif

  #if (DRP_FW_BUILD==0)
    //#if defined NUCLEUS && defined PLUS_VERSION_COMP
      typedef unsigned long UINT32;
    typedef unsigned char UINT8;
    //#endif
  #endif

  #if defined NUCLEUS && defined PLUS_VERSION_COMP
    typedef unsigned char UINT8;
  #endif
#endif

typedef unsigned long  DRP_UINT32;
typedef unsigned short DRP_UWORD16;
typedef unsigned short DRP_WORD16;
typedef unsigned long  DRP_UWORD32;
typedef unsigned short DRP_UINT16;
typedef unsigned char  DRP_UINT8;

#define L1_DRP_DITHERING          1

//MUX defines for enabling TSTCLK0 on GPIO_17
#define CONF_GPIO_17              0xFFFEF156
#define CONF_MUX_VIEW8            0xFFFE9259
#define CONF_DEBUG_SEL_TST_8      0xFFFE9208
#define CONF_LOCOSTO_DEBUG        0xFFFEF020 //0x00 for normal debug values

/****************************************************************************/
/****************************************************************************/
/*             Data structure elements for DRP_SW_DATA                      */
/****************************************************************************/
/****************************************************************************/

/*-------------------------------------**
** TX_RX common calibration parameters **
**-------------------------------------*/
typedef struct
{
  UINT16 perinv_value;
  UINT16 dlo_at_value;
  UINT16 pvt_value[2*NUM_BANDS];
  UINT16 kdco_inv[2*NUM_BANDS];
#if DRP_FLYBACK_IBIAS_CALIB
  UINT16 subband_rffreq[NUM_BANDS*NUM_FLYBACK_SUBBANDS];
  UINT16 ckv_dly[NUM_BANDS*NUM_FLYBACK_SUBBANDS];
  UINT16 perinv_thresh[NUM_BANDS*NUM_FLYBACK_SUBBANDS][3];
  UINT16 ibias[NUM_BANDS*NUM_FLYBACK_SUBBANDS];
#endif
} T_DRP_TXRXCOMMON_CALIB;

/*----------------------------**
** LNA calibration parameters **
**----------------------------*/
typedef struct
{
  UINT16 cfreq[NUM_BANDS];
} T_DRP_LNA_CALIB;

/*-----------------------------**
** IQMC calibration parameters **
**-----------------------------*/
typedef struct
{
  UINT16 coeff[NUM_BANDS][2];
} T_DRP_IQMC_CALIB;

/*---------------------------------**
** SCF pole calibration parameters **
**---------------------------------*/
typedef struct
{
  UINT32 ANA_MIX_LB_IQ_table[NUM_BANDS];
  UINT32 ANA_SCF_IQ_0_table[2*NUM_BANDS];
} T_DRP_SCFPOLE_CALIB;

/*----------------------------**
** ABE calibration paraneters **
**----------------------------*/
typedef struct
{
  UINT32 gain_alpha_table[NUM_ABE_GAINS];
} T_DRP_ABE_CALIB;

/*---------------------------**
** ABE simulation parameters **
**---------------------------*/
typedef struct
{
  UINT16 beta[NUM_ABE_GAINS];
  UINT32 abe_calib_table_weak[NUM_ABE_GAINS];
} T_DRP_ABE_SIMU;

/*----------------------------**
** AFE calibration parameters **
**----------------------------*/
typedef struct
{
  SINT16 gain[NUM_BANDS][NUM_AFE_GAINS];
} T_DRP_AFE_CALIB;

/*-------------------------------------------**
** Temperature Sensor Calibration parameters **
**-------------------------------------------*/
typedef struct
{
  SINT8 temperature[NUM_TEMPERATURE];
} T_DRP_TEMP_CALIB;

/*------------------------------------------**
** Temperature Sensor Simulation parameters **
**------------------------------------------*/
typedef struct
{
  SINT8 temp_code_weak[NUM_TEMPERATURE];
  SINT8 temp_code_strong[NUM_TEMPERATURE];
} T_DRP_TEMP_SIMU;


/*---------------------------**
** RX Calibration parameters **
**---------------------------*/
typedef struct
{
  T_DRP_ABE_CALIB abe;
  T_DRP_AFE_CALIB afe;
  T_DRP_LNA_CALIB lna;
  T_DRP_IQMC_CALIB iqmc;
  T_DRP_SCFPOLE_CALIB scf_pole;
} T_DRP_RX_CALIB;

/*-----------------------------**
** DCXO Calibration parameters **
**-----------------------------*/
typedef struct
{
  UINT16 cfa_value;
  UINT16 idac_value;
} T_DRP_DCXO_CALIB;

/*---------------------------**
** Logarithm Const parameters         **
**---------------------------*/
typedef struct
{
  UINT16 logarithm_table[33];
  UINT16 dummy1;     // 16 bit word padding
} T_DRP_LOG_CONST;

/*---------------------------**
** ABE constant settings **
**---------------------------*/
typedef struct
{
  UINT16 gain_table_0[NUM_ABE_GAINS];
  UINT16 gain_table_1[NUM_ABE_GAINS];
  UINT16 abe_meas_input_strength[NUM_ABE_GAINS];
} T_DRP_ABE_CONST;

/*----------------------------**
** AFE constants settings **
**----------------------------*/
typedef struct
{
  UINT16 gain_table[NUM_AFE_GAINS];
} T_DRP_AFE_CONST;

/*--------------------------**
** RX Constant parameters **
**--------------------------*/
typedef struct
{
  T_DRP_ABE_CONST abe;
  T_DRP_AFE_CONST afe;
} T_DRP_RX_CONST;

/*--------------------------**
** RX Simulation parameters **
**--------------------------*/
typedef struct
{
  T_DRP_ABE_SIMU abe;
} T_DRP_RX_SIMU;

/*************************************************/
/*       DRP SW Data Structure Additions         */
/*************************************************/
typedef struct
{
  UINT16 version;              // DRP FW version number
  UINT16 efuse[4];
  UINT16 dummy1;               // 16 bit word padding
} T_DRP_SW_DATA_VER_EFUSE;

// **************************************************************************
// ** PPA Slope Values **
// **************************************************************************
typedef struct {
  UINT16 magnitude[NUM_BANDS];
  SINT16 slope[NUM_BANDS];
} T_DRP_PPA;

/*----------------------------**
** FLYBACK DELAY calibration parameters **
**----------------------------*/
typedef struct
{
  SINT16 xmax_table[2];
  UINT16 cf_table[2];
  UINT16 ct_table[2];
  UINT16 perinvcal_table[2];
  UINT16 fcal_table[2];
} T_FLYBACK_DELAY_CALIB;

/************************************/
/*       DRP MAIN CAL               */
/************************************/
typedef struct
{
  T_DRP_TXRXCOMMON_CALIB txrx_common;
  T_DRP_RX_CALIB         rx;
  T_DRP_DCXO_CALIB       dcxo;
  T_DRP_TEMP_CALIB       temperature;
  T_DRP_SW_DATA_VER_EFUSE drp_sw_data_ver_efuse;
  T_DRP_PPA              ppa;
  T_FLYBACK_DELAY_CALIB  flyback;
  //any other data structure
} T_DRP_CALIB;

/*************************************************/
/*       DRP MAIN SIMULATION PARAM               */
/*************************************************/
typedef struct
{
  T_DRP_RX_SIMU rx;
  T_DRP_TEMP_SIMU temperature;
} T_DRP_SIMU;

/*************************************************/
/*       DRP Complete SW Data Structure          */
/*************************************************/
typedef struct
{
  UINT16 length;              // length of the structure
  UINT16 dummy1;              // 16bit padding
  T_DRP_CALIB calib;          // contains the calibration data
  T_DRP_LOG_CONST log_const;  //
  T_DRP_RX_CONST rx_const;    //
  T_DRP_SIMU  simulation;
} T_DRP_SW_DATA;


/****************************************************************************/
/****************************************************************************/
/*       Elements of the DRP_SRM_DATA structure                             */
/****************************************************************************/
/****************************************************************************/

typedef struct
{
  UINT16 dspmcu_divider[DSPMCU_DIVIDER_TABLE_LENGTH];
  UINT16 fcu_dac_compare_table[NUM_FCU_DAC_COMPARE_VALUES];
  UINT16 fcu_dac_table[NUM_FCU_DAC_COMPARE_VALUES];
  UINT16 abe_gain_table_0[NUM_ABE_GAINS];
  UINT16 abe_gain_table_1[NUM_ABE_GAINS];
  UINT16 afe_gain_table[NUM_AFE_GAINS];
  UINT16 afe_calib_table[NUM_BANDS][NUM_AFE_GAINS];
  UINT32 abe_calib_table[NUM_ABE_GAINS];
  UINT16 afe_est_table[NUM_AFE_GAINS];
  UINT16 abe_est_table[NUM_ABE_GAINS];
  UINT16 tar_afe_gain_table[2][NUM_AFE_GAINS_LOCOSTO];
  UINT16 tar_abe_gain_table[NUM_ABE_GAINS_LOCOSTO];
  UINT16 dcxo_ib_table[NUM_DCXO_IB_COMP_VALUES];
  UINT16 ana_dcu_pcu_table[2];
  UINT16 dco_clk_dcu_pcu_table[2];
  UINT16 temp_dummy1;
  UINT16 arx_default_table[NUM_ARX_VALUES];
  UINT16 rx_freq_table[2];
  UINT16 tx_freq_table[2];
  UINT16 rx_dco1[NUM_BANDS];
  UINT16 rx_dco2[NUM_BANDS];
  UINT16 rx_ibias[2];
  UINT16 tx_dco[NUM_BANDS];
  UINT16 tx_ibias[2];
  UINT16 tx_cfreq_table[NUM_BANDS];
  UINT16 rx_cfreq_table[NUM_BANDS];
  SINT16 tx_ppa_slope[NUM_BANDS];
  UINT16 tx_ppa_table[NUM_BANDS];
  SINT8 temperature[NUM_TEMPERATURE];
  UINT8  hb_fcw_comp_table[NUM_HB_FCW_COMP_VALUES];
  UINT8  lb_fcw_comp_table[NUM_LB_FCW_COMP_VALUES];
  UINT8  dcxo_ib_comp_table[NUM_DCXO_IB_COMP_VALUES];
  SINT8  tx_kdco_cmp_table[4];
  SINT8  tx_kdco_update_table[4];
} T_DRP_SRM_TABLES;

/**************************************************/
/* Tx-Rx Common Calib                             */
/**************************************************/

typedef struct
{
  UINT16 perinv;
  UINT16 dummy1;                 //16 bit word padding
  //need to remove this definition in future. The copy_calibration_data()
  //will write directly into the DRP register and scripts will not be reading
  //the value from SRM.
  //UINT16 dlo_tune_at;
} T_DRP_SRM_TX_RX_COMMON_CALIB;

/*************************************************/
/*  RX Calibration Tables                        */
/*************************************************/

typedef struct
{
  UINT16 kdco_t[NUM_BANDS];
  UINT16 pvt[NUM_BANDS];
  UINT32 iqmc[NUM_BANDS];
  UINT32 mix_lb[NUM_BANDS];
  UINT32 scf[2*NUM_BANDS];        //Corner frequencies specified are one of {400kHz, 270kHz, 270kHz} and {400kHz, 400kHz, 400kHz}
  UINT16 cfreq[NUM_BANDS];
} T_DRP_SRM_RX_CALIB;

/*************************************************/
/*  TX Calibration Tables                        */
/*************************************************/

typedef struct
{
  UINT16 kdco_t[NUM_BANDS];
  UINT16 pvt[NUM_BANDS];
#if DRP_FLYBACK_IBIAS_CALIB
  UINT16 subband_rffreq[NUM_BANDS*NUM_FLYBACK_SUBBANDS];
  UINT16 ckv_dly[NUM_BANDS*NUM_FLYBACK_SUBBANDS];
  UINT16 perinv_thresh[NUM_BANDS*NUM_FLYBACK_SUBBANDS][3];
  UINT16 ibias[NUM_BANDS*NUM_FLYBACK_SUBBANDS];
#endif
} T_DRP_SRM_TX_CALIB;

/*************************************************/
/* Complete SRM Calibration and Tables Data Structure       */
/*************************************************/

typedef struct
{
  T_DRP_SRM_TX_RX_COMMON_CALIB txrx;
  T_DRP_SRM_RX_CALIB rx;
  T_DRP_SRM_TX_CALIB tx;
  T_DRP_SRM_TABLES tables;
  UINT32 atten_100khz;
  UINT16 abe_gain_comp_index;
  SINT16 dc_offset_i;
  SINT16 dc_offset_q;
  UINT16 dcxo_ib_den_corr;
  SINT16 fcudac_offset_i;
  SINT16 fcudac_offset_q;
  UINT16 temp1;
  UINT16 int_halfint_ch_flag;
  UINT32 force_fcuoffset;
  UINT16 clk_src1_single_double_dither_flag;
  UINT16 loop_delay_clk_src1_clk_src2;
  UINT16 loop_delay_clk_src2;
  UINT16 kdco_slope;
  UINT16 tx_ppa_comp;
  UINT16 a2d_bypass;
  SINT16 tx_kdco_adapt_sum;
  UINT16 tx_kdcoadapten_demcw;
  UINT16 comp_kdco;
  UINT16 tx_sdorder_cw;
  UINT16 tx_dither_en_flyback_cal_en;
  UINT16 dummy1;
  UINT32 dcest_min_out_pos_dc;
  UINT32 dcest_max_out_pos_dc;
  UINT32 dcest_min_out_neg_dc;
  UINT32 dcest_max_out_neg_dc;
  SINT16 flyback_xmax_table[2];
  UINT16 flyback_cf_table[2];
  UINT16 flyback_ct_table[2];
  UINT16 flyback_perinvcal_table[2];
  UINT16 flyback_fcal_table[2];
} T_DRP_SRM_DATA;

/****************************************************************************/
/****************************************************************************/
/*                 API STRUCTURE                  */
/****************************************************************************/
/****************************************************************************/

/*-----------------------------**
** ROC Script Input Parameters **
**-----------------------------*/
typedef struct
{
  UINT16 window_start;
  UINT16 window_stop;
  SINT16  lut_start_phase;
  SINT16  dummy1;
}
T_DRP_ROC_IN;

/*------------------------------**
** ROC Script Output Parameters **
**------------------------------*/
typedef struct
{
  UINT32 accum_I[4];
  UINT32 accum_Q[4];
}
T_DRP_ROC_OUT;

/*-----------------------------**
** ROC Script InOut Parameters **
**-----------------------------*/
typedef struct
{
  T_DRP_ROC_IN input;
  T_DRP_ROC_OUT output;
}
T_DRP_ROC_INOUT;

/*------------------------------**
** AGC        Output Parameters **
**------------------------------*/
typedef struct
{
  UINT16 compensated_gain;       // ABF + AFE gain in DRP after compensation
                                  // 1024*log2(Pout/Pin)
  UINT16 meas_abe_vpp_i;         // V-pp for I path
  UINT16 meas_abe_vpp_q;         // V-pp for Q path
  UINT16 dummy1;                 // 16 bit word padding;
}
T_DRP_AGC_OUT;

/*------------------------------**
** Temperature InOut Parameters **
**------------------------------*/
typedef struct
{
  SINT16 output;
  UINT16 dummy1;      //16 bit word padding
}
T_DRP_TEMP_OUT;

/*---------------------**
** RX InOut Parameters **
**---------------------*/
typedef struct
{
  UINT16 rxon_input;          // b0 - IF_FREQ index
                               // b1 - Gain compensation enable
                               // b5:b2 - ABE gain index
                               // b6 - AFE gain index
                               // b7 - SCF Pole index
                               // b9:8 - dbb if setting
  UINT16 dummy1;              //16 bit word padding
  T_DRP_AGC_OUT agc;           //agc control structure
#if LOCOSTO_VALID
  T_DRP_ROC_INOUT roc;
#endif
}
T_DRP_RX_INOUT;


/*-----------------------------**
** AFC script Input Parameters **
**-----------------------------*/
typedef struct
{
  UINT16 mem_xtal;
  UINT16 dummy1;      //16 bit word padding
}
T_DRP_AFC_IN;

/*-----------------------------**
** AFC script Output Parameters **
**-----------------------------*/
typedef struct
{
  UINT16 dcxo_amp;
  UINT16 dummy1;      //16 bit word padding
}
T_DRP_AFC_OUT;

/*-----------------------------**
** AFC script InOut Parameters **
**-----------------------------*/
typedef struct
{
  T_DRP_AFC_IN input;
  T_DRP_AFC_OUT output;
}
T_DRP_AFC_INOUT;

/*----------------------**
** DRP InOut Parameters **
**----------------------*/
typedef struct
{
  T_DRP_RX_INOUT rx;
  T_DRP_AFC_INOUT afc;
  T_DRP_TEMP_OUT temperature;
}
T_DRP_INOUT;

/*---------------------------**
** DRP General control words **
**---------------------------*/

typedef struct
{
  UINT16 retiming;     // enable-disable control of retiming
  UINT16 calib_ctl;    // b0 - FCW bypass for Tx
                        // b1 - FCW bypass for RX
                        // b2 - Bypass ABE gain comp call
                        // b3 - Bypass AFE gain comp call
                        // b4 - mixer disable during ABE gain measure
                        // b5 - ibias setting bypass
                        // b6 - flyback setting bypass
                        // b7 - use CVKD2 for TX_ON DCOIF
                        // b8 - AFE always ON
                        // b9 - Use EFUSE from DRP memory locations
                       // b10 - LNA cfreq calibration for DCS band disabled
                       // b11 - LNA cfreq calibration for PCS band disabled
}
T_DRP_CTL;

/*------------------------------------**
** DRP SRM API Data Structure **
**------------------------------------*/
typedef struct
{
  T_DRP_INOUT inout;        // input-output DRP parameters - phone mode
  T_DRP_CTL control;        // contains the DRP operating mode control words
  UINT16 compensated_abe_gain;
  UINT16 compensated_afe_gain;
  UINT16 tx_start_wait1;
  UINT8  tx_start_wait2;
  UINT8  dummy1;
} T_DRP_SRM_API;


/****************************************/
/*        DRP Registers                 */
/****************************************/

typedef struct  {

        volatile UINT16 DRP2_ID_0L;
        volatile UINT16 DRP2_ID_0H;
        volatile UINT16 DRP2_ID_1L;
        volatile UINT16 DRP2_ID_1H;
        volatile UINT16 OCP_RSVD_0X08L;
        volatile UINT16 OCP_RSVD_0X08H;
        volatile UINT16 OCP_RSVD_0X0CL;
        volatile UINT16 OCP_RSVD_0X0CH;
        volatile UINT16 OCP_SYSCONFIGL;
        volatile UINT16 OCP_SYSCONFIGH;
        volatile UINT16 OCP_SYSSTATUSL;
        volatile UINT16 OCP_SYSSTATUSH;
        volatile UINT16 OCP_IRQSTATUSL;
        volatile UINT16 OCP_IRQSTATUSH;
        volatile UINT16 OCP_IRQENABLEL;
        volatile UINT16 OCP_IRQENABLEH;
        volatile UINT16 OCP_WKUPENABLEL;
        volatile UINT16 OCP_WKUPENABLEH;
        volatile UINT16 OCP_IRQCFGL;
        volatile UINT16 OCP_IRQCFGH;
        volatile UINT16 OCP_PORT_CTLL;
        volatile UINT16 OCP_PORT_CTLH;
        volatile UINT16 OCP_SCRATCHL;
        volatile UINT16 OCP_SCRATCHH;
        volatile UINT16 OCP_IRQTRIGENL;
        volatile UINT16 OCP_IRQTRIGENH;
        volatile UINT16 OCP_IRQTRIGL;
        volatile UINT16 OCP_IRQTRIGH;
        volatile UINT16 MEM_0038L;
        volatile UINT16 MEM_0038H;
        volatile UINT16 MEM_003CL;
        volatile UINT16 MEM_003CH;
        volatile UINT16 MEM_0040L;
        volatile UINT16 MEM_0040H;
        volatile UINT16 MEM_0044L;
        volatile UINT16 MEM_0044H;
        volatile UINT16 MEM_0048L;
        volatile UINT16 MEM_0048H;
        volatile UINT16 MEM_004CL;
        volatile UINT16 MEM_004CH;
        volatile UINT16 MEM_0050L;
        volatile UINT16 MEM_0050H;
        volatile UINT16 MEM_0054L;
        volatile UINT16 MEM_0054H;
        volatile UINT16 MEM_0058L;
        volatile UINT16 MEM_0058H;
        volatile UINT16 MEM_005CL;
        volatile UINT16 MEM_005CH;
        volatile UINT16 MEM_0060L;
        volatile UINT16 MEM_0060H;
        volatile UINT16 MEM_0064L;
        volatile UINT16 MEM_0064H;
        volatile UINT16 MEM_0068L;
        volatile UINT16 MEM_0068H;
        volatile UINT16 MEM_006CL;
        volatile UINT16 MEM_006CH;
        volatile UINT16 MEM_0070L;
        volatile UINT16 MEM_0070H;
        volatile UINT16 MEM_0074L;
        volatile UINT16 MEM_0074H;
        volatile UINT16 MEM_0078L;
        volatile UINT16 MEM_0078H;
        volatile UINT16 MEM_007CL;
        volatile UINT16 MEM_007CH;
        volatile UINT16 MEM_0080L;
        volatile UINT16 MEM_0080H;
        volatile UINT16 MEM_0084L;
        volatile UINT16 MEM_0084H;
        volatile UINT16 MEM_0088L;
        volatile UINT16 MEM_0088H;
        volatile UINT16 MEM_008CL;
        volatile UINT16 MEM_008CH;
        volatile UINT16 MEM_0090L;
        volatile UINT16 MEM_0090H;
        volatile UINT16 MEM_0094L;
        volatile UINT16 MEM_0094H;
        volatile UINT16 MEM_0098L;
        volatile UINT16 MEM_0098H;
        volatile UINT16 MEM_009CL;
        volatile UINT16 MEM_009CH;
        volatile UINT16 MEM_00A0L;
        volatile UINT16 MEM_00A0H;
        volatile UINT16 MEM_00A4L;
        volatile UINT16 MEM_00A4H;
        volatile UINT16 MEM_00A8L;
        volatile UINT16 MEM_00A8H;
        volatile UINT16 MEM_00ACL;
        volatile UINT16 MEM_00ACH;
        volatile UINT16 MEM_00B0L;
        volatile UINT16 MEM_00B0H;
        volatile UINT16 MEM_00B4L;
        volatile UINT16 MEM_00B4H;
        volatile UINT16 MEM_00B8L;
        volatile UINT16 MEM_00B8H;
        volatile UINT16 MEM_00BCL;
        volatile UINT16 MEM_00BCH;
        volatile UINT16 MEM_00C0L;
        volatile UINT16 MEM_00C0H;
        volatile UINT16 MEM_00C4L;
        volatile UINT16 MEM_00C4H;
        volatile UINT16 MEM_00C8L;
        volatile UINT16 MEM_00C8H;
        volatile UINT16 MEM_00CCL;
        volatile UINT16 MEM_00CCH;
        volatile UINT16 MEM_00D0L;
        volatile UINT16 MEM_00D0H;
        volatile UINT16 MEM_00D4L;
        volatile UINT16 MEM_00D4H;
        volatile UINT16 MEM_00D8L;
        volatile UINT16 MEM_00D8H;
        volatile UINT16 MEM_00DCL;
        volatile UINT16 MEM_00DCH;
        volatile UINT16 MEM_00E0L;
        volatile UINT16 MEM_00E0H;
        volatile UINT16 MEM_00E4L;
        volatile UINT16 MEM_00E4H;
        volatile UINT16 MEM_00E8L;
        volatile UINT16 MEM_00E8H;
        volatile UINT16 MEM_00ECL;
        volatile UINT16 MEM_00ECH;
        volatile UINT16 MEM_00F0L;
        volatile UINT16 MEM_00F0H;
        volatile UINT16 MEM_00F4L;
        volatile UINT16 MEM_00F4H;
        volatile UINT16 MEM_00F8L;
        volatile UINT16 MEM_00F8H;
        volatile UINT16 MEM_00FCL;
        volatile UINT16 MEM_00FCH;
        volatile UINT16 DLO_IIRL;
        volatile UINT16 DLO_IIRH;
        volatile UINT16 DLO_ALPHAL;
        volatile UINT16 DLO_ALPHAH;
        volatile UINT16 DLO_GAINL;
        volatile UINT16 DLO_GAINH;
        volatile UINT16 DLO_KDCOINV_TL;
        volatile UINT16 DLO_KDCOINV_TH;
        volatile UINT16 DLO_TUNE_A_TL;
        volatile UINT16 DLO_TUNE_A_TH;
        volatile UINT16 DLO_PERINVL;
        volatile UINT16 DLO_PERINVH;
        volatile UINT16 DLO_OFFSETL;
        volatile UINT16 DLO_OFFSETH;
        volatile UINT16 DLO_TUNEL;
        volatile UINT16 DLO_TUNEH;
        volatile UINT16 DLO_PHASEL;
        volatile UINT16 DLO_PHASEH;
        volatile UINT16 DLO_LFL;
        volatile UINT16 DLO_LFH;
        volatile UINT16 DLO_DCOIFL;
        volatile UINT16 DLO_DCOIFH;
        volatile UINT16 DLO_TUNE_LIML;
        volatile UINT16 DLO_TUNE_LIMH;
        volatile UINT16 DLO_TESTL;
        volatile UINT16 DLO_TESTH;
        volatile UINT16 DLO_CQML;
        volatile UINT16 DLO_CQMH;
        volatile UINT16 DLO_TDCSDL;
        volatile UINT16 DLO_TDCSDH;
        volatile UINT16 DLO_INTERRUPTL;
        volatile UINT16 DLO_INTERRUPTH;
        volatile UINT16 DLO_CKR_SDL;
        volatile UINT16 DLO_CKR_SDH;
        volatile UINT16 MEM_0144L;
        volatile UINT16 MEM_0144H;
        volatile UINT16 MEM_0148L;
        volatile UINT16 MEM_0148H;
        volatile UINT16 MEM_014CL;
        volatile UINT16 MEM_014CH;
        volatile UINT16 RF_FREQL;
        volatile UINT16 RF_FREQH;
        volatile UINT16 DLO_FCWL;
        volatile UINT16 DLO_FCWH;
        volatile UINT16 DSP_DIVIDERL;
        volatile UINT16 DSP_DIVIDERH;
        volatile UINT16 MCU_DIVIDERL;
        volatile UINT16 MCU_DIVIDERH;
        volatile UINT16 DLO_SEQL;
        volatile UINT16 DLO_SEQH;
        volatile UINT16 DLO_SEQ_SRSTL;
        volatile UINT16 DLO_SEQ_SRSTH;
        volatile UINT16 DLO_SEQ_CQML;
        volatile UINT16 DLO_SEQ_CQMH;
        volatile UINT16 DLO_CALIBL;
        volatile UINT16 DLO_CALIBH;
        volatile UINT16 DLO_IPML;
        volatile UINT16 DLO_IPMH;
        volatile UINT16 MEM_0174L;
        volatile UINT16 MEM_0174H;
        volatile UINT16 MEM_0178L;
        volatile UINT16 MEM_0178H;
        volatile UINT16 RDLO_ALPHAL;
        volatile UINT16 RDLO_ALPHAH;
        volatile UINT16 RDLO_FLAGSL;
        volatile UINT16 RDLO_FLAGSH;
        volatile UINT16 RDLO_FLAGS2L;
        volatile UINT16 RDLO_FLAGS2H;
        volatile UINT16 RDLO_TUNEL;
        volatile UINT16 RDLO_TUNEH;
        volatile UINT16 RDLO_TSTL;
        volatile UINT16 RDLO_TSTH;
        volatile UINT16 RCAL_RAWACC_RFL;
        volatile UINT16 RCAL_RAWACC_RFH;
        volatile UINT16 RCAL_RAWACC_FRL;
        volatile UINT16 RCAL_RAWACC_FRH;
        volatile UINT16 RCAL_RAWNUM_RFL;
        volatile UINT16 RCAL_RAWNUM_RFH;
        volatile UINT16 RCAL_RAWNUM_FRL;
        volatile UINT16 RCAL_RAWNUM_FRH;
        volatile UINT16 RTUNE_ACCL;
        volatile UINT16 RTUNE_ACCH;
        volatile UINT16 MEM_01A4L;
        volatile UINT16 MEM_01A4H;
        volatile UINT16 MEM_01A8L;
        volatile UINT16 MEM_01A8H;
        volatile UINT16 MEM_01ACL;
        volatile UINT16 MEM_01ACH;
        volatile UINT16 RCAL_TL;
        volatile UINT16 RCAL_TH;
        volatile UINT16 MEM_01B4L;
        volatile UINT16 MEM_01B4H;
        volatile UINT16 MEM_01B8L;
        volatile UINT16 MEM_01B8H;
        volatile UINT16 MEM_01BCL;
        volatile UINT16 MEM_01BCH;
        volatile UINT16 MEM_01C0L;
        volatile UINT16 MEM_01C0H;
        volatile UINT16 MEM_01C4L;
        volatile UINT16 MEM_01C4H;
        volatile UINT16 MEM_01C8L;
        volatile UINT16 MEM_01C8H;
        volatile UINT16 MEM_01CCL;
        volatile UINT16 MEM_01CCH;
        volatile UINT16 MEM_01D0L;
        volatile UINT16 MEM_01D0H;
        volatile UINT16 MEM_01D4L;
        volatile UINT16 MEM_01D4H;
        volatile UINT16 MEM_01D8L;
        volatile UINT16 MEM_01D8H;
        volatile UINT16 MEM_01DCL;
        volatile UINT16 MEM_01DCH;
        volatile UINT16 MEM_01E0L;
        volatile UINT16 MEM_01E0H;
        volatile UINT16 MEM_01E4L;
        volatile UINT16 MEM_01E4H;
        volatile UINT16 MEM_01E8L;
        volatile UINT16 MEM_01E8H;
        volatile UINT16 MEM_01ECL;
        volatile UINT16 MEM_01ECH;
        volatile UINT16 MEM_01F0L;
        volatile UINT16 MEM_01F0H;
        volatile UINT16 MEM_01F4L;
        volatile UINT16 MEM_01F4H;
        volatile UINT16 MEM_01F8L;
        volatile UINT16 MEM_01F8H;
        volatile UINT16 MEM_01FCL;
        volatile UINT16 MEM_01FCH;
        volatile UINT16 RCF1_CWL;
        volatile UINT16 RCF1_CWH;
        volatile UINT16 PREF_CWL;
        volatile UINT16 PREF_CWH;
        volatile UINT16 FCU_DACL;
        volatile UINT16 FCU_DACH;
        volatile UINT16 DOC_COMPL;
        volatile UINT16 DOC_COMPH;
        volatile UINT16 DCEST_CWL;
        volatile UINT16 DCEST_CWH;
        volatile UINT16 DCEST_IIR_WRL;
        volatile UINT16 DCEST_IIR_WRH;
        volatile UINT16 DCEST_IIR_RDL;
        volatile UINT16 DCEST_IIR_RDH;
        volatile UINT16 DCEST_MM_REFL;
        volatile UINT16 DCEST_MM_REFH;
        volatile UINT16 DCEST_MIN_OUTL;
        volatile UINT16 DCEST_MIN_OUTH;
        volatile UINT16 DCEST_MAX_OUTL;
        volatile UINT16 DCEST_MAX_OUTH;
        volatile UINT16 DCEST_OUTL;
        volatile UINT16 DCEST_OUTH;
        volatile UINT16 DAC_CWL;
        volatile UINT16 DAC_CWH;
        volatile UINT16 LUTPRE_CWL;
        volatile UINT16 LUTPRE_CWH;
        volatile UINT16 RES_CWL;
        volatile UINT16 RES_CWH;
        volatile UINT16 IQMC_CWL;
        volatile UINT16 IQMC_CWH;
        volatile UINT16 IQMC_THRESHL;
        volatile UINT16 IQMC_THRESHH;
        volatile UINT16 IQMC_MUL;
        volatile UINT16 IQMC_MUH;
        volatile UINT16 IQMC_W0_INL;
        volatile UINT16 IQMC_W0_INH;
        volatile UINT16 IQMC_W0_OUTL;
        volatile UINT16 IQMC_W0_OUTH;
        volatile UINT16 IQMC_STATUSL;
        volatile UINT16 IQMC_STATUSH;
        volatile UINT16 ROC_CWL;
        volatile UINT16 ROC_CWH;
        volatile UINT16 ROC_STATUSL;
        volatile UINT16 ROC_STATUSH;
        volatile UINT16 ROC_ACCL;
        volatile UINT16 ROC_ACCH;
        volatile UINT16 ROC_CALC_IL;
        volatile UINT16 ROC_CALC_IH;
        volatile UINT16 ROC_CALC_QL;
        volatile UINT16 ROC_CALC_QH;
        volatile UINT16 ZIF_CWL;
        volatile UINT16 ZIF_CWH;
        volatile UINT16 ZIF_LUT_ADDL;
        volatile UINT16 ZIF_LUT_ADDH;
        volatile UINT16 MEM_026CL;
        volatile UINT16 MEM_026CH;
        volatile UINT16 MEM_0270L;
        volatile UINT16 MEM_0270H;
        volatile UINT16 MEM_0274L;
        volatile UINT16 MEM_0274H;
        volatile UINT16 MEM_0278L;
        volatile UINT16 MEM_0278H;
        volatile UINT16 MEM_027CL;
        volatile UINT16 MEM_027CH;
        volatile UINT16 MEM_0280L;
        volatile UINT16 MEM_0280H;
        volatile UINT16 MEM_0284L;
        volatile UINT16 MEM_0284H;
        volatile UINT16 MEM_0288L;
        volatile UINT16 MEM_0288H;
        volatile UINT16 MEM_028CL;
        volatile UINT16 MEM_028CH;
        volatile UINT16 MEM_0290L;
        volatile UINT16 MEM_0290H;
        volatile UINT16 MEM_0294L;
        volatile UINT16 MEM_0294H;
        volatile UINT16 MEM_0298L;
        volatile UINT16 MEM_0298H;
        volatile UINT16 MEM_029CL;
        volatile UINT16 MEM_029CH;
        volatile UINT16 MEM_02A0L;
        volatile UINT16 MEM_02A0H;
        volatile UINT16 MEM_02A4L;
        volatile UINT16 MEM_02A4H;
        volatile UINT16 MEM_02A8L;
        volatile UINT16 MEM_02A8H;
        volatile UINT16 CONN_CWL;
        volatile UINT16 CONN_CWH;
        volatile UINT16 TST_CWL;
        volatile UINT16 TST_CWH;
        volatile UINT16 TST_CONSTL;
        volatile UINT16 TST_CONSTH;
        volatile UINT16 CSF_CWL;
        volatile UINT16 CSF_CWH;
        volatile UINT16 CSF_CNTL;
        volatile UINT16 CSF_CNTH;
        volatile UINT16 CSF_COEFF_0_1L;
        volatile UINT16 CSF_COEFF_0_1H;
        volatile UINT16 CSF_COEFF_2_3L;
        volatile UINT16 CSF_COEFF_2_3H;
        volatile UINT16 CSF_COEFF_4_5L;
        volatile UINT16 CSF_COEFF_4_5H;
        volatile UINT16 CSF_COEFF_6_7L;
        volatile UINT16 CSF_COEFF_6_7H;
        volatile UINT16 CSF_COEFF_8_9L;
        volatile UINT16 CSF_COEFF_8_9H;
        volatile UINT16 CSF_COEFF_10_11L;
        volatile UINT16 CSF_COEFF_10_11H;
        volatile UINT16 CSF_COEFF_12_13L;
        volatile UINT16 CSF_COEFF_12_13H;
        volatile UINT16 CSF_COEFF_14_15L;
        volatile UINT16 CSF_COEFF_14_15H;
        volatile UINT16 CSF_COEFF_16_17L;
        volatile UINT16 CSF_COEFF_16_17H;
        volatile UINT16 CSF_COEFF_18_19L;
        volatile UINT16 CSF_COEFF_18_19H;
        volatile UINT16 CSF_COEFF_20_21L;
        volatile UINT16 CSF_COEFF_20_21H;
        volatile UINT16 CSF_COEFF_22_23L;
        volatile UINT16 CSF_COEFF_22_23H;
        volatile UINT16 CSF_COEFF_24_25L;
        volatile UINT16 CSF_COEFF_24_25H;
        volatile UINT16 CSF_COEFF_26_27L;
        volatile UINT16 CSF_COEFF_26_27H;
        volatile UINT16 CSF_COEFF_28_29L;
        volatile UINT16 CSF_COEFF_28_29H;
        volatile UINT16 CSF_COEFF_30_31L;
        volatile UINT16 CSF_COEFF_30_31H;
        volatile UINT16 DTX_ACWL;
        volatile UINT16 DTX_ACWH;
        volatile UINT16 DTX_CONFIGL;
        volatile UINT16 DTX_CONFIGH;
        volatile UINT16 DTX_SEL_CONTL;
        volatile UINT16 DTX_SEL_CONTH;
        volatile UINT16 DTX_USER_WORDL;
        volatile UINT16 DTX_USER_WORDH;
        volatile UINT16 DTX_PPA_DLYL;
        volatile UINT16 DTX_PPA_DLYH;
        volatile UINT16 DTX_PPA_STEPL;
        volatile UINT16 DTX_PPA_STEPH;
        volatile UINT16 DTX_SINE_CTLL;
        volatile UINT16 DTX_SINE_CTLH;
        volatile UINT16 MEM_031CL;
        volatile UINT16 MEM_031CH;
        volatile UINT16 MEM_0320L;
        volatile UINT16 MEM_0320H;
        volatile UINT16 MEM_0324L;
        volatile UINT16 MEM_0324H;
        volatile UINT16 MEM_0328L;
        volatile UINT16 MEM_0328H;
        volatile UINT16 MEM_032CL;
        volatile UINT16 MEM_032CH;
        volatile UINT16 MEM_0330L;
        volatile UINT16 MEM_0330H;
        volatile UINT16 MEM_0334L;
        volatile UINT16 MEM_0334H;
        volatile UINT16 MEM_0338L;
        volatile UINT16 MEM_0338H;
        volatile UINT16 MEM_033CL;
        volatile UINT16 MEM_033CH;
        volatile UINT16 MEM_0340L;
        volatile UINT16 MEM_0340H;
        volatile UINT16 MEM_0344L;
        volatile UINT16 MEM_0344H;
        volatile UINT16 MEM_0348L;
        volatile UINT16 MEM_0348H;
        volatile UINT16 MEM_034CL;
        volatile UINT16 MEM_034CH;
        volatile UINT16 MEM_0350L;
        volatile UINT16 MEM_0350H;
        volatile UINT16 MEM_0354L;
        volatile UINT16 MEM_0354H;
        volatile UINT16 MEM_0358L;
        volatile UINT16 MEM_0358H;
        volatile UINT16 MEM_035CL;
        volatile UINT16 MEM_035CH;
        volatile UINT16 MEM_0360L;
        volatile UINT16 MEM_0360H;
        volatile UINT16 MEM_0364L;
        volatile UINT16 MEM_0364H;
        volatile UINT16 MEM_0368L;
        volatile UINT16 MEM_0368H;
        volatile UINT16 MEM_036CL;
        volatile UINT16 MEM_036CH;
        volatile UINT16 MEM_0370L;
        volatile UINT16 MEM_0370H;
        volatile UINT16 MEM_0374L;
        volatile UINT16 MEM_0374H;
        volatile UINT16 MEM_0378L;
        volatile UINT16 MEM_0378H;
        volatile UINT16 MEM_037CL;
        volatile UINT16 MEM_037CH;
        volatile UINT16 MEM_0380L;
        volatile UINT16 MEM_0380H;
        volatile UINT16 MEM_0384L;
        volatile UINT16 MEM_0384H;
        volatile UINT16 MEM_0388L;
        volatile UINT16 MEM_0388H;
        volatile UINT16 MEM_038CL;
        volatile UINT16 MEM_038CH;
        volatile UINT16 MEM_0390L;
        volatile UINT16 MEM_0390H;
        volatile UINT16 MEM_0394L;
        volatile UINT16 MEM_0394H;
        volatile UINT16 MEM_0398L;
        volatile UINT16 MEM_0398H;
        volatile UINT16 MEM_039CL;
        volatile UINT16 MEM_039CH;
        volatile UINT16 MEM_03A0L;
        volatile UINT16 MEM_03A0H;
        volatile UINT16 MEM_03A4L;
        volatile UINT16 MEM_03A4H;
        volatile UINT16 MEM_03A8L;
        volatile UINT16 MEM_03A8H;
        volatile UINT16 MEM_03ACL;
        volatile UINT16 MEM_03ACH;
        volatile UINT16 MEM_03B0L;
        volatile UINT16 MEM_03B0H;
        volatile UINT16 MEM_03B4L;
        volatile UINT16 MEM_03B4H;
        volatile UINT16 MEM_03B8L;
        volatile UINT16 MEM_03B8H;
        volatile UINT16 MEM_03BCL;
        volatile UINT16 MEM_03BCH;
        volatile UINT16 MEM_03C0L;
        volatile UINT16 MEM_03C0H;
        volatile UINT16 MEM_03C4L;
        volatile UINT16 MEM_03C4H;
        volatile UINT16 MEM_03C8L;
        volatile UINT16 MEM_03C8H;
        volatile UINT16 MEM_03CCL;
        volatile UINT16 MEM_03CCH;
        volatile UINT16 MEM_03D0L;
        volatile UINT16 MEM_03D0H;
        volatile UINT16 MEM_03D4L;
        volatile UINT16 MEM_03D4H;
        volatile UINT16 MEM_03D8L;
        volatile UINT16 MEM_03D8H;
        volatile UINT16 MEM_03DCL;
        volatile UINT16 MEM_03DCH;
        volatile UINT16 MEM_03E0L;
        volatile UINT16 MEM_03E0H;
        volatile UINT16 MEM_03E4L;
        volatile UINT16 MEM_03E4H;
        volatile UINT16 MEM_03E8L;
        volatile UINT16 MEM_03E8H;
        volatile UINT16 MEM_03ECL;
        volatile UINT16 MEM_03ECH;
        volatile UINT16 MEM_03F0L;
        volatile UINT16 MEM_03F0H;
        volatile UINT16 MEM_03F4L;
        volatile UINT16 MEM_03F4H;
        volatile UINT16 MEM_03F8L;
        volatile UINT16 MEM_03F8H;
        volatile UINT16 MEM_03FCL;
        volatile UINT16 MEM_03FCH;
        volatile UINT16 CKM_WDL;
        volatile UINT16 CKM_WDH;
        volatile UINT16 CKM_WD_STATL;
        volatile UINT16 CKM_WD_STATH;
        volatile UINT16 CKM_TSTCLKL;
        volatile UINT16 CKM_TSTCLKH;
        volatile UINT16 CKM_OCPCLKL;
        volatile UINT16 CKM_OCPCLKH;
        volatile UINT16 CKM_CLOCKSL;
        volatile UINT16 CKM_CLOCKSH;
        volatile UINT16 CKM_CKDISPL;
        volatile UINT16 CKM_CKDISPH;
        volatile UINT16 CKM_PPAL;
        volatile UINT16 CKM_PPAH;
        volatile UINT16 MEM_041CL;
        volatile UINT16 MEM_041CH;
        volatile UINT16 MEM_0420L;
        volatile UINT16 MEM_0420H;
        volatile UINT16 MEM_0424L;
        volatile UINT16 MEM_0424H;
        volatile UINT16 MEM_0428L;
        volatile UINT16 MEM_0428H;
        volatile UINT16 MEM_042CL;
        volatile UINT16 MEM_042CH;
        volatile UINT16 MEM_0430L;
        volatile UINT16 MEM_0430H;
        volatile UINT16 MEM_0434L;
        volatile UINT16 MEM_0434H;
        volatile UINT16 MEM_0438L;
        volatile UINT16 MEM_0438H;
        volatile UINT16 MEM_043CL;
        volatile UINT16 MEM_043CH;
        volatile UINT16 DCXO_XTALL;
        volatile UINT16 DCXO_XTALH;
        volatile UINT16 MEM_0444L;
        volatile UINT16 MEM_0444H;
        volatile UINT16 MEM_0448L;
        volatile UINT16 MEM_0448H;
        volatile UINT16 MEM_044CL;
        volatile UINT16 MEM_044CH;
        volatile UINT16 DCXO_LDOXL;
        volatile UINT16 DCXO_LDOXH;
        volatile UINT16 DCXO_ENL;
        volatile UINT16 DCXO_ENH;
        volatile UINT16 DCXO_QC_OFFL;
        volatile UINT16 DCXO_QC_OFFH;
        volatile UINT16 DCXO_CKENL;
        volatile UINT16 DCXO_CKENH;
        volatile UINT16 MEM_0460L;
        volatile UINT16 MEM_0460H;
        volatile UINT16 MEM_0464L;
        volatile UINT16 MEM_0464H;
        volatile UINT16 MEM_0468L;
        volatile UINT16 MEM_0468H;
        volatile UINT16 MEM_046CL;
        volatile UINT16 MEM_046CH;
        volatile UINT16 MEM_0470L;
        volatile UINT16 MEM_0470H;
        volatile UINT16 MEM_0474L;
        volatile UINT16 MEM_0474H;
        volatile UINT16 MEM_0478L;
        volatile UINT16 MEM_0478H;
        volatile UINT16 MEM_047CL;
        volatile UINT16 MEM_047CH;
        volatile UINT16 DCXO_IDACL;
        volatile UINT16 DCXO_IDACH;
        volatile UINT16 DCXO_TIMEL;
        volatile UINT16 DCXO_TIMEH;
        volatile UINT16 DCXO_THRESHL;
        volatile UINT16 DCXO_THRESHH;
        volatile UINT16 MEM_048CL;
        volatile UINT16 MEM_048CH;
        volatile UINT16 DCXO_CKADCL;
        volatile UINT16 DCXO_CKADCH;
        volatile UINT16 MEM_0494L;
        volatile UINT16 MEM_0494H;
        volatile UINT16 MEM_0498L;
        volatile UINT16 MEM_0498H;
        volatile UINT16 MEM_049CL;
        volatile UINT16 MEM_049CH;
        volatile UINT16 RDCXO_IDACL;
        volatile UINT16 RDCXO_IDACH;
        volatile UINT16 RDCXO_ADCL;
        volatile UINT16 RDCXO_ADCH;
        volatile UINT16 MEM_04A8L;
        volatile UINT16 MEM_04A8H;
        volatile UINT16 MEM_04ACL;
        volatile UINT16 MEM_04ACH;
        volatile UINT16 MEM_04B0L;
        volatile UINT16 MEM_04B0H;
        volatile UINT16 MEM_04B4L;
        volatile UINT16 MEM_04B4H;
        volatile UINT16 MEM_04B8L;
        volatile UINT16 MEM_04B8H;
        volatile UINT16 MEM_04BCL;
        volatile UINT16 MEM_04BCH;
        volatile UINT16 MEM_04C0L;
        volatile UINT16 MEM_04C0H;
        volatile UINT16 MEM_04C4L;
        volatile UINT16 MEM_04C4H;
        volatile UINT16 MEM_04C8L;
        volatile UINT16 MEM_04C8H;
        volatile UINT16 MEM_04CCL;
        volatile UINT16 MEM_04CCH;
        volatile UINT16 MEM_04D0L;
        volatile UINT16 MEM_04D0H;
        volatile UINT16 MEM_04D4L;
        volatile UINT16 MEM_04D4H;
        volatile UINT16 MEM_04D8L;
        volatile UINT16 MEM_04D8H;
        volatile UINT16 MEM_04DCL;
        volatile UINT16 MEM_04DCH;
        volatile UINT16 MEM_04E0L;
        volatile UINT16 MEM_04E0H;
        volatile UINT16 MEM_04E4L;
        volatile UINT16 MEM_04E4H;
        volatile UINT16 MEM_04E8L;
        volatile UINT16 MEM_04E8H;
        volatile UINT16 MEM_04ECL;
        volatile UINT16 MEM_04ECH;
        volatile UINT16 MEM_04F0L;
        volatile UINT16 MEM_04F0H;
        volatile UINT16 MEM_04F4L;
        volatile UINT16 MEM_04F4H;
        volatile UINT16 MEM_04F8L;
        volatile UINT16 MEM_04F8H;
        volatile UINT16 MEM_04FCL;
        volatile UINT16 MEM_04FCH;
        volatile UINT16 SCRIPT_STARTL;
        volatile UINT16 SCRIPT_STARTH;
        volatile UINT16 SCRIPT_STATUSL;
        volatile UINT16 SCRIPT_STATUSH;
        volatile UINT16 SCRIPT_PTR_0L;
        volatile UINT16 SCRIPT_PTR_0H;
        volatile UINT16 SCRIPT_PTR_1L;
        volatile UINT16 SCRIPT_PTR_1H;
        volatile UINT16 SCRIPT_PTR_2L;
        volatile UINT16 SCRIPT_PTR_2H;
        volatile UINT16 SCRIPT_PTR_3L;
        volatile UINT16 SCRIPT_PTR_3H;
        volatile UINT16 SCRIPT_PTR_4L;
        volatile UINT16 SCRIPT_PTR_4H;
        volatile UINT16 SCRIPT_PTR_5L;
        volatile UINT16 SCRIPT_PTR_5H;
        volatile UINT16 SCRIPT_PTR_6L;
        volatile UINT16 SCRIPT_PTR_6H;
        volatile UINT16 SCRIPT_PTR_7L;
        volatile UINT16 SCRIPT_PTR_7H;
        volatile UINT16 SCRIPT_PTR_8L;
        volatile UINT16 SCRIPT_PTR_8H;
        volatile UINT16 SCRIPT_PTR_9L;
        volatile UINT16 SCRIPT_PTR_9H;
        volatile UINT16 SCRIPT_PTR_10L;
        volatile UINT16 SCRIPT_PTR_10H;
        volatile UINT16 SCRIPT_PTR_11L;
        volatile UINT16 SCRIPT_PTR_11H;
        volatile UINT16 SCRIPT_PTR_12L;
        volatile UINT16 SCRIPT_PTR_12H;
        volatile UINT16 SCRIPT_PTR_13L;
        volatile UINT16 SCRIPT_PTR_13H;
        volatile UINT16 SCRIPT_PTR_14L;
        volatile UINT16 SCRIPT_PTR_14H;
        volatile UINT16 SCRIPT_PTR_15L;
        volatile UINT16 SCRIPT_PTR_15H;
        volatile UINT16 SCR_CKTIM_FREQL;
        volatile UINT16 SCR_CKTIM_FREQH;
        volatile UINT16 SCR_DEBUGL;
        volatile UINT16 SCR_DEBUGH;
        volatile UINT16 SCR_SLAVE_HALTL;
        volatile UINT16 SCR_SLAVE_HALTH;
        volatile UINT16 SCR_HW_BRKPTL;
        volatile UINT16 SCR_HW_BRKPTH;
        volatile UINT16 SCR_CALC_CWL;
        volatile UINT16 SCR_CALC_CWH;
        volatile UINT16 SCR_CALC_SWL;
        volatile UINT16 SCR_CALC_SWH;
        volatile UINT16 MEM_0560L;
        volatile UINT16 MEM_0560H;
        volatile UINT16 MEM_0564L;
        volatile UINT16 MEM_0564H;
        volatile UINT16 MEM_0568L;
        volatile UINT16 MEM_0568H;
        volatile UINT16 MEM_056CL;
        volatile UINT16 MEM_056CH;
        volatile UINT16 MEM_0570L;
        volatile UINT16 MEM_0570H;
        volatile UINT16 MEM_0574L;
        volatile UINT16 MEM_0574H;
        volatile UINT16 MEM_0578L;
        volatile UINT16 MEM_0578H;
        volatile UINT16 MEM_057CL;
        volatile UINT16 MEM_057CH;
        volatile UINT16 SCR_PCL;
        volatile UINT16 SCR_PCH;
        volatile UINT16 SCR_PC1L;
        volatile UINT16 SCR_PC1H;
        volatile UINT16 SCR_IRL;
        volatile UINT16 SCR_IRH;
        volatile UINT16 SCR_R0L;
        volatile UINT16 SCR_R0H;
        volatile UINT16 MEM_0590L;
        volatile UINT16 MEM_0590H;
        volatile UINT16 MEM_0594L;
        volatile UINT16 MEM_0594H;
        volatile UINT16 MEM_0598L;
        volatile UINT16 MEM_0598H;
        volatile UINT16 MEM_059CL;
        volatile UINT16 MEM_059CH;
        volatile UINT16 MEM_05A0L;
        volatile UINT16 MEM_05A0H;
        volatile UINT16 MEM_05A4L;
        volatile UINT16 MEM_05A4H;
        volatile UINT16 MEM_05A8L;
        volatile UINT16 MEM_05A8H;
        volatile UINT16 MEM_05ACL;
        volatile UINT16 MEM_05ACH;
        volatile UINT16 MEM_05B0L;
        volatile UINT16 MEM_05B0H;
        volatile UINT16 MEM_05B4L;
        volatile UINT16 MEM_05B4H;
        volatile UINT16 MEM_05B8L;
        volatile UINT16 MEM_05B8H;
        volatile UINT16 MEM_05BCL;
        volatile UINT16 MEM_05BCH;
        volatile UINT16 MEM_05C0L;
        volatile UINT16 MEM_05C0H;
        volatile UINT16 MEM_05C4L;
        volatile UINT16 MEM_05C4H;
        volatile UINT16 MEM_05C8L;
        volatile UINT16 MEM_05C8H;
        volatile UINT16 MEM_05CCL;
        volatile UINT16 MEM_05CCH;
        volatile UINT16 MEM_05D0L;
        volatile UINT16 MEM_05D0H;
        volatile UINT16 MEM_05D4L;
        volatile UINT16 MEM_05D4H;
        volatile UINT16 MEM_05D8L;
        volatile UINT16 MEM_05D8H;
        volatile UINT16 MEM_05DCL;
        volatile UINT16 MEM_05DCH;
        volatile UINT16 MEM_05E0L;
        volatile UINT16 MEM_05E0H;
        volatile UINT16 MEM_05E4L;
        volatile UINT16 MEM_05E4H;
        volatile UINT16 MEM_05E8L;
        volatile UINT16 MEM_05E8H;
        volatile UINT16 MEM_05ECL;
        volatile UINT16 MEM_05ECH;
        volatile UINT16 MEM_05F0L;
        volatile UINT16 MEM_05F0H;
        volatile UINT16 MEM_05F4L;
        volatile UINT16 MEM_05F4H;
        volatile UINT16 MEM_05F8L;
        volatile UINT16 MEM_05F8H;
        volatile UINT16 MEM_05FCL;
        volatile UINT16 MEM_05FCH;
        volatile UINT16 MEM_0600L;
        volatile UINT16 MEM_0600H;
        volatile UINT16 MEM_0604L;
        volatile UINT16 MEM_0604H;
        volatile UINT16 MEM_0608L;
        volatile UINT16 MEM_0608H;
        volatile UINT16 MEM_060CL;
        volatile UINT16 MEM_060CH;
        volatile UINT16 MEM_0610L;
        volatile UINT16 MEM_0610H;
        volatile UINT16 MEM_0614L;
        volatile UINT16 MEM_0614H;
        volatile UINT16 MEM_0618L;
        volatile UINT16 MEM_0618H;
        volatile UINT16 MEM_061CL;
        volatile UINT16 MEM_061CH;
        volatile UINT16 MEM_0620L;
        volatile UINT16 MEM_0620H;
        volatile UINT16 MEM_0624L;
        volatile UINT16 MEM_0624H;
        volatile UINT16 MEM_0628L;
        volatile UINT16 MEM_0628H;
        volatile UINT16 MEM_062CL;
        volatile UINT16 MEM_062CH;
        volatile UINT16 MEM_0630L;
        volatile UINT16 MEM_0630H;
        volatile UINT16 MEM_0634L;
        volatile UINT16 MEM_0634H;
        volatile UINT16 MEM_0638L;
        volatile UINT16 MEM_0638H;
        volatile UINT16 MEM_063CL;
        volatile UINT16 MEM_063CH;
        volatile UINT16 MEM_0640L;
        volatile UINT16 MEM_0640H;
        volatile UINT16 MEM_0644L;
        volatile UINT16 MEM_0644H;
        volatile UINT16 MEM_0648L;
        volatile UINT16 MEM_0648H;
        volatile UINT16 MEM_064CL;
        volatile UINT16 MEM_064CH;
        volatile UINT16 MEM_0650L;
        volatile UINT16 MEM_0650H;
        volatile UINT16 MEM_0654L;
        volatile UINT16 MEM_0654H;
        volatile UINT16 MEM_0658L;
        volatile UINT16 MEM_0658H;
        volatile UINT16 MEM_065CL;
        volatile UINT16 MEM_065CH;
        volatile UINT16 MEM_0660L;
        volatile UINT16 MEM_0660H;
        volatile UINT16 MEM_0664L;
        volatile UINT16 MEM_0664H;
        volatile UINT16 MEM_0668L;
        volatile UINT16 MEM_0668H;
        volatile UINT16 MEM_066CL;
        volatile UINT16 MEM_066CH;
        volatile UINT16 MEM_0670L;
        volatile UINT16 MEM_0670H;
        volatile UINT16 MEM_0674L;
        volatile UINT16 MEM_0674H;
        volatile UINT16 MEM_0678L;
        volatile UINT16 MEM_0678H;
        volatile UINT16 MEM_067CL;
        volatile UINT16 MEM_067CH;
        volatile UINT16 MEM_0680L;
        volatile UINT16 MEM_0680H;
        volatile UINT16 MEM_0684L;
        volatile UINT16 MEM_0684H;
        volatile UINT16 MEM_0688L;
        volatile UINT16 MEM_0688H;
        volatile UINT16 MEM_068CL;
        volatile UINT16 MEM_068CH;
        volatile UINT16 MEM_0690L;
        volatile UINT16 MEM_0690H;
        volatile UINT16 MEM_0694L;
        volatile UINT16 MEM_0694H;
        volatile UINT16 MEM_0698L;
        volatile UINT16 MEM_0698H;
        volatile UINT16 MEM_069CL;
        volatile UINT16 MEM_069CH;
        volatile UINT16 MEM_06A0L;
        volatile UINT16 MEM_06A0H;
        volatile UINT16 MEM_06A4L;
        volatile UINT16 MEM_06A4H;
        volatile UINT16 MEM_06A8L;
        volatile UINT16 MEM_06A8H;
        volatile UINT16 MEM_06ACL;
        volatile UINT16 MEM_06ACH;
        volatile UINT16 MEM_06B0L;
        volatile UINT16 MEM_06B0H;
        volatile UINT16 MEM_06B4L;
        volatile UINT16 MEM_06B4H;
        volatile UINT16 MEM_06B8L;
        volatile UINT16 MEM_06B8H;
        volatile UINT16 MEM_06BCL;
        volatile UINT16 MEM_06BCH;
        volatile UINT16 MEM_06C0L;
        volatile UINT16 MEM_06C0H;
        volatile UINT16 MEM_06C4L;
        volatile UINT16 MEM_06C4H;
        volatile UINT16 MEM_06C8L;
        volatile UINT16 MEM_06C8H;
        volatile UINT16 MEM_06CCL;
        volatile UINT16 MEM_06CCH;
        volatile UINT16 MEM_06D0L;
        volatile UINT16 MEM_06D0H;
        volatile UINT16 MEM_06D4L;
        volatile UINT16 MEM_06D4H;
        volatile UINT16 MEM_06D8L;
        volatile UINT16 MEM_06D8H;
        volatile UINT16 MEM_06DCL;
        volatile UINT16 MEM_06DCH;
        volatile UINT16 MEM_06E0L;
        volatile UINT16 MEM_06E0H;
        volatile UINT16 MEM_06E4L;
        volatile UINT16 MEM_06E4H;
        volatile UINT16 MEM_06E8L;
        volatile UINT16 MEM_06E8H;
        volatile UINT16 MEM_06ECL;
        volatile UINT16 MEM_06ECH;
        volatile UINT16 MEM_06F0L;
        volatile UINT16 MEM_06F0H;
        volatile UINT16 MEM_06F4L;
        volatile UINT16 MEM_06F4H;
        volatile UINT16 MEM_06F8L;
        volatile UINT16 MEM_06F8H;
        volatile UINT16 MEM_06FCL;
        volatile UINT16 MEM_06FCH;
        volatile UINT16 MEM_0700L;
        volatile UINT16 MEM_0700H;
        volatile UINT16 MEM_0704L;
        volatile UINT16 MEM_0704H;
        volatile UINT16 MEM_0708L;
        volatile UINT16 MEM_0708H;
        volatile UINT16 MEM_070CL;
        volatile UINT16 MEM_070CH;
        volatile UINT16 MEM_0710L;
        volatile UINT16 MEM_0710H;
        volatile UINT16 MEM_0714L;
        volatile UINT16 MEM_0714H;
        volatile UINT16 MEM_0718L;
        volatile UINT16 MEM_0718H;
        volatile UINT16 MEM_071CL;
        volatile UINT16 MEM_071CH;
        volatile UINT16 MEM_0720L;
        volatile UINT16 MEM_0720H;
        volatile UINT16 MEM_0724L;
        volatile UINT16 MEM_0724H;
        volatile UINT16 MEM_0728L;
        volatile UINT16 MEM_0728H;
        volatile UINT16 MEM_072CL;
        volatile UINT16 MEM_072CH;
        volatile UINT16 MEM_0730L;
        volatile UINT16 MEM_0730H;
        volatile UINT16 MEM_0734L;
        volatile UINT16 MEM_0734H;
        volatile UINT16 MEM_0738L;
        volatile UINT16 MEM_0738H;
        volatile UINT16 MEM_073CL;
        volatile UINT16 MEM_073CH;
        volatile UINT16 MEM_0740L;
        volatile UINT16 MEM_0740H;
        volatile UINT16 MEM_0744L;
        volatile UINT16 MEM_0744H;
        volatile UINT16 MEM_0748L;
        volatile UINT16 MEM_0748H;
        volatile UINT16 MEM_074CL;
        volatile UINT16 MEM_074CH;
        volatile UINT16 MEM_0750L;
        volatile UINT16 MEM_0750H;
        volatile UINT16 MEM_0754L;
        volatile UINT16 MEM_0754H;
        volatile UINT16 MEM_0758L;
        volatile UINT16 MEM_0758H;
        volatile UINT16 MEM_075CL;
        volatile UINT16 MEM_075CH;
        volatile UINT16 MEM_0760L;
        volatile UINT16 MEM_0760H;
        volatile UINT16 MEM_0764L;
        volatile UINT16 MEM_0764H;
        volatile UINT16 MEM_0768L;
        volatile UINT16 MEM_0768H;
        volatile UINT16 MEM_076CL;
        volatile UINT16 MEM_076CH;
        volatile UINT16 MEM_0770L;
        volatile UINT16 MEM_0770H;
        volatile UINT16 MEM_0774L;
        volatile UINT16 MEM_0774H;
        volatile UINT16 MEM_0778L;
        volatile UINT16 MEM_0778H;
        volatile UINT16 MEM_077CL;
        volatile UINT16 MEM_077CH;
        volatile UINT16 MEM_0780L;
        volatile UINT16 MEM_0780H;
        volatile UINT16 MEM_0784L;
        volatile UINT16 MEM_0784H;
        volatile UINT16 MEM_0788L;
        volatile UINT16 MEM_0788H;
        volatile UINT16 MEM_078CL;
        volatile UINT16 MEM_078CH;
        volatile UINT16 MEM_0790L;
        volatile UINT16 MEM_0790H;
        volatile UINT16 MEM_0794L;
        volatile UINT16 MEM_0794H;
        volatile UINT16 MEM_0798L;
        volatile UINT16 MEM_0798H;
        volatile UINT16 MEM_079CL;
        volatile UINT16 MEM_079CH;
        volatile UINT16 MEM_07A0L;
        volatile UINT16 MEM_07A0H;
        volatile UINT16 MEM_07A4L;
        volatile UINT16 MEM_07A4H;
        volatile UINT16 MEM_07A8L;
        volatile UINT16 MEM_07A8H;
        volatile UINT16 MEM_07ACL;
        volatile UINT16 MEM_07ACH;
        volatile UINT16 MEM_07B0L;
        volatile UINT16 MEM_07B0H;
        volatile UINT16 MEM_07B4L;
        volatile UINT16 MEM_07B4H;
        volatile UINT16 MEM_07B8L;
        volatile UINT16 MEM_07B8H;
        volatile UINT16 MEM_07BCL;
        volatile UINT16 MEM_07BCH;
        volatile UINT16 MEM_07C0L;
        volatile UINT16 MEM_07C0H;
        volatile UINT16 MEM_07C4L;
        volatile UINT16 MEM_07C4H;
        volatile UINT16 MEM_07C8L;
        volatile UINT16 MEM_07C8H;
        volatile UINT16 MEM_07CCL;
        volatile UINT16 MEM_07CCH;
        volatile UINT16 MEM_07D0L;
        volatile UINT16 MEM_07D0H;
        volatile UINT16 MEM_07D4L;
        volatile UINT16 MEM_07D4H;
        volatile UINT16 MEM_07D8L;
        volatile UINT16 MEM_07D8H;
        volatile UINT16 MEM_07DCL;
        volatile UINT16 MEM_07DCH;
        volatile UINT16 MEM_07E0L;
        volatile UINT16 MEM_07E0H;
        volatile UINT16 MEM_07E4L;
        volatile UINT16 MEM_07E4H;
        volatile UINT16 MEM_07E8L;
        volatile UINT16 MEM_07E8H;
        volatile UINT16 MEM_07ECL;
        volatile UINT16 MEM_07ECH;
        volatile UINT16 MEM_07F0L;
        volatile UINT16 MEM_07F0H;
        volatile UINT16 MEM_07F4L;
        volatile UINT16 MEM_07F4H;
        volatile UINT16 MEM_07F8L;
        volatile UINT16 MEM_07F8H;
        volatile UINT16 MEM_07FCL;
        volatile UINT16 MEM_07FCH;
        volatile UINT16 MEM_0800L;
        volatile UINT16 MEM_0800H;
        volatile UINT16 MEM_0804L;
        volatile UINT16 MEM_0804H;
        volatile UINT16 MEM_0808L;
        volatile UINT16 MEM_0808H;
        volatile UINT16 MEM_080CL;
        volatile UINT16 MEM_080CH;
        volatile UINT16 MEM_0810L;
        volatile UINT16 MEM_0810H;
        volatile UINT16 MEM_0814L;
        volatile UINT16 MEM_0814H;
        volatile UINT16 MEM_0818L;
        volatile UINT16 MEM_0818H;
        volatile UINT16 MEM_081CL;
        volatile UINT16 MEM_081CH;
        volatile UINT16 MEM_0820L;
        volatile UINT16 MEM_0820H;
        volatile UINT16 MEM_0824L;
        volatile UINT16 MEM_0824H;
        volatile UINT16 MEM_0828L;
        volatile UINT16 MEM_0828H;
        volatile UINT16 MEM_082CL;
        volatile UINT16 MEM_082CH;
        volatile UINT16 MEM_0830L;
        volatile UINT16 MEM_0830H;
        volatile UINT16 MEM_0834L;
        volatile UINT16 MEM_0834H;
        volatile UINT16 MEM_0838L;
        volatile UINT16 MEM_0838H;
        volatile UINT16 MEM_083CL;
        volatile UINT16 MEM_083CH;
        volatile UINT16 MEM_0840L;
        volatile UINT16 MEM_0840H;
        volatile UINT16 MEM_0844L;
        volatile UINT16 MEM_0844H;
        volatile UINT16 MEM_0848L;
        volatile UINT16 MEM_0848H;
        volatile UINT16 MEM_084CL;
        volatile UINT16 MEM_084CH;
        volatile UINT16 MEM_0850L;
        volatile UINT16 MEM_0850H;
        volatile UINT16 MEM_0854L;
        volatile UINT16 MEM_0854H;
        volatile UINT16 MEM_0858L;
        volatile UINT16 MEM_0858H;
        volatile UINT16 MEM_085CL;
        volatile UINT16 MEM_085CH;
        volatile UINT16 MEM_0860L;
        volatile UINT16 MEM_0860H;
        volatile UINT16 MEM_0864L;
        volatile UINT16 MEM_0864H;
        volatile UINT16 MEM_0868L;
        volatile UINT16 MEM_0868H;
        volatile UINT16 MEM_086CL;
        volatile UINT16 MEM_086CH;
        volatile UINT16 MEM_0870L;
        volatile UINT16 MEM_0870H;
        volatile UINT16 MEM_0874L;
        volatile UINT16 MEM_0874H;
        volatile UINT16 MEM_0878L;
        volatile UINT16 MEM_0878H;
        volatile UINT16 MEM_087CL;
        volatile UINT16 MEM_087CH;
        volatile UINT16 MEM_0880L;
        volatile UINT16 MEM_0880H;
        volatile UINT16 MEM_0884L;
        volatile UINT16 MEM_0884H;
        volatile UINT16 MEM_0888L;
        volatile UINT16 MEM_0888H;
        volatile UINT16 MEM_088CL;
        volatile UINT16 MEM_088CH;
        volatile UINT16 MEM_0890L;
        volatile UINT16 MEM_0890H;
        volatile UINT16 MEM_0894L;
        volatile UINT16 MEM_0894H;
        volatile UINT16 MEM_0898L;
        volatile UINT16 MEM_0898H;
        volatile UINT16 MEM_089CL;
        volatile UINT16 MEM_089CH;
        volatile UINT16 MEM_08A0L;
        volatile UINT16 MEM_08A0H;
        volatile UINT16 MEM_08A4L;
        volatile UINT16 MEM_08A4H;
        volatile UINT16 MEM_08A8L;
        volatile UINT16 MEM_08A8H;
        volatile UINT16 MEM_08ACL;
        volatile UINT16 MEM_08ACH;
        volatile UINT16 MEM_08B0L;
        volatile UINT16 MEM_08B0H;
        volatile UINT16 MEM_08B4L;
        volatile UINT16 MEM_08B4H;
        volatile UINT16 MEM_08B8L;
        volatile UINT16 MEM_08B8H;
        volatile UINT16 MEM_08BCL;
        volatile UINT16 MEM_08BCH;
        volatile UINT16 MEM_08C0L;
        volatile UINT16 MEM_08C0H;
        volatile UINT16 MEM_08C4L;
        volatile UINT16 MEM_08C4H;
        volatile UINT16 MEM_08C8L;
        volatile UINT16 MEM_08C8H;
        volatile UINT16 MEM_08CCL;
        volatile UINT16 MEM_08CCH;
        volatile UINT16 MEM_08D0L;
        volatile UINT16 MEM_08D0H;
        volatile UINT16 MEM_08D4L;
        volatile UINT16 MEM_08D4H;
        volatile UINT16 MEM_08D8L;
        volatile UINT16 MEM_08D8H;
        volatile UINT16 MEM_08DCL;
        volatile UINT16 MEM_08DCH;
        volatile UINT16 MEM_08E0L;
        volatile UINT16 MEM_08E0H;
        volatile UINT16 MEM_08E4L;
        volatile UINT16 MEM_08E4H;
        volatile UINT16 MEM_08E8L;
        volatile UINT16 MEM_08E8H;
        volatile UINT16 MEM_08ECL;
        volatile UINT16 MEM_08ECH;
        volatile UINT16 MEM_08F0L;
        volatile UINT16 MEM_08F0H;
        volatile UINT16 MEM_08F4L;
        volatile UINT16 MEM_08F4H;
        volatile UINT16 MEM_08F8L;
        volatile UINT16 MEM_08F8H;
        volatile UINT16 MEM_08FCL;
        volatile UINT16 MEM_08FCH;
        volatile UINT16 DTST_MUX_SELL;
        volatile UINT16 DTST_MUX_SELH;
        volatile UINT16 DTST_OEZL;
        volatile UINT16 DTST_OEZH;
        volatile UINT16 DTST_DMUX_CONSTL;
        volatile UINT16 DTST_DMUX_CONSTH;
        volatile UINT16 DTST_DRX_DECIMATIONL;
        volatile UINT16 DTST_DRX_DECIMATIONH;
        volatile UINT16 MEM_0910L;
        volatile UINT16 MEM_0910H;
        volatile UINT16 MEM_0914L;
        volatile UINT16 MEM_0914H;
        volatile UINT16 MEM_0918L;
        volatile UINT16 MEM_0918H;
        volatile UINT16 MEM_091CL;
        volatile UINT16 MEM_091CH;
        volatile UINT16 MEM_0920L;
        volatile UINT16 MEM_0920H;
        volatile UINT16 MEM_0924L;
        volatile UINT16 MEM_0924H;
        volatile UINT16 MEM_0928L;
        volatile UINT16 MEM_0928H;
        volatile UINT16 MEM_092CL;
        volatile UINT16 MEM_092CH;
        volatile UINT16 MEM_0930L;
        volatile UINT16 MEM_0930H;
        volatile UINT16 MEM_0934L;
        volatile UINT16 MEM_0934H;
        volatile UINT16 MEM_0938L;
        volatile UINT16 MEM_0938H;
        volatile UINT16 MEM_093CL;
        volatile UINT16 MEM_093CH;
        volatile UINT16 MEM_0940L;
        volatile UINT16 MEM_0940H;
        volatile UINT16 MEM_0944L;
        volatile UINT16 MEM_0944H;
        volatile UINT16 MEM_0948L;
        volatile UINT16 MEM_0948H;
        volatile UINT16 MEM_094CL;
        volatile UINT16 MEM_094CH;
        volatile UINT16 MEM_0950L;
        volatile UINT16 MEM_0950H;
        volatile UINT16 MEM_0954L;
        volatile UINT16 MEM_0954H;
        volatile UINT16 MEM_0958L;
        volatile UINT16 MEM_0958H;
        volatile UINT16 MEM_095CL;
        volatile UINT16 MEM_095CH;
        volatile UINT16 MEM_0960L;
        volatile UINT16 MEM_0960H;
        volatile UINT16 MEM_0964L;
        volatile UINT16 MEM_0964H;
        volatile UINT16 MEM_0968L;
        volatile UINT16 MEM_0968H;
        volatile UINT16 MEM_096CL;
        volatile UINT16 MEM_096CH;
        volatile UINT16 MEM_0970L;
        volatile UINT16 MEM_0970H;
        volatile UINT16 MEM_0974L;
        volatile UINT16 MEM_0974H;
        volatile UINT16 MEM_0978L;
        volatile UINT16 MEM_0978H;
        volatile UINT16 MEM_097CL;
        volatile UINT16 MEM_097CH;
        volatile UINT16 MEM_0980L;
        volatile UINT16 MEM_0980H;
        volatile UINT16 MEM_0984L;
        volatile UINT16 MEM_0984H;
        volatile UINT16 MEM_0988L;
        volatile UINT16 MEM_0988H;
        volatile UINT16 MEM_098CL;
        volatile UINT16 MEM_098CH;
        volatile UINT16 MEM_0990L;
        volatile UINT16 MEM_0990H;
        volatile UINT16 MEM_0994L;
        volatile UINT16 MEM_0994H;
        volatile UINT16 MEM_0998L;
        volatile UINT16 MEM_0998H;
        volatile UINT16 MEM_099CL;
        volatile UINT16 MEM_099CH;
        volatile UINT16 MEM_09A0L;
        volatile UINT16 MEM_09A0H;
        volatile UINT16 MEM_09A4L;
        volatile UINT16 MEM_09A4H;
        volatile UINT16 MEM_09A8L;
        volatile UINT16 MEM_09A8H;
        volatile UINT16 MEM_09ACL;
        volatile UINT16 MEM_09ACH;
        volatile UINT16 MEM_09B0L;
        volatile UINT16 MEM_09B0H;
        volatile UINT16 MEM_09B4L;
        volatile UINT16 MEM_09B4H;
        volatile UINT16 MEM_09B8L;
        volatile UINT16 MEM_09B8H;
        volatile UINT16 MEM_09BCL;
        volatile UINT16 MEM_09BCH;
        volatile UINT16 MEM_09C0L;
        volatile UINT16 MEM_09C0H;
        volatile UINT16 MEM_09C4L;
        volatile UINT16 MEM_09C4H;
        volatile UINT16 MEM_09C8L;
        volatile UINT16 MEM_09C8H;
        volatile UINT16 MEM_09CCL;
        volatile UINT16 MEM_09CCH;
        volatile UINT16 MEM_09D0L;
        volatile UINT16 MEM_09D0H;
        volatile UINT16 MEM_09D4L;
        volatile UINT16 MEM_09D4H;
        volatile UINT16 MEM_09D8L;
        volatile UINT16 MEM_09D8H;
        volatile UINT16 MEM_09DCL;
        volatile UINT16 MEM_09DCH;
        volatile UINT16 MEM_09E0L;
        volatile UINT16 MEM_09E0H;
        volatile UINT16 MEM_09E4L;
        volatile UINT16 MEM_09E4H;
        volatile UINT16 MEM_09E8L;
        volatile UINT16 MEM_09E8H;
        volatile UINT16 MEM_09ECL;
        volatile UINT16 MEM_09ECH;
        volatile UINT16 MEM_09F0L;
        volatile UINT16 MEM_09F0H;
        volatile UINT16 MEM_09F4L;
        volatile UINT16 MEM_09F4H;
        volatile UINT16 MEM_09F8L;
        volatile UINT16 MEM_09F8H;
        volatile UINT16 MEM_09FCL;
        volatile UINT16 MEM_09FCH;
        volatile UINT16 MEM_0A00L;
        volatile UINT16 MEM_0A00H;
        volatile UINT16 MEM_0A04L;
        volatile UINT16 MEM_0A04H;
        volatile UINT16 MEM_0A08L;
        volatile UINT16 MEM_0A08H;
        volatile UINT16 MEM_0A0CL;
        volatile UINT16 MEM_0A0CH;
        volatile UINT16 MEM_0A10L;
        volatile UINT16 MEM_0A10H;
        volatile UINT16 MEM_0A14L;
        volatile UINT16 MEM_0A14H;
        volatile UINT16 MEM_0A18L;
        volatile UINT16 MEM_0A18H;
        volatile UINT16 MEM_0A1CL;
        volatile UINT16 MEM_0A1CH;
        volatile UINT16 MEM_0A20L;
        volatile UINT16 MEM_0A20H;
        volatile UINT16 MEM_0A24L;
        volatile UINT16 MEM_0A24H;
        volatile UINT16 MEM_0A28L;
        volatile UINT16 MEM_0A28H;
        volatile UINT16 MEM_0A2CL;
        volatile UINT16 MEM_0A2CH;
        volatile UINT16 MEM_0A30L;
        volatile UINT16 MEM_0A30H;
        volatile UINT16 MEM_0A34L;
        volatile UINT16 MEM_0A34H;
        volatile UINT16 MEM_0A38L;
        volatile UINT16 MEM_0A38H;
        volatile UINT16 MEM_0A3CL;
        volatile UINT16 MEM_0A3CH;
        volatile UINT16 MEM_0A40L;
        volatile UINT16 MEM_0A40H;
        volatile UINT16 MEM_0A44L;
        volatile UINT16 MEM_0A44H;
        volatile UINT16 MEM_0A48L;
        volatile UINT16 MEM_0A48H;
        volatile UINT16 MEM_0A4CL;
        volatile UINT16 MEM_0A4CH;
        volatile UINT16 MEM_0A50L;
        volatile UINT16 MEM_0A50H;
        volatile UINT16 MEM_0A54L;
        volatile UINT16 MEM_0A54H;
        volatile UINT16 MEM_0A58L;
        volatile UINT16 MEM_0A58H;
        volatile UINT16 MEM_0A5CL;
        volatile UINT16 MEM_0A5CH;
        volatile UINT16 MEM_0A60L;
        volatile UINT16 MEM_0A60H;
        volatile UINT16 MEM_0A64L;
        volatile UINT16 MEM_0A64H;
        volatile UINT16 MEM_0A68L;
        volatile UINT16 MEM_0A68H;
        volatile UINT16 MEM_0A6CL;
        volatile UINT16 MEM_0A6CH;
        volatile UINT16 MEM_0A70L;
        volatile UINT16 MEM_0A70H;
        volatile UINT16 MEM_0A74L;
        volatile UINT16 MEM_0A74H;
        volatile UINT16 MEM_0A78L;
        volatile UINT16 MEM_0A78H;
        volatile UINT16 MEM_0A7CL;
        volatile UINT16 MEM_0A7CH;
        volatile UINT16 MEM_0A80L;
        volatile UINT16 MEM_0A80H;
        volatile UINT16 MEM_0A84L;
        volatile UINT16 MEM_0A84H;
        volatile UINT16 MEM_0A88L;
        volatile UINT16 MEM_0A88H;
        volatile UINT16 MEM_0A8CL;
        volatile UINT16 MEM_0A8CH;
        volatile UINT16 MEM_0A90L;
        volatile UINT16 MEM_0A90H;
        volatile UINT16 MEM_0A94L;
        volatile UINT16 MEM_0A94H;
        volatile UINT16 MEM_0A98L;
        volatile UINT16 MEM_0A98H;
        volatile UINT16 MEM_0A9CL;
        volatile UINT16 MEM_0A9CH;
        volatile UINT16 MEM_0AA0L;
        volatile UINT16 MEM_0AA0H;
        volatile UINT16 MEM_0AA4L;
        volatile UINT16 MEM_0AA4H;
        volatile UINT16 MEM_0AA8L;
        volatile UINT16 MEM_0AA8H;
        volatile UINT16 MEM_0AACL;
        volatile UINT16 MEM_0AACH;
        volatile UINT16 MEM_0AB0L;
        volatile UINT16 MEM_0AB0H;
        volatile UINT16 MEM_0AB4L;
        volatile UINT16 MEM_0AB4H;
        volatile UINT16 MEM_0AB8L;
        volatile UINT16 MEM_0AB8H;
        volatile UINT16 MEM_0ABCL;
        volatile UINT16 MEM_0ABCH;
        volatile UINT16 MEM_0AC0L;
        volatile UINT16 MEM_0AC0H;
        volatile UINT16 MEM_0AC4L;
        volatile UINT16 MEM_0AC4H;
        volatile UINT16 MEM_0AC8L;
        volatile UINT16 MEM_0AC8H;
        volatile UINT16 MEM_0ACCL;
        volatile UINT16 MEM_0ACCH;
        volatile UINT16 MEM_0AD0L;
        volatile UINT16 MEM_0AD0H;
        volatile UINT16 MEM_0AD4L;
        volatile UINT16 MEM_0AD4H;
        volatile UINT16 MEM_0AD8L;
        volatile UINT16 MEM_0AD8H;
        volatile UINT16 MEM_0ADCL;
        volatile UINT16 MEM_0ADCH;
        volatile UINT16 MEM_0AE0L;
        volatile UINT16 MEM_0AE0H;
        volatile UINT16 MEM_0AE4L;
        volatile UINT16 MEM_0AE4H;
        volatile UINT16 MEM_0AE8L;
        volatile UINT16 MEM_0AE8H;
        volatile UINT16 MEM_0AECL;
        volatile UINT16 MEM_0AECH;
        volatile UINT16 MEM_0AF0L;
        volatile UINT16 MEM_0AF0H;
        volatile UINT16 MEM_0AF4L;
        volatile UINT16 MEM_0AF4H;
        volatile UINT16 MEM_0AF8L;
        volatile UINT16 MEM_0AF8H;
        volatile UINT16 MEM_0AFCL;
        volatile UINT16 MEM_0AFCH;
        volatile UINT16 MEM_0B00L;
        volatile UINT16 MEM_0B00H;
        volatile UINT16 MEM_0B04L;
        volatile UINT16 MEM_0B04H;
        volatile UINT16 MEM_0B08L;
        volatile UINT16 MEM_0B08H;
        volatile UINT16 MEM_0B0CL;
        volatile UINT16 MEM_0B0CH;
        volatile UINT16 MEM_0B10L;
        volatile UINT16 MEM_0B10H;
        volatile UINT16 MEM_0B14L;
        volatile UINT16 MEM_0B14H;
        volatile UINT16 MEM_0B18L;
        volatile UINT16 MEM_0B18H;
        volatile UINT16 MEM_0B1CL;
        volatile UINT16 MEM_0B1CH;
        volatile UINT16 MEM_0B20L;
        volatile UINT16 MEM_0B20H;
        volatile UINT16 MEM_0B24L;
        volatile UINT16 MEM_0B24H;
        volatile UINT16 MEM_0B28L;
        volatile UINT16 MEM_0B28H;
        volatile UINT16 MEM_0B2CL;
        volatile UINT16 MEM_0B2CH;
        volatile UINT16 MEM_0B30L;
        volatile UINT16 MEM_0B30H;
        volatile UINT16 MEM_0B34L;
        volatile UINT16 MEM_0B34H;
        volatile UINT16 MEM_0B38L;
        volatile UINT16 MEM_0B38H;
        volatile UINT16 MEM_0B3CL;
        volatile UINT16 MEM_0B3CH;
        volatile UINT16 MEM_0B40L;
        volatile UINT16 MEM_0B40H;
        volatile UINT16 MEM_0B44L;
        volatile UINT16 MEM_0B44H;
        volatile UINT16 MEM_0B48L;
        volatile UINT16 MEM_0B48H;
        volatile UINT16 MEM_0B4CL;
        volatile UINT16 MEM_0B4CH;
        volatile UINT16 MEM_0B50L;
        volatile UINT16 MEM_0B50H;
        volatile UINT16 MEM_0B54L;
        volatile UINT16 MEM_0B54H;
        volatile UINT16 MEM_0B58L;
        volatile UINT16 MEM_0B58H;
        volatile UINT16 MEM_0B5CL;
        volatile UINT16 MEM_0B5CH;
        volatile UINT16 MEM_0B60L;
        volatile UINT16 MEM_0B60H;
        volatile UINT16 MEM_0B64L;
        volatile UINT16 MEM_0B64H;
        volatile UINT16 MEM_0B68L;
        volatile UINT16 MEM_0B68H;
        volatile UINT16 MEM_0B6CL;
        volatile UINT16 MEM_0B6CH;
        volatile UINT16 MEM_0B70L;
        volatile UINT16 MEM_0B70H;
        volatile UINT16 MEM_0B74L;
        volatile UINT16 MEM_0B74H;
        volatile UINT16 MEM_0B78L;
        volatile UINT16 MEM_0B78H;
        volatile UINT16 MEM_0B7CL;
        volatile UINT16 MEM_0B7CH;
        volatile UINT16 MEM_0B80L;
        volatile UINT16 MEM_0B80H;
        volatile UINT16 MEM_0B84L;
        volatile UINT16 MEM_0B84H;
        volatile UINT16 MEM_0B88L;
        volatile UINT16 MEM_0B88H;
        volatile UINT16 MEM_0B8CL;
        volatile UINT16 MEM_0B8CH;
        volatile UINT16 MEM_0B90L;
        volatile UINT16 MEM_0B90H;
        volatile UINT16 MEM_0B94L;
        volatile UINT16 MEM_0B94H;
        volatile UINT16 MEM_0B98L;
        volatile UINT16 MEM_0B98H;
        volatile UINT16 MEM_0B9CL;
        volatile UINT16 MEM_0B9CH;
        volatile UINT16 MEM_0BA0L;
        volatile UINT16 MEM_0BA0H;
        volatile UINT16 MEM_0BA4L;
        volatile UINT16 MEM_0BA4H;
        volatile UINT16 MEM_0BA8L;
        volatile UINT16 MEM_0BA8H;
        volatile UINT16 MEM_0BACL;
        volatile UINT16 MEM_0BACH;
        volatile UINT16 MEM_0BB0L;
        volatile UINT16 MEM_0BB0H;
        volatile UINT16 MEM_0BB4L;
        volatile UINT16 MEM_0BB4H;
        volatile UINT16 MEM_0BB8L;
        volatile UINT16 MEM_0BB8H;
        volatile UINT16 MEM_0BBCL;
        volatile UINT16 MEM_0BBCH;
        volatile UINT16 MEM_0BC0L;
        volatile UINT16 MEM_0BC0H;
        volatile UINT16 MEM_0BC4L;
        volatile UINT16 MEM_0BC4H;
        volatile UINT16 MEM_0BC8L;
        volatile UINT16 MEM_0BC8H;
        volatile UINT16 MEM_0BCCL;
        volatile UINT16 MEM_0BCCH;
        volatile UINT16 MEM_0BD0L;
        volatile UINT16 MEM_0BD0H;
        volatile UINT16 MEM_0BD4L;
        volatile UINT16 MEM_0BD4H;
        volatile UINT16 MEM_0BD8L;
        volatile UINT16 MEM_0BD8H;
        volatile UINT16 MEM_0BDCL;
        volatile UINT16 MEM_0BDCH;
        volatile UINT16 MEM_0BE0L;
        volatile UINT16 MEM_0BE0H;
        volatile UINT16 MEM_0BE4L;
        volatile UINT16 MEM_0BE4H;
        volatile UINT16 MEM_0BE8L;
        volatile UINT16 MEM_0BE8H;
        volatile UINT16 MEM_0BECL;
        volatile UINT16 MEM_0BECH;
        volatile UINT16 MEM_0BF0L;
        volatile UINT16 MEM_0BF0H;
        volatile UINT16 MEM_0BF4L;
        volatile UINT16 MEM_0BF4H;
        volatile UINT16 MEM_0BF8L;
        volatile UINT16 MEM_0BF8H;
        volatile UINT16 MEM_0BFCL;
        volatile UINT16 MEM_0BFCH;
        volatile UINT16 MEM_0C00L;
        volatile UINT16 MEM_0C00H;
        volatile UINT16 MEM_0C04L;
        volatile UINT16 MEM_0C04H;
        volatile UINT16 MEM_0C08L;
        volatile UINT16 MEM_0C08H;
        volatile UINT16 MEM_0C0CL;
        volatile UINT16 MEM_0C0CH;
        volatile UINT16 MEM_0C10L;
        volatile UINT16 MEM_0C10H;
        volatile UINT16 MEM_0C14L;
        volatile UINT16 MEM_0C14H;
        volatile UINT16 MEM_0C18L;
        volatile UINT16 MEM_0C18H;
        volatile UINT16 MEM_0C1CL;
        volatile UINT16 MEM_0C1CH;
        volatile UINT16 MEM_0C20L;
        volatile UINT16 MEM_0C20H;
        volatile UINT16 MEM_0C24L;
        volatile UINT16 MEM_0C24H;
        volatile UINT16 MEM_0C28L;
        volatile UINT16 MEM_0C28H;
        volatile UINT16 MEM_0C2CL;
        volatile UINT16 MEM_0C2CH;
        volatile UINT16 MEM_0C30L;
        volatile UINT16 MEM_0C30H;
        volatile UINT16 MEM_0C34L;
        volatile UINT16 MEM_0C34H;
        volatile UINT16 MEM_0C38L;
        volatile UINT16 MEM_0C38H;
        volatile UINT16 MEM_0C3CL;
        volatile UINT16 MEM_0C3CH;
        volatile UINT16 MEM_0C40L;
        volatile UINT16 MEM_0C40H;
        volatile UINT16 MEM_0C44L;
        volatile UINT16 MEM_0C44H;
        volatile UINT16 MEM_0C48L;
        volatile UINT16 MEM_0C48H;
        volatile UINT16 MEM_0C4CL;
        volatile UINT16 MEM_0C4CH;
        volatile UINT16 MEM_0C50L;
        volatile UINT16 MEM_0C50H;
        volatile UINT16 MEM_0C54L;
        volatile UINT16 MEM_0C54H;
        volatile UINT16 MEM_0C58L;
        volatile UINT16 MEM_0C58H;
        volatile UINT16 MEM_0C5CL;
        volatile UINT16 MEM_0C5CH;
        volatile UINT16 MEM_0C60L;
        volatile UINT16 MEM_0C60H;
        volatile UINT16 MEM_0C64L;
        volatile UINT16 MEM_0C64H;
        volatile UINT16 MEM_0C68L;
        volatile UINT16 MEM_0C68H;
        volatile UINT16 MEM_0C6CL;
        volatile UINT16 MEM_0C6CH;
        volatile UINT16 MEM_0C70L;
        volatile UINT16 MEM_0C70H;
        volatile UINT16 MEM_0C74L;
        volatile UINT16 MEM_0C74H;
        volatile UINT16 MEM_0C78L;
        volatile UINT16 MEM_0C78H;
        volatile UINT16 MEM_0C7CL;
        volatile UINT16 MEM_0C7CH;
        volatile UINT16 MEM_0C80L;
        volatile UINT16 MEM_0C80H;
        volatile UINT16 MEM_0C84L;
        volatile UINT16 MEM_0C84H;
        volatile UINT16 MEM_0C88L;
        volatile UINT16 MEM_0C88H;
        volatile UINT16 MEM_0C8CL;
        volatile UINT16 MEM_0C8CH;
        volatile UINT16 MEM_0C90L;
        volatile UINT16 MEM_0C90H;
        volatile UINT16 MEM_0C94L;
        volatile UINT16 MEM_0C94H;
        volatile UINT16 MEM_0C98L;
        volatile UINT16 MEM_0C98H;
        volatile UINT16 MEM_0C9CL;
        volatile UINT16 MEM_0C9CH;
        volatile UINT16 MEM_0CA0L;
        volatile UINT16 MEM_0CA0H;
        volatile UINT16 MEM_0CA4L;
        volatile UINT16 MEM_0CA4H;
        volatile UINT16 MEM_0CA8L;
        volatile UINT16 MEM_0CA8H;
        volatile UINT16 MEM_0CACL;
        volatile UINT16 MEM_0CACH;
        volatile UINT16 MEM_0CB0L;
        volatile UINT16 MEM_0CB0H;
        volatile UINT16 MEM_0CB4L;
        volatile UINT16 MEM_0CB4H;
        volatile UINT16 MEM_0CB8L;
        volatile UINT16 MEM_0CB8H;
        volatile UINT16 MEM_0CBCL;
        volatile UINT16 MEM_0CBCH;
        volatile UINT16 MEM_0CC0L;
        volatile UINT16 MEM_0CC0H;
        volatile UINT16 MEM_0CC4L;
        volatile UINT16 MEM_0CC4H;
        volatile UINT16 MEM_0CC8L;
        volatile UINT16 MEM_0CC8H;
        volatile UINT16 MEM_0CCCL;
        volatile UINT16 MEM_0CCCH;
        volatile UINT16 MEM_0CD0L;
        volatile UINT16 MEM_0CD0H;
        volatile UINT16 MEM_0CD4L;
        volatile UINT16 MEM_0CD4H;
        volatile UINT16 MEM_0CD8L;
        volatile UINT16 MEM_0CD8H;
        volatile UINT16 MEM_0CDCL;
        volatile UINT16 MEM_0CDCH;
        volatile UINT16 MEM_0CE0L;
        volatile UINT16 MEM_0CE0H;
        volatile UINT16 MEM_0CE4L;
        volatile UINT16 MEM_0CE4H;
        volatile UINT16 MEM_0CE8L;
        volatile UINT16 MEM_0CE8H;
        volatile UINT16 MEM_0CECL;
        volatile UINT16 MEM_0CECH;
        volatile UINT16 MEM_0CF0L;
        volatile UINT16 MEM_0CF0H;
        volatile UINT16 MEM_0CF4L;
        volatile UINT16 MEM_0CF4H;
        volatile UINT16 MEM_0CF8L;
        volatile UINT16 MEM_0CF8H;
        volatile UINT16 MEM_0CFCL;
        volatile UINT16 MEM_0CFCH;
        volatile UINT16 MEM_0D00L;
        volatile UINT16 MEM_0D00H;
        volatile UINT16 MEM_0D04L;
        volatile UINT16 MEM_0D04H;
        volatile UINT16 MEM_0D08L;
        volatile UINT16 MEM_0D08H;
        volatile UINT16 MEM_0D0CL;
        volatile UINT16 MEM_0D0CH;
        volatile UINT16 MEM_0D10L;
        volatile UINT16 MEM_0D10H;
        volatile UINT16 MEM_0D14L;
        volatile UINT16 MEM_0D14H;
        volatile UINT16 MEM_0D18L;
        volatile UINT16 MEM_0D18H;
        volatile UINT16 MEM_0D1CL;
        volatile UINT16 MEM_0D1CH;
        volatile UINT16 MEM_0D20L;
        volatile UINT16 MEM_0D20H;
        volatile UINT16 MEM_0D24L;
        volatile UINT16 MEM_0D24H;
        volatile UINT16 MEM_0D28L;
        volatile UINT16 MEM_0D28H;
        volatile UINT16 MEM_0D2CL;
        volatile UINT16 MEM_0D2CH;
        volatile UINT16 MEM_0D30L;
        volatile UINT16 MEM_0D30H;
        volatile UINT16 MEM_0D34L;
        volatile UINT16 MEM_0D34H;
        volatile UINT16 MEM_0D38L;
        volatile UINT16 MEM_0D38H;
        volatile UINT16 MEM_0D3CL;
        volatile UINT16 MEM_0D3CH;
        volatile UINT16 MEM_0D40L;
        volatile UINT16 MEM_0D40H;
        volatile UINT16 MEM_0D44L;
        volatile UINT16 MEM_0D44H;
        volatile UINT16 MEM_0D48L;
        volatile UINT16 MEM_0D48H;
        volatile UINT16 MEM_0D4CL;
        volatile UINT16 MEM_0D4CH;
        volatile UINT16 MEM_0D50L;
        volatile UINT16 MEM_0D50H;
        volatile UINT16 MEM_0D54L;
        volatile UINT16 MEM_0D54H;
        volatile UINT16 MEM_0D58L;
        volatile UINT16 MEM_0D58H;
        volatile UINT16 MEM_0D5CL;
        volatile UINT16 MEM_0D5CH;
        volatile UINT16 MEM_0D60L;
        volatile UINT16 MEM_0D60H;
        volatile UINT16 MEM_0D64L;
        volatile UINT16 MEM_0D64H;
        volatile UINT16 MEM_0D68L;
        volatile UINT16 MEM_0D68H;
        volatile UINT16 MEM_0D6CL;
        volatile UINT16 MEM_0D6CH;
        volatile UINT16 MEM_0D70L;
        volatile UINT16 MEM_0D70H;
        volatile UINT16 MEM_0D74L;
        volatile UINT16 MEM_0D74H;
        volatile UINT16 MEM_0D78L;
        volatile UINT16 MEM_0D78H;
        volatile UINT16 MEM_0D7CL;
        volatile UINT16 MEM_0D7CH;
        volatile UINT16 MEM_0D80L;
        volatile UINT16 MEM_0D80H;
        volatile UINT16 MEM_0D84L;
        volatile UINT16 MEM_0D84H;
        volatile UINT16 MEM_0D88L;
        volatile UINT16 MEM_0D88H;
        volatile UINT16 MEM_0D8CL;
        volatile UINT16 MEM_0D8CH;
        volatile UINT16 MEM_0D90L;
        volatile UINT16 MEM_0D90H;
        volatile UINT16 MEM_0D94L;
        volatile UINT16 MEM_0D94H;
        volatile UINT16 MEM_0D98L;
        volatile UINT16 MEM_0D98H;
        volatile UINT16 MEM_0D9CL;
        volatile UINT16 MEM_0D9CH;
        volatile UINT16 MEM_0DA0L;
        volatile UINT16 MEM_0DA0H;
        volatile UINT16 MEM_0DA4L;
        volatile UINT16 MEM_0DA4H;
        volatile UINT16 MEM_0DA8L;
        volatile UINT16 MEM_0DA8H;
        volatile UINT16 MEM_0DACL;
        volatile UINT16 MEM_0DACH;
        volatile UINT16 MEM_0DB0L;
        volatile UINT16 MEM_0DB0H;
        volatile UINT16 MEM_0DB4L;
        volatile UINT16 MEM_0DB4H;
        volatile UINT16 MEM_0DB8L;
        volatile UINT16 MEM_0DB8H;
        volatile UINT16 MEM_0DBCL;
        volatile UINT16 MEM_0DBCH;
        volatile UINT16 MEM_0DC0L;
        volatile UINT16 MEM_0DC0H;
        volatile UINT16 MEM_0DC4L;
        volatile UINT16 MEM_0DC4H;
        volatile UINT16 MEM_0DC8L;
        volatile UINT16 MEM_0DC8H;
        volatile UINT16 MEM_0DCCL;
        volatile UINT16 MEM_0DCCH;
        volatile UINT16 MEM_0DD0L;
        volatile UINT16 MEM_0DD0H;
        volatile UINT16 MEM_0DD4L;
        volatile UINT16 MEM_0DD4H;
        volatile UINT16 MEM_0DD8L;
        volatile UINT16 MEM_0DD8H;
        volatile UINT16 MEM_0DDCL;
        volatile UINT16 MEM_0DDCH;
        volatile UINT16 MEM_0DE0L;
        volatile UINT16 MEM_0DE0H;
        volatile UINT16 MEM_0DE4L;
        volatile UINT16 MEM_0DE4H;
        volatile UINT16 MEM_0DE8L;
        volatile UINT16 MEM_0DE8H;
        volatile UINT16 MEM_0DECL;
        volatile UINT16 MEM_0DECH;
        volatile UINT16 MEM_0DF0L;
        volatile UINT16 MEM_0DF0H;
        volatile UINT16 MEM_0DF4L;
        volatile UINT16 MEM_0DF4H;
        volatile UINT16 MEM_0DF8L;
        volatile UINT16 MEM_0DF8H;
        volatile UINT16 MEM_0DFCL;
        volatile UINT16 MEM_0DFCH;
        volatile UINT16 MEM_0E00L;
        volatile UINT16 MEM_0E00H;
        volatile UINT16 MEM_0E04L;
        volatile UINT16 MEM_0E04H;
        volatile UINT16 MEM_0E08L;
        volatile UINT16 MEM_0E08H;
        volatile UINT16 MEM_0E0CL;
        volatile UINT16 MEM_0E0CH;
        volatile UINT16 MEM_0E10L;
        volatile UINT16 MEM_0E10H;
        volatile UINT16 MEM_0E14L;
        volatile UINT16 MEM_0E14H;
        volatile UINT16 MEM_0E18L;
        volatile UINT16 MEM_0E18H;
        volatile UINT16 MEM_0E1CL;
        volatile UINT16 MEM_0E1CH;
        volatile UINT16 MEM_0E20L;
        volatile UINT16 MEM_0E20H;
        volatile UINT16 MEM_0E24L;
        volatile UINT16 MEM_0E24H;
        volatile UINT16 MEM_0E28L;
        volatile UINT16 MEM_0E28H;
        volatile UINT16 MEM_0E2CL;
        volatile UINT16 MEM_0E2CH;
        volatile UINT16 MEM_0E30L;
        volatile UINT16 MEM_0E30H;
        volatile UINT16 MEM_0E34L;
        volatile UINT16 MEM_0E34H;
        volatile UINT16 MEM_0E38L;
        volatile UINT16 MEM_0E38H;
        volatile UINT16 MEM_0E3CL;
        volatile UINT16 MEM_0E3CH;
        volatile UINT16 MEM_0E40L;
        volatile UINT16 MEM_0E40H;
        volatile UINT16 MEM_0E44L;
        volatile UINT16 MEM_0E44H;
        volatile UINT16 MEM_0E48L;
        volatile UINT16 MEM_0E48H;
        volatile UINT16 MEM_0E4CL;
        volatile UINT16 MEM_0E4CH;
        volatile UINT16 MEM_0E50L;
        volatile UINT16 MEM_0E50H;
        volatile UINT16 MEM_0E54L;
        volatile UINT16 MEM_0E54H;
        volatile UINT16 MEM_0E58L;
        volatile UINT16 MEM_0E58H;
        volatile UINT16 MEM_0E5CL;
        volatile UINT16 MEM_0E5CH;
        volatile UINT16 MEM_0E60L;
        volatile UINT16 MEM_0E60H;
        volatile UINT16 MEM_0E64L;
        volatile UINT16 MEM_0E64H;
        volatile UINT16 MEM_0E68L;
        volatile UINT16 MEM_0E68H;
        volatile UINT16 MEM_0E6CL;
        volatile UINT16 MEM_0E6CH;
        volatile UINT16 MEM_0E70L;
        volatile UINT16 MEM_0E70H;
        volatile UINT16 MEM_0E74L;
        volatile UINT16 MEM_0E74H;
        volatile UINT16 MEM_0E78L;
        volatile UINT16 MEM_0E78H;
        volatile UINT16 MEM_0E7CL;
        volatile UINT16 MEM_0E7CH;
        volatile UINT16 MEM_0E80L;
        volatile UINT16 MEM_0E80H;
        volatile UINT16 MEM_0E84L;
        volatile UINT16 MEM_0E84H;
        volatile UINT16 MEM_0E88L;
        volatile UINT16 MEM_0E88H;
        volatile UINT16 MEM_0E8CL;
        volatile UINT16 MEM_0E8CH;
        volatile UINT16 MEM_0E90L;
        volatile UINT16 MEM_0E90H;
        volatile UINT16 MEM_0E94L;
        volatile UINT16 MEM_0E94H;
        volatile UINT16 MEM_0E98L;
        volatile UINT16 MEM_0E98H;
        volatile UINT16 MEM_0E9CL;
        volatile UINT16 MEM_0E9CH;
        volatile UINT16 MEM_0EA0L;
        volatile UINT16 MEM_0EA0H;
        volatile UINT16 MEM_0EA4L;
        volatile UINT16 MEM_0EA4H;
        volatile UINT16 MEM_0EA8L;
        volatile UINT16 MEM_0EA8H;
        volatile UINT16 MEM_0EACL;
        volatile UINT16 MEM_0EACH;
        volatile UINT16 MEM_0EB0L;
        volatile UINT16 MEM_0EB0H;
        volatile UINT16 MEM_0EB4L;
        volatile UINT16 MEM_0EB4H;
        volatile UINT16 MEM_0EB8L;
        volatile UINT16 MEM_0EB8H;
        volatile UINT16 MEM_0EBCL;
        volatile UINT16 MEM_0EBCH;
        volatile UINT16 MEM_0EC0L;
        volatile UINT16 MEM_0EC0H;
        volatile UINT16 MEM_0EC4L;
        volatile UINT16 MEM_0EC4H;
        volatile UINT16 MEM_0EC8L;
        volatile UINT16 MEM_0EC8H;
        volatile UINT16 MEM_0ECCL;
        volatile UINT16 MEM_0ECCH;
        volatile UINT16 MEM_0ED0L;
        volatile UINT16 MEM_0ED0H;
        volatile UINT16 MEM_0ED4L;
        volatile UINT16 MEM_0ED4H;
        volatile UINT16 MEM_0ED8L;
        volatile UINT16 MEM_0ED8H;
        volatile UINT16 MEM_0EDCL;
        volatile UINT16 MEM_0EDCH;
        volatile UINT16 MEM_0EE0L;
        volatile UINT16 MEM_0EE0H;
        volatile UINT16 MEM_0EE4L;
        volatile UINT16 MEM_0EE4H;
        volatile UINT16 MEM_0EE8L;
        volatile UINT16 MEM_0EE8H;
        volatile UINT16 MEM_0EECL;
        volatile UINT16 MEM_0EECH;
        volatile UINT16 MEM_0EF0L;
        volatile UINT16 MEM_0EF0H;
        volatile UINT16 MEM_0EF4L;
        volatile UINT16 MEM_0EF4H;
        volatile UINT16 MEM_0EF8L;
        volatile UINT16 MEM_0EF8H;
        volatile UINT16 MEM_0EFCL;
        volatile UINT16 MEM_0EFCH;
        volatile UINT16 MEM_0F00L;
        volatile UINT16 MEM_0F00H;
        volatile UINT16 MEM_0F04L;
        volatile UINT16 MEM_0F04H;
        volatile UINT16 MEM_0F08L;
        volatile UINT16 MEM_0F08H;
        volatile UINT16 MEM_0F0CL;
        volatile UINT16 MEM_0F0CH;
        volatile UINT16 MEM_0F10L;
        volatile UINT16 MEM_0F10H;
        volatile UINT16 MEM_0F14L;
        volatile UINT16 MEM_0F14H;
        volatile UINT16 MEM_0F18L;
        volatile UINT16 MEM_0F18H;
        volatile UINT16 MEM_0F1CL;
        volatile UINT16 MEM_0F1CH;
        volatile UINT16 MEM_0F20L;
        volatile UINT16 MEM_0F20H;
        volatile UINT16 MEM_0F24L;
        volatile UINT16 MEM_0F24H;
        volatile UINT16 MEM_0F28L;
        volatile UINT16 MEM_0F28H;
        volatile UINT16 MEM_0F2CL;
        volatile UINT16 MEM_0F2CH;
        volatile UINT16 MEM_0F30L;
        volatile UINT16 MEM_0F30H;
        volatile UINT16 MEM_0F34L;
        volatile UINT16 MEM_0F34H;
        volatile UINT16 MEM_0F38L;
        volatile UINT16 MEM_0F38H;
        volatile UINT16 MEM_0F3CL;
        volatile UINT16 MEM_0F3CH;
        volatile UINT16 MEM_0F40L;
        volatile UINT16 MEM_0F40H;
        volatile UINT16 MEM_0F44L;
        volatile UINT16 MEM_0F44H;
        volatile UINT16 MEM_0F48L;
        volatile UINT16 MEM_0F48H;
        volatile UINT16 MEM_0F4CL;
        volatile UINT16 MEM_0F4CH;
        volatile UINT16 MEM_0F50L;
        volatile UINT16 MEM_0F50H;
        volatile UINT16 MEM_0F54L;
        volatile UINT16 MEM_0F54H;
        volatile UINT16 MEM_0F58L;
        volatile UINT16 MEM_0F58H;
        volatile UINT16 MEM_0F5CL;
        volatile UINT16 MEM_0F5CH;
        volatile UINT16 MEM_0F60L;
        volatile UINT16 MEM_0F60H;
        volatile UINT16 MEM_0F64L;
        volatile UINT16 MEM_0F64H;
        volatile UINT16 MEM_0F68L;
        volatile UINT16 MEM_0F68H;
        volatile UINT16 MEM_0F6CL;
        volatile UINT16 MEM_0F6CH;
        volatile UINT16 MEM_0F70L;
        volatile UINT16 MEM_0F70H;
        volatile UINT16 MEM_0F74L;
        volatile UINT16 MEM_0F74H;
        volatile UINT16 MEM_0F78L;
        volatile UINT16 MEM_0F78H;
        volatile UINT16 MEM_0F7CL;
        volatile UINT16 MEM_0F7CH;
        volatile UINT16 MEM_0F80L;
        volatile UINT16 MEM_0F80H;
        volatile UINT16 MEM_0F84L;
        volatile UINT16 MEM_0F84H;
        volatile UINT16 MEM_0F88L;
        volatile UINT16 MEM_0F88H;
        volatile UINT16 MEM_0F8CL;
        volatile UINT16 MEM_0F8CH;
        volatile UINT16 MEM_0F90L;
        volatile UINT16 MEM_0F90H;
        volatile UINT16 MEM_0F94L;
        volatile UINT16 MEM_0F94H;
        volatile UINT16 MEM_0F98L;
        volatile UINT16 MEM_0F98H;
        volatile UINT16 MEM_0F9CL;
        volatile UINT16 MEM_0F9CH;
        volatile UINT16 MEM_0FA0L;
        volatile UINT16 MEM_0FA0H;
        volatile UINT16 MEM_0FA4L;
        volatile UINT16 MEM_0FA4H;
        volatile UINT16 MEM_0FA8L;
        volatile UINT16 MEM_0FA8H;
        volatile UINT16 MEM_0FACL;
        volatile UINT16 MEM_0FACH;
        volatile UINT16 MEM_0FB0L;
        volatile UINT16 MEM_0FB0H;
        volatile UINT16 MEM_0FB4L;
        volatile UINT16 MEM_0FB4H;
        volatile UINT16 MEM_0FB8L;
        volatile UINT16 MEM_0FB8H;
        volatile UINT16 MEM_0FBCL;
        volatile UINT16 MEM_0FBCH;
        volatile UINT16 MEM_0FC0L;
        volatile UINT16 MEM_0FC0H;
        volatile UINT16 MEM_0FC4L;
        volatile UINT16 MEM_0FC4H;
        volatile UINT16 MEM_0FC8L;
        volatile UINT16 MEM_0FC8H;
        volatile UINT16 MEM_0FCCL;
        volatile UINT16 MEM_0FCCH;
        volatile UINT16 MEM_0FD0L;
        volatile UINT16 MEM_0FD0H;
        volatile UINT16 MEM_0FD4L;
        volatile UINT16 MEM_0FD4H;
        volatile UINT16 MEM_0FD8L;
        volatile UINT16 MEM_0FD8H;
        volatile UINT16 MEM_0FDCL;
        volatile UINT16 MEM_0FDCH;
        volatile UINT16 MEM_0FE0L;
        volatile UINT16 MEM_0FE0H;
        volatile UINT16 MEM_0FE4L;
        volatile UINT16 MEM_0FE4H;
        volatile UINT16 MEM_0FE8L;
        volatile UINT16 MEM_0FE8H;
        volatile UINT16 MEM_0FECL;
        volatile UINT16 MEM_0FECH;
        volatile UINT16 MEM_0FF0L;
        volatile UINT16 MEM_0FF0H;
        volatile UINT16 MEM_0FF4L;
        volatile UINT16 MEM_0FF4H;
        volatile UINT16 MEM_0FF8L;
        volatile UINT16 MEM_0FF8H;
        volatile UINT16 MEM_0FFCL;
        volatile UINT16 MEM_0FFCH;
        volatile UINT16 MEM_1000L;
        volatile UINT16 MEM_1000H;
        volatile UINT16 MEM_1004L;
        volatile UINT16 MEM_1004H;
        volatile UINT16 MEM_1008L;
        volatile UINT16 MEM_1008H;
        volatile UINT16 MEM_100CL;
        volatile UINT16 MEM_100CH;
        volatile UINT16 MEM_1010L;
        volatile UINT16 MEM_1010H;
        volatile UINT16 MEM_1014L;
        volatile UINT16 MEM_1014H;
        volatile UINT16 MEM_1018L;
        volatile UINT16 MEM_1018H;
        volatile UINT16 MEM_101CL;
        volatile UINT16 MEM_101CH;
        volatile UINT16 MEM_1020L;
        volatile UINT16 MEM_1020H;
        volatile UINT16 MEM_1024L;
        volatile UINT16 MEM_1024H;
        volatile UINT16 MEM_1028L;
        volatile UINT16 MEM_1028H;
        volatile UINT16 MEM_102CL;
        volatile UINT16 MEM_102CH;
        volatile UINT16 MEM_1030L;
        volatile UINT16 MEM_1030H;
        volatile UINT16 MEM_1034L;
        volatile UINT16 MEM_1034H;
        volatile UINT16 MEM_1038L;
        volatile UINT16 MEM_1038H;
        volatile UINT16 MEM_103CL;
        volatile UINT16 MEM_103CH;
        volatile UINT16 MEM_1040L;
        volatile UINT16 MEM_1040H;
        volatile UINT16 MEM_1044L;
        volatile UINT16 MEM_1044H;
        volatile UINT16 MEM_1048L;
        volatile UINT16 MEM_1048H;
        volatile UINT16 MEM_104CL;
        volatile UINT16 MEM_104CH;
        volatile UINT16 MEM_1050L;
        volatile UINT16 MEM_1050H;
        volatile UINT16 MEM_1054L;
        volatile UINT16 MEM_1054H;
        volatile UINT16 MEM_1058L;
        volatile UINT16 MEM_1058H;
        volatile UINT16 MEM_105CL;
        volatile UINT16 MEM_105CH;
        volatile UINT16 MEM_1060L;
        volatile UINT16 MEM_1060H;
        volatile UINT16 MEM_1064L;
        volatile UINT16 MEM_1064H;
        volatile UINT16 MEM_1068L;
        volatile UINT16 MEM_1068H;
        volatile UINT16 MEM_106CL;
        volatile UINT16 MEM_106CH;
        volatile UINT16 MEM_1070L;
        volatile UINT16 MEM_1070H;
        volatile UINT16 MEM_1074L;
        volatile UINT16 MEM_1074H;
        volatile UINT16 MEM_1078L;
        volatile UINT16 MEM_1078H;
        volatile UINT16 MEM_107CL;
        volatile UINT16 MEM_107CH;
        volatile UINT16 MEM_1080L;
        volatile UINT16 MEM_1080H;
        volatile UINT16 MEM_1084L;
        volatile UINT16 MEM_1084H;
        volatile UINT16 MEM_1088L;
        volatile UINT16 MEM_1088H;
        volatile UINT16 MEM_108CL;
        volatile UINT16 MEM_108CH;
        volatile UINT16 MEM_1090L;
        volatile UINT16 MEM_1090H;
        volatile UINT16 MEM_1094L;
        volatile UINT16 MEM_1094H;
        volatile UINT16 MEM_1098L;
        volatile UINT16 MEM_1098H;
        volatile UINT16 MEM_109CL;
        volatile UINT16 MEM_109CH;
        volatile UINT16 MEM_10A0L;
        volatile UINT16 MEM_10A0H;
        volatile UINT16 MEM_10A4L;
        volatile UINT16 MEM_10A4H;
        volatile UINT16 MEM_10A8L;
        volatile UINT16 MEM_10A8H;
        volatile UINT16 MEM_10ACL;
        volatile UINT16 MEM_10ACH;
        volatile UINT16 MEM_10B0L;
        volatile UINT16 MEM_10B0H;
        volatile UINT16 MEM_10B4L;
        volatile UINT16 MEM_10B4H;
        volatile UINT16 MEM_10B8L;
        volatile UINT16 MEM_10B8H;
        volatile UINT16 MEM_10BCL;
        volatile UINT16 MEM_10BCH;
        volatile UINT16 MEM_10C0L;
        volatile UINT16 MEM_10C0H;
        volatile UINT16 MEM_10C4L;
        volatile UINT16 MEM_10C4H;
        volatile UINT16 MEM_10C8L;
        volatile UINT16 MEM_10C8H;
        volatile UINT16 MEM_10CCL;
        volatile UINT16 MEM_10CCH;
        volatile UINT16 MEM_10D0L;
        volatile UINT16 MEM_10D0H;
        volatile UINT16 MEM_10D4L;
        volatile UINT16 MEM_10D4H;
        volatile UINT16 MEM_10D8L;
        volatile UINT16 MEM_10D8H;
        volatile UINT16 MEM_10DCL;
        volatile UINT16 MEM_10DCH;
        volatile UINT16 MEM_10E0L;
        volatile UINT16 MEM_10E0H;
        volatile UINT16 MEM_10E4L;
        volatile UINT16 MEM_10E4H;
        volatile UINT16 MEM_10E8L;
        volatile UINT16 MEM_10E8H;
        volatile UINT16 MEM_10ECL;
        volatile UINT16 MEM_10ECH;
        volatile UINT16 MEM_10F0L;
        volatile UINT16 MEM_10F0H;
        volatile UINT16 MEM_10F4L;
        volatile UINT16 MEM_10F4H;
        volatile UINT16 MEM_10F8L;
        volatile UINT16 MEM_10F8H;
        volatile UINT16 MEM_10FCL;
        volatile UINT16 MEM_10FCH;
        volatile UINT16 MEM_1100L;
        volatile UINT16 MEM_1100H;
        volatile UINT16 MEM_1104L;
        volatile UINT16 MEM_1104H;
        volatile UINT16 MEM_1108L;
        volatile UINT16 MEM_1108H;
        volatile UINT16 MEM_110CL;
        volatile UINT16 MEM_110CH;
        volatile UINT16 MEM_1110L;
        volatile UINT16 MEM_1110H;
        volatile UINT16 MEM_1114L;
        volatile UINT16 MEM_1114H;
        volatile UINT16 MEM_1118L;
        volatile UINT16 MEM_1118H;
        volatile UINT16 MEM_111CL;
        volatile UINT16 MEM_111CH;
        volatile UINT16 MEM_1120L;
        volatile UINT16 MEM_1120H;
        volatile UINT16 MEM_1124L;
        volatile UINT16 MEM_1124H;
        volatile UINT16 MEM_1128L;
        volatile UINT16 MEM_1128H;
        volatile UINT16 MEM_112CL;
        volatile UINT16 MEM_112CH;
        volatile UINT16 MEM_1130L;
        volatile UINT16 MEM_1130H;
        volatile UINT16 MEM_1134L;
        volatile UINT16 MEM_1134H;
        volatile UINT16 MEM_1138L;
        volatile UINT16 MEM_1138H;
        volatile UINT16 MEM_113CL;
        volatile UINT16 MEM_113CH;
        volatile UINT16 MEM_1140L;
        volatile UINT16 MEM_1140H;
        volatile UINT16 MEM_1144L;
        volatile UINT16 MEM_1144H;
        volatile UINT16 MEM_1148L;
        volatile UINT16 MEM_1148H;
        volatile UINT16 MEM_114CL;
        volatile UINT16 MEM_114CH;
        volatile UINT16 MEM_1150L;
        volatile UINT16 MEM_1150H;
        volatile UINT16 MEM_1154L;
        volatile UINT16 MEM_1154H;
        volatile UINT16 MEM_1158L;
        volatile UINT16 MEM_1158H;
        volatile UINT16 MEM_115CL;
        volatile UINT16 MEM_115CH;
        volatile UINT16 MEM_1160L;
        volatile UINT16 MEM_1160H;
        volatile UINT16 MEM_1164L;
        volatile UINT16 MEM_1164H;
        volatile UINT16 MEM_1168L;
        volatile UINT16 MEM_1168H;
        volatile UINT16 MEM_116CL;
        volatile UINT16 MEM_116CH;
        volatile UINT16 MEM_1170L;
        volatile UINT16 MEM_1170H;
        volatile UINT16 MEM_1174L;
        volatile UINT16 MEM_1174H;
        volatile UINT16 MEM_1178L;
        volatile UINT16 MEM_1178H;
        volatile UINT16 MEM_117CL;
        volatile UINT16 MEM_117CH;
        volatile UINT16 MEM_1180L;
        volatile UINT16 MEM_1180H;
        volatile UINT16 MEM_1184L;
        volatile UINT16 MEM_1184H;
        volatile UINT16 MEM_1188L;
        volatile UINT16 MEM_1188H;
        volatile UINT16 MEM_118CL;
        volatile UINT16 MEM_118CH;
        volatile UINT16 MEM_1190L;
        volatile UINT16 MEM_1190H;
        volatile UINT16 MEM_1194L;
        volatile UINT16 MEM_1194H;
        volatile UINT16 MEM_1198L;
        volatile UINT16 MEM_1198H;
        volatile UINT16 MEM_119CL;
        volatile UINT16 MEM_119CH;
        volatile UINT16 MEM_11A0L;
        volatile UINT16 MEM_11A0H;
        volatile UINT16 MEM_11A4L;
        volatile UINT16 MEM_11A4H;
        volatile UINT16 MEM_11A8L;
        volatile UINT16 MEM_11A8H;
        volatile UINT16 MEM_11ACL;
        volatile UINT16 MEM_11ACH;
        volatile UINT16 MEM_11B0L;
        volatile UINT16 MEM_11B0H;
        volatile UINT16 MEM_11B4L;
        volatile UINT16 MEM_11B4H;
        volatile UINT16 MEM_11B8L;
        volatile UINT16 MEM_11B8H;
        volatile UINT16 MEM_11BCL;
        volatile UINT16 MEM_11BCH;
        volatile UINT16 MEM_11C0L;
        volatile UINT16 MEM_11C0H;
        volatile UINT16 MEM_11C4L;
        volatile UINT16 MEM_11C4H;
        volatile UINT16 MEM_11C8L;
        volatile UINT16 MEM_11C8H;
        volatile UINT16 MEM_11CCL;
        volatile UINT16 MEM_11CCH;
        volatile UINT16 MEM_11D0L;
        volatile UINT16 MEM_11D0H;
        volatile UINT16 MEM_11D4L;
        volatile UINT16 MEM_11D4H;
        volatile UINT16 MEM_11D8L;
        volatile UINT16 MEM_11D8H;
        volatile UINT16 MEM_11DCL;
        volatile UINT16 MEM_11DCH;
        volatile UINT16 MEM_11E0L;
        volatile UINT16 MEM_11E0H;
        volatile UINT16 MEM_11E4L;
        volatile UINT16 MEM_11E4H;
        volatile UINT16 MEM_11E8L;
        volatile UINT16 MEM_11E8H;
        volatile UINT16 MEM_11ECL;
        volatile UINT16 MEM_11ECH;
        volatile UINT16 MEM_11F0L;
        volatile UINT16 MEM_11F0H;
        volatile UINT16 MEM_11F4L;
        volatile UINT16 MEM_11F4H;
        volatile UINT16 MEM_11F8L;
        volatile UINT16 MEM_11F8H;
        volatile UINT16 MEM_11FCL;
        volatile UINT16 MEM_11FCH;
        volatile UINT16 MEM_1200L;
        volatile UINT16 MEM_1200H;
        volatile UINT16 MEM_1204L;
        volatile UINT16 MEM_1204H;
        volatile UINT16 MEM_1208L;
        volatile UINT16 MEM_1208H;
        volatile UINT16 MEM_120CL;
        volatile UINT16 MEM_120CH;
        volatile UINT16 MEM_1210L;
        volatile UINT16 MEM_1210H;
        volatile UINT16 MEM_1214L;
        volatile UINT16 MEM_1214H;
        volatile UINT16 MEM_1218L;
        volatile UINT16 MEM_1218H;
        volatile UINT16 MEM_121CL;
        volatile UINT16 MEM_121CH;
        volatile UINT16 MEM_1220L;
        volatile UINT16 MEM_1220H;
        volatile UINT16 MEM_1224L;
        volatile UINT16 MEM_1224H;
        volatile UINT16 MEM_1228L;
        volatile UINT16 MEM_1228H;
        volatile UINT16 MEM_122CL;
        volatile UINT16 MEM_122CH;
        volatile UINT16 MEM_1230L;
        volatile UINT16 MEM_1230H;
        volatile UINT16 MEM_1234L;
        volatile UINT16 MEM_1234H;
        volatile UINT16 MEM_1238L;
        volatile UINT16 MEM_1238H;
        volatile UINT16 MEM_123CL;
        volatile UINT16 MEM_123CH;
        volatile UINT16 MEM_1240L;
        volatile UINT16 MEM_1240H;
        volatile UINT16 MEM_1244L;
        volatile UINT16 MEM_1244H;
        volatile UINT16 MEM_1248L;
        volatile UINT16 MEM_1248H;
        volatile UINT16 MEM_124CL;
        volatile UINT16 MEM_124CH;
        volatile UINT16 MEM_1250L;
        volatile UINT16 MEM_1250H;
        volatile UINT16 MEM_1254L;
        volatile UINT16 MEM_1254H;
        volatile UINT16 MEM_1258L;
        volatile UINT16 MEM_1258H;
        volatile UINT16 MEM_125CL;
        volatile UINT16 MEM_125CH;
        volatile UINT16 MEM_1260L;
        volatile UINT16 MEM_1260H;
        volatile UINT16 MEM_1264L;
        volatile UINT16 MEM_1264H;
        volatile UINT16 MEM_1268L;
        volatile UINT16 MEM_1268H;
        volatile UINT16 MEM_126CL;
        volatile UINT16 MEM_126CH;
        volatile UINT16 MEM_1270L;
        volatile UINT16 MEM_1270H;
        volatile UINT16 MEM_1274L;
        volatile UINT16 MEM_1274H;
        volatile UINT16 MEM_1278L;
        volatile UINT16 MEM_1278H;
        volatile UINT16 MEM_127CL;
        volatile UINT16 MEM_127CH;
        volatile UINT16 MEM_1280L;
        volatile UINT16 MEM_1280H;
        volatile UINT16 MEM_1284L;
        volatile UINT16 MEM_1284H;
        volatile UINT16 MEM_1288L;
        volatile UINT16 MEM_1288H;
        volatile UINT16 MEM_128CL;
        volatile UINT16 MEM_128CH;
        volatile UINT16 MEM_1290L;
        volatile UINT16 MEM_1290H;
        volatile UINT16 MEM_1294L;
        volatile UINT16 MEM_1294H;
        volatile UINT16 MEM_1298L;
        volatile UINT16 MEM_1298H;
        volatile UINT16 MEM_129CL;
        volatile UINT16 MEM_129CH;
        volatile UINT16 MEM_12A0L;
        volatile UINT16 MEM_12A0H;
        volatile UINT16 MEM_12A4L;
        volatile UINT16 MEM_12A4H;
        volatile UINT16 MEM_12A8L;
        volatile UINT16 MEM_12A8H;
        volatile UINT16 MEM_12ACL;
        volatile UINT16 MEM_12ACH;
        volatile UINT16 MEM_12B0L;
        volatile UINT16 MEM_12B0H;
        volatile UINT16 MEM_12B4L;
        volatile UINT16 MEM_12B4H;
        volatile UINT16 MEM_12B8L;
        volatile UINT16 MEM_12B8H;
        volatile UINT16 MEM_12BCL;
        volatile UINT16 MEM_12BCH;
        volatile UINT16 MEM_12C0L;
        volatile UINT16 MEM_12C0H;
        volatile UINT16 MEM_12C4L;
        volatile UINT16 MEM_12C4H;
        volatile UINT16 MEM_12C8L;
        volatile UINT16 MEM_12C8H;
        volatile UINT16 MEM_12CCL;
        volatile UINT16 MEM_12CCH;
        volatile UINT16 MEM_12D0L;
        volatile UINT16 MEM_12D0H;
        volatile UINT16 MEM_12D4L;
        volatile UINT16 MEM_12D4H;
        volatile UINT16 MEM_12D8L;
        volatile UINT16 MEM_12D8H;
        volatile UINT16 MEM_12DCL;
        volatile UINT16 MEM_12DCH;
        volatile UINT16 MEM_12E0L;
        volatile UINT16 MEM_12E0H;
        volatile UINT16 MEM_12E4L;
        volatile UINT16 MEM_12E4H;
        volatile UINT16 MEM_12E8L;
        volatile UINT16 MEM_12E8H;
        volatile UINT16 MEM_12ECL;
        volatile UINT16 MEM_12ECH;
        volatile UINT16 MEM_12F0L;
        volatile UINT16 MEM_12F0H;
        volatile UINT16 MEM_12F4L;
        volatile UINT16 MEM_12F4H;
        volatile UINT16 MEM_12F8L;
        volatile UINT16 MEM_12F8H;
        volatile UINT16 MEM_12FCL;
        volatile UINT16 MEM_12FCH;
        volatile UINT16 MEM_1300L;
        volatile UINT16 MEM_1300H;
        volatile UINT16 MEM_1304L;
        volatile UINT16 MEM_1304H;
        volatile UINT16 MEM_1308L;
        volatile UINT16 MEM_1308H;
        volatile UINT16 MEM_130CL;
        volatile UINT16 MEM_130CH;
        volatile UINT16 MEM_1310L;
        volatile UINT16 MEM_1310H;
        volatile UINT16 MEM_1314L;
        volatile UINT16 MEM_1314H;
        volatile UINT16 MEM_1318L;
        volatile UINT16 MEM_1318H;
        volatile UINT16 MEM_131CL;
        volatile UINT16 MEM_131CH;
        volatile UINT16 MEM_1320L;
        volatile UINT16 MEM_1320H;
        volatile UINT16 MEM_1324L;
        volatile UINT16 MEM_1324H;
        volatile UINT16 MEM_1328L;
        volatile UINT16 MEM_1328H;
        volatile UINT16 MEM_132CL;
        volatile UINT16 MEM_132CH;
        volatile UINT16 MEM_1330L;
        volatile UINT16 MEM_1330H;
        volatile UINT16 MEM_1334L;
        volatile UINT16 MEM_1334H;
        volatile UINT16 MEM_1338L;
        volatile UINT16 MEM_1338H;
        volatile UINT16 MEM_133CL;
        volatile UINT16 MEM_133CH;
        volatile UINT16 MEM_1340L;
        volatile UINT16 MEM_1340H;
        volatile UINT16 MEM_1344L;
        volatile UINT16 MEM_1344H;
        volatile UINT16 MEM_1348L;
        volatile UINT16 MEM_1348H;
        volatile UINT16 MEM_134CL;
        volatile UINT16 MEM_134CH;
        volatile UINT16 MEM_1350L;
        volatile UINT16 MEM_1350H;
        volatile UINT16 MEM_1354L;
        volatile UINT16 MEM_1354H;
        volatile UINT16 MEM_1358L;
        volatile UINT16 MEM_1358H;
        volatile UINT16 MEM_135CL;
        volatile UINT16 MEM_135CH;
        volatile UINT16 MEM_1360L;
        volatile UINT16 MEM_1360H;
        volatile UINT16 MEM_1364L;
        volatile UINT16 MEM_1364H;
        volatile UINT16 MEM_1368L;
        volatile UINT16 MEM_1368H;
        volatile UINT16 MEM_136CL;
        volatile UINT16 MEM_136CH;
        volatile UINT16 MEM_1370L;
        volatile UINT16 MEM_1370H;
        volatile UINT16 MEM_1374L;
        volatile UINT16 MEM_1374H;
        volatile UINT16 MEM_1378L;
        volatile UINT16 MEM_1378H;
        volatile UINT16 MEM_137CL;
        volatile UINT16 MEM_137CH;
        volatile UINT16 MEM_1380L;
        volatile UINT16 MEM_1380H;
        volatile UINT16 MEM_1384L;
        volatile UINT16 MEM_1384H;
        volatile UINT16 MEM_1388L;
        volatile UINT16 MEM_1388H;
        volatile UINT16 MEM_138CL;
        volatile UINT16 MEM_138CH;
        volatile UINT16 MEM_1390L;
        volatile UINT16 MEM_1390H;
        volatile UINT16 MEM_1394L;
        volatile UINT16 MEM_1394H;
        volatile UINT16 MEM_1398L;
        volatile UINT16 MEM_1398H;
        volatile UINT16 MEM_139CL;
        volatile UINT16 MEM_139CH;
        volatile UINT16 MEM_13A0L;
        volatile UINT16 MEM_13A0H;
        volatile UINT16 MEM_13A4L;
        volatile UINT16 MEM_13A4H;
        volatile UINT16 MEM_13A8L;
        volatile UINT16 MEM_13A8H;
        volatile UINT16 MEM_13ACL;
        volatile UINT16 MEM_13ACH;
        volatile UINT16 MEM_13B0L;
        volatile UINT16 MEM_13B0H;
        volatile UINT16 MEM_13B4L;
        volatile UINT16 MEM_13B4H;
        volatile UINT16 MEM_13B8L;
        volatile UINT16 MEM_13B8H;
        volatile UINT16 MEM_13BCL;
        volatile UINT16 MEM_13BCH;
        volatile UINT16 MEM_13C0L;
        volatile UINT16 MEM_13C0H;
        volatile UINT16 MEM_13C4L;
        volatile UINT16 MEM_13C4H;
        volatile UINT16 MEM_13C8L;
        volatile UINT16 MEM_13C8H;
        volatile UINT16 MEM_13CCL;
        volatile UINT16 MEM_13CCH;
        volatile UINT16 MEM_13D0L;
        volatile UINT16 MEM_13D0H;
        volatile UINT16 MEM_13D4L;
        volatile UINT16 MEM_13D4H;
        volatile UINT16 MEM_13D8L;
        volatile UINT16 MEM_13D8H;
        volatile UINT16 MEM_13DCL;
        volatile UINT16 MEM_13DCH;
        volatile UINT16 MEM_13E0L;
        volatile UINT16 MEM_13E0H;
        volatile UINT16 MEM_13E4L;
        volatile UINT16 MEM_13E4H;
        volatile UINT16 MEM_13E8L;
        volatile UINT16 MEM_13E8H;
        volatile UINT16 MEM_13ECL;
        volatile UINT16 MEM_13ECH;
        volatile UINT16 MEM_13F0L;
        volatile UINT16 MEM_13F0H;
        volatile UINT16 MEM_13F4L;
        volatile UINT16 MEM_13F4H;
        volatile UINT16 MEM_13F8L;
        volatile UINT16 MEM_13F8H;
        volatile UINT16 MEM_13FCL;
        volatile UINT16 MEM_13FCH;
        volatile UINT16 MEM_1400L;
        volatile UINT16 MEM_1400H;
        volatile UINT16 MEM_1404L;
        volatile UINT16 MEM_1404H;
        volatile UINT16 MEM_1408L;
        volatile UINT16 MEM_1408H;
        volatile UINT16 MEM_140CL;
        volatile UINT16 MEM_140CH;
        volatile UINT16 MEM_1410L;
        volatile UINT16 MEM_1410H;
        volatile UINT16 MEM_1414L;
        volatile UINT16 MEM_1414H;
        volatile UINT16 MEM_1418L;
        volatile UINT16 MEM_1418H;
        volatile UINT16 MEM_141CL;
        volatile UINT16 MEM_141CH;
        volatile UINT16 MEM_1420L;
        volatile UINT16 MEM_1420H;
        volatile UINT16 MEM_1424L;
        volatile UINT16 MEM_1424H;
        volatile UINT16 MEM_1428L;
        volatile UINT16 MEM_1428H;
        volatile UINT16 MEM_142CL;
        volatile UINT16 MEM_142CH;
        volatile UINT16 MEM_1430L;
        volatile UINT16 MEM_1430H;
        volatile UINT16 MEM_1434L;
        volatile UINT16 MEM_1434H;
        volatile UINT16 MEM_1438L;
        volatile UINT16 MEM_1438H;
        volatile UINT16 MEM_143CL;
        volatile UINT16 MEM_143CH;
        volatile UINT16 MEM_1440L;
        volatile UINT16 MEM_1440H;
        volatile UINT16 MEM_1444L;
        volatile UINT16 MEM_1444H;
        volatile UINT16 MEM_1448L;
        volatile UINT16 MEM_1448H;
        volatile UINT16 MEM_144CL;
        volatile UINT16 MEM_144CH;
        volatile UINT16 MEM_1450L;
        volatile UINT16 MEM_1450H;
        volatile UINT16 MEM_1454L;
        volatile UINT16 MEM_1454H;
        volatile UINT16 MEM_1458L;
        volatile UINT16 MEM_1458H;
        volatile UINT16 MEM_145CL;
        volatile UINT16 MEM_145CH;
        volatile UINT16 MEM_1460L;
        volatile UINT16 MEM_1460H;
        volatile UINT16 MEM_1464L;
        volatile UINT16 MEM_1464H;
        volatile UINT16 MEM_1468L;
        volatile UINT16 MEM_1468H;
        volatile UINT16 MEM_146CL;
        volatile UINT16 MEM_146CH;
        volatile UINT16 MEM_1470L;
        volatile UINT16 MEM_1470H;
        volatile UINT16 MEM_1474L;
        volatile UINT16 MEM_1474H;
        volatile UINT16 MEM_1478L;
        volatile UINT16 MEM_1478H;
        volatile UINT16 MEM_147CL;
        volatile UINT16 MEM_147CH;
        volatile UINT16 MEM_1480L;
        volatile UINT16 MEM_1480H;
        volatile UINT16 MEM_1484L;
        volatile UINT16 MEM_1484H;
        volatile UINT16 MEM_1488L;
        volatile UINT16 MEM_1488H;
        volatile UINT16 MEM_148CL;
        volatile UINT16 MEM_148CH;
        volatile UINT16 MEM_1490L;
        volatile UINT16 MEM_1490H;
        volatile UINT16 MEM_1494L;
        volatile UINT16 MEM_1494H;
        volatile UINT16 MEM_1498L;
        volatile UINT16 MEM_1498H;
        volatile UINT16 MEM_149CL;
        volatile UINT16 MEM_149CH;
        volatile UINT16 MEM_14A0L;
        volatile UINT16 MEM_14A0H;
        volatile UINT16 MEM_14A4L;
        volatile UINT16 MEM_14A4H;
        volatile UINT16 MEM_14A8L;
        volatile UINT16 MEM_14A8H;
        volatile UINT16 MEM_14ACL;
        volatile UINT16 MEM_14ACH;
        volatile UINT16 MEM_14B0L;
        volatile UINT16 MEM_14B0H;
        volatile UINT16 MEM_14B4L;
        volatile UINT16 MEM_14B4H;
        volatile UINT16 MEM_14B8L;
        volatile UINT16 MEM_14B8H;
        volatile UINT16 MEM_14BCL;
        volatile UINT16 MEM_14BCH;
        volatile UINT16 MEM_14C0L;
        volatile UINT16 MEM_14C0H;
        volatile UINT16 MEM_14C4L;
        volatile UINT16 MEM_14C4H;
        volatile UINT16 MEM_14C8L;
        volatile UINT16 MEM_14C8H;
        volatile UINT16 MEM_14CCL;
        volatile UINT16 MEM_14CCH;
        volatile UINT16 MEM_14D0L;
        volatile UINT16 MEM_14D0H;
        volatile UINT16 MEM_14D4L;
        volatile UINT16 MEM_14D4H;
        volatile UINT16 MEM_14D8L;
        volatile UINT16 MEM_14D8H;
        volatile UINT16 MEM_14DCL;
        volatile UINT16 MEM_14DCH;
        volatile UINT16 MEM_14E0L;
        volatile UINT16 MEM_14E0H;
        volatile UINT16 MEM_14E4L;
        volatile UINT16 MEM_14E4H;
        volatile UINT16 MEM_14E8L;
        volatile UINT16 MEM_14E8H;
        volatile UINT16 MEM_14ECL;
        volatile UINT16 MEM_14ECH;
        volatile UINT16 MEM_14F0L;
        volatile UINT16 MEM_14F0H;
        volatile UINT16 MEM_14F4L;
        volatile UINT16 MEM_14F4H;
        volatile UINT16 MEM_14F8L;
        volatile UINT16 MEM_14F8H;
        volatile UINT16 MEM_14FCL;
        volatile UINT16 MEM_14FCH;
        volatile UINT16 MEM_1500L;
        volatile UINT16 MEM_1500H;
        volatile UINT16 MEM_1504L;
        volatile UINT16 MEM_1504H;
        volatile UINT16 MEM_1508L;
        volatile UINT16 MEM_1508H;
        volatile UINT16 MEM_150CL;
        volatile UINT16 MEM_150CH;
        volatile UINT16 MEM_1510L;
        volatile UINT16 MEM_1510H;
        volatile UINT16 MEM_1514L;
        volatile UINT16 MEM_1514H;
        volatile UINT16 MEM_1518L;
        volatile UINT16 MEM_1518H;
        volatile UINT16 MEM_151CL;
        volatile UINT16 MEM_151CH;
        volatile UINT16 MEM_1520L;
        volatile UINT16 MEM_1520H;
        volatile UINT16 MEM_1524L;
        volatile UINT16 MEM_1524H;
        volatile UINT16 MEM_1528L;
        volatile UINT16 MEM_1528H;
        volatile UINT16 MEM_152CL;
        volatile UINT16 MEM_152CH;
        volatile UINT16 MEM_1530L;
        volatile UINT16 MEM_1530H;
        volatile UINT16 MEM_1534L;
        volatile UINT16 MEM_1534H;
        volatile UINT16 MEM_1538L;
        volatile UINT16 MEM_1538H;
        volatile UINT16 MEM_153CL;
        volatile UINT16 MEM_153CH;
        volatile UINT16 MEM_1540L;
        volatile UINT16 MEM_1540H;
        volatile UINT16 MEM_1544L;
        volatile UINT16 MEM_1544H;
        volatile UINT16 MEM_1548L;
        volatile UINT16 MEM_1548H;
        volatile UINT16 MEM_154CL;
        volatile UINT16 MEM_154CH;
        volatile UINT16 MEM_1550L;
        volatile UINT16 MEM_1550H;
        volatile UINT16 MEM_1554L;
        volatile UINT16 MEM_1554H;
        volatile UINT16 MEM_1558L;
        volatile UINT16 MEM_1558H;
        volatile UINT16 MEM_155CL;
        volatile UINT16 MEM_155CH;
        volatile UINT16 MEM_1560L;
        volatile UINT16 MEM_1560H;
        volatile UINT16 MEM_1564L;
        volatile UINT16 MEM_1564H;
        volatile UINT16 MEM_1568L;
        volatile UINT16 MEM_1568H;
        volatile UINT16 MEM_156CL;
        volatile UINT16 MEM_156CH;
        volatile UINT16 MEM_1570L;
        volatile UINT16 MEM_1570H;
        volatile UINT16 MEM_1574L;
        volatile UINT16 MEM_1574H;
        volatile UINT16 MEM_1578L;
        volatile UINT16 MEM_1578H;
        volatile UINT16 MEM_157CL;
        volatile UINT16 MEM_157CH;
        volatile UINT16 MEM_1580L;
        volatile UINT16 MEM_1580H;
        volatile UINT16 MEM_1584L;
        volatile UINT16 MEM_1584H;
        volatile UINT16 MEM_1588L;
        volatile UINT16 MEM_1588H;
        volatile UINT16 MEM_158CL;
        volatile UINT16 MEM_158CH;
        volatile UINT16 MEM_1590L;
        volatile UINT16 MEM_1590H;
        volatile UINT16 MEM_1594L;
        volatile UINT16 MEM_1594H;
        volatile UINT16 MEM_1598L;
        volatile UINT16 MEM_1598H;
        volatile UINT16 MEM_159CL;
        volatile UINT16 MEM_159CH;
        volatile UINT16 MEM_15A0L;
        volatile UINT16 MEM_15A0H;
        volatile UINT16 MEM_15A4L;
        volatile UINT16 MEM_15A4H;
        volatile UINT16 MEM_15A8L;
        volatile UINT16 MEM_15A8H;
        volatile UINT16 MEM_15ACL;
        volatile UINT16 MEM_15ACH;
        volatile UINT16 MEM_15B0L;
        volatile UINT16 MEM_15B0H;
        volatile UINT16 MEM_15B4L;
        volatile UINT16 MEM_15B4H;
        volatile UINT16 MEM_15B8L;
        volatile UINT16 MEM_15B8H;
        volatile UINT16 MEM_15BCL;
        volatile UINT16 MEM_15BCH;
        volatile UINT16 MEM_15C0L;
        volatile UINT16 MEM_15C0H;
        volatile UINT16 MEM_15C4L;
        volatile UINT16 MEM_15C4H;
        volatile UINT16 MEM_15C8L;
        volatile UINT16 MEM_15C8H;
        volatile UINT16 MEM_15CCL;
        volatile UINT16 MEM_15CCH;
        volatile UINT16 MEM_15D0L;
        volatile UINT16 MEM_15D0H;
        volatile UINT16 MEM_15D4L;
        volatile UINT16 MEM_15D4H;
        volatile UINT16 MEM_15D8L;
        volatile UINT16 MEM_15D8H;
        volatile UINT16 MEM_15DCL;
        volatile UINT16 MEM_15DCH;
        volatile UINT16 MEM_15E0L;
        volatile UINT16 MEM_15E0H;
        volatile UINT16 MEM_15E4L;
        volatile UINT16 MEM_15E4H;
        volatile UINT16 MEM_15E8L;
        volatile UINT16 MEM_15E8H;
        volatile UINT16 MEM_15ECL;
        volatile UINT16 MEM_15ECH;
        volatile UINT16 MEM_15F0L;
        volatile UINT16 MEM_15F0H;
        volatile UINT16 MEM_15F4L;
        volatile UINT16 MEM_15F4H;
        volatile UINT16 MEM_15F8L;
        volatile UINT16 MEM_15F8H;
        volatile UINT16 MEM_15FCL;
        volatile UINT16 MEM_15FCH;
        volatile UINT16 MEM_1600L;
        volatile UINT16 MEM_1600H;
        volatile UINT16 MEM_1604L;
        volatile UINT16 MEM_1604H;
        volatile UINT16 MEM_1608L;
        volatile UINT16 MEM_1608H;
        volatile UINT16 MEM_160CL;
        volatile UINT16 MEM_160CH;
        volatile UINT16 MEM_1610L;
        volatile UINT16 MEM_1610H;
        volatile UINT16 MEM_1614L;
        volatile UINT16 MEM_1614H;
        volatile UINT16 MEM_1618L;
        volatile UINT16 MEM_1618H;
        volatile UINT16 MEM_161CL;
        volatile UINT16 MEM_161CH;
        volatile UINT16 MEM_1620L;
        volatile UINT16 MEM_1620H;
        volatile UINT16 MEM_1624L;
        volatile UINT16 MEM_1624H;
        volatile UINT16 MEM_1628L;
        volatile UINT16 MEM_1628H;
        volatile UINT16 MEM_162CL;
        volatile UINT16 MEM_162CH;
        volatile UINT16 MEM_1630L;
        volatile UINT16 MEM_1630H;
        volatile UINT16 MEM_1634L;
        volatile UINT16 MEM_1634H;
        volatile UINT16 MEM_1638L;
        volatile UINT16 MEM_1638H;
        volatile UINT16 MEM_163CL;
        volatile UINT16 MEM_163CH;
        volatile UINT16 MEM_1640L;
        volatile UINT16 MEM_1640H;
        volatile UINT16 MEM_1644L;
        volatile UINT16 MEM_1644H;
        volatile UINT16 MEM_1648L;
        volatile UINT16 MEM_1648H;
        volatile UINT16 MEM_164CL;
        volatile UINT16 MEM_164CH;
        volatile UINT16 MEM_1650L;
        volatile UINT16 MEM_1650H;
        volatile UINT16 MEM_1654L;
        volatile UINT16 MEM_1654H;
        volatile UINT16 MEM_1658L;
        volatile UINT16 MEM_1658H;
        volatile UINT16 MEM_165CL;
        volatile UINT16 MEM_165CH;
        volatile UINT16 MEM_1660L;
        volatile UINT16 MEM_1660H;
        volatile UINT16 MEM_1664L;
        volatile UINT16 MEM_1664H;
        volatile UINT16 MEM_1668L;
        volatile UINT16 MEM_1668H;
        volatile UINT16 MEM_166CL;
        volatile UINT16 MEM_166CH;
        volatile UINT16 MEM_1670L;
        volatile UINT16 MEM_1670H;
        volatile UINT16 MEM_1674L;
        volatile UINT16 MEM_1674H;
        volatile UINT16 MEM_1678L;
        volatile UINT16 MEM_1678H;
        volatile UINT16 MEM_167CL;
        volatile UINT16 MEM_167CH;
        volatile UINT16 MEM_1680L;
        volatile UINT16 MEM_1680H;
        volatile UINT16 MEM_1684L;
        volatile UINT16 MEM_1684H;
        volatile UINT16 MEM_1688L;
        volatile UINT16 MEM_1688H;
        volatile UINT16 MEM_168CL;
        volatile UINT16 MEM_168CH;
        volatile UINT16 MEM_1690L;
        volatile UINT16 MEM_1690H;
        volatile UINT16 MEM_1694L;
        volatile UINT16 MEM_1694H;
        volatile UINT16 MEM_1698L;
        volatile UINT16 MEM_1698H;
        volatile UINT16 MEM_169CL;
        volatile UINT16 MEM_169CH;
        volatile UINT16 MEM_16A0L;
        volatile UINT16 MEM_16A0H;
        volatile UINT16 MEM_16A4L;
        volatile UINT16 MEM_16A4H;
        volatile UINT16 MEM_16A8L;
        volatile UINT16 MEM_16A8H;
        volatile UINT16 MEM_16ACL;
        volatile UINT16 MEM_16ACH;
        volatile UINT16 MEM_16B0L;
        volatile UINT16 MEM_16B0H;
        volatile UINT16 MEM_16B4L;
        volatile UINT16 MEM_16B4H;
        volatile UINT16 MEM_16B8L;
        volatile UINT16 MEM_16B8H;
        volatile UINT16 MEM_16BCL;
        volatile UINT16 MEM_16BCH;
        volatile UINT16 MEM_16C0L;
        volatile UINT16 MEM_16C0H;
        volatile UINT16 MEM_16C4L;
        volatile UINT16 MEM_16C4H;
        volatile UINT16 MEM_16C8L;
        volatile UINT16 MEM_16C8H;
        volatile UINT16 MEM_16CCL;
        volatile UINT16 MEM_16CCH;
        volatile UINT16 MEM_16D0L;
        volatile UINT16 MEM_16D0H;
        volatile UINT16 MEM_16D4L;
        volatile UINT16 MEM_16D4H;
        volatile UINT16 MEM_16D8L;
        volatile UINT16 MEM_16D8H;
        volatile UINT16 MEM_16DCL;
        volatile UINT16 MEM_16DCH;
        volatile UINT16 MEM_16E0L;
        volatile UINT16 MEM_16E0H;
        volatile UINT16 MEM_16E4L;
        volatile UINT16 MEM_16E4H;
        volatile UINT16 MEM_16E8L;
        volatile UINT16 MEM_16E8H;
        volatile UINT16 MEM_16ECL;
        volatile UINT16 MEM_16ECH;
        volatile UINT16 MEM_16F0L;
        volatile UINT16 MEM_16F0H;
        volatile UINT16 MEM_16F4L;
        volatile UINT16 MEM_16F4H;
        volatile UINT16 MEM_16F8L;
        volatile UINT16 MEM_16F8H;
        volatile UINT16 MEM_16FCL;
        volatile UINT16 MEM_16FCH;
        volatile UINT16 MEM_1700L;
        volatile UINT16 MEM_1700H;
        volatile UINT16 MEM_1704L;
        volatile UINT16 MEM_1704H;
        volatile UINT16 MEM_1708L;
        volatile UINT16 MEM_1708H;
        volatile UINT16 MEM_170CL;
        volatile UINT16 MEM_170CH;
        volatile UINT16 MEM_1710L;
        volatile UINT16 MEM_1710H;
        volatile UINT16 MEM_1714L;
        volatile UINT16 MEM_1714H;
        volatile UINT16 MEM_1718L;
        volatile UINT16 MEM_1718H;
        volatile UINT16 MEM_171CL;
        volatile UINT16 MEM_171CH;
        volatile UINT16 MEM_1720L;
        volatile UINT16 MEM_1720H;
        volatile UINT16 MEM_1724L;
        volatile UINT16 MEM_1724H;
        volatile UINT16 MEM_1728L;
        volatile UINT16 MEM_1728H;
        volatile UINT16 MEM_172CL;
        volatile UINT16 MEM_172CH;
        volatile UINT16 MEM_1730L;
        volatile UINT16 MEM_1730H;
        volatile UINT16 MEM_1734L;
        volatile UINT16 MEM_1734H;
        volatile UINT16 MEM_1738L;
        volatile UINT16 MEM_1738H;
        volatile UINT16 MEM_173CL;
        volatile UINT16 MEM_173CH;
        volatile UINT16 MEM_1740L;
        volatile UINT16 MEM_1740H;
        volatile UINT16 MEM_1744L;
        volatile UINT16 MEM_1744H;
        volatile UINT16 MEM_1748L;
        volatile UINT16 MEM_1748H;
        volatile UINT16 MEM_174CL;
        volatile UINT16 MEM_174CH;
        volatile UINT16 MEM_1750L;
        volatile UINT16 MEM_1750H;
        volatile UINT16 MEM_1754L;
        volatile UINT16 MEM_1754H;
        volatile UINT16 MEM_1758L;
        volatile UINT16 MEM_1758H;
        volatile UINT16 MEM_175CL;
        volatile UINT16 MEM_175CH;
        volatile UINT16 MEM_1760L;
        volatile UINT16 MEM_1760H;
        volatile UINT16 MEM_1764L;
        volatile UINT16 MEM_1764H;
        volatile UINT16 MEM_1768L;
        volatile UINT16 MEM_1768H;
        volatile UINT16 MEM_176CL;
        volatile UINT16 MEM_176CH;
        volatile UINT16 MEM_1770L;
        volatile UINT16 MEM_1770H;
        volatile UINT16 MEM_1774L;
        volatile UINT16 MEM_1774H;
        volatile UINT16 MEM_1778L;
        volatile UINT16 MEM_1778H;
        volatile UINT16 MEM_177CL;
        volatile UINT16 MEM_177CH;
        volatile UINT16 MEM_1780L;
        volatile UINT16 MEM_1780H;
        volatile UINT16 MEM_1784L;
        volatile UINT16 MEM_1784H;
        volatile UINT16 MEM_1788L;
        volatile UINT16 MEM_1788H;
        volatile UINT16 MEM_178CL;
        volatile UINT16 MEM_178CH;
        volatile UINT16 MEM_1790L;
        volatile UINT16 MEM_1790H;
        volatile UINT16 MEM_1794L;
        volatile UINT16 MEM_1794H;
        volatile UINT16 MEM_1798L;
        volatile UINT16 MEM_1798H;
        volatile UINT16 MEM_179CL;
        volatile UINT16 MEM_179CH;
        volatile UINT16 MEM_17A0L;
        volatile UINT16 MEM_17A0H;
        volatile UINT16 MEM_17A4L;
        volatile UINT16 MEM_17A4H;
        volatile UINT16 MEM_17A8L;
        volatile UINT16 MEM_17A8H;
        volatile UINT16 MEM_17ACL;
        volatile UINT16 MEM_17ACH;
        volatile UINT16 MEM_17B0L;
        volatile UINT16 MEM_17B0H;
        volatile UINT16 MEM_17B4L;
        volatile UINT16 MEM_17B4H;
        volatile UINT16 MEM_17B8L;
        volatile UINT16 MEM_17B8H;
        volatile UINT16 MEM_17BCL;
        volatile UINT16 MEM_17BCH;
        volatile UINT16 MEM_17C0L;
        volatile UINT16 MEM_17C0H;
        volatile UINT16 MEM_17C4L;
        volatile UINT16 MEM_17C4H;
        volatile UINT16 MEM_17C8L;
        volatile UINT16 MEM_17C8H;
        volatile UINT16 MEM_17CCL;
        volatile UINT16 MEM_17CCH;
        volatile UINT16 MEM_17D0L;
        volatile UINT16 MEM_17D0H;
        volatile UINT16 MEM_17D4L;
        volatile UINT16 MEM_17D4H;
        volatile UINT16 MEM_17D8L;
        volatile UINT16 MEM_17D8H;
        volatile UINT16 MEM_17DCL;
        volatile UINT16 MEM_17DCH;
        volatile UINT16 MEM_17E0L;
        volatile UINT16 MEM_17E0H;
        volatile UINT16 MEM_17E4L;
        volatile UINT16 MEM_17E4H;
        volatile UINT16 MEM_17E8L;
        volatile UINT16 MEM_17E8H;
        volatile UINT16 MEM_17ECL;
        volatile UINT16 MEM_17ECH;
        volatile UINT16 MEM_17F0L;
        volatile UINT16 MEM_17F0H;
        volatile UINT16 MEM_17F4L;
        volatile UINT16 MEM_17F4H;
        volatile UINT16 MEM_17F8L;
        volatile UINT16 MEM_17F8H;
        volatile UINT16 MEM_17FCL;
        volatile UINT16 MEM_17FCH;
        volatile UINT16 MEM_1800L;
        volatile UINT16 MEM_1800H;
        volatile UINT16 MEM_1804L;
        volatile UINT16 MEM_1804H;
        volatile UINT16 MEM_1808L;
        volatile UINT16 MEM_1808H;
        volatile UINT16 MEM_180CL;
        volatile UINT16 MEM_180CH;
        volatile UINT16 MEM_1810L;
        volatile UINT16 MEM_1810H;
        volatile UINT16 MEM_1814L;
        volatile UINT16 MEM_1814H;
        volatile UINT16 MEM_1818L;
        volatile UINT16 MEM_1818H;
        volatile UINT16 MEM_181CL;
        volatile UINT16 MEM_181CH;
        volatile UINT16 MEM_1820L;
        volatile UINT16 MEM_1820H;
        volatile UINT16 MEM_1824L;
        volatile UINT16 MEM_1824H;
        volatile UINT16 MEM_1828L;
        volatile UINT16 MEM_1828H;
        volatile UINT16 MEM_182CL;
        volatile UINT16 MEM_182CH;
        volatile UINT16 MEM_1830L;
        volatile UINT16 MEM_1830H;
        volatile UINT16 MEM_1834L;
        volatile UINT16 MEM_1834H;
        volatile UINT16 MEM_1838L;
        volatile UINT16 MEM_1838H;
        volatile UINT16 MEM_183CL;
        volatile UINT16 MEM_183CH;
        volatile UINT16 MEM_1840L;
        volatile UINT16 MEM_1840H;
        volatile UINT16 MEM_1844L;
        volatile UINT16 MEM_1844H;
        volatile UINT16 MEM_1848L;
        volatile UINT16 MEM_1848H;
        volatile UINT16 MEM_184CL;
        volatile UINT16 MEM_184CH;
        volatile UINT16 MEM_1850L;
        volatile UINT16 MEM_1850H;
        volatile UINT16 MEM_1854L;
        volatile UINT16 MEM_1854H;
        volatile UINT16 MEM_1858L;
        volatile UINT16 MEM_1858H;
        volatile UINT16 MEM_185CL;
        volatile UINT16 MEM_185CH;
        volatile UINT16 MEM_1860L;
        volatile UINT16 MEM_1860H;
        volatile UINT16 MEM_1864L;
        volatile UINT16 MEM_1864H;
        volatile UINT16 MEM_1868L;
        volatile UINT16 MEM_1868H;
        volatile UINT16 MEM_186CL;
        volatile UINT16 MEM_186CH;
        volatile UINT16 MEM_1870L;
        volatile UINT16 MEM_1870H;
        volatile UINT16 MEM_1874L;
        volatile UINT16 MEM_1874H;
        volatile UINT16 MEM_1878L;
        volatile UINT16 MEM_1878H;
        volatile UINT16 MEM_187CL;
        volatile UINT16 MEM_187CH;
        volatile UINT16 MEM_1880L;
        volatile UINT16 MEM_1880H;
        volatile UINT16 MEM_1884L;
        volatile UINT16 MEM_1884H;
        volatile UINT16 MEM_1888L;
        volatile UINT16 MEM_1888H;
        volatile UINT16 MEM_188CL;
        volatile UINT16 MEM_188CH;
        volatile UINT16 MEM_1890L;
        volatile UINT16 MEM_1890H;
        volatile UINT16 MEM_1894L;
        volatile UINT16 MEM_1894H;
        volatile UINT16 MEM_1898L;
        volatile UINT16 MEM_1898H;
        volatile UINT16 MEM_189CL;
        volatile UINT16 MEM_189CH;
        volatile UINT16 MEM_18A0L;
        volatile UINT16 MEM_18A0H;
        volatile UINT16 MEM_18A4L;
        volatile UINT16 MEM_18A4H;
        volatile UINT16 MEM_18A8L;
        volatile UINT16 MEM_18A8H;
        volatile UINT16 MEM_18ACL;
        volatile UINT16 MEM_18ACH;
        volatile UINT16 MEM_18B0L;
        volatile UINT16 MEM_18B0H;
        volatile UINT16 MEM_18B4L;
        volatile UINT16 MEM_18B4H;
        volatile UINT16 MEM_18B8L;
        volatile UINT16 MEM_18B8H;
        volatile UINT16 MEM_18BCL;
        volatile UINT16 MEM_18BCH;
        volatile UINT16 MEM_18C0L;
        volatile UINT16 MEM_18C0H;
        volatile UINT16 MEM_18C4L;
        volatile UINT16 MEM_18C4H;
        volatile UINT16 MEM_18C8L;
        volatile UINT16 MEM_18C8H;
        volatile UINT16 MEM_18CCL;
        volatile UINT16 MEM_18CCH;
        volatile UINT16 MEM_18D0L;
        volatile UINT16 MEM_18D0H;
        volatile UINT16 MEM_18D4L;
        volatile UINT16 MEM_18D4H;
        volatile UINT16 MEM_18D8L;
        volatile UINT16 MEM_18D8H;
        volatile UINT16 MEM_18DCL;
        volatile UINT16 MEM_18DCH;
        volatile UINT16 MEM_18E0L;
        volatile UINT16 MEM_18E0H;
        volatile UINT16 MEM_18E4L;
        volatile UINT16 MEM_18E4H;
        volatile UINT16 MEM_18E8L;
        volatile UINT16 MEM_18E8H;
        volatile UINT16 MEM_18ECL;
        volatile UINT16 MEM_18ECH;
        volatile UINT16 MEM_18F0L;
        volatile UINT16 MEM_18F0H;
        volatile UINT16 MEM_18F4L;
        volatile UINT16 MEM_18F4H;
        volatile UINT16 MEM_18F8L;
        volatile UINT16 MEM_18F8H;
        volatile UINT16 MEM_18FCL;
        volatile UINT16 MEM_18FCH;
        volatile UINT16 MEM_1900L;
        volatile UINT16 MEM_1900H;
        volatile UINT16 MEM_1904L;
        volatile UINT16 MEM_1904H;
        volatile UINT16 MEM_1908L;
        volatile UINT16 MEM_1908H;
        volatile UINT16 MEM_190CL;
        volatile UINT16 MEM_190CH;
        volatile UINT16 MEM_1910L;
        volatile UINT16 MEM_1910H;
        volatile UINT16 MEM_1914L;
        volatile UINT16 MEM_1914H;
        volatile UINT16 MEM_1918L;
        volatile UINT16 MEM_1918H;
        volatile UINT16 MEM_191CL;
        volatile UINT16 MEM_191CH;
        volatile UINT16 MEM_1920L;
        volatile UINT16 MEM_1920H;
        volatile UINT16 MEM_1924L;
        volatile UINT16 MEM_1924H;
        volatile UINT16 MEM_1928L;
        volatile UINT16 MEM_1928H;
        volatile UINT16 MEM_192CL;
        volatile UINT16 MEM_192CH;
        volatile UINT16 MEM_1930L;
        volatile UINT16 MEM_1930H;
        volatile UINT16 MEM_1934L;
        volatile UINT16 MEM_1934H;
        volatile UINT16 MEM_1938L;
        volatile UINT16 MEM_1938H;
        volatile UINT16 MEM_193CL;
        volatile UINT16 MEM_193CH;
        volatile UINT16 MEM_1940L;
        volatile UINT16 MEM_1940H;
        volatile UINT16 MEM_1944L;
        volatile UINT16 MEM_1944H;
        volatile UINT16 MEM_1948L;
        volatile UINT16 MEM_1948H;
        volatile UINT16 MEM_194CL;
        volatile UINT16 MEM_194CH;
        volatile UINT16 MEM_1950L;
        volatile UINT16 MEM_1950H;
        volatile UINT16 MEM_1954L;
        volatile UINT16 MEM_1954H;
        volatile UINT16 MEM_1958L;
        volatile UINT16 MEM_1958H;
        volatile UINT16 MEM_195CL;
        volatile UINT16 MEM_195CH;
        volatile UINT16 MEM_1960L;
        volatile UINT16 MEM_1960H;
        volatile UINT16 MEM_1964L;
        volatile UINT16 MEM_1964H;
        volatile UINT16 MEM_1968L;
        volatile UINT16 MEM_1968H;
        volatile UINT16 MEM_196CL;
        volatile UINT16 MEM_196CH;
        volatile UINT16 MEM_1970L;
        volatile UINT16 MEM_1970H;
        volatile UINT16 MEM_1974L;
        volatile UINT16 MEM_1974H;
        volatile UINT16 MEM_1978L;
        volatile UINT16 MEM_1978H;
        volatile UINT16 MEM_197CL;
        volatile UINT16 MEM_197CH;
        volatile UINT16 MEM_1980L;
        volatile UINT16 MEM_1980H;
        volatile UINT16 MEM_1984L;
        volatile UINT16 MEM_1984H;
        volatile UINT16 MEM_1988L;
        volatile UINT16 MEM_1988H;
        volatile UINT16 MEM_198CL;
        volatile UINT16 MEM_198CH;
        volatile UINT16 MEM_1990L;
        volatile UINT16 MEM_1990H;
        volatile UINT16 MEM_1994L;
        volatile UINT16 MEM_1994H;
        volatile UINT16 MEM_1998L;
        volatile UINT16 MEM_1998H;
        volatile UINT16 MEM_199CL;
        volatile UINT16 MEM_199CH;
        volatile UINT16 MEM_19A0L;
        volatile UINT16 MEM_19A0H;
        volatile UINT16 MEM_19A4L;
        volatile UINT16 MEM_19A4H;
        volatile UINT16 MEM_19A8L;
        volatile UINT16 MEM_19A8H;
        volatile UINT16 MEM_19ACL;
        volatile UINT16 MEM_19ACH;
        volatile UINT16 MEM_19B0L;
        volatile UINT16 MEM_19B0H;
        volatile UINT16 MEM_19B4L;
        volatile UINT16 MEM_19B4H;
        volatile UINT16 MEM_19B8L;
        volatile UINT16 MEM_19B8H;
        volatile UINT16 MEM_19BCL;
        volatile UINT16 MEM_19BCH;
        volatile UINT16 MEM_19C0L;
        volatile UINT16 MEM_19C0H;
        volatile UINT16 MEM_19C4L;
        volatile UINT16 MEM_19C4H;
        volatile UINT16 MEM_19C8L;
        volatile UINT16 MEM_19C8H;
        volatile UINT16 MEM_19CCL;
        volatile UINT16 MEM_19CCH;
        volatile UINT16 MEM_19D0L;
        volatile UINT16 MEM_19D0H;
        volatile UINT16 MEM_19D4L;
        volatile UINT16 MEM_19D4H;
        volatile UINT16 MEM_19D8L;
        volatile UINT16 MEM_19D8H;
        volatile UINT16 MEM_19DCL;
        volatile UINT16 MEM_19DCH;
        volatile UINT16 MEM_19E0L;
        volatile UINT16 MEM_19E0H;
        volatile UINT16 MEM_19E4L;
        volatile UINT16 MEM_19E4H;
        volatile UINT16 MEM_19E8L;
        volatile UINT16 MEM_19E8H;
        volatile UINT16 MEM_19ECL;
        volatile UINT16 MEM_19ECH;
        volatile UINT16 MEM_19F0L;
        volatile UINT16 MEM_19F0H;
        volatile UINT16 MEM_19F4L;
        volatile UINT16 MEM_19F4H;
        volatile UINT16 MEM_19F8L;
        volatile UINT16 MEM_19F8H;
        volatile UINT16 MEM_19FCL;
        volatile UINT16 MEM_19FCH;
        volatile UINT16 MEM_1A00L;
        volatile UINT16 MEM_1A00H;
        volatile UINT16 MEM_1A04L;
        volatile UINT16 MEM_1A04H;
        volatile UINT16 MEM_1A08L;
        volatile UINT16 MEM_1A08H;
        volatile UINT16 MEM_1A0CL;
        volatile UINT16 MEM_1A0CH;
        volatile UINT16 MEM_1A10L;
        volatile UINT16 MEM_1A10H;
        volatile UINT16 MEM_1A14L;
        volatile UINT16 MEM_1A14H;
        volatile UINT16 MEM_1A18L;
        volatile UINT16 MEM_1A18H;
        volatile UINT16 MEM_1A1CL;
        volatile UINT16 MEM_1A1CH;
        volatile UINT16 MEM_1A20L;
        volatile UINT16 MEM_1A20H;
        volatile UINT16 MEM_1A24L;
        volatile UINT16 MEM_1A24H;
        volatile UINT16 MEM_1A28L;
        volatile UINT16 MEM_1A28H;
        volatile UINT16 MEM_1A2CL;
        volatile UINT16 MEM_1A2CH;
        volatile UINT16 MEM_1A30L;
        volatile UINT16 MEM_1A30H;
        volatile UINT16 MEM_1A34L;
        volatile UINT16 MEM_1A34H;
        volatile UINT16 MEM_1A38L;
        volatile UINT16 MEM_1A38H;
        volatile UINT16 MEM_1A3CL;
        volatile UINT16 MEM_1A3CH;
        volatile UINT16 MEM_1A40L;
        volatile UINT16 MEM_1A40H;
        volatile UINT16 MEM_1A44L;
        volatile UINT16 MEM_1A44H;
        volatile UINT16 MEM_1A48L;
        volatile UINT16 MEM_1A48H;
        volatile UINT16 MEM_1A4CL;
        volatile UINT16 MEM_1A4CH;
        volatile UINT16 MEM_1A50L;
        volatile UINT16 MEM_1A50H;
        volatile UINT16 MEM_1A54L;
        volatile UINT16 MEM_1A54H;
        volatile UINT16 MEM_1A58L;
        volatile UINT16 MEM_1A58H;
        volatile UINT16 MEM_1A5CL;
        volatile UINT16 MEM_1A5CH;
        volatile UINT16 MEM_1A60L;
        volatile UINT16 MEM_1A60H;
        volatile UINT16 MEM_1A64L;
        volatile UINT16 MEM_1A64H;
        volatile UINT16 MEM_1A68L;
        volatile UINT16 MEM_1A68H;
        volatile UINT16 MEM_1A6CL;
        volatile UINT16 MEM_1A6CH;
        volatile UINT16 MEM_1A70L;
        volatile UINT16 MEM_1A70H;
        volatile UINT16 MEM_1A74L;
        volatile UINT16 MEM_1A74H;
        volatile UINT16 MEM_1A78L;
        volatile UINT16 MEM_1A78H;
        volatile UINT16 MEM_1A7CL;
        volatile UINT16 MEM_1A7CH;
        volatile UINT16 MEM_1A80L;
        volatile UINT16 MEM_1A80H;
        volatile UINT16 MEM_1A84L;
        volatile UINT16 MEM_1A84H;
        volatile UINT16 MEM_1A88L;
        volatile UINT16 MEM_1A88H;
        volatile UINT16 MEM_1A8CL;
        volatile UINT16 MEM_1A8CH;
        volatile UINT16 MEM_1A90L;
        volatile UINT16 MEM_1A90H;
        volatile UINT16 MEM_1A94L;
        volatile UINT16 MEM_1A94H;
        volatile UINT16 MEM_1A98L;
        volatile UINT16 MEM_1A98H;
        volatile UINT16 MEM_1A9CL;
        volatile UINT16 MEM_1A9CH;
        volatile UINT16 MEM_1AA0L;
        volatile UINT16 MEM_1AA0H;
        volatile UINT16 MEM_1AA4L;
        volatile UINT16 MEM_1AA4H;
        volatile UINT16 MEM_1AA8L;
        volatile UINT16 MEM_1AA8H;
        volatile UINT16 MEM_1AACL;
        volatile UINT16 MEM_1AACH;
        volatile UINT16 MEM_1AB0L;
        volatile UINT16 MEM_1AB0H;
        volatile UINT16 MEM_1AB4L;
        volatile UINT16 MEM_1AB4H;
        volatile UINT16 MEM_1AB8L;
        volatile UINT16 MEM_1AB8H;
        volatile UINT16 MEM_1ABCL;
        volatile UINT16 MEM_1ABCH;
        volatile UINT16 MEM_1AC0L;
        volatile UINT16 MEM_1AC0H;
        volatile UINT16 MEM_1AC4L;
        volatile UINT16 MEM_1AC4H;
        volatile UINT16 MEM_1AC8L;
        volatile UINT16 MEM_1AC8H;
        volatile UINT16 MEM_1ACCL;
        volatile UINT16 MEM_1ACCH;
        volatile UINT16 MEM_1AD0L;
        volatile UINT16 MEM_1AD0H;
        volatile UINT16 MEM_1AD4L;
        volatile UINT16 MEM_1AD4H;
        volatile UINT16 MEM_1AD8L;
        volatile UINT16 MEM_1AD8H;
        volatile UINT16 MEM_1ADCL;
        volatile UINT16 MEM_1ADCH;
        volatile UINT16 MEM_1AE0L;
        volatile UINT16 MEM_1AE0H;
        volatile UINT16 MEM_1AE4L;
        volatile UINT16 MEM_1AE4H;
        volatile UINT16 MEM_1AE8L;
        volatile UINT16 MEM_1AE8H;
        volatile UINT16 MEM_1AECL;
        volatile UINT16 MEM_1AECH;
        volatile UINT16 MEM_1AF0L;
        volatile UINT16 MEM_1AF0H;
        volatile UINT16 MEM_1AF4L;
        volatile UINT16 MEM_1AF4H;
        volatile UINT16 MEM_1AF8L;
        volatile UINT16 MEM_1AF8H;
        volatile UINT16 MEM_1AFCL;
        volatile UINT16 MEM_1AFCH;
        volatile UINT16 MEM_1B00L;
        volatile UINT16 MEM_1B00H;
        volatile UINT16 MEM_1B04L;
        volatile UINT16 MEM_1B04H;
        volatile UINT16 MEM_1B08L;
        volatile UINT16 MEM_1B08H;
        volatile UINT16 MEM_1B0CL;
        volatile UINT16 MEM_1B0CH;
        volatile UINT16 MEM_1B10L;
        volatile UINT16 MEM_1B10H;
        volatile UINT16 MEM_1B14L;
        volatile UINT16 MEM_1B14H;
        volatile UINT16 MEM_1B18L;
        volatile UINT16 MEM_1B18H;
        volatile UINT16 MEM_1B1CL;
        volatile UINT16 MEM_1B1CH;
        volatile UINT16 MEM_1B20L;
        volatile UINT16 MEM_1B20H;
        volatile UINT16 MEM_1B24L;
        volatile UINT16 MEM_1B24H;
        volatile UINT16 MEM_1B28L;
        volatile UINT16 MEM_1B28H;
        volatile UINT16 MEM_1B2CL;
        volatile UINT16 MEM_1B2CH;
        volatile UINT16 MEM_1B30L;
        volatile UINT16 MEM_1B30H;
        volatile UINT16 MEM_1B34L;
        volatile UINT16 MEM_1B34H;
        volatile UINT16 MEM_1B38L;
        volatile UINT16 MEM_1B38H;
        volatile UINT16 MEM_1B3CL;
        volatile UINT16 MEM_1B3CH;
        volatile UINT16 MEM_1B40L;
        volatile UINT16 MEM_1B40H;
        volatile UINT16 MEM_1B44L;
        volatile UINT16 MEM_1B44H;
        volatile UINT16 MEM_1B48L;
        volatile UINT16 MEM_1B48H;
        volatile UINT16 MEM_1B4CL;
        volatile UINT16 MEM_1B4CH;
        volatile UINT16 MEM_1B50L;
        volatile UINT16 MEM_1B50H;
        volatile UINT16 MEM_1B54L;
        volatile UINT16 MEM_1B54H;
        volatile UINT16 MEM_1B58L;
        volatile UINT16 MEM_1B58H;
        volatile UINT16 MEM_1B5CL;
        volatile UINT16 MEM_1B5CH;
        volatile UINT16 MEM_1B60L;
        volatile UINT16 MEM_1B60H;
        volatile UINT16 MEM_1B64L;
        volatile UINT16 MEM_1B64H;
        volatile UINT16 MEM_1B68L;
        volatile UINT16 MEM_1B68H;
        volatile UINT16 MEM_1B6CL;
        volatile UINT16 MEM_1B6CH;
        volatile UINT16 MEM_1B70L;
        volatile UINT16 MEM_1B70H;
        volatile UINT16 MEM_1B74L;
        volatile UINT16 MEM_1B74H;
        volatile UINT16 MEM_1B78L;
        volatile UINT16 MEM_1B78H;
        volatile UINT16 MEM_1B7CL;
        volatile UINT16 MEM_1B7CH;
        volatile UINT16 MEM_1B80L;
        volatile UINT16 MEM_1B80H;
        volatile UINT16 MEM_1B84L;
        volatile UINT16 MEM_1B84H;
        volatile UINT16 MEM_1B88L;
        volatile UINT16 MEM_1B88H;
        volatile UINT16 MEM_1B8CL;
        volatile UINT16 MEM_1B8CH;
        volatile UINT16 MEM_1B90L;
        volatile UINT16 MEM_1B90H;
        volatile UINT16 MEM_1B94L;
        volatile UINT16 MEM_1B94H;
        volatile UINT16 MEM_1B98L;
        volatile UINT16 MEM_1B98H;
        volatile UINT16 MEM_1B9CL;
        volatile UINT16 MEM_1B9CH;
        volatile UINT16 MEM_1BA0L;
        volatile UINT16 MEM_1BA0H;
        volatile UINT16 MEM_1BA4L;
        volatile UINT16 MEM_1BA4H;
        volatile UINT16 MEM_1BA8L;
        volatile UINT16 MEM_1BA8H;
        volatile UINT16 MEM_1BACL;
        volatile UINT16 MEM_1BACH;
        volatile UINT16 MEM_1BB0L;
        volatile UINT16 MEM_1BB0H;
        volatile UINT16 MEM_1BB4L;
        volatile UINT16 MEM_1BB4H;
        volatile UINT16 MEM_1BB8L;
        volatile UINT16 MEM_1BB8H;
        volatile UINT16 MEM_1BBCL;
        volatile UINT16 MEM_1BBCH;
        volatile UINT16 MEM_1BC0L;
        volatile UINT16 MEM_1BC0H;
        volatile UINT16 MEM_1BC4L;
        volatile UINT16 MEM_1BC4H;
        volatile UINT16 MEM_1BC8L;
        volatile UINT16 MEM_1BC8H;
        volatile UINT16 MEM_1BCCL;
        volatile UINT16 MEM_1BCCH;
        volatile UINT16 MEM_1BD0L;
        volatile UINT16 MEM_1BD0H;
        volatile UINT16 MEM_1BD4L;
        volatile UINT16 MEM_1BD4H;
        volatile UINT16 MEM_1BD8L;
        volatile UINT16 MEM_1BD8H;
        volatile UINT16 MEM_1BDCL;
        volatile UINT16 MEM_1BDCH;
        volatile UINT16 MEM_1BE0L;
        volatile UINT16 MEM_1BE0H;
        volatile UINT16 MEM_1BE4L;
        volatile UINT16 MEM_1BE4H;
        volatile UINT16 MEM_1BE8L;
        volatile UINT16 MEM_1BE8H;
        volatile UINT16 MEM_1BECL;
        volatile UINT16 MEM_1BECH;
        volatile UINT16 MEM_1BF0L;
        volatile UINT16 MEM_1BF0H;
        volatile UINT16 MEM_1BF4L;
        volatile UINT16 MEM_1BF4H;
        volatile UINT16 MEM_1BF8L;
        volatile UINT16 MEM_1BF8H;
        volatile UINT16 MEM_1BFCL;
        volatile UINT16 MEM_1BFCH;
        volatile UINT16 MEM_1C00L;
        volatile UINT16 MEM_1C00H;
        volatile UINT16 MEM_1C04L;
        volatile UINT16 MEM_1C04H;
        volatile UINT16 MEM_1C08L;
        volatile UINT16 MEM_1C08H;
        volatile UINT16 MEM_1C0CL;
        volatile UINT16 MEM_1C0CH;
        volatile UINT16 MEM_1C10L;
        volatile UINT16 MEM_1C10H;
        volatile UINT16 MEM_1C14L;
        volatile UINT16 MEM_1C14H;
        volatile UINT16 MEM_1C18L;
        volatile UINT16 MEM_1C18H;
        volatile UINT16 MEM_1C1CL;
        volatile UINT16 MEM_1C1CH;
        volatile UINT16 MEM_1C20L;
        volatile UINT16 MEM_1C20H;
        volatile UINT16 MEM_1C24L;
        volatile UINT16 MEM_1C24H;
        volatile UINT16 MEM_1C28L;
        volatile UINT16 MEM_1C28H;
        volatile UINT16 MEM_1C2CL;
        volatile UINT16 MEM_1C2CH;
        volatile UINT16 MEM_1C30L;
        volatile UINT16 MEM_1C30H;
        volatile UINT16 MEM_1C34L;
        volatile UINT16 MEM_1C34H;
        volatile UINT16 MEM_1C38L;
        volatile UINT16 MEM_1C38H;
        volatile UINT16 MEM_1C3CL;
        volatile UINT16 MEM_1C3CH;
        volatile UINT16 MEM_1C40L;
        volatile UINT16 MEM_1C40H;
        volatile UINT16 MEM_1C44L;
        volatile UINT16 MEM_1C44H;
        volatile UINT16 MEM_1C48L;
        volatile UINT16 MEM_1C48H;
        volatile UINT16 MEM_1C4CL;
        volatile UINT16 MEM_1C4CH;
        volatile UINT16 MEM_1C50L;
        volatile UINT16 MEM_1C50H;
        volatile UINT16 MEM_1C54L;
        volatile UINT16 MEM_1C54H;
        volatile UINT16 MEM_1C58L;
        volatile UINT16 MEM_1C58H;
        volatile UINT16 MEM_1C5CL;
        volatile UINT16 MEM_1C5CH;
        volatile UINT16 MEM_1C60L;
        volatile UINT16 MEM_1C60H;
        volatile UINT16 MEM_1C64L;
        volatile UINT16 MEM_1C64H;
        volatile UINT16 MEM_1C68L;
        volatile UINT16 MEM_1C68H;
        volatile UINT16 MEM_1C6CL;
        volatile UINT16 MEM_1C6CH;
        volatile UINT16 MEM_1C70L;
        volatile UINT16 MEM_1C70H;
        volatile UINT16 MEM_1C74L;
        volatile UINT16 MEM_1C74H;
        volatile UINT16 MEM_1C78L;
        volatile UINT16 MEM_1C78H;
        volatile UINT16 MEM_1C7CL;
        volatile UINT16 MEM_1C7CH;
        volatile UINT16 MEM_1C80L;
        volatile UINT16 MEM_1C80H;
        volatile UINT16 MEM_1C84L;
        volatile UINT16 MEM_1C84H;
        volatile UINT16 MEM_1C88L;
        volatile UINT16 MEM_1C88H;
        volatile UINT16 MEM_1C8CL;
        volatile UINT16 MEM_1C8CH;
        volatile UINT16 MEM_1C90L;
        volatile UINT16 MEM_1C90H;
        volatile UINT16 MEM_1C94L;
        volatile UINT16 MEM_1C94H;
        volatile UINT16 MEM_1C98L;
        volatile UINT16 MEM_1C98H;
        volatile UINT16 MEM_1C9CL;
        volatile UINT16 MEM_1C9CH;
        volatile UINT16 MEM_1CA0L;
        volatile UINT16 MEM_1CA0H;
        volatile UINT16 MEM_1CA4L;
        volatile UINT16 MEM_1CA4H;
        volatile UINT16 MEM_1CA8L;
        volatile UINT16 MEM_1CA8H;
        volatile UINT16 MEM_1CACL;
        volatile UINT16 MEM_1CACH;
        volatile UINT16 MEM_1CB0L;
        volatile UINT16 MEM_1CB0H;
        volatile UINT16 MEM_1CB4L;
        volatile UINT16 MEM_1CB4H;
        volatile UINT16 MEM_1CB8L;
        volatile UINT16 MEM_1CB8H;
        volatile UINT16 MEM_1CBCL;
        volatile UINT16 MEM_1CBCH;
        volatile UINT16 MEM_1CC0L;
        volatile UINT16 MEM_1CC0H;
        volatile UINT16 MEM_1CC4L;
        volatile UINT16 MEM_1CC4H;
        volatile UINT16 MEM_1CC8L;
        volatile UINT16 MEM_1CC8H;
        volatile UINT16 MEM_1CCCL;
        volatile UINT16 MEM_1CCCH;
        volatile UINT16 MEM_1CD0L;
        volatile UINT16 MEM_1CD0H;
        volatile UINT16 MEM_1CD4L;
        volatile UINT16 MEM_1CD4H;
        volatile UINT16 MEM_1CD8L;
        volatile UINT16 MEM_1CD8H;
        volatile UINT16 MEM_1CDCL;
        volatile UINT16 MEM_1CDCH;
        volatile UINT16 MEM_1CE0L;
        volatile UINT16 MEM_1CE0H;
        volatile UINT16 MEM_1CE4L;
        volatile UINT16 MEM_1CE4H;
        volatile UINT16 MEM_1CE8L;
        volatile UINT16 MEM_1CE8H;
        volatile UINT16 MEM_1CECL;
        volatile UINT16 MEM_1CECH;
        volatile UINT16 MEM_1CF0L;
        volatile UINT16 MEM_1CF0H;
        volatile UINT16 MEM_1CF4L;
        volatile UINT16 MEM_1CF4H;
        volatile UINT16 MEM_1CF8L;
        volatile UINT16 MEM_1CF8H;
        volatile UINT16 MEM_1CFCL;
        volatile UINT16 MEM_1CFCH;
        volatile UINT16 MEM_1D00L;
        volatile UINT16 MEM_1D00H;
        volatile UINT16 MEM_1D04L;
        volatile UINT16 MEM_1D04H;
        volatile UINT16 MEM_1D08L;
        volatile UINT16 MEM_1D08H;
        volatile UINT16 MEM_1D0CL;
        volatile UINT16 MEM_1D0CH;
        volatile UINT16 MEM_1D10L;
        volatile UINT16 MEM_1D10H;
        volatile UINT16 MEM_1D14L;
        volatile UINT16 MEM_1D14H;
        volatile UINT16 MEM_1D18L;
        volatile UINT16 MEM_1D18H;
        volatile UINT16 MEM_1D1CL;
        volatile UINT16 MEM_1D1CH;
        volatile UINT16 MEM_1D20L;
        volatile UINT16 MEM_1D20H;
        volatile UINT16 MEM_1D24L;
        volatile UINT16 MEM_1D24H;
        volatile UINT16 MEM_1D28L;
        volatile UINT16 MEM_1D28H;
        volatile UINT16 MEM_1D2CL;
        volatile UINT16 MEM_1D2CH;
        volatile UINT16 MEM_1D30L;
        volatile UINT16 MEM_1D30H;
        volatile UINT16 MEM_1D34L;
        volatile UINT16 MEM_1D34H;
        volatile UINT16 MEM_1D38L;
        volatile UINT16 MEM_1D38H;
        volatile UINT16 MEM_1D3CL;
        volatile UINT16 MEM_1D3CH;
        volatile UINT16 MEM_1D40L;
        volatile UINT16 MEM_1D40H;
        volatile UINT16 MEM_1D44L;
        volatile UINT16 MEM_1D44H;
        volatile UINT16 MEM_1D48L;
        volatile UINT16 MEM_1D48H;
        volatile UINT16 MEM_1D4CL;
        volatile UINT16 MEM_1D4CH;
        volatile UINT16 MEM_1D50L;
        volatile UINT16 MEM_1D50H;
        volatile UINT16 MEM_1D54L;
        volatile UINT16 MEM_1D54H;
        volatile UINT16 MEM_1D58L;
        volatile UINT16 MEM_1D58H;
        volatile UINT16 MEM_1D5CL;
        volatile UINT16 MEM_1D5CH;
        volatile UINT16 MEM_1D60L;
        volatile UINT16 MEM_1D60H;
        volatile UINT16 MEM_1D64L;
        volatile UINT16 MEM_1D64H;
        volatile UINT16 MEM_1D68L;
        volatile UINT16 MEM_1D68H;
        volatile UINT16 MEM_1D6CL;
        volatile UINT16 MEM_1D6CH;
        volatile UINT16 MEM_1D70L;
        volatile UINT16 MEM_1D70H;
        volatile UINT16 MEM_1D74L;
        volatile UINT16 MEM_1D74H;
        volatile UINT16 MEM_1D78L;
        volatile UINT16 MEM_1D78H;
        volatile UINT16 MEM_1D7CL;
        volatile UINT16 MEM_1D7CH;
        volatile UINT16 MEM_1D80L;
        volatile UINT16 MEM_1D80H;
        volatile UINT16 MEM_1D84L;
        volatile UINT16 MEM_1D84H;
        volatile UINT16 MEM_1D88L;
        volatile UINT16 MEM_1D88H;
        volatile UINT16 MEM_1D8CL;
        volatile UINT16 MEM_1D8CH;
        volatile UINT16 MEM_1D90L;
        volatile UINT16 MEM_1D90H;
        volatile UINT16 MEM_1D94L;
        volatile UINT16 MEM_1D94H;
        volatile UINT16 MEM_1D98L;
        volatile UINT16 MEM_1D98H;
        volatile UINT16 MEM_1D9CL;
        volatile UINT16 MEM_1D9CH;
        volatile UINT16 MEM_1DA0L;
        volatile UINT16 MEM_1DA0H;
        volatile UINT16 MEM_1DA4L;
        volatile UINT16 MEM_1DA4H;
        volatile UINT16 MEM_1DA8L;
        volatile UINT16 MEM_1DA8H;
        volatile UINT16 MEM_1DACL;
        volatile UINT16 MEM_1DACH;
        volatile UINT16 MEM_1DB0L;
        volatile UINT16 MEM_1DB0H;
        volatile UINT16 MEM_1DB4L;
        volatile UINT16 MEM_1DB4H;
        volatile UINT16 MEM_1DB8L;
        volatile UINT16 MEM_1DB8H;
        volatile UINT16 MEM_1DBCL;
        volatile UINT16 MEM_1DBCH;
        volatile UINT16 MEM_1DC0L;
        volatile UINT16 MEM_1DC0H;
        volatile UINT16 MEM_1DC4L;
        volatile UINT16 MEM_1DC4H;
        volatile UINT16 MEM_1DC8L;
        volatile UINT16 MEM_1DC8H;
        volatile UINT16 MEM_1DCCL;
        volatile UINT16 MEM_1DCCH;
        volatile UINT16 MEM_1DD0L;
        volatile UINT16 MEM_1DD0H;
        volatile UINT16 MEM_1DD4L;
        volatile UINT16 MEM_1DD4H;
        volatile UINT16 MEM_1DD8L;
        volatile UINT16 MEM_1DD8H;
        volatile UINT16 MEM_1DDCL;
        volatile UINT16 MEM_1DDCH;
        volatile UINT16 MEM_1DE0L;
        volatile UINT16 MEM_1DE0H;
        volatile UINT16 MEM_1DE4L;
        volatile UINT16 MEM_1DE4H;
        volatile UINT16 MEM_1DE8L;
        volatile UINT16 MEM_1DE8H;
        volatile UINT16 MEM_1DECL;
        volatile UINT16 MEM_1DECH;
        volatile UINT16 MEM_1DF0L;
        volatile UINT16 MEM_1DF0H;
        volatile UINT16 MEM_1DF4L;
        volatile UINT16 MEM_1DF4H;
        volatile UINT16 MEM_1DF8L;
        volatile UINT16 MEM_1DF8H;
        volatile UINT16 MEM_1DFCL;
        volatile UINT16 MEM_1DFCH;
        volatile UINT16 SRM_CWL;
        volatile UINT16 SRM_CWH;
        volatile UINT16 EFUSE0L;
        volatile UINT16 EFUSE0H;
        volatile UINT16 EFUSE1L;
        volatile UINT16 EFUSE1H;
        volatile UINT16 RX_DATAL;
        volatile UINT16 RX_DATAH;
        volatile UINT16 TX_DATAL;
        volatile UINT16 TX_DATAH;
        volatile UINT16 DBBIFL;
        volatile UINT16 DBBIFH;
        volatile UINT16 RX_PTR_START_END_ADDRL;
        volatile UINT16 RX_PTR_START_END_ADDRH;
        volatile UINT16 TX_PTR_START_END_ADDRL;
        volatile UINT16 TX_PTR_START_END_ADDRH;
        volatile UINT16 IRQ_CNTL;
        volatile UINT16 IRQ_CNTH;
        volatile UINT16 DRXIF_CWL;
        volatile UINT16 DRXIF_CWH;
        volatile UINT16 ARX_CW_PTRL;
        volatile UINT16 ARX_CW_PTRH;
        volatile UINT16 MEM_1E2CL;
        volatile UINT16 MEM_1E2CH;
        volatile UINT16 ANA_LO_TX_ENL;
        volatile UINT16 ANA_LO_TX_ENH;
        volatile UINT16 ANA_USDL;
        volatile UINT16 ANA_USDH;
        volatile UINT16 ANA_DCOL;
        volatile UINT16 ANA_DCOH;
        volatile UINT16 ANA_DPLLGENL;
        volatile UINT16 ANA_DPLLGENH;
        volatile UINT16 ANA_PPAL;
        volatile UINT16 ANA_PPAH;
        volatile UINT16 ANA_LDO_OSCL;
        volatile UINT16 ANA_LDO_OSCH;
        volatile UINT16 ANA_LDO_RFIOL;
        volatile UINT16 ANA_LDO_RFIOH;
        volatile UINT16 ANA_LDO_DCXOL;
        volatile UINT16 ANA_LDO_DCXOH;
        volatile UINT16 ANA_LDO_AL;
        volatile UINT16 ANA_LDO_AH;
        volatile UINT16 ANA_REFSYSL;
        volatile UINT16 ANA_REFSYSH;
        volatile UINT16 ANA_SAML;
        volatile UINT16 ANA_SAMH;
        volatile UINT16 ANA_BGAPL;
        volatile UINT16 ANA_BGAPH;
        volatile UINT16 ANA_DCXOL;
        volatile UINT16 ANA_DCXOH;
        volatile UINT16 ANA_TSBUFL;
        volatile UINT16 ANA_TSBUFH;
        volatile UINT16 ANA_RESERVEDL;
        volatile UINT16 ANA_RESERVEDH;
        volatile UINT16 CALC_DATAL;
        volatile UINT16 CALC_DATAH;
        volatile UINT16 CALC_PTR_START_END_ADDRL;
        volatile UINT16 CALC_PTR_START_END_ADDRH;
        volatile UINT16 CALCIF_CWL;
        volatile UINT16 CALCIF_CWH;
        volatile UINT16 SRM_STATUSL;
        volatile UINT16 SRM_STATUSH;
        volatile UINT16 MEM_1E7CL;
        volatile UINT16 MEM_1E7CH;
        volatile UINT16 MEM_1E80L;
        volatile UINT16 MEM_1E80H;
        volatile UINT16 MEM_1E84L;
        volatile UINT16 MEM_1E84H;
        volatile UINT16 MEM_1E88L;
        volatile UINT16 MEM_1E88H;
        volatile UINT16 MEM_1E8CL;
        volatile UINT16 MEM_1E8CH;
        volatile UINT16 MEM_1E90L;
        volatile UINT16 MEM_1E90H;
        volatile UINT16 MEM_1E94L;
        volatile UINT16 MEM_1E94H;
        volatile UINT16 MEM_1E98L;
        volatile UINT16 MEM_1E98H;
        volatile UINT16 MEM_1E9CL;
        volatile UINT16 MEM_1E9CH;
        volatile UINT16 MEM_1EA0L;
        volatile UINT16 MEM_1EA0H;
        volatile UINT16 MEM_1EA4L;
        volatile UINT16 MEM_1EA4H;
        volatile UINT16 MEM_1EA8L;
        volatile UINT16 MEM_1EA8H;
        volatile UINT16 MEM_1EACL;
        volatile UINT16 MEM_1EACH;
        volatile UINT16 MEM_1EB0L;
        volatile UINT16 MEM_1EB0H;
        volatile UINT16 MEM_1EB4L;
        volatile UINT16 MEM_1EB4H;
        volatile UINT16 MEM_1EB8L;
        volatile UINT16 MEM_1EB8H;
        volatile UINT16 MEM_1EBCL;
        volatile UINT16 MEM_1EBCH;
        volatile UINT16 MEM_1EC0L;
        volatile UINT16 MEM_1EC0H;
        volatile UINT16 MEM_1EC4L;
        volatile UINT16 MEM_1EC4H;
        volatile UINT16 MEM_1EC8L;
        volatile UINT16 MEM_1EC8H;
        volatile UINT16 MEM_1ECCL;
        volatile UINT16 MEM_1ECCH;
        volatile UINT16 MEM_1ED0L;
        volatile UINT16 MEM_1ED0H;
        volatile UINT16 MEM_1ED4L;
        volatile UINT16 MEM_1ED4H;
        volatile UINT16 MEM_1ED8L;
        volatile UINT16 MEM_1ED8H;
        volatile UINT16 MEM_1EDCL;
        volatile UINT16 MEM_1EDCH;
        volatile UINT16 MEM_1EE0L;
        volatile UINT16 MEM_1EE0H;
        volatile UINT16 MEM_1EE4L;
        volatile UINT16 MEM_1EE4H;
        volatile UINT16 MEM_1EE8L;
        volatile UINT16 MEM_1EE8H;
        volatile UINT16 MEM_1EECL;
        volatile UINT16 MEM_1EECH;
        volatile UINT16 MEM_1EF0L;
        volatile UINT16 MEM_1EF0H;
        volatile UINT16 MEM_1EF4L;
        volatile UINT16 MEM_1EF4H;
        volatile UINT16 MEM_1EF8L;
        volatile UINT16 MEM_1EF8H;
        volatile UINT16 MEM_1EFCL;
        volatile UINT16 MEM_1EFCH;
        volatile UINT16 MEM_1F00L;
        volatile UINT16 MEM_1F00H;
        volatile UINT16 MEM_1F04L;
        volatile UINT16 MEM_1F04H;
        volatile UINT16 MEM_1F08L;
        volatile UINT16 MEM_1F08H;
        volatile UINT16 MEM_1F0CL;
        volatile UINT16 MEM_1F0CH;
        volatile UINT16 MEM_1F10L;
        volatile UINT16 MEM_1F10H;
        volatile UINT16 ANA_ATST_PINS_0L;
        volatile UINT16 ANA_ATST_PINS_0H;
        volatile UINT16 ANA_ATST_PINS_1L;
        volatile UINT16 ANA_ATST_PINS_1H;
        volatile UINT16 ANA_ATST_AFE_0L;
        volatile UINT16 ANA_ATST_AFE_0H;
        volatile UINT16 ANA_ATST_AFE_1L;
        volatile UINT16 ANA_ATST_AFE_1H;
        volatile UINT16 ANA_ATST_ABE_0L;
        volatile UINT16 ANA_ATST_ABE_0H;
        volatile UINT16 ANA_ATST_ABE_1L;
        volatile UINT16 ANA_ATST_ABE_1H;
        volatile UINT16 ANA_ADCREF_IL;
        volatile UINT16 ANA_ADCREF_IH;
        volatile UINT16 ANA_ADCREF_QL;
        volatile UINT16 ANA_ADCREF_QH;
        volatile UINT16 ANA_CTA_I_0L;
        volatile UINT16 ANA_CTA_I_0H;
        volatile UINT16 ANA_CTA_I_1L;
        volatile UINT16 ANA_CTA_I_1H;
        volatile UINT16 ANA_CTA_Q_0L;
        volatile UINT16 ANA_CTA_Q_0H;
        volatile UINT16 ANA_CTA_Q_1L;
        volatile UINT16 ANA_CTA_Q_1H;
        volatile UINT16 ANA_DCU_PCUL;
        volatile UINT16 ANA_DCU_PCUH;
        volatile UINT16 ANA_FBDAC_IL;
        volatile UINT16 ANA_FBDAC_IH;
        volatile UINT16 ANA_FBDAC_QL;
        volatile UINT16 ANA_FBDAC_QH;
        volatile UINT16 ANA_LNA_XBL;
        volatile UINT16 ANA_LNA_XBH;
        volatile UINT16 MEM_1F54L;
        volatile UINT16 MEM_1F54H;
        volatile UINT16 ANA_MIX_HB_IL;
        volatile UINT16 ANA_MIX_HB_IH;
        volatile UINT16 ANA_MIX_HB_QL;
        volatile UINT16 ANA_MIX_HB_QH;
        volatile UINT16 ANA_MIX_LB_IL;
        volatile UINT16 ANA_MIX_LB_IH;
        volatile UINT16 ANA_MIX_LB_QL;
        volatile UINT16 ANA_MIX_LB_QH;
        volatile UINT16 ANA_SCF_I_0L;
        volatile UINT16 ANA_SCF_I_0H;
        volatile UINT16 ANA_SCF_I_1L;
        volatile UINT16 ANA_SCF_I_1H;
        volatile UINT16 ANA_SCF_Q_0L;
        volatile UINT16 ANA_SCF_Q_0H;
        volatile UINT16 ANA_SCF_Q_1L;
        volatile UINT16 ANA_SCF_Q_1H;
        volatile UINT16 ANA_SDM_I_0L;
        volatile UINT16 ANA_SDM_I_0H;
        volatile UINT16 ANA_SDM_I_1L;
        volatile UINT16 ANA_SDM_I_1H;
        volatile UINT16 ANA_SDM_Q_0L;
        volatile UINT16 ANA_SDM_Q_0H;
        volatile UINT16 ANA_SDM_Q_1L;
        volatile UINT16 ANA_SDM_Q_1H;
        volatile UINT16 ANA_TA_XB_IL;
        volatile UINT16 ANA_TA_XB_IH;
        volatile UINT16 ANA_TA_XB_QL;
        volatile UINT16 ANA_TA_XB_QH;
        volatile UINT16 MEM_1F90L;
        volatile UINT16 MEM_1F90H;
        volatile UINT16 MEM_1F94L;
        volatile UINT16 MEM_1F94H;
        volatile UINT16 ANA_SCFVCML;
        volatile UINT16 ANA_SCFVCMH;
        volatile UINT16 MEM_1F9CL;
        volatile UINT16 MEM_1F9CH;
        volatile UINT16 MEM_1FA0L;
        volatile UINT16 MEM_1FA0H;
        volatile UINT16 MEM_1FA4L;
        volatile UINT16 MEM_1FA4H;
        volatile UINT16 MEM_1FA8L;
        volatile UINT16 MEM_1FA8H;
        volatile UINT16 MEM_1FACL;
        volatile UINT16 MEM_1FACH;
        volatile UINT16 MEM_1FB0L;
        volatile UINT16 MEM_1FB0H;
        volatile UINT16 MEM_1FB4L;
        volatile UINT16 MEM_1FB4H;
        volatile UINT16 MEM_1FB8L;
        volatile UINT16 MEM_1FB8H;
        volatile UINT16 MEM_1FBCL;
        volatile UINT16 MEM_1FBCH;
        volatile UINT16 MEM_1FC0L;
        volatile UINT16 MEM_1FC0H;
        volatile UINT16 MEM_1FC4L;
        volatile UINT16 MEM_1FC4H;
        volatile UINT16 MEM_1FC8L;
        volatile UINT16 MEM_1FC8H;
        volatile UINT16 MEM_1FCCL;
        volatile UINT16 MEM_1FCCH;
        volatile UINT16 MEM_1FD0L;
        volatile UINT16 MEM_1FD0H;
        volatile UINT16 MEM_1FD4L;
        volatile UINT16 MEM_1FD4H;
        volatile UINT16 MEM_1FD8L;
        volatile UINT16 MEM_1FD8H;
        volatile UINT16 MEM_1FDCL;
        volatile UINT16 MEM_1FDCH;
        volatile UINT16 MEM_1FE0L;
        volatile UINT16 MEM_1FE0H;
        volatile UINT16 MEM_1FE4L;
        volatile UINT16 MEM_1FE4H;
        volatile UINT16 MEM_1FE8L;
        volatile UINT16 MEM_1FE8H;
        volatile UINT16 MEM_1FECL;
        volatile UINT16 MEM_1FECH;
        volatile UINT16 MEM_1FF0L;
        volatile UINT16 MEM_1FF0H;
        volatile UINT16 MEM_1FF4L;
        volatile UINT16 MEM_1FF4H;
        volatile UINT16 ANA_RX_SPAREL;
        volatile UINT16 ANA_RX_SPAREH;
        volatile UINT16 ANA_RX_CONSTL;
        volatile UINT16 ANA_RX_CONSTH;
        volatile UINT16 MEM_2000L;
        volatile UINT16 MEM_2000H;
        volatile UINT16 MEM_2004L;
        volatile UINT16 MEM_2004H;
        volatile UINT16 MEM_2008L;
        volatile UINT16 MEM_2008H;
        volatile UINT16 MEM_200CL;
        volatile UINT16 MEM_200CH;
        volatile UINT16 MEM_2010L;
        volatile UINT16 MEM_2010H;
        volatile UINT16 MEM_2014L;
        volatile UINT16 MEM_2014H;
        volatile UINT16 MEM_2018L;
        volatile UINT16 MEM_2018H;
        volatile UINT16 MEM_201CL;
        volatile UINT16 MEM_201CH;
        volatile UINT16 MEM_2020L;
        volatile UINT16 MEM_2020H;
        volatile UINT16 MEM_2024L;
        volatile UINT16 MEM_2024H;
        volatile UINT16 MEM_2028L;
        volatile UINT16 MEM_2028H;
        volatile UINT16 MEM_202CL;
        volatile UINT16 MEM_202CH;
        volatile UINT16 MEM_2030L;
        volatile UINT16 MEM_2030H;
        volatile UINT16 MEM_2034L;
        volatile UINT16 MEM_2034H;
        volatile UINT16 MEM_2038L;
        volatile UINT16 MEM_2038H;
        volatile UINT16 MEM_203CL;
        volatile UINT16 MEM_203CH;
        volatile UINT16 MEM_2040L;
        volatile UINT16 MEM_2040H;
        volatile UINT16 MEM_2044L;
        volatile UINT16 MEM_2044H;
        volatile UINT16 MEM_2048L;
        volatile UINT16 MEM_2048H;
        volatile UINT16 MEM_204CL;
        volatile UINT16 MEM_204CH;
        volatile UINT16 MEM_2050L;
        volatile UINT16 MEM_2050H;
        volatile UINT16 MEM_2054L;
        volatile UINT16 MEM_2054H;
        volatile UINT16 MEM_2058L;
        volatile UINT16 MEM_2058H;
        volatile UINT16 MEM_205CL;
        volatile UINT16 MEM_205CH;
        volatile UINT16 MEM_2060L;
        volatile UINT16 MEM_2060H;
        volatile UINT16 MEM_2064L;
        volatile UINT16 MEM_2064H;
        volatile UINT16 MEM_2068L;
        volatile UINT16 MEM_2068H;
        volatile UINT16 MEM_206CL;
        volatile UINT16 MEM_206CH;
        volatile UINT16 MEM_2070L;
        volatile UINT16 MEM_2070H;
        volatile UINT16 MEM_2074L;
        volatile UINT16 MEM_2074H;
        volatile UINT16 MEM_2078L;
        volatile UINT16 MEM_2078H;
        volatile UINT16 MEM_207CL;
        volatile UINT16 MEM_207CH;
        volatile UINT16 MEM_2080L;
        volatile UINT16 MEM_2080H;
        volatile UINT16 MEM_2084L;
        volatile UINT16 MEM_2084H;
        volatile UINT16 MEM_2088L;
        volatile UINT16 MEM_2088H;
        volatile UINT16 MEM_208CL;
        volatile UINT16 MEM_208CH;
        volatile UINT16 MEM_2090L;
        volatile UINT16 MEM_2090H;
        volatile UINT16 MEM_2094L;
        volatile UINT16 MEM_2094H;
        volatile UINT16 MEM_2098L;
        volatile UINT16 MEM_2098H;
        volatile UINT16 MEM_209CL;
        volatile UINT16 MEM_209CH;
        volatile UINT16 MEM_20A0L;
        volatile UINT16 MEM_20A0H;
        volatile UINT16 MEM_20A4L;
        volatile UINT16 MEM_20A4H;
        volatile UINT16 MEM_20A8L;
        volatile UINT16 MEM_20A8H;
        volatile UINT16 MEM_20ACL;
        volatile UINT16 MEM_20ACH;
        volatile UINT16 MEM_20B0L;
        volatile UINT16 MEM_20B0H;
        volatile UINT16 MEM_20B4L;
        volatile UINT16 MEM_20B4H;
        volatile UINT16 MEM_20B8L;
        volatile UINT16 MEM_20B8H;
        volatile UINT16 MEM_20BCL;
        volatile UINT16 MEM_20BCH;
        volatile UINT16 MEM_20C0L;
        volatile UINT16 MEM_20C0H;
        volatile UINT16 MEM_20C4L;
        volatile UINT16 MEM_20C4H;
        volatile UINT16 MEM_20C8L;
        volatile UINT16 MEM_20C8H;
        volatile UINT16 MEM_20CCL;
        volatile UINT16 MEM_20CCH;
        volatile UINT16 MEM_20D0L;
        volatile UINT16 MEM_20D0H;
        volatile UINT16 MEM_20D4L;
        volatile UINT16 MEM_20D4H;
        volatile UINT16 MEM_20D8L;
        volatile UINT16 MEM_20D8H;
        volatile UINT16 MEM_20DCL;
        volatile UINT16 MEM_20DCH;
        volatile UINT16 MEM_20E0L;
        volatile UINT16 MEM_20E0H;
        volatile UINT16 MEM_20E4L;
        volatile UINT16 MEM_20E4H;
        volatile UINT16 MEM_20E8L;
        volatile UINT16 MEM_20E8H;
        volatile UINT16 MEM_20ECL;
        volatile UINT16 MEM_20ECH;
        volatile UINT16 MEM_20F0L;
        volatile UINT16 MEM_20F0H;
        volatile UINT16 MEM_20F4L;
        volatile UINT16 MEM_20F4H;
        volatile UINT16 MEM_20F8L;
        volatile UINT16 MEM_20F8H;
        volatile UINT16 MEM_20FCL;
        volatile UINT16 MEM_20FCH;
        volatile UINT16 MEM_2100L;
        volatile UINT16 MEM_2100H;
        volatile UINT16 MEM_2104L;
        volatile UINT16 MEM_2104H;
        volatile UINT16 MEM_2108L;
        volatile UINT16 MEM_2108H;
        volatile UINT16 MEM_210CL;
        volatile UINT16 MEM_210CH;
        volatile UINT16 MEM_2110L;
        volatile UINT16 MEM_2110H;
        volatile UINT16 MEM_2114L;
        volatile UINT16 MEM_2114H;
        volatile UINT16 MEM_2118L;
        volatile UINT16 MEM_2118H;
        volatile UINT16 MEM_211CL;
        volatile UINT16 MEM_211CH;
        volatile UINT16 MEM_2120L;
        volatile UINT16 MEM_2120H;
        volatile UINT16 MEM_2124L;
        volatile UINT16 MEM_2124H;
        volatile UINT16 MEM_2128L;
        volatile UINT16 MEM_2128H;
        volatile UINT16 MEM_212CL;
        volatile UINT16 MEM_212CH;
        volatile UINT16 MEM_2130L;
        volatile UINT16 MEM_2130H;
        volatile UINT16 MEM_2134L;
        volatile UINT16 MEM_2134H;
        volatile UINT16 MEM_2138L;
        volatile UINT16 MEM_2138H;
        volatile UINT16 MEM_213CL;
        volatile UINT16 MEM_213CH;
        volatile UINT16 MEM_2140L;
        volatile UINT16 MEM_2140H;
        volatile UINT16 MEM_2144L;
        volatile UINT16 MEM_2144H;
        volatile UINT16 MEM_2148L;
        volatile UINT16 MEM_2148H;
        volatile UINT16 MEM_214CL;
        volatile UINT16 MEM_214CH;
        volatile UINT16 MEM_2150L;
        volatile UINT16 MEM_2150H;
        volatile UINT16 MEM_2154L;
        volatile UINT16 MEM_2154H;
        volatile UINT16 MEM_2158L;
        volatile UINT16 MEM_2158H;
        volatile UINT16 MEM_215CL;
        volatile UINT16 MEM_215CH;
        volatile UINT16 MEM_2160L;
        volatile UINT16 MEM_2160H;
        volatile UINT16 MEM_2164L;
        volatile UINT16 MEM_2164H;
        volatile UINT16 MEM_2168L;
        volatile UINT16 MEM_2168H;
        volatile UINT16 MEM_216CL;
        volatile UINT16 MEM_216CH;
        volatile UINT16 MEM_2170L;
        volatile UINT16 MEM_2170H;
        volatile UINT16 MEM_2174L;
        volatile UINT16 MEM_2174H;
        volatile UINT16 MEM_2178L;
        volatile UINT16 MEM_2178H;
        volatile UINT16 MEM_217CL;
        volatile UINT16 MEM_217CH;
        volatile UINT16 MEM_2180L;
        volatile UINT16 MEM_2180H;
        volatile UINT16 MEM_2184L;
        volatile UINT16 MEM_2184H;
        volatile UINT16 MEM_2188L;
        volatile UINT16 MEM_2188H;
        volatile UINT16 MEM_218CL;
        volatile UINT16 MEM_218CH;
        volatile UINT16 MEM_2190L;
        volatile UINT16 MEM_2190H;
        volatile UINT16 MEM_2194L;
        volatile UINT16 MEM_2194H;
        volatile UINT16 MEM_2198L;
        volatile UINT16 MEM_2198H;
        volatile UINT16 MEM_219CL;
        volatile UINT16 MEM_219CH;
        volatile UINT16 MEM_21A0L;
        volatile UINT16 MEM_21A0H;
        volatile UINT16 MEM_21A4L;
        volatile UINT16 MEM_21A4H;
        volatile UINT16 MEM_21A8L;
        volatile UINT16 MEM_21A8H;
        volatile UINT16 MEM_21ACL;
        volatile UINT16 MEM_21ACH;
        volatile UINT16 MEM_21B0L;
        volatile UINT16 MEM_21B0H;
        volatile UINT16 MEM_21B4L;
        volatile UINT16 MEM_21B4H;
        volatile UINT16 MEM_21B8L;
        volatile UINT16 MEM_21B8H;
        volatile UINT16 MEM_21BCL;
        volatile UINT16 MEM_21BCH;
        volatile UINT16 MEM_21C0L;
        volatile UINT16 MEM_21C0H;
        volatile UINT16 MEM_21C4L;
        volatile UINT16 MEM_21C4H;
        volatile UINT16 MEM_21C8L;
        volatile UINT16 MEM_21C8H;
        volatile UINT16 MEM_21CCL;
        volatile UINT16 MEM_21CCH;
        volatile UINT16 MEM_21D0L;
        volatile UINT16 MEM_21D0H;
        volatile UINT16 MEM_21D4L;
        volatile UINT16 MEM_21D4H;
        volatile UINT16 MEM_21D8L;
        volatile UINT16 MEM_21D8H;
        volatile UINT16 MEM_21DCL;
        volatile UINT16 MEM_21DCH;
        volatile UINT16 MEM_21E0L;
        volatile UINT16 MEM_21E0H;
        volatile UINT16 MEM_21E4L;
        volatile UINT16 MEM_21E4H;
        volatile UINT16 MEM_21E8L;
        volatile UINT16 MEM_21E8H;
        volatile UINT16 MEM_21ECL;
        volatile UINT16 MEM_21ECH;
        volatile UINT16 MEM_21F0L;
        volatile UINT16 MEM_21F0H;
        volatile UINT16 MEM_21F4L;
        volatile UINT16 MEM_21F4H;
        volatile UINT16 MEM_21F8L;
        volatile UINT16 MEM_21F8H;
        volatile UINT16 MEM_21FCL;
        volatile UINT16 MEM_21FCH;
        volatile UINT16 MEM_2200L;
        volatile UINT16 MEM_2200H;
        volatile UINT16 MEM_2204L;
        volatile UINT16 MEM_2204H;
        volatile UINT16 MEM_2208L;
        volatile UINT16 MEM_2208H;
        volatile UINT16 MEM_220CL;
        volatile UINT16 MEM_220CH;
        volatile UINT16 MEM_2210L;
        volatile UINT16 MEM_2210H;
        volatile UINT16 MEM_2214L;
        volatile UINT16 MEM_2214H;
        volatile UINT16 MEM_2218L;
        volatile UINT16 MEM_2218H;
        volatile UINT16 MEM_221CL;
        volatile UINT16 MEM_221CH;
        volatile UINT16 MEM_2220L;
        volatile UINT16 MEM_2220H;
        volatile UINT16 MEM_2224L;
        volatile UINT16 MEM_2224H;
        volatile UINT16 MEM_2228L;
        volatile UINT16 MEM_2228H;
        volatile UINT16 MEM_222CL;
        volatile UINT16 MEM_222CH;
        volatile UINT16 MEM_2230L;
        volatile UINT16 MEM_2230H;
        volatile UINT16 MEM_2234L;
        volatile UINT16 MEM_2234H;
        volatile UINT16 MEM_2238L;
        volatile UINT16 MEM_2238H;
        volatile UINT16 MEM_223CL;
        volatile UINT16 MEM_223CH;
        volatile UINT16 MEM_2240L;
        volatile UINT16 MEM_2240H;
        volatile UINT16 MEM_2244L;
        volatile UINT16 MEM_2244H;
        volatile UINT16 MEM_2248L;
        volatile UINT16 MEM_2248H;
        volatile UINT16 MEM_224CL;
        volatile UINT16 MEM_224CH;
        volatile UINT16 MEM_2250L;
        volatile UINT16 MEM_2250H;
        volatile UINT16 MEM_2254L;
        volatile UINT16 MEM_2254H;
        volatile UINT16 MEM_2258L;
        volatile UINT16 MEM_2258H;
        volatile UINT16 MEM_225CL;
        volatile UINT16 MEM_225CH;
        volatile UINT16 MEM_2260L;
        volatile UINT16 MEM_2260H;
        volatile UINT16 MEM_2264L;
        volatile UINT16 MEM_2264H;
        volatile UINT16 MEM_2268L;
        volatile UINT16 MEM_2268H;
        volatile UINT16 MEM_226CL;
        volatile UINT16 MEM_226CH;
        volatile UINT16 MEM_2270L;
        volatile UINT16 MEM_2270H;
        volatile UINT16 MEM_2274L;
        volatile UINT16 MEM_2274H;
        volatile UINT16 MEM_2278L;
        volatile UINT16 MEM_2278H;
        volatile UINT16 MEM_227CL;
        volatile UINT16 MEM_227CH;
        volatile UINT16 MEM_2280L;
        volatile UINT16 MEM_2280H;
        volatile UINT16 MEM_2284L;
        volatile UINT16 MEM_2284H;
        volatile UINT16 MEM_2288L;
        volatile UINT16 MEM_2288H;
        volatile UINT16 MEM_228CL;
        volatile UINT16 MEM_228CH;
        volatile UINT16 MEM_2290L;
        volatile UINT16 MEM_2290H;
        volatile UINT16 MEM_2294L;
        volatile UINT16 MEM_2294H;
        volatile UINT16 MEM_2298L;
        volatile UINT16 MEM_2298H;
        volatile UINT16 MEM_229CL;
        volatile UINT16 MEM_229CH;
        volatile UINT16 MEM_22A0L;
        volatile UINT16 MEM_22A0H;
        volatile UINT16 MEM_22A4L;
        volatile UINT16 MEM_22A4H;
        volatile UINT16 MEM_22A8L;
        volatile UINT16 MEM_22A8H;
        volatile UINT16 MEM_22ACL;
        volatile UINT16 MEM_22ACH;
        volatile UINT16 MEM_22B0L;
        volatile UINT16 MEM_22B0H;
        volatile UINT16 MEM_22B4L;
        volatile UINT16 MEM_22B4H;
        volatile UINT16 MEM_22B8L;
        volatile UINT16 MEM_22B8H;
        volatile UINT16 MEM_22BCL;
        volatile UINT16 MEM_22BCH;
        volatile UINT16 MEM_22C0L;
        volatile UINT16 MEM_22C0H;
        volatile UINT16 MEM_22C4L;
        volatile UINT16 MEM_22C4H;
        volatile UINT16 MEM_22C8L;
        volatile UINT16 MEM_22C8H;
        volatile UINT16 MEM_22CCL;
        volatile UINT16 MEM_22CCH;
        volatile UINT16 MEM_22D0L;
        volatile UINT16 MEM_22D0H;
        volatile UINT16 MEM_22D4L;
        volatile UINT16 MEM_22D4H;
        volatile UINT16 MEM_22D8L;
        volatile UINT16 MEM_22D8H;
        volatile UINT16 MEM_22DCL;
        volatile UINT16 MEM_22DCH;
        volatile UINT16 MEM_22E0L;
        volatile UINT16 MEM_22E0H;
        volatile UINT16 MEM_22E4L;
        volatile UINT16 MEM_22E4H;
        volatile UINT16 MEM_22E8L;
        volatile UINT16 MEM_22E8H;
        volatile UINT16 MEM_22ECL;
        volatile UINT16 MEM_22ECH;
        volatile UINT16 MEM_22F0L;
        volatile UINT16 MEM_22F0H;
        volatile UINT16 MEM_22F4L;
        volatile UINT16 MEM_22F4H;
        volatile UINT16 MEM_22F8L;
        volatile UINT16 MEM_22F8H;
        volatile UINT16 MEM_22FCL;
        volatile UINT16 MEM_22FCH;
        volatile UINT16 MEM_2300L;
        volatile UINT16 MEM_2300H;
        volatile UINT16 MEM_2304L;
        volatile UINT16 MEM_2304H;
        volatile UINT16 MEM_2308L;
        volatile UINT16 MEM_2308H;
        volatile UINT16 MEM_230CL;
        volatile UINT16 MEM_230CH;
        volatile UINT16 MEM_2310L;
        volatile UINT16 MEM_2310H;
        volatile UINT16 MEM_2314L;
        volatile UINT16 MEM_2314H;
        volatile UINT16 MEM_2318L;
        volatile UINT16 MEM_2318H;
        volatile UINT16 MEM_231CL;
        volatile UINT16 MEM_231CH;
        volatile UINT16 MEM_2320L;
        volatile UINT16 MEM_2320H;
        volatile UINT16 MEM_2324L;
        volatile UINT16 MEM_2324H;
        volatile UINT16 MEM_2328L;
        volatile UINT16 MEM_2328H;
        volatile UINT16 MEM_232CL;
        volatile UINT16 MEM_232CH;
        volatile UINT16 MEM_2330L;
        volatile UINT16 MEM_2330H;
        volatile UINT16 MEM_2334L;
        volatile UINT16 MEM_2334H;
        volatile UINT16 MEM_2338L;
        volatile UINT16 MEM_2338H;
        volatile UINT16 MEM_233CL;
        volatile UINT16 MEM_233CH;
        volatile UINT16 MEM_2340L;
        volatile UINT16 MEM_2340H;
        volatile UINT16 MEM_2344L;
        volatile UINT16 MEM_2344H;
        volatile UINT16 MEM_2348L;
        volatile UINT16 MEM_2348H;
        volatile UINT16 MEM_234CL;
        volatile UINT16 MEM_234CH;
        volatile UINT16 MEM_2350L;
        volatile UINT16 MEM_2350H;
        volatile UINT16 MEM_2354L;
        volatile UINT16 MEM_2354H;
        volatile UINT16 MEM_2358L;
        volatile UINT16 MEM_2358H;
        volatile UINT16 MEM_235CL;
        volatile UINT16 MEM_235CH;
        volatile UINT16 MEM_2360L;
        volatile UINT16 MEM_2360H;
        volatile UINT16 MEM_2364L;
        volatile UINT16 MEM_2364H;
        volatile UINT16 MEM_2368L;
        volatile UINT16 MEM_2368H;
        volatile UINT16 MEM_236CL;
        volatile UINT16 MEM_236CH;
        volatile UINT16 MEM_2370L;
        volatile UINT16 MEM_2370H;
        volatile UINT16 MEM_2374L;
        volatile UINT16 MEM_2374H;
        volatile UINT16 MEM_2378L;
        volatile UINT16 MEM_2378H;
        volatile UINT16 MEM_237CL;
        volatile UINT16 MEM_237CH;
        volatile UINT16 MEM_2380L;
        volatile UINT16 MEM_2380H;
        volatile UINT16 MEM_2384L;
        volatile UINT16 MEM_2384H;
        volatile UINT16 MEM_2388L;
        volatile UINT16 MEM_2388H;
        volatile UINT16 MEM_238CL;
        volatile UINT16 MEM_238CH;
        volatile UINT16 MEM_2390L;
        volatile UINT16 MEM_2390H;
        volatile UINT16 MEM_2394L;
        volatile UINT16 MEM_2394H;
        volatile UINT16 MEM_2398L;
        volatile UINT16 MEM_2398H;
        volatile UINT16 MEM_239CL;
        volatile UINT16 MEM_239CH;
        volatile UINT16 MEM_23A0L;
        volatile UINT16 MEM_23A0H;
        volatile UINT16 MEM_23A4L;
        volatile UINT16 MEM_23A4H;
        volatile UINT16 MEM_23A8L;
        volatile UINT16 MEM_23A8H;
        volatile UINT16 MEM_23ACL;
        volatile UINT16 MEM_23ACH;
        volatile UINT16 MEM_23B0L;
        volatile UINT16 MEM_23B0H;
        volatile UINT16 MEM_23B4L;
        volatile UINT16 MEM_23B4H;
        volatile UINT16 MEM_23B8L;
        volatile UINT16 MEM_23B8H;
        volatile UINT16 MEM_23BCL;
        volatile UINT16 MEM_23BCH;
        volatile UINT16 MEM_23C0L;
        volatile UINT16 MEM_23C0H;
        volatile UINT16 MEM_23C4L;
        volatile UINT16 MEM_23C4H;
        volatile UINT16 MEM_23C8L;
        volatile UINT16 MEM_23C8H;
        volatile UINT16 MEM_23CCL;
        volatile UINT16 MEM_23CCH;
        volatile UINT16 MEM_23D0L;
        volatile UINT16 MEM_23D0H;
        volatile UINT16 MEM_23D4L;
        volatile UINT16 MEM_23D4H;
        volatile UINT16 MEM_23D8L;
        volatile UINT16 MEM_23D8H;
        volatile UINT16 MEM_23DCL;
        volatile UINT16 MEM_23DCH;
        volatile UINT16 MEM_23E0L;
        volatile UINT16 MEM_23E0H;
        volatile UINT16 MEM_23E4L;
        volatile UINT16 MEM_23E4H;
        volatile UINT16 MEM_23E8L;
        volatile UINT16 MEM_23E8H;
        volatile UINT16 MEM_23ECL;
        volatile UINT16 MEM_23ECH;
        volatile UINT16 MEM_23F0L;
        volatile UINT16 MEM_23F0H;
        volatile UINT16 MEM_23F4L;
        volatile UINT16 MEM_23F4H;
        volatile UINT16 MEM_23F8L;
        volatile UINT16 MEM_23F8H;
        volatile UINT16 MEM_23FCL;
        volatile UINT16 MEM_23FCH;
        volatile UINT16 MEM_2400L;
        volatile UINT16 MEM_2400H;
        volatile UINT16 MEM_2404L;
        volatile UINT16 MEM_2404H;
        volatile UINT16 MEM_2408L;
        volatile UINT16 MEM_2408H;
        volatile UINT16 MEM_240CL;
        volatile UINT16 MEM_240CH;
        volatile UINT16 MEM_2410L;
        volatile UINT16 MEM_2410H;
        volatile UINT16 MEM_2414L;
        volatile UINT16 MEM_2414H;
        volatile UINT16 MEM_2418L;
        volatile UINT16 MEM_2418H;
        volatile UINT16 MEM_241CL;
        volatile UINT16 MEM_241CH;
        volatile UINT16 MEM_2420L;
        volatile UINT16 MEM_2420H;
        volatile UINT16 MEM_2424L;
        volatile UINT16 MEM_2424H;
        volatile UINT16 MEM_2428L;
        volatile UINT16 MEM_2428H;
        volatile UINT16 MEM_242CL;
        volatile UINT16 MEM_242CH;
        volatile UINT16 MEM_2430L;
        volatile UINT16 MEM_2430H;
        volatile UINT16 MEM_2434L;
        volatile UINT16 MEM_2434H;
        volatile UINT16 MEM_2438L;
        volatile UINT16 MEM_2438H;
        volatile UINT16 MEM_243CL;
        volatile UINT16 MEM_243CH;
        volatile UINT16 MEM_2440L;
        volatile UINT16 MEM_2440H;
        volatile UINT16 MEM_2444L;
        volatile UINT16 MEM_2444H;
        volatile UINT16 MEM_2448L;
        volatile UINT16 MEM_2448H;
        volatile UINT16 MEM_244CL;
        volatile UINT16 MEM_244CH;
        volatile UINT16 MEM_2450L;
        volatile UINT16 MEM_2450H;
        volatile UINT16 MEM_2454L;
        volatile UINT16 MEM_2454H;
        volatile UINT16 MEM_2458L;
        volatile UINT16 MEM_2458H;
        volatile UINT16 MEM_245CL;
        volatile UINT16 MEM_245CH;
        volatile UINT16 MEM_2460L;
        volatile UINT16 MEM_2460H;
        volatile UINT16 MEM_2464L;
        volatile UINT16 MEM_2464H;
        volatile UINT16 MEM_2468L;
        volatile UINT16 MEM_2468H;
        volatile UINT16 MEM_246CL;
        volatile UINT16 MEM_246CH;
        volatile UINT16 MEM_2470L;
        volatile UINT16 MEM_2470H;
        volatile UINT16 MEM_2474L;
        volatile UINT16 MEM_2474H;
        volatile UINT16 MEM_2478L;
        volatile UINT16 MEM_2478H;
        volatile UINT16 MEM_247CL;
        volatile UINT16 MEM_247CH;
        volatile UINT16 MEM_2480L;
        volatile UINT16 MEM_2480H;
        volatile UINT16 MEM_2484L;
        volatile UINT16 MEM_2484H;
        volatile UINT16 MEM_2488L;
        volatile UINT16 MEM_2488H;
        volatile UINT16 MEM_248CL;
        volatile UINT16 MEM_248CH;
        volatile UINT16 MEM_2490L;
        volatile UINT16 MEM_2490H;
        volatile UINT16 MEM_2494L;
        volatile UINT16 MEM_2494H;
        volatile UINT16 MEM_2498L;
        volatile UINT16 MEM_2498H;
        volatile UINT16 MEM_249CL;
        volatile UINT16 MEM_249CH;
        volatile UINT16 MEM_24A0L;
        volatile UINT16 MEM_24A0H;
        volatile UINT16 MEM_24A4L;
        volatile UINT16 MEM_24A4H;
        volatile UINT16 MEM_24A8L;
        volatile UINT16 MEM_24A8H;
        volatile UINT16 MEM_24ACL;
        volatile UINT16 MEM_24ACH;
        volatile UINT16 MEM_24B0L;
        volatile UINT16 MEM_24B0H;
        volatile UINT16 MEM_24B4L;
        volatile UINT16 MEM_24B4H;
        volatile UINT16 MEM_24B8L;
        volatile UINT16 MEM_24B8H;
        volatile UINT16 MEM_24BCL;
        volatile UINT16 MEM_24BCH;
        volatile UINT16 MEM_24C0L;
        volatile UINT16 MEM_24C0H;
        volatile UINT16 MEM_24C4L;
        volatile UINT16 MEM_24C4H;
        volatile UINT16 MEM_24C8L;
        volatile UINT16 MEM_24C8H;
        volatile UINT16 MEM_24CCL;
        volatile UINT16 MEM_24CCH;
        volatile UINT16 MEM_24D0L;
        volatile UINT16 MEM_24D0H;
        volatile UINT16 MEM_24D4L;
        volatile UINT16 MEM_24D4H;
        volatile UINT16 MEM_24D8L;
        volatile UINT16 MEM_24D8H;
        volatile UINT16 MEM_24DCL;
        volatile UINT16 MEM_24DCH;
        volatile UINT16 MEM_24E0L;
        volatile UINT16 MEM_24E0H;
        volatile UINT16 MEM_24E4L;
        volatile UINT16 MEM_24E4H;
        volatile UINT16 MEM_24E8L;
        volatile UINT16 MEM_24E8H;
        volatile UINT16 MEM_24ECL;
        volatile UINT16 MEM_24ECH;
        volatile UINT16 MEM_24F0L;
        volatile UINT16 MEM_24F0H;
        volatile UINT16 MEM_24F4L;
        volatile UINT16 MEM_24F4H;
        volatile UINT16 MEM_24F8L;
        volatile UINT16 MEM_24F8H;
        volatile UINT16 MEM_24FCL;
        volatile UINT16 MEM_24FCH;
        volatile UINT16 MEM_2500L;
        volatile UINT16 MEM_2500H;
        volatile UINT16 MEM_2504L;
        volatile UINT16 MEM_2504H;
        volatile UINT16 MEM_2508L;
        volatile UINT16 MEM_2508H;
        volatile UINT16 MEM_250CL;
        volatile UINT16 MEM_250CH;
        volatile UINT16 MEM_2510L;
        volatile UINT16 MEM_2510H;
        volatile UINT16 MEM_2514L;
        volatile UINT16 MEM_2514H;
        volatile UINT16 MEM_2518L;
        volatile UINT16 MEM_2518H;
        volatile UINT16 MEM_251CL;
        volatile UINT16 MEM_251CH;
        volatile UINT16 MEM_2520L;
        volatile UINT16 MEM_2520H;
        volatile UINT16 MEM_2524L;
        volatile UINT16 MEM_2524H;
        volatile UINT16 MEM_2528L;
        volatile UINT16 MEM_2528H;
        volatile UINT16 MEM_252CL;
        volatile UINT16 MEM_252CH;
        volatile UINT16 MEM_2530L;
        volatile UINT16 MEM_2530H;
        volatile UINT16 MEM_2534L;
        volatile UINT16 MEM_2534H;
        volatile UINT16 MEM_2538L;
        volatile UINT16 MEM_2538H;
        volatile UINT16 MEM_253CL;
        volatile UINT16 MEM_253CH;
        volatile UINT16 MEM_2540L;
        volatile UINT16 MEM_2540H;
        volatile UINT16 MEM_2544L;
        volatile UINT16 MEM_2544H;
        volatile UINT16 MEM_2548L;
        volatile UINT16 MEM_2548H;
        volatile UINT16 MEM_254CL;
        volatile UINT16 MEM_254CH;
        volatile UINT16 MEM_2550L;
        volatile UINT16 MEM_2550H;
        volatile UINT16 MEM_2554L;
        volatile UINT16 MEM_2554H;
        volatile UINT16 MEM_2558L;
        volatile UINT16 MEM_2558H;
        volatile UINT16 MEM_255CL;
        volatile UINT16 MEM_255CH;
        volatile UINT16 MEM_2560L;
        volatile UINT16 MEM_2560H;
        volatile UINT16 MEM_2564L;
        volatile UINT16 MEM_2564H;
        volatile UINT16 MEM_2568L;
        volatile UINT16 MEM_2568H;
        volatile UINT16 MEM_256CL;
        volatile UINT16 MEM_256CH;
        volatile UINT16 MEM_2570L;
        volatile UINT16 MEM_2570H;
        volatile UINT16 MEM_2574L;
        volatile UINT16 MEM_2574H;
        volatile UINT16 MEM_2578L;
        volatile UINT16 MEM_2578H;
        volatile UINT16 MEM_257CL;
        volatile UINT16 MEM_257CH;
        volatile UINT16 MEM_2580L;
        volatile UINT16 MEM_2580H;
        volatile UINT16 MEM_2584L;
        volatile UINT16 MEM_2584H;
        volatile UINT16 MEM_2588L;
        volatile UINT16 MEM_2588H;
        volatile UINT16 MEM_258CL;
        volatile UINT16 MEM_258CH;
        volatile UINT16 MEM_2590L;
        volatile UINT16 MEM_2590H;
        volatile UINT16 MEM_2594L;
        volatile UINT16 MEM_2594H;
        volatile UINT16 MEM_2598L;
        volatile UINT16 MEM_2598H;
        volatile UINT16 MEM_259CL;
        volatile UINT16 MEM_259CH;
        volatile UINT16 MEM_25A0L;
        volatile UINT16 MEM_25A0H;
        volatile UINT16 MEM_25A4L;
        volatile UINT16 MEM_25A4H;
        volatile UINT16 MEM_25A8L;
        volatile UINT16 MEM_25A8H;
        volatile UINT16 MEM_25ACL;
        volatile UINT16 MEM_25ACH;
        volatile UINT16 MEM_25B0L;
        volatile UINT16 MEM_25B0H;
        volatile UINT16 MEM_25B4L;
        volatile UINT16 MEM_25B4H;
        volatile UINT16 MEM_25B8L;
        volatile UINT16 MEM_25B8H;
        volatile UINT16 MEM_25BCL;
        volatile UINT16 MEM_25BCH;
        volatile UINT16 MEM_25C0L;
        volatile UINT16 MEM_25C0H;
        volatile UINT16 MEM_25C4L;
        volatile UINT16 MEM_25C4H;
        volatile UINT16 MEM_25C8L;
        volatile UINT16 MEM_25C8H;
        volatile UINT16 MEM_25CCL;
        volatile UINT16 MEM_25CCH;
        volatile UINT16 MEM_25D0L;
        volatile UINT16 MEM_25D0H;
        volatile UINT16 MEM_25D4L;
        volatile UINT16 MEM_25D4H;
        volatile UINT16 MEM_25D8L;
        volatile UINT16 MEM_25D8H;
        volatile UINT16 MEM_25DCL;
        volatile UINT16 MEM_25DCH;
        volatile UINT16 MEM_25E0L;
        volatile UINT16 MEM_25E0H;
        volatile UINT16 MEM_25E4L;
        volatile UINT16 MEM_25E4H;
        volatile UINT16 MEM_25E8L;
        volatile UINT16 MEM_25E8H;
        volatile UINT16 MEM_25ECL;
        volatile UINT16 MEM_25ECH;
        volatile UINT16 MEM_25F0L;
        volatile UINT16 MEM_25F0H;
        volatile UINT16 MEM_25F4L;
        volatile UINT16 MEM_25F4H;
        volatile UINT16 MEM_25F8L;
        volatile UINT16 MEM_25F8H;
        volatile UINT16 MEM_25FCL;
        volatile UINT16 MEM_25FCH;
        volatile UINT16 MEM_2600L;
        volatile UINT16 MEM_2600H;
        volatile UINT16 MEM_2604L;
        volatile UINT16 MEM_2604H;
        volatile UINT16 MEM_2608L;
        volatile UINT16 MEM_2608H;
        volatile UINT16 MEM_260CL;
        volatile UINT16 MEM_260CH;
        volatile UINT16 MEM_2610L;
        volatile UINT16 MEM_2610H;
        volatile UINT16 MEM_2614L;
        volatile UINT16 MEM_2614H;
        volatile UINT16 MEM_2618L;
        volatile UINT16 MEM_2618H;
        volatile UINT16 MEM_261CL;
        volatile UINT16 MEM_261CH;
        volatile UINT16 MEM_2620L;
        volatile UINT16 MEM_2620H;
        volatile UINT16 MEM_2624L;
        volatile UINT16 MEM_2624H;
        volatile UINT16 MEM_2628L;
        volatile UINT16 MEM_2628H;
        volatile UINT16 MEM_262CL;
        volatile UINT16 MEM_262CH;
        volatile UINT16 MEM_2630L;
        volatile UINT16 MEM_2630H;
        volatile UINT16 MEM_2634L;
        volatile UINT16 MEM_2634H;
        volatile UINT16 MEM_2638L;
        volatile UINT16 MEM_2638H;
        volatile UINT16 MEM_263CL;
        volatile UINT16 MEM_263CH;
        volatile UINT16 MEM_2640L;
        volatile UINT16 MEM_2640H;
        volatile UINT16 MEM_2644L;
        volatile UINT16 MEM_2644H;
        volatile UINT16 MEM_2648L;
        volatile UINT16 MEM_2648H;
        volatile UINT16 MEM_264CL;
        volatile UINT16 MEM_264CH;
        volatile UINT16 MEM_2650L;
        volatile UINT16 MEM_2650H;
        volatile UINT16 MEM_2654L;
        volatile UINT16 MEM_2654H;
        volatile UINT16 MEM_2658L;
        volatile UINT16 MEM_2658H;
        volatile UINT16 MEM_265CL;
        volatile UINT16 MEM_265CH;
        volatile UINT16 MEM_2660L;
        volatile UINT16 MEM_2660H;
        volatile UINT16 MEM_2664L;
        volatile UINT16 MEM_2664H;
        volatile UINT16 MEM_2668L;
        volatile UINT16 MEM_2668H;
        volatile UINT16 MEM_266CL;
        volatile UINT16 MEM_266CH;
        volatile UINT16 MEM_2670L;
        volatile UINT16 MEM_2670H;
        volatile UINT16 MEM_2674L;
        volatile UINT16 MEM_2674H;
        volatile UINT16 MEM_2678L;
        volatile UINT16 MEM_2678H;
        volatile UINT16 MEM_267CL;
        volatile UINT16 MEM_267CH;
        volatile UINT16 MEM_2680L;
        volatile UINT16 MEM_2680H;
        volatile UINT16 MEM_2684L;
        volatile UINT16 MEM_2684H;
        volatile UINT16 MEM_2688L;
        volatile UINT16 MEM_2688H;
        volatile UINT16 MEM_268CL;
        volatile UINT16 MEM_268CH;
        volatile UINT16 MEM_2690L;
        volatile UINT16 MEM_2690H;
        volatile UINT16 MEM_2694L;
        volatile UINT16 MEM_2694H;
        volatile UINT16 MEM_2698L;
        volatile UINT16 MEM_2698H;
        volatile UINT16 MEM_269CL;
        volatile UINT16 MEM_269CH;
        volatile UINT16 MEM_26A0L;
        volatile UINT16 MEM_26A0H;
        volatile UINT16 MEM_26A4L;
        volatile UINT16 MEM_26A4H;
        volatile UINT16 MEM_26A8L;
        volatile UINT16 MEM_26A8H;
        volatile UINT16 MEM_26ACL;
        volatile UINT16 MEM_26ACH;
        volatile UINT16 MEM_26B0L;
        volatile UINT16 MEM_26B0H;
        volatile UINT16 MEM_26B4L;
        volatile UINT16 MEM_26B4H;
        volatile UINT16 MEM_26B8L;
        volatile UINT16 MEM_26B8H;
        volatile UINT16 MEM_26BCL;
        volatile UINT16 MEM_26BCH;
        volatile UINT16 MEM_26C0L;
        volatile UINT16 MEM_26C0H;
        volatile UINT16 MEM_26C4L;
        volatile UINT16 MEM_26C4H;
        volatile UINT16 MEM_26C8L;
        volatile UINT16 MEM_26C8H;
        volatile UINT16 MEM_26CCL;
        volatile UINT16 MEM_26CCH;
        volatile UINT16 MEM_26D0L;
        volatile UINT16 MEM_26D0H;
        volatile UINT16 MEM_26D4L;
        volatile UINT16 MEM_26D4H;
        volatile UINT16 MEM_26D8L;
        volatile UINT16 MEM_26D8H;
        volatile UINT16 MEM_26DCL;
        volatile UINT16 MEM_26DCH;
        volatile UINT16 MEM_26E0L;
        volatile UINT16 MEM_26E0H;
        volatile UINT16 MEM_26E4L;
        volatile UINT16 MEM_26E4H;
        volatile UINT16 MEM_26E8L;
        volatile UINT16 MEM_26E8H;
        volatile UINT16 MEM_26ECL;
        volatile UINT16 MEM_26ECH;
        volatile UINT16 MEM_26F0L;
        volatile UINT16 MEM_26F0H;
        volatile UINT16 MEM_26F4L;
        volatile UINT16 MEM_26F4H;
        volatile UINT16 MEM_26F8L;
        volatile UINT16 MEM_26F8H;
        volatile UINT16 MEM_26FCL;
        volatile UINT16 MEM_26FCH;
        volatile UINT16 MEM_2700L;
        volatile UINT16 MEM_2700H;
        volatile UINT16 MEM_2704L;
        volatile UINT16 MEM_2704H;
        volatile UINT16 MEM_2708L;
        volatile UINT16 MEM_2708H;
        volatile UINT16 MEM_270CL;
        volatile UINT16 MEM_270CH;
        volatile UINT16 MEM_2710L;
        volatile UINT16 MEM_2710H;
        volatile UINT16 MEM_2714L;
        volatile UINT16 MEM_2714H;
        volatile UINT16 MEM_2718L;
        volatile UINT16 MEM_2718H;
        volatile UINT16 MEM_271CL;
        volatile UINT16 MEM_271CH;
        volatile UINT16 MEM_2720L;
        volatile UINT16 MEM_2720H;
        volatile UINT16 MEM_2724L;
        volatile UINT16 MEM_2724H;
        volatile UINT16 MEM_2728L;
        volatile UINT16 MEM_2728H;
        volatile UINT16 MEM_272CL;
        volatile UINT16 MEM_272CH;
        volatile UINT16 MEM_2730L;
        volatile UINT16 MEM_2730H;
        volatile UINT16 MEM_2734L;
        volatile UINT16 MEM_2734H;
        volatile UINT16 MEM_2738L;
        volatile UINT16 MEM_2738H;
        volatile UINT16 MEM_273CL;
        volatile UINT16 MEM_273CH;
        volatile UINT16 MEM_2740L;
        volatile UINT16 MEM_2740H;
        volatile UINT16 MEM_2744L;
        volatile UINT16 MEM_2744H;
        volatile UINT16 MEM_2748L;
        volatile UINT16 MEM_2748H;
        volatile UINT16 MEM_274CL;
        volatile UINT16 MEM_274CH;
        volatile UINT16 MEM_2750L;
        volatile UINT16 MEM_2750H;
        volatile UINT16 MEM_2754L;
        volatile UINT16 MEM_2754H;
        volatile UINT16 MEM_2758L;
        volatile UINT16 MEM_2758H;
        volatile UINT16 MEM_275CL;
        volatile UINT16 MEM_275CH;
        volatile UINT16 MEM_2760L;
        volatile UINT16 MEM_2760H;
        volatile UINT16 MEM_2764L;
        volatile UINT16 MEM_2764H;
        volatile UINT16 MEM_2768L;
        volatile UINT16 MEM_2768H;
        volatile UINT16 MEM_276CL;
        volatile UINT16 MEM_276CH;
        volatile UINT16 MEM_2770L;
        volatile UINT16 MEM_2770H;
        volatile UINT16 MEM_2774L;
        volatile UINT16 MEM_2774H;
        volatile UINT16 MEM_2778L;
        volatile UINT16 MEM_2778H;
        volatile UINT16 MEM_277CL;
        volatile UINT16 MEM_277CH;
        volatile UINT16 MEM_2780L;
        volatile UINT16 MEM_2780H;
        volatile UINT16 MEM_2784L;
        volatile UINT16 MEM_2784H;
        volatile UINT16 MEM_2788L;
        volatile UINT16 MEM_2788H;
        volatile UINT16 MEM_278CL;
        volatile UINT16 MEM_278CH;
        volatile UINT16 MEM_2790L;
        volatile UINT16 MEM_2790H;
        volatile UINT16 MEM_2794L;
        volatile UINT16 MEM_2794H;
        volatile UINT16 MEM_2798L;
        volatile UINT16 MEM_2798H;
        volatile UINT16 MEM_279CL;
        volatile UINT16 MEM_279CH;
        volatile UINT16 MEM_27A0L;
        volatile UINT16 MEM_27A0H;
        volatile UINT16 MEM_27A4L;
        volatile UINT16 MEM_27A4H;
        volatile UINT16 MEM_27A8L;
        volatile UINT16 MEM_27A8H;
        volatile UINT16 MEM_27ACL;
        volatile UINT16 MEM_27ACH;
        volatile UINT16 MEM_27B0L;
        volatile UINT16 MEM_27B0H;
        volatile UINT16 MEM_27B4L;
        volatile UINT16 MEM_27B4H;
        volatile UINT16 MEM_27B8L;
        volatile UINT16 MEM_27B8H;
        volatile UINT16 MEM_27BCL;
        volatile UINT16 MEM_27BCH;
        volatile UINT16 MEM_27C0L;
        volatile UINT16 MEM_27C0H;
        volatile UINT16 MEM_27C4L;
        volatile UINT16 MEM_27C4H;
        volatile UINT16 MEM_27C8L;
        volatile UINT16 MEM_27C8H;
        volatile UINT16 MEM_27CCL;
        volatile UINT16 MEM_27CCH;
        volatile UINT16 MEM_27D0L;
        volatile UINT16 MEM_27D0H;
        volatile UINT16 MEM_27D4L;
        volatile UINT16 MEM_27D4H;
        volatile UINT16 MEM_27D8L;
        volatile UINT16 MEM_27D8H;
        volatile UINT16 MEM_27DCL;
        volatile UINT16 MEM_27DCH;
        volatile UINT16 MEM_27E0L;
        volatile UINT16 MEM_27E0H;
        volatile UINT16 MEM_27E4L;
        volatile UINT16 MEM_27E4H;
        volatile UINT16 MEM_27E8L;
        volatile UINT16 MEM_27E8H;
        volatile UINT16 MEM_27ECL;
        volatile UINT16 MEM_27ECH;
        volatile UINT16 MEM_27F0L;
        volatile UINT16 MEM_27F0H;
        volatile UINT16 MEM_27F4L;
        volatile UINT16 MEM_27F4H;
        volatile UINT16 MEM_27F8L;
        volatile UINT16 MEM_27F8H;
        volatile UINT16 MEM_27FCL;
        volatile UINT16 MEM_27FCH;
        volatile UINT16 MEM_2800L;
        volatile UINT16 MEM_2800H;
        volatile UINT16 MEM_2804L;
        volatile UINT16 MEM_2804H;
        volatile UINT16 MEM_2808L;
        volatile UINT16 MEM_2808H;
        volatile UINT16 MEM_280CL;
        volatile UINT16 MEM_280CH;
        volatile UINT16 MEM_2810L;
        volatile UINT16 MEM_2810H;
        volatile UINT16 MEM_2814L;
        volatile UINT16 MEM_2814H;
        volatile UINT16 MEM_2818L;
        volatile UINT16 MEM_2818H;
        volatile UINT16 MEM_281CL;
        volatile UINT16 MEM_281CH;
        volatile UINT16 MEM_2820L;
        volatile UINT16 MEM_2820H;
        volatile UINT16 MEM_2824L;
        volatile UINT16 MEM_2824H;
        volatile UINT16 MEM_2828L;
        volatile UINT16 MEM_2828H;
        volatile UINT16 MEM_282CL;
        volatile UINT16 MEM_282CH;
        volatile UINT16 MEM_2830L;
        volatile UINT16 MEM_2830H;
        volatile UINT16 MEM_2834L;
        volatile UINT16 MEM_2834H;
        volatile UINT16 MEM_2838L;
        volatile UINT16 MEM_2838H;
        volatile UINT16 MEM_283CL;
        volatile UINT16 MEM_283CH;
        volatile UINT16 MEM_2840L;
        volatile UINT16 MEM_2840H;
        volatile UINT16 MEM_2844L;
        volatile UINT16 MEM_2844H;
        volatile UINT16 MEM_2848L;
        volatile UINT16 MEM_2848H;
        volatile UINT16 MEM_284CL;
        volatile UINT16 MEM_284CH;
        volatile UINT16 MEM_2850L;
        volatile UINT16 MEM_2850H;
        volatile UINT16 MEM_2854L;
        volatile UINT16 MEM_2854H;
        volatile UINT16 MEM_2858L;
        volatile UINT16 MEM_2858H;
        volatile UINT16 MEM_285CL;
        volatile UINT16 MEM_285CH;
        volatile UINT16 MEM_2860L;
        volatile UINT16 MEM_2860H;
        volatile UINT16 MEM_2864L;
        volatile UINT16 MEM_2864H;
        volatile UINT16 MEM_2868L;
        volatile UINT16 MEM_2868H;
        volatile UINT16 MEM_286CL;
        volatile UINT16 MEM_286CH;
        volatile UINT16 MEM_2870L;
        volatile UINT16 MEM_2870H;
        volatile UINT16 MEM_2874L;
        volatile UINT16 MEM_2874H;
        volatile UINT16 MEM_2878L;
        volatile UINT16 MEM_2878H;
        volatile UINT16 MEM_287CL;
        volatile UINT16 MEM_287CH;
        volatile UINT16 MEM_2880L;
        volatile UINT16 MEM_2880H;
        volatile UINT16 MEM_2884L;
        volatile UINT16 MEM_2884H;
        volatile UINT16 MEM_2888L;
        volatile UINT16 MEM_2888H;
        volatile UINT16 MEM_288CL;
        volatile UINT16 MEM_288CH;
        volatile UINT16 MEM_2890L;
        volatile UINT16 MEM_2890H;
        volatile UINT16 MEM_2894L;
        volatile UINT16 MEM_2894H;
        volatile UINT16 MEM_2898L;
        volatile UINT16 MEM_2898H;
        volatile UINT16 MEM_289CL;
        volatile UINT16 MEM_289CH;
        volatile UINT16 MEM_28A0L;
        volatile UINT16 MEM_28A0H;
        volatile UINT16 MEM_28A4L;
        volatile UINT16 MEM_28A4H;
        volatile UINT16 MEM_28A8L;
        volatile UINT16 MEM_28A8H;
        volatile UINT16 MEM_28ACL;
        volatile UINT16 MEM_28ACH;
        volatile UINT16 MEM_28B0L;
        volatile UINT16 MEM_28B0H;
        volatile UINT16 MEM_28B4L;
        volatile UINT16 MEM_28B4H;
        volatile UINT16 MEM_28B8L;
        volatile UINT16 MEM_28B8H;
        volatile UINT16 MEM_28BCL;
        volatile UINT16 MEM_28BCH;
        volatile UINT16 MEM_28C0L;
        volatile UINT16 MEM_28C0H;
        volatile UINT16 MEM_28C4L;
        volatile UINT16 MEM_28C4H;
        volatile UINT16 MEM_28C8L;
        volatile UINT16 MEM_28C8H;
        volatile UINT16 MEM_28CCL;
        volatile UINT16 MEM_28CCH;
        volatile UINT16 MEM_28D0L;
        volatile UINT16 MEM_28D0H;
        volatile UINT16 MEM_28D4L;
        volatile UINT16 MEM_28D4H;
        volatile UINT16 MEM_28D8L;
        volatile UINT16 MEM_28D8H;
        volatile UINT16 MEM_28DCL;
        volatile UINT16 MEM_28DCH;
        volatile UINT16 MEM_28E0L;
        volatile UINT16 MEM_28E0H;
        volatile UINT16 MEM_28E4L;
        volatile UINT16 MEM_28E4H;
        volatile UINT16 MEM_28E8L;
        volatile UINT16 MEM_28E8H;
        volatile UINT16 MEM_28ECL;
        volatile UINT16 MEM_28ECH;
        volatile UINT16 MEM_28F0L;
        volatile UINT16 MEM_28F0H;
        volatile UINT16 MEM_28F4L;
        volatile UINT16 MEM_28F4H;
        volatile UINT16 MEM_28F8L;
        volatile UINT16 MEM_28F8H;
        volatile UINT16 MEM_28FCL;
        volatile UINT16 MEM_28FCH;
        volatile UINT16 MEM_2900L;
        volatile UINT16 MEM_2900H;
        volatile UINT16 MEM_2904L;
        volatile UINT16 MEM_2904H;
        volatile UINT16 MEM_2908L;
        volatile UINT16 MEM_2908H;
        volatile UINT16 MEM_290CL;
        volatile UINT16 MEM_290CH;
        volatile UINT16 MEM_2910L;
        volatile UINT16 MEM_2910H;
        volatile UINT16 MEM_2914L;
        volatile UINT16 MEM_2914H;
        volatile UINT16 MEM_2918L;
        volatile UINT16 MEM_2918H;
        volatile UINT16 MEM_291CL;
        volatile UINT16 MEM_291CH;
        volatile UINT16 MEM_2920L;
        volatile UINT16 MEM_2920H;
        volatile UINT16 MEM_2924L;
        volatile UINT16 MEM_2924H;
        volatile UINT16 MEM_2928L;
        volatile UINT16 MEM_2928H;
        volatile UINT16 MEM_292CL;
        volatile UINT16 MEM_292CH;
        volatile UINT16 MEM_2930L;
        volatile UINT16 MEM_2930H;
        volatile UINT16 MEM_2934L;
        volatile UINT16 MEM_2934H;
        volatile UINT16 MEM_2938L;
        volatile UINT16 MEM_2938H;
        volatile UINT16 MEM_293CL;
        volatile UINT16 MEM_293CH;
        volatile UINT16 MEM_2940L;
        volatile UINT16 MEM_2940H;
        volatile UINT16 MEM_2944L;
        volatile UINT16 MEM_2944H;
        volatile UINT16 MEM_2948L;
        volatile UINT16 MEM_2948H;
        volatile UINT16 MEM_294CL;
        volatile UINT16 MEM_294CH;
        volatile UINT16 MEM_2950L;
        volatile UINT16 MEM_2950H;
        volatile UINT16 MEM_2954L;
        volatile UINT16 MEM_2954H;
        volatile UINT16 MEM_2958L;
        volatile UINT16 MEM_2958H;
        volatile UINT16 MEM_295CL;
        volatile UINT16 MEM_295CH;
        volatile UINT16 MEM_2960L;
        volatile UINT16 MEM_2960H;
        volatile UINT16 MEM_2964L;
        volatile UINT16 MEM_2964H;
        volatile UINT16 MEM_2968L;
        volatile UINT16 MEM_2968H;
        volatile UINT16 MEM_296CL;
        volatile UINT16 MEM_296CH;
        volatile UINT16 MEM_2970L;
        volatile UINT16 MEM_2970H;
        volatile UINT16 MEM_2974L;
        volatile UINT16 MEM_2974H;
        volatile UINT16 MEM_2978L;
        volatile UINT16 MEM_2978H;
        volatile UINT16 MEM_297CL;
        volatile UINT16 MEM_297CH;
        volatile UINT16 MEM_2980L;
        volatile UINT16 MEM_2980H;
        volatile UINT16 MEM_2984L;
        volatile UINT16 MEM_2984H;
        volatile UINT16 MEM_2988L;
        volatile UINT16 MEM_2988H;
        volatile UINT16 MEM_298CL;
        volatile UINT16 MEM_298CH;
        volatile UINT16 MEM_2990L;
        volatile UINT16 MEM_2990H;
        volatile UINT16 MEM_2994L;
        volatile UINT16 MEM_2994H;
        volatile UINT16 MEM_2998L;
        volatile UINT16 MEM_2998H;
        volatile UINT16 MEM_299CL;
        volatile UINT16 MEM_299CH;
        volatile UINT16 MEM_29A0L;
        volatile UINT16 MEM_29A0H;
        volatile UINT16 MEM_29A4L;
        volatile UINT16 MEM_29A4H;
        volatile UINT16 MEM_29A8L;
        volatile UINT16 MEM_29A8H;
        volatile UINT16 MEM_29ACL;
        volatile UINT16 MEM_29ACH;
        volatile UINT16 MEM_29B0L;
        volatile UINT16 MEM_29B0H;
        volatile UINT16 MEM_29B4L;
        volatile UINT16 MEM_29B4H;
        volatile UINT16 MEM_29B8L;
        volatile UINT16 MEM_29B8H;
        volatile UINT16 MEM_29BCL;
        volatile UINT16 MEM_29BCH;
        volatile UINT16 MEM_29C0L;
        volatile UINT16 MEM_29C0H;
        volatile UINT16 MEM_29C4L;
        volatile UINT16 MEM_29C4H;
        volatile UINT16 MEM_29C8L;
        volatile UINT16 MEM_29C8H;
        volatile UINT16 MEM_29CCL;
        volatile UINT16 MEM_29CCH;
        volatile UINT16 MEM_29D0L;
        volatile UINT16 MEM_29D0H;
        volatile UINT16 MEM_29D4L;
        volatile UINT16 MEM_29D4H;
        volatile UINT16 MEM_29D8L;
        volatile UINT16 MEM_29D8H;
        volatile UINT16 MEM_29DCL;
        volatile UINT16 MEM_29DCH;
        volatile UINT16 MEM_29E0L;
        volatile UINT16 MEM_29E0H;
        volatile UINT16 MEM_29E4L;
        volatile UINT16 MEM_29E4H;
        volatile UINT16 MEM_29E8L;
        volatile UINT16 MEM_29E8H;
        volatile UINT16 MEM_29ECL;
        volatile UINT16 MEM_29ECH;
        volatile UINT16 MEM_29F0L;
        volatile UINT16 MEM_29F0H;
        volatile UINT16 MEM_29F4L;
        volatile UINT16 MEM_29F4H;
        volatile UINT16 MEM_29F8L;
        volatile UINT16 MEM_29F8H;
        volatile UINT16 MEM_29FCL;
        volatile UINT16 MEM_29FCH;
        volatile UINT16 MEM_2A00L;
        volatile UINT16 MEM_2A00H;
        volatile UINT16 MEM_2A04L;
        volatile UINT16 MEM_2A04H;
        volatile UINT16 MEM_2A08L;
        volatile UINT16 MEM_2A08H;
        volatile UINT16 MEM_2A0CL;
        volatile UINT16 MEM_2A0CH;
        volatile UINT16 MEM_2A10L;
        volatile UINT16 MEM_2A10H;
        volatile UINT16 MEM_2A14L;
        volatile UINT16 MEM_2A14H;
        volatile UINT16 MEM_2A18L;
        volatile UINT16 MEM_2A18H;
        volatile UINT16 MEM_2A1CL;
        volatile UINT16 MEM_2A1CH;
        volatile UINT16 MEM_2A20L;
        volatile UINT16 MEM_2A20H;
        volatile UINT16 MEM_2A24L;
        volatile UINT16 MEM_2A24H;
        volatile UINT16 MEM_2A28L;
        volatile UINT16 MEM_2A28H;
        volatile UINT16 MEM_2A2CL;
        volatile UINT16 MEM_2A2CH;
        volatile UINT16 MEM_2A30L;
        volatile UINT16 MEM_2A30H;
        volatile UINT16 MEM_2A34L;
        volatile UINT16 MEM_2A34H;
        volatile UINT16 MEM_2A38L;
        volatile UINT16 MEM_2A38H;
        volatile UINT16 MEM_2A3CL;
        volatile UINT16 MEM_2A3CH;
        volatile UINT16 MEM_2A40L;
        volatile UINT16 MEM_2A40H;
        volatile UINT16 MEM_2A44L;
        volatile UINT16 MEM_2A44H;
        volatile UINT16 MEM_2A48L;
        volatile UINT16 MEM_2A48H;
        volatile UINT16 MEM_2A4CL;
        volatile UINT16 MEM_2A4CH;
        volatile UINT16 MEM_2A50L;
        volatile UINT16 MEM_2A50H;
        volatile UINT16 MEM_2A54L;
        volatile UINT16 MEM_2A54H;
        volatile UINT16 MEM_2A58L;
        volatile UINT16 MEM_2A58H;
        volatile UINT16 MEM_2A5CL;
        volatile UINT16 MEM_2A5CH;
        volatile UINT16 MEM_2A60L;
        volatile UINT16 MEM_2A60H;
        volatile UINT16 MEM_2A64L;
        volatile UINT16 MEM_2A64H;
        volatile UINT16 MEM_2A68L;
        volatile UINT16 MEM_2A68H;
        volatile UINT16 MEM_2A6CL;
        volatile UINT16 MEM_2A6CH;
        volatile UINT16 MEM_2A70L;
        volatile UINT16 MEM_2A70H;
        volatile UINT16 MEM_2A74L;
        volatile UINT16 MEM_2A74H;
        volatile UINT16 MEM_2A78L;
        volatile UINT16 MEM_2A78H;
        volatile UINT16 MEM_2A7CL;
        volatile UINT16 MEM_2A7CH;
        volatile UINT16 MEM_2A80L;
        volatile UINT16 MEM_2A80H;
        volatile UINT16 MEM_2A84L;
        volatile UINT16 MEM_2A84H;
        volatile UINT16 MEM_2A88L;
        volatile UINT16 MEM_2A88H;
        volatile UINT16 MEM_2A8CL;
        volatile UINT16 MEM_2A8CH;
        volatile UINT16 MEM_2A90L;
        volatile UINT16 MEM_2A90H;
        volatile UINT16 MEM_2A94L;
        volatile UINT16 MEM_2A94H;
        volatile UINT16 MEM_2A98L;
        volatile UINT16 MEM_2A98H;
        volatile UINT16 MEM_2A9CL;
        volatile UINT16 MEM_2A9CH;
        volatile UINT16 MEM_2AA0L;
        volatile UINT16 MEM_2AA0H;
        volatile UINT16 MEM_2AA4L;
        volatile UINT16 MEM_2AA4H;
        volatile UINT16 MEM_2AA8L;
        volatile UINT16 MEM_2AA8H;
        volatile UINT16 MEM_2AACL;
        volatile UINT16 MEM_2AACH;
        volatile UINT16 MEM_2AB0L;
        volatile UINT16 MEM_2AB0H;
        volatile UINT16 MEM_2AB4L;
        volatile UINT16 MEM_2AB4H;
        volatile UINT16 MEM_2AB8L;
        volatile UINT16 MEM_2AB8H;
        volatile UINT16 MEM_2ABCL;
        volatile UINT16 MEM_2ABCH;
        volatile UINT16 MEM_2AC0L;
        volatile UINT16 MEM_2AC0H;
        volatile UINT16 MEM_2AC4L;
        volatile UINT16 MEM_2AC4H;
        volatile UINT16 MEM_2AC8L;
        volatile UINT16 MEM_2AC8H;
        volatile UINT16 MEM_2ACCL;
        volatile UINT16 MEM_2ACCH;
        volatile UINT16 MEM_2AD0L;
        volatile UINT16 MEM_2AD0H;
        volatile UINT16 MEM_2AD4L;
        volatile UINT16 MEM_2AD4H;
        volatile UINT16 MEM_2AD8L;
        volatile UINT16 MEM_2AD8H;
        volatile UINT16 MEM_2ADCL;
        volatile UINT16 MEM_2ADCH;
        volatile UINT16 MEM_2AE0L;
        volatile UINT16 MEM_2AE0H;
        volatile UINT16 MEM_2AE4L;
        volatile UINT16 MEM_2AE4H;
        volatile UINT16 MEM_2AE8L;
        volatile UINT16 MEM_2AE8H;
        volatile UINT16 MEM_2AECL;
        volatile UINT16 MEM_2AECH;
        volatile UINT16 MEM_2AF0L;
        volatile UINT16 MEM_2AF0H;
        volatile UINT16 MEM_2AF4L;
        volatile UINT16 MEM_2AF4H;
        volatile UINT16 MEM_2AF8L;
        volatile UINT16 MEM_2AF8H;
        volatile UINT16 MEM_2AFCL;
        volatile UINT16 MEM_2AFCH;
        volatile UINT16 MEM_2B00L;
        volatile UINT16 MEM_2B00H;
        volatile UINT16 MEM_2B04L;
        volatile UINT16 MEM_2B04H;
        volatile UINT16 MEM_2B08L;
        volatile UINT16 MEM_2B08H;
        volatile UINT16 MEM_2B0CL;
        volatile UINT16 MEM_2B0CH;
        volatile UINT16 MEM_2B10L;
        volatile UINT16 MEM_2B10H;
        volatile UINT16 MEM_2B14L;
        volatile UINT16 MEM_2B14H;
        volatile UINT16 MEM_2B18L;
        volatile UINT16 MEM_2B18H;
        volatile UINT16 MEM_2B1CL;
        volatile UINT16 MEM_2B1CH;
        volatile UINT16 MEM_2B20L;
        volatile UINT16 MEM_2B20H;
        volatile UINT16 MEM_2B24L;
        volatile UINT16 MEM_2B24H;
        volatile UINT16 MEM_2B28L;
        volatile UINT16 MEM_2B28H;
        volatile UINT16 MEM_2B2CL;
        volatile UINT16 MEM_2B2CH;
        volatile UINT16 MEM_2B30L;
        volatile UINT16 MEM_2B30H;
        volatile UINT16 MEM_2B34L;
        volatile UINT16 MEM_2B34H;
        volatile UINT16 MEM_2B38L;
        volatile UINT16 MEM_2B38H;
        volatile UINT16 MEM_2B3CL;
        volatile UINT16 MEM_2B3CH;
        volatile UINT16 MEM_2B40L;
        volatile UINT16 MEM_2B40H;
        volatile UINT16 MEM_2B44L;
        volatile UINT16 MEM_2B44H;
        volatile UINT16 MEM_2B48L;
        volatile UINT16 MEM_2B48H;
        volatile UINT16 MEM_2B4CL;
        volatile UINT16 MEM_2B4CH;
        volatile UINT16 MEM_2B50L;
        volatile UINT16 MEM_2B50H;
        volatile UINT16 MEM_2B54L;
        volatile UINT16 MEM_2B54H;
        volatile UINT16 MEM_2B58L;
        volatile UINT16 MEM_2B58H;
        volatile UINT16 MEM_2B5CL;
        volatile UINT16 MEM_2B5CH;
        volatile UINT16 MEM_2B60L;
        volatile UINT16 MEM_2B60H;
        volatile UINT16 MEM_2B64L;
        volatile UINT16 MEM_2B64H;
        volatile UINT16 MEM_2B68L;
        volatile UINT16 MEM_2B68H;
        volatile UINT16 MEM_2B6CL;
        volatile UINT16 MEM_2B6CH;
        volatile UINT16 MEM_2B70L;
        volatile UINT16 MEM_2B70H;
        volatile UINT16 MEM_2B74L;
        volatile UINT16 MEM_2B74H;
        volatile UINT16 MEM_2B78L;
        volatile UINT16 MEM_2B78H;
        volatile UINT16 MEM_2B7CL;
        volatile UINT16 MEM_2B7CH;
        volatile UINT16 MEM_2B80L;
        volatile UINT16 MEM_2B80H;
        volatile UINT16 MEM_2B84L;
        volatile UINT16 MEM_2B84H;
        volatile UINT16 MEM_2B88L;
        volatile UINT16 MEM_2B88H;
        volatile UINT16 MEM_2B8CL;
        volatile UINT16 MEM_2B8CH;
        volatile UINT16 MEM_2B90L;
        volatile UINT16 MEM_2B90H;
        volatile UINT16 MEM_2B94L;
        volatile UINT16 MEM_2B94H;
        volatile UINT16 MEM_2B98L;
        volatile UINT16 MEM_2B98H;
        volatile UINT16 MEM_2B9CL;
        volatile UINT16 MEM_2B9CH;
        volatile UINT16 MEM_2BA0L;
        volatile UINT16 MEM_2BA0H;
        volatile UINT16 MEM_2BA4L;
        volatile UINT16 MEM_2BA4H;
        volatile UINT16 MEM_2BA8L;
        volatile UINT16 MEM_2BA8H;
        volatile UINT16 MEM_2BACL;
        volatile UINT16 MEM_2BACH;
        volatile UINT16 MEM_2BB0L;
        volatile UINT16 MEM_2BB0H;
        volatile UINT16 MEM_2BB4L;
        volatile UINT16 MEM_2BB4H;
        volatile UINT16 MEM_2BB8L;
        volatile UINT16 MEM_2BB8H;
        volatile UINT16 MEM_2BBCL;
        volatile UINT16 MEM_2BBCH;
        volatile UINT16 MEM_2BC0L;
        volatile UINT16 MEM_2BC0H;
        volatile UINT16 MEM_2BC4L;
        volatile UINT16 MEM_2BC4H;
        volatile UINT16 MEM_2BC8L;
        volatile UINT16 MEM_2BC8H;
        volatile UINT16 MEM_2BCCL;
        volatile UINT16 MEM_2BCCH;
        volatile UINT16 MEM_2BD0L;
        volatile UINT16 MEM_2BD0H;
        volatile UINT16 MEM_2BD4L;
        volatile UINT16 MEM_2BD4H;
        volatile UINT16 MEM_2BD8L;
        volatile UINT16 MEM_2BD8H;
        volatile UINT16 MEM_2BDCL;
        volatile UINT16 MEM_2BDCH;
        volatile UINT16 MEM_2BE0L;
        volatile UINT16 MEM_2BE0H;
        volatile UINT16 MEM_2BE4L;
        volatile UINT16 MEM_2BE4H;
        volatile UINT16 MEM_2BE8L;
        volatile UINT16 MEM_2BE8H;
        volatile UINT16 MEM_2BECL;
        volatile UINT16 MEM_2BECH;
        volatile UINT16 MEM_2BF0L;
        volatile UINT16 MEM_2BF0H;
        volatile UINT16 MEM_2BF4L;
        volatile UINT16 MEM_2BF4H;
        volatile UINT16 MEM_2BF8L;
        volatile UINT16 MEM_2BF8H;
        volatile UINT16 MEM_2BFCL;
        volatile UINT16 MEM_2BFCH;
        volatile UINT16 MEM_2C00L;
        volatile UINT16 MEM_2C00H;
        volatile UINT16 MEM_2C04L;
        volatile UINT16 MEM_2C04H;
        volatile UINT16 MEM_2C08L;
        volatile UINT16 MEM_2C08H;
        volatile UINT16 MEM_2C0CL;
        volatile UINT16 MEM_2C0CH;
        volatile UINT16 MEM_2C10L;
        volatile UINT16 MEM_2C10H;
        volatile UINT16 MEM_2C14L;
        volatile UINT16 MEM_2C14H;
        volatile UINT16 MEM_2C18L;
        volatile UINT16 MEM_2C18H;
        volatile UINT16 MEM_2C1CL;
        volatile UINT16 MEM_2C1CH;
        volatile UINT16 MEM_2C20L;
        volatile UINT16 MEM_2C20H;
        volatile UINT16 MEM_2C24L;
        volatile UINT16 MEM_2C24H;
        volatile UINT16 MEM_2C28L;
        volatile UINT16 MEM_2C28H;
        volatile UINT16 MEM_2C2CL;
        volatile UINT16 MEM_2C2CH;
        volatile UINT16 MEM_2C30L;
        volatile UINT16 MEM_2C30H;
        volatile UINT16 MEM_2C34L;
        volatile UINT16 MEM_2C34H;
        volatile UINT16 MEM_2C38L;
        volatile UINT16 MEM_2C38H;
        volatile UINT16 MEM_2C3CL;
        volatile UINT16 MEM_2C3CH;
        volatile UINT16 MEM_2C40L;
        volatile UINT16 MEM_2C40H;
        volatile UINT16 MEM_2C44L;
        volatile UINT16 MEM_2C44H;
        volatile UINT16 MEM_2C48L;
        volatile UINT16 MEM_2C48H;
        volatile UINT16 MEM_2C4CL;
        volatile UINT16 MEM_2C4CH;
        volatile UINT16 MEM_2C50L;
        volatile UINT16 MEM_2C50H;
        volatile UINT16 MEM_2C54L;
        volatile UINT16 MEM_2C54H;
        volatile UINT16 MEM_2C58L;
        volatile UINT16 MEM_2C58H;
        volatile UINT16 MEM_2C5CL;
        volatile UINT16 MEM_2C5CH;
        volatile UINT16 MEM_2C60L;
        volatile UINT16 MEM_2C60H;
        volatile UINT16 MEM_2C64L;
        volatile UINT16 MEM_2C64H;
        volatile UINT16 MEM_2C68L;
        volatile UINT16 MEM_2C68H;
        volatile UINT16 MEM_2C6CL;
        volatile UINT16 MEM_2C6CH;
        volatile UINT16 MEM_2C70L;
        volatile UINT16 MEM_2C70H;
        volatile UINT16 MEM_2C74L;
        volatile UINT16 MEM_2C74H;
        volatile UINT16 MEM_2C78L;
        volatile UINT16 MEM_2C78H;
        volatile UINT16 MEM_2C7CL;
        volatile UINT16 MEM_2C7CH;
        volatile UINT16 MEM_2C80L;
        volatile UINT16 MEM_2C80H;
        volatile UINT16 MEM_2C84L;
        volatile UINT16 MEM_2C84H;
        volatile UINT16 MEM_2C88L;
        volatile UINT16 MEM_2C88H;
        volatile UINT16 MEM_2C8CL;
        volatile UINT16 MEM_2C8CH;
        volatile UINT16 MEM_2C90L;
        volatile UINT16 MEM_2C90H;
        volatile UINT16 MEM_2C94L;
        volatile UINT16 MEM_2C94H;
        volatile UINT16 MEM_2C98L;
        volatile UINT16 MEM_2C98H;
        volatile UINT16 MEM_2C9CL;
        volatile UINT16 MEM_2C9CH;
        volatile UINT16 MEM_2CA0L;
        volatile UINT16 MEM_2CA0H;
        volatile UINT16 MEM_2CA4L;
        volatile UINT16 MEM_2CA4H;
        volatile UINT16 MEM_2CA8L;
        volatile UINT16 MEM_2CA8H;
        volatile UINT16 MEM_2CACL;
        volatile UINT16 MEM_2CACH;
        volatile UINT16 MEM_2CB0L;
        volatile UINT16 MEM_2CB0H;
        volatile UINT16 MEM_2CB4L;
        volatile UINT16 MEM_2CB4H;
        volatile UINT16 MEM_2CB8L;
        volatile UINT16 MEM_2CB8H;
        volatile UINT16 MEM_2CBCL;
        volatile UINT16 MEM_2CBCH;
        volatile UINT16 MEM_2CC0L;
        volatile UINT16 MEM_2CC0H;
        volatile UINT16 MEM_2CC4L;
        volatile UINT16 MEM_2CC4H;
        volatile UINT16 MEM_2CC8L;
        volatile UINT16 MEM_2CC8H;
        volatile UINT16 MEM_2CCCL;
        volatile UINT16 MEM_2CCCH;
        volatile UINT16 MEM_2CD0L;
        volatile UINT16 MEM_2CD0H;
        volatile UINT16 MEM_2CD4L;
        volatile UINT16 MEM_2CD4H;
        volatile UINT16 MEM_2CD8L;
        volatile UINT16 MEM_2CD8H;
        volatile UINT16 MEM_2CDCL;
        volatile UINT16 MEM_2CDCH;
        volatile UINT16 MEM_2CE0L;
        volatile UINT16 MEM_2CE0H;
        volatile UINT16 MEM_2CE4L;
        volatile UINT16 MEM_2CE4H;
        volatile UINT16 MEM_2CE8L;
        volatile UINT16 MEM_2CE8H;
        volatile UINT16 MEM_2CECL;
        volatile UINT16 MEM_2CECH;
        volatile UINT16 MEM_2CF0L;
        volatile UINT16 MEM_2CF0H;
        volatile UINT16 MEM_2CF4L;
        volatile UINT16 MEM_2CF4H;
        volatile UINT16 MEM_2CF8L;
        volatile UINT16 MEM_2CF8H;
        volatile UINT16 MEM_2CFCL;
        volatile UINT16 MEM_2CFCH;
        volatile UINT16 MEM_2D00L;
        volatile UINT16 MEM_2D00H;
        volatile UINT16 MEM_2D04L;
        volatile UINT16 MEM_2D04H;
        volatile UINT16 MEM_2D08L;
        volatile UINT16 MEM_2D08H;
        volatile UINT16 MEM_2D0CL;
        volatile UINT16 MEM_2D0CH;
        volatile UINT16 MEM_2D10L;
        volatile UINT16 MEM_2D10H;
        volatile UINT16 MEM_2D14L;
        volatile UINT16 MEM_2D14H;
        volatile UINT16 MEM_2D18L;
        volatile UINT16 MEM_2D18H;
        volatile UINT16 MEM_2D1CL;
        volatile UINT16 MEM_2D1CH;
        volatile UINT16 MEM_2D20L;
        volatile UINT16 MEM_2D20H;
        volatile UINT16 MEM_2D24L;
        volatile UINT16 MEM_2D24H;
        volatile UINT16 MEM_2D28L;
        volatile UINT16 MEM_2D28H;
        volatile UINT16 MEM_2D2CL;
        volatile UINT16 MEM_2D2CH;
        volatile UINT16 MEM_2D30L;
        volatile UINT16 MEM_2D30H;
        volatile UINT16 MEM_2D34L;
        volatile UINT16 MEM_2D34H;
        volatile UINT16 MEM_2D38L;
        volatile UINT16 MEM_2D38H;
        volatile UINT16 MEM_2D3CL;
        volatile UINT16 MEM_2D3CH;
        volatile UINT16 MEM_2D40L;
        volatile UINT16 MEM_2D40H;
        volatile UINT16 MEM_2D44L;
        volatile UINT16 MEM_2D44H;
        volatile UINT16 MEM_2D48L;
        volatile UINT16 MEM_2D48H;
        volatile UINT16 MEM_2D4CL;
        volatile UINT16 MEM_2D4CH;
        volatile UINT16 MEM_2D50L;
        volatile UINT16 MEM_2D50H;
        volatile UINT16 MEM_2D54L;
        volatile UINT16 MEM_2D54H;
        volatile UINT16 MEM_2D58L;
        volatile UINT16 MEM_2D58H;
        volatile UINT16 MEM_2D5CL;
        volatile UINT16 MEM_2D5CH;
        volatile UINT16 MEM_2D60L;
        volatile UINT16 MEM_2D60H;
        volatile UINT16 MEM_2D64L;
        volatile UINT16 MEM_2D64H;
        volatile UINT16 MEM_2D68L;
        volatile UINT16 MEM_2D68H;
        volatile UINT16 MEM_2D6CL;
        volatile UINT16 MEM_2D6CH;
        volatile UINT16 MEM_2D70L;
        volatile UINT16 MEM_2D70H;
        volatile UINT16 MEM_2D74L;
        volatile UINT16 MEM_2D74H;
        volatile UINT16 MEM_2D78L;
        volatile UINT16 MEM_2D78H;
        volatile UINT16 MEM_2D7CL;
        volatile UINT16 MEM_2D7CH;
        volatile UINT16 MEM_2D80L;
        volatile UINT16 MEM_2D80H;
        volatile UINT16 MEM_2D84L;
        volatile UINT16 MEM_2D84H;
        volatile UINT16 MEM_2D88L;
        volatile UINT16 MEM_2D88H;
        volatile UINT16 MEM_2D8CL;
        volatile UINT16 MEM_2D8CH;
        volatile UINT16 MEM_2D90L;
        volatile UINT16 MEM_2D90H;
        volatile UINT16 MEM_2D94L;
        volatile UINT16 MEM_2D94H;
        volatile UINT16 MEM_2D98L;
        volatile UINT16 MEM_2D98H;
        volatile UINT16 MEM_2D9CL;
        volatile UINT16 MEM_2D9CH;
        volatile UINT16 MEM_2DA0L;
        volatile UINT16 MEM_2DA0H;
        volatile UINT16 MEM_2DA4L;
        volatile UINT16 MEM_2DA4H;
        volatile UINT16 MEM_2DA8L;
        volatile UINT16 MEM_2DA8H;
        volatile UINT16 MEM_2DACL;
        volatile UINT16 MEM_2DACH;
        volatile UINT16 MEM_2DB0L;
        volatile UINT16 MEM_2DB0H;
        volatile UINT16 MEM_2DB4L;
        volatile UINT16 MEM_2DB4H;
        volatile UINT16 MEM_2DB8L;
        volatile UINT16 MEM_2DB8H;
        volatile UINT16 MEM_2DBCL;
        volatile UINT16 MEM_2DBCH;
        volatile UINT16 MEM_2DC0L;
        volatile UINT16 MEM_2DC0H;
        volatile UINT16 MEM_2DC4L;
        volatile UINT16 MEM_2DC4H;
        volatile UINT16 MEM_2DC8L;
        volatile UINT16 MEM_2DC8H;
        volatile UINT16 MEM_2DCCL;
        volatile UINT16 MEM_2DCCH;
        volatile UINT16 MEM_2DD0L;
        volatile UINT16 MEM_2DD0H;
        volatile UINT16 MEM_2DD4L;
        volatile UINT16 MEM_2DD4H;
        volatile UINT16 MEM_2DD8L;
        volatile UINT16 MEM_2DD8H;
        volatile UINT16 MEM_2DDCL;
        volatile UINT16 MEM_2DDCH;
        volatile UINT16 MEM_2DE0L;
        volatile UINT16 MEM_2DE0H;
        volatile UINT16 MEM_2DE4L;
        volatile UINT16 MEM_2DE4H;
        volatile UINT16 MEM_2DE8L;
        volatile UINT16 MEM_2DE8H;
        volatile UINT16 MEM_2DECL;
        volatile UINT16 MEM_2DECH;
        volatile UINT16 MEM_2DF0L;
        volatile UINT16 MEM_2DF0H;
        volatile UINT16 MEM_2DF4L;
        volatile UINT16 MEM_2DF4H;
        volatile UINT16 MEM_2DF8L;
        volatile UINT16 MEM_2DF8H;
        volatile UINT16 MEM_2DFCL;
        volatile UINT16 MEM_2DFCH;
        volatile UINT16 MEM_2E00L;
        volatile UINT16 MEM_2E00H;
        volatile UINT16 MEM_2E04L;
        volatile UINT16 MEM_2E04H;
        volatile UINT16 MEM_2E08L;
        volatile UINT16 MEM_2E08H;
        volatile UINT16 MEM_2E0CL;
        volatile UINT16 MEM_2E0CH;
        volatile UINT16 MEM_2E10L;
        volatile UINT16 MEM_2E10H;
        volatile UINT16 MEM_2E14L;
        volatile UINT16 MEM_2E14H;
        volatile UINT16 MEM_2E18L;
        volatile UINT16 MEM_2E18H;
        volatile UINT16 MEM_2E1CL;
        volatile UINT16 MEM_2E1CH;
        volatile UINT16 MEM_2E20L;
        volatile UINT16 MEM_2E20H;
        volatile UINT16 MEM_2E24L;
        volatile UINT16 MEM_2E24H;
        volatile UINT16 MEM_2E28L;
        volatile UINT16 MEM_2E28H;
        volatile UINT16 MEM_2E2CL;
        volatile UINT16 MEM_2E2CH;
        volatile UINT16 MEM_2E30L;
        volatile UINT16 MEM_2E30H;
        volatile UINT16 MEM_2E34L;
        volatile UINT16 MEM_2E34H;
        volatile UINT16 MEM_2E38L;
        volatile UINT16 MEM_2E38H;
        volatile UINT16 MEM_2E3CL;
        volatile UINT16 MEM_2E3CH;
        volatile UINT16 MEM_2E40L;
        volatile UINT16 MEM_2E40H;
        volatile UINT16 MEM_2E44L;
        volatile UINT16 MEM_2E44H;
        volatile UINT16 MEM_2E48L;
        volatile UINT16 MEM_2E48H;
        volatile UINT16 MEM_2E4CL;
        volatile UINT16 MEM_2E4CH;
        volatile UINT16 MEM_2E50L;
        volatile UINT16 MEM_2E50H;
        volatile UINT16 MEM_2E54L;
        volatile UINT16 MEM_2E54H;
        volatile UINT16 MEM_2E58L;
        volatile UINT16 MEM_2E58H;
        volatile UINT16 MEM_2E5CL;
        volatile UINT16 MEM_2E5CH;
        volatile UINT16 MEM_2E60L;
        volatile UINT16 MEM_2E60H;
        volatile UINT16 MEM_2E64L;
        volatile UINT16 MEM_2E64H;
        volatile UINT16 MEM_2E68L;
        volatile UINT16 MEM_2E68H;
        volatile UINT16 MEM_2E6CL;
        volatile UINT16 MEM_2E6CH;
        volatile UINT16 MEM_2E70L;
        volatile UINT16 MEM_2E70H;
        volatile UINT16 MEM_2E74L;
        volatile UINT16 MEM_2E74H;
        volatile UINT16 MEM_2E78L;
        volatile UINT16 MEM_2E78H;
        volatile UINT16 MEM_2E7CL;
        volatile UINT16 MEM_2E7CH;
        volatile UINT16 MEM_2E80L;
        volatile UINT16 MEM_2E80H;
        volatile UINT16 MEM_2E84L;
        volatile UINT16 MEM_2E84H;
        volatile UINT16 MEM_2E88L;
        volatile UINT16 MEM_2E88H;
        volatile UINT16 MEM_2E8CL;
        volatile UINT16 MEM_2E8CH;
        volatile UINT16 MEM_2E90L;
        volatile UINT16 MEM_2E90H;
        volatile UINT16 MEM_2E94L;
        volatile UINT16 MEM_2E94H;
        volatile UINT16 MEM_2E98L;
        volatile UINT16 MEM_2E98H;
        volatile UINT16 MEM_2E9CL;
        volatile UINT16 MEM_2E9CH;
        volatile UINT16 MEM_2EA0L;
        volatile UINT16 MEM_2EA0H;
        volatile UINT16 MEM_2EA4L;
        volatile UINT16 MEM_2EA4H;
        volatile UINT16 MEM_2EA8L;
        volatile UINT16 MEM_2EA8H;
        volatile UINT16 MEM_2EACL;
        volatile UINT16 MEM_2EACH;
        volatile UINT16 MEM_2EB0L;
        volatile UINT16 MEM_2EB0H;
        volatile UINT16 MEM_2EB4L;
        volatile UINT16 MEM_2EB4H;
        volatile UINT16 MEM_2EB8L;
        volatile UINT16 MEM_2EB8H;
        volatile UINT16 MEM_2EBCL;
        volatile UINT16 MEM_2EBCH;
        volatile UINT16 MEM_2EC0L;
        volatile UINT16 MEM_2EC0H;
        volatile UINT16 MEM_2EC4L;
        volatile UINT16 MEM_2EC4H;
        volatile UINT16 MEM_2EC8L;
        volatile UINT16 MEM_2EC8H;
        volatile UINT16 MEM_2ECCL;
        volatile UINT16 MEM_2ECCH;
        volatile UINT16 MEM_2ED0L;
        volatile UINT16 MEM_2ED0H;
        volatile UINT16 MEM_2ED4L;
        volatile UINT16 MEM_2ED4H;
        volatile UINT16 MEM_2ED8L;
        volatile UINT16 MEM_2ED8H;
        volatile UINT16 MEM_2EDCL;
        volatile UINT16 MEM_2EDCH;
        volatile UINT16 MEM_2EE0L;
        volatile UINT16 MEM_2EE0H;
        volatile UINT16 MEM_2EE4L;
        volatile UINT16 MEM_2EE4H;
        volatile UINT16 MEM_2EE8L;
        volatile UINT16 MEM_2EE8H;
        volatile UINT16 MEM_2EECL;
        volatile UINT16 MEM_2EECH;
        volatile UINT16 MEM_2EF0L;
        volatile UINT16 MEM_2EF0H;
        volatile UINT16 MEM_2EF4L;
        volatile UINT16 MEM_2EF4H;
        volatile UINT16 MEM_2EF8L;
        volatile UINT16 MEM_2EF8H;
        volatile UINT16 MEM_2EFCL;
        volatile UINT16 MEM_2EFCH;
        volatile UINT16 MEM_2F00L;
        volatile UINT16 MEM_2F00H;
        volatile UINT16 MEM_2F04L;
        volatile UINT16 MEM_2F04H;
        volatile UINT16 MEM_2F08L;
        volatile UINT16 MEM_2F08H;
        volatile UINT16 MEM_2F0CL;
        volatile UINT16 MEM_2F0CH;
        volatile UINT16 MEM_2F10L;
        volatile UINT16 MEM_2F10H;
        volatile UINT16 MEM_2F14L;
        volatile UINT16 MEM_2F14H;
        volatile UINT16 MEM_2F18L;
        volatile UINT16 MEM_2F18H;
        volatile UINT16 MEM_2F1CL;
        volatile UINT16 MEM_2F1CH;
        volatile UINT16 MEM_2F20L;
        volatile UINT16 MEM_2F20H;
        volatile UINT16 MEM_2F24L;
        volatile UINT16 MEM_2F24H;
        volatile UINT16 MEM_2F28L;
        volatile UINT16 MEM_2F28H;
        volatile UINT16 MEM_2F2CL;
        volatile UINT16 MEM_2F2CH;
        volatile UINT16 MEM_2F30L;
        volatile UINT16 MEM_2F30H;
        volatile UINT16 MEM_2F34L;
        volatile UINT16 MEM_2F34H;
        volatile UINT16 MEM_2F38L;
        volatile UINT16 MEM_2F38H;
        volatile UINT16 MEM_2F3CL;
        volatile UINT16 MEM_2F3CH;
        volatile UINT16 MEM_2F40L;
        volatile UINT16 MEM_2F40H;
        volatile UINT16 MEM_2F44L;
        volatile UINT16 MEM_2F44H;
        volatile UINT16 MEM_2F48L;
        volatile UINT16 MEM_2F48H;
        volatile UINT16 MEM_2F4CL;
        volatile UINT16 MEM_2F4CH;
        volatile UINT16 MEM_2F50L;
        volatile UINT16 MEM_2F50H;
        volatile UINT16 MEM_2F54L;
        volatile UINT16 MEM_2F54H;
        volatile UINT16 MEM_2F58L;
        volatile UINT16 MEM_2F58H;
        volatile UINT16 MEM_2F5CL;
        volatile UINT16 MEM_2F5CH;
        volatile UINT16 MEM_2F60L;
        volatile UINT16 MEM_2F60H;
        volatile UINT16 MEM_2F64L;
        volatile UINT16 MEM_2F64H;
        volatile UINT16 MEM_2F68L;
        volatile UINT16 MEM_2F68H;
        volatile UINT16 MEM_2F6CL;
        volatile UINT16 MEM_2F6CH;
        volatile UINT16 MEM_2F70L;
        volatile UINT16 MEM_2F70H;
        volatile UINT16 MEM_2F74L;
        volatile UINT16 MEM_2F74H;
        volatile UINT16 MEM_2F78L;
        volatile UINT16 MEM_2F78H;
        volatile UINT16 MEM_2F7CL;
        volatile UINT16 MEM_2F7CH;
        volatile UINT16 MEM_2F80L;
        volatile UINT16 MEM_2F80H;
        volatile UINT16 MEM_2F84L;
        volatile UINT16 MEM_2F84H;
        volatile UINT16 MEM_2F88L;
        volatile UINT16 MEM_2F88H;
        volatile UINT16 MEM_2F8CL;
        volatile UINT16 MEM_2F8CH;
        volatile UINT16 MEM_2F90L;
        volatile UINT16 MEM_2F90H;
        volatile UINT16 MEM_2F94L;
        volatile UINT16 MEM_2F94H;
        volatile UINT16 MEM_2F98L;
        volatile UINT16 MEM_2F98H;
        volatile UINT16 MEM_2F9CL;
        volatile UINT16 MEM_2F9CH;
        volatile UINT16 MEM_2FA0L;
        volatile UINT16 MEM_2FA0H;
        volatile UINT16 MEM_2FA4L;
        volatile UINT16 MEM_2FA4H;
        volatile UINT16 MEM_2FA8L;
        volatile UINT16 MEM_2FA8H;
        volatile UINT16 MEM_2FACL;
        volatile UINT16 MEM_2FACH;
        volatile UINT16 MEM_2FB0L;
        volatile UINT16 MEM_2FB0H;
        volatile UINT16 MEM_2FB4L;
        volatile UINT16 MEM_2FB4H;
        volatile UINT16 MEM_2FB8L;
        volatile UINT16 MEM_2FB8H;
        volatile UINT16 MEM_2FBCL;
        volatile UINT16 MEM_2FBCH;
        volatile UINT16 MEM_2FC0L;
        volatile UINT16 MEM_2FC0H;
        volatile UINT16 MEM_2FC4L;
        volatile UINT16 MEM_2FC4H;
        volatile UINT16 MEM_2FC8L;
        volatile UINT16 MEM_2FC8H;
        volatile UINT16 MEM_2FCCL;
        volatile UINT16 MEM_2FCCH;
        volatile UINT16 MEM_2FD0L;
        volatile UINT16 MEM_2FD0H;
        volatile UINT16 MEM_2FD4L;
        volatile UINT16 MEM_2FD4H;
        volatile UINT16 MEM_2FD8L;
        volatile UINT16 MEM_2FD8H;
        volatile UINT16 MEM_2FDCL;
        volatile UINT16 MEM_2FDCH;
        volatile UINT16 MEM_2FE0L;
        volatile UINT16 MEM_2FE0H;
        volatile UINT16 MEM_2FE4L;
        volatile UINT16 MEM_2FE4H;
        volatile UINT16 MEM_2FE8L;
        volatile UINT16 MEM_2FE8H;
        volatile UINT16 MEM_2FECL;
        volatile UINT16 MEM_2FECH;
        volatile UINT16 MEM_2FF0L;
        volatile UINT16 MEM_2FF0H;
        volatile UINT16 MEM_2FF4L;
        volatile UINT16 MEM_2FF4H;
        volatile UINT16 MEM_2FF8L;
        volatile UINT16 MEM_2FF8H;
        volatile UINT16 MEM_2FFCL;
        volatile UINT16 MEM_2FFCH;
} T_DRP_REGS_STR;

#if DRP_STANDALONE_BUILD
void drp_calib_main(void);
#endif // DRP_STANDALONE_BUILD

uint32 drp_copy_ref_sw_to_drpsrm(unsigned char *ref_sw_ptr);

#if ((DRP_TEST_SW && !DRP_BURNIN) || (!DRP_TEST_SW))
SINT16 drp_tx_rx_common_calib(
                               #if DRP_TEST_SW
                               UINT16 pcb_config,
                               #endif
                               T_DRP_SW_DATA *sw_data_ptr);
#endif

#if ((DRP_TEST_SW && (!DRP_BURNIN && !DRP_TDL_DFT)) || (!DRP_TEST_SW))
SINT16 drp_copy_sw_data_to_drpsrm(T_DRP_SW_DATA *drp_sw_data);
SINT16 drp_lna_cfreq_calib(UINT16 BAND_INDEX,
                           #if DRP_TEST_SW
                           UINT16 pcb_config,
                           #endif
                           T_DRP_SW_DATA *sw_data_ptr);

SINT16 drp_iqmc_calib(UINT16 BAND_INDEX,
                      #if DRP_TEST_SW
                      UINT16 pcb_config,
                      #endif
                      T_DRP_SW_DATA *sw_data_ptr);

SINT16 drp_iqmc_calib(UINT16 BAND_INDEX,
                      #if DRP_TEST_SW
                      UINT16 pcb_config,
                      #endif
                      T_DRP_SW_DATA *sw_data_ptr);

SINT16 drp_mixer_pole_calib(UINT16 BAND_INDEX,
                            #if DRP_TEST_SW
                            UINT16 pcb_config,
                            #endif
                            T_DRP_SW_DATA *sw_data_ptr);

SINT16 drp_scf_pole_calib(UINT16 BAND_INDEX,
                          #if DRP_TEST_SW
                          UINT16 pcb_config,
                          #endif
                          T_DRP_SW_DATA *sw_data_ptr);

SINT16 drp_afe_gain_calib1(UINT16 BAND_INDEX,
                           #if DRP_TEST_SW
                           UINT16 pcb_config,
                           #endif
                           T_DRP_SW_DATA *sw_data_ptr);

SINT16 drp_afe_gain_calib2(UINT16 BAND_INDEX,
                           #if DRP_TEST_SW
                           UINT16 pcb_config,
                           #endif
                           T_DRP_SW_DATA *sw_data_ptr);

void drp_efuse_update_deq(UINT16 deqSetting);

void drp_rx_fcw(UINT16 BAND_INDEX, UINT32 FCW_OFFSET);

void drp_api_addr_init(void);
UINT16 drp_tone_check(UINT16 band, UINT16 channel, UINT16 abe_gain_indx, UINT16 afe_gain_indx, T_DRP_SW_DATA *sw_data_ptr);
void drp_idac_optimize(T_DRP_SW_DATA *sw_data_ptr);
SINT16 drp_dcxo_calib(UINT16 BAND_INDEX,
                          #if DRP_TEST_SW
                          UINT16 pcb_config,
                          #endif
                        T_DRP_SW_DATA *sw_data_ptr);
void set_dcxo_cfa(UINT16 cfa);
SINT16 drp_dco_retiming_calibration(T_DRP_SW_DATA *sw_data_ptr);
SINT16 drp_dco_ibias_calibration(T_DRP_SW_DATA *sw_data_ptr);
UINT16 drp_generate_dbbif_setting(UINT16 pcb_config, UINT16 band_index);
UINT16 drp_generate_dbbif_setting_arfcn(UINT16 pcb_config, UINT16 arfcn);

#endif //#if ((DRP_TEST_SW && !DRP_BURNIN) || (!DRP_TEST_SW))

#endif // for __DRP_API__


