/*
+------------------------------------------------------------------------------
|  File:       mem.h
+------------------------------------------------------------------------------
|                 Copyright Condat AG 1999-2000, Berlin
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Condat AG.
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Condat AG.
+------------------------------------------------------------------------------
| Purpose:     Definitions for the entity MEM.
| $Identity:$
+------------------------------------------------------------------------------
*/

#ifndef MEM_H
#define MEM_H

/*==== INCLUDES ==============================================================*/

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "tools.h"

/*==== GENERATED CONTENT ======================================================*/

/*
+--------------------------------------------------------------------------+
| PROJECT : PROTOCOL STACK                                                 |
| FILE    : p_8010_112_mem_sap.val                                         |
| SOURCE  : "s:\g23m\condat\ms\DFILE\PRIM\8010_112_mem_sap.pdf"            |
| LastModified : "12 February, 2003 by Gert Z. Srensen (GSO)"              |
| IdAndVersion : "8010.112.02.002"                                         |
| SrcFileTime  : "Wed Nov 26 14:28:02 2003"                                |
| Generated by CCDGEN_2.4.11 on Tue Sep 21 10:40:12 2004                   |
|           !!DO NOT MODIFY!!DO NOT MODIFY!!DO NOT MODIFY!!                |
+--------------------------------------------------------------------------+
*/

/* PRAGMAS
 * PREFIX                 : MEM
 * COMPATIBILITY_DEFINES  : NO
 * ALWAYS_ENUM_IN_VAL_FILE: YES
 * ENABLE_GROUP: NO
 * CAPITALIZE_TYPENAME: NO
 */


#ifndef P_8010_112_MEM_SAP_VAL
#define P_8010_112_MEM_SAP_VAL


#define CDG_ENTER__P_8010_112_MEM_SAP_VAL

#define CDG_ENTER__FILENAME _P_8010_112_MEM_SAP_VAL
#define CDG_ENTER__P_8010_112_MEM_SAP_VAL__FILE_TYPE CDGINC
#define CDG_ENTER__P_8010_112_MEM_SAP_VAL__LAST_MODIFIED _12_February_2003_by_Gert_Z_Srensen_GSO
#define CDG_ENTER__P_8010_112_MEM_SAP_VAL__ID_AND_VERSION _8010_112_02_002

#define CDG_ENTER__P_8010_112_MEM_SAP_VAL__SRC_FILE_TIME _Wed_Nov_26_14_28_02_2003

#include "CDG_ENTER.h"

#undef CDG_ENTER__P_8010_112_MEM_SAP_VAL

#undef CDG_ENTER__FILENAME


/*
 * user defined constants
 */
#define MEM_MAX_NUMBER_OF_BUFFERS      (0x40)     
#define MEM_MAX_NUMBER_OF_USERS        (0x40)     
#define MEM_UNORDERED_BUFFER           (0x0)      
#define MEM_FIFO_BUFFER                (0x1)      
#define MEM_MAX_RAB_ID                 (0x10)     
#define MEM_MAX_MEMORY_POOL_SIZE       (0xffffff) 
#define MEM_INVALID_USER_HANDLE        (0x0)      
#define MEM_INVALID_BUFFER_HANDLE      (0x0)      
#define MEM_RLC_UL_AM_MODE             (0x0)      
#define MEM_RLC_UL_UM_MODE             (0x1)      
#define MEM_RLC_UL_TM_MODE             (0x2)      
#define MEM_INVALID_MEMORY_HANDLE      (0x0)      

#include "CDG_LEAVE.h"

#endif


/*
+--------------------------------------------------------------------------+
| PROJECT : PROTOCOL STACK                                                 |
| FILE    : p_8010_112_mem_sap.h                                           |
| SOURCE  : "s:\g23m\condat\ms\DFILE\PRIM\8010_112_mem_sap.pdf"            |
| LastModified : "12 February, 2003 by Gert Z. Srensen (GSO)"              |
| IdAndVersion : "8010.112.02.002"                                         |
| SrcFileTime  : "Wed Nov 26 14:28:02 2003"                                |
| Generated by CCDGEN_2.4.11 on Tue Sep 21 10:40:12 2004                   |
|           !!DO NOT MODIFY!!DO NOT MODIFY!!DO NOT MODIFY!!                |
+--------------------------------------------------------------------------+
*/

/* PRAGMAS
 * PREFIX                 : MEM
 * COMPATIBILITY_DEFINES  : NO
 * ALWAYS_ENUM_IN_VAL_FILE: YES
 * ENABLE_GROUP: NO
 * CAPITALIZE_TYPENAME: NO
 */


#ifndef P_8010_112_MEM_SAP_H
#define P_8010_112_MEM_SAP_H


#define CDG_ENTER__P_8010_112_MEM_SAP_H

#define CDG_ENTER__FILENAME _P_8010_112_MEM_SAP_H
#define CDG_ENTER__P_8010_112_MEM_SAP_H__FILE_TYPE CDGINC
#define CDG_ENTER__P_8010_112_MEM_SAP_H__LAST_MODIFIED _12_February_2003_by_Gert_Z_Srensen_GSO
#define CDG_ENTER__P_8010_112_MEM_SAP_H__ID_AND_VERSION _8010_112_02_002

#define CDG_ENTER__P_8010_112_MEM_SAP_H__SRC_FILE_TIME _Wed_Nov_26_14_28_02_2003

#include "CDG_ENTER.h"

#undef CDG_ENTER__P_8010_112_MEM_SAP_H

#undef CDG_ENTER__FILENAME


#ifndef __T_MEM_no_parms__
#define __T_MEM_no_parms__
/*
 * No parameters.
 * CCDGEN:WriteStruct_Count==14836
 */
typedef struct
{
  U8                        none;                     /*<  0:  1> No parameters                                      */
  U8                        zzz_align0;               /*<  1:  1> alignment                                          */
  U8                        zzz_align1;               /*<  2:  1> alignment                                          */
  U8                        zzz_align2;               /*<  3:  1> alignment                                          */
} T_MEM_no_parms;
#endif

#ifndef __T_MEM_uplink_buffer_users_info__
#define __T_MEM_uplink_buffer_users_info__
/*
 * No parameters.
 * CCDGEN:WriteStruct_Count==14839
 */
typedef struct
{
  U8                        rab_id;                   /*<  0:  1> Radio access identifier                            */
  U8                        rlc_mode;                 /*<  1:  1> RLC Mode                                           */
  U8                        zzz_align0;               /*<  2:  1> alignment                                          */
  U8                        zzz_align1;               /*<  3:  1> alignment                                          */
  U32                       bits_per_tti;             /*<  4:  4> Bits per TTI                                       */
  U16                       rlc_tx_window_size;       /*<  8:  2> RLC window size                                    */
  U8                        zzz_align2;               /*< 10:  1> alignment                                          */
  U8                        zzz_align3;               /*< 11:  1> alignment                                          */
} T_MEM_uplink_buffer_users_info;
#endif


/*
 * End of substructure section, begin of primitive definition section
 */

#ifndef __T_MEM_READY_IND__
#define __T_MEM_READY_IND__
/*
 * 
 * CCDGEN:WriteStruct_Count==14842
 */
typedef struct
{
  U8                        user_handle;              /*<  0:  1> User Handle                                        */
  U8                        user_parameter;           /*<  1:  1> User parameter                                     */
  U8                        zzz_align0;               /*<  2:  1> alignment                                          */
  U8                        zzz_align1;               /*<  3:  1> alignment                                          */
} T_MEM_READY_IND;
#endif

#ifndef __T_MEM_BUFFER__
#define __T_MEM_BUFFER__
/*
 * 
 * CCDGEN:WriteStruct_Count==14845
 */
typedef struct
{
  U32                       memory_pool_size;         /*<  0:  4> Memory pool size                                   */
  U32                       allocated;                /*<  4:  4> Parameter                                          */
  U8                        ordering;                 /*<  8:  1> Ordering                                           */
  U8                        delete_pending;           /*<  9:  1> Parameter                                          */
  U8                        zzz_align0;               /*< 10:  1> alignment                                          */
  U8                        zzz_align1;               /*< 11:  1> alignment                                          */
  U32                       max_allocated;            /*< 12:  4> Parameter                                          */
  U32                       fifo_read_index;          /*< 16:  4> Parameter                                          */
  U32                       fifo_write_index;         /*< 20:  4> Parameter                                          */
} T_MEM_BUFFER;
#endif


#include "CDG_LEAVE.h"


#endif


/*==== CONSTS ================================================================*/

#define MEM_READY_IND                  (0x8000408b)
#define MEM_BUFFER                     (0x8001408b)


#ifdef ENTITY_MEM

#define VSI_CALLER        mem_handle,
#define VSI_CALLER_SINGLE mem_handle

#endif

#define MEM_STATISTICS

#define MAX_UPLINK_USERS 11		/* Maximum number of uplink buffer users. Corresponds  */
								/* maxim number of available rab identifiers	 	   */	
#define MAX_RAB_ID 16	        /* Maximum  RAB identifier. Used in array declarations. 15+1  */
#define RAB_TRANSMIT_BUFFER_SIZE_BYTES 500000 /* Uplink buffer size */								
#define MAX_SDU_SIZE 1520


/*==== TYPES =================================================================*/

typedef struct
{
  T_HANDLE  comm_handle;     /* Communication handle to user                  */
  U8        user_parameter;  /* User defined parameter                        */
  U8        buffer_id;       /* Id of buffer used by this user                */

  U32       low;             /* Flow control low                              */
  U32       high;            /* Flow control high                             */
  U32       max;             /* Flow control max                              */
  U32       allocated;       /* Allocated number of octets                    */

#ifdef MEM_STATISTICS
  U32       max_allocated;   /* Max number of octets allocated by user        */
#endif /* STATISTICS */

  U16       space_before;		/* Extra space to allocate before user data      */
  U8        space_after;		/* Extra space to allocate after user data       */
  U8        ready;				/* TRUE if ready to receive data from this user  */
  U8        delete_pending;		/* TRUE if user is to be deleted when all freed  */

} T_MEM_USER;


typedef struct
{
  U8*  (*get_user_data) (U32 memory_handle, U16 *ptr_length);
  U8   (*create_user)   (U8 buffer_handle, U8 user_parameter,  char *task_name);
  U8   (*create_buffer) (U8 ordering, U32 memory_pool_size);
  U8*  (*alloc)         (U8 user_handle, U16 length, U32 *ptr_handle);
  void (*dealloc)       (U32 memory_handle);
  void (*delete_user)   (U8 user_handle);
  void (*delete_buffer) (U8 buffer_handle);
} T_MEM_PROPERTIES;

/*==== EXPORTS ===============================================================*/

#ifdef MEM_PEI_C

/* Task handle for MEM */
T_HANDLE      mem_handle;

/* Semaphore used to guarantee exclusive access at critical points */
T_HANDLE     mem_semaphore_handle;

/*T_MEM_BUFFER *mem_buffer[MEM_MAX_NUMBER_OF_BUFFERS];*/
T_MEM_USER   *mem_user[MEM_MAX_NUMBER_OF_USERS];

#else /* MEM_PEI_C */

extern T_HANDLE      mem_handle;
extern T_HANDLE      mem_semaphore_handle;
extern T_MEM_BUFFER *mem_buffer[MEM_MAX_NUMBER_OF_BUFFERS];
extern T_MEM_USER   *mem_user[MEM_MAX_NUMBER_OF_USERS];

#endif /* MEM_PEI_C */

extern U8 mem_create_buffer(U8 ordering, U32 memory_pool_size);
extern void mem_delete_buffer(U8 buffer_handle);
extern U8 mem_create_user(U8 buffer_handle, U8 user_parameter,  char *task_name);
extern void mem_init(void);
extern void mem_delete_user(U8  user_handle);
extern U8 mem_create_uplink_user(char* task_name, U8 mem_rab_id);
extern void  mem_delete_uplink_user(U8 user_handle);
extern void mem_adjust_uplink_users_flow_control(T_MEM_uplink_buffer_users_info *users_info[MEM_MAX_RAB_ID]);
extern void mem_configure_flow_control(U8 user_handle, U32 low, U32 high, U32 max);
extern void mem_configure_extra_space(U8 user_handle, U16  space_before, U8 space_after);
extern BOOL mem_ready(U8 user_handle);
extern U8 *mem_alloc(U8 user_handle, U16 length, U32 *ptr_handle);
extern void mem_dealloc(U32 memory_handle);
extern void mem_realloc(U32 memory_handle, U16 length);
extern U8 *mem_get_user_data(U32 memory_handle, U16 *ptr_length);
extern U16 mem_get_space_before(U32 memory_handle);
extern U8 mem_get_space_after(U32 memory_handle);
extern U8 *mem_decrease_space_before(U32 memory_handle, U16 delta_space_before, U16 *ptr_length);
extern void mem_increase_space_before(U32 memory_handle, U16 delta_space_before);
extern void mem_decrease_space_after(U32 memory_handle, U8 delta_space_after);
extern void mem_increase_space_after(U32 memory_handle, U8 delta_space_after);
extern void mem_send_ready_ind(T_HANDLE com_handle, U8 user_handle, U8 user_paramaeter);

#endif /* MEM_H */
